/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StringBuilder
implements Serializable,
CharSequence {
    private static final long serialVersionUID = 4383685877147921099L;
    private static final int DEFAULT_CAPACITY = 16;
    int count;
    char[] value;

    public final int length() {
        return this.count;
    }

    public final int capacity() {
        return this.value.length;
    }

    public final void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            int max = this.value.length * 2 + 2;
            minimumCapacity = minimumCapacity < max ? max : minimumCapacity;
            char[] nb = new char[minimumCapacity];
            System.arraycopy(this.value, 0, nb, 0, this.count);
            this.value = nb;
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void setLength(int newLength) {
        block2: {
            if (newLength < 0) {
                throw new StringIndexOutOfBoundsException(newLength);
            }
            valueLength = this.value.length;
            this.ensureCapacity(newLength);
            if (newLength >= valueLength) ** GOTO lbl9
            this.count = newLength;
            break block2;
lbl-1000:
            // 1 sources

            {
                this.value[this.count++] = '\u0000';
lbl9:
                // 2 sources

                ** while (this.count < newLength)
            }
        }
    }

    public final char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public final void getChars(int srcOffset, int srcEnd, char[] dst, int dstOffset) {
        if (srcOffset < 0 || srcEnd > this.count || srcEnd < srcOffset) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, srcOffset, dst, dstOffset, srcEnd - srcOffset);
    }

    public final void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.ensureCapacity(this.count);
        this.value[index] = ch;
    }

    public final StringBuilder append(Object obj) {
        return this.append(obj == null ? "null" : obj.toString());
    }

    public final StringBuilder append(String str) {
        if (str == null) {
            str = "null";
        }
        int len = str.count;
        this.ensureCapacity(this.count + len);
        str.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final StringBuilder append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.append("null");
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int len = stringBuffer.count;
            this.ensureCapacity(this.count + len);
            System.arraycopy(stringBuffer.value, 0, this.value, this.count, len);
            this.count += len;
            return this;
        }
    }

    public final StringBuilder append(char[] data) {
        return this.append(data, 0, data.length);
    }

    public final StringBuilder append(char[] data, int offset, int count) {
        if (offset < 0 || count < 0 || offset > data.length - count) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + count);
        System.arraycopy(data, offset, this.value, this.count, count);
        this.count += count;
        return this;
    }

    public final StringBuilder append(boolean bool) {
        return this.append(bool ? "true" : "false");
    }

    public final StringBuilder append(char ch) {
        this.ensureCapacity(this.count + 1);
        this.value[this.count++] = ch;
        return this;
    }

    public final StringBuilder append(CharSequence seq) {
        return this.append(seq, 0, seq.length());
    }

    public final StringBuilder append(CharSequence seq, int start, int end) {
        if (seq == null) {
            return this.append("null");
        }
        if (end - start > 0) {
            this.ensureCapacity(this.count + end - start);
            while (start < end) {
                this.value[this.count++] = seq.charAt(start);
                ++start;
            }
        }
        return this;
    }

    public final synchronized StringBuilder appendCodePoint(int code) {
        int len = Character.charCount(code);
        this.ensureCapacity(this.count + len);
        Character.toChars(code, this.value, this.count);
        this.count += len;
        return this;
    }

    public final StringBuilder append(int inum) {
        return this.append(String.valueOf(inum));
    }

    public final StringBuilder append(long lnum) {
        return this.append(Long.toString(lnum, 10));
    }

    public final StringBuilder append(float fnum) {
        return this.append(Float.toString(fnum));
    }

    public final StringBuilder append(double dnum) {
        return this.append(Double.toString(dnum));
    }

    public final StringBuilder delete(int start, int end) {
        if (start < 0 || start > this.count || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        this.ensureCapacity(this.count);
        if (this.count - end != 0) {
            System.arraycopy(this.value, end, this.value, start, this.count - end);
        }
        this.count -= end - start;
        return this;
    }

    public final StringBuilder deleteCharAt(int index) {
        return this.delete(index, index + 1);
    }

    public final StringBuilder replace(int start, int end, String str) {
        if (start < 0 || start > this.count || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        int len = str.count;
        int delta = len - (end > this.count ? this.count : end) + start;
        this.ensureCapacity(this.count + delta);
        if (delta != 0 && end < this.count) {
            System.arraycopy(this.value, end, this.value, end + delta, this.count - end);
        }
        str.getChars(0, len, this.value, start);
        this.count += delta;
        return this;
    }

    public final String substring(int beginIndex) {
        return this.substring(beginIndex, this.count);
    }

    public final CharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public final String substring(int beginIndex, int endIndex) {
        int len = endIndex - beginIndex;
        if (beginIndex < 0 || endIndex > this.count || endIndex < beginIndex) {
            throw new StringIndexOutOfBoundsException();
        }
        if (len == 0) {
            return "";
        }
        return new String(this.value, beginIndex, len);
    }

    public final StringBuilder insert(int offset, char[] str, int str_offset, int len) {
        if (offset < 0 || offset > this.count || len < 0 || str_offset < 0 || str_offset > str.length - len) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, str_offset, this.value, offset, len);
        this.count += len;
        return this;
    }

    public final StringBuilder insert(int offset, Object obj) {
        return this.insert(offset, obj == null ? "null" : obj.toString());
    }

    public final StringBuilder insert(int offset, String str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (str == null) {
            str = "null";
        }
        int len = str.count;
        this.ensureCapacity(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count += len;
        return this;
    }

    public final synchronized StringBuilder insert(int offset, CharSequence sequence) {
        if (sequence == null) {
            sequence = "null";
        }
        return this.insert(offset, sequence, 0, sequence.length());
    }

    public final synchronized StringBuilder insert(int offset, CharSequence sequence, int start, int end) {
        if (sequence == null) {
            sequence = "null";
        }
        if (start < 0 || end < 0 || start > end || end > sequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        int len = end - start;
        this.ensureCapacity(this.count + len);
        VMSystem.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        int i = start;
        while (i < end) {
            this.value[offset++] = sequence.charAt(i);
            ++i;
        }
        this.count += len;
        return this;
    }

    public final StringBuilder insert(int offset, char[] data) {
        return this.insert(offset, data, 0, data.length);
    }

    public final StringBuilder insert(int offset, boolean bool) {
        return this.insert(offset, bool ? "true" : "false");
    }

    public final StringBuilder insert(int offset, char ch) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = ch;
        ++this.count;
        return this;
    }

    public final StringBuilder insert(int offset, int inum) {
        return this.insert(offset, String.valueOf(inum));
    }

    public final StringBuilder insert(int offset, long lnum) {
        return this.insert(offset, Long.toString(lnum, 10));
    }

    public final StringBuilder insert(int offset, float fnum) {
        return this.insert(offset, Float.toString(fnum));
    }

    public final StringBuilder insert(int offset, double dnum) {
        return this.insert(offset, Double.toString(dnum));
    }

    public final int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public final int indexOf(String str, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int limit = this.count - str.count;
        while (fromIndex <= limit) {
            if (this.regionMatches(fromIndex, str)) {
                return fromIndex;
            }
            ++fromIndex;
        }
        return -1;
    }

    public final int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count - str.count);
    }

    public final int lastIndexOf(String str, int fromIndex) {
        fromIndex = Math.min(fromIndex, this.count - str.count);
        while (fromIndex >= 0) {
            if (this.regionMatches(fromIndex, str)) {
                return fromIndex;
            }
            --fromIndex;
        }
        return -1;
    }

    public final StringBuilder reverse() {
        this.ensureCapacity(this.count);
        int i = this.count >> 1;
        int j = this.count - i;
        while (--i >= 0) {
            char c = this.value[i];
            this.value[i] = this.value[j];
            this.value[j] = c;
            ++j;
        }
        return this;
    }

    public final String toString() {
        return new String(this);
    }

    private final boolean regionMatches(int toffset, String other) {
        int len = other.count;
        int index = other.offset;
        while (--len >= 0) {
            if (this.value[toffset++] == other.value[index++]) continue;
            return false;
        }
        return true;
    }

    public StringBuilder() {
        this(16);
    }

    public StringBuilder(int capacity) {
        this.value = new char[capacity];
    }

    public StringBuilder(String str) {
        this.count = str.count;
        this.value = new char[this.count + 16];
        str.getChars(0, this.count, this.value, 0);
    }

    public StringBuilder(CharSequence seq) {
        int len = seq.length();
        int n = 0;
        if (len > 0) {
            n = len;
        }
        this.count = n;
        this.value = new char[this.count + 16];
        int i = 0;
        while (i < len) {
            this.value[i] = seq.charAt(i);
            ++i;
        }
    }
}

