/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Long
extends Number
implements Comparable {
    private static final long serialVersionUID = 4290774380558885855L;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('J');
    public static final int SIZE = 64;
    private final long value;

    public static final String toString(long num, int radix) {
        if ((long)((int)num) == num) {
            return Integer.toString((int)num, radix);
        }
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        char[] buffer = new char[65];
        int i = 65;
        boolean isNeg = false;
        if (num < 0L) {
            isNeg = true;
            if ((num = -num) < 0L) {
                buffer[--i] = digits[(int)(-(num + (long)radix) % (long)radix)];
                num = -(num / (long)radix);
            }
        }
        do {
            buffer[--i] = digits[(int)(num % (long)radix)];
        } while ((num /= (long)radix) > 0L);
        if (isNeg) {
            buffer[--i] = 45;
        }
        return new String(buffer, i, 65 - i, true);
    }

    public static final String toHexString(long l) {
        return Long.toUnsignedString(l, 4);
    }

    public static final String toOctalString(long l) {
        return Long.toUnsignedString(l, 3);
    }

    public static final String toBinaryString(long l) {
        return Long.toUnsignedString(l, 1);
    }

    public static final String toString(long num) {
        return Long.toString(num, 10);
    }

    public static final long parseLong(String str, int radix) {
        return Long.parseLong(str, radix, false);
    }

    public static final long parseLong(String s) {
        return Long.parseLong(s, 10, false);
    }

    public static final Long valueOf(String s, int radix) {
        return new Long(Long.parseLong(s, radix, false));
    }

    public static final Long valueOf(String s) {
        return new Long(Long.parseLong(s, 10, false));
    }

    public static final synchronized Long valueOf(long val) {
        return new Long(val);
    }

    public static final Long decode(String str) {
        return new Long(Long.parseLong(str, 10, true));
    }

    public final byte byteValue() {
        return (byte)this.value;
    }

    public final short shortValue() {
        return (short)this.value;
    }

    public final int intValue() {
        return (int)this.value;
    }

    public final long longValue() {
        return this.value;
    }

    public final float floatValue() {
        return this.value;
    }

    public final double doubleValue() {
        return this.value;
    }

    public final String toString() {
        return Long.toString(this.value, 10);
    }

    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public final boolean equals(Object obj) {
        boolean bl = false;
        if (obj instanceof Long && this.value == ((Long)obj).value) {
            bl = true;
        }
        return bl;
    }

    public static final Long getLong(String nm) {
        return Long.getLong(nm, null);
    }

    public static final Long getLong(String nm, long val) {
        Long result = Long.getLong(nm, null);
        return result == null ? new Long(val) : result;
    }

    public static final Long getLong(String nm, Long def) {
        if (nm == null || "".equals(nm)) {
            return def;
        }
        if ((nm = System.getProperty(nm)) == null) {
            return def;
        }
        try {
            return Long.decode(nm);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public final int compareTo(Long l) {
        if (this.value == l.value) {
            return 0;
        }
        return this.value > l.value ? 1 : -1;
    }

    public final int compareTo(Object o) {
        return this.compareTo((Long)o);
    }

    public static final int bitCount(long x) {
        x = (x >> 1 & 0x5555555555555555L) + (x & 0x5555555555555555L);
        x = (x >> 2 & 0x3333333333333333L) + (x & 0x3333333333333333L);
        int v = (int)((x >>> 32) + x);
        v = (v >> 4 & 0xF0F0F0F) + (v & 0xF0F0F0F);
        v = (v >> 8 & 0xFF00FF) + (v & 0xFF00FF);
        return (v >> 16 & (char)-1) + (v & (char)-1);
    }

    public static final long rotateLeft(long x, int distance) {
        return x << distance | x >>> -distance;
    }

    public static final long rotateRight(long x, int distance) {
        return x << -distance | x >>> distance;
    }

    public static final long highestOneBit(long value) {
        value |= value >>> 1;
        value |= value >>> 2;
        value |= value >>> 4;
        value |= value >>> 8;
        value |= value >>> 16;
        value |= value >>> 32;
        return value ^ value >>> 1;
    }

    public static final int numberOfLeadingZeros(long value) {
        value |= value >>> 1;
        value |= value >>> 2;
        value |= value >>> 4;
        value |= value >>> 8;
        value |= value >>> 16;
        value |= value >>> 32;
        return Long.bitCount(value ^ -1L);
    }

    public static final long lowestOneBit(long value) {
        return value & -value;
    }

    public static final int numberOfTrailingZeros(long value) {
        return Long.bitCount((value & -value) - 1L);
    }

    public static final int signum(long x) {
        int n;
        if (x < 0L) {
            n = -1;
        } else {
            n = 0;
            if (x > 0L) {
                n = 1;
            }
        }
        return n;
    }

    public static final long reverseBytes(long val) {
        int hi = Integer.reverseBytes((int)val);
        int lo = Integer.reverseBytes((int)(val >>> 32));
        return (long)hi << 32 | (long)lo;
    }

    public static final long reverse(long val) {
        long hi = (long)Integer.reverse((int)val) & 0xFFFFFFFFL;
        long lo = (long)Integer.reverse((int)(val >>> 32)) & 0xFFFFFFFFL;
        return hi << 32 | lo;
    }

    private static final String toUnsignedString(long num, int exp) {
        if (num >= 0L && (long)((int)num) == num) {
            return Integer.toUnsignedString((int)num, exp);
        }
        int mask = (1 << exp) - 1;
        char[] buffer = new char[64];
        int i = 64;
        do {
            buffer[--i] = digits[(int)num & mask];
        } while ((num >>>= exp) != 0L);
        return new String(buffer, i, 64 - i, true);
    }

    private static final long parseLong(String str, int radix, boolean decode) {
        if (!decode && str == null) {
            throw new NumberFormatException();
        }
        int index = 0;
        int len = str.length();
        boolean isNeg = false;
        if (len == 0) {
            throw new NumberFormatException();
        }
        int ch = str.charAt(index);
        if (ch == 45) {
            if (len == 1) {
                throw new NumberFormatException();
            }
            isNeg = true;
            ch = str.charAt(++index);
        }
        if (decode) {
            if (ch == 48) {
                if (++index == len) {
                    return 0L;
                }
                if ((str.charAt(index) & 0xFFFFFFDF) == 88) {
                    radix = 16;
                    ++index;
                } else {
                    radix = 8;
                }
            } else if (ch == 35) {
                radix = 16;
                ++index;
            }
        }
        if (index == len) {
            throw new NumberFormatException();
        }
        long max = Long.MAX_VALUE / (long)radix;
        if (isNeg && Long.MAX_VALUE % (long)radix == (long)(radix - 1)) {
            ++max;
        }
        long val = 0L;
        while (index < len) {
            if (val < 0L || val > max) {
                throw new NumberFormatException();
            }
            ch = Character.digit(str.charAt(index++), radix);
            val = val * (long)radix + (long)ch;
            if (ch >= 0 && (val >= 0L || isNeg && val == Long.MIN_VALUE)) continue;
            throw new NumberFormatException();
        }
        return isNeg ? -val : val;
    }

    public Long(long value) {
        this.value = value;
    }

    public Long(String s) {
        this.value = Long.parseLong(s, 10, false);
    }
}

