/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;

public final class Buffers {
    public static final DataBuffer createBuffer(int dataType, Object data, int size) {
        if (data == null) {
            return Buffers.createBuffer(dataType, size, 1);
        }
        return Buffers.createBufferFromData(dataType, data, size);
    }

    public static final DataBuffer createBuffer(int dataType, int size) {
        return Buffers.createBuffer(dataType, size, 1);
    }

    public static final DataBuffer createBuffer(int dataType, int size, int numBanks) {
        switch (dataType) {
            case 0: {
                return new DataBufferByte(size, numBanks);
            }
            case 2: {
                return new DataBufferShort(size, numBanks);
            }
            case 1: {
                return new DataBufferUShort(size, numBanks);
            }
            case 3: {
                return new DataBufferInt(size, numBanks);
            }
            case 4: {
                return new DataBufferFloat(size, numBanks);
            }
            case 5: {
                return new DataBufferDouble(size, numBanks);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static final DataBuffer createBufferFromData(int dataType, Object data, int size) {
        switch (dataType) {
            case 0: {
                return new DataBufferByte((byte[])data, size);
            }
            case 2: {
                return new DataBufferShort((short[])data, size);
            }
            case 1: {
                return new DataBufferUShort((short[])data, size);
            }
            case 3: {
                return new DataBufferInt((int[])data, size);
            }
            case 4: {
                return new DataBufferFloat((float[])data, size);
            }
            case 5: {
                return new DataBufferDouble((double[])data, size);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static final Object getData(DataBuffer buffer) {
        if (buffer instanceof DataBufferByte) {
            return ((DataBufferByte)buffer).getData();
        }
        if (buffer instanceof DataBufferShort) {
            return ((DataBufferShort)buffer).getData();
        }
        if (buffer instanceof DataBufferUShort) {
            return ((DataBufferUShort)buffer).getData();
        }
        if (buffer instanceof DataBufferInt) {
            return ((DataBufferInt)buffer).getData();
        }
        if (buffer instanceof DataBufferFloat) {
            return ((DataBufferFloat)buffer).getData();
        }
        if (buffer instanceof DataBufferDouble) {
            return ((DataBufferDouble)buffer).getData();
        }
        throw new ClassCastException("Unknown data buffer type");
    }

    public static final Object getData(DataBuffer src, int srcOffset, Object dest, int destOffset, int length) {
        Object[] from;
        if (src instanceof DataBufferByte) {
            from = ((DataBufferByte)src).getData();
            if (dest == null) {
                dest = new byte[length + destOffset];
            }
        } else if (src instanceof DataBufferShort) {
            from = ((DataBufferShort)src).getData();
            if (dest == null) {
                dest = new short[length + destOffset];
            }
        } else if (src instanceof DataBufferUShort) {
            from = ((DataBufferUShort)src).getData();
            if (dest == null) {
                dest = new short[length + destOffset];
            }
        } else if (src instanceof DataBufferInt) {
            from = ((DataBufferInt)src).getData();
            if (dest == null) {
                dest = new int[length + destOffset];
            }
        } else if (src instanceof DataBufferFloat) {
            from = ((DataBufferFloat)src).getData();
            if (dest == null) {
                dest = new float[length + destOffset];
            }
        } else if (src instanceof DataBufferDouble) {
            from = ((DataBufferDouble)src).getData();
            if (dest == null) {
                dest = new double[length + destOffset];
            }
        } else {
            throw new ClassCastException("Unknown data buffer type");
        }
        System.arraycopy(from, srcOffset, dest, destOffset, length);
        return dest;
    }

    public static final int smallestAppropriateTransferType(int bits) {
        if (bits <= 8) {
            return 0;
        }
        if (bits <= 16) {
            return 1;
        }
        if (bits <= 32) {
            return 3;
        }
        return 32;
    }
}

