/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.InvalidFieldException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.MethodResult;
import gnu.classpath.jdwp.util.Value;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class ObjectReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeReferenceType(bb, os);
                    break;
                }
                case 2: {
                    this.executeGetValues(bb, os);
                    break;
                }
                case 3: {
                    this.executeSetValues(bb, os);
                    break;
                }
                case 5: {
                    this.executeMonitorInfo(bb, os);
                    break;
                }
                case 6: {
                    this.executeInvokeMethod(bb, os);
                    break;
                }
                case 7: {
                    this.executeDisableCollection(bb, os);
                    break;
                }
                case 8: {
                    this.executeEnableCollection(bb, os);
                    break;
                }
                case 9: {
                    this.executeIsCollected(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in ObjectReference Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private final void executeReferenceType(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        Object obj = oid.getObject();
        Class clazz = obj.getClass();
        ReferenceTypeId refId = this.idMan.getReferenceTypeId(clazz);
        refId.writeTagged(os);
    }

    private final void executeGetValues(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        Object obj = oid.getObject();
        int numFields = bb.getInt();
        os.writeInt(numFields);
        int i = 0;
        while (i < numFields) {
            Field field = (Field)this.idMan.readObjectId(bb).getObject();
            try {
                field.setAccessible(true);
                Object value = field.get(obj);
                Value.writeTaggedValue(os, value);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidFieldException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new JdwpInternalErrorException(ex);
            }
            ++i;
        }
    }

    private final void executeSetValues(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        Object obj = oid.getObject();
        int numFields = bb.getInt();
        int i = 0;
        while (i < numFields) {
            Field field = (Field)this.idMan.readObjectId(bb).getObject();
            Object value = Value.getUntaggedObj(bb, field.getType());
            try {
                field.setAccessible(true);
                field.set(obj, value);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidFieldException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new JdwpInternalErrorException(ex);
            }
            ++i;
        }
    }

    private final void executeMonitorInfo(ByteBuffer bb, DataOutputStream os) throws JdwpException {
        throw new NotImplementedException("Command ExecuteMonitorInfo not implemented.");
    }

    private final void executeInvokeMethod(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        boolean suspend;
        ObjectId oid = this.idMan.readObjectId(bb);
        Object obj = oid.getObject();
        ObjectId tid = this.idMan.readObjectId(bb);
        Thread thread = (Thread)tid.getObject();
        ReferenceTypeId rid = this.idMan.readReferenceTypeId(bb);
        Class clazz = rid.getType();
        ObjectId mid = this.idMan.readObjectId(bb);
        Method method = (Method)mid.getObject();
        int args = bb.getInt();
        Object[] values = new Object[args];
        int i = 0;
        while (i < args) {
            values[i] = Value.getObj(bb);
            ++i;
        }
        int invokeOptions = bb.getInt();
        boolean bl = false;
        if ((invokeOptions & 1) != 0) {
            bl = true;
        }
        if (suspend = bl) {
            VMVirtualMachine.suspendAllThreads();
        }
        boolean bl2 = false;
        if ((invokeOptions & 2) != 0) {
            bl2 = true;
        }
        boolean nonVirtual = bl2;
        MethodResult mr = VMVirtualMachine.executeMethod(obj, thread, clazz, method, values, nonVirtual);
        Object value = mr.getReturnedValue();
        Exception exception = mr.getThrownException();
        ObjectId eId = this.idMan.getObjectId(exception);
        Value.writeTaggedValue(os, value);
        eId.writeTagged(os);
    }

    private final void executeDisableCollection(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        oid.disableCollection();
    }

    private final void executeEnableCollection(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        oid.enableCollection();
    }

    private final void executeIsCollected(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        boolean bl = false;
        if (oid.getReference().get() == null) {
            bl = true;
        }
        boolean collected = bl;
        os.writeBoolean(collected);
    }
}

