// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"regexp"
	"strconv"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/helper/schema"
	"github.com/hashicorp/terraform-plugin-sdk/helper/validation"
	"google.golang.org/api/googleapi"
)

var (
	bigqueryDatasetRegexp = regexp.MustCompile("projects/(.+)/datasets/(.+)")
	bigqueryTableRegexp   = regexp.MustCompile("projects/(.+)/datasets/(.+)/tables/(.+)")
)

func resourceBigQueryJob() *schema.Resource {
	return &schema.Resource{
		Create: resourceBigQueryJobCreate,
		Read:   resourceBigQueryJobRead,
		Delete: resourceBigQueryJobDelete,

		Importer: &schema.ResourceImporter{
			State: resourceBigQueryJobImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(4 * time.Minute),
			Delete: schema.DefaultTimeout(4 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"copy": {
				Type:        schema.TypeList,
				Optional:    true,
				ForceNew:    true,
				Description: `Copies a table.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"source_tables": {
							Type:        schema.TypeList,
							Required:    true,
							ForceNew:    true,
							Description: `Source tables to copy.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"table_id": {
										Type:             schema.TypeString,
										Required:         true,
										ForceNew:         true,
										DiffSuppressFunc: compareSelfLinkRelativePaths,
										Description: `The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set,
or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.`,
									},
									"dataset_id": {
										Type:        schema.TypeString,
										Computed:    true,
										Optional:    true,
										ForceNew:    true,
										Description: `The ID of the dataset containing this table.`,
									},
									"project_id": {
										Type:        schema.TypeString,
										Computed:    true,
										Optional:    true,
										ForceNew:    true,
										Description: `The ID of the project containing this table.`,
									},
								},
							},
						},
						"create_disposition": {
							Type:         schema.TypeString,
							Optional:     true,
							ForceNew:     true,
							ValidateFunc: validation.StringInSlice([]string{"CREATE_IF_NEEDED", "CREATE_NEVER", ""}, false),
							Description: `Specifies whether the job is allowed to create new tables. The following values are supported:
CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_NEVER" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]`,
							Default: "CREATE_NEVER",
						},
						"destination_encryption_configuration": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Custom encryption configuration (e.g., Cloud KMS keys)`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"kms_key_name": {
										Type:     schema.TypeString,
										Required: true,
										ForceNew: true,
										Description: `Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
The BigQuery Service Account associated with your project requires access to this encryption key.`,
									},
								},
							},
						},
						"destination_table": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `The destination table.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"table_id": {
										Type:             schema.TypeString,
										Required:         true,
										ForceNew:         true,
										DiffSuppressFunc: compareSelfLinkRelativePaths,
										Description: `The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set,
or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.`,
									},
									"dataset_id": {
										Type:        schema.TypeString,
										Computed:    true,
										Optional:    true,
										ForceNew:    true,
										Description: `The ID of the dataset containing this table.`,
									},
									"project_id": {
										Type:        schema.TypeString,
										Computed:    true,
										Optional:    true,
										ForceNew:    true,
										Description: `The ID of the project containing this table.`,
									},
								},
							},
						},
						"write_disposition": {
							Type:         schema.TypeString,
							Optional:     true,
							ForceNew:     true,
							ValidateFunc: validation.StringInSlice([]string{"WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY", ""}, false),
							Description: `Specifies the action that occurs if the destination table already exists. The following values are supported:
WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]`,
							Default: "WRITE_EMPTY",
						},
					},
				},
				ExactlyOneOf: []string{},
			},
			"extract": {
				Type:        schema.TypeList,
				Optional:    true,
				ForceNew:    true,
				Description: `Configures an extract job.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"destination_uris": {
							Type:        schema.TypeList,
							Required:    true,
							ForceNew:    true,
							Description: `A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
						},
						"compression": {
							Type:     schema.TypeString,
							Optional: true,
							ForceNew: true,
							Description: `The compression type to use for exported files. Possible values include GZIP, DEFLATE, SNAPPY, and NONE.
The default value is NONE. DEFLATE and SNAPPY are only supported for Avro.`,
							Default: "NONE",
						},
						"destination_format": {
							Type:     schema.TypeString,
							Computed: true,
							Optional: true,
							ForceNew: true,
							Description: `The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON and AVRO for tables and SAVED_MODEL for models.
The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV.
The default value for models is SAVED_MODEL.`,
						},
						"field_delimiter": {
							Type:     schema.TypeString,
							Computed: true,
							Optional: true,
							ForceNew: true,
							Description: `When extracting data in CSV format, this defines the delimiter to use between fields in the exported data.
Default is ','`,
						},
						"print_header": {
							Type:        schema.TypeBool,
							Optional:    true,
							ForceNew:    true,
							Description: `Whether to print out a header row in the results. Default is true.`,
							Default:     true,
						},
						"source_model": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `A reference to the model being exported.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"dataset_id": {
										Type:        schema.TypeString,
										Required:    true,
										ForceNew:    true,
										Description: `The ID of the dataset containing this model.`,
									},
									"model_id": {
										Type:        schema.TypeString,
										Required:    true,
										ForceNew:    true,
										Description: `The ID of the model.`,
									},
									"project_id": {
										Type:        schema.TypeString,
										Required:    true,
										ForceNew:    true,
										Description: `The ID of the project containing this model.`,
									},
								},
							},
							ExactlyOneOf: []string{},
						},
						"source_table": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `A reference to the table being exported.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"table_id": {
										Type:             schema.TypeString,
										Required:         true,
										ForceNew:         true,
										DiffSuppressFunc: compareSelfLinkRelativePaths,
										Description: `The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set,
or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.`,
									},
									"dataset_id": {
										Type:        schema.TypeString,
										Computed:    true,
										Optional:    true,
										ForceNew:    true,
										Description: `The ID of the dataset containing this table.`,
									},
									"project_id": {
										Type:        schema.TypeString,
										Computed:    true,
										Optional:    true,
										ForceNew:    true,
										Description: `The ID of the project containing this table.`,
									},
								},
							},
							ExactlyOneOf: []string{},
						},
						"use_avro_logical_types": {
							Type:        schema.TypeBool,
							Optional:    true,
							ForceNew:    true,
							Description: `Whether to use logical types when extracting to AVRO format.`,
						},
					},
				},
				ExactlyOneOf: []string{},
			},
			"job_timeout_ms": {
				Type:        schema.TypeString,
				Optional:    true,
				ForceNew:    true,
				Description: `Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.`,
			},
			"labels": {
				Type:        schema.TypeMap,
				Optional:    true,
				ForceNew:    true,
				Description: `The labels associated with this job. You can use these to organize and group your jobs.`,
				Elem:        &schema.Schema{Type: schema.TypeString},
			},
			"load": {
				Type:        schema.TypeList,
				Optional:    true,
				ForceNew:    true,
				Description: `Configures a load job.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"destination_table": {
							Type:        schema.TypeList,
							Required:    true,
							ForceNew:    true,
							Description: `The destination table to load the data into.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"table_id": {
										Type:             schema.TypeString,
										Required:         true,
										ForceNew:         true,
										DiffSuppressFunc: compareSelfLinkRelativePaths,
										Description: `The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set,
or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.`,
									},
									"dataset_id": {
										Type:        schema.TypeString,
										Computed:    true,
										Optional:    true,
										ForceNew:    true,
										Description: `The ID of the dataset containing this table.`,
									},
									"project_id": {
										Type:        schema.TypeString,
										Computed:    true,
										Optional:    true,
										ForceNew:    true,
										Description: `The ID of the project containing this table.`,
									},
								},
							},
						},
						"source_uris": {
							Type:     schema.TypeList,
							Required: true,
							ForceNew: true,
							Description: `The fully-qualified URIs that point to your data in Google Cloud.
For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character
and it must come after the 'bucket' name. Size limits related to load jobs apply
to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be
specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table.
For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '*' wildcard character is not allowed.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
						},
						"allow_jagged_rows": {
							Type:     schema.TypeBool,
							Optional: true,
							ForceNew: true,
							Description: `Accept rows that are missing trailing optional columns. The missing values are treated as nulls.
If false, records with missing trailing columns are treated as bad records, and if there are too many bad records,
an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.`,
							Default: false,
						},
						"allow_quoted_newlines": {
							Type:     schema.TypeBool,
							Optional: true,
							ForceNew: true,
							Description: `Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file.
The default value is false.`,
							Default: false,
						},
						"autodetect": {
							Type:        schema.TypeBool,
							Optional:    true,
							ForceNew:    true,
							Description: `Indicates if we should automatically infer the options and schema for CSV and JSON sources.`,
						},
						"create_disposition": {
							Type:         schema.TypeString,
							Optional:     true,
							ForceNew:     true,
							ValidateFunc: validation.StringInSlice([]string{"CREATE_IF_NEEDED", "CREATE_NEVER", ""}, false),
							Description: `Specifies whether the job is allowed to create new tables. The following values are supported:
CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_NEVER" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]`,
							Default: "CREATE_NEVER",
						},
						"destination_encryption_configuration": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Custom encryption configuration (e.g., Cloud KMS keys)`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"kms_key_name": {
										Type:     schema.TypeString,
										Required: true,
										ForceNew: true,
										Description: `Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
The BigQuery Service Account associated with your project requires access to this encryption key.`,
									},
								},
							},
						},
						"encoding": {
							Type:     schema.TypeString,
							Optional: true,
							ForceNew: true,
							Description: `The character encoding of the data. The supported values are UTF-8 or ISO-8859-1.
The default value is UTF-8. BigQuery decodes the data after the raw, binary data
has been split using the values of the quote and fieldDelimiter properties.`,
							Default: "UTF-8",
						},
						"field_delimiter": {
							Type:     schema.TypeString,
							Computed: true,
							Optional: true,
							ForceNew: true,
							Description: `The separator for fields in a CSV file. The separator can be any ISO-8859-1 single-byte character.
To use a character in the range 128-255, you must encode the character as UTF8. BigQuery converts
the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the
data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator.
The default value is a comma (',').`,
						},
						"ignore_unknown_values": {
							Type:     schema.TypeBool,
							Optional: true,
							ForceNew: true,
							Description: `Indicates if BigQuery should allow extra values that are not represented in the table schema.
If true, the extra values are ignored. If false, records with extra columns are treated as bad records,
and if there are too many bad records, an invalid error is returned in the job result.
The default value is false. The sourceFormat property determines what BigQuery treats as an extra value:
CSV: Trailing columns
JSON: Named values that don't match any column names`,
							Default: false,
						},
						"max_bad_records": {
							Type:     schema.TypeInt,
							Optional: true,
							ForceNew: true,
							Description: `The maximum number of bad records that BigQuery can ignore when running the job. If the number of bad records exceeds this value,
an invalid error is returned in the job result. The default value is 0, which requires that all records are valid.`,
							Default: 0,
						},
						"null_marker": {
							Type:     schema.TypeString,
							Optional: true,
							ForceNew: true,
							Description: `Specifies a string that represents a null value in a CSV file. For example, if you specify "\N", BigQuery interprets "\N" as a null value
when loading a CSV file. The default value is the empty string. If you set this property to a custom value, BigQuery throws an error if an
empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as
an empty value.`,
							Default: "",
						},
						"projection_fields": {
							Type:     schema.TypeList,
							Optional: true,
							ForceNew: true,
							Description: `If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup.
Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties.
If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
						},
						"quote": {
							Type:     schema.TypeString,
							Computed: true,
							Optional: true,
							ForceNew: true,
							Description: `The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding,
and then uses the first byte of the encoded string to split the data in its raw, binary state.
The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string.
If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.`,
						},
						"schema_update_options": {
							Type:     schema.TypeList,
							Optional: true,
							ForceNew: true,
							Description: `Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or
supplied in the job configuration. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators.
For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified:
ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
						},
						"skip_leading_rows": {
							Type:         schema.TypeInt,
							Optional:     true,
							ForceNew:     true,
							ValidateFunc: validation.IntAtLeast(0),
							Description: `The number of rows at the top of a CSV file that BigQuery will skip when loading the data.
The default value is 0. This property is useful if you have header rows in the file that should be skipped.
When autodetect is on, the behavior is the following:
skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected,
the row is read as data. Otherwise data is read starting from the second row.
skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row.
skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected,
row N is just skipped. Otherwise row N is used to extract column names for the detected schema.`,
							Default: 0,
						},
						"source_format": {
							Type:     schema.TypeString,
							Optional: true,
							ForceNew: true,
							Description: `The format of the data files. For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP".
For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET".
For orc, specify "ORC". The default value is CSV.`,
							Default: "CSV",
						},
						"time_partitioning": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Time-based partitioning specification for the destination table.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"type": {
										Type:     schema.TypeString,
										Required: true,
										ForceNew: true,
										Description: `The only type supported is DAY, which will generate one partition per day. Providing an empty string used to cause an error,
but in OnePlatform the field will be treated as unset.`,
									},
									"expiration_ms": {
										Type:        schema.TypeString,
										Optional:    true,
										ForceNew:    true,
										Description: `Number of milliseconds for which to keep the storage for a partition. A wrapper is used here because 0 is an invalid value.`,
									},
									"field": {
										Type:     schema.TypeString,
										Optional: true,
										ForceNew: true,
										Description: `If not set, the table is partitioned by pseudo column '_PARTITIONTIME'; if set, the table is partitioned by this field.
The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
A wrapper is used here because an empty string is an invalid value.`,
									},
								},
							},
						},
						"write_disposition": {
							Type:         schema.TypeString,
							Optional:     true,
							ForceNew:     true,
							ValidateFunc: validation.StringInSlice([]string{"WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY", ""}, false),
							Description: `Specifies the action that occurs if the destination table already exists. The following values are supported:
WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]`,
							Default: "WRITE_EMPTY",
						},
					},
				},
				ExactlyOneOf: []string{},
			},
			"query": {
				Type:        schema.TypeList,
				Optional:    true,
				ForceNew:    true,
				Description: `Configures a query job.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"query": {
							Type:        schema.TypeString,
							Required:    true,
							ForceNew:    true,
							Description: `SQL query text to execute. The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.`,
						},
						"allow_large_results": {
							Type:     schema.TypeBool,
							Optional: true,
							ForceNew: true,
							Description: `If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance.
Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed.
However, you must still set destinationTable when result size exceeds the allowed maximum response size.`,
						},
						"create_disposition": {
							Type:         schema.TypeString,
							Optional:     true,
							ForceNew:     true,
							ValidateFunc: validation.StringInSlice([]string{"CREATE_IF_NEEDED", "CREATE_NEVER", ""}, false),
							Description: `Specifies whether the job is allowed to create new tables. The following values are supported:
CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_NEVER" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]`,
							Default: "CREATE_NEVER",
						},
						"default_dataset": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Specifies the default dataset to use for unqualified table names in the query. Note that this does not alter behavior of unqualified dataset names.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"dataset_id": {
										Type:             schema.TypeString,
										Required:         true,
										ForceNew:         true,
										DiffSuppressFunc: compareSelfLinkRelativePaths,
										Description: `The dataset. Can be specified '{{dataset_id}}' if 'project_id' is also set,
or of the form 'projects/{{project}}/datasets/{{dataset_id}}' if not.`,
									},
									"project_id": {
										Type:        schema.TypeString,
										Computed:    true,
										Optional:    true,
										ForceNew:    true,
										Description: `The ID of the project containing this table.`,
									},
								},
							},
						},
						"destination_encryption_configuration": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Custom encryption configuration (e.g., Cloud KMS keys)`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"kms_key_name": {
										Type:     schema.TypeString,
										Required: true,
										ForceNew: true,
										Description: `Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
The BigQuery Service Account associated with your project requires access to this encryption key.`,
									},
								},
							},
						},
						"destination_table": {
							Type:     schema.TypeList,
							Optional: true,
							ForceNew: true,
							Description: `Describes the table where the query results should be stored.
This property must be set for large results that exceed the maximum response size.
For queries that produce anonymous (cached) results, this field will be populated by BigQuery.`,
							MaxItems: 1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"table_id": {
										Type:             schema.TypeString,
										Required:         true,
										ForceNew:         true,
										DiffSuppressFunc: compareSelfLinkRelativePaths,
										Description: `The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set,
or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.`,
									},
									"dataset_id": {
										Type:        schema.TypeString,
										Computed:    true,
										Optional:    true,
										ForceNew:    true,
										Description: `The ID of the dataset containing this table.`,
									},
									"project_id": {
										Type:        schema.TypeString,
										Computed:    true,
										Optional:    true,
										ForceNew:    true,
										Description: `The ID of the project containing this table.`,
									},
								},
							},
						},
						"flatten_results": {
							Type:     schema.TypeBool,
							Optional: true,
							ForceNew: true,
							Description: `If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results.
allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.`,
						},
						"maximum_billing_tier": {
							Type:     schema.TypeInt,
							Optional: true,
							ForceNew: true,
							Description: `Limits the billing tier for this job. Queries that have resource usage beyond this tier will fail (without incurring a charge).
If unspecified, this will be set to your project default.`,
						},
						"maximum_bytes_billed": {
							Type:     schema.TypeString,
							Optional: true,
							ForceNew: true,
							Description: `Limits the bytes billed for this job. Queries that will have bytes billed beyond this limit will fail (without incurring a charge).
If unspecified, this will be set to your project default.`,
						},
						"parameter_mode": {
							Type:        schema.TypeString,
							Optional:    true,
							ForceNew:    true,
							Description: `Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.`,
						},
						"priority": {
							Type:         schema.TypeString,
							Optional:     true,
							ForceNew:     true,
							ValidateFunc: validation.StringInSlice([]string{"INTERACTIVE", "BATCH", ""}, false),
							Description:  `Specifies a priority for the query. Default value: "INTERACTIVE" Possible values: ["INTERACTIVE", "BATCH"]`,
							Default:      "INTERACTIVE",
						},
						"schema_update_options": {
							Type:     schema.TypeList,
							Optional: true,
							ForceNew: true,
							Description: `Allows the schema of the destination table to be updated as a side effect of the query job.
Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table,
specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema.
One or more of the following values are specified:
ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
						},
						"script_options": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Options controlling the execution of scripts.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"key_result_statement": {
										Type:         schema.TypeString,
										Optional:     true,
										ForceNew:     true,
										ValidateFunc: validation.StringInSlice([]string{"LAST", "FIRST_SELECT", ""}, false),
										Description: `Determines which statement in the script represents the "key result",
used to populate the schema and query results of the script job. Possible values: ["LAST", "FIRST_SELECT"]`,
										AtLeastOneOf: []string{},
									},
									"statement_byte_budget": {
										Type:         schema.TypeString,
										Optional:     true,
										ForceNew:     true,
										Description:  `Limit on the number of bytes billed per statement. Exceeding this budget results in an error.`,
										AtLeastOneOf: []string{},
									},
									"statement_timeout_ms": {
										Type:         schema.TypeString,
										Optional:     true,
										ForceNew:     true,
										Description:  `Timeout period for each statement in a script.`,
										AtLeastOneOf: []string{},
									},
								},
							},
						},
						"use_legacy_sql": {
							Type:     schema.TypeBool,
							Optional: true,
							ForceNew: true,
							Description: `Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is true.
If set to false, the query will use BigQuery's standard SQL.`,
							Default: true,
						},
						"use_query_cache": {
							Type:     schema.TypeBool,
							Optional: true,
							ForceNew: true,
							Description: `Whether to look for the result in the query cache. The query cache is a best-effort cache that will be flushed whenever
tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified.
The default value is true.`,
							Default: true,
						},
						"user_defined_function_resources": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Describes user-defined function resources used in the query.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"inline_code": {
										Type:     schema.TypeString,
										Optional: true,
										ForceNew: true,
										Description: `An inline resource that contains code for a user-defined function (UDF).
Providing a inline code resource is equivalent to providing a URI for a file containing the same code.`,
									},
									"resource_uri": {
										Type:        schema.TypeString,
										Optional:    true,
										ForceNew:    true,
										Description: `A code resource to load from a Google Cloud Storage URI (gs://bucket/path).`,
									},
								},
							},
						},
						"write_disposition": {
							Type:         schema.TypeString,
							Optional:     true,
							ForceNew:     true,
							ValidateFunc: validation.StringInSlice([]string{"WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY", ""}, false),
							Description: `Specifies the action that occurs if the destination table already exists. The following values are supported:
WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]`,
							Default: "WRITE_EMPTY",
						},
					},
				},
				ExactlyOneOf: []string{},
			},
			"job_type": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `The type of the job.`,
			},

			"job_id": {
				Type:        schema.TypeString,
				Required:    true,
				ForceNew:    true,
				Description: `The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.`,
			},
			"location": {
				Type:        schema.TypeString,
				Optional:    true,
				ForceNew:    true,
				Description: `The geographic location of the job. The default value is US.`,
				Default:     "US",
			},

			"user_email": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `Email address of the user who ran the job.`,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
	}
}

func resourceBigQueryJobCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	obj := make(map[string]interface{})
	configurationProp, err := expandBigQueryJobConfiguration(nil, d, config)
	if err != nil {
		return err
	} else if !isEmptyValue(reflect.ValueOf(configurationProp)) {
		obj["configuration"] = configurationProp
	}
	jobReferenceProp, err := expandBigQueryJobJobReference(nil, d, config)
	if err != nil {
		return err
	} else if !isEmptyValue(reflect.ValueOf(jobReferenceProp)) {
		obj["jobReference"] = jobReferenceProp
	}

	obj, err = resourceBigQueryJobEncoder(d, meta, obj)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{BigQueryBasePath}}projects/{{project}}/jobs")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new Job: %#v", obj)
	project, err := getProject(d, config)
	if err != nil {
		return err
	}
	res, err := sendRequestWithTimeout(config, "POST", project, url, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating Job: %s", err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "projects/{{project}}/jobs/{{job_id}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	log.Printf("[DEBUG] Finished creating Job %q: %#v", d.Id(), res)

	return resourceBigQueryJobRead(d, meta)
}

func resourceBigQueryJobRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	url, err := replaceVars(d, config, "{{BigQueryBasePath}}projects/{{project}}/jobs/{{job_id}}")
	if err != nil {
		return err
	}

	project, err := getProject(d, config)
	if err != nil {
		return err
	}
	res, err := sendRequest(config, "GET", project, url, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("BigQueryJob %q", d.Id()))
	}

	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading Job: %s", err)
	}

	if err := d.Set("user_email", flattenBigQueryJobUserEmail(res["user_email"], d, config)); err != nil {
		return fmt.Errorf("Error reading Job: %s", err)
	}
	// Terraform must set the top level schema field, but since this object contains collapsed properties
	// it's difficult to know what the top level should be. Instead we just loop over the map returned from flatten.
	if flattenedProp := flattenBigQueryJobConfiguration(res["configuration"], d, config); flattenedProp != nil {
		if gerr, ok := flattenedProp.(*googleapi.Error); ok {
			return fmt.Errorf("Error reading Job: %s", gerr)
		}
		casted := flattenedProp.([]interface{})[0]
		if casted != nil {
			for k, v := range casted.(map[string]interface{}) {
				d.Set(k, v)
			}
		}
	}
	// Terraform must set the top level schema field, but since this object contains collapsed properties
	// it's difficult to know what the top level should be. Instead we just loop over the map returned from flatten.
	if flattenedProp := flattenBigQueryJobJobReference(res["jobReference"], d, config); flattenedProp != nil {
		if gerr, ok := flattenedProp.(*googleapi.Error); ok {
			return fmt.Errorf("Error reading Job: %s", gerr)
		}
		casted := flattenedProp.([]interface{})[0]
		if casted != nil {
			for k, v := range casted.(map[string]interface{}) {
				d.Set(k, v)
			}
		}
	}

	return nil
}

func resourceBigQueryJobDelete(d *schema.ResourceData, meta interface{}) error {
	log.Printf("[WARNING] BigQuery Job resources"+
		" cannot be deleted from GCP. The resource %s will be removed from Terraform"+
		" state, but will still be present on the server.", d.Id())
	d.SetId("")

	return nil
}

func resourceBigQueryJobImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)
	if err := parseImportId([]string{
		"projects/(?P<project>[^/]+)/jobs/(?P<job_id>[^/]+)",
		"(?P<project>[^/]+)/(?P<job_id>[^/]+)",
		"(?P<job_id>[^/]+)",
	}, d, config); err != nil {
		return nil, err
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "projects/{{project}}/jobs/{{job_id}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	return []*schema.ResourceData{d}, nil
}

func flattenBigQueryJobUserEmail(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfiguration(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["job_type"] =
		flattenBigQueryJobConfigurationJobType(original["jobType"], d, config)
	transformed["job_timeout_ms"] =
		flattenBigQueryJobConfigurationJobTimeoutMs(original["jobTimeoutMs"], d, config)
	transformed["labels"] =
		flattenBigQueryJobConfigurationLabels(original["labels"], d, config)
	transformed["query"] =
		flattenBigQueryJobConfigurationQuery(original["query"], d, config)
	transformed["load"] =
		flattenBigQueryJobConfigurationLoad(original["load"], d, config)
	transformed["copy"] =
		flattenBigQueryJobConfigurationCopy(original["copy"], d, config)
	transformed["extract"] =
		flattenBigQueryJobConfigurationExtract(original["extract"], d, config)
	return []interface{}{transformed}
}
func flattenBigQueryJobConfigurationJobType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationJobTimeoutMs(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLabels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQuery(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["query"] =
		flattenBigQueryJobConfigurationQueryQuery(original["query"], d, config)
	transformed["destination_table"] =
		flattenBigQueryJobConfigurationQueryDestinationTable(original["destinationTable"], d, config)
	transformed["user_defined_function_resources"] =
		flattenBigQueryJobConfigurationQueryUserDefinedFunctionResources(original["userDefinedFunctionResources"], d, config)
	transformed["create_disposition"] =
		flattenBigQueryJobConfigurationQueryCreateDisposition(original["createDisposition"], d, config)
	transformed["write_disposition"] =
		flattenBigQueryJobConfigurationQueryWriteDisposition(original["writeDisposition"], d, config)
	transformed["default_dataset"] =
		flattenBigQueryJobConfigurationQueryDefaultDataset(original["defaultDataset"], d, config)
	transformed["priority"] =
		flattenBigQueryJobConfigurationQueryPriority(original["priority"], d, config)
	transformed["allow_large_results"] =
		flattenBigQueryJobConfigurationQueryAllowLargeResults(original["allowLargeResults"], d, config)
	transformed["use_query_cache"] =
		flattenBigQueryJobConfigurationQueryUseQueryCache(original["useQueryCache"], d, config)
	transformed["flatten_results"] =
		flattenBigQueryJobConfigurationQueryFlattenResults(original["flattenResults"], d, config)
	transformed["maximum_billing_tier"] =
		flattenBigQueryJobConfigurationQueryMaximumBillingTier(original["maximumBillingTier"], d, config)
	transformed["maximum_bytes_billed"] =
		flattenBigQueryJobConfigurationQueryMaximumBytesBilled(original["maximumBytesBilled"], d, config)
	transformed["use_legacy_sql"] =
		flattenBigQueryJobConfigurationQueryUseLegacySql(original["useLegacySql"], d, config)
	transformed["parameter_mode"] =
		flattenBigQueryJobConfigurationQueryParameterMode(original["parameterMode"], d, config)
	transformed["schema_update_options"] =
		flattenBigQueryJobConfigurationQuerySchemaUpdateOptions(original["schemaUpdateOptions"], d, config)
	transformed["destination_encryption_configuration"] =
		flattenBigQueryJobConfigurationQueryDestinationEncryptionConfiguration(original["destinationEncryptionConfiguration"], d, config)
	transformed["script_options"] =
		flattenBigQueryJobConfigurationQueryScriptOptions(original["scriptOptions"], d, config)
	return []interface{}{transformed}
}
func flattenBigQueryJobConfigurationQueryQuery(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryDestinationTable(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["project_id"] = original["projectId"]
	transformed["dataset_id"] = original["datasetId"]
	transformed["table_id"] = original["tableId"]

	if bigqueryTableRegexp.MatchString(d.Get("query.0.destination_table.0.table_id").(string)) {
		// The user specified the table_id as a URL, so store it in state that way
		transformed["table_id"] = fmt.Sprintf("projects/%s/datasets/%s/tables/%s", transformed["project_id"], transformed["dataset_id"], transformed["table_id"])
	}
	return []interface{}{transformed}
}

func flattenBigQueryJobConfigurationQueryUserDefinedFunctionResources(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"resource_uri": flattenBigQueryJobConfigurationQueryUserDefinedFunctionResourcesResourceUri(original["resourceUri"], d, config),
			"inline_code":  flattenBigQueryJobConfigurationQueryUserDefinedFunctionResourcesInlineCode(original["inlineCode"], d, config),
		})
	}
	return transformed
}
func flattenBigQueryJobConfigurationQueryUserDefinedFunctionResourcesResourceUri(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryUserDefinedFunctionResourcesInlineCode(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryCreateDisposition(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryWriteDisposition(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryDefaultDataset(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["project_id"] = original["projectId"]
	transformed["dataset_id"] = original["datasetId"]

	if bigqueryDatasetRegexp.MatchString(d.Get("query.0.default_dataset.0.dataset_id").(string)) {
		// The user specified the dataset_id as a URL, so store it in state that way
		transformed["dataset_id"] = fmt.Sprintf("projects/%s/datasets/%s", transformed["project_id"], transformed["dataset_id"])
	}
	return []interface{}{transformed}
}

func flattenBigQueryJobConfigurationQueryPriority(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryAllowLargeResults(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryUseQueryCache(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryFlattenResults(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryMaximumBillingTier(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := strconv.ParseInt(strVal, 10, 64); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenBigQueryJobConfigurationQueryMaximumBytesBilled(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryUseLegacySql(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryParameterMode(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQuerySchemaUpdateOptions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryDestinationEncryptionConfiguration(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["kms_key_name"] =
		flattenBigQueryJobConfigurationQueryDestinationEncryptionConfigurationKmsKeyName(original["kmsKeyName"], d, config)
	return []interface{}{transformed}
}
func flattenBigQueryJobConfigurationQueryDestinationEncryptionConfigurationKmsKeyName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryScriptOptions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["statement_timeout_ms"] =
		flattenBigQueryJobConfigurationQueryScriptOptionsStatementTimeoutMs(original["statementTimeoutMs"], d, config)
	transformed["statement_byte_budget"] =
		flattenBigQueryJobConfigurationQueryScriptOptionsStatementByteBudget(original["statementByteBudget"], d, config)
	transformed["key_result_statement"] =
		flattenBigQueryJobConfigurationQueryScriptOptionsKeyResultStatement(original["keyResultStatement"], d, config)
	return []interface{}{transformed}
}
func flattenBigQueryJobConfigurationQueryScriptOptionsStatementTimeoutMs(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryScriptOptionsStatementByteBudget(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationQueryScriptOptionsKeyResultStatement(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoad(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["source_uris"] =
		flattenBigQueryJobConfigurationLoadSourceUris(original["sourceUris"], d, config)
	transformed["destination_table"] =
		flattenBigQueryJobConfigurationLoadDestinationTable(original["destinationTable"], d, config)
	transformed["create_disposition"] =
		flattenBigQueryJobConfigurationLoadCreateDisposition(original["createDisposition"], d, config)
	transformed["write_disposition"] =
		flattenBigQueryJobConfigurationLoadWriteDisposition(original["writeDisposition"], d, config)
	transformed["null_marker"] =
		flattenBigQueryJobConfigurationLoadNullMarker(original["nullMarker"], d, config)
	transformed["field_delimiter"] =
		flattenBigQueryJobConfigurationLoadFieldDelimiter(original["fieldDelimiter"], d, config)
	transformed["skip_leading_rows"] =
		flattenBigQueryJobConfigurationLoadSkipLeadingRows(original["skipLeadingRows"], d, config)
	transformed["encoding"] =
		flattenBigQueryJobConfigurationLoadEncoding(original["encoding"], d, config)
	transformed["quote"] =
		flattenBigQueryJobConfigurationLoadQuote(original["quote"], d, config)
	transformed["max_bad_records"] =
		flattenBigQueryJobConfigurationLoadMaxBadRecords(original["maxBadRecords"], d, config)
	transformed["allow_quoted_newlines"] =
		flattenBigQueryJobConfigurationLoadAllowQuotedNewlines(original["allowQuotedNewlines"], d, config)
	transformed["source_format"] =
		flattenBigQueryJobConfigurationLoadSourceFormat(original["sourceFormat"], d, config)
	transformed["allow_jagged_rows"] =
		flattenBigQueryJobConfigurationLoadAllowJaggedRows(original["allowJaggedRows"], d, config)
	transformed["ignore_unknown_values"] =
		flattenBigQueryJobConfigurationLoadIgnoreUnknownValues(original["ignoreUnknownValues"], d, config)
	transformed["projection_fields"] =
		flattenBigQueryJobConfigurationLoadProjectionFields(original["projectionFields"], d, config)
	transformed["autodetect"] =
		flattenBigQueryJobConfigurationLoadAutodetect(original["autodetect"], d, config)
	transformed["schema_update_options"] =
		flattenBigQueryJobConfigurationLoadSchemaUpdateOptions(original["schemaUpdateOptions"], d, config)
	transformed["time_partitioning"] =
		flattenBigQueryJobConfigurationLoadTimePartitioning(original["timePartitioning"], d, config)
	transformed["destination_encryption_configuration"] =
		flattenBigQueryJobConfigurationLoadDestinationEncryptionConfiguration(original["destinationEncryptionConfiguration"], d, config)
	return []interface{}{transformed}
}
func flattenBigQueryJobConfigurationLoadSourceUris(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadDestinationTable(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["project_id"] = original["projectId"]
	transformed["dataset_id"] = original["datasetId"]
	transformed["table_id"] = original["tableId"]

	if bigqueryTableRegexp.MatchString(d.Get("load.0.destination_table.0.table_id").(string)) {
		// The user specified the table_id as a URL, so store it in state that way
		transformed["table_id"] = fmt.Sprintf("projects/%s/datasets/%s/tables/%s", transformed["project_id"], transformed["dataset_id"], transformed["table_id"])
	}
	return []interface{}{transformed}
}

func flattenBigQueryJobConfigurationLoadCreateDisposition(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadWriteDisposition(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadNullMarker(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadFieldDelimiter(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadSkipLeadingRows(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := strconv.ParseInt(strVal, 10, 64); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenBigQueryJobConfigurationLoadEncoding(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadQuote(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadMaxBadRecords(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := strconv.ParseInt(strVal, 10, 64); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenBigQueryJobConfigurationLoadAllowQuotedNewlines(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadSourceFormat(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadAllowJaggedRows(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadIgnoreUnknownValues(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadProjectionFields(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadAutodetect(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadSchemaUpdateOptions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadTimePartitioning(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["type"] =
		flattenBigQueryJobConfigurationLoadTimePartitioningType(original["type"], d, config)
	transformed["expiration_ms"] =
		flattenBigQueryJobConfigurationLoadTimePartitioningExpirationMs(original["expirationMs"], d, config)
	transformed["field"] =
		flattenBigQueryJobConfigurationLoadTimePartitioningField(original["field"], d, config)
	return []interface{}{transformed}
}
func flattenBigQueryJobConfigurationLoadTimePartitioningType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadTimePartitioningExpirationMs(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadTimePartitioningField(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationLoadDestinationEncryptionConfiguration(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["kms_key_name"] =
		flattenBigQueryJobConfigurationLoadDestinationEncryptionConfigurationKmsKeyName(original["kmsKeyName"], d, config)
	return []interface{}{transformed}
}
func flattenBigQueryJobConfigurationLoadDestinationEncryptionConfigurationKmsKeyName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationCopy(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["source_tables"] =
		flattenBigQueryJobConfigurationCopySourceTables(original["sourceTables"], d, config)
	transformed["destination_table"] =
		flattenBigQueryJobConfigurationCopyDestinationTable(original["destinationTable"], d, config)
	transformed["create_disposition"] =
		flattenBigQueryJobConfigurationCopyCreateDisposition(original["createDisposition"], d, config)
	transformed["write_disposition"] =
		flattenBigQueryJobConfigurationCopyWriteDisposition(original["writeDisposition"], d, config)
	transformed["destination_encryption_configuration"] =
		flattenBigQueryJobConfigurationCopyDestinationEncryptionConfiguration(original["destinationEncryptionConfiguration"], d, config)
	return []interface{}{transformed}
}
func flattenBigQueryJobConfigurationCopySourceTables(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for i, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		t := map[string]interface{}{
			"project_id": original["projectId"],
			"dataset_id": original["datasetId"],
			"table_id":   original["tableId"],
		}

		if bigqueryTableRegexp.MatchString(d.Get(fmt.Sprintf("copy.0.source_tables.%d.table_id", i)).(string)) {
			// The user specified the table_id as a URL, so store it in state that way
			t["table_id"] = fmt.Sprintf("projects/%s/datasets/%s/tables/%s", t["project_id"], t["dataset_id"], t["table_id"])
		}
		transformed = append(transformed, t)
	}

	return transformed
}

func flattenBigQueryJobConfigurationCopyDestinationTable(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["project_id"] = original["projectId"]
	transformed["dataset_id"] = original["datasetId"]
	transformed["table_id"] = original["tableId"]

	if bigqueryTableRegexp.MatchString(d.Get("copy.0.destination_table.0.table_id").(string)) {
		// The user specified the table_id as a URL, so store it in state that way
		transformed["table_id"] = fmt.Sprintf("projects/%s/datasets/%s/tables/%s", transformed["project_id"], transformed["dataset_id"], transformed["table_id"])
	}
	return []interface{}{transformed}
}

func flattenBigQueryJobConfigurationCopyCreateDisposition(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationCopyWriteDisposition(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationCopyDestinationEncryptionConfiguration(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["kms_key_name"] =
		flattenBigQueryJobConfigurationCopyDestinationEncryptionConfigurationKmsKeyName(original["kmsKeyName"], d, config)
	return []interface{}{transformed}
}
func flattenBigQueryJobConfigurationCopyDestinationEncryptionConfigurationKmsKeyName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationExtract(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["destination_uris"] =
		flattenBigQueryJobConfigurationExtractDestinationUris(original["destinationUris"], d, config)
	transformed["print_header"] =
		flattenBigQueryJobConfigurationExtractPrintHeader(original["printHeader"], d, config)
	transformed["field_delimiter"] =
		flattenBigQueryJobConfigurationExtractFieldDelimiter(original["fieldDelimiter"], d, config)
	transformed["destination_format"] =
		flattenBigQueryJobConfigurationExtractDestinationFormat(original["destinationFormat"], d, config)
	transformed["compression"] =
		flattenBigQueryJobConfigurationExtractCompression(original["compression"], d, config)
	transformed["use_avro_logical_types"] =
		flattenBigQueryJobConfigurationExtractUseAvroLogicalTypes(original["useAvroLogicalTypes"], d, config)
	transformed["source_table"] =
		flattenBigQueryJobConfigurationExtractSourceTable(original["sourceTable"], d, config)
	transformed["source_model"] =
		flattenBigQueryJobConfigurationExtractSourceModel(original["sourceModel"], d, config)
	return []interface{}{transformed}
}
func flattenBigQueryJobConfigurationExtractDestinationUris(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationExtractPrintHeader(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationExtractFieldDelimiter(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationExtractDestinationFormat(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationExtractCompression(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationExtractUseAvroLogicalTypes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationExtractSourceTable(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["project_id"] = original["projectId"]
	transformed["dataset_id"] = original["datasetId"]
	transformed["table_id"] = original["tableId"]

	if bigqueryTableRegexp.MatchString(d.Get("extract.0.source_table.0.table_id").(string)) {
		// The user specified the table_id as a URL, so store it in state that way
		transformed["table_id"] = fmt.Sprintf("projects/%s/datasets/%s/tables/%s", transformed["project_id"], transformed["dataset_id"], transformed["table_id"])
	}
	return []interface{}{transformed}
}

func flattenBigQueryJobConfigurationExtractSourceModel(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["project_id"] =
		flattenBigQueryJobConfigurationExtractSourceModelProjectId(original["projectId"], d, config)
	transformed["dataset_id"] =
		flattenBigQueryJobConfigurationExtractSourceModelDatasetId(original["datasetId"], d, config)
	transformed["model_id"] =
		flattenBigQueryJobConfigurationExtractSourceModelModelId(original["modelId"], d, config)
	return []interface{}{transformed}
}
func flattenBigQueryJobConfigurationExtractSourceModelProjectId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationExtractSourceModelDatasetId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobConfigurationExtractSourceModelModelId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobJobReference(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["job_id"] =
		flattenBigQueryJobJobReferenceJobId(original["jobId"], d, config)
	transformed["location"] =
		flattenBigQueryJobJobReferenceLocation(original["location"], d, config)
	return []interface{}{transformed}
}
func flattenBigQueryJobJobReferenceJobId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigQueryJobJobReferenceLocation(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandBigQueryJobConfiguration(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	transformed := make(map[string]interface{})
	transformedJobType, err := expandBigQueryJobConfigurationJobType(d.Get("job_type"), d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedJobType); val.IsValid() && !isEmptyValue(val) {
		transformed["jobType"] = transformedJobType
	}

	transformedJobTimeoutMs, err := expandBigQueryJobConfigurationJobTimeoutMs(d.Get("job_timeout_ms"), d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedJobTimeoutMs); val.IsValid() && !isEmptyValue(val) {
		transformed["jobTimeoutMs"] = transformedJobTimeoutMs
	}

	transformedLabels, err := expandBigQueryJobConfigurationLabels(d.Get("labels"), d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLabels); val.IsValid() && !isEmptyValue(val) {
		transformed["labels"] = transformedLabels
	}

	transformedQuery, err := expandBigQueryJobConfigurationQuery(d.Get("query"), d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedQuery); val.IsValid() && !isEmptyValue(val) {
		transformed["query"] = transformedQuery
	}

	transformedLoad, err := expandBigQueryJobConfigurationLoad(d.Get("load"), d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLoad); val.IsValid() && !isEmptyValue(val) {
		transformed["load"] = transformedLoad
	}

	transformedCopy, err := expandBigQueryJobConfigurationCopy(d.Get("copy"), d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCopy); val.IsValid() && !isEmptyValue(val) {
		transformed["copy"] = transformedCopy
	}

	transformedExtract, err := expandBigQueryJobConfigurationExtract(d.Get("extract"), d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExtract); val.IsValid() && !isEmptyValue(val) {
		transformed["extract"] = transformedExtract
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationJobType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationJobTimeoutMs(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLabels(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandBigQueryJobConfigurationQuery(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedQuery, err := expandBigQueryJobConfigurationQueryQuery(original["query"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedQuery); val.IsValid() && !isEmptyValue(val) {
		transformed["query"] = transformedQuery
	}

	transformedDestinationTable, err := expandBigQueryJobConfigurationQueryDestinationTable(original["destination_table"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDestinationTable); val.IsValid() && !isEmptyValue(val) {
		transformed["destinationTable"] = transformedDestinationTable
	}

	transformedUserDefinedFunctionResources, err := expandBigQueryJobConfigurationQueryUserDefinedFunctionResources(original["user_defined_function_resources"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUserDefinedFunctionResources); val.IsValid() && !isEmptyValue(val) {
		transformed["userDefinedFunctionResources"] = transformedUserDefinedFunctionResources
	}

	transformedCreateDisposition, err := expandBigQueryJobConfigurationQueryCreateDisposition(original["create_disposition"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCreateDisposition); val.IsValid() && !isEmptyValue(val) {
		transformed["createDisposition"] = transformedCreateDisposition
	}

	transformedWriteDisposition, err := expandBigQueryJobConfigurationQueryWriteDisposition(original["write_disposition"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWriteDisposition); val.IsValid() && !isEmptyValue(val) {
		transformed["writeDisposition"] = transformedWriteDisposition
	}

	transformedDefaultDataset, err := expandBigQueryJobConfigurationQueryDefaultDataset(original["default_dataset"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDefaultDataset); val.IsValid() && !isEmptyValue(val) {
		transformed["defaultDataset"] = transformedDefaultDataset
	}

	transformedPriority, err := expandBigQueryJobConfigurationQueryPriority(original["priority"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPriority); val.IsValid() && !isEmptyValue(val) {
		transformed["priority"] = transformedPriority
	}

	transformedAllowLargeResults, err := expandBigQueryJobConfigurationQueryAllowLargeResults(original["allow_large_results"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowLargeResults); val.IsValid() && !isEmptyValue(val) {
		transformed["allowLargeResults"] = transformedAllowLargeResults
	}

	transformedUseQueryCache, err := expandBigQueryJobConfigurationQueryUseQueryCache(original["use_query_cache"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUseQueryCache); val.IsValid() && !isEmptyValue(val) {
		transformed["useQueryCache"] = transformedUseQueryCache
	}

	transformedFlattenResults, err := expandBigQueryJobConfigurationQueryFlattenResults(original["flatten_results"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFlattenResults); val.IsValid() && !isEmptyValue(val) {
		transformed["flattenResults"] = transformedFlattenResults
	}

	transformedMaximumBillingTier, err := expandBigQueryJobConfigurationQueryMaximumBillingTier(original["maximum_billing_tier"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMaximumBillingTier); val.IsValid() && !isEmptyValue(val) {
		transformed["maximumBillingTier"] = transformedMaximumBillingTier
	}

	transformedMaximumBytesBilled, err := expandBigQueryJobConfigurationQueryMaximumBytesBilled(original["maximum_bytes_billed"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMaximumBytesBilled); val.IsValid() && !isEmptyValue(val) {
		transformed["maximumBytesBilled"] = transformedMaximumBytesBilled
	}

	transformedUseLegacySql, err := expandBigQueryJobConfigurationQueryUseLegacySql(original["use_legacy_sql"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUseLegacySql); val.IsValid() && !isEmptyValue(val) {
		transformed["useLegacySql"] = transformedUseLegacySql
	}

	transformedParameterMode, err := expandBigQueryJobConfigurationQueryParameterMode(original["parameter_mode"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedParameterMode); val.IsValid() && !isEmptyValue(val) {
		transformed["parameterMode"] = transformedParameterMode
	}

	transformedSchemaUpdateOptions, err := expandBigQueryJobConfigurationQuerySchemaUpdateOptions(original["schema_update_options"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSchemaUpdateOptions); val.IsValid() && !isEmptyValue(val) {
		transformed["schemaUpdateOptions"] = transformedSchemaUpdateOptions
	}

	transformedDestinationEncryptionConfiguration, err := expandBigQueryJobConfigurationQueryDestinationEncryptionConfiguration(original["destination_encryption_configuration"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDestinationEncryptionConfiguration); val.IsValid() && !isEmptyValue(val) {
		transformed["destinationEncryptionConfiguration"] = transformedDestinationEncryptionConfiguration
	}

	transformedScriptOptions, err := expandBigQueryJobConfigurationQueryScriptOptions(original["script_options"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedScriptOptions); val.IsValid() && !isEmptyValue(val) {
		transformed["scriptOptions"] = transformedScriptOptions
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationQueryQuery(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryDestinationTable(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedProjectId := original["project_id"]
	if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
		transformed["projectId"] = transformedProjectId
	}

	transformedDatasetId := original["dataset_id"]
	if val := reflect.ValueOf(transformedDatasetId); val.IsValid() && !isEmptyValue(val) {
		transformed["datasetId"] = transformedDatasetId
	}

	transformedTableId := original["table_id"]
	if val := reflect.ValueOf(transformedTableId); val.IsValid() && !isEmptyValue(val) {
		transformed["tableId"] = transformedTableId
	}

	if parts := bigqueryTableRegexp.FindStringSubmatch(transformedTableId.(string)); parts != nil {
		transformed["projectId"] = parts[1]
		transformed["datasetId"] = parts[2]
		transformed["tableId"] = parts[3]
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationQueryUserDefinedFunctionResources(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedResourceUri, err := expandBigQueryJobConfigurationQueryUserDefinedFunctionResourcesResourceUri(original["resource_uri"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedResourceUri); val.IsValid() && !isEmptyValue(val) {
			transformed["resourceUri"] = transformedResourceUri
		}

		transformedInlineCode, err := expandBigQueryJobConfigurationQueryUserDefinedFunctionResourcesInlineCode(original["inline_code"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedInlineCode); val.IsValid() && !isEmptyValue(val) {
			transformed["inlineCode"] = transformedInlineCode
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandBigQueryJobConfigurationQueryUserDefinedFunctionResourcesResourceUri(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryUserDefinedFunctionResourcesInlineCode(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryCreateDisposition(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryWriteDisposition(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryDefaultDataset(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedProjectId := original["project_id"]
	if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
		transformed["projectId"] = transformedProjectId
	}

	transformedDatasetId := original["dataset_id"]
	if val := reflect.ValueOf(transformedDatasetId); val.IsValid() && !isEmptyValue(val) {
		transformed["datasetId"] = transformedDatasetId
	}

	if parts := bigqueryDatasetRegexp.FindStringSubmatch(transformedDatasetId.(string)); parts != nil {
		transformed["projectId"] = parts[1]
		transformed["datasetId"] = parts[2]
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationQueryPriority(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryAllowLargeResults(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryUseQueryCache(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryFlattenResults(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryMaximumBillingTier(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryMaximumBytesBilled(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryUseLegacySql(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryParameterMode(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQuerySchemaUpdateOptions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryDestinationEncryptionConfiguration(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedKmsKeyName, err := expandBigQueryJobConfigurationQueryDestinationEncryptionConfigurationKmsKeyName(original["kms_key_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedKmsKeyName); val.IsValid() && !isEmptyValue(val) {
		transformed["kmsKeyName"] = transformedKmsKeyName
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationQueryDestinationEncryptionConfigurationKmsKeyName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryScriptOptions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedStatementTimeoutMs, err := expandBigQueryJobConfigurationQueryScriptOptionsStatementTimeoutMs(original["statement_timeout_ms"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedStatementTimeoutMs); val.IsValid() && !isEmptyValue(val) {
		transformed["statementTimeoutMs"] = transformedStatementTimeoutMs
	}

	transformedStatementByteBudget, err := expandBigQueryJobConfigurationQueryScriptOptionsStatementByteBudget(original["statement_byte_budget"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedStatementByteBudget); val.IsValid() && !isEmptyValue(val) {
		transformed["statementByteBudget"] = transformedStatementByteBudget
	}

	transformedKeyResultStatement, err := expandBigQueryJobConfigurationQueryScriptOptionsKeyResultStatement(original["key_result_statement"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedKeyResultStatement); val.IsValid() && !isEmptyValue(val) {
		transformed["keyResultStatement"] = transformedKeyResultStatement
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationQueryScriptOptionsStatementTimeoutMs(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryScriptOptionsStatementByteBudget(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationQueryScriptOptionsKeyResultStatement(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoad(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedSourceUris, err := expandBigQueryJobConfigurationLoadSourceUris(original["source_uris"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSourceUris); val.IsValid() && !isEmptyValue(val) {
		transformed["sourceUris"] = transformedSourceUris
	}

	transformedDestinationTable, err := expandBigQueryJobConfigurationLoadDestinationTable(original["destination_table"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDestinationTable); val.IsValid() && !isEmptyValue(val) {
		transformed["destinationTable"] = transformedDestinationTable
	}

	transformedCreateDisposition, err := expandBigQueryJobConfigurationLoadCreateDisposition(original["create_disposition"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCreateDisposition); val.IsValid() && !isEmptyValue(val) {
		transformed["createDisposition"] = transformedCreateDisposition
	}

	transformedWriteDisposition, err := expandBigQueryJobConfigurationLoadWriteDisposition(original["write_disposition"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWriteDisposition); val.IsValid() && !isEmptyValue(val) {
		transformed["writeDisposition"] = transformedWriteDisposition
	}

	transformedNullMarker, err := expandBigQueryJobConfigurationLoadNullMarker(original["null_marker"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedNullMarker); val.IsValid() && !isEmptyValue(val) {
		transformed["nullMarker"] = transformedNullMarker
	}

	transformedFieldDelimiter, err := expandBigQueryJobConfigurationLoadFieldDelimiter(original["field_delimiter"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFieldDelimiter); val.IsValid() && !isEmptyValue(val) {
		transformed["fieldDelimiter"] = transformedFieldDelimiter
	}

	transformedSkipLeadingRows, err := expandBigQueryJobConfigurationLoadSkipLeadingRows(original["skip_leading_rows"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSkipLeadingRows); val.IsValid() && !isEmptyValue(val) {
		transformed["skipLeadingRows"] = transformedSkipLeadingRows
	}

	transformedEncoding, err := expandBigQueryJobConfigurationLoadEncoding(original["encoding"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEncoding); val.IsValid() && !isEmptyValue(val) {
		transformed["encoding"] = transformedEncoding
	}

	transformedQuote, err := expandBigQueryJobConfigurationLoadQuote(original["quote"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedQuote); val.IsValid() && !isEmptyValue(val) {
		transformed["quote"] = transformedQuote
	}

	transformedMaxBadRecords, err := expandBigQueryJobConfigurationLoadMaxBadRecords(original["max_bad_records"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMaxBadRecords); val.IsValid() && !isEmptyValue(val) {
		transformed["maxBadRecords"] = transformedMaxBadRecords
	}

	transformedAllowQuotedNewlines, err := expandBigQueryJobConfigurationLoadAllowQuotedNewlines(original["allow_quoted_newlines"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowQuotedNewlines); val.IsValid() && !isEmptyValue(val) {
		transformed["allowQuotedNewlines"] = transformedAllowQuotedNewlines
	}

	transformedSourceFormat, err := expandBigQueryJobConfigurationLoadSourceFormat(original["source_format"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSourceFormat); val.IsValid() && !isEmptyValue(val) {
		transformed["sourceFormat"] = transformedSourceFormat
	}

	transformedAllowJaggedRows, err := expandBigQueryJobConfigurationLoadAllowJaggedRows(original["allow_jagged_rows"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowJaggedRows); val.IsValid() && !isEmptyValue(val) {
		transformed["allowJaggedRows"] = transformedAllowJaggedRows
	}

	transformedIgnoreUnknownValues, err := expandBigQueryJobConfigurationLoadIgnoreUnknownValues(original["ignore_unknown_values"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedIgnoreUnknownValues); val.IsValid() && !isEmptyValue(val) {
		transformed["ignoreUnknownValues"] = transformedIgnoreUnknownValues
	}

	transformedProjectionFields, err := expandBigQueryJobConfigurationLoadProjectionFields(original["projection_fields"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedProjectionFields); val.IsValid() && !isEmptyValue(val) {
		transformed["projectionFields"] = transformedProjectionFields
	}

	transformedAutodetect, err := expandBigQueryJobConfigurationLoadAutodetect(original["autodetect"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAutodetect); val.IsValid() && !isEmptyValue(val) {
		transformed["autodetect"] = transformedAutodetect
	}

	transformedSchemaUpdateOptions, err := expandBigQueryJobConfigurationLoadSchemaUpdateOptions(original["schema_update_options"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSchemaUpdateOptions); val.IsValid() && !isEmptyValue(val) {
		transformed["schemaUpdateOptions"] = transformedSchemaUpdateOptions
	}

	transformedTimePartitioning, err := expandBigQueryJobConfigurationLoadTimePartitioning(original["time_partitioning"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTimePartitioning); val.IsValid() && !isEmptyValue(val) {
		transformed["timePartitioning"] = transformedTimePartitioning
	}

	transformedDestinationEncryptionConfiguration, err := expandBigQueryJobConfigurationLoadDestinationEncryptionConfiguration(original["destination_encryption_configuration"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDestinationEncryptionConfiguration); val.IsValid() && !isEmptyValue(val) {
		transformed["destinationEncryptionConfiguration"] = transformedDestinationEncryptionConfiguration
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationLoadSourceUris(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadDestinationTable(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedProjectId := original["project_id"]
	if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
		transformed["projectId"] = transformedProjectId
	}

	transformedDatasetId := original["dataset_id"]
	if val := reflect.ValueOf(transformedDatasetId); val.IsValid() && !isEmptyValue(val) {
		transformed["datasetId"] = transformedDatasetId
	}

	transformedTableId := original["table_id"]
	if val := reflect.ValueOf(transformedTableId); val.IsValid() && !isEmptyValue(val) {
		transformed["tableId"] = transformedTableId
	}

	if parts := bigqueryTableRegexp.FindStringSubmatch(transformedTableId.(string)); parts != nil {
		transformed["projectId"] = parts[1]
		transformed["datasetId"] = parts[2]
		transformed["tableId"] = parts[3]
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationLoadCreateDisposition(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadWriteDisposition(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadNullMarker(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadFieldDelimiter(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadSkipLeadingRows(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadEncoding(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadQuote(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadMaxBadRecords(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadAllowQuotedNewlines(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadSourceFormat(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadAllowJaggedRows(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadIgnoreUnknownValues(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadProjectionFields(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadAutodetect(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadSchemaUpdateOptions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadTimePartitioning(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedType, err := expandBigQueryJobConfigurationLoadTimePartitioningType(original["type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedType); val.IsValid() && !isEmptyValue(val) {
		transformed["type"] = transformedType
	}

	transformedExpirationMs, err := expandBigQueryJobConfigurationLoadTimePartitioningExpirationMs(original["expiration_ms"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExpirationMs); val.IsValid() && !isEmptyValue(val) {
		transformed["expirationMs"] = transformedExpirationMs
	}

	transformedField, err := expandBigQueryJobConfigurationLoadTimePartitioningField(original["field"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedField); val.IsValid() && !isEmptyValue(val) {
		transformed["field"] = transformedField
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationLoadTimePartitioningType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadTimePartitioningExpirationMs(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadTimePartitioningField(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationLoadDestinationEncryptionConfiguration(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedKmsKeyName, err := expandBigQueryJobConfigurationLoadDestinationEncryptionConfigurationKmsKeyName(original["kms_key_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedKmsKeyName); val.IsValid() && !isEmptyValue(val) {
		transformed["kmsKeyName"] = transformedKmsKeyName
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationLoadDestinationEncryptionConfigurationKmsKeyName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationCopy(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedSourceTables, err := expandBigQueryJobConfigurationCopySourceTables(original["source_tables"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSourceTables); val.IsValid() && !isEmptyValue(val) {
		transformed["sourceTables"] = transformedSourceTables
	}

	transformedDestinationTable, err := expandBigQueryJobConfigurationCopyDestinationTable(original["destination_table"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDestinationTable); val.IsValid() && !isEmptyValue(val) {
		transformed["destinationTable"] = transformedDestinationTable
	}

	transformedCreateDisposition, err := expandBigQueryJobConfigurationCopyCreateDisposition(original["create_disposition"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCreateDisposition); val.IsValid() && !isEmptyValue(val) {
		transformed["createDisposition"] = transformedCreateDisposition
	}

	transformedWriteDisposition, err := expandBigQueryJobConfigurationCopyWriteDisposition(original["write_disposition"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWriteDisposition); val.IsValid() && !isEmptyValue(val) {
		transformed["writeDisposition"] = transformedWriteDisposition
	}

	transformedDestinationEncryptionConfiguration, err := expandBigQueryJobConfigurationCopyDestinationEncryptionConfiguration(original["destination_encryption_configuration"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDestinationEncryptionConfiguration); val.IsValid() && !isEmptyValue(val) {
		transformed["destinationEncryptionConfiguration"] = transformedDestinationEncryptionConfiguration
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationCopySourceTables(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedProjectId := original["project_id"]
		if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
			transformed["projectId"] = transformedProjectId
		}

		transformedDatasetId := original["dataset_id"]
		if val := reflect.ValueOf(transformedDatasetId); val.IsValid() && !isEmptyValue(val) {
			transformed["datasetId"] = transformedDatasetId
		}

		transformedTableId := original["table_id"]
		if val := reflect.ValueOf(transformedTableId); val.IsValid() && !isEmptyValue(val) {
			transformed["tableId"] = transformedTableId
		}

		tableRef := regexp.MustCompile("projects/(.+)/datasets/(.+)/tables/(.+)")
		if parts := tableRef.FindStringSubmatch(transformedTableId.(string)); parts != nil {
			transformed["projectId"] = parts[1]
			transformed["datasetId"] = parts[2]
			transformed["tableId"] = parts[3]
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandBigQueryJobConfigurationCopyDestinationTable(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedProjectId := original["project_id"]
	if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
		transformed["projectId"] = transformedProjectId
	}

	transformedDatasetId := original["dataset_id"]
	if val := reflect.ValueOf(transformedDatasetId); val.IsValid() && !isEmptyValue(val) {
		transformed["datasetId"] = transformedDatasetId
	}

	transformedTableId := original["table_id"]
	if val := reflect.ValueOf(transformedTableId); val.IsValid() && !isEmptyValue(val) {
		transformed["tableId"] = transformedTableId
	}

	if parts := bigqueryTableRegexp.FindStringSubmatch(transformedTableId.(string)); parts != nil {
		transformed["projectId"] = parts[1]
		transformed["datasetId"] = parts[2]
		transformed["tableId"] = parts[3]
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationCopyCreateDisposition(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationCopyWriteDisposition(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationCopyDestinationEncryptionConfiguration(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedKmsKeyName, err := expandBigQueryJobConfigurationCopyDestinationEncryptionConfigurationKmsKeyName(original["kms_key_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedKmsKeyName); val.IsValid() && !isEmptyValue(val) {
		transformed["kmsKeyName"] = transformedKmsKeyName
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationCopyDestinationEncryptionConfigurationKmsKeyName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationExtract(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedDestinationUris, err := expandBigQueryJobConfigurationExtractDestinationUris(original["destination_uris"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDestinationUris); val.IsValid() && !isEmptyValue(val) {
		transformed["destinationUris"] = transformedDestinationUris
	}

	transformedPrintHeader, err := expandBigQueryJobConfigurationExtractPrintHeader(original["print_header"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPrintHeader); val.IsValid() && !isEmptyValue(val) {
		transformed["printHeader"] = transformedPrintHeader
	}

	transformedFieldDelimiter, err := expandBigQueryJobConfigurationExtractFieldDelimiter(original["field_delimiter"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFieldDelimiter); val.IsValid() && !isEmptyValue(val) {
		transformed["fieldDelimiter"] = transformedFieldDelimiter
	}

	transformedDestinationFormat, err := expandBigQueryJobConfigurationExtractDestinationFormat(original["destination_format"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDestinationFormat); val.IsValid() && !isEmptyValue(val) {
		transformed["destinationFormat"] = transformedDestinationFormat
	}

	transformedCompression, err := expandBigQueryJobConfigurationExtractCompression(original["compression"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCompression); val.IsValid() && !isEmptyValue(val) {
		transformed["compression"] = transformedCompression
	}

	transformedUseAvroLogicalTypes, err := expandBigQueryJobConfigurationExtractUseAvroLogicalTypes(original["use_avro_logical_types"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUseAvroLogicalTypes); val.IsValid() && !isEmptyValue(val) {
		transformed["useAvroLogicalTypes"] = transformedUseAvroLogicalTypes
	}

	transformedSourceTable, err := expandBigQueryJobConfigurationExtractSourceTable(original["source_table"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSourceTable); val.IsValid() && !isEmptyValue(val) {
		transformed["sourceTable"] = transformedSourceTable
	}

	transformedSourceModel, err := expandBigQueryJobConfigurationExtractSourceModel(original["source_model"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSourceModel); val.IsValid() && !isEmptyValue(val) {
		transformed["sourceModel"] = transformedSourceModel
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationExtractDestinationUris(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationExtractPrintHeader(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationExtractFieldDelimiter(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationExtractDestinationFormat(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationExtractCompression(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationExtractUseAvroLogicalTypes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationExtractSourceTable(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedProjectId := original["project_id"]
	if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
		transformed["projectId"] = transformedProjectId
	}

	transformedDatasetId := original["dataset_id"]
	if val := reflect.ValueOf(transformedDatasetId); val.IsValid() && !isEmptyValue(val) {
		transformed["datasetId"] = transformedDatasetId
	}

	transformedTableId := original["table_id"]
	if val := reflect.ValueOf(transformedTableId); val.IsValid() && !isEmptyValue(val) {
		transformed["tableId"] = transformedTableId
	}

	if parts := bigqueryTableRegexp.FindStringSubmatch(transformedTableId.(string)); parts != nil {
		transformed["projectId"] = parts[1]
		transformed["datasetId"] = parts[2]
		transformed["tableId"] = parts[3]
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationExtractSourceModel(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedProjectId, err := expandBigQueryJobConfigurationExtractSourceModelProjectId(original["project_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
		transformed["projectId"] = transformedProjectId
	}

	transformedDatasetId, err := expandBigQueryJobConfigurationExtractSourceModelDatasetId(original["dataset_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDatasetId); val.IsValid() && !isEmptyValue(val) {
		transformed["datasetId"] = transformedDatasetId
	}

	transformedModelId, err := expandBigQueryJobConfigurationExtractSourceModelModelId(original["model_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedModelId); val.IsValid() && !isEmptyValue(val) {
		transformed["modelId"] = transformedModelId
	}

	return transformed, nil
}

func expandBigQueryJobConfigurationExtractSourceModelProjectId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationExtractSourceModelDatasetId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobConfigurationExtractSourceModelModelId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobJobReference(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	transformed := make(map[string]interface{})
	transformedJobId, err := expandBigQueryJobJobReferenceJobId(d.Get("job_id"), d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedJobId); val.IsValid() && !isEmptyValue(val) {
		transformed["jobId"] = transformedJobId
	}

	transformedLocation, err := expandBigQueryJobJobReferenceLocation(d.Get("location"), d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLocation); val.IsValid() && !isEmptyValue(val) {
		transformed["location"] = transformedLocation
	}

	return transformed, nil
}

func expandBigQueryJobJobReferenceJobId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigQueryJobJobReferenceLocation(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func resourceBigQueryJobEncoder(d *schema.ResourceData, meta interface{}, obj map[string]interface{}) (map[string]interface{}, error) {
	project, err := getProject(d, meta.(*Config))
	if err != nil {
		return nil, err
	}
	obj["jobReference"].(map[string]interface{})["project"] = project
	return obj, nil
}
