/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.samtools.util.DateParser;

public class Iso8601Date
extends Date {
    private static final ThreadLocal<DateFormat> iso8601DateFormatter = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        }
    };

    public Iso8601Date(String dateStr) {
        super(DateParser.parse(dateStr).getTime());
        this.truncateMilliseconds();
    }

    public Iso8601Date(Date date) {
        super(date.getTime());
        this.truncateMilliseconds();
    }

    @Override
    public String toString() {
        return iso8601DateFormatter.get().format(this);
    }

    private void truncateMilliseconds() {
        long time = this.getTime();
        long mod = time % 1000L;
        if (mod != 0L) {
            super.setTime(time - mod);
        }
    }
}

