/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UIManager
implements Serializable {
    private static final long serialVersionUID = -5547433830339189365L;
    static LookAndFeelInfo[] installed = new LookAndFeelInfo[]{new LookAndFeelInfo("Metal", "javax.swing.plaf.metal.MetalLookAndFeel")};
    static LookAndFeel[] auxLookAndFeels;
    static LookAndFeel currentLookAndFeel;
    static UIDefaults currentUIDefaults;
    static SwingPropertyChangeSupport listeners;
    static /* synthetic */ Class class$javax$swing$UIManager;

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        listeners.addPropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
        listeners.removePropertyChangeListener(listener);
    }

    public static PropertyChangeListener[] getPropertyChangeListeners() {
        return listeners.getPropertyChangeListeners();
    }

    public static void addAuxiliaryLookAndFeel(LookAndFeel laf) {
        if (laf == null) {
            throw new NullPointerException("Null 'laf' argument.");
        }
        if (auxLookAndFeels == null) {
            auxLookAndFeels = new LookAndFeel[1];
            UIManager.auxLookAndFeels[0] = laf;
            return;
        }
        LookAndFeel[] temp = new LookAndFeel[auxLookAndFeels.length + 1];
        System.arraycopy(auxLookAndFeels, 0, temp, 0, auxLookAndFeels.length);
        auxLookAndFeels = temp;
        UIManager.auxLookAndFeels[UIManager.auxLookAndFeels.length - 1] = laf;
    }

    public static boolean removeAuxiliaryLookAndFeel(LookAndFeel laf) {
        if (auxLookAndFeels == null) {
            return false;
        }
        int count = auxLookAndFeels.length;
        if (count == 1 && auxLookAndFeels[0] == laf) {
            auxLookAndFeels = null;
            return true;
        }
        int i = 0;
        while (i < count) {
            if (auxLookAndFeels[i] == laf) {
                LookAndFeel[] temp = new LookAndFeel[auxLookAndFeels.length - 1];
                if (i == 0) {
                    System.arraycopy(auxLookAndFeels, 1, temp, 0, count - 1);
                } else if (i == count - 1) {
                    System.arraycopy(auxLookAndFeels, 0, temp, 0, count - 1);
                } else {
                    System.arraycopy(auxLookAndFeels, 0, temp, 0, i);
                    System.arraycopy(auxLookAndFeels, i + 1, temp, i, count - i - 1);
                }
                auxLookAndFeels = temp;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static LookAndFeel[] getAuxiliaryLookAndFeels() {
        return auxLookAndFeels;
    }

    public static Object get(Object key) {
        return UIManager.getLookAndFeelDefaults().get(key);
    }

    public static Object get(Object key, Locale locale) {
        return UIManager.getLookAndFeelDefaults().get(key, locale);
    }

    public static boolean getBoolean(Object key) {
        Boolean value = (Boolean)UIManager.getLookAndFeelDefaults().get(key);
        boolean bl = false;
        if (value != null) {
            bl = value;
        }
        return bl;
    }

    public static boolean getBoolean(Object key, Locale locale) {
        Boolean value = (Boolean)UIManager.getLookAndFeelDefaults().get(key, locale);
        boolean bl = false;
        if (value != null) {
            bl = value;
        }
        return bl;
    }

    public static Border getBorder(Object key) {
        return (Border)UIManager.getLookAndFeelDefaults().get(key);
    }

    public static Border getBorder(Object key, Locale locale) {
        return (Border)UIManager.getLookAndFeelDefaults().get(key, locale);
    }

    public static Color getColor(Object key) {
        return (Color)UIManager.getLookAndFeelDefaults().get(key);
    }

    public static Color getColor(Object key, Locale locale) {
        return (Color)UIManager.getLookAndFeelDefaults().get(key);
    }

    public static String getCrossPlatformLookAndFeelClassName() {
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    public static UIDefaults getDefaults() {
        return currentUIDefaults;
    }

    public static Dimension getDimension(Object key) {
        return (Dimension)UIManager.getLookAndFeelDefaults().get(key);
    }

    public static Dimension getDimension(Object key, Locale locale) {
        return (Dimension)UIManager.getLookAndFeelDefaults().get(key, locale);
    }

    public static Font getFont(Object key) {
        return (Font)UIManager.getLookAndFeelDefaults().get(key);
    }

    public static Font getFont(Object key, Locale locale) {
        return (Font)UIManager.getLookAndFeelDefaults().get(key, locale);
    }

    public static Icon getIcon(Object key) {
        return (Icon)UIManager.getLookAndFeelDefaults().get(key);
    }

    public static Icon getIcon(Object key, Locale locale) {
        return (Icon)UIManager.getLookAndFeelDefaults().get(key, locale);
    }

    public static Insets getInsets(Object key) {
        return UIManager.getLookAndFeelDefaults().getInsets(key);
    }

    public static Insets getInsets(Object key, Locale locale) {
        return UIManager.getLookAndFeelDefaults().getInsets(key, locale);
    }

    public static LookAndFeelInfo[] getInstalledLookAndFeels() {
        return installed;
    }

    public static int getInt(Object key) {
        Integer x = (Integer)UIManager.getLookAndFeelDefaults().get(key);
        if (x == null) {
            return 0;
        }
        return x;
    }

    public static int getInt(Object key, Locale locale) {
        Integer x = (Integer)UIManager.getLookAndFeelDefaults().get(key, locale);
        if (x == null) {
            return 0;
        }
        return x;
    }

    public static LookAndFeel getLookAndFeel() {
        return currentLookAndFeel;
    }

    public static UIDefaults getLookAndFeelDefaults() {
        return currentUIDefaults;
    }

    public static String getString(Object key) {
        return (String)UIManager.getLookAndFeelDefaults().get(key);
    }

    public static String getString(Object key, Locale locale) {
        return (String)UIManager.getLookAndFeelDefaults().get(key, locale);
    }

    public static String getSystemLookAndFeelClassName() {
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static ComponentUI getUI(JComponent target) {
        return UIManager.getLookAndFeelDefaults().getUI(target);
    }

    public static void installLookAndFeel(String name, String className) {
        UIManager.installLookAndFeel(new LookAndFeelInfo(name, className));
    }

    public static void installLookAndFeel(LookAndFeelInfo info) {
    }

    public static Object put(Object key, Object value) {
        return UIManager.getLookAndFeelDefaults().put(key, value);
    }

    public static void setInstalledLookAndFeels(LookAndFeelInfo[] infos) {
    }

    public static void setLookAndFeel(LookAndFeel newLookAndFeel) throws UnsupportedLookAndFeelException {
        if (newLookAndFeel != null && !newLookAndFeel.isSupportedLookAndFeel()) {
            throw new UnsupportedLookAndFeelException(newLookAndFeel.getName());
        }
        LookAndFeel oldLookAndFeel = currentLookAndFeel;
        if (oldLookAndFeel != null) {
            oldLookAndFeel.uninitialize();
        }
        currentLookAndFeel = newLookAndFeel;
        if (newLookAndFeel != null) {
            newLookAndFeel.initialize();
            currentUIDefaults = newLookAndFeel.getDefaults();
        } else {
            currentUIDefaults = null;
        }
        listeners.firePropertyChange("lookAndFeel", oldLookAndFeel, newLookAndFeel);
    }

    public static void setLookAndFeel(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        Class c = Class.forName(className);
        LookAndFeel a = (LookAndFeel)c.newInstance();
        UIManager.setLookAndFeel(a);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$javax$swing$UIManager;
        if (clazz == null) {
            clazz = class$javax$swing$UIManager = UIManager.class("[Ljavax.swing.UIManager;", false);
        }
        listeners = new SwingPropertyChangeSupport(clazz);
        String defaultlaf = System.getProperty("swing.defaultlaf");
        try {
            if (defaultlaf != null) {
                Class lafClass = Class.forName(defaultlaf);
                LookAndFeel laf = (LookAndFeel)lafClass.newInstance();
                UIManager.setLookAndFeel(laf);
            } else {
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            }
        }
        catch (Exception ex) {
            System.err.println("cannot initialize Look and Feel: " + defaultlaf);
            System.err.println("error: " + ex.toString());
            System.err.println("falling back to Metal Look and Feel");
            try {
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            }
            catch (Exception ex2) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"There must be no problem installing the MetalLookAndFeel."))).initCause(ex2);
            }
        }
    }

    public static class LookAndFeelInfo {
        String name;
        String clazz;

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.clazz;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append(this.getClass().getName());
            s.append('[');
            s.append(this.getName());
            s.append(' ');
            s.append(this.getClassName());
            s.append(']');
            return s.toString();
        }

        public LookAndFeelInfo(String name, String clazz) {
            this.name = name;
            this.clazz = clazz;
        }
    }
}

