package Crypt::HSXKPasswd::Dictionary::FR;

use parent Crypt::HSXKPasswd::Dictionary;

# NOTE:
# -----
# This module was Auto-generated at 2015-06-07T19:39:39Z by
# Crypt::HSXKPasswd::Util->dictionary_from_text_file()

# import required modules
use strict;
use warnings;
use English qw( -no_match_vars ); # for more readable code
use Fatal qw( :void open close binmode ); # make builtins throw exceptions on failure
use Readonly; # for truly constant constants

# HSXKPasswd stuff
use Crypt::HSXKPasswd::Helper;

# set things up for using UTF-8
use 5.016; # min Perl for good UTF-8 support, implies feature 'unicode_strings'
use Encode qw(encode decode);
use utf8;
binmode STDOUT, ':encoding(UTF-8)';

#
# === Constants ===============================================================#
#

# version info
use version; our $VERSION = qv('3.002_001');

# utility constants
Readonly my $_CLASS => 'Crypt::HSXKPasswd::Dictionary::FR';

# the word list
my @_WORDS = ( ## no critic (ProhibitQuotedWordLists)
    'Antéchrist',
    'Antéchrists',
    'Brest',
    'Escalator',
    'Escalators',
    'Esquimau',
    'Esquimaude',
    'Esquimaudes',
    'Esquimaux',
    'Frédéric',
    'GUTenberg',
    'Hygiaphone',
    'Hygiaphones',
    'ISPELL',
    'Internet',
    'JAEA',
    'Joliot',
    'Labview',
    'Lakanal',
    'Land',
    'Länder',
    'MJSAM',
    'Mach',
    'Martini',
    'Melba',
    'Minitel',
    'Minitels',
    'Monotype',
    'Monotypes',
    'Moviola',
    'Moviolas',
    'Napoléon',
    'Noël',
    'Noëls',
    'Orlon',
    'PCSI',
    'Polaroïd',
    'Polaroïds',
    'Pédalo',
    'Pédalos',
    'Pître',
    'Quasimodo',
    'Quasimodos',
    'Rhodia',
    'Rhovyl',
    'Rilsan',
    'Rimmel',
    'Rimmels',
    'Ripolin',
    'Ripolins',
    'Ronéo',
    'Ronéos',
    'Sandow',
    'Sandows',
    'Scotch',
    'Scotchs',
    'Scrabble',
    'Scrabbles',
    'Skaï',
    'Skaïs',
    'TOEIC',
    'Tartempion',
    'Taxiphone',
    'Taxiphones',
    'Technicolor',
    'Tergal',
    'Tergals',
    'Toussaint',
    'Triplex',
    'Téflon',
    'Téflons',
    'Vespa',
    'Vespas',
    'Volucompteur',
    'Véda',
    'Védas',
    'Walkman',
    'Walkmans',
    'abaissa',
    'abaissable',
    'abaissables',
    'abaissai',
    'abaissaient',
    'abaissais',
    'abaissait',
    'abaissant',
    'abaissante',
    'abaissantes',
    'abaissants',
    'abaissas',
    'abaissasse',
    'abaissassent',
    'abaissasses',
    'abaissassiez',
    'abaisse',
    'abaissement',
    'abaissements',
    'abaissent',
    'abaisser',
    'abaissera',
    'abaisserai',
    'abaisserais',
    'abaisserait',
    'abaisseras',
    'abaisserez',
    'abaisseriez',
    'abaisserions',
    'abaisserons',
    'abaisseront',
    'abaisses',
    'abaisseur',
    'abaisseurs',
    'abaissez',
    'abaissiez',
    'abaissions',
    'abaissons',
    'abaissâmes',
    'abaissât',
    'abaissâtes',
    'abaissèrent',
    'abaissé',
    'abaissée',
    'abaissées',
    'abaissés',
    'abajoue',
    'abajoues',
    'abandon',
    'abandonna',
    'abandonnai',
    'abandonnais',
    'abandonnait',
    'abandonnant',
    'abandonnas',
    'abandonnasse',
    'abandonne',
    'abandonnent',
    'abandonner',
    'abandonnera',
    'abandonnerai',
    'abandonneras',
    'abandonnerez',
    'abandonnes',
    'abandonnez',
    'abandonniez',
    'abandonnions',
    'abandonnons',
    'abandonnâmes',
    'abandonnât',
    'abandonnâtes',
    'abandonné',
    'abandonnée',
    'abandonnées',
    'abandonnés',
    'abandons',
    'abaque',
    'abaques',
    'abaqus',
    'abarrou',
    'abasourdi',
    'abasourdie',
    'abasourdies',
    'abasourdir',
    'abasourdira',
    'abasourdirai',
    'abasourdiras',
    'abasourdirez',
    'abasourdis',
    'abasourdisse',
    'abasourdit',
    'abasourdîmes',
    'abasourdît',
    'abasourdîtes',
    'abat',
    'abatage',
    'abatages',
    'abats',
    'abattage',
    'abattages',
    'abattaient',
    'abattais',
    'abattait',
    'abattant',
    'abattante',
    'abattantes',
    'abattants',
    'abatte',
    'abattement',
    'abattements',
    'abattent',
    'abattes',
    'abatteur',
    'abatteurs',
    'abattez',
    'abattiez',
    'abattions',
    'abattirent',
    'abattis',
    'abattisse',
    'abattissent',
    'abattisses',
    'abattissiez',
    'abattissions',
    'abattit',
    'abattoir',
    'abattoirs',
    'abattons',
    'abattra',
    'abattrai',
    'abattraient',
    'abattrais',
    'abattrait',
    'abattras',
    'abattre',
    'abattrez',
    'abattriez',
    'abattrions',
    'abattrons',
    'abattront',
    'abattu',
    'abattue',
    'abattues',
    'abattus',
    'abattée',
    'abattées',
    'abattîmes',
    'abattît',
    'abattîtes',
    'abatée',
    'abatées',
    'abbatial',
    'abbatiale',
    'abbatiales',
    'abbatiaux',
    'abbaye',
    'abbayes',
    'abbesse',
    'abbesses',
    'abbevillien',
    'abbevilliens',
    'abbé',
    'abbés',
    'abcès',
    'abcéder',
    'abdicataire',
    'abdicataires',
    'abdication',
    'abdications',
    'abdiqua',
    'abdiquai',
    'abdiquaient',
    'abdiquais',
    'abdiquait',
    'abdiquant',
    'abdiquas',
    'abdiquasse',
    'abdiquassent',
    'abdiquasses',
    'abdiquassiez',
    'abdique',
    'abdiquent',
    'abdiquer',
    'abdiquera',
    'abdiquerai',
    'abdiquerais',
    'abdiquerait',
    'abdiqueras',
    'abdiquerez',
    'abdiqueriez',
    'abdiquerions',
    'abdiquerons',
    'abdiqueront',
    'abdiques',
    'abdiquez',
    'abdiquiez',
    'abdiquions',
    'abdiquons',
    'abdiquâmes',
    'abdiquât',
    'abdiquâtes',
    'abdiquèrent',
    'abdiqué',
    'abdiquée',
    'abdiquées',
    'abdiqués',
    'abdomen',
    'abdomens',
    'abdominal',
    'abdominale',
    'abdominales',
    'abdominaux',
    'abducteur',
    'abducteurs',
    'abduction',
    'abductions',
    'abeille',
    'abeilles',
    'aberra',
    'aberrai',
    'aberraient',
    'aberrais',
    'aberrait',
    'aberrance',
    'aberrances',
    'aberrant',
    'aberrante',
    'aberrantes',
    'aberrants',
    'aberras',
    'aberrasse',
    'aberrassent',
    'aberrasses',
    'aberrassiez',
    'aberrassions',
    'aberration',
    'aberrations',
    'aberre',
    'aberrent',
    'aberrer',
    'aberrera',
    'aberrerai',
    'aberreraient',
    'aberrerais',
    'aberrerait',
    'aberreras',
    'aberrerez',
    'aberreriez',
    'aberrerions',
    'aberrerons',
    'aberreront',
    'aberres',
    'aberrez',
    'aberriez',
    'aberrions',
    'aberrons',
    'aberrâmes',
    'aberrât',
    'aberrâtes',
    'aberrèrent',
    'aberré',
    'abhorra',
    'abhorrai',
    'abhorraient',
    'abhorrais',
    'abhorrait',
    'abhorrant',
    'abhorras',
    'abhorrasse',
    'abhorrassent',
    'abhorrasses',
    'abhorrassiez',
    'abhorre',
    'abhorrent',
    'abhorrer',
    'abhorrera',
    'abhorrerai',
    'abhorrerais',
    'abhorrerait',
    'abhorreras',
    'abhorrerez',
    'abhorreriez',
    'abhorrerions',
    'abhorrerons',
    'abhorreront',
    'abhorres',
    'abhorrez',
    'abhorriez',
    'abhorrions',
    'abhorrons',
    'abhorrâmes',
    'abhorrât',
    'abhorrâtes',
    'abhorrèrent',
    'abhorré',
    'abhorrée',
    'abhorrées',
    'abhorrés',
    'abiotique',
    'abiotiques',
    'abject',
    'abjecte',
    'abjectement',
    'abjectes',
    'abjection',
    'abjections',
    'abjects',
    'abjura',
    'abjurai',
    'abjuraient',
    'abjurais',
    'abjurait',
    'abjurant',
    'abjuras',
    'abjurasse',
    'abjurassent',
    'abjurasses',
    'abjurassiez',
    'abjurassions',
    'abjuration',
    'abjurations',
    'abjure',
    'abjurent',
    'abjurer',
    'abjurera',
    'abjurerai',
    'abjureraient',
    'abjurerais',
    'abjurerait',
    'abjureras',
    'abjurerez',
    'abjureriez',
    'abjurerions',
    'abjurerons',
    'abjureront',
    'abjures',
    'abjurez',
    'abjuriez',
    'abjurions',
    'abjurons',
    'abjurâmes',
    'abjurât',
    'abjurâtes',
    'abjurèrent',
    'abjuré',
    'abjurée',
    'abjurées',
    'abjurés',
    'ablater',
    'ablatif',
    'ablatifs',
    'ablation',
    'ablations',
    'ablative',
    'ablatives',
    'ablette',
    'ablettes',
    'abloqua',
    'abloquai',
    'abloquaient',
    'abloquais',
    'abloquait',
    'abloquant',
    'abloquas',
    'abloquasse',
    'abloquassent',
    'abloquasses',
    'abloquassiez',
    'abloque',
    'abloquent',
    'abloquer',
    'abloquera',
    'abloquerai',
    'abloquerais',
    'abloquerait',
    'abloqueras',
    'abloquerez',
    'abloqueriez',
    'abloquerions',
    'abloquerons',
    'abloqueront',
    'abloques',
    'abloquez',
    'abloquiez',
    'abloquions',
    'abloquons',
    'abloquâmes',
    'abloquât',
    'abloquâtes',
    'abloquèrent',
    'abloqué',
    'abloquée',
    'abloquées',
    'abloqués',
    'ablution',
    'ablutions',
    'ablégat',
    'ablégats',
    'abnégation',
    'abnégations',
    'aboi',
    'aboie',
    'aboiement',
    'aboiements',
    'aboient',
    'aboiera',
    'aboierai',
    'aboieraient',
    'aboierais',
    'aboierait',
    'aboieras',
    'aboierez',
    'aboieriez',
    'aboierions',
    'aboierons',
    'aboieront',
    'aboies',
    'abois',
    'aboli',
    'abolie',
    'abolies',
    'abolir',
    'abolira',
    'abolirai',
    'aboliraient',
    'abolirais',
    'abolirait',
    'aboliras',
    'abolirent',
    'abolirez',
    'aboliriez',
    'abolirions',
    'abolirons',
    'aboliront',
    'abolis',
    'abolissaient',
    'abolissais',
    'abolissait',
    'abolissant',
    'abolisse',
    'abolissent',
    'abolisses',
    'abolissez',
    'abolissiez',
    'abolissions',
    'abolissons',
    'abolit',
    'abolition',
    'abolitions',
    'abolîmes',
    'abolît',
    'abolîtes',
    'abomina',
    'abominable',
    'abominables',
    'abominai',
    'abominaient',
    'abominais',
    'abominait',
    'abominant',
    'abominas',
    'abominasse',
    'abominassent',
    'abominasses',
    'abominassiez',
    'abomination',
    'abominations',
    'abomine',
    'abominent',
    'abominer',
    'abominera',
    'abominerai',
    'abominerais',
    'abominerait',
    'abomineras',
    'abominerez',
    'abomineriez',
    'abominerions',
    'abominerons',
    'abomineront',
    'abomines',
    'abominez',
    'abominiez',
    'abominions',
    'abominons',
    'abominâmes',
    'abominât',
    'abominâtes',
    'abominèrent',
    'abominé',
    'abominée',
    'abominées',
    'abominés',
    'abonda',
    'abondai',
    'abondaient',
    'abondais',
    'abondait',
    'abondamment',
    'abondance',
    'abondances',
    'abondanciste',
    'abondant',
    'abondante',
    'abondantes',
    'abondants',
    'abondas',
    'abondasse',
    'abondassent',
    'abondasses',
    'abondassiez',
    'abondassions',
    'abonde',
    'abondent',
    'abonder',
    'abondera',
    'abonderai',
    'abonderaient',
    'abonderais',
    'abonderait',
    'abonderas',
    'abonderez',
    'abonderiez',
    'abonderions',
    'abonderons',
    'abonderont',
    'abondes',
    'abondez',
    'abondiez',
    'abondions',
    'abondons',
    'abondâmes',
    'abondât',
    'abondâtes',
    'abondèrent',
    'abondé',
    'abonna',
    'abonnai',
    'abonnaient',
    'abonnais',
    'abonnait',
    'abonnant',
    'abonnas',
    'abonnasse',
    'abonnassent',
    'abonnasses',
    'abonnassiez',
    'abonnassions',
    'abonne',
    'abonnement',
    'abonnements',
    'abonnent',
    'abonner',
    'abonnera',
    'abonnerai',
    'abonneraient',
    'abonnerais',
    'abonnerait',
    'abonneras',
    'abonnerez',
    'abonneriez',
    'abonnerions',
    'abonnerons',
    'abonneront',
    'abonnes',
    'abonnez',
    'abonni',
    'abonnie',
    'abonnies',
    'abonniez',
    'abonnions',
    'abonnir',
    'abonnira',
    'abonnirai',
    'abonniraient',
    'abonnirais',
    'abonnirait',
    'abonniras',
    'abonnirent',
    'abonnirez',
    'abonniriez',
    'abonnirions',
    'abonnirons',
    'abonniront',
    'abonnis',
    'abonnissais',
    'abonnissait',
    'abonnissant',
    'abonnisse',
    'abonnissent',
    'abonnisses',
    'abonnissez',
    'abonnissiez',
    'abonnissions',
    'abonnissons',
    'abonnit',
    'abonnons',
    'abonnâmes',
    'abonnât',
    'abonnâtes',
    'abonnèrent',
    'abonné',
    'abonnée',
    'abonnées',
    'abonnés',
    'abonnîmes',
    'abonnît',
    'abonnîtes',
    'abord',
    'aborda',
    'abordable',
    'abordables',
    'abordage',
    'abordages',
    'abordai',
    'abordaient',
    'abordais',
    'abordait',
    'abordant',
    'abordas',
    'abordasse',
    'abordassent',
    'abordasses',
    'abordassiez',
    'abordassions',
    'aborde',
    'abordent',
    'aborder',
    'abordera',
    'aborderai',
    'aborderaient',
    'aborderais',
    'aborderait',
    'aborderas',
    'aborderez',
    'aborderiez',
    'aborderions',
    'aborderons',
    'aborderont',
    'abordes',
    'abordez',
    'abordiez',
    'abordions',
    'abordons',
    'abords',
    'abordâmes',
    'abordât',
    'abordâtes',
    'abordèrent',
    'abordé',
    'abordée',
    'abordées',
    'abordés',
    'aborigène',
    'aborigènes',
    'abortif',
    'abortifs',
    'abortive',
    'abortives',
    'abot',
    'abots',
    'aboucha',
    'abouchai',
    'abouchaient',
    'abouchais',
    'abouchait',
    'abouchant',
    'abouchas',
    'abouchasse',
    'abouchassent',
    'abouchasses',
    'abouchassiez',
    'abouche',
    'abouchement',
    'abouchements',
    'abouchent',
    'aboucher',
    'abouchera',
    'aboucherai',
    'aboucherais',
    'aboucherait',
    'aboucheras',
    'aboucherez',
    'aboucheriez',
    'aboucherions',
    'aboucherons',
    'aboucheront',
    'abouches',
    'abouchez',
    'abouchiez',
    'abouchions',
    'abouchons',
    'abouchâmes',
    'abouchât',
    'abouchâtes',
    'abouchèrent',
    'abouché',
    'abouchée',
    'abouchées',
    'abouchés',
    'aboula',
    'aboulai',
    'aboulaient',
    'aboulais',
    'aboulait',
    'aboulant',
    'aboulas',
    'aboulasse',
    'aboulassent',
    'aboulasses',
    'aboulassiez',
    'aboulassions',
    'aboule',
    'aboulent',
    'abouler',
    'aboulera',
    'aboulerai',
    'abouleraient',
    'aboulerais',
    'aboulerait',
    'abouleras',
    'aboulerez',
    'abouleriez',
    'aboulerions',
    'aboulerons',
    'abouleront',
    'aboules',
    'aboulez',
    'aboulie',
    'aboulies',
    'abouliez',
    'aboulions',
    'aboulique',
    'abouliques',
    'aboulons',
    'aboulâmes',
    'aboulât',
    'aboulâtes',
    'aboulèrent',
    'aboulé',
    'aboulée',
    'aboulées',
    'aboulés',
    'about',
    'abouta',
    'aboutai',
    'aboutaient',
    'aboutais',
    'aboutait',
    'aboutant',
    'aboutas',
    'aboutasse',
    'aboutassent',
    'aboutasses',
    'aboutassiez',
    'aboutassions',
    'aboute',
    'aboutement',
    'aboutements',
    'aboutent',
    'abouter',
    'aboutera',
    'abouterai',
    'abouteraient',
    'abouterais',
    'abouterait',
    'abouteras',
    'abouterez',
    'abouteriez',
    'abouterions',
    'abouterons',
    'abouteront',
    'aboutes',
    'aboutez',
    'abouti',
    'aboutiez',
    'aboutions',
    'aboutir',
    'aboutira',
    'aboutirai',
    'aboutiraient',
    'aboutirais',
    'aboutirait',
    'aboutiras',
    'aboutirent',
    'aboutirez',
    'aboutiriez',
    'aboutirions',
    'aboutirons',
    'aboutiront',
    'aboutis',
    'aboutissais',
    'aboutissait',
    'aboutissant',
    'aboutissants',
    'aboutisse',
    'aboutissent',
    'aboutisses',
    'aboutissez',
    'aboutissiez',
    'aboutissions',
    'aboutissons',
    'aboutit',
    'aboutons',
    'abouts',
    'aboutâmes',
    'aboutât',
    'aboutâtes',
    'aboutèrent',
    'abouté',
    'aboutée',
    'aboutées',
    'aboutés',
    'aboutîmes',
    'aboutît',
    'aboutîtes',
    'aboya',
    'aboyai',
    'aboyaient',
    'aboyais',
    'aboyait',
    'aboyant',
    'aboyas',
    'aboyasse',
    'aboyassent',
    'aboyasses',
    'aboyassiez',
    'aboyassions',
    'aboyer',
    'aboyeur',
    'aboyeurs',
    'aboyeuse',
    'aboyeuses',
    'aboyez',
    'aboyiez',
    'aboyions',
    'aboyons',
    'aboyâmes',
    'aboyât',
    'aboyâtes',
    'aboyèrent',
    'aboyé',
    'aboyée',
    'aboyées',
    'aboyés',
    'abrasa',
    'abrasai',
    'abrasaient',
    'abrasais',
    'abrasait',
    'abrasant',
    'abrasas',
    'abrasasse',
    'abrasassent',
    'abrasasses',
    'abrasassiez',
    'abrasassions',
    'abrase',
    'abrasent',
    'abraser',
    'abrasera',
    'abraserai',
    'abraseraient',
    'abraserais',
    'abraserait',
    'abraseras',
    'abraserez',
    'abraseriez',
    'abraserions',
    'abraserons',
    'abraseront',
    'abrases',
    'abrasez',
    'abrasiez',
    'abrasif',
    'abrasifs',
    'abrasion',
    'abrasions',
    'abrasive',
    'abrasives',
    'abrasons',
    'abrasâmes',
    'abrasât',
    'abrasâtes',
    'abrasèrent',
    'abrasé',
    'abrasée',
    'abrasées',
    'abrasés',
    'abreuva',
    'abreuvai',
    'abreuvaient',
    'abreuvais',
    'abreuvait',
    'abreuvant',
    'abreuvas',
    'abreuvasse',
    'abreuvassent',
    'abreuvasses',
    'abreuvassiez',
    'abreuve',
    'abreuvent',
    'abreuver',
    'abreuvera',
    'abreuverai',
    'abreuverais',
    'abreuverait',
    'abreuveras',
    'abreuverez',
    'abreuveriez',
    'abreuverions',
    'abreuverons',
    'abreuveront',
    'abreuves',
    'abreuvez',
    'abreuviez',
    'abreuvions',
    'abreuvoir',
    'abreuvoirs',
    'abreuvons',
    'abreuvâmes',
    'abreuvât',
    'abreuvâtes',
    'abreuvèrent',
    'abreuvé',
    'abreuvée',
    'abreuvées',
    'abreuvés',
    'abri',
    'abricot',
    'abricota',
    'abricotai',
    'abricotaient',
    'abricotais',
    'abricotait',
    'abricotant',
    'abricotas',
    'abricotasse',
    'abricotasses',
    'abricote',
    'abricotent',
    'abricoter',
    'abricotera',
    'abricoterai',
    'abricoterais',
    'abricoterait',
    'abricoteras',
    'abricoterez',
    'abricoteriez',
    'abricoterons',
    'abricoteront',
    'abricotes',
    'abricotez',
    'abricotier',
    'abricotiers',
    'abricotiez',
    'abricotions',
    'abricotons',
    'abricots',
    'abricotâmes',
    'abricotât',
    'abricotâtes',
    'abricotèrent',
    'abricoté',
    'abricotée',
    'abricotées',
    'abricotés',
    'abris',
    'abrita',
    'abritai',
    'abritaient',
    'abritais',
    'abritait',
    'abritant',
    'abritas',
    'abritasse',
    'abritassent',
    'abritasses',
    'abritassiez',
    'abritassions',
    'abrite',
    'abritent',
    'abriter',
    'abritera',
    'abriterai',
    'abriteraient',
    'abriterais',
    'abriterait',
    'abriteras',
    'abriterez',
    'abriteriez',
    'abriterions',
    'abriterons',
    'abriteront',
    'abrites',
    'abritez',
    'abritiez',
    'abritions',
    'abritons',
    'abritâmes',
    'abritât',
    'abritâtes',
    'abritèrent',
    'abrité',
    'abritée',
    'abritées',
    'abrités',
    'abrivent',
    'abrivents',
    'abrogatif',
    'abrogatifs',
    'abrogation',
    'abrogations',
    'abrogative',
    'abrogatives',
    'abrogatoire',
    'abrogatoires',
    'abroge',
    'abrogea',
    'abrogeable',
    'abrogeables',
    'abrogeai',
    'abrogeaient',
    'abrogeais',
    'abrogeait',
    'abrogeant',
    'abrogeas',
    'abrogeasse',
    'abrogeassent',
    'abrogeasses',
    'abrogeassiez',
    'abrogent',
    'abrogeons',
    'abroger',
    'abrogera',
    'abrogerai',
    'abrogeraient',
    'abrogerais',
    'abrogerait',
    'abrogeras',
    'abrogerez',
    'abrogeriez',
    'abrogerions',
    'abrogerons',
    'abrogeront',
    'abroges',
    'abrogez',
    'abrogeâmes',
    'abrogeât',
    'abrogeâtes',
    'abrogiez',
    'abrogions',
    'abrogèrent',
    'abrogé',
    'abrogée',
    'abrogées',
    'abrogés',
    'abrupt',
    'abrupte',
    'abruptement',
    'abruptes',
    'abrupts',
    'abruti',
    'abrutie',
    'abruties',
    'abrutir',
    'abrutira',
    'abrutirai',
    'abrutiraient',
    'abrutirais',
    'abrutirait',
    'abrutiras',
    'abrutirent',
    'abrutirez',
    'abrutiriez',
    'abrutirions',
    'abrutirons',
    'abrutiront',
    'abrutis',
    'abrutissais',
    'abrutissait',
    'abrutissant',
    'abrutissante',
    'abrutissants',
    'abrutisse',
    'abrutissent',
    'abrutisses',
    'abrutissez',
    'abrutissiez',
    'abrutissions',
    'abrutissons',
    'abrutit',
    'abrutîmes',
    'abrutît',
    'abrutîtes',
    'abrège',
    'abrègement',
    'abrègements',
    'abrègent',
    'abrèges',
    'abréaction',
    'abréactions',
    'abréagir',
    'abrégea',
    'abrégeai',
    'abrégeaient',
    'abrégeais',
    'abrégeait',
    'abrégeant',
    'abrégeas',
    'abrégeasse',
    'abrégeassent',
    'abrégeasses',
    'abrégeassiez',
    'abrégement',
    'abrégements',
    'abrégeons',
    'abréger',
    'abrégera',
    'abrégerai',
    'abrégeraient',
    'abrégerais',
    'abrégerait',
    'abrégeras',
    'abrégerez',
    'abrégeriez',
    'abrégerions',
    'abrégerons',
    'abrégeront',
    'abrégez',
    'abrégeâmes',
    'abrégeât',
    'abrégeâtes',
    'abrégiez',
    'abrégions',
    'abrégèrent',
    'abrégé',
    'abrégée',
    'abrégées',
    'abrégés',
    'abréviatif',
    'abréviatifs',
    'abréviation',
    'abréviations',
    'abréviative',
    'abréviatives',
    'abscisse',
    'abscisses',
    'abscons',
    'absconse',
    'absconses',
    'absence',
    'absences',
    'absent',
    'absenta',
    'absentaient',
    'absentais',
    'absentait',
    'absentant',
    'absentassiez',
    'absente',
    'absentent',
    'absenter',
    'absentera',
    'absenterai',
    'absenterais',
    'absenterait',
    'absenteras',
    'absenterez',
    'absenteriez',
    'absenterions',
    'absenterons',
    'absenteront',
    'absentes',
    'absentez',
    'absentiez',
    'absentions',
    'absentons',
    'absents',
    'absentâmes',
    'absentâtes',
    'absentèrent',
    'absenté',
    'absentée',
    'absentées',
    'absentéisme',
    'absentéismes',
    'absentéiste',
    'absentéistes',
    'absentés',
    'abside',
    'absides',
    'absinthe',
    'absinthes',
    'absinthisme',
    'absinthismes',
    'absolu',
    'absolue',
    'absolues',
    'absolument',
    'absolus',
    'absolution',
    'absolutions',
    'absolutisme',
    'absolutismes',
    'absolutiste',
    'absolutistes',
    'absolutoire',
    'absolutoires',
    'absolvaient',
    'absolvais',
    'absolvait',
    'absolvant',
    'absolve',
    'absolvent',
    'absolves',
    'absolvez',
    'absolviez',
    'absolvions',
    'absolvons',
    'absorba',
    'absorbai',
    'absorbaient',
    'absorbais',
    'absorbait',
    'absorbant',
    'absorbante',
    'absorbantes',
    'absorbants',
    'absorbas',
    'absorbasse',
    'absorbassent',
    'absorbasses',
    'absorbassiez',
    'absorbe',
    'absorbent',
    'absorber',
    'absorbera',
    'absorberai',
    'absorberais',
    'absorberait',
    'absorberas',
    'absorberez',
    'absorberiez',
    'absorberions',
    'absorberons',
    'absorberont',
    'absorbes',
    'absorbeur',
    'absorbeurs',
    'absorbez',
    'absorbiez',
    'absorbions',
    'absorbons',
    'absorbâmes',
    'absorbât',
    'absorbâtes',
    'absorbèrent',
    'absorbé',
    'absorbée',
    'absorbées',
    'absorbés',
    'absorption',
    'absorptions',
    'absorptivité',
    'absoudra',
    'absoudrai',
    'absoudraient',
    'absoudrais',
    'absoudrait',
    'absoudras',
    'absoudre',
    'absoudrez',
    'absoudriez',
    'absoudrions',
    'absoudrons',
    'absoudront',
    'absous',
    'absout',
    'absoute',
    'absoutes',
    'abstenaient',
    'abstenais',
    'abstenait',
    'abstenant',
    'abstenez',
    'absteniez',
    'abstenions',
    'abstenir',
    'abstenons',
    'abstention',
    'abstentions',
    'abstenu',
    'abstenue',
    'abstenues',
    'abstenus',
    'abstiendra',
    'abstiendrai',
    'abstiendrais',
    'abstiendrait',
    'abstiendras',
    'abstiendrez',
    'abstiendriez',
    'abstiendrons',
    'abstiendront',
    'abstienne',
    'abstiennent',
    'abstiennes',
    'abstiens',
    'abstient',
    'abstinence',
    'abstinences',
    'abstinent',
    'abstinente',
    'abstinentes',
    'abstinents',
    'abstinrent',
    'abstinssiez',
    'abstinssions',
    'abstint',
    'abstracteur',
    'abstracteurs',
    'abstraction',
    'abstractions',
    'abstraie',
    'abstraient',
    'abstraies',
    'abstraira',
    'abstrairai',
    'abstrairais',
    'abstrairait',
    'abstrairas',
    'abstraire',
    'abstrairez',
    'abstrairiez',
    'abstrairions',
    'abstrairons',
    'abstrairont',
    'abstrais',
    'abstrait',
    'abstraite',
    'abstraites',
    'abstraits',
    'abstrayaient',
    'abstrayais',
    'abstrayait',
    'abstrayant',
    'abstrayez',
    'abstrayiez',
    'abstrayions',
    'abstrayons',
    'abstrus',
    'abstruse',
    'abstruses',
    'abstème',
    'abstèmes',
    'abstînmes',
    'abstîntes',
    'absurde',
    'absurdes',
    'absurdité',
    'absurdités',
    'abus',
    'abusa',
    'abusai',
    'abusaient',
    'abusais',
    'abusait',
    'abusant',
    'abusas',
    'abusasse',
    'abusassent',
    'abusasses',
    'abusassiez',
    'abusassions',
    'abuse',
    'abusent',
    'abuser',
    'abusera',
    'abuserai',
    'abuseraient',
    'abuserais',
    'abuserait',
    'abuseras',
    'abuserez',
    'abuseriez',
    'abuserions',
    'abuserons',
    'abuseront',
    'abuses',
    'abusez',
    'abusiez',
    'abusif',
    'abusifs',
    'abusions',
    'abusive',
    'abusivement',
    'abusives',
    'abusons',
    'abusâmes',
    'abusât',
    'abusâtes',
    'abusèrent',
    'abusé',
    'abusée',
    'abusées',
    'abusés',
    'abyssal',
    'abyssale',
    'abyssales',
    'abyssaux',
    'abysse',
    'abysses',
    'abyssin',
    'abyssine',
    'abyssines',
    'abyssinien',
    'abyssinienne',
    'abyssiniens',
    'abyssins',
    'abâtardi',
    'abâtardie',
    'abâtardies',
    'abâtardir',
    'abâtardira',
    'abâtardirai',
    'abâtardirais',
    'abâtardirait',
    'abâtardiras',
    'abâtardirent',
    'abâtardirez',
    'abâtardiriez',
    'abâtardirons',
    'abâtardiront',
    'abâtardis',
    'abâtardisse',
    'abâtardisses',
    'abâtardissez',
    'abâtardit',
    'abâtardîmes',
    'abâtardît',
    'abâtardîtes',
    'abécédaire',
    'abécédaires',
    'abêti',
    'abêtie',
    'abêties',
    'abêtir',
    'abêtira',
    'abêtirai',
    'abêtiraient',
    'abêtirais',
    'abêtirait',
    'abêtiras',
    'abêtirent',
    'abêtirez',
    'abêtiriez',
    'abêtirions',
    'abêtirons',
    'abêtiront',
    'abêtis',
    'abêtissaient',
    'abêtissais',
    'abêtissait',
    'abêtissant',
    'abêtissante',
    'abêtissantes',
    'abêtissants',
    'abêtisse',
    'abêtissement',
    'abêtissent',
    'abêtisses',
    'abêtissez',
    'abêtissiez',
    'abêtissions',
    'abêtissons',
    'abêtit',
    'abêtîmes',
    'abêtît',
    'abêtîtes',
    'abîma',
    'abîmai',
    'abîmaient',
    'abîmais',
    'abîmait',
    'abîmant',
    'abîmas',
    'abîmasse',
    'abîmassent',
    'abîmasses',
    'abîmassiez',
    'abîmassions',
    'abîme',
    'abîment',
    'abîmer',
    'abîmera',
    'abîmerai',
    'abîmeraient',
    'abîmerais',
    'abîmerait',
    'abîmeras',
    'abîmerez',
    'abîmeriez',
    'abîmerions',
    'abîmerons',
    'abîmeront',
    'abîmes',
    'abîmez',
    'abîmiez',
    'abîmions',
    'abîmons',
    'abîmâmes',
    'abîmât',
    'abîmâtes',
    'abîmèrent',
    'abîmé',
    'abîmée',
    'abîmées',
    'abîmés',
    'acabit',
    'acabits',
    'acacia',
    'acacias',
    'acadien',
    'acadienne',
    'acadiennes',
    'acadiens',
    'académicien',
    'académiciens',
    'académie',
    'académies',
    'académique',
    'académiques',
    'académisme',
    'académismes',
    'acagnarder',
    'acagnarderez',
    'acagnardez',
    'acagnardiez',
    'acagnardions',
    'acagnardons',
    'acagnardâmes',
    'acagnardâtes',
    'acagnardé',
    'acagnardée',
    'acagnardées',
    'acagnardés',
    'acajou',
    'acajous',
    'acalèphe',
    'acalèphes',
    'acanthacée',
    'acanthacées',
    'acanthe',
    'acanthes',
    'acarien',
    'acariens',
    'acariâtre',
    'acariâtres',
    'acariâtreté',
    'acariâtretés',
    'acarus',
    'acaule',
    'acaules',
    'accabla',
    'accablai',
    'accablaient',
    'accablais',
    'accablait',
    'accablant',
    'accablante',
    'accablantes',
    'accablants',
    'accablas',
    'accablasse',
    'accablassent',
    'accablasses',
    'accablassiez',
    'accable',
    'accablement',
    'accablements',
    'accablent',
    'accabler',
    'accablera',
    'accablerai',
    'accablerais',
    'accablerait',
    'accableras',
    'accablerez',
    'accableriez',
    'accablerions',
    'accablerons',
    'accableront',
    'accables',
    'accablez',
    'accabliez',
    'accablions',
    'accablons',
    'accablâmes',
    'accablât',
    'accablâtes',
    'accablèrent',
    'accablé',
    'accablée',
    'accablées',
    'accablés',
    'accalmie',
    'accalmies',
    'accapara',
    'accaparai',
    'accaparaient',
    'accaparais',
    'accaparait',
    'accaparant',
    'accaparas',
    'accaparasse',
    'accaparasses',
    'accapare',
    'accaparement',
    'accaparent',
    'accaparer',
    'accaparera',
    'accaparerai',
    'accaparerais',
    'accaparerait',
    'accapareras',
    'accaparerez',
    'accapareriez',
    'accaparerons',
    'accapareront',
    'accapares',
    'accapareur',
    'accapareurs',
    'accapareuse',
    'accapareuses',
    'accaparez',
    'accapariez',
    'accaparions',
    'accaparons',
    'accaparâmes',
    'accaparât',
    'accaparâtes',
    'accaparèrent',
    'accaparé',
    'accaparée',
    'accaparées',
    'accaparés',
    'accastilla',
    'accastillai',
    'accastillais',
    'accastillait',
    'accastillant',
    'accastillas',
    'accastille',
    'accastillent',
    'accastiller',
    'accastillera',
    'accastilles',
    'accastillez',
    'accastilliez',
    'accastillons',
    'accastillât',
    'accastillé',
    'accastillée',
    'accastillées',
    'accastillés',
    'accelerando',
    'accent',
    'accents',
    'accentua',
    'accentuai',
    'accentuaient',
    'accentuais',
    'accentuait',
    'accentuant',
    'accentuas',
    'accentuasse',
    'accentuasses',
    'accentuation',
    'accentue',
    'accentuel',
    'accentuelle',
    'accentuelles',
    'accentuels',
    'accentuent',
    'accentuer',
    'accentuera',
    'accentuerai',
    'accentuerais',
    'accentuerait',
    'accentueras',
    'accentuerez',
    'accentueriez',
    'accentuerons',
    'accentueront',
    'accentues',
    'accentuez',
    'accentuiez',
    'accentuions',
    'accentuons',
    'accentuâmes',
    'accentuât',
    'accentuâtes',
    'accentuèrent',
    'accentué',
    'accentuée',
    'accentuées',
    'accentués',
    'accepta',
    'acceptable',
    'acceptables',
    'acceptai',
    'acceptaient',
    'acceptais',
    'acceptait',
    'acceptant',
    'acceptante',
    'acceptantes',
    'acceptants',
    'acceptas',
    'acceptasse',
    'acceptassent',
    'acceptasses',
    'acceptassiez',
    'acceptation',
    'acceptations',
    'accepte',
    'acceptent',
    'accepter',
    'acceptera',
    'accepterai',
    'accepterais',
    'accepterait',
    'accepteras',
    'accepterez',
    'accepteriez',
    'accepterions',
    'accepterons',
    'accepteront',
    'acceptes',
    'accepteur',
    'accepteurs',
    'acceptez',
    'acceptiez',
    'acception',
    'acceptions',
    'acceptons',
    'acceptâmes',
    'acceptât',
    'acceptâtes',
    'acceptèrent',
    'accepté',
    'acceptée',
    'acceptées',
    'acceptés',
    'accessible',
    'accessibles',
    'accession',
    'accessions',
    'accessit',
    'accessits',
    'accessoire',
    'accessoires',
    'accessoirisa',
    'accessoirise',
    'accessoirisé',
    'accident',
    'accidenta',
    'accidentai',
    'accidentais',
    'accidentait',
    'accidentant',
    'accidentas',
    'accidentasse',
    'accidente',
    'accidentel',
    'accidentelle',
    'accidentels',
    'accidentent',
    'accidenter',
    'accidentera',
    'accidenterai',
    'accidenteras',
    'accidenterez',
    'accidentes',
    'accidentez',
    'accidentiez',
    'accidentions',
    'accidentons',
    'accidents',
    'accidentâmes',
    'accidentât',
    'accidentâtes',
    'accidenté',
    'accidentée',
    'accidentées',
    'accidentés',
    'accise',
    'accises',
    'acclama',
    'acclamai',
    'acclamaient',
    'acclamais',
    'acclamait',
    'acclamant',
    'acclamas',
    'acclamasse',
    'acclamassent',
    'acclamasses',
    'acclamassiez',
    'acclamation',
    'acclamations',
    'acclame',
    'acclament',
    'acclamer',
    'acclamera',
    'acclamerai',
    'acclamerais',
    'acclamerait',
    'acclameras',
    'acclamerez',
    'acclameriez',
    'acclamerions',
    'acclamerons',
    'acclameront',
    'acclames',
    'acclamez',
    'acclamiez',
    'acclamions',
    'acclamons',
    'acclamâmes',
    'acclamât',
    'acclamâtes',
    'acclamèrent',
    'acclamé',
    'acclamée',
    'acclamées',
    'acclamés',
    'acclimata',
    'acclimatable',
    'acclimatai',
    'acclimatais',
    'acclimatait',
    'acclimatant',
    'acclimatas',
    'acclimatasse',
    'acclimate',
    'acclimatent',
    'acclimater',
    'acclimatera',
    'acclimaterai',
    'acclimateras',
    'acclimaterez',
    'acclimates',
    'acclimatez',
    'acclimatiez',
    'acclimations',
    'acclimatons',
    'acclimatâmes',
    'acclimatât',
    'acclimatâtes',
    'acclimaté',
    'acclimatée',
    'acclimatées',
    'acclimatés',
    'accointances',
    'accointer',
    'accointerez',
    'accointeriez',
    'accointerons',
    'accointez',
    'accointiez',
    'accointions',
    'accointons',
    'accointâmes',
    'accointâtes',
    'accointé',
    'accointée',
    'accointées',
    'accointés',
    'accola',
    'accolade',
    'accolades',
    'accolai',
    'accolaient',
    'accolais',
    'accolait',
    'accolant',
    'accolas',
    'accolasse',
    'accolassent',
    'accolasses',
    'accolassiez',
    'accolassions',
    'accole',
    'accolent',
    'accoler',
    'accolera',
    'accolerai',
    'accoleraient',
    'accolerais',
    'accolerait',
    'accoleras',
    'accolerez',
    'accoleriez',
    'accolerions',
    'accolerons',
    'accoleront',
    'accoles',
    'accolez',
    'accoliez',
    'accolions',
    'accolons',
    'accolâmes',
    'accolât',
    'accolâtes',
    'accolèrent',
    'accolé',
    'accolée',
    'accolées',
    'accolés',
    'accommoda',
    'accommodai',
    'accommodais',
    'accommodait',
    'accommodant',
    'accommodante',
    'accommodants',
    'accommodas',
    'accommodasse',
    'accommodat',
    'accommodats',
    'accommode',
    'accommodent',
    'accommoder',
    'accommodera',
    'accommoderai',
    'accommoderas',
    'accommoderez',
    'accommodes',
    'accommodez',
    'accommodiez',
    'accommodions',
    'accommodons',
    'accommodâmes',
    'accommodât',
    'accommodâtes',
    'accommodé',
    'accommodée',
    'accommodées',
    'accommodés',
    'accompagna',
    'accompagnai',
    'accompagnais',
    'accompagnait',
    'accompagnant',
    'accompagnas',
    'accompagne',
    'accompagnent',
    'accompagner',
    'accompagnera',
    'accompagnes',
    'accompagnez',
    'accompagniez',
    'accompagnons',
    'accompagnât',
    'accompagné',
    'accompagnée',
    'accompagnées',
    'accompagnés',
    'accompli',
    'accomplie',
    'accomplies',
    'accomplir',
    'accomplira',
    'accomplirai',
    'accomplirais',
    'accomplirait',
    'accompliras',
    'accomplirent',
    'accomplirez',
    'accompliriez',
    'accomplirons',
    'accompliront',
    'accomplis',
    'accomplisse',
    'accomplisses',
    'accomplissez',
    'accomplit',
    'accomplîmes',
    'accomplît',
    'accomplîtes',
    'accora',
    'accorai',
    'accoraient',
    'accorais',
    'accorait',
    'accorant',
    'accoras',
    'accorasse',
    'accorassent',
    'accorasses',
    'accorassiez',
    'accorassions',
    'accord',
    'accorda',
    'accordable',
    'accordables',
    'accordai',
    'accordaient',
    'accordailles',
    'accordais',
    'accordait',
    'accordant',
    'accordas',
    'accordasse',
    'accordassent',
    'accordasses',
    'accordassiez',
    'accorde',
    'accordement',
    'accordements',
    'accordent',
    'accorder',
    'accordera',
    'accorderai',
    'accorderais',
    'accorderait',
    'accorderas',
    'accorderez',
    'accorderiez',
    'accorderions',
    'accorderons',
    'accorderont',
    'accordes',
    'accordeur',
    'accordeurs',
    'accordez',
    'accordiez',
    'accordions',
    'accordoir',
    'accordoirs',
    'accordons',
    'accords',
    'accordâmes',
    'accordât',
    'accordâtes',
    'accordèrent',
    'accordé',
    'accordée',
    'accordées',
    'accordéon',
    'accordéons',
    'accordés',
    'accore',
    'accorent',
    'accorer',
    'accorera',
    'accorerai',
    'accoreraient',
    'accorerais',
    'accorerait',
    'accoreras',
    'accorerez',
    'accoreriez',
    'accorerions',
    'accorerons',
    'accoreront',
    'accores',
    'accorez',
    'accoriez',
    'accorions',
    'accorons',
    'accort',
    'accorte',
    'accortes',
    'accorts',
    'accorâmes',
    'accorât',
    'accorâtes',
    'accorèrent',
    'accoré',
    'accorée',
    'accorées',
    'accorés',
    'accosta',
    'accostable',
    'accostables',
    'accostage',
    'accostages',
    'accostai',
    'accostaient',
    'accostais',
    'accostait',
    'accostant',
    'accostas',
    'accostasse',
    'accostassent',
    'accostasses',
    'accostassiez',
    'accoste',
    'accostent',
    'accoster',
    'accostera',
    'accosterai',
    'accosterais',
    'accosterait',
    'accosteras',
    'accosterez',
    'accosteriez',
    'accosterions',
    'accosterons',
    'accosteront',
    'accostes',
    'accostez',
    'accostiez',
    'accostions',
    'accostons',
    'accostâmes',
    'accostât',
    'accostâtes',
    'accostèrent',
    'accosté',
    'accostée',
    'accostées',
    'accostés',
    'accot',
    'accota',
    'accotai',
    'accotaient',
    'accotais',
    'accotait',
    'accotant',
    'accotas',
    'accotasse',
    'accotassent',
    'accotasses',
    'accotassiez',
    'accotassions',
    'accote',
    'accotement',
    'accotements',
    'accotent',
    'accoter',
    'accotera',
    'accoterai',
    'accoteraient',
    'accoterais',
    'accoterait',
    'accoteras',
    'accoterez',
    'accoteriez',
    'accoterions',
    'accoterons',
    'accoteront',
    'accotes',
    'accotez',
    'accotiez',
    'accotions',
    'accotoir',
    'accotoirs',
    'accotons',
    'accots',
    'accotâmes',
    'accotât',
    'accotâtes',
    'accotèrent',
    'accoté',
    'accotée',
    'accotées',
    'accotés',
    'accoua',
    'accouai',
    'accouaient',
    'accouais',
    'accouait',
    'accouant',
    'accouas',
    'accouasse',
    'accouassent',
    'accouasses',
    'accouassiez',
    'accouassions',
    'accoucha',
    'accouchai',
    'accouchaient',
    'accouchais',
    'accouchait',
    'accouchant',
    'accouchas',
    'accouchasse',
    'accouchasses',
    'accouche',
    'accouchement',
    'accouchent',
    'accoucher',
    'accouchera',
    'accoucherai',
    'accoucherais',
    'accoucherait',
    'accoucheras',
    'accoucherez',
    'accoucheriez',
    'accoucherons',
    'accoucheront',
    'accouches',
    'accoucheur',
    'accoucheurs',
    'accoucheuse',
    'accoucheuses',
    'accouchez',
    'accouchiez',
    'accouchions',
    'accouchons',
    'accouchâmes',
    'accouchât',
    'accouchâtes',
    'accouchèrent',
    'accouché',
    'accouchée',
    'accouchées',
    'accouchés',
    'accouda',
    'accoudaient',
    'accoudais',
    'accoudait',
    'accoudant',
    'accoudassiez',
    'accoude',
    'accoudement',
    'accoudements',
    'accoudent',
    'accouder',
    'accoudera',
    'accouderai',
    'accouderais',
    'accouderait',
    'accouderas',
    'accouderez',
    'accouderiez',
    'accouderions',
    'accouderons',
    'accouderont',
    'accoudes',
    'accoudez',
    'accoudiez',
    'accoudions',
    'accoudoir',
    'accoudoirs',
    'accoudons',
    'accoudâmes',
    'accoudâtes',
    'accoudèrent',
    'accoudé',
    'accoudée',
    'accoudées',
    'accoudés',
    'accoue',
    'accouent',
    'accouer',
    'accouera',
    'accouerai',
    'accoueraient',
    'accouerais',
    'accouerait',
    'accoueras',
    'accouerez',
    'accoueriez',
    'accouerions',
    'accouerons',
    'accoueront',
    'accoues',
    'accouez',
    'accouiez',
    'accouions',
    'accouons',
    'accoupla',
    'accouplai',
    'accouplaient',
    'accouplais',
    'accouplait',
    'accouplant',
    'accouplas',
    'accouplasse',
    'accouplasses',
    'accouple',
    'accouplement',
    'accouplent',
    'accoupler',
    'accouplera',
    'accouplerai',
    'accouplerais',
    'accouplerait',
    'accoupleras',
    'accouplerez',
    'accoupleriez',
    'accouplerons',
    'accoupleront',
    'accouples',
    'accouplez',
    'accoupliez',
    'accouplions',
    'accouplons',
    'accouplâmes',
    'accouplât',
    'accouplâtes',
    'accouplèrent',
    'accouplé',
    'accouplée',
    'accouplées',
    'accouplés',
    'accouraient',
    'accourais',
    'accourait',
    'accourant',
    'accourci',
    'accourcir',
    'accourcira',
    'accourcirai',
    'accourcirais',
    'accourcirait',
    'accourciras',
    'accourcirent',
    'accourcirez',
    'accourciriez',
    'accourcirons',
    'accourciront',
    'accourcis',
    'accourcisse',
    'accourcisses',
    'accourcissez',
    'accourcit',
    'accourcîmes',
    'accourcît',
    'accourcîtes',
    'accoure',
    'accourent',
    'accoures',
    'accourez',
    'accouriez',
    'accourions',
    'accourir',
    'accourons',
    'accourra',
    'accourrai',
    'accourraient',
    'accourrais',
    'accourrait',
    'accourras',
    'accourrez',
    'accourriez',
    'accourrions',
    'accourrons',
    'accourront',
    'accours',
    'accourt',
    'accouru',
    'accourue',
    'accourues',
    'accoururent',
    'accourus',
    'accourusse',
    'accourussent',
    'accourusses',
    'accourussiez',
    'accourut',
    'accourûmes',
    'accourût',
    'accourûtes',
    'accoutra',
    'accoutrai',
    'accoutraient',
    'accoutrais',
    'accoutrait',
    'accoutrant',
    'accoutras',
    'accoutrasse',
    'accoutrasses',
    'accoutre',
    'accoutrement',
    'accoutrent',
    'accoutrer',
    'accoutrera',
    'accoutrerai',
    'accoutrerais',
    'accoutrerait',
    'accoutreras',
    'accoutrerez',
    'accoutreriez',
    'accoutrerons',
    'accoutreront',
    'accoutres',
    'accoutrez',
    'accoutriez',
    'accoutrions',
    'accoutrons',
    'accoutrâmes',
    'accoutrât',
    'accoutrâtes',
    'accoutrèrent',
    'accoutré',
    'accoutrée',
    'accoutrées',
    'accoutrés',
    'accoutuma',
    'accoutumai',
    'accoutumais',
    'accoutumait',
    'accoutumance',
    'accoutumant',
    'accoutumas',
    'accoutumasse',
    'accoutume',
    'accoutument',
    'accoutumer',
    'accoutumera',
    'accoutumerai',
    'accoutumeras',
    'accoutumerez',
    'accoutumes',
    'accoutumez',
    'accoutumiez',
    'accoutumions',
    'accoutumons',
    'accoutumâmes',
    'accoutumât',
    'accoutumâtes',
    'accoutumé',
    'accoutumée',
    'accoutumées',
    'accoutumés',
    'accouvage',
    'accouvages',
    'accouâmes',
    'accouât',
    'accouâtes',
    'accouèrent',
    'accoué',
    'accouée',
    'accouées',
    'accoués',
    'accrescent',
    'accrescente',
    'accrescentes',
    'accrescents',
    'accroc',
    'accrocha',
    'accrochage',
    'accrochages',
    'accrochai',
    'accrochaient',
    'accrochais',
    'accrochait',
    'accrochant',
    'accrochas',
    'accrochasse',
    'accrochasses',
    'accroche',
    'accrochent',
    'accrocher',
    'accrochera',
    'accrocherai',
    'accrocherais',
    'accrocherait',
    'accrocheras',
    'accrocherez',
    'accrocheriez',
    'accrocherons',
    'accrocheront',
    'accroches',
    'accrocheur',
    'accrocheurs',
    'accrocheuse',
    'accrocheuses',
    'accrochez',
    'accrochiez',
    'accrochions',
    'accrochons',
    'accrochâmes',
    'accrochât',
    'accrochâtes',
    'accrochèrent',
    'accroché',
    'accrochée',
    'accrochées',
    'accrochés',
    'accrocs',
    'accroire',
    'accrois',
    'accroissais',
    'accroissait',
    'accroissant',
    'accroisse',
    'accroissent',
    'accroisses',
    'accroissez',
    'accroissiez',
    'accroissions',
    'accroissons',
    'accroupi',
    'accroupie',
    'accroupies',
    'accroupir',
    'accroupirez',
    'accroupiriez',
    'accroupirons',
    'accroupis',
    'accroupissez',
    'accroupîmes',
    'accroupîtes',
    'accroît',
    'accroîtra',
    'accroîtrai',
    'accroîtrais',
    'accroîtrait',
    'accroîtras',
    'accroître',
    'accroîtrez',
    'accroîtriez',
    'accroîtrions',
    'accroîtrons',
    'accroîtront',
    'accru',
    'accrue',
    'accrues',
    'accrurent',
    'accrus',
    'accrusse',
    'accrussent',
    'accrusses',
    'accrussiez',
    'accrussions',
    'accrut',
    'accrédita',
    'accréditai',
    'accréditais',
    'accréditait',
    'accréditant',
    'accréditas',
    'accréditasse',
    'accrédite',
    'accréditent',
    'accréditer',
    'accréditera',
    'accréditerai',
    'accréditeras',
    'accréditerez',
    'accrédites',
    'accréditeur',
    'accréditeurs',
    'accréditez',
    'accréditiez',
    'accréditif',
    'accréditifs',
    'accréditions',
    'accréditive',
    'accréditives',
    'accréditons',
    'accréditrice',
    'accréditâmes',
    'accréditât',
    'accréditâtes',
    'accrédité',
    'accréditée',
    'accréditées',
    'accrédités',
    'accrétion',
    'accrétions',
    'accrûmes',
    'accrût',
    'accrûtes',
    'accu',
    'accueil',
    'accueillais',
    'accueillait',
    'accueillant',
    'accueillante',
    'accueillants',
    'accueille',
    'accueillent',
    'accueillera',
    'accueillerai',
    'accueilleras',
    'accueillerez',
    'accueilles',
    'accueillez',
    'accueilli',
    'accueillie',
    'accueillies',
    'accueilliez',
    'accueillions',
    'accueillir',
    'accueillis',
    'accueillisse',
    'accueillit',
    'accueillons',
    'accueillîmes',
    'accueillît',
    'accueillîtes',
    'accueils',
    'accula',
    'acculai',
    'acculaient',
    'acculais',
    'acculait',
    'acculant',
    'acculas',
    'acculasse',
    'acculassent',
    'acculasses',
    'acculassiez',
    'acculassions',
    'accule',
    'acculent',
    'acculer',
    'acculera',
    'acculerai',
    'acculeraient',
    'acculerais',
    'acculerait',
    'acculeras',
    'acculerez',
    'acculeriez',
    'acculerions',
    'acculerons',
    'acculeront',
    'accules',
    'acculez',
    'acculiez',
    'acculions',
    'acculons',
    'accultura',
    'acculturai',
    'acculturais',
    'acculturait',
    'acculturant',
    'acculturas',
    'acculturasse',
    'acculture',
    'acculturent',
    'acculturer',
    'acculturera',
    'acculturerai',
    'accultureras',
    'acculturerez',
    'accultures',
    'acculturez',
    'acculturiez',
    'acculturions',
    'acculturons',
    'acculturâmes',
    'acculturât',
    'acculturâtes',
    'acculturé',
    'acculturée',
    'acculturées',
    'acculturés',
    'acculâmes',
    'acculât',
    'acculâtes',
    'acculèrent',
    'acculé',
    'acculée',
    'acculées',
    'acculés',
    'accumula',
    'accumulai',
    'accumulaient',
    'accumulais',
    'accumulait',
    'accumulant',
    'accumulas',
    'accumulasse',
    'accumulasses',
    'accumulateur',
    'accumulation',
    'accumule',
    'accumulent',
    'accumuler',
    'accumulera',
    'accumulerai',
    'accumulerais',
    'accumulerait',
    'accumuleras',
    'accumulerez',
    'accumuleriez',
    'accumulerons',
    'accumuleront',
    'accumules',
    'accumulez',
    'accumuliez',
    'accumulions',
    'accumulons',
    'accumulâmes',
    'accumulât',
    'accumulâtes',
    'accumulèrent',
    'accumulé',
    'accumulée',
    'accumulées',
    'accumulés',
    'accus',
    'accusa',
    'accusai',
    'accusaient',
    'accusais',
    'accusait',
    'accusant',
    'accusas',
    'accusasse',
    'accusassent',
    'accusasses',
    'accusassiez',
    'accusassions',
    'accusateur',
    'accusateurs',
    'accusatif',
    'accusatifs',
    'accusation',
    'accusations',
    'accusative',
    'accusatives',
    'accusatoire',
    'accusatoires',
    'accusatrice',
    'accusatrices',
    'accuse',
    'accusent',
    'accuser',
    'accusera',
    'accuserai',
    'accuseraient',
    'accuserais',
    'accuserait',
    'accuseras',
    'accuserez',
    'accuseriez',
    'accuserions',
    'accuserons',
    'accuseront',
    'accuses',
    'accusez',
    'accusiez',
    'accusions',
    'accusons',
    'accusâmes',
    'accusât',
    'accusâtes',
    'accusèrent',
    'accusé',
    'accusée',
    'accusées',
    'accusés',
    'accède',
    'accèdent',
    'accèdes',
    'accès',
    'accéda',
    'accédai',
    'accédaient',
    'accédais',
    'accédait',
    'accédant',
    'accédas',
    'accédasse',
    'accédassent',
    'accédasses',
    'accédassiez',
    'accédassions',
    'accéder',
    'accédera',
    'accéderai',
    'accéderaient',
    'accéderais',
    'accéderait',
    'accéderas',
    'accéderez',
    'accéderiez',
    'accéderions',
    'accéderons',
    'accéderont',
    'accédez',
    'accédiez',
    'accédions',
    'accédons',
    'accédâmes',
    'accédât',
    'accédâtes',
    'accédèrent',
    'accédé',
    'accélère',
    'accélèrent',
    'accélères',
    'accéléra',
    'accélérai',
    'accéléraient',
    'accélérais',
    'accélérait',
    'accélérant',
    'accéléras',
    'accélérasse',
    'accélérasses',
    'accélérateur',
    'accélération',
    'accélérer',
    'accélérera',
    'accélérerai',
    'accélérerais',
    'accélérerait',
    'accéléreras',
    'accélérerez',
    'accéléreriez',
    'accélérerons',
    'accéléreront',
    'accélérez',
    'accélériez',
    'accélérions',
    'accélérons',
    'accélérâmes',
    'accélérât',
    'accélérâtes',
    'accélérèrent',
    'accéléré',
    'accélérée',
    'accélérées',
    'accélérés',
    'acerbe',
    'acerbes',
    'acerbité',
    'acerbités',
    'aces',
    'acescence',
    'acescences',
    'acescent',
    'acescente',
    'acescentes',
    'acescents',
    'achalanda',
    'achalandage',
    'achalandages',
    'achalandai',
    'achalandais',
    'achalandait',
    'achalandant',
    'achalandas',
    'achalandasse',
    'achalande',
    'achalandent',
    'achalander',
    'achalandera',
    'achalanderai',
    'achalanderas',
    'achalanderez',
    'achalandes',
    'achalandez',
    'achalandiez',
    'achalandions',
    'achalandons',
    'achalandâmes',
    'achalandât',
    'achalandâtes',
    'achalandé',
    'achalandée',
    'achalandées',
    'achalandés',
    'achards',
    'acharna',
    'acharnai',
    'acharnaient',
    'acharnais',
    'acharnait',
    'acharnant',
    'acharnas',
    'acharnasse',
    'acharnassent',
    'acharnasses',
    'acharnassiez',
    'acharne',
    'acharnement',
    'acharnements',
    'acharnent',
    'acharner',
    'acharnera',
    'acharnerai',
    'acharnerais',
    'acharnerait',
    'acharneras',
    'acharnerez',
    'acharneriez',
    'acharnerions',
    'acharnerons',
    'acharneront',
    'acharnes',
    'acharnez',
    'acharniez',
    'acharnions',
    'acharnons',
    'acharnâmes',
    'acharnât',
    'acharnâtes',
    'acharnèrent',
    'acharné',
    'acharnée',
    'acharnées',
    'acharnés',
    'achat',
    'achats',
    'achemina',
    'acheminai',
    'acheminaient',
    'acheminais',
    'acheminait',
    'acheminant',
    'acheminas',
    'acheminasse',
    'acheminasses',
    'achemine',
    'acheminement',
    'acheminent',
    'acheminer',
    'acheminera',
    'acheminerai',
    'acheminerais',
    'acheminerait',
    'achemineras',
    'acheminerez',
    'achemineriez',
    'acheminerons',
    'achemineront',
    'achemines',
    'acheminez',
    'acheminiez',
    'acheminions',
    'acheminons',
    'acheminâmes',
    'acheminât',
    'acheminâtes',
    'acheminèrent',
    'acheminé',
    'acheminée',
    'acheminées',
    'acheminés',
    'acheta',
    'achetable',
    'achetables',
    'achetai',
    'achetaient',
    'achetais',
    'achetait',
    'achetant',
    'achetas',
    'achetasse',
    'achetassent',
    'achetasses',
    'achetassiez',
    'achetassions',
    'acheter',
    'acheteur',
    'acheteurs',
    'acheteuse',
    'acheteuses',
    'achetez',
    'achetiez',
    'achetions',
    'achetons',
    'achetâmes',
    'achetât',
    'achetâtes',
    'achetèrent',
    'acheté',
    'achetée',
    'achetées',
    'achetés',
    'acheuléen',
    'acheuléenne',
    'acheuléennes',
    'acheuléens',
    'acheva',
    'achevai',
    'achevaient',
    'achevais',
    'achevait',
    'achevant',
    'achevas',
    'achevasse',
    'achevassent',
    'achevasses',
    'achevassiez',
    'achevassions',
    'achever',
    'achevez',
    'acheviez',
    'achevions',
    'achevons',
    'achevâmes',
    'achevât',
    'achevâtes',
    'achevèrent',
    'achevé',
    'achevée',
    'achevées',
    'achevés',
    'achigan',
    'achigans',
    'achillée',
    'achillées',
    'acholie',
    'acholies',
    'achoppa',
    'achoppaient',
    'achoppais',
    'achoppait',
    'achoppant',
    'achoppassiez',
    'achoppe',
    'achoppement',
    'achoppements',
    'achoppent',
    'achopper',
    'achoppera',
    'achopperai',
    'achopperais',
    'achopperait',
    'achopperas',
    'achopperez',
    'achopperiez',
    'achopperions',
    'achopperons',
    'achopperont',
    'achoppes',
    'achoppez',
    'achoppiez',
    'achoppions',
    'achoppons',
    'achoppâmes',
    'achoppâtes',
    'achoppèrent',
    'achoppé',
    'achoppée',
    'achoppées',
    'achoppés',
    'achromat',
    'achromatique',
    'achromatiser',
    'achromatisme',
    'achromats',
    'achrome',
    'achromes',
    'achromie',
    'achromies',
    'achylie',
    'achylies',
    'achète',
    'achètent',
    'achètera',
    'achèterai',
    'achèteraient',
    'achèterais',
    'achèterait',
    'achèteras',
    'achèterez',
    'achèteriez',
    'achèterions',
    'achèterons',
    'achèteront',
    'achètes',
    'achève',
    'achèvement',
    'achèvements',
    'achèvent',
    'achèvera',
    'achèverai',
    'achèveraient',
    'achèverais',
    'achèverait',
    'achèveras',
    'achèverez',
    'achèveriez',
    'achèverions',
    'achèverons',
    'achèveront',
    'achèves',
    'achéen',
    'achéenne',
    'achéennes',
    'achéens',
    'aciculaire',
    'aciculaires',
    'acidalie',
    'acidalies',
    'acide',
    'acides',
    'acidifia',
    'acidifiable',
    'acidifiables',
    'acidifiai',
    'acidifiaient',
    'acidifiais',
    'acidifiait',
    'acidifiant',
    'acidifiante',
    'acidifiantes',
    'acidifiants',
    'acidifias',
    'acidifiasse',
    'acidifiasses',
    'acidifie',
    'acidifient',
    'acidifier',
    'acidifiera',
    'acidifierai',
    'acidifierais',
    'acidifierait',
    'acidifieras',
    'acidifierez',
    'acidifieriez',
    'acidifierons',
    'acidifieront',
    'acidifies',
    'acidifiez',
    'acidifiiez',
    'acidifiions',
    'acidifions',
    'acidifiâmes',
    'acidifiât',
    'acidifiâtes',
    'acidifièrent',
    'acidifié',
    'acidifiée',
    'acidifiées',
    'acidifiés',
    'acidimètre',
    'acidimètres',
    'acidimétrie',
    'acidimétries',
    'acidité',
    'acidités',
    'acidophile',
    'acidophiles',
    'acidose',
    'acidoses',
    'acidula',
    'acidulai',
    'acidulaient',
    'acidulais',
    'acidulait',
    'acidulant',
    'acidulas',
    'acidulasse',
    'acidulassent',
    'acidulasses',
    'acidulassiez',
    'acidule',
    'acidulent',
    'aciduler',
    'acidulera',
    'acidulerai',
    'acidulerais',
    'acidulerait',
    'aciduleras',
    'acidulerez',
    'aciduleriez',
    'acidulerions',
    'acidulerons',
    'aciduleront',
    'acidules',
    'acidulez',
    'aciduliez',
    'acidulions',
    'acidulons',
    'acidulâmes',
    'acidulât',
    'acidulâtes',
    'acidulèrent',
    'acidulé',
    'acidulée',
    'acidulées',
    'acidulés',
    'acier',
    'aciers',
    'acini',
    'acinus',
    'acisela',
    'aciselai',
    'aciselaient',
    'aciselais',
    'aciselait',
    'aciselant',
    'aciselas',
    'aciselasse',
    'aciselassent',
    'aciselasses',
    'aciselassiez',
    'aciseler',
    'aciselez',
    'aciseliez',
    'aciselions',
    'aciselons',
    'aciselâmes',
    'aciselât',
    'aciselâtes',
    'aciselèrent',
    'aciselé',
    'aciselée',
    'aciselées',
    'aciselés',
    'acisèle',
    'acisèlent',
    'acisèlera',
    'acisèlerai',
    'acisèlerais',
    'acisèlerait',
    'acisèleras',
    'acisèlerez',
    'acisèleriez',
    'acisèlerions',
    'acisèlerons',
    'acisèleront',
    'acisèles',
    'acière',
    'acièrent',
    'acières',
    'aciéra',
    'aciérage',
    'aciérages',
    'aciérai',
    'aciéraient',
    'aciérais',
    'aciérait',
    'aciérant',
    'aciéras',
    'aciérasse',
    'aciérassent',
    'aciérasses',
    'aciérassiez',
    'aciérassions',
    'aciération',
    'aciérations',
    'aciérer',
    'aciérera',
    'aciérerai',
    'aciéreraient',
    'aciérerais',
    'aciérerait',
    'aciéreras',
    'aciérerez',
    'aciéreriez',
    'aciérerions',
    'aciérerons',
    'aciéreront',
    'aciérez',
    'aciérie',
    'aciéries',
    'aciériez',
    'aciérions',
    'aciérons',
    'aciérâmes',
    'aciérât',
    'aciérâtes',
    'aciérèrent',
    'aciéré',
    'aciérée',
    'aciérées',
    'aciérés',
    'aclinique',
    'acliniques',
    'acmé',
    'acmés',
    'acné',
    'acnéique',
    'acnéiques',
    'acnés',
    'acolyte',
    'acolytes',
    'acompte',
    'acomptes',
    'acon',
    'aconage',
    'aconages',
    'aconier',
    'aconiers',
    'aconit',
    'aconitine',
    'aconitines',
    'aconits',
    'acons',
    'acoquinement',
    'acoquiner',
    'acoquinerez',
    'acoquineriez',
    'acoquinerons',
    'acoquinez',
    'acoquiniez',
    'acoquinions',
    'acoquinons',
    'acoquinâmes',
    'acoquinâtes',
    'acoquiné',
    'acoquinée',
    'acoquinées',
    'acoquinés',
    'acore',
    'acores',
    'acouphène',
    'acouphènes',
    'acousticien',
    'acousticiens',
    'acoustique',
    'acoustiques',
    'acquerra',
    'acquerrai',
    'acquerraient',
    'acquerrais',
    'acquerrait',
    'acquerras',
    'acquerrez',
    'acquerriez',
    'acquerrions',
    'acquerrons',
    'acquerront',
    'acquiers',
    'acquiert',
    'acquiesce',
    'acquiescent',
    'acquiescer',
    'acquiescera',
    'acquiescerai',
    'acquiesceras',
    'acquiescerez',
    'acquiesces',
    'acquiescez',
    'acquiesciez',
    'acquiescions',
    'acquiescé',
    'acquiesça',
    'acquiesçai',
    'acquiesçais',
    'acquiesçait',
    'acquiesçant',
    'acquiesças',
    'acquiesçasse',
    'acquiesçons',
    'acquiesçâmes',
    'acquiesçât',
    'acquiesçâtes',
    'acquirent',
    'acquis',
    'acquise',
    'acquises',
    'acquisitif',
    'acquisitifs',
    'acquisition',
    'acquisitions',
    'acquisitive',
    'acquisitives',
    'acquisse',
    'acquissent',
    'acquisses',
    'acquissiez',
    'acquissions',
    'acquit',
    'acquits',
    'acquitta',
    'acquittable',
    'acquittables',
    'acquittai',
    'acquittaient',
    'acquittais',
    'acquittait',
    'acquittant',
    'acquittas',
    'acquittasse',
    'acquittasses',
    'acquitte',
    'acquittement',
    'acquittent',
    'acquitter',
    'acquittera',
    'acquitterai',
    'acquitterais',
    'acquitterait',
    'acquitteras',
    'acquitterez',
    'acquitteriez',
    'acquitterons',
    'acquitteront',
    'acquittes',
    'acquittez',
    'acquittiez',
    'acquittions',
    'acquittons',
    'acquittâmes',
    'acquittât',
    'acquittâtes',
    'acquittèrent',
    'acquitté',
    'acquittée',
    'acquittées',
    'acquittés',
    'acquière',
    'acquièrent',
    'acquières',
    'acquéraient',
    'acquérais',
    'acquérait',
    'acquérant',
    'acquéresse',
    'acquéresses',
    'acquéreur',
    'acquéreurs',
    'acquérez',
    'acquériez',
    'acquérions',
    'acquérir',
    'acquérons',
    'acquêt',
    'acquêts',
    'acquîmes',
    'acquît',
    'acquîtes',
    'acre',
    'acres',
    'acrimonie',
    'acrimonies',
    'acrimonieuse',
    'acrimonieux',
    'acrobate',
    'acrobates',
    'acrobatie',
    'acrobaties',
    'acrobatique',
    'acrobatiques',
    'acrocyanose',
    'acrocyanoses',
    'acrocéphale',
    'acrocéphales',
    'acrocéphalie',
    'acroléine',
    'acroléines',
    'acromion',
    'acromions',
    'acromégalie',
    'acromégalies',
    'acronyme',
    'acronymes',
    'acrophobie',
    'acrophobies',
    'acropole',
    'acropoles',
    'acrostiche',
    'acrostiches',
    'acrotère',
    'acrotères',
    'acrylique',
    'acryliques',
    'acta',
    'actai',
    'actaient',
    'actais',
    'actait',
    'actant',
    'actants',
    'actas',
    'actasse',
    'actassent',
    'actasses',
    'actassiez',
    'actassions',
    'acte',
    'actent',
    'acter',
    'actera',
    'acterai',
    'acteraient',
    'acterais',
    'acterait',
    'acteras',
    'acterez',
    'acteriez',
    'acterions',
    'acterons',
    'acteront',
    'actes',
    'acteur',
    'acteurs',
    'actez',
    'actiez',
    'actif',
    'actifs',
    'actinides',
    'actinie',
    'actinies',
    'actinique',
    'actiniques',
    'actinisme',
    'actinismes',
    'actinite',
    'actinites',
    'actinium',
    'actiniums',
    'actinologie',
    'actinologies',
    'actinomycose',
    'actinomycète',
    'actinomètre',
    'actinomètres',
    'actinométrie',
    'actinote',
    'actinotes',
    'action',
    'actionna',
    'actionnable',
    'actionnables',
    'actionnai',
    'actionnaient',
    'actionnaire',
    'actionnaires',
    'actionnais',
    'actionnait',
    'actionnant',
    'actionnariat',
    'actionnas',
    'actionnasse',
    'actionnasses',
    'actionne',
    'actionnement',
    'actionnent',
    'actionner',
    'actionnera',
    'actionnerai',
    'actionnerais',
    'actionnerait',
    'actionneras',
    'actionnerez',
    'actionneriez',
    'actionnerons',
    'actionneront',
    'actionnes',
    'actionneur',
    'actionneurs',
    'actionnez',
    'actionniez',
    'actionnions',
    'actionnons',
    'actionnâmes',
    'actionnât',
    'actionnâtes',
    'actionnèrent',
    'actionné',
    'actionnée',
    'actionnées',
    'actionnés',
    'actions',
    'activa',
    'activai',
    'activaient',
    'activais',
    'activait',
    'activant',
    'activas',
    'activasse',
    'activassent',
    'activasses',
    'activassiez',
    'activassions',
    'activateur',
    'activateurs',
    'activation',
    'activations',
    'active',
    'activement',
    'activent',
    'activer',
    'activera',
    'activerai',
    'activeraient',
    'activerais',
    'activerait',
    'activeras',
    'activerez',
    'activeriez',
    'activerions',
    'activerons',
    'activeront',
    'actives',
    'activeur',
    'activeurs',
    'activez',
    'activiez',
    'activions',
    'activisme',
    'activismes',
    'activiste',
    'activistes',
    'activité',
    'activités',
    'activons',
    'activâmes',
    'activât',
    'activâtes',
    'activèrent',
    'activé',
    'activée',
    'activées',
    'activés',
    'actons',
    'actrice',
    'actrices',
    'actuaire',
    'actuaires',
    'actualisa',
    'actualisai',
    'actualisais',
    'actualisait',
    'actualisant',
    'actualisas',
    'actualisasse',
    'actualise',
    'actualisent',
    'actualiser',
    'actualisera',
    'actualiserai',
    'actualiseras',
    'actualiserez',
    'actualises',
    'actualisez',
    'actualisiez',
    'actualisions',
    'actualisons',
    'actualisâmes',
    'actualisât',
    'actualisâtes',
    'actualisé',
    'actualisée',
    'actualisées',
    'actualisés',
    'actualité',
    'actualités',
    'actuariat',
    'actuariats',
    'actuariel',
    'actuarielle',
    'actuarielles',
    'actuariels',
    'actuel',
    'actuelle',
    'actuellement',
    'actuelles',
    'actuels',
    'actâmes',
    'actât',
    'actâtes',
    'actèrent',
    'actée',
    'actées',
    'acuité',
    'acuités',
    'acuminé',
    'acuminée',
    'acuminées',
    'acuminés',
    'acuponcteur',
    'acuponcteurs',
    'acuponctrice',
    'acuponcture',
    'acuponctures',
    'acupuncteur',
    'acupuncteurs',
    'acupunctrice',
    'acupuncture',
    'acupunctures',
    'acutangle',
    'acutangles',
    'acère',
    'acèrent',
    'acères',
    'acéphale',
    'acéphales',
    'acéra',
    'acérai',
    'acéraient',
    'acérais',
    'acérait',
    'acérant',
    'acéras',
    'acérasse',
    'acérassent',
    'acérasses',
    'acérassiez',
    'acérassions',
    'acérer',
    'acérera',
    'acérerai',
    'acéreraient',
    'acérerais',
    'acérerait',
    'acéreras',
    'acérerez',
    'acéreriez',
    'acérerions',
    'acérerons',
    'acéreront',
    'acérez',
    'acériez',
    'acérions',
    'acérons',
    'acérâmes',
    'acérât',
    'acérâtes',
    'acérèrent',
    'acéré',
    'acérée',
    'acérées',
    'acérés',
    'acétamide',
    'acétamides',
    'acétate',
    'acétates',
    'acétifia',
    'acétifiai',
    'acétifiaient',
    'acétifiais',
    'acétifiait',
    'acétifiant',
    'acétifias',
    'acétifiasse',
    'acétifiasses',
    'acétifie',
    'acétifient',
    'acétifier',
    'acétifiera',
    'acétifierai',
    'acétifierais',
    'acétifierait',
    'acétifieras',
    'acétifierez',
    'acétifieriez',
    'acétifierons',
    'acétifieront',
    'acétifies',
    'acétifiez',
    'acétifiiez',
    'acétifiions',
    'acétifions',
    'acétifiâmes',
    'acétifiât',
    'acétifiâtes',
    'acétifièrent',
    'acétifié',
    'acétifiée',
    'acétifiées',
    'acétifiés',
    'acétique',
    'acétiques',
    'acétobacter',
    'acétobacters',
    'acétone',
    'acétones',
    'acétonurie',
    'acétonuries',
    'acétonémie',
    'acétonémies',
    'acétyla',
    'acétylai',
    'acétylaient',
    'acétylais',
    'acétylait',
    'acétylant',
    'acétylas',
    'acétylasse',
    'acétylassent',
    'acétylasses',
    'acétylassiez',
    'acétyle',
    'acétylent',
    'acétyler',
    'acétylera',
    'acétylerai',
    'acétylerais',
    'acétylerait',
    'acétyleras',
    'acétylerez',
    'acétyleriez',
    'acétylerions',
    'acétylerons',
    'acétyleront',
    'acétyles',
    'acétylez',
    'acétyliez',
    'acétylions',
    'acétylons',
    'acétylâmes',
    'acétylât',
    'acétylâtes',
    'acétylène',
    'acétylènes',
    'acétylèrent',
    'acétylé',
    'acétylée',
    'acétylées',
    'acétylénique',
    'acétylés',
    'adage',
    'adages',
    'adagio',
    'adagios',
    'adamantin',
    'adamantine',
    'adamantines',
    'adamantins',
    'adamar',
    'adamisme',
    'adamismes',
    'adapta',
    'adaptabilité',
    'adaptable',
    'adaptables',
    'adaptai',
    'adaptaient',
    'adaptais',
    'adaptait',
    'adaptant',
    'adaptas',
    'adaptasse',
    'adaptassent',
    'adaptasses',
    'adaptassiez',
    'adaptassions',
    'adaptateur',
    'adaptateurs',
    'adaptatif',
    'adaptatifs',
    'adaptation',
    'adaptations',
    'adaptative',
    'adaptatives',
    'adaptatrice',
    'adaptatrices',
    'adapte',
    'adaptent',
    'adapter',
    'adaptera',
    'adapterai',
    'adapteraient',
    'adapterais',
    'adapterait',
    'adapteras',
    'adapterez',
    'adapteriez',
    'adapterions',
    'adapterons',
    'adapteront',
    'adaptes',
    'adaptez',
    'adaptiez',
    'adaptions',
    'adaptons',
    'adaptâmes',
    'adaptât',
    'adaptâtes',
    'adaptèrent',
    'adapté',
    'adaptée',
    'adaptées',
    'adaptés',
    'addenda',
    'additif',
    'additifs',
    'addition',
    'additionna',
    'additionnai',
    'additionnais',
    'additionnait',
    'additionnant',
    'additionnas',
    'additionne',
    'additionnel',
    'additionnels',
    'additionnent',
    'additionner',
    'additionnera',
    'additionnes',
    'additionnez',
    'additionniez',
    'additionnons',
    'additionnât',
    'additionné',
    'additionnée',
    'additionnées',
    'additionnés',
    'additions',
    'additive',
    'additives',
    'adducteur',
    'adducteurs',
    'adduction',
    'adductions',
    'adent',
    'adents',
    'adepte',
    'adeptes',
    'adextré',
    'adextrée',
    'adextrées',
    'adextrés',
    'adhère',
    'adhèrent',
    'adhères',
    'adhéra',
    'adhérai',
    'adhéraient',
    'adhérais',
    'adhérait',
    'adhérant',
    'adhérante',
    'adhérantes',
    'adhérants',
    'adhéras',
    'adhérasse',
    'adhérassent',
    'adhérasses',
    'adhérassiez',
    'adhérassions',
    'adhérence',
    'adhérences',
    'adhérent',
    'adhérente',
    'adhérentes',
    'adhérents',
    'adhérer',
    'adhérera',
    'adhérerai',
    'adhéreraient',
    'adhérerais',
    'adhérerait',
    'adhéreras',
    'adhérerez',
    'adhéreriez',
    'adhérerions',
    'adhérerons',
    'adhéreront',
    'adhérez',
    'adhériez',
    'adhérions',
    'adhérons',
    'adhérâmes',
    'adhérât',
    'adhérâtes',
    'adhérèrent',
    'adhéré',
    'adhésif',
    'adhésifs',
    'adhésion',
    'adhésions',
    'adhésive',
    'adhésives',
    'adhésivité',
    'adhésivités',
    'adiaphorèse',
    'adiaphorèses',
    'adieu',
    'adieux',
    'adipeuse',
    'adipeuses',
    'adipeux',
    'adipique',
    'adipiques',
    'adipolyse',
    'adipolyses',
    'adipopexie',
    'adipopexies',
    'adipose',
    'adiposes',
    'adiposité',
    'adiposités',
    'adipsie',
    'adipsies',
    'adjacence',
    'adjacences',
    'adjacent',
    'adjacente',
    'adjacentes',
    'adjacents',
    'adjectif',
    'adjectifs',
    'adjectiva',
    'adjectivai',
    'adjectivais',
    'adjectivait',
    'adjectival',
    'adjectivale',
    'adjectivales',
    'adjectivant',
    'adjectivas',
    'adjectivasse',
    'adjectivaux',
    'adjective',
    'adjectivent',
    'adjectiver',
    'adjectivera',
    'adjectiverai',
    'adjectiveras',
    'adjectiverez',
    'adjectives',
    'adjectivez',
    'adjectiviez',
    'adjectivions',
    'adjectivisa',
    'adjectivisai',
    'adjectivisas',
    'adjectivise',
    'adjectiviser',
    'adjectivises',
    'adjectivisez',
    'adjectivisât',
    'adjectivisé',
    'adjectivisée',
    'adjectivisés',
    'adjectivons',
    'adjectivâmes',
    'adjectivât',
    'adjectivâtes',
    'adjectivé',
    'adjectivée',
    'adjectivées',
    'adjectivés',
    'adjoignaient',
    'adjoignais',
    'adjoignait',
    'adjoignant',
    'adjoigne',
    'adjoignent',
    'adjoignes',
    'adjoignez',
    'adjoigniez',
    'adjoignions',
    'adjoignirent',
    'adjoignis',
    'adjoignisse',
    'adjoignisses',
    'adjoignit',
    'adjoignons',
    'adjoignîmes',
    'adjoignît',
    'adjoignîtes',
    'adjoindra',
    'adjoindrai',
    'adjoindrais',
    'adjoindrait',
    'adjoindras',
    'adjoindre',
    'adjoindrez',
    'adjoindriez',
    'adjoindrions',
    'adjoindrons',
    'adjoindront',
    'adjoins',
    'adjoint',
    'adjointe',
    'adjointes',
    'adjoints',
    'adjonction',
    'adjonctions',
    'adjudant',
    'adjudante',
    'adjudantes',
    'adjudants',
    'adjudicateur',
    'adjudicatif',
    'adjudicatifs',
    'adjudication',
    'adjudicative',
    'adjuge',
    'adjugea',
    'adjugeai',
    'adjugeaient',
    'adjugeais',
    'adjugeait',
    'adjugeant',
    'adjugeas',
    'adjugeasse',
    'adjugeassent',
    'adjugeasses',
    'adjugeassiez',
    'adjugent',
    'adjugeons',
    'adjuger',
    'adjugera',
    'adjugerai',
    'adjugeraient',
    'adjugerais',
    'adjugerait',
    'adjugeras',
    'adjugerez',
    'adjugeriez',
    'adjugerions',
    'adjugerons',
    'adjugeront',
    'adjuges',
    'adjugez',
    'adjugeâmes',
    'adjugeât',
    'adjugeâtes',
    'adjugiez',
    'adjugions',
    'adjugèrent',
    'adjugé',
    'adjugée',
    'adjugées',
    'adjugés',
    'adjura',
    'adjurai',
    'adjuraient',
    'adjurais',
    'adjurait',
    'adjurant',
    'adjuras',
    'adjurasse',
    'adjurassent',
    'adjurasses',
    'adjurassiez',
    'adjurassions',
    'adjuration',
    'adjurations',
    'adjure',
    'adjurent',
    'adjurer',
    'adjurera',
    'adjurerai',
    'adjureraient',
    'adjurerais',
    'adjurerait',
    'adjureras',
    'adjurerez',
    'adjureriez',
    'adjurerions',
    'adjurerons',
    'adjureront',
    'adjures',
    'adjurez',
    'adjuriez',
    'adjurions',
    'adjurons',
    'adjurâmes',
    'adjurât',
    'adjurâtes',
    'adjurèrent',
    'adjuré',
    'adjurée',
    'adjurées',
    'adjurés',
    'adjuvant',
    'adjuvante',
    'adjuvantes',
    'adjuvants',
    'adjuvat',
    'adjuvats',
    'admet',
    'admets',
    'admettaient',
    'admettais',
    'admettait',
    'admettant',
    'admette',
    'admettent',
    'admettes',
    'admettez',
    'admettiez',
    'admettions',
    'admettons',
    'admettra',
    'admettrai',
    'admettraient',
    'admettrais',
    'admettrait',
    'admettras',
    'admettre',
    'admettrez',
    'admettriez',
    'admettrions',
    'admettrons',
    'admettront',
    'adminicule',
    'adminicules',
    'administra',
    'administrai',
    'administrais',
    'administrait',
    'administrant',
    'administras',
    'administre',
    'administrent',
    'administrer',
    'administrera',
    'administres',
    'administrez',
    'administriez',
    'administrons',
    'administrât',
    'administré',
    'administrée',
    'administrées',
    'administrés',
    'admira',
    'admirable',
    'admirables',
    'admirai',
    'admiraient',
    'admirais',
    'admirait',
    'admirant',
    'admiras',
    'admirasse',
    'admirassent',
    'admirasses',
    'admirassiez',
    'admirassions',
    'admirateur',
    'admirateurs',
    'admiratif',
    'admiratifs',
    'admiration',
    'admirations',
    'admirative',
    'admiratives',
    'admiratrice',
    'admiratrices',
    'admire',
    'admirent',
    'admirer',
    'admirera',
    'admirerai',
    'admireraient',
    'admirerais',
    'admirerait',
    'admireras',
    'admirerez',
    'admireriez',
    'admirerions',
    'admirerons',
    'admireront',
    'admires',
    'admirez',
    'admiriez',
    'admirions',
    'admirons',
    'admirâmes',
    'admirât',
    'admirâtes',
    'admirèrent',
    'admiré',
    'admirée',
    'admirées',
    'admirés',
    'admis',
    'admise',
    'admises',
    'admisse',
    'admissent',
    'admisses',
    'admissible',
    'admissibles',
    'admissiez',
    'admission',
    'admissions',
    'admit',
    'admittance',
    'admittances',
    'admixtion',
    'admixtions',
    'admonesta',
    'admonestai',
    'admonestais',
    'admonestait',
    'admonestant',
    'admonestas',
    'admonestasse',
    'admoneste',
    'admonestent',
    'admonester',
    'admonestera',
    'admonesterai',
    'admonesteras',
    'admonesterez',
    'admonestes',
    'admonestez',
    'admonestiez',
    'admonestions',
    'admonestons',
    'admonestâmes',
    'admonestât',
    'admonestâtes',
    'admonesté',
    'admonestée',
    'admonestées',
    'admonestés',
    'admonition',
    'admonitions',
    'admîmes',
    'admît',
    'admîtes',
    'adné',
    'adnée',
    'adnées',
    'adnés',
    'adolescence',
    'adolescences',
    'adolescent',
    'adolescente',
    'adolescentes',
    'adolescents',
    'adonis',
    'adonisassiez',
    'adoniser',
    'adoniserez',
    'adoniseriez',
    'adoniserions',
    'adoniserons',
    'adonisez',
    'adonisiez',
    'adonisions',
    'adonisons',
    'adonisâmes',
    'adonisâtes',
    'adonisé',
    'adonisée',
    'adonisées',
    'adonisés',
    'adonna',
    'adonnaient',
    'adonnais',
    'adonnait',
    'adonnant',
    'adonnassiez',
    'adonnassions',
    'adonne',
    'adonnent',
    'adonner',
    'adonnera',
    'adonnerai',
    'adonneraient',
    'adonnerais',
    'adonnerait',
    'adonneras',
    'adonnerez',
    'adonneriez',
    'adonnerions',
    'adonnerons',
    'adonneront',
    'adonnes',
    'adonnez',
    'adonniez',
    'adonnions',
    'adonnons',
    'adonnâmes',
    'adonnâtes',
    'adonnèrent',
    'adonné',
    'adonnée',
    'adonnées',
    'adonnés',
    'adopta',
    'adoptable',
    'adoptables',
    'adoptai',
    'adoptaient',
    'adoptais',
    'adoptait',
    'adoptant',
    'adoptante',
    'adoptantes',
    'adoptants',
    'adoptas',
    'adoptasse',
    'adoptassent',
    'adoptasses',
    'adoptassiez',
    'adoptassions',
    'adopte',
    'adoptent',
    'adopter',
    'adoptera',
    'adopterai',
    'adopteraient',
    'adopterais',
    'adopterait',
    'adopteras',
    'adopterez',
    'adopteriez',
    'adopterions',
    'adopterons',
    'adopteront',
    'adoptes',
    'adoptez',
    'adoptiez',
    'adoptif',
    'adoptifs',
    'adoption',
    'adoptions',
    'adoptive',
    'adoptives',
    'adoptons',
    'adoptâmes',
    'adoptât',
    'adoptâtes',
    'adoptèrent',
    'adopté',
    'adoptée',
    'adoptées',
    'adoptés',
    'adora',
    'adorable',
    'adorablement',
    'adorables',
    'adorai',
    'adoraient',
    'adorais',
    'adorait',
    'adorant',
    'adoras',
    'adorasse',
    'adorassent',
    'adorasses',
    'adorassiez',
    'adorassions',
    'adorateur',
    'adorateurs',
    'adoration',
    'adorations',
    'adoratrice',
    'adoratrices',
    'adore',
    'adorent',
    'adorer',
    'adorera',
    'adorerai',
    'adoreraient',
    'adorerais',
    'adorerait',
    'adoreras',
    'adorerez',
    'adoreriez',
    'adorerions',
    'adorerons',
    'adoreront',
    'adores',
    'adorez',
    'adoriez',
    'adorions',
    'adorons',
    'adorâmes',
    'adorât',
    'adorâtes',
    'adorèrent',
    'adoré',
    'adorée',
    'adorées',
    'adorés',
    'ados',
    'adossa',
    'adossai',
    'adossaient',
    'adossais',
    'adossait',
    'adossant',
    'adossas',
    'adossasse',
    'adossassent',
    'adossasses',
    'adossassiez',
    'adossassions',
    'adosse',
    'adossement',
    'adossements',
    'adossent',
    'adosser',
    'adossera',
    'adosserai',
    'adosseraient',
    'adosserais',
    'adosserait',
    'adosseras',
    'adosserez',
    'adosseriez',
    'adosserions',
    'adosserons',
    'adosseront',
    'adosses',
    'adossez',
    'adossiez',
    'adossions',
    'adossons',
    'adossâmes',
    'adossât',
    'adossâtes',
    'adossèrent',
    'adossé',
    'adossée',
    'adossées',
    'adossés',
    'adouba',
    'adoubai',
    'adoubaient',
    'adoubais',
    'adoubait',
    'adoubant',
    'adoubas',
    'adoubasse',
    'adoubassent',
    'adoubasses',
    'adoubassiez',
    'adoubassions',
    'adoube',
    'adoubent',
    'adouber',
    'adoubera',
    'adouberai',
    'adouberaient',
    'adouberais',
    'adouberait',
    'adouberas',
    'adouberez',
    'adouberiez',
    'adouberions',
    'adouberons',
    'adouberont',
    'adoubes',
    'adoubez',
    'adoubiez',
    'adoubions',
    'adoubons',
    'adoubâmes',
    'adoubât',
    'adoubâtes',
    'adoubèrent',
    'adoubé',
    'adoubée',
    'adoubées',
    'adoubés',
    'adouci',
    'adoucie',
    'adoucies',
    'adoucir',
    'adoucira',
    'adoucirai',
    'adouciraient',
    'adoucirais',
    'adoucirait',
    'adouciras',
    'adoucirent',
    'adoucirez',
    'adouciriez',
    'adoucirions',
    'adoucirons',
    'adouciront',
    'adoucis',
    'adoucissage',
    'adoucissages',
    'adoucissais',
    'adoucissait',
    'adoucissant',
    'adoucissante',
    'adoucissants',
    'adoucisse',
    'adoucissent',
    'adoucisses',
    'adoucisseur',
    'adoucisseurs',
    'adoucissez',
    'adoucissiez',
    'adoucissions',
    'adoucissons',
    'adoucit',
    'adoucîmes',
    'adoucît',
    'adoucîtes',
    'adragante',
    'adragantes',
    'adressa',
    'adressage',
    'adressages',
    'adressai',
    'adressaient',
    'adressais',
    'adressait',
    'adressant',
    'adressas',
    'adressasse',
    'adressassent',
    'adressasses',
    'adressassiez',
    'adresse',
    'adressent',
    'adresser',
    'adressera',
    'adresserai',
    'adresserais',
    'adresserait',
    'adresseras',
    'adresserez',
    'adresseriez',
    'adresserions',
    'adresserons',
    'adresseront',
    'adresses',
    'adressez',
    'adressiez',
    'adressions',
    'adressons',
    'adressâmes',
    'adressât',
    'adressâtes',
    'adressèrent',
    'adressé',
    'adressée',
    'adressées',
    'adressés',
    'adret',
    'adrets',
    'adroit',
    'adroite',
    'adroitement',
    'adroites',
    'adroits',
    'adrénaline',
    'adrénalines',
    'adrénergique',
    'adsorbant',
    'adsorbante',
    'adsorbantes',
    'adsorbants',
    'adsorber',
    'adsorption',
    'adsorptions',
    'adstrat',
    'adstrats',
    'adula',
    'adulai',
    'adulaient',
    'adulais',
    'adulait',
    'adulant',
    'adulas',
    'adulasse',
    'adulassent',
    'adulasses',
    'adulassiez',
    'adulassions',
    'adulateur',
    'adulateurs',
    'adulation',
    'adulations',
    'adulatrice',
    'adulatrices',
    'adule',
    'adulent',
    'aduler',
    'adulera',
    'adulerai',
    'aduleraient',
    'adulerais',
    'adulerait',
    'aduleras',
    'adulerez',
    'aduleriez',
    'adulerions',
    'adulerons',
    'aduleront',
    'adules',
    'adulez',
    'aduliez',
    'adulions',
    'adulons',
    'adulte',
    'adultes',
    'adultisme',
    'adultismes',
    'adultère',
    'adultèrent',
    'adultères',
    'adultéra',
    'adultérai',
    'adultéraient',
    'adultérais',
    'adultérait',
    'adultérant',
    'adultéras',
    'adultérasse',
    'adultérasses',
    'adultération',
    'adultérer',
    'adultérera',
    'adultérerai',
    'adultérerais',
    'adultérerait',
    'adultéreras',
    'adultérerez',
    'adultéreriez',
    'adultérerons',
    'adultéreront',
    'adultérez',
    'adultériez',
    'adultérin',
    'adultérine',
    'adultérines',
    'adultérins',
    'adultérions',
    'adultérons',
    'adultérâmes',
    'adultérât',
    'adultérâtes',
    'adultérèrent',
    'adultéré',
    'adultérée',
    'adultérées',
    'adultérés',
    'adulâmes',
    'adulât',
    'adulâtes',
    'adulèrent',
    'adulé',
    'adulée',
    'adulées',
    'adulés',
    'advection',
    'advections',
    'advenait',
    'advenir',
    'adventif',
    'adventifs',
    'adventiste',
    'adventistes',
    'adventive',
    'adventives',
    'advenu',
    'advenue',
    'advenues',
    'advenus',
    'adverbe',
    'adverbes',
    'adverbial',
    'adverbiale',
    'adverbiales',
    'adverbiaux',
    'adversaire',
    'adversaires',
    'adversatif',
    'adversatifs',
    'adversative',
    'adversatives',
    'adverse',
    'adverses',
    'adversité',
    'adversités',
    'adviendra',
    'adviendrait',
    'advienne',
    'advient',
    'advint',
    'advînt',
    'adynamie',
    'adynamies',
    'adénite',
    'adénites',
    'adénome',
    'adénomes',
    'adénopathie',
    'adénopathies',
    'adénosine',
    'adénosines',
    'adénoïde',
    'adénoïdes',
    'adéquat',
    'adéquate',
    'adéquatement',
    'adéquates',
    'adéquation',
    'adéquations',
    'adéquats',
    'aegosome',
    'aegosomes',
    'aequo',
    'aeschne',
    'aeschnes',
    'affabilité',
    'affabilités',
    'affable',
    'affablement',
    'affables',
    'affabula',
    'affabulai',
    'affabulaient',
    'affabulais',
    'affabulait',
    'affabulant',
    'affabulas',
    'affabulasse',
    'affabulasses',
    'affabulation',
    'affabule',
    'affabulent',
    'affabuler',
    'affabulera',
    'affabulerai',
    'affabulerais',
    'affabulerait',
    'affabuleras',
    'affabulerez',
    'affabuleriez',
    'affabulerons',
    'affabuleront',
    'affabules',
    'affabulez',
    'affabuliez',
    'affabulions',
    'affabulons',
    'affabulâmes',
    'affabulât',
    'affabulâtes',
    'affabulèrent',
    'affabulé',
    'affabulée',
    'affabulées',
    'affabulés',
    'affacturage',
    'affacturages',
    'affacturant',
    'affacturer',
    'affacturé',
    'affacturée',
    'affacturées',
    'affacturés',
    'affadi',
    'affadie',
    'affadies',
    'affadir',
    'affadira',
    'affadirai',
    'affadiraient',
    'affadirais',
    'affadirait',
    'affadiras',
    'affadirent',
    'affadirez',
    'affadiriez',
    'affadirions',
    'affadirons',
    'affadiront',
    'affadis',
    'affadissais',
    'affadissait',
    'affadissant',
    'affadissante',
    'affadissants',
    'affadisse',
    'affadissent',
    'affadisses',
    'affadissez',
    'affadissiez',
    'affadissions',
    'affadissons',
    'affadit',
    'affadîmes',
    'affadît',
    'affadîtes',
    'affaibli',
    'affaiblie',
    'affaiblies',
    'affaiblir',
    'affaiblira',
    'affaiblirai',
    'affaiblirais',
    'affaiblirait',
    'affaibliras',
    'affaiblirent',
    'affaiblirez',
    'affaibliriez',
    'affaiblirons',
    'affaibliront',
    'affaiblis',
    'affaiblisse',
    'affaiblisses',
    'affaiblissez',
    'affaiblit',
    'affaiblîmes',
    'affaiblît',
    'affaiblîtes',
    'affaira',
    'affairaient',
    'affairais',
    'affairait',
    'affairant',
    'affairassiez',
    'affaire',
    'affairement',
    'affairements',
    'affairent',
    'affairer',
    'affairera',
    'affairerai',
    'affairerais',
    'affairerait',
    'affaireras',
    'affairerez',
    'affaireriez',
    'affairerions',
    'affairerons',
    'affaireront',
    'affaires',
    'affairez',
    'affairiez',
    'affairions',
    'affairisme',
    'affairismes',
    'affairiste',
    'affairistes',
    'affairons',
    'affairâmes',
    'affairâtes',
    'affairèrent',
    'affairé',
    'affairée',
    'affairées',
    'affairés',
    'affaissa',
    'affaissai',
    'affaissaient',
    'affaissais',
    'affaissait',
    'affaissant',
    'affaissas',
    'affaissasse',
    'affaissasses',
    'affaisse',
    'affaissement',
    'affaissent',
    'affaisser',
    'affaissera',
    'affaisserai',
    'affaisserais',
    'affaisserait',
    'affaisseras',
    'affaisserez',
    'affaisseriez',
    'affaisserons',
    'affaisseront',
    'affaisses',
    'affaissez',
    'affaissiez',
    'affaissions',
    'affaissons',
    'affaissâmes',
    'affaissât',
    'affaissâtes',
    'affaissèrent',
    'affaissé',
    'affaissée',
    'affaissées',
    'affaissés',
    'affaitage',
    'affaitages',
    'affaitement',
    'affaitements',
    'affala',
    'affalai',
    'affalaient',
    'affalais',
    'affalait',
    'affalant',
    'affalas',
    'affalasse',
    'affalassent',
    'affalasses',
    'affalassiez',
    'affalassions',
    'affale',
    'affalement',
    'affalements',
    'affalent',
    'affaler',
    'affalera',
    'affalerai',
    'affaleraient',
    'affalerais',
    'affalerait',
    'affaleras',
    'affalerez',
    'affaleriez',
    'affalerions',
    'affalerons',
    'affaleront',
    'affales',
    'affalez',
    'affaliez',
    'affalions',
    'affalons',
    'affalâmes',
    'affalât',
    'affalâtes',
    'affalèrent',
    'affalé',
    'affalée',
    'affalées',
    'affalés',
    'affama',
    'affamai',
    'affamaient',
    'affamais',
    'affamait',
    'affamant',
    'affamas',
    'affamasse',
    'affamassent',
    'affamasses',
    'affamassiez',
    'affamassions',
    'affame',
    'affament',
    'affamer',
    'affamera',
    'affamerai',
    'affameraient',
    'affamerais',
    'affamerait',
    'affameras',
    'affamerez',
    'affameriez',
    'affamerions',
    'affamerons',
    'affameront',
    'affames',
    'affameur',
    'affameurs',
    'affamez',
    'affamiez',
    'affamions',
    'affamons',
    'affamâmes',
    'affamât',
    'affamâtes',
    'affamèrent',
    'affamé',
    'affamée',
    'affamées',
    'affamés',
    'affect',
    'affecta',
    'affectai',
    'affectaient',
    'affectais',
    'affectait',
    'affectant',
    'affectas',
    'affectasse',
    'affectassent',
    'affectasses',
    'affectassiez',
    'affectation',
    'affectations',
    'affecte',
    'affectent',
    'affecter',
    'affectera',
    'affecterai',
    'affecterais',
    'affecterait',
    'affecteras',
    'affecterez',
    'affecteriez',
    'affecterions',
    'affecterons',
    'affecteront',
    'affectes',
    'affectez',
    'affectiez',
    'affectif',
    'affectifs',
    'affection',
    'affectionna',
    'affectionnai',
    'affectionnas',
    'affectionne',
    'affectionner',
    'affectionnes',
    'affectionnez',
    'affectionnât',
    'affectionné',
    'affectionnée',
    'affectionnés',
    'affections',
    'affective',
    'affectives',
    'affectivité',
    'affectivités',
    'affectons',
    'affects',
    'affectueuse',
    'affectueuses',
    'affectueux',
    'affectâmes',
    'affectât',
    'affectâtes',
    'affectèrent',
    'affecté',
    'affectée',
    'affectées',
    'affectés',
    'affenage',
    'affenages',
    'afferma',
    'affermage',
    'affermages',
    'affermai',
    'affermaient',
    'affermais',
    'affermait',
    'affermant',
    'affermas',
    'affermasse',
    'affermassent',
    'affermasses',
    'affermassiez',
    'afferme',
    'afferment',
    'affermer',
    'affermera',
    'affermerai',
    'affermerais',
    'affermerait',
    'affermeras',
    'affermerez',
    'affermeriez',
    'affermerions',
    'affermerons',
    'affermeront',
    'affermes',
    'affermez',
    'affermi',
    'affermie',
    'affermies',
    'affermiez',
    'affermions',
    'affermir',
    'affermira',
    'affermirai',
    'affermirais',
    'affermirait',
    'affermiras',
    'affermirent',
    'affermirez',
    'affermiriez',
    'affermirions',
    'affermirons',
    'affermiront',
    'affermis',
    'affermissais',
    'affermissait',
    'affermissant',
    'affermisse',
    'affermissent',
    'affermisses',
    'affermissez',
    'affermissiez',
    'affermissons',
    'affermit',
    'affermons',
    'affermâmes',
    'affermât',
    'affermâtes',
    'affermèrent',
    'affermé',
    'affermée',
    'affermées',
    'affermés',
    'affermîmes',
    'affermît',
    'affermîtes',
    'afficha',
    'affichable',
    'affichables',
    'affichage',
    'affichages',
    'affichai',
    'affichaient',
    'affichais',
    'affichait',
    'affichant',
    'affichas',
    'affichasse',
    'affichassent',
    'affichasses',
    'affichassiez',
    'affiche',
    'affichent',
    'afficher',
    'affichera',
    'afficherai',
    'afficherais',
    'afficherait',
    'afficheras',
    'afficherez',
    'afficheriez',
    'afficherions',
    'afficherons',
    'afficheront',
    'affiches',
    'affichette',
    'affichettes',
    'afficheur',
    'afficheurs',
    'affichez',
    'affichiez',
    'affichions',
    'affichiste',
    'affichistes',
    'affichons',
    'affichâmes',
    'affichât',
    'affichâtes',
    'affichèrent',
    'affiché',
    'affichée',
    'affichées',
    'affichés',
    'affidavit',
    'affidavits',
    'affidé',
    'affidée',
    'affidées',
    'affidés',
    'affila',
    'affilage',
    'affilages',
    'affilai',
    'affilaient',
    'affilais',
    'affilait',
    'affilant',
    'affilas',
    'affilasse',
    'affilassent',
    'affilasses',
    'affilassiez',
    'affilassions',
    'affile',
    'affilent',
    'affiler',
    'affilera',
    'affilerai',
    'affileraient',
    'affilerais',
    'affilerait',
    'affileras',
    'affilerez',
    'affileriez',
    'affilerions',
    'affilerons',
    'affileront',
    'affiles',
    'affilez',
    'affilia',
    'affiliai',
    'affiliaient',
    'affiliais',
    'affiliait',
    'affiliant',
    'affilias',
    'affiliasse',
    'affiliassent',
    'affiliasses',
    'affiliassiez',
    'affiliation',
    'affiliations',
    'affilie',
    'affilient',
    'affilier',
    'affiliera',
    'affilierai',
    'affilierais',
    'affilierait',
    'affilieras',
    'affilierez',
    'affilieriez',
    'affilierions',
    'affilierons',
    'affilieront',
    'affilies',
    'affiliez',
    'affiliiez',
    'affiliions',
    'affilions',
    'affiliâmes',
    'affiliât',
    'affiliâtes',
    'affilièrent',
    'affilié',
    'affiliée',
    'affiliées',
    'affiliés',
    'affiloir',
    'affiloirs',
    'affilons',
    'affilâmes',
    'affilât',
    'affilâtes',
    'affilèrent',
    'affilé',
    'affilée',
    'affilées',
    'affilés',
    'affin',
    'affina',
    'affinage',
    'affinages',
    'affinai',
    'affinaient',
    'affinais',
    'affinait',
    'affinant',
    'affinas',
    'affinasse',
    'affinassent',
    'affinasses',
    'affinassiez',
    'affinassions',
    'affine',
    'affinement',
    'affinements',
    'affinent',
    'affiner',
    'affinera',
    'affinerai',
    'affineraient',
    'affinerais',
    'affinerait',
    'affineras',
    'affinerez',
    'affineriez',
    'affinerions',
    'affinerons',
    'affineront',
    'affines',
    'affineur',
    'affineurs',
    'affineuse',
    'affineuses',
    'affinez',
    'affiniez',
    'affinions',
    'affinité',
    'affinités',
    'affinons',
    'affins',
    'affinâmes',
    'affinât',
    'affinâtes',
    'affinèrent',
    'affiné',
    'affinée',
    'affinées',
    'affinés',
    'affiquet',
    'affiquets',
    'affirma',
    'affirmai',
    'affirmaient',
    'affirmais',
    'affirmait',
    'affirmant',
    'affirmas',
    'affirmasse',
    'affirmassent',
    'affirmasses',
    'affirmassiez',
    'affirmatif',
    'affirmatifs',
    'affirmation',
    'affirmations',
    'affirmative',
    'affirmatives',
    'affirme',
    'affirment',
    'affirmer',
    'affirmera',
    'affirmerai',
    'affirmerais',
    'affirmerait',
    'affirmeras',
    'affirmerez',
    'affirmeriez',
    'affirmerions',
    'affirmerons',
    'affirmeront',
    'affirmes',
    'affirmez',
    'affirmiez',
    'affirmions',
    'affirmons',
    'affirmâmes',
    'affirmât',
    'affirmâtes',
    'affirmèrent',
    'affirmé',
    'affirmée',
    'affirmées',
    'affirmés',
    'affixal',
    'affixale',
    'affixales',
    'affixation',
    'affixations',
    'affixaux',
    'affixe',
    'affixes',
    'affleura',
    'affleurai',
    'affleuraient',
    'affleurais',
    'affleurait',
    'affleurant',
    'affleuras',
    'affleurasse',
    'affleurasses',
    'affleure',
    'affleurement',
    'affleurent',
    'affleurer',
    'affleurera',
    'affleurerai',
    'affleurerais',
    'affleurerait',
    'affleureras',
    'affleurerez',
    'affleureriez',
    'affleurerons',
    'affleureront',
    'affleures',
    'affleurez',
    'affleuriez',
    'affleurions',
    'affleurons',
    'affleurâmes',
    'affleurât',
    'affleurâtes',
    'affleurèrent',
    'affleuré',
    'affleurée',
    'affleurées',
    'affleurés',
    'afflictif',
    'afflictifs',
    'affliction',
    'afflictions',
    'afflictive',
    'afflictives',
    'afflige',
    'affligea',
    'affligeai',
    'affligeaient',
    'affligeais',
    'affligeait',
    'affligeant',
    'affligeante',
    'affligeantes',
    'affligeants',
    'affligeas',
    'affligeasse',
    'affligeasses',
    'affligent',
    'affligeons',
    'affliger',
    'affligera',
    'affligerai',
    'affligerais',
    'affligerait',
    'affligeras',
    'affligerez',
    'affligeriez',
    'affligerions',
    'affligerons',
    'affligeront',
    'affliges',
    'affligez',
    'affligeâmes',
    'affligeât',
    'affligeâtes',
    'affligiez',
    'affligions',
    'affligèrent',
    'affligé',
    'affligée',
    'affligées',
    'affligés',
    'affloua',
    'afflouai',
    'afflouaient',
    'afflouais',
    'afflouait',
    'afflouant',
    'afflouas',
    'afflouasse',
    'afflouassent',
    'afflouasses',
    'afflouassiez',
    'affloue',
    'afflouent',
    'afflouer',
    'afflouera',
    'afflouerai',
    'afflouerais',
    'afflouerait',
    'affloueras',
    'afflouerez',
    'affloueriez',
    'afflouerions',
    'afflouerons',
    'affloueront',
    'affloues',
    'afflouez',
    'afflouiez',
    'afflouions',
    'afflouons',
    'afflouâmes',
    'afflouât',
    'afflouâtes',
    'afflouèrent',
    'affloué',
    'afflouée',
    'afflouées',
    'affloués',
    'afflua',
    'affluai',
    'affluaient',
    'affluais',
    'affluait',
    'affluant',
    'affluas',
    'affluasse',
    'affluassent',
    'affluasses',
    'affluassiez',
    'affluassions',
    'afflue',
    'affluence',
    'affluences',
    'affluent',
    'affluente',
    'affluentes',
    'affluents',
    'affluer',
    'affluera',
    'affluerai',
    'afflueraient',
    'affluerais',
    'affluerait',
    'afflueras',
    'affluerez',
    'afflueriez',
    'affluerions',
    'affluerons',
    'afflueront',
    'afflues',
    'affluez',
    'affluiez',
    'affluions',
    'affluons',
    'afflux',
    'affluâmes',
    'affluât',
    'affluâtes',
    'affluèrent',
    'afflué',
    'affola',
    'affolai',
    'affolaient',
    'affolais',
    'affolait',
    'affolant',
    'affolante',
    'affolantes',
    'affolants',
    'affolas',
    'affolasse',
    'affolassent',
    'affolasses',
    'affolassiez',
    'affolassions',
    'affole',
    'affolement',
    'affolements',
    'affolent',
    'affoler',
    'affolera',
    'affolerai',
    'affoleraient',
    'affolerais',
    'affolerait',
    'affoleras',
    'affolerez',
    'affoleriez',
    'affolerions',
    'affolerons',
    'affoleront',
    'affoles',
    'affolez',
    'affoliez',
    'affolions',
    'affolons',
    'affolâmes',
    'affolât',
    'affolâtes',
    'affolèrent',
    'affolé',
    'affolée',
    'affolées',
    'affolés',
    'affouage',
    'affouagea',
    'affouageai',
    'affouageais',
    'affouageait',
    'affouageant',
    'affouageas',
    'affouageasse',
    'affouagent',
    'affouageons',
    'affouager',
    'affouagera',
    'affouagerai',
    'affouagerais',
    'affouagerait',
    'affouageras',
    'affouagerez',
    'affouageriez',
    'affouagerons',
    'affouageront',
    'affouages',
    'affouagez',
    'affouageâmes',
    'affouageât',
    'affouageâtes',
    'affouagiez',
    'affouagions',
    'affouagèrent',
    'affouagé',
    'affouagée',
    'affouagées',
    'affouagés',
    'affouilla',
    'affouillai',
    'affouillais',
    'affouillait',
    'affouillant',
    'affouillas',
    'affouillasse',
    'affouille',
    'affouillent',
    'affouiller',
    'affouillera',
    'affouillerai',
    'affouilleras',
    'affouillerez',
    'affouilles',
    'affouillez',
    'affouilliez',
    'affouillions',
    'affouillons',
    'affouillâmes',
    'affouillât',
    'affouillâtes',
    'affouillé',
    'affouillée',
    'affouillées',
    'affouillés',
    'affourage',
    'affouragea',
    'affourageai',
    'affourageais',
    'affourageait',
    'affourageant',
    'affourageas',
    'affouragent',
    'affourageons',
    'affourager',
    'affouragera',
    'affouragerai',
    'affourageras',
    'affouragerez',
    'affourages',
    'affouragez',
    'affourageât',
    'affouragiez',
    'affouragions',
    'affouragé',
    'affouragée',
    'affouragées',
    'affouragés',
    'affourcha',
    'affourchai',
    'affourchais',
    'affourchait',
    'affourchant',
    'affourchas',
    'affourchasse',
    'affourche',
    'affourchent',
    'affourcher',
    'affourchera',
    'affourcherai',
    'affourcheras',
    'affourcherez',
    'affourches',
    'affourchez',
    'affourchiez',
    'affourchions',
    'affourchons',
    'affourchâmes',
    'affourchât',
    'affourchâtes',
    'affourché',
    'affourchée',
    'affourchées',
    'affourchés',
    'affourrage',
    'affourragea',
    'affourrageai',
    'affourrageas',
    'affourragent',
    'affourrager',
    'affourragera',
    'affourrages',
    'affourragez',
    'affourrageât',
    'affourragiez',
    'affourragé',
    'affourragée',
    'affourragées',
    'affourragés',
    'affranchi',
    'affranchie',
    'affranchies',
    'affranchir',
    'affranchira',
    'affranchirai',
    'affranchiras',
    'affranchirez',
    'affranchis',
    'affranchisse',
    'affranchit',
    'affranchîmes',
    'affranchît',
    'affranchîtes',
    'affres',
    'affreuse',
    'affreusement',
    'affreuses',
    'affreux',
    'affrianda',
    'affriandai',
    'affriandais',
    'affriandait',
    'affriandant',
    'affriandas',
    'affriandasse',
    'affriande',
    'affriandent',
    'affriander',
    'affriandera',
    'affrianderai',
    'affrianderas',
    'affrianderez',
    'affriandes',
    'affriandez',
    'affriandiez',
    'affriandions',
    'affriandons',
    'affriandâmes',
    'affriandât',
    'affriandâtes',
    'affriandé',
    'affriandée',
    'affriandées',
    'affriandés',
    'affricha',
    'affrichai',
    'affrichaient',
    'affrichais',
    'affrichait',
    'affrichant',
    'affrichas',
    'affrichasse',
    'affrichasses',
    'affriche',
    'affrichent',
    'affricher',
    'affrichera',
    'affricherai',
    'affricherais',
    'affricherait',
    'affricheras',
    'affricherez',
    'affricheriez',
    'affricherons',
    'affricheront',
    'affriches',
    'affrichez',
    'affrichiez',
    'affrichions',
    'affrichons',
    'affrichâmes',
    'affrichât',
    'affrichâtes',
    'affrichèrent',
    'affriché',
    'affrichée',
    'affrichées',
    'affrichés',
    'affriola',
    'affriolai',
    'affriolaient',
    'affriolais',
    'affriolait',
    'affriolant',
    'affriolante',
    'affriolantes',
    'affriolants',
    'affriolas',
    'affriolasse',
    'affriolasses',
    'affriole',
    'affriolent',
    'affrioler',
    'affriolera',
    'affriolerai',
    'affriolerais',
    'affriolerait',
    'affrioleras',
    'affriolerez',
    'affrioleriez',
    'affriolerons',
    'affrioleront',
    'affrioles',
    'affriolez',
    'affrioliez',
    'affriolions',
    'affriolons',
    'affriolâmes',
    'affriolât',
    'affriolâtes',
    'affriolèrent',
    'affriolé',
    'affriolée',
    'affriolées',
    'affriolés',
    'affriquée',
    'affriquées',
    'affrita',
    'affritai',
    'affritaient',
    'affritais',
    'affritait',
    'affritant',
    'affritas',
    'affritasse',
    'affritassent',
    'affritasses',
    'affritassiez',
    'affrite',
    'affritent',
    'affriter',
    'affritera',
    'affriterai',
    'affriterais',
    'affriterait',
    'affriteras',
    'affriterez',
    'affriteriez',
    'affriterions',
    'affriterons',
    'affriteront',
    'affrites',
    'affritez',
    'affritiez',
    'affritions',
    'affritons',
    'affritâmes',
    'affritât',
    'affritâtes',
    'affritèrent',
    'affrité',
    'affritée',
    'affritées',
    'affrités',
    'affront',
    'affronta',
    'affrontai',
    'affrontaient',
    'affrontais',
    'affrontait',
    'affrontant',
    'affrontas',
    'affrontasse',
    'affrontasses',
    'affronte',
    'affrontement',
    'affrontent',
    'affronter',
    'affrontera',
    'affronterai',
    'affronterais',
    'affronterait',
    'affronteras',
    'affronterez',
    'affronteriez',
    'affronterons',
    'affronteront',
    'affrontes',
    'affrontez',
    'affrontiez',
    'affrontions',
    'affrontons',
    'affronts',
    'affrontâmes',
    'affrontât',
    'affrontâtes',
    'affrontèrent',
    'affronté',
    'affrontée',
    'affrontées',
    'affrontés',
    'affruita',
    'affruitai',
    'affruitaient',
    'affruitais',
    'affruitait',
    'affruitant',
    'affruitas',
    'affruitasse',
    'affruitasses',
    'affruite',
    'affruitent',
    'affruiter',
    'affruitera',
    'affruiterai',
    'affruiterais',
    'affruiterait',
    'affruiteras',
    'affruiterez',
    'affruiteriez',
    'affruiterons',
    'affruiteront',
    'affruites',
    'affruitez',
    'affruitiez',
    'affruitions',
    'affruitons',
    'affruitâmes',
    'affruitât',
    'affruitâtes',
    'affruitèrent',
    'affruité',
    'affrète',
    'affrètement',
    'affrètements',
    'affrètent',
    'affrètes',
    'affréta',
    'affrétai',
    'affrétaient',
    'affrétais',
    'affrétait',
    'affrétant',
    'affrétas',
    'affrétasse',
    'affrétassent',
    'affrétasses',
    'affrétassiez',
    'affréter',
    'affrétera',
    'affréterai',
    'affréterais',
    'affréterait',
    'affréteras',
    'affréterez',
    'affréteriez',
    'affréterions',
    'affréterons',
    'affréteront',
    'affréteur',
    'affréteurs',
    'affrétez',
    'affrétiez',
    'affrétions',
    'affrétons',
    'affrétâmes',
    'affrétât',
    'affrétâtes',
    'affrétèrent',
    'affrété',
    'affrétée',
    'affrétées',
    'affrétés',
    'affubla',
    'affublai',
    'affublaient',
    'affublais',
    'affublait',
    'affublant',
    'affublas',
    'affublasse',
    'affublassent',
    'affublasses',
    'affublassiez',
    'affuble',
    'affublement',
    'affublements',
    'affublent',
    'affubler',
    'affublera',
    'affublerai',
    'affublerais',
    'affublerait',
    'affubleras',
    'affublerez',
    'affubleriez',
    'affublerions',
    'affublerons',
    'affubleront',
    'affubles',
    'affublez',
    'affubliez',
    'affublions',
    'affublons',
    'affublâmes',
    'affublât',
    'affublâtes',
    'affublèrent',
    'affublé',
    'affublée',
    'affublées',
    'affublés',
    'affura',
    'affurai',
    'affuraient',
    'affurais',
    'affurait',
    'affurant',
    'affuras',
    'affurasse',
    'affurassent',
    'affurasses',
    'affurassiez',
    'affurassions',
    'affure',
    'affurent',
    'affurer',
    'affurera',
    'affurerai',
    'affureraient',
    'affurerais',
    'affurerait',
    'affureras',
    'affurerez',
    'affureriez',
    'affurerions',
    'affurerons',
    'affureront',
    'affures',
    'affurez',
    'affuriez',
    'affurions',
    'affurons',
    'affurâmes',
    'affurât',
    'affurâtes',
    'affurèrent',
    'affuré',
    'affurée',
    'affurées',
    'affurés',
    'affusion',
    'affusions',
    'affère',
    'affèrent',
    'affères',
    'afféage',
    'afféagea',
    'afféageai',
    'afféageaient',
    'afféageais',
    'afféageait',
    'afféageant',
    'afféageas',
    'afféageasse',
    'afféageasses',
    'afféagent',
    'afféageons',
    'afféager',
    'afféagera',
    'afféagerai',
    'afféagerais',
    'afféagerait',
    'afféageras',
    'afféagerez',
    'afféageriez',
    'afféagerions',
    'afféagerons',
    'afféageront',
    'afféages',
    'afféagez',
    'afféageâmes',
    'afféageât',
    'afféageâtes',
    'afféagiez',
    'afféagions',
    'afféagèrent',
    'afféagé',
    'afféagée',
    'afféagées',
    'afféagés',
    'afféra',
    'afférai',
    'afféraient',
    'afférais',
    'afférait',
    'afférant',
    'afféras',
    'afférasse',
    'afférassent',
    'afférasses',
    'afférassiez',
    'afférassions',
    'afférent',
    'afférente',
    'afférentes',
    'afférents',
    'afférer',
    'afférera',
    'afférerai',
    'afféreraient',
    'afférerais',
    'afférerait',
    'afféreras',
    'afférerez',
    'afféreriez',
    'afférerions',
    'afférerons',
    'afféreront',
    'afférez',
    'affériez',
    'afférions',
    'afférons',
    'afférâmes',
    'afférât',
    'afférâtes',
    'afférèrent',
    'afféré',
    'afféterie',
    'afféteries',
    'affété',
    'affétée',
    'affétées',
    'affétés',
    'affût',
    'affûta',
    'affûtage',
    'affûtages',
    'affûtai',
    'affûtaient',
    'affûtais',
    'affûtait',
    'affûtant',
    'affûtas',
    'affûtasse',
    'affûtassent',
    'affûtasses',
    'affûtassiez',
    'affûtassions',
    'affûte',
    'affûtent',
    'affûter',
    'affûtera',
    'affûterai',
    'affûteraient',
    'affûterais',
    'affûterait',
    'affûteras',
    'affûterez',
    'affûteriez',
    'affûterions',
    'affûterons',
    'affûteront',
    'affûtes',
    'affûteur',
    'affûteurs',
    'affûteuse',
    'affûteuses',
    'affûtez',
    'affûtiaux',
    'affûtiez',
    'affûtions',
    'affûtons',
    'affûts',
    'affûtâmes',
    'affûtât',
    'affûtâtes',
    'affûtèrent',
    'affûté',
    'affûtée',
    'affûtées',
    'affûtés',
    'afghan',
    'afghane',
    'afghanes',
    'afghans',
    'aficionado',
    'aficionados',
    'afin',
    'afocal',
    'afocale',
    'afocales',
    'afocaux',
    'africain',
    'africaine',
    'africaines',
    'africains',
    'africanisa',
    'africanisai',
    'africanisais',
    'africanisait',
    'africanisant',
    'africanisas',
    'africanise',
    'africanisent',
    'africaniser',
    'africanisera',
    'africanises',
    'africanisez',
    'africanisiez',
    'africanisons',
    'africaniste',
    'africanistes',
    'africanisât',
    'africanisé',
    'africanisée',
    'africanisées',
    'africanisés',
    'afrikaans',
    'afrikander',
    'afrikaner',
    'afro',
    'agace',
    'agacement',
    'agacements',
    'agacent',
    'agacer',
    'agacera',
    'agacerai',
    'agaceraient',
    'agacerais',
    'agacerait',
    'agaceras',
    'agacerez',
    'agacerie',
    'agaceries',
    'agaceriez',
    'agacerions',
    'agacerons',
    'agaceront',
    'agaces',
    'agacez',
    'agaciez',
    'agacions',
    'agacèrent',
    'agacé',
    'agacée',
    'agacées',
    'agacés',
    'agalactie',
    'agalacties',
    'agami',
    'agamis',
    'agape',
    'agapes',
    'agaric',
    'agarics',
    'agate',
    'agates',
    'agatisé',
    'agatisée',
    'agatisées',
    'agatisés',
    'agave',
    'agaves',
    'agavé',
    'agavés',
    'agaça',
    'agaçai',
    'agaçaient',
    'agaçais',
    'agaçait',
    'agaçant',
    'agaçante',
    'agaçantes',
    'agaçants',
    'agaças',
    'agaçasse',
    'agaçassent',
    'agaçasses',
    'agaçassiez',
    'agaçassions',
    'agaçons',
    'agaçâmes',
    'agaçât',
    'agaçâtes',
    'agence',
    'agencement',
    'agencements',
    'agencent',
    'agencer',
    'agencera',
    'agencerai',
    'agenceraient',
    'agencerais',
    'agencerait',
    'agenceras',
    'agencerez',
    'agenceriez',
    'agencerions',
    'agencerons',
    'agenceront',
    'agences',
    'agencez',
    'agenciez',
    'agencions',
    'agencèrent',
    'agencé',
    'agencée',
    'agencées',
    'agencés',
    'agenda',
    'agendas',
    'agenouilla',
    'agenouillais',
    'agenouillait',
    'agenouillant',
    'agenouille',
    'agenouillent',
    'agenouiller',
    'agenouillera',
    'agenouilles',
    'agenouillez',
    'agenouilliez',
    'agenouilloir',
    'agenouillons',
    'agenouillé',
    'agenouillée',
    'agenouillées',
    'agenouillés',
    'agent',
    'agents',
    'agença',
    'agençai',
    'agençaient',
    'agençais',
    'agençait',
    'agençant',
    'agenças',
    'agençasse',
    'agençassent',
    'agençasses',
    'agençassiez',
    'agençassions',
    'agençons',
    'agençâmes',
    'agençât',
    'agençâtes',
    'agglomère',
    'agglomèrent',
    'agglomères',
    'aggloméra',
    'agglomérai',
    'agglomérais',
    'agglomérait',
    'agglomérant',
    'agglomérants',
    'aggloméras',
    'agglomérasse',
    'agglomérat',
    'agglomérats',
    'agglomérer',
    'agglomérera',
    'agglomérerai',
    'aggloméreras',
    'agglomérerez',
    'agglomérez',
    'agglomériez',
    'agglomérions',
    'agglomérons',
    'agglomérâmes',
    'agglomérât',
    'agglomérâtes',
    'aggloméré',
    'agglomérée',
    'agglomérées',
    'agglomérés',
    'agglutina',
    'agglutinai',
    'agglutinais',
    'agglutinait',
    'agglutinant',
    'agglutinante',
    'agglutinants',
    'agglutinas',
    'agglutinasse',
    'agglutine',
    'agglutinent',
    'agglutiner',
    'agglutinera',
    'agglutinerai',
    'agglutineras',
    'agglutinerez',
    'agglutines',
    'agglutinez',
    'agglutiniez',
    'agglutinions',
    'agglutinons',
    'agglutinâmes',
    'agglutinât',
    'agglutinâtes',
    'agglutiné',
    'agglutinée',
    'agglutinées',
    'agglutinés',
    'aggrava',
    'aggravai',
    'aggravaient',
    'aggravais',
    'aggravait',
    'aggravant',
    'aggravante',
    'aggravantes',
    'aggravants',
    'aggravas',
    'aggravasse',
    'aggravassent',
    'aggravasses',
    'aggravassiez',
    'aggravation',
    'aggravations',
    'aggrave',
    'aggravent',
    'aggraver',
    'aggravera',
    'aggraverai',
    'aggraverais',
    'aggraverait',
    'aggraveras',
    'aggraverez',
    'aggraveriez',
    'aggraverions',
    'aggraverons',
    'aggraveront',
    'aggraves',
    'aggravez',
    'aggraviez',
    'aggravions',
    'aggravons',
    'aggravâmes',
    'aggravât',
    'aggravâtes',
    'aggravèrent',
    'aggravé',
    'aggravée',
    'aggravées',
    'aggravés',
    'agha',
    'aghas',
    'agile',
    'agilement',
    'agiles',
    'agilité',
    'agilités',
    'agio',
    'agios',
    'agiota',
    'agiotage',
    'agiotages',
    'agiotai',
    'agiotaient',
    'agiotais',
    'agiotait',
    'agiotant',
    'agiotas',
    'agiotasse',
    'agiotassent',
    'agiotasses',
    'agiotassiez',
    'agiotassions',
    'agiote',
    'agiotent',
    'agioter',
    'agiotera',
    'agioterai',
    'agioteraient',
    'agioterais',
    'agioterait',
    'agioteras',
    'agioterez',
    'agioteriez',
    'agioterions',
    'agioterons',
    'agioteront',
    'agiotes',
    'agioteur',
    'agioteurs',
    'agiotez',
    'agiotiez',
    'agiotions',
    'agiotons',
    'agiotâmes',
    'agiotât',
    'agiotâtes',
    'agiotèrent',
    'agioté',
    'agir',
    'agira',
    'agirai',
    'agiraient',
    'agirais',
    'agirait',
    'agiras',
    'agirent',
    'agirez',
    'agiriez',
    'agirions',
    'agirons',
    'agiront',
    'agis',
    'agissaient',
    'agissais',
    'agissait',
    'agissant',
    'agissante',
    'agissantes',
    'agissants',
    'agisse',
    'agissement',
    'agissements',
    'agissent',
    'agisses',
    'agissez',
    'agissiez',
    'agissions',
    'agissons',
    'agit',
    'agita',
    'agitai',
    'agitaient',
    'agitais',
    'agitait',
    'agitant',
    'agitas',
    'agitasse',
    'agitassent',
    'agitasses',
    'agitassiez',
    'agitassions',
    'agitateur',
    'agitateurs',
    'agitation',
    'agitations',
    'agitato',
    'agitatrice',
    'agitatrices',
    'agite',
    'agitent',
    'agiter',
    'agitera',
    'agiterai',
    'agiteraient',
    'agiterais',
    'agiterait',
    'agiteras',
    'agiterez',
    'agiteriez',
    'agiterions',
    'agiterons',
    'agiteront',
    'agites',
    'agitez',
    'agitiez',
    'agitions',
    'agitons',
    'agitâmes',
    'agitât',
    'agitâtes',
    'agitèrent',
    'agité',
    'agitée',
    'agitées',
    'agités',
    'aglyphe',
    'aglyphes',
    'agnat',
    'agnathe',
    'agnathes',
    'agnats',
    'agneau',
    'agneaux',
    'agnela',
    'agnelage',
    'agnelages',
    'agnelai',
    'agnelaient',
    'agnelais',
    'agnelait',
    'agnelant',
    'agnelas',
    'agnelasse',
    'agnelassent',
    'agnelasses',
    'agnelassiez',
    'agnelassions',
    'agneler',
    'agnelet',
    'agnelets',
    'agnelez',
    'agneliez',
    'agnelin',
    'agneline',
    'agnelines',
    'agnelins',
    'agnelions',
    'agnelle',
    'agnellent',
    'agnellera',
    'agnellerai',
    'agnellerais',
    'agnellerait',
    'agnelleras',
    'agnellerez',
    'agnelleriez',
    'agnellerions',
    'agnellerons',
    'agnelleront',
    'agnelles',
    'agnelons',
    'agnelâmes',
    'agnelât',
    'agnelâtes',
    'agnelèrent',
    'agnelé',
    'agnosie',
    'agnosies',
    'agnosticisme',
    'agnostique',
    'agnostiques',
    'agonie',
    'agonies',
    'agonir',
    'agonira',
    'agonirai',
    'agoniraient',
    'agonirais',
    'agonirait',
    'agoniras',
    'agonirent',
    'agonirez',
    'agoniriez',
    'agonirions',
    'agonirons',
    'agoniront',
    'agonis',
    'agonisa',
    'agonisai',
    'agonisaient',
    'agonisais',
    'agonisait',
    'agonisant',
    'agonisante',
    'agonisantes',
    'agonisants',
    'agonisas',
    'agonisasse',
    'agonisassent',
    'agonisasses',
    'agonisassiez',
    'agonise',
    'agonisent',
    'agoniser',
    'agonisera',
    'agoniserai',
    'agoniserais',
    'agoniserait',
    'agoniseras',
    'agoniserez',
    'agoniseriez',
    'agoniserions',
    'agoniserons',
    'agoniseront',
    'agonises',
    'agonisez',
    'agonisiez',
    'agonisions',
    'agonisons',
    'agonissaient',
    'agonissais',
    'agonissait',
    'agonissant',
    'agonisse',
    'agonissent',
    'agonisses',
    'agonissez',
    'agonissiez',
    'agonissions',
    'agonissons',
    'agoniste',
    'agonistes',
    'agonisâmes',
    'agonisât',
    'agonisâtes',
    'agonisèrent',
    'agonisé',
    'agonit',
    'agonîmes',
    'agonît',
    'agonîtes',
    'agora',
    'agoraphobie',
    'agoraphobies',
    'agoras',
    'agouti',
    'agoutis',
    'agrafa',
    'agrafage',
    'agrafages',
    'agrafai',
    'agrafaient',
    'agrafais',
    'agrafait',
    'agrafant',
    'agrafas',
    'agrafasse',
    'agrafassent',
    'agrafasses',
    'agrafassiez',
    'agrafassions',
    'agrafe',
    'agrafent',
    'agrafer',
    'agrafera',
    'agraferai',
    'agraferaient',
    'agraferais',
    'agraferait',
    'agraferas',
    'agraferez',
    'agraferiez',
    'agraferions',
    'agraferons',
    'agraferont',
    'agrafes',
    'agrafeuse',
    'agrafeuses',
    'agrafez',
    'agrafiez',
    'agrafions',
    'agrafons',
    'agrafâmes',
    'agrafât',
    'agrafâtes',
    'agrafèrent',
    'agrafé',
    'agrafée',
    'agrafées',
    'agrafés',
    'agrainer',
    'agraire',
    'agraires',
    'agrammatical',
    'agrammatisme',
    'agrandi',
    'agrandie',
    'agrandies',
    'agrandir',
    'agrandira',
    'agrandirai',
    'agrandirais',
    'agrandirait',
    'agrandiras',
    'agrandirent',
    'agrandirez',
    'agrandiriez',
    'agrandirions',
    'agrandirons',
    'agrandiront',
    'agrandis',
    'agrandissais',
    'agrandissait',
    'agrandissant',
    'agrandisse',
    'agrandissent',
    'agrandisses',
    'agrandisseur',
    'agrandissez',
    'agrandissiez',
    'agrandissons',
    'agrandit',
    'agrandîmes',
    'agrandît',
    'agrandîtes',
    'agraphie',
    'agraphies',
    'agrarien',
    'agrarienne',
    'agrariennes',
    'agrariens',
    'agressa',
    'agressai',
    'agressaient',
    'agressais',
    'agressait',
    'agressant',
    'agressas',
    'agressasse',
    'agressassent',
    'agressasses',
    'agressassiez',
    'agresse',
    'agressent',
    'agresser',
    'agressera',
    'agresserai',
    'agresserais',
    'agresserait',
    'agresseras',
    'agresserez',
    'agresseriez',
    'agresserions',
    'agresserons',
    'agresseront',
    'agresses',
    'agresseur',
    'agresseurs',
    'agressez',
    'agressiez',
    'agressif',
    'agressifs',
    'agression',
    'agressions',
    'agressive',
    'agressives',
    'agressivité',
    'agressivités',
    'agressons',
    'agressâmes',
    'agressât',
    'agressâtes',
    'agressèrent',
    'agressé',
    'agressée',
    'agressées',
    'agressés',
    'agreste',
    'agrestes',
    'agricha',
    'agrichai',
    'agrichaient',
    'agrichais',
    'agrichait',
    'agrichant',
    'agrichas',
    'agrichasse',
    'agrichassent',
    'agrichasses',
    'agrichassiez',
    'agriche',
    'agrichent',
    'agricher',
    'agrichera',
    'agricherai',
    'agricherais',
    'agricherait',
    'agricheras',
    'agricherez',
    'agricheriez',
    'agricherions',
    'agricherons',
    'agricheront',
    'agriches',
    'agrichez',
    'agrichiez',
    'agrichions',
    'agrichons',
    'agrichâmes',
    'agrichât',
    'agrichâtes',
    'agrichèrent',
    'agriché',
    'agrichée',
    'agrichées',
    'agrichés',
    'agricole',
    'agricoles',
    'agriculteur',
    'agriculteurs',
    'agricultrice',
    'agriculture',
    'agricultures',
    'agriffassiez',
    'agriffer',
    'agrifferez',
    'agrifferiez',
    'agrifferions',
    'agrifferons',
    'agriffez',
    'agriffiez',
    'agriffions',
    'agriffons',
    'agriffâmes',
    'agriffâtes',
    'agriffé',
    'agriffée',
    'agriffées',
    'agriffés',
    'agrile',
    'agriles',
    'agrion',
    'agrions',
    'agriote',
    'agriotes',
    'agripaume',
    'agripaumes',
    'agrippa',
    'agrippai',
    'agrippaient',
    'agrippais',
    'agrippait',
    'agrippant',
    'agrippas',
    'agrippasse',
    'agrippassent',
    'agrippasses',
    'agrippassiez',
    'agrippe',
    'agrippent',
    'agripper',
    'agrippera',
    'agripperai',
    'agripperais',
    'agripperait',
    'agripperas',
    'agripperez',
    'agripperiez',
    'agripperions',
    'agripperons',
    'agripperont',
    'agrippes',
    'agrippez',
    'agrippiez',
    'agrippions',
    'agrippons',
    'agrippâmes',
    'agrippât',
    'agrippâtes',
    'agrippèrent',
    'agrippé',
    'agrippée',
    'agrippées',
    'agrippés',
    'agrochimie',
    'agrochimies',
    'agrologie',
    'agrologies',
    'agronome',
    'agronomes',
    'agronomie',
    'agronomies',
    'agronomique',
    'agronomiques',
    'agrostide',
    'agrostides',
    'agrostis',
    'agrotis',
    'agrume',
    'agrumes',
    'agrège',
    'agrègent',
    'agrèges',
    'agrès',
    'agréa',
    'agréable',
    'agréablement',
    'agréables',
    'agréai',
    'agréaient',
    'agréais',
    'agréait',
    'agréant',
    'agréas',
    'agréasse',
    'agréassent',
    'agréasses',
    'agréassiez',
    'agréassions',
    'agrée',
    'agréent',
    'agréer',
    'agréera',
    'agréerai',
    'agréeraient',
    'agréerais',
    'agréerait',
    'agréeras',
    'agréerez',
    'agréeriez',
    'agréerions',
    'agréerons',
    'agréeront',
    'agrées',
    'agréez',
    'agrégat',
    'agrégatif',
    'agrégatifs',
    'agrégation',
    'agrégations',
    'agrégative',
    'agrégatives',
    'agrégats',
    'agrégea',
    'agrégeai',
    'agrégeaient',
    'agrégeais',
    'agrégeait',
    'agrégeant',
    'agrégeas',
    'agrégeasse',
    'agrégeassent',
    'agrégeasses',
    'agrégeassiez',
    'agrégeons',
    'agréger',
    'agrégera',
    'agrégerai',
    'agrégeraient',
    'agrégerais',
    'agrégerait',
    'agrégeras',
    'agrégerez',
    'agrégeriez',
    'agrégerions',
    'agrégerons',
    'agrégeront',
    'agrégez',
    'agrégeâmes',
    'agrégeât',
    'agrégeâtes',
    'agrégiez',
    'agrégions',
    'agrégèrent',
    'agrégé',
    'agrégée',
    'agrégées',
    'agrégés',
    'agréiez',
    'agréions',
    'agrément',
    'agrémenta',
    'agrémentai',
    'agrémentais',
    'agrémentait',
    'agrémentant',
    'agrémentas',
    'agrémentasse',
    'agrémente',
    'agrémentent',
    'agrémenter',
    'agrémentera',
    'agrémenterai',
    'agrémenteras',
    'agrémenterez',
    'agrémentes',
    'agrémentez',
    'agrémentiez',
    'agrémentions',
    'agrémentons',
    'agréments',
    'agrémentâmes',
    'agrémentât',
    'agrémentâtes',
    'agrémenté',
    'agrémentée',
    'agrémentées',
    'agrémentés',
    'agréons',
    'agréâmes',
    'agréât',
    'agréâtes',
    'agréèrent',
    'agréé',
    'agréée',
    'agréées',
    'agréés',
    'aguardiente',
    'aguardientes',
    'aguerri',
    'aguerrie',
    'aguerries',
    'aguerrir',
    'aguerrira',
    'aguerrirai',
    'aguerrirais',
    'aguerrirait',
    'aguerriras',
    'aguerrirent',
    'aguerrirez',
    'aguerririez',
    'aguerririons',
    'aguerrirons',
    'aguerriront',
    'aguerris',
    'aguerrissais',
    'aguerrissait',
    'aguerrissant',
    'aguerrisse',
    'aguerrissent',
    'aguerrisses',
    'aguerrissez',
    'aguerrissiez',
    'aguerrissons',
    'aguerrit',
    'aguerrîmes',
    'aguerrît',
    'aguerrîtes',
    'aguets',
    'agueusie',
    'agueusies',
    'agui',
    'aguicha',
    'aguichai',
    'aguichaient',
    'aguichais',
    'aguichait',
    'aguichant',
    'aguichante',
    'aguichantes',
    'aguichants',
    'aguichas',
    'aguichasse',
    'aguichassent',
    'aguichasses',
    'aguichassiez',
    'aguiche',
    'aguichent',
    'aguicher',
    'aguichera',
    'aguicherai',
    'aguicherais',
    'aguicherait',
    'aguicheras',
    'aguicherez',
    'aguicheriez',
    'aguicherions',
    'aguicherons',
    'aguicheront',
    'aguiches',
    'aguicheur',
    'aguicheurs',
    'aguicheuse',
    'aguicheuses',
    'aguichez',
    'aguichiez',
    'aguichions',
    'aguichons',
    'aguichâmes',
    'aguichât',
    'aguichâtes',
    'aguichèrent',
    'aguiché',
    'aguichée',
    'aguichées',
    'aguichés',
    'aguis',
    'aguiser',
    'agénésie',
    'agénésies',
    'agérate',
    'agérates',
    'agîmes',
    'agît',
    'agîtes',
    'ahan',
    'ahana',
    'ahanai',
    'ahanaient',
    'ahanais',
    'ahanait',
    'ahanant',
    'ahanas',
    'ahanasse',
    'ahanassent',
    'ahanasses',
    'ahanassiez',
    'ahanassions',
    'ahane',
    'ahanent',
    'ahaner',
    'ahanera',
    'ahanerai',
    'ahaneraient',
    'ahanerais',
    'ahanerait',
    'ahaneras',
    'ahanerez',
    'ahaneriez',
    'ahanerions',
    'ahanerons',
    'ahaneront',
    'ahanes',
    'ahanez',
    'ahaniez',
    'ahanions',
    'ahanons',
    'ahans',
    'ahanâmes',
    'ahanât',
    'ahanâtes',
    'ahanèrent',
    'ahané',
    'aheurtassiez',
    'aheurter',
    'aheurterez',
    'aheurteriez',
    'aheurterions',
    'aheurterons',
    'aheurtez',
    'aheurtiez',
    'aheurtions',
    'aheurtons',
    'aheurtâmes',
    'aheurtâtes',
    'aheurté',
    'aheurtée',
    'aheurtées',
    'aheurtés',
    'ahuri',
    'ahurie',
    'ahuries',
    'ahurir',
    'ahurira',
    'ahurirai',
    'ahuriraient',
    'ahurirais',
    'ahurirait',
    'ahuriras',
    'ahurirent',
    'ahurirez',
    'ahuririez',
    'ahuririons',
    'ahurirons',
    'ahuriront',
    'ahuris',
    'ahurissaient',
    'ahurissais',
    'ahurissait',
    'ahurissant',
    'ahurissante',
    'ahurissantes',
    'ahurissants',
    'ahurisse',
    'ahurissement',
    'ahurissent',
    'ahurisses',
    'ahurissez',
    'ahurissiez',
    'ahurissions',
    'ahurissons',
    'ahurit',
    'ahurîmes',
    'ahurît',
    'ahurîtes',
    'aiche',
    'aiches',
    'aida',
    'aidai',
    'aidaient',
    'aidais',
    'aidait',
    'aidant',
    'aidas',
    'aidasse',
    'aidassent',
    'aidasses',
    'aidassiez',
    'aidassions',
    'aide',
    'aident',
    'aider',
    'aidera',
    'aiderai',
    'aideraient',
    'aiderais',
    'aiderait',
    'aideras',
    'aiderez',
    'aideriez',
    'aiderions',
    'aiderons',
    'aideront',
    'aides',
    'aidez',
    'aidiez',
    'aidions',
    'aidons',
    'aidâmes',
    'aidât',
    'aidâtes',
    'aidèrent',
    'aidé',
    'aidée',
    'aidées',
    'aidés',
    'aient',
    'aies',
    'aigle',
    'aiglefin',
    'aiglefins',
    'aigles',
    'aiglon',
    'aiglonne',
    'aiglonnes',
    'aiglons',
    'aigre',
    'aigrefin',
    'aigrefins',
    'aigrelet',
    'aigrelets',
    'aigrelette',
    'aigrelettes',
    'aigrement',
    'aigremoine',
    'aigremoines',
    'aigres',
    'aigrette',
    'aigrettes',
    'aigretté',
    'aigrettée',
    'aigrettées',
    'aigrettés',
    'aigreur',
    'aigreurs',
    'aigri',
    'aigrie',
    'aigries',
    'aigrir',
    'aigrira',
    'aigrirai',
    'aigriraient',
    'aigrirais',
    'aigrirait',
    'aigriras',
    'aigrirent',
    'aigrirez',
    'aigririez',
    'aigririons',
    'aigrirons',
    'aigriront',
    'aigris',
    'aigrissaient',
    'aigrissais',
    'aigrissait',
    'aigrissant',
    'aigrisse',
    'aigrissent',
    'aigrisses',
    'aigrissez',
    'aigrissiez',
    'aigrissions',
    'aigrissons',
    'aigrit',
    'aigrîmes',
    'aigrît',
    'aigrîtes',
    'aigu',
    'aiguilla',
    'aiguillage',
    'aiguillages',
    'aiguillai',
    'aiguillaient',
    'aiguillais',
    'aiguillait',
    'aiguillant',
    'aiguillas',
    'aiguillasse',
    'aiguillasses',
    'aiguillat',
    'aiguillats',
    'aiguille',
    'aiguillent',
    'aiguiller',
    'aiguillera',
    'aiguillerai',
    'aiguillerais',
    'aiguillerait',
    'aiguilleras',
    'aiguillerez',
    'aiguilleriez',
    'aiguillerons',
    'aiguilleront',
    'aiguilles',
    'aiguilleta',
    'aiguilletai',
    'aiguilletais',
    'aiguilletait',
    'aiguilletant',
    'aiguilletas',
    'aiguilleter',
    'aiguilletez',
    'aiguilletiez',
    'aiguilletons',
    'aiguillette',
    'aiguillettes',
    'aiguilletât',
    'aiguilleté',
    'aiguilletée',
    'aiguilletées',
    'aiguilletés',
    'aiguilleur',
    'aiguilleurs',
    'aiguilleuse',
    'aiguilleuses',
    'aiguillez',
    'aiguilliez',
    'aiguillions',
    'aiguillon',
    'aiguillonna',
    'aiguillonnai',
    'aiguillonnas',
    'aiguillonne',
    'aiguillonner',
    'aiguillonnes',
    'aiguillonnez',
    'aiguillonnât',
    'aiguillonné',
    'aiguillonnée',
    'aiguillonnés',
    'aiguillons',
    'aiguillot',
    'aiguillots',
    'aiguillâmes',
    'aiguillât',
    'aiguillâtes',
    'aiguillèrent',
    'aiguillé',
    'aiguillée',
    'aiguillées',
    'aiguillés',
    'aiguisa',
    'aiguisage',
    'aiguisages',
    'aiguisai',
    'aiguisaient',
    'aiguisais',
    'aiguisait',
    'aiguisant',
    'aiguisas',
    'aiguisasse',
    'aiguisassent',
    'aiguisasses',
    'aiguisassiez',
    'aiguise',
    'aiguisent',
    'aiguiser',
    'aiguisera',
    'aiguiserai',
    'aiguiserais',
    'aiguiserait',
    'aiguiseras',
    'aiguiserez',
    'aiguiseriez',
    'aiguiserions',
    'aiguiserons',
    'aiguiseront',
    'aiguises',
    'aiguiseur',
    'aiguiseurs',
    'aiguiseuse',
    'aiguiseuses',
    'aiguisez',
    'aiguisiez',
    'aiguisions',
    'aiguisoir',
    'aiguisoirs',
    'aiguisons',
    'aiguisâmes',
    'aiguisât',
    'aiguisâtes',
    'aiguisèrent',
    'aiguisé',
    'aiguisée',
    'aiguisées',
    'aiguisés',
    'aiguière',
    'aiguières',
    'aigus',
    'aiguë',
    'aiguës',
    'ailante',
    'ailantes',
    'aile',
    'aileron',
    'ailerons',
    'ailes',
    'ailette',
    'ailettes',
    'ailier',
    'ailiers',
    'ailla',
    'aillai',
    'aillaient',
    'aillais',
    'aillait',
    'aillant',
    'aillas',
    'aillasse',
    'aillassent',
    'aillasses',
    'aillassiez',
    'aillassions',
    'aille',
    'aillent',
    'ailler',
    'aillera',
    'aillerai',
    'ailleraient',
    'aillerais',
    'aillerait',
    'ailleras',
    'aillerez',
    'ailleriez',
    'aillerions',
    'aillerons',
    'ailleront',
    'ailles',
    'ailleurs',
    'aillez',
    'ailliez',
    'aillions',
    'ailloli',
    'aillolis',
    'aillons',
    'aillâmes',
    'aillât',
    'aillâtes',
    'aillèrent',
    'aillé',
    'aillée',
    'aillées',
    'aillés',
    'ails',
    'ailé',
    'ailée',
    'ailées',
    'ailés',
    'aima',
    'aimable',
    'aimablement',
    'aimables',
    'aimai',
    'aimaient',
    'aimais',
    'aimait',
    'aimant',
    'aimanta',
    'aimantai',
    'aimantaient',
    'aimantais',
    'aimantait',
    'aimantant',
    'aimantas',
    'aimantasse',
    'aimantassent',
    'aimantasses',
    'aimantassiez',
    'aimantation',
    'aimantations',
    'aimante',
    'aimantent',
    'aimanter',
    'aimantera',
    'aimanterai',
    'aimanterais',
    'aimanterait',
    'aimanteras',
    'aimanterez',
    'aimanteriez',
    'aimanterions',
    'aimanterons',
    'aimanteront',
    'aimantes',
    'aimantez',
    'aimantiez',
    'aimantions',
    'aimantons',
    'aimants',
    'aimantâmes',
    'aimantât',
    'aimantâtes',
    'aimantèrent',
    'aimanté',
    'aimantée',
    'aimantées',
    'aimantés',
    'aimas',
    'aimasse',
    'aimassent',
    'aimasses',
    'aimassiez',
    'aimassions',
    'aime',
    'aiment',
    'aimer',
    'aimera',
    'aimerai',
    'aimeraient',
    'aimerais',
    'aimerait',
    'aimeras',
    'aimerez',
    'aimeriez',
    'aimerions',
    'aimerons',
    'aimeront',
    'aimes',
    'aimez',
    'aimiez',
    'aimions',
    'aimons',
    'aimâmes',
    'aimât',
    'aimâtes',
    'aimèrent',
    'aimé',
    'aimée',
    'aimées',
    'aimés',
    'aine',
    'aines',
    'ainsi',
    'aira',
    'airai',
    'airaient',
    'airain',
    'airains',
    'airais',
    'airait',
    'airant',
    'airas',
    'airasse',
    'airassent',
    'airasses',
    'airassiez',
    'airassions',
    'airbus',
    'aire',
    'airedale',
    'airedales',
    'airelle',
    'airelles',
    'airent',
    'airer',
    'airera',
    'airerai',
    'aireraient',
    'airerais',
    'airerait',
    'aireras',
    'airerez',
    'aireriez',
    'airerions',
    'airerons',
    'aireront',
    'aires',
    'airez',
    'airiez',
    'airions',
    'airons',
    'airs',
    'airâmes',
    'airât',
    'airâtes',
    'airèrent',
    'airé',
    'aisance',
    'aisances',
    'aise',
    'aises',
    'aisselle',
    'aisselles',
    'aisy',
    'aisys',
    'aisé',
    'aisée',
    'aisées',
    'aisément',
    'aisés',
    'ajointa',
    'ajointai',
    'ajointaient',
    'ajointais',
    'ajointait',
    'ajointant',
    'ajointas',
    'ajointasse',
    'ajointassent',
    'ajointasses',
    'ajointassiez',
    'ajointe',
    'ajointent',
    'ajointer',
    'ajointera',
    'ajointerai',
    'ajointerais',
    'ajointerait',
    'ajointeras',
    'ajointerez',
    'ajointeriez',
    'ajointerions',
    'ajointerons',
    'ajointeront',
    'ajointes',
    'ajointez',
    'ajointiez',
    'ajointions',
    'ajointons',
    'ajointâmes',
    'ajointât',
    'ajointâtes',
    'ajointèrent',
    'ajointé',
    'ajointée',
    'ajointées',
    'ajointés',
    'ajonc',
    'ajoncs',
    'ajour',
    'ajoura',
    'ajourai',
    'ajouraient',
    'ajourais',
    'ajourait',
    'ajourant',
    'ajouras',
    'ajourasse',
    'ajourassent',
    'ajourasses',
    'ajourassiez',
    'ajourassions',
    'ajoure',
    'ajourent',
    'ajourer',
    'ajourera',
    'ajourerai',
    'ajoureraient',
    'ajourerais',
    'ajourerait',
    'ajoureras',
    'ajourerez',
    'ajoureriez',
    'ajourerions',
    'ajourerons',
    'ajoureront',
    'ajoures',
    'ajourez',
    'ajouriez',
    'ajourions',
    'ajourna',
    'ajournai',
    'ajournaient',
    'ajournais',
    'ajournait',
    'ajournant',
    'ajournas',
    'ajournasse',
    'ajournassent',
    'ajournasses',
    'ajournassiez',
    'ajourne',
    'ajournement',
    'ajournements',
    'ajournent',
    'ajourner',
    'ajournera',
    'ajournerai',
    'ajournerais',
    'ajournerait',
    'ajourneras',
    'ajournerez',
    'ajourneriez',
    'ajournerions',
    'ajournerons',
    'ajourneront',
    'ajournes',
    'ajournez',
    'ajourniez',
    'ajournions',
    'ajournons',
    'ajournâmes',
    'ajournât',
    'ajournâtes',
    'ajournèrent',
    'ajourné',
    'ajournée',
    'ajournées',
    'ajournés',
    'ajourons',
    'ajours',
    'ajourâmes',
    'ajourât',
    'ajourâtes',
    'ajourèrent',
    'ajouré',
    'ajourée',
    'ajourées',
    'ajourés',
    'ajout',
    'ajouta',
    'ajoutai',
    'ajoutaient',
    'ajoutais',
    'ajoutait',
    'ajoutant',
    'ajoutas',
    'ajoutasse',
    'ajoutassent',
    'ajoutasses',
    'ajoutassiez',
    'ajoutassions',
    'ajoute',
    'ajoutent',
    'ajouter',
    'ajoutera',
    'ajouterai',
    'ajouteraient',
    'ajouterais',
    'ajouterait',
    'ajouteras',
    'ajouterez',
    'ajouteriez',
    'ajouterions',
    'ajouterons',
    'ajouteront',
    'ajoutes',
    'ajoutez',
    'ajoutiez',
    'ajoutions',
    'ajoutons',
    'ajouts',
    'ajoutâmes',
    'ajoutât',
    'ajoutâtes',
    'ajoutèrent',
    'ajouté',
    'ajoutée',
    'ajoutées',
    'ajoutés',
    'ajusta',
    'ajustable',
    'ajustables',
    'ajustage',
    'ajustages',
    'ajustai',
    'ajustaient',
    'ajustais',
    'ajustait',
    'ajustant',
    'ajustas',
    'ajustasse',
    'ajustassent',
    'ajustasses',
    'ajustassiez',
    'ajustassions',
    'ajuste',
    'ajustement',
    'ajustements',
    'ajustent',
    'ajuster',
    'ajustera',
    'ajusterai',
    'ajusteraient',
    'ajusterais',
    'ajusterait',
    'ajusteras',
    'ajusterez',
    'ajusteriez',
    'ajusterions',
    'ajusterons',
    'ajusteront',
    'ajustes',
    'ajusteur',
    'ajusteurs',
    'ajusteuse',
    'ajusteuses',
    'ajustez',
    'ajustiez',
    'ajustions',
    'ajustons',
    'ajustâmes',
    'ajustât',
    'ajustâtes',
    'ajustèrent',
    'ajusté',
    'ajustée',
    'ajustées',
    'ajustés',
    'akinésie',
    'akinésies',
    'akkadien',
    'akkadienne',
    'akkadiennes',
    'akkadiens',
    'akvavit',
    'akvavits',
    'alabandine',
    'alabandines',
    'alabastrite',
    'alabastrites',
    'alaire',
    'alaires',
    'alaise',
    'alaises',
    'alambic',
    'alambics',
    'alambiqua',
    'alambiquai',
    'alambiquais',
    'alambiquait',
    'alambiquant',
    'alambiquas',
    'alambiquasse',
    'alambique',
    'alambiquent',
    'alambiquer',
    'alambiquera',
    'alambiquerai',
    'alambiqueras',
    'alambiquerez',
    'alambiques',
    'alambiquez',
    'alambiquiez',
    'alambiquions',
    'alambiquons',
    'alambiquâmes',
    'alambiquât',
    'alambiquâtes',
    'alambiqué',
    'alambiquée',
    'alambiquées',
    'alambiqués',
    'alandier',
    'alandiers',
    'alangui',
    'alanguie',
    'alanguies',
    'alanguir',
    'alanguira',
    'alanguirai',
    'alanguirais',
    'alanguirait',
    'alanguiras',
    'alanguirent',
    'alanguirez',
    'alanguiriez',
    'alanguirions',
    'alanguirons',
    'alanguiront',
    'alanguis',
    'alanguissais',
    'alanguissait',
    'alanguissant',
    'alanguisse',
    'alanguissent',
    'alanguisses',
    'alanguissez',
    'alanguissiez',
    'alanguissons',
    'alanguit',
    'alanguîmes',
    'alanguît',
    'alanguîtes',
    'alanine',
    'alanines',
    'alarma',
    'alarmai',
    'alarmaient',
    'alarmais',
    'alarmait',
    'alarmant',
    'alarmante',
    'alarmantes',
    'alarmants',
    'alarmas',
    'alarmasse',
    'alarmassent',
    'alarmasses',
    'alarmassiez',
    'alarmassions',
    'alarme',
    'alarment',
    'alarmer',
    'alarmera',
    'alarmerai',
    'alarmeraient',
    'alarmerais',
    'alarmerait',
    'alarmeras',
    'alarmerez',
    'alarmeriez',
    'alarmerions',
    'alarmerons',
    'alarmeront',
    'alarmes',
    'alarmez',
    'alarmiez',
    'alarmions',
    'alarmiste',
    'alarmistes',
    'alarmons',
    'alarmâmes',
    'alarmât',
    'alarmâtes',
    'alarmèrent',
    'alarmé',
    'alarmée',
    'alarmées',
    'alarmés',
    'alastrim',
    'alastrims',
    'alaterne',
    'alaternes',
    'albanais',
    'albanaise',
    'albanaises',
    'albatros',
    'alberge',
    'alberges',
    'albergier',
    'albergiers',
    'albigeois',
    'albigeoise',
    'albigeoises',
    'albinisme',
    'albinismes',
    'albinos',
    'albite',
    'albites',
    'albuginé',
    'albuginée',
    'albuginées',
    'albuginés',
    'albugo',
    'albugos',
    'album',
    'albumen',
    'albumens',
    'albumine',
    'albumines',
    'albumineuse',
    'albumineuses',
    'albumineux',
    'albuminoïde',
    'albuminoïdes',
    'albuminurie',
    'albuminuries',
    'albuminé',
    'albuminée',
    'albuminées',
    'albuminés',
    'albumose',
    'albumoses',
    'albums',
    'albâtre',
    'albâtres',
    'albédo',
    'albédos',
    'alcade',
    'alcades',
    'alcalescence',
    'alcalescent',
    'alcalescente',
    'alcalescents',
    'alcali',
    'alcalifiant',
    'alcalifiante',
    'alcalifiants',
    'alcalimètre',
    'alcalimètres',
    'alcalimétrie',
    'alcalin',
    'alcaline',
    'alcalines',
    'alcalinisa',
    'alcalinisai',
    'alcalinisais',
    'alcalinisait',
    'alcalinisant',
    'alcalinisas',
    'alcalinise',
    'alcalinisent',
    'alcaliniser',
    'alcalinisera',
    'alcalinises',
    'alcalinisez',
    'alcalinisiez',
    'alcalinisons',
    'alcalinisât',
    'alcalinisé',
    'alcalinisée',
    'alcalinisées',
    'alcalinisés',
    'alcalinité',
    'alcalinités',
    'alcalins',
    'alcalis',
    'alcalisa',
    'alcalisai',
    'alcalisaient',
    'alcalisais',
    'alcalisait',
    'alcalisant',
    'alcalisas',
    'alcalisasse',
    'alcalisasses',
    'alcalise',
    'alcalisent',
    'alcaliser',
    'alcalisera',
    'alcaliserai',
    'alcaliserais',
    'alcaliserait',
    'alcaliseras',
    'alcaliserez',
    'alcaliseriez',
    'alcaliserons',
    'alcaliseront',
    'alcalises',
    'alcalisez',
    'alcalisiez',
    'alcalisions',
    'alcalisons',
    'alcalisâmes',
    'alcalisât',
    'alcalisâtes',
    'alcalisèrent',
    'alcalisé',
    'alcalisée',
    'alcalisées',
    'alcalisés',
    'alcalose',
    'alcaloses',
    'alcaloïde',
    'alcaloïdes',
    'alcarazas',
    'alcaïque',
    'alcaïques',
    'alchimie',
    'alchimies',
    'alchimique',
    'alchimiques',
    'alchimiste',
    'alchimistes',
    'alchémille',
    'alchémilles',
    'alcool',
    'alcoolat',
    'alcoolats',
    'alcoolature',
    'alcoolatures',
    'alcoolique',
    'alcooliques',
    'alcoolisa',
    'alcoolisable',
    'alcoolisai',
    'alcoolisais',
    'alcoolisait',
    'alcoolisant',
    'alcoolisas',
    'alcoolisasse',
    'alcoolise',
    'alcoolisent',
    'alcooliser',
    'alcoolisera',
    'alcooliserai',
    'alcooliseras',
    'alcooliserez',
    'alcoolises',
    'alcoolisez',
    'alcoolisiez',
    'alcoolisions',
    'alcoolisme',
    'alcoolismes',
    'alcoolisons',
    'alcoolisâmes',
    'alcoolisât',
    'alcoolisâtes',
    'alcoolisé',
    'alcoolisée',
    'alcoolisées',
    'alcoolisés',
    'alcools',
    'alcoolé',
    'alcoolémie',
    'alcoolémies',
    'alcoolés',
    'alcoomètre',
    'alcoomètres',
    'alcootest',
    'alcootests',
    'alcoyle',
    'alcoyles',
    'alcyne',
    'alcynes',
    'alcyon',
    'alcyons',
    'alcène',
    'alcènes',
    'alcôve',
    'alcôves',
    'aldin',
    'aldine',
    'aldines',
    'aldins',
    'aldol',
    'aldols',
    'aldostérone',
    'aldostérones',
    'aldéhyde',
    'aldéhydes',
    'aldéhydique',
    'aldéhydiques',
    'alenti',
    'alentie',
    'alenties',
    'alentir',
    'alentira',
    'alentirai',
    'alentiraient',
    'alentirais',
    'alentirait',
    'alentiras',
    'alentirent',
    'alentirez',
    'alentiriez',
    'alentirions',
    'alentirons',
    'alentiront',
    'alentis',
    'alentissais',
    'alentissait',
    'alentissant',
    'alentisse',
    'alentissent',
    'alentisses',
    'alentissez',
    'alentissiez',
    'alentissions',
    'alentissons',
    'alentit',
    'alentour',
    'alentours',
    'alentîmes',
    'alentît',
    'alentîtes',
    'aleph',
    'alephs',
    'alerta',
    'alertai',
    'alertaient',
    'alertais',
    'alertait',
    'alertant',
    'alertas',
    'alertasse',
    'alertassent',
    'alertasses',
    'alertassiez',
    'alertassions',
    'alerte',
    'alertement',
    'alertent',
    'alerter',
    'alertera',
    'alerterai',
    'alerteraient',
    'alerterais',
    'alerterait',
    'alerteras',
    'alerterez',
    'alerteriez',
    'alerterions',
    'alerterons',
    'alerteront',
    'alertes',
    'alertez',
    'alertiez',
    'alertions',
    'alertons',
    'alertâmes',
    'alertât',
    'alertâtes',
    'alertèrent',
    'alerté',
    'alertée',
    'alertées',
    'alertés',
    'ales',
    'aleurite',
    'aleurites',
    'aleurode',
    'aleurodes',
    'aleurone',
    'aleurones',
    'alevin',
    'alevina',
    'alevinage',
    'alevinages',
    'alevinai',
    'alevinaient',
    'alevinais',
    'alevinait',
    'alevinant',
    'alevinas',
    'alevinasse',
    'alevinassent',
    'alevinasses',
    'alevinassiez',
    'alevine',
    'alevinent',
    'aleviner',
    'alevinera',
    'alevinerai',
    'alevinerais',
    'alevinerait',
    'alevineras',
    'alevinerez',
    'alevineriez',
    'alevinerions',
    'alevinerons',
    'alevineront',
    'alevines',
    'alevinez',
    'alevinier',
    'aleviniers',
    'aleviniez',
    'alevinions',
    'alevinière',
    'alevinières',
    'alevinons',
    'alevins',
    'alevinâmes',
    'alevinât',
    'alevinâtes',
    'alevinèrent',
    'aleviné',
    'alevinée',
    'alevinées',
    'alevinés',
    'alexandra',
    'alexandrin',
    'alexandrine',
    'alexandrines',
    'alexandrins',
    'alezan',
    'alezane',
    'alezanes',
    'alezans',
    'alfa',
    'alfas',
    'alfatier',
    'alfatiers',
    'alfatière',
    'alfatières',
    'alfénide',
    'alfénides',
    'algarade',
    'algarades',
    'algazelle',
    'algazelles',
    'algide',
    'algides',
    'algidité',
    'algidités',
    'algie',
    'algies',
    'alginate',
    'alginates',
    'algine',
    'algines',
    'algique',
    'algiques',
    'algol',
    'algols',
    'algonquin',
    'algonquins',
    'algorithme',
    'algorithmes',
    'algue',
    'algues',
    'algèbre',
    'algèbres',
    'algébrique',
    'algébriques',
    'algérien',
    'algérienne',
    'algériennes',
    'algériens',
    'alias',
    'alibi',
    'alibis',
    'alicant',
    'alicante',
    'alicantes',
    'alicants',
    'alidade',
    'alidades',
    'alifère',
    'alifères',
    'aligna',
    'alignai',
    'alignaient',
    'alignais',
    'alignait',
    'alignant',
    'alignas',
    'alignasse',
    'alignassent',
    'alignasses',
    'alignassiez',
    'alignassions',
    'aligne',
    'alignement',
    'alignements',
    'alignent',
    'aligner',
    'alignera',
    'alignerai',
    'aligneraient',
    'alignerais',
    'alignerait',
    'aligneras',
    'alignerez',
    'aligneriez',
    'alignerions',
    'alignerons',
    'aligneront',
    'alignes',
    'alignez',
    'aligniez',
    'alignions',
    'alignons',
    'alignâmes',
    'alignât',
    'alignâtes',
    'alignèrent',
    'aligné',
    'alignée',
    'alignées',
    'alignés',
    'aligoté',
    'aligotés',
    'aliment',
    'alimenta',
    'alimentai',
    'alimentaient',
    'alimentaire',
    'alimentaires',
    'alimentais',
    'alimentait',
    'alimentant',
    'alimentas',
    'alimentasse',
    'alimentasses',
    'alimentation',
    'alimente',
    'alimentent',
    'alimenter',
    'alimentera',
    'alimenterai',
    'alimenterais',
    'alimenterait',
    'alimenteras',
    'alimenterez',
    'alimenteriez',
    'alimenterons',
    'alimenteront',
    'alimentes',
    'alimentez',
    'alimentiez',
    'alimentions',
    'alimentons',
    'aliments',
    'alimentâmes',
    'alimentât',
    'alimentâtes',
    'alimentèrent',
    'alimenté',
    'alimentée',
    'alimentées',
    'alimentés',
    'alinéa',
    'alinéas',
    'alios',
    'aliphatique',
    'aliphatiques',
    'aliquante',
    'aliquantes',
    'aliquote',
    'aliquotes',
    'alise',
    'alises',
    'alisier',
    'alisiers',
    'alisme',
    'alismes',
    'alita',
    'alitai',
    'alitaient',
    'alitais',
    'alitait',
    'alitant',
    'alitas',
    'alitasse',
    'alitassent',
    'alitasses',
    'alitassiez',
    'alitassions',
    'alite',
    'alitement',
    'alitements',
    'alitent',
    'aliter',
    'alitera',
    'aliterai',
    'aliteraient',
    'aliterais',
    'aliterait',
    'aliteras',
    'aliterez',
    'aliteriez',
    'aliterions',
    'aliterons',
    'aliteront',
    'alites',
    'alitez',
    'alitiez',
    'alitions',
    'alitons',
    'alitâmes',
    'alitât',
    'alitâtes',
    'alitèrent',
    'alité',
    'alitée',
    'alitées',
    'alités',
    'alizarine',
    'alizarines',
    'alizé',
    'alizés',
    'aliène',
    'aliènent',
    'aliènes',
    'aliéna',
    'aliénabilité',
    'aliénable',
    'aliénables',
    'aliénai',
    'aliénaient',
    'aliénais',
    'aliénait',
    'aliénant',
    'aliénante',
    'aliénantes',
    'aliénants',
    'aliénas',
    'aliénasse',
    'aliénassent',
    'aliénasses',
    'aliénassiez',
    'aliénassions',
    'aliénataire',
    'aliénataires',
    'aliénateur',
    'aliénateurs',
    'aliénation',
    'aliénations',
    'aliénatrice',
    'aliénatrices',
    'aliéner',
    'aliénera',
    'aliénerai',
    'aliéneraient',
    'aliénerais',
    'aliénerait',
    'aliéneras',
    'aliénerez',
    'aliéneriez',
    'aliénerions',
    'aliénerons',
    'aliéneront',
    'aliénez',
    'aliéniez',
    'aliénions',
    'aliéniste',
    'aliénistes',
    'aliénons',
    'aliénâmes',
    'aliénât',
    'aliénâtes',
    'aliénèrent',
    'aliéné',
    'aliénée',
    'aliénées',
    'aliénés',
    'alkermès',
    'alkékenge',
    'alkékenges',
    'alla',
    'allai',
    'allaient',
    'allais',
    'allait',
    'allaita',
    'allaitai',
    'allaitaient',
    'allaitais',
    'allaitait',
    'allaitant',
    'allaitas',
    'allaitasse',
    'allaitassent',
    'allaitasses',
    'allaitassiez',
    'allaite',
    'allaitement',
    'allaitements',
    'allaitent',
    'allaiter',
    'allaitera',
    'allaiterai',
    'allaiterais',
    'allaiterait',
    'allaiteras',
    'allaiterez',
    'allaiteriez',
    'allaiterions',
    'allaiterons',
    'allaiteront',
    'allaites',
    'allaitez',
    'allaitiez',
    'allaitions',
    'allaitons',
    'allaitâmes',
    'allaitât',
    'allaitâtes',
    'allaitèrent',
    'allaité',
    'allaitée',
    'allaitées',
    'allaités',
    'allant',
    'allante',
    'allantes',
    'allantoïde',
    'allantoïdes',
    'allants',
    'allas',
    'allasse',
    'allassent',
    'allasses',
    'allassiez',
    'allassions',
    'allegretto',
    'allegrettos',
    'allegro',
    'allegros',
    'allemand',
    'allemande',
    'allemandes',
    'allemands',
    'aller',
    'allergie',
    'allergies',
    'allergique',
    'allergiques',
    'allergisant',
    'allergisante',
    'allergisants',
    'allergologie',
    'allergologue',
    'allergène',
    'allergènes',
    'allers',
    'allez',
    'allia',
    'alliacé',
    'alliacée',
    'alliacées',
    'alliacés',
    'alliage',
    'alliages',
    'alliai',
    'alliaient',
    'alliais',
    'alliait',
    'alliance',
    'alliances',
    'alliant',
    'allias',
    'alliasse',
    'alliassent',
    'alliasses',
    'alliassiez',
    'alliassions',
    'allie',
    'allient',
    'allier',
    'alliera',
    'allierai',
    'allieraient',
    'allierais',
    'allierait',
    'allieras',
    'allierez',
    'allieriez',
    'allierions',
    'allierons',
    'allieront',
    'allies',
    'alliez',
    'alligator',
    'alligators',
    'alliiez',
    'alliions',
    'allions',
    'allitération',
    'alliâmes',
    'alliât',
    'alliâtes',
    'allièrent',
    'allié',
    'alliée',
    'alliées',
    'alliés',
    'allocataire',
    'allocataires',
    'allocation',
    'allocations',
    'allocutaire',
    'allocutaires',
    'allocution',
    'allocutions',
    'allodial',
    'allodiale',
    'allodiales',
    'allodiaux',
    'allogamie',
    'allogamies',
    'allogène',
    'allogènes',
    'allonge',
    'allongea',
    'allongeai',
    'allongeaient',
    'allongeais',
    'allongeait',
    'allongeant',
    'allongeas',
    'allongeasse',
    'allongeasses',
    'allongement',
    'allongements',
    'allongent',
    'allongeons',
    'allonger',
    'allongera',
    'allongerai',
    'allongerais',
    'allongerait',
    'allongeras',
    'allongerez',
    'allongeriez',
    'allongerions',
    'allongerons',
    'allongeront',
    'allonges',
    'allongez',
    'allongeâmes',
    'allongeât',
    'allongeâtes',
    'allongiez',
    'allongions',
    'allongèrent',
    'allongé',
    'allongée',
    'allongées',
    'allongés',
    'allons',
    'allopathe',
    'allopathes',
    'allopathie',
    'allopathies',
    'allopathique',
    'allostérie',
    'allostérique',
    'allotropie',
    'allotropies',
    'allotropique',
    'alloua',
    'allouai',
    'allouaient',
    'allouais',
    'allouait',
    'allouant',
    'allouas',
    'allouasse',
    'allouassent',
    'allouasses',
    'allouassiez',
    'allouassions',
    'alloue',
    'allouent',
    'allouer',
    'allouera',
    'allouerai',
    'alloueraient',
    'allouerais',
    'allouerait',
    'alloueras',
    'allouerez',
    'alloueriez',
    'allouerions',
    'allouerons',
    'alloueront',
    'alloues',
    'allouez',
    'allouiez',
    'allouions',
    'allouons',
    'allouâmes',
    'allouât',
    'allouâtes',
    'allouèrent',
    'alloué',
    'allouée',
    'allouées',
    'alloués',
    'alluchon',
    'alluchons',
    'alluma',
    'allumage',
    'allumages',
    'allumai',
    'allumaient',
    'allumais',
    'allumait',
    'allumant',
    'allumas',
    'allumasse',
    'allumassent',
    'allumasses',
    'allumassiez',
    'allumassions',
    'allume',
    'allument',
    'allumer',
    'allumera',
    'allumerai',
    'allumeraient',
    'allumerais',
    'allumerait',
    'allumeras',
    'allumerez',
    'allumeriez',
    'allumerions',
    'allumerons',
    'allumeront',
    'allumes',
    'allumette',
    'allumettes',
    'allumettier',
    'allumettiers',
    'allumettière',
    'allumeur',
    'allumeurs',
    'allumeuse',
    'allumeuses',
    'allumez',
    'allumiez',
    'allumions',
    'allumons',
    'allumâmes',
    'allumât',
    'allumâtes',
    'allumèrent',
    'allumé',
    'allumée',
    'allumées',
    'allumés',
    'allure',
    'allures',
    'alluré',
    'allurée',
    'allurées',
    'allurés',
    'allusif',
    'allusifs',
    'allusion',
    'allusions',
    'allusive',
    'allusives',
    'alluvial',
    'alluviale',
    'alluviales',
    'alluviaux',
    'alluvion',
    'alluvionna',
    'alluvionnai',
    'alluvionnais',
    'alluvionnait',
    'alluvionnant',
    'alluvionnas',
    'alluvionne',
    'alluvionnent',
    'alluvionner',
    'alluvionnera',
    'alluvionnes',
    'alluvionnez',
    'alluvionniez',
    'alluvionnons',
    'alluvionnât',
    'alluvionné',
    'alluvions',
    'allyle',
    'allyles',
    'allylique',
    'allyliques',
    'allâmes',
    'allât',
    'allâtes',
    'allèche',
    'allèchement',
    'allèchements',
    'allèchent',
    'allèches',
    'allège',
    'allègement',
    'allègements',
    'allègent',
    'allèges',
    'allègre',
    'allègrement',
    'allègres',
    'allègue',
    'allèguent',
    'allègues',
    'allène',
    'allènes',
    'allèrent',
    'allé',
    'allécha',
    'alléchai',
    'alléchaient',
    'alléchais',
    'alléchait',
    'alléchant',
    'alléchante',
    'alléchantes',
    'alléchants',
    'alléchas',
    'alléchasse',
    'alléchassent',
    'alléchasses',
    'alléchassiez',
    'allécher',
    'alléchera',
    'allécherai',
    'allécherais',
    'allécherait',
    'allécheras',
    'allécherez',
    'allécheriez',
    'allécherions',
    'allécherons',
    'allécheront',
    'alléchez',
    'alléchiez',
    'alléchions',
    'alléchons',
    'alléchâmes',
    'alléchât',
    'alléchâtes',
    'alléchèrent',
    'alléché',
    'alléchée',
    'alléchées',
    'alléchés',
    'allée',
    'allées',
    'allégation',
    'allégations',
    'allégea',
    'allégeai',
    'allégeaient',
    'allégeais',
    'allégeait',
    'allégeance',
    'allégeances',
    'allégeant',
    'allégeas',
    'allégeasse',
    'allégeassent',
    'allégeasses',
    'allégeassiez',
    'allégement',
    'allégements',
    'allégeons',
    'alléger',
    'allégera',
    'allégerai',
    'allégeraient',
    'allégerais',
    'allégerait',
    'allégeras',
    'allégerez',
    'allégeriez',
    'allégerions',
    'allégerons',
    'allégeront',
    'allégez',
    'allégeâmes',
    'allégeât',
    'allégeâtes',
    'allégi',
    'allégie',
    'allégies',
    'allégiez',
    'allégions',
    'allégir',
    'allégira',
    'allégirai',
    'allégiraient',
    'allégirais',
    'allégirait',
    'allégiras',
    'allégirent',
    'allégirez',
    'allégiriez',
    'allégirions',
    'allégirons',
    'allégiront',
    'allégis',
    'allégissais',
    'allégissait',
    'allégissant',
    'allégisse',
    'allégissent',
    'allégisses',
    'allégissez',
    'allégissiez',
    'allégissions',
    'allégissons',
    'allégit',
    'allégorie',
    'allégories',
    'allégorique',
    'allégoriques',
    'allégorisa',
    'allégorisai',
    'allégorisais',
    'allégorisait',
    'allégorisant',
    'allégorisas',
    'allégorise',
    'allégorisent',
    'allégoriser',
    'allégorisera',
    'allégorises',
    'allégorisez',
    'allégorisiez',
    'allégorisons',
    'allégorisât',
    'allégorisé',
    'allégorisée',
    'allégorisées',
    'allégorisés',
    'allégrement',
    'allégresse',
    'allégresses',
    'allégua',
    'alléguai',
    'alléguaient',
    'alléguais',
    'alléguait',
    'alléguant',
    'alléguas',
    'alléguasse',
    'alléguassent',
    'alléguasses',
    'alléguassiez',
    'alléguer',
    'alléguera',
    'alléguerai',
    'alléguerais',
    'alléguerait',
    'allégueras',
    'alléguerez',
    'allégueriez',
    'alléguerions',
    'alléguerons',
    'allégueront',
    'alléguez',
    'alléguiez',
    'alléguions',
    'alléguons',
    'alléguâmes',
    'alléguât',
    'alléguâtes',
    'alléguèrent',
    'allégué',
    'alléguée',
    'alléguées',
    'allégués',
    'allégèrent',
    'allégé',
    'allégée',
    'allégées',
    'allégés',
    'allégîmes',
    'allégît',
    'allégîtes',
    'allélomorphe',
    'alléluia',
    'allés',
    'allô',
    'almanach',
    'almanachs',
    'almandin',
    'almandins',
    'almasilium',
    'almasiliums',
    'almée',
    'almées',
    'alogie',
    'alogies',
    'alogique',
    'alogiques',
    'aloi',
    'alopécie',
    'alopécies',
    'alors',
    'alose',
    'aloses',
    'alouate',
    'alouates',
    'alouette',
    'alouettes',
    'alourdi',
    'alourdie',
    'alourdies',
    'alourdir',
    'alourdira',
    'alourdirai',
    'alourdirais',
    'alourdirait',
    'alourdiras',
    'alourdirent',
    'alourdirez',
    'alourdiriez',
    'alourdirions',
    'alourdirons',
    'alourdiront',
    'alourdis',
    'alourdissais',
    'alourdissait',
    'alourdissant',
    'alourdisse',
    'alourdissent',
    'alourdisses',
    'alourdissez',
    'alourdissiez',
    'alourdissons',
    'alourdit',
    'alourdîmes',
    'alourdît',
    'alourdîtes',
    'aloyau',
    'aloyaux',
    'aloès',
    'alpaga',
    'alpagas',
    'alpage',
    'alpages',
    'alpagua',
    'alpaguai',
    'alpaguaient',
    'alpaguais',
    'alpaguait',
    'alpaguant',
    'alpaguas',
    'alpaguasse',
    'alpaguassent',
    'alpaguasses',
    'alpaguassiez',
    'alpague',
    'alpaguent',
    'alpaguer',
    'alpaguera',
    'alpaguerai',
    'alpaguerais',
    'alpaguerait',
    'alpagueras',
    'alpaguerez',
    'alpagueriez',
    'alpaguerions',
    'alpaguerons',
    'alpagueront',
    'alpagues',
    'alpaguez',
    'alpaguiez',
    'alpaguions',
    'alpaguons',
    'alpaguâmes',
    'alpaguât',
    'alpaguâtes',
    'alpaguèrent',
    'alpaguée',
    'alpax',
    'alpe',
    'alpes',
    'alpestre',
    'alpestres',
    'alpha',
    'alphabet',
    'alphabets',
    'alphabétique',
    'alphabétisa',
    'alphabétisai',
    'alphabétisas',
    'alphabétise',
    'alphabétiser',
    'alphabétises',
    'alphabétisez',
    'alphabétisme',
    'alphabétisât',
    'alphabétisé',
    'alphabétisée',
    'alphabétisés',
    'alpin',
    'alpine',
    'alpines',
    'alpinisme',
    'alpinismes',
    'alpiniste',
    'alpinistes',
    'alpins',
    'alpiste',
    'alpistes',
    'alsacien',
    'alsacienne',
    'alsaciennes',
    'alsaciens',
    'alter',
    'altercation',
    'altercations',
    'alterna',
    'alternai',
    'alternaient',
    'alternais',
    'alternait',
    'alternance',
    'alternances',
    'alternant',
    'alternante',
    'alternantes',
    'alternants',
    'alternas',
    'alternasse',
    'alternassent',
    'alternasses',
    'alternassiez',
    'alternat',
    'alternateur',
    'alternateurs',
    'alternatif',
    'alternatifs',
    'alternative',
    'alternatives',
    'alternats',
    'alterne',
    'alternent',
    'alterner',
    'alternera',
    'alternerai',
    'alternerais',
    'alternerait',
    'alterneras',
    'alternerez',
    'alterneriez',
    'alternerions',
    'alternerons',
    'alterneront',
    'alternes',
    'alternez',
    'alterniez',
    'alternions',
    'alternons',
    'alternâmes',
    'alternât',
    'alternâtes',
    'alternèrent',
    'alterné',
    'alternée',
    'alternées',
    'alternés',
    'altesse',
    'altesses',
    'altier',
    'altiers',
    'altimètre',
    'altimètres',
    'altimétrie',
    'altimétries',
    'altiport',
    'altiports',
    'altise',
    'altises',
    'altiste',
    'altistes',
    'altitude',
    'altitudes',
    'altière',
    'altières',
    'alto',
    'altocumulus',
    'altos',
    'altruisme',
    'altruismes',
    'altruiste',
    'altruistes',
    'altuglas',
    'altère',
    'altèrent',
    'altères',
    'altéra',
    'altérabilité',
    'altérable',
    'altérables',
    'altéragène',
    'altéragènes',
    'altérai',
    'altéraient',
    'altérais',
    'altérait',
    'altérant',
    'altérante',
    'altérantes',
    'altérants',
    'altéras',
    'altérasse',
    'altérassent',
    'altérasses',
    'altérassiez',
    'altérassions',
    'altération',
    'altérations',
    'altérer',
    'altérera',
    'altérerai',
    'altéreraient',
    'altérerais',
    'altérerait',
    'altéreras',
    'altérerez',
    'altéreriez',
    'altérerions',
    'altérerons',
    'altéreront',
    'altérez',
    'altériez',
    'altérions',
    'altérité',
    'altérités',
    'altérons',
    'altérâmes',
    'altérât',
    'altérâtes',
    'altérèrent',
    'altéré',
    'altérée',
    'altérées',
    'altérés',
    'alucite',
    'alucites',
    'alumina',
    'aluminage',
    'aluminages',
    'aluminai',
    'aluminaient',
    'aluminais',
    'aluminait',
    'aluminant',
    'aluminas',
    'aluminasse',
    'aluminassent',
    'aluminasses',
    'aluminassiez',
    'aluminate',
    'aluminates',
    'alumine',
    'aluminent',
    'aluminer',
    'aluminera',
    'aluminerai',
    'aluminerais',
    'aluminerait',
    'alumineras',
    'aluminerez',
    'alumineriez',
    'aluminerions',
    'aluminerons',
    'alumineront',
    'alumines',
    'alumineuse',
    'alumineuses',
    'alumineux',
    'aluminez',
    'aluminiage',
    'aluminiages',
    'aluminiez',
    'aluminions',
    'aluminium',
    'aluminiums',
    'aluminons',
    'aluminâmes',
    'aluminât',
    'aluminâtes',
    'aluminèrent',
    'aluminé',
    'aluminée',
    'aluminées',
    'aluminés',
    'alun',
    'aluna',
    'alunai',
    'alunaient',
    'alunais',
    'alunait',
    'alunant',
    'alunas',
    'alunasse',
    'alunassent',
    'alunasses',
    'alunassiez',
    'alunassions',
    'alune',
    'alunent',
    'aluner',
    'alunera',
    'alunerai',
    'aluneraient',
    'alunerais',
    'alunerait',
    'aluneras',
    'alunerez',
    'aluneriez',
    'alunerions',
    'alunerons',
    'aluneront',
    'alunes',
    'alunez',
    'aluni',
    'aluniez',
    'alunions',
    'alunir',
    'alunira',
    'alunirai',
    'aluniraient',
    'alunirais',
    'alunirait',
    'aluniras',
    'alunirent',
    'alunirez',
    'aluniriez',
    'alunirions',
    'alunirons',
    'aluniront',
    'alunis',
    'alunissage',
    'alunissages',
    'alunissaient',
    'alunissais',
    'alunissait',
    'alunissant',
    'alunisse',
    'alunissent',
    'alunisses',
    'alunissez',
    'alunissiez',
    'alunissions',
    'alunissons',
    'alunit',
    'alunite',
    'alunites',
    'alunons',
    'aluns',
    'alunâmes',
    'alunât',
    'alunâtes',
    'alunèrent',
    'aluné',
    'alunée',
    'alunées',
    'alunés',
    'alunîmes',
    'alunît',
    'alunîtes',
    'alvin',
    'alvine',
    'alvines',
    'alvins',
    'alvéolaire',
    'alvéolaires',
    'alvéole',
    'alvéoles',
    'alvéolite',
    'alvéolites',
    'alvéolé',
    'alvéolée',
    'alvéolées',
    'alvéolés',
    'alyte',
    'alytes',
    'alèse',
    'alèsent',
    'alèses',
    'aléa',
    'aléas',
    'aléatoire',
    'aléatoires',
    'alémanique',
    'alémaniques',
    'alépine',
    'alépines',
    'alérion',
    'alérions',
    'alésa',
    'alésage',
    'alésages',
    'alésai',
    'alésaient',
    'alésais',
    'alésait',
    'alésant',
    'alésas',
    'alésasse',
    'alésassent',
    'alésasses',
    'alésassiez',
    'alésassions',
    'aléser',
    'alésera',
    'aléserai',
    'aléseraient',
    'aléserais',
    'aléserait',
    'aléseras',
    'aléserez',
    'aléseriez',
    'aléserions',
    'aléserons',
    'aléseront',
    'aléseur',
    'aléseurs',
    'aléseuse',
    'aléseuses',
    'alésez',
    'alésiez',
    'alésions',
    'alésoir',
    'alésoirs',
    'alésons',
    'alésâmes',
    'alésât',
    'alésâtes',
    'alésèrent',
    'alésé',
    'alésée',
    'alésées',
    'alésés',
    'alêne',
    'alênes',
    'amabilité',
    'amabilités',
    'amadou',
    'amadoua',
    'amadouai',
    'amadouaient',
    'amadouais',
    'amadouait',
    'amadouant',
    'amadouas',
    'amadouasse',
    'amadouassent',
    'amadouasses',
    'amadouassiez',
    'amadoue',
    'amadouent',
    'amadouer',
    'amadouera',
    'amadouerai',
    'amadouerais',
    'amadouerait',
    'amadoueras',
    'amadouerez',
    'amadoueriez',
    'amadouerions',
    'amadouerons',
    'amadoueront',
    'amadoues',
    'amadouez',
    'amadouiez',
    'amadouions',
    'amadouons',
    'amadous',
    'amadouvier',
    'amadouviers',
    'amadouâmes',
    'amadouât',
    'amadouâtes',
    'amadouèrent',
    'amadoué',
    'amadouée',
    'amadouées',
    'amadoués',
    'amaigri',
    'amaigrie',
    'amaigries',
    'amaigrir',
    'amaigrira',
    'amaigrirai',
    'amaigrirais',
    'amaigrirait',
    'amaigriras',
    'amaigrirent',
    'amaigrirez',
    'amaigririez',
    'amaigririons',
    'amaigrirons',
    'amaigriront',
    'amaigris',
    'amaigrissais',
    'amaigrissait',
    'amaigrissant',
    'amaigrisse',
    'amaigrissent',
    'amaigrisses',
    'amaigrissez',
    'amaigrissiez',
    'amaigrissons',
    'amaigrit',
    'amaigrîmes',
    'amaigrît',
    'amaigrîtes',
    'amalgama',
    'amalgamai',
    'amalgamaient',
    'amalgamais',
    'amalgamait',
    'amalgamant',
    'amalgamas',
    'amalgamasse',
    'amalgamasses',
    'amalgamation',
    'amalgame',
    'amalgament',
    'amalgamer',
    'amalgamera',
    'amalgamerai',
    'amalgamerais',
    'amalgamerait',
    'amalgameras',
    'amalgamerez',
    'amalgameriez',
    'amalgamerons',
    'amalgameront',
    'amalgames',
    'amalgamez',
    'amalgamiez',
    'amalgamions',
    'amalgamons',
    'amalgamâmes',
    'amalgamât',
    'amalgamâtes',
    'amalgamèrent',
    'amalgamé',
    'amalgamée',
    'amalgamées',
    'amalgamés',
    'amandaie',
    'amandaies',
    'amande',
    'amandes',
    'amandier',
    'amandiers',
    'amanite',
    'amanites',
    'amant',
    'amante',
    'amantes',
    'amants',
    'amarante',
    'amarantes',
    'amareyeur',
    'amareyeurs',
    'amareyeuse',
    'amareyeuses',
    'amaril',
    'amarile',
    'amariles',
    'amarils',
    'amarina',
    'amarinai',
    'amarinaient',
    'amarinais',
    'amarinait',
    'amarinant',
    'amarinas',
    'amarinasse',
    'amarinassent',
    'amarinasses',
    'amarinassiez',
    'amarine',
    'amarinent',
    'amariner',
    'amarinera',
    'amarinerai',
    'amarinerais',
    'amarinerait',
    'amarineras',
    'amarinerez',
    'amarineriez',
    'amarinerions',
    'amarinerons',
    'amarineront',
    'amarines',
    'amarinez',
    'amariniez',
    'amarinions',
    'amarinons',
    'amarinâmes',
    'amarinât',
    'amarinâtes',
    'amarinèrent',
    'amariné',
    'amarinée',
    'amarinées',
    'amarinés',
    'amarra',
    'amarrage',
    'amarrages',
    'amarrai',
    'amarraient',
    'amarrais',
    'amarrait',
    'amarrant',
    'amarras',
    'amarrasse',
    'amarrassent',
    'amarrasses',
    'amarrassiez',
    'amarrassions',
    'amarre',
    'amarrent',
    'amarrer',
    'amarrera',
    'amarrerai',
    'amarreraient',
    'amarrerais',
    'amarrerait',
    'amarreras',
    'amarrerez',
    'amarreriez',
    'amarrerions',
    'amarrerons',
    'amarreront',
    'amarres',
    'amarrez',
    'amarriez',
    'amarrions',
    'amarrons',
    'amarrâmes',
    'amarrât',
    'amarrâtes',
    'amarrèrent',
    'amarré',
    'amarrée',
    'amarrées',
    'amarrés',
    'amaryllis',
    'amas',
    'amassa',
    'amassai',
    'amassaient',
    'amassais',
    'amassait',
    'amassant',
    'amassas',
    'amassasse',
    'amassassent',
    'amassasses',
    'amassassiez',
    'amassassions',
    'amasse',
    'amassent',
    'amasser',
    'amassera',
    'amasserai',
    'amasseraient',
    'amasserais',
    'amasserait',
    'amasseras',
    'amasserez',
    'amasseriez',
    'amasserions',
    'amasserons',
    'amasseront',
    'amasses',
    'amassez',
    'amassiez',
    'amassions',
    'amassons',
    'amassâmes',
    'amassât',
    'amassâtes',
    'amassèrent',
    'amassé',
    'amassée',
    'amassées',
    'amassés',
    'amateur',
    'amateurisme',
    'amateurismes',
    'amateurs',
    'amati',
    'amatie',
    'amaties',
    'amatir',
    'amatira',
    'amatirai',
    'amatiraient',
    'amatirais',
    'amatirait',
    'amatiras',
    'amatirent',
    'amatirez',
    'amatiriez',
    'amatirions',
    'amatirons',
    'amatiront',
    'amatis',
    'amatissaient',
    'amatissais',
    'amatissait',
    'amatissant',
    'amatisse',
    'amatissent',
    'amatisses',
    'amatissez',
    'amatissiez',
    'amatissions',
    'amatissons',
    'amatit',
    'amatîmes',
    'amatît',
    'amatîtes',
    'amaurose',
    'amauroses',
    'amazone',
    'amazones',
    'ambages',
    'ambassade',
    'ambassades',
    'ambassadeur',
    'ambassadeurs',
    'ambassadrice',
    'ambiance',
    'ambiances',
    'ambiant',
    'ambiante',
    'ambiantes',
    'ambiants',
    'ambidextre',
    'ambidextres',
    'ambigu',
    'ambigument',
    'ambigus',
    'ambiguë',
    'ambiguës',
    'ambiguïté',
    'ambiguïtés',
    'ambisexué',
    'ambisexuée',
    'ambisexuées',
    'ambisexués',
    'ambitieuse',
    'ambitieuses',
    'ambitieux',
    'ambition',
    'ambitionna',
    'ambitionnai',
    'ambitionnais',
    'ambitionnait',
    'ambitionnant',
    'ambitionnas',
    'ambitionne',
    'ambitionnent',
    'ambitionner',
    'ambitionnera',
    'ambitionnes',
    'ambitionnez',
    'ambitionniez',
    'ambitionnons',
    'ambitionnât',
    'ambitionné',
    'ambitionnée',
    'ambitionnées',
    'ambitionnés',
    'ambitions',
    'ambivalence',
    'ambivalences',
    'ambivalent',
    'ambivalente',
    'ambivalentes',
    'ambivalents',
    'ambla',
    'amblai',
    'amblaient',
    'amblais',
    'amblait',
    'amblant',
    'amblas',
    'amblasse',
    'amblassent',
    'amblasses',
    'amblassiez',
    'amblassions',
    'amble',
    'amblent',
    'ambler',
    'amblera',
    'amblerai',
    'ambleraient',
    'amblerais',
    'amblerait',
    'ambleras',
    'amblerez',
    'ambleriez',
    'amblerions',
    'amblerons',
    'ambleront',
    'ambles',
    'ambleur',
    'ambleurs',
    'ambleuse',
    'ambleuses',
    'amblez',
    'ambliez',
    'amblions',
    'amblons',
    'amblyope',
    'amblyopes',
    'amblyopie',
    'amblyopies',
    'amblyoscope',
    'amblyoscopes',
    'amblystome',
    'amblystomes',
    'amblâmes',
    'amblât',
    'amblâtes',
    'amblèrent',
    'amblé',
    'ambon',
    'ambons',
    'ambra',
    'ambrai',
    'ambraient',
    'ambrais',
    'ambrait',
    'ambrant',
    'ambras',
    'ambrasse',
    'ambrassent',
    'ambrasses',
    'ambrassiez',
    'ambrassions',
    'ambre',
    'ambrent',
    'ambrer',
    'ambrera',
    'ambrerai',
    'ambreraient',
    'ambrerais',
    'ambrerait',
    'ambreras',
    'ambrerez',
    'ambreriez',
    'ambrerions',
    'ambrerons',
    'ambreront',
    'ambres',
    'ambrez',
    'ambriez',
    'ambrions',
    'ambroisie',
    'ambroisies',
    'ambrons',
    'ambrosien',
    'ambrosienne',
    'ambrosiennes',
    'ambrosiens',
    'ambrâmes',
    'ambrât',
    'ambrâtes',
    'ambrèrent',
    'ambré',
    'ambrée',
    'ambrées',
    'ambrés',
    'ambulacre',
    'ambulacres',
    'ambulance',
    'ambulances',
    'ambulancier',
    'ambulanciers',
    'ambulancière',
    'ambulant',
    'ambulante',
    'ambulantes',
    'ambulants',
    'ambulatoire',
    'ambulatoires',
    'amen',
    'amena',
    'amenai',
    'amenaient',
    'amenais',
    'amenait',
    'amenant',
    'amenas',
    'amenasse',
    'amenassent',
    'amenasses',
    'amenassiez',
    'amenassions',
    'amenda',
    'amendable',
    'amendables',
    'amendai',
    'amendaient',
    'amendais',
    'amendait',
    'amendant',
    'amendas',
    'amendasse',
    'amendassent',
    'amendasses',
    'amendassiez',
    'amendassions',
    'amende',
    'amendement',
    'amendements',
    'amendent',
    'amender',
    'amendera',
    'amenderai',
    'amenderaient',
    'amenderais',
    'amenderait',
    'amenderas',
    'amenderez',
    'amenderiez',
    'amenderions',
    'amenderons',
    'amenderont',
    'amendes',
    'amendez',
    'amendiez',
    'amendions',
    'amendons',
    'amendâmes',
    'amendât',
    'amendâtes',
    'amendèrent',
    'amendé',
    'amendée',
    'amendées',
    'amendés',
    'amener',
    'amenez',
    'ameniez',
    'amenions',
    'amenons',
    'amentifère',
    'amentifères',
    'amenuisa',
    'amenuisai',
    'amenuisaient',
    'amenuisais',
    'amenuisait',
    'amenuisant',
    'amenuisas',
    'amenuisasse',
    'amenuisasses',
    'amenuise',
    'amenuisement',
    'amenuisent',
    'amenuiser',
    'amenuisera',
    'amenuiserai',
    'amenuiserais',
    'amenuiserait',
    'amenuiseras',
    'amenuiserez',
    'amenuiseriez',
    'amenuiserons',
    'amenuiseront',
    'amenuises',
    'amenuisez',
    'amenuisiez',
    'amenuisions',
    'amenuisons',
    'amenuisâmes',
    'amenuisât',
    'amenuisâtes',
    'amenuisèrent',
    'amenuisé',
    'amenuisée',
    'amenuisées',
    'amenuisés',
    'amenâmes',
    'amenât',
    'amenâtes',
    'amenèrent',
    'amené',
    'amenée',
    'amenées',
    'amenés',
    'amer',
    'amerloque',
    'amerloques',
    'amerri',
    'amerrir',
    'amerrira',
    'amerrirai',
    'amerriraient',
    'amerrirais',
    'amerrirait',
    'amerriras',
    'amerrirent',
    'amerrirez',
    'amerririez',
    'amerririons',
    'amerrirons',
    'amerriront',
    'amerris',
    'amerrissage',
    'amerrissages',
    'amerrissais',
    'amerrissait',
    'amerrissant',
    'amerrisse',
    'amerrissent',
    'amerrisses',
    'amerrissez',
    'amerrissiez',
    'amerrissions',
    'amerrissons',
    'amerrit',
    'amerrîmes',
    'amerrît',
    'amerrîtes',
    'amers',
    'amertume',
    'amertumes',
    'ameublement',
    'ameublements',
    'ameubli',
    'ameublie',
    'ameublies',
    'ameublir',
    'ameublira',
    'ameublirai',
    'ameublirais',
    'ameublirait',
    'ameubliras',
    'ameublirent',
    'ameublirez',
    'ameubliriez',
    'ameublirions',
    'ameublirons',
    'ameubliront',
    'ameublis',
    'ameublissais',
    'ameublissait',
    'ameublissant',
    'ameublisse',
    'ameublissent',
    'ameublisses',
    'ameublissez',
    'ameublissiez',
    'ameublissons',
    'ameublit',
    'ameublîmes',
    'ameublît',
    'ameublîtes',
    'ameuta',
    'ameutai',
    'ameutaient',
    'ameutais',
    'ameutait',
    'ameutant',
    'ameutas',
    'ameutasse',
    'ameutassent',
    'ameutasses',
    'ameutassiez',
    'ameutassions',
    'ameute',
    'ameutent',
    'ameuter',
    'ameutera',
    'ameuterai',
    'ameuteraient',
    'ameuterais',
    'ameuterait',
    'ameuteras',
    'ameuterez',
    'ameuteriez',
    'ameuterions',
    'ameuterons',
    'ameuteront',
    'ameutes',
    'ameutez',
    'ameutiez',
    'ameutions',
    'ameutons',
    'ameutâmes',
    'ameutât',
    'ameutâtes',
    'ameutèrent',
    'ameuté',
    'ameutée',
    'ameutées',
    'ameutés',
    'amharique',
    'amhariques',
    'amiable',
    'amiables',
    'amiante',
    'amiantes',
    'amibe',
    'amibes',
    'amibiase',
    'amibiases',
    'amibien',
    'amibienne',
    'amibiennes',
    'amibiens',
    'amiboïde',
    'amiboïdes',
    'amical',
    'amicale',
    'amicalement',
    'amicales',
    'amicaux',
    'amict',
    'amicts',
    'amide',
    'amides',
    'amidon',
    'amidonna',
    'amidonnage',
    'amidonnages',
    'amidonnai',
    'amidonnaient',
    'amidonnais',
    'amidonnait',
    'amidonnant',
    'amidonnas',
    'amidonnasse',
    'amidonnasses',
    'amidonne',
    'amidonnent',
    'amidonner',
    'amidonnera',
    'amidonnerai',
    'amidonnerais',
    'amidonnerait',
    'amidonneras',
    'amidonnerez',
    'amidonnerie',
    'amidonneries',
    'amidonneriez',
    'amidonnerons',
    'amidonneront',
    'amidonnes',
    'amidonnez',
    'amidonnier',
    'amidonniers',
    'amidonniez',
    'amidonnions',
    'amidonnière',
    'amidonnières',
    'amidonnons',
    'amidonnâmes',
    'amidonnât',
    'amidonnâtes',
    'amidonnèrent',
    'amidonné',
    'amidonnée',
    'amidonnées',
    'amidonnés',
    'amidons',
    'amidopyrine',
    'amidopyrines',
    'amie',
    'amies',
    'aminci',
    'amincie',
    'amincies',
    'amincir',
    'amincira',
    'amincirai',
    'aminciraient',
    'amincirais',
    'amincirait',
    'aminciras',
    'amincirent',
    'amincirez',
    'aminciriez',
    'amincirions',
    'amincirons',
    'aminciront',
    'amincis',
    'amincissais',
    'amincissait',
    'amincissant',
    'amincissante',
    'amincissants',
    'amincisse',
    'amincissent',
    'amincisses',
    'amincissez',
    'amincissiez',
    'amincissions',
    'amincissons',
    'amincit',
    'amincîmes',
    'amincît',
    'amincîtes',
    'aminoplaste',
    'aminoplastes',
    'aminé',
    'aminée',
    'aminées',
    'aminés',
    'amiral',
    'amirale',
    'amirales',
    'amirauté',
    'amirautés',
    'amiraux',
    'amis',
    'amitié',
    'amitiés',
    'amitose',
    'amitoses',
    'ammodyte',
    'ammodytes',
    'ammoniac',
    'ammoniacal',
    'ammoniacale',
    'ammoniacales',
    'ammoniacaux',
    'ammoniacs',
    'ammoniaque',
    'ammoniaques',
    'ammonisation',
    'ammonite',
    'ammonites',
    'ammonium',
    'ammoniums',
    'ammophile',
    'ammophiles',
    'amniocentèse',
    'amnios',
    'amnioscopie',
    'amnioscopies',
    'amniote',
    'amniotes',
    'amniotique',
    'amniotiques',
    'amnistia',
    'amnistiable',
    'amnistiables',
    'amnistiai',
    'amnistiaient',
    'amnistiais',
    'amnistiait',
    'amnistiant',
    'amnistiante',
    'amnistiantes',
    'amnistiants',
    'amnistias',
    'amnistiasse',
    'amnistiasses',
    'amnistie',
    'amnistient',
    'amnistier',
    'amnistiera',
    'amnistierai',
    'amnistierais',
    'amnistierait',
    'amnistieras',
    'amnistierez',
    'amnistieriez',
    'amnistierons',
    'amnistieront',
    'amnisties',
    'amnistiez',
    'amnistiiez',
    'amnistiions',
    'amnistions',
    'amnistiâmes',
    'amnistiât',
    'amnistiâtes',
    'amnistièrent',
    'amnistié',
    'amnistiée',
    'amnistiées',
    'amnistiés',
    'amnésie',
    'amnésies',
    'amnésique',
    'amnésiques',
    'amocha',
    'amochai',
    'amochaient',
    'amochais',
    'amochait',
    'amochant',
    'amochas',
    'amochasse',
    'amochassent',
    'amochasses',
    'amochassiez',
    'amochassions',
    'amoche',
    'amochent',
    'amocher',
    'amochera',
    'amocherai',
    'amocheraient',
    'amocherais',
    'amocherait',
    'amocheras',
    'amocherez',
    'amocheriez',
    'amocherions',
    'amocherons',
    'amocheront',
    'amoches',
    'amochez',
    'amochiez',
    'amochions',
    'amochons',
    'amochâmes',
    'amochât',
    'amochâtes',
    'amochèrent',
    'amoché',
    'amochée',
    'amochées',
    'amochés',
    'amodia',
    'amodiai',
    'amodiaient',
    'amodiais',
    'amodiait',
    'amodiant',
    'amodias',
    'amodiasse',
    'amodiassent',
    'amodiasses',
    'amodiassiez',
    'amodiassions',
    'amodiation',
    'amodiations',
    'amodie',
    'amodient',
    'amodier',
    'amodiera',
    'amodierai',
    'amodieraient',
    'amodierais',
    'amodierait',
    'amodieras',
    'amodierez',
    'amodieriez',
    'amodierions',
    'amodierons',
    'amodieront',
    'amodies',
    'amodiez',
    'amodiiez',
    'amodiions',
    'amodions',
    'amodiâmes',
    'amodiât',
    'amodiâtes',
    'amodièrent',
    'amodié',
    'amodiée',
    'amodiées',
    'amodiés',
    'amoindri',
    'amoindrie',
    'amoindries',
    'amoindrir',
    'amoindrira',
    'amoindrirai',
    'amoindrirais',
    'amoindrirait',
    'amoindriras',
    'amoindrirent',
    'amoindrirez',
    'amoindririez',
    'amoindrirons',
    'amoindriront',
    'amoindris',
    'amoindrisse',
    'amoindrisses',
    'amoindrissez',
    'amoindrit',
    'amoindrîmes',
    'amoindrît',
    'amoindrîtes',
    'amolli',
    'amollie',
    'amollies',
    'amollir',
    'amollira',
    'amollirai',
    'amolliraient',
    'amollirais',
    'amollirait',
    'amolliras',
    'amollirent',
    'amollirez',
    'amolliriez',
    'amollirions',
    'amollirons',
    'amolliront',
    'amollis',
    'amollissais',
    'amollissait',
    'amollissant',
    'amollissante',
    'amollissants',
    'amollisse',
    'amollissent',
    'amollisses',
    'amollissez',
    'amollissiez',
    'amollissions',
    'amollissons',
    'amollit',
    'amollîmes',
    'amollît',
    'amollîtes',
    'amoncela',
    'amoncelai',
    'amoncelaient',
    'amoncelais',
    'amoncelait',
    'amoncelant',
    'amoncelas',
    'amoncelasse',
    'amoncelasses',
    'amonceler',
    'amoncelez',
    'amonceliez',
    'amoncelions',
    'amoncelle',
    'amoncellent',
    'amoncellera',
    'amoncellerai',
    'amoncelleras',
    'amoncellerez',
    'amoncelles',
    'amoncelons',
    'amoncelâmes',
    'amoncelât',
    'amoncelâtes',
    'amoncelèrent',
    'amoncelé',
    'amoncelée',
    'amoncelées',
    'amoncelés',
    'amonibilité',
    'amonibilités',
    'amont',
    'amonts',
    'amoral',
    'amorale',
    'amorales',
    'amoralisme',
    'amoralismes',
    'amoraux',
    'amorce',
    'amorcent',
    'amorcer',
    'amorcera',
    'amorcerai',
    'amorceraient',
    'amorcerais',
    'amorcerait',
    'amorceras',
    'amorcerez',
    'amorceriez',
    'amorcerions',
    'amorcerons',
    'amorceront',
    'amorces',
    'amorcez',
    'amorciez',
    'amorcions',
    'amorcèrent',
    'amorcé',
    'amorcée',
    'amorcées',
    'amorcés',
    'amordance',
    'amordancent',
    'amordancer',
    'amordancera',
    'amordancerai',
    'amordanceras',
    'amordancerez',
    'amordances',
    'amordancez',
    'amordanciez',
    'amordancions',
    'amordancé',
    'amordancée',
    'amordancées',
    'amordancés',
    'amordança',
    'amordançai',
    'amordançais',
    'amordançait',
    'amordançant',
    'amordanças',
    'amordançasse',
    'amordançons',
    'amordançâmes',
    'amordançât',
    'amordançâtes',
    'amoroso',
    'amorphe',
    'amorphes',
    'amorti',
    'amortie',
    'amorties',
    'amortir',
    'amortira',
    'amortirai',
    'amortiraient',
    'amortirais',
    'amortirait',
    'amortiras',
    'amortirent',
    'amortirez',
    'amortiriez',
    'amortirions',
    'amortirons',
    'amortiront',
    'amortis',
    'amortissable',
    'amortissais',
    'amortissait',
    'amortissant',
    'amortisse',
    'amortissent',
    'amortisses',
    'amortisseur',
    'amortisseurs',
    'amortissez',
    'amortissiez',
    'amortissions',
    'amortissons',
    'amortit',
    'amortîmes',
    'amortît',
    'amortîtes',
    'amorça',
    'amorçage',
    'amorçages',
    'amorçai',
    'amorçaient',
    'amorçais',
    'amorçait',
    'amorçant',
    'amorças',
    'amorçasse',
    'amorçassent',
    'amorçasses',
    'amorçassiez',
    'amorçassions',
    'amorçons',
    'amorçâmes',
    'amorçât',
    'amorçâtes',
    'amotissaient',
    'amotissais',
    'amotissait',
    'amotissant',
    'amotissez',
    'amotissiez',
    'amotissions',
    'amotissons',
    'amour',
    'amouracher',
    'amouracherez',
    'amourachez',
    'amourachiez',
    'amourachions',
    'amourachons',
    'amourachâmes',
    'amourachâtes',
    'amouraché',
    'amourachée',
    'amourachées',
    'amourachés',
    'amourette',
    'amourettes',
    'amoureuse',
    'amoureuses',
    'amoureux',
    'amours',
    'amovible',
    'amovibles',
    'amphi',
    'amphibie',
    'amphibiens',
    'amphibies',
    'amphibole',
    'amphiboles',
    'amphibologie',
    'amphictyon',
    'amphictyonie',
    'amphictyons',
    'amphigouri',
    'amphigouris',
    'amphimixie',
    'amphimixies',
    'amphioxus',
    'amphis',
    'amphisbène',
    'amphisbènes',
    'amphithéâtre',
    'amphitryon',
    'amphitryons',
    'ampholyte',
    'ampholytes',
    'amphore',
    'amphores',
    'amphotère',
    'amphotères',
    'amphétamine',
    'amphétamines',
    'ample',
    'amplectif',
    'amplectifs',
    'amplective',
    'amplectives',
    'amplement',
    'amples',
    'ampleur',
    'ampleurs',
    'ampli',
    'ampliatif',
    'ampliatifs',
    'ampliation',
    'ampliations',
    'ampliative',
    'ampliatives',
    'amplifia',
    'amplifiai',
    'amplifiaient',
    'amplifiais',
    'amplifiait',
    'amplifiant',
    'amplifiante',
    'amplifiantes',
    'amplifias',
    'amplifiasse',
    'amplifiasses',
    'amplifie',
    'amplifient',
    'amplifier',
    'amplifiera',
    'amplifierai',
    'amplifierais',
    'amplifierait',
    'amplifieras',
    'amplifierez',
    'amplifieriez',
    'amplifierons',
    'amplifieront',
    'amplifies',
    'amplifiez',
    'amplifiiez',
    'amplifiions',
    'amplifions',
    'amplifiâmes',
    'amplifiât',
    'amplifiâtes',
    'amplifièrent',
    'amplifié',
    'amplifiée',
    'amplifiées',
    'amplifiés',
    'amplis',
    'amplitude',
    'amplitudes',
    'ampoule',
    'ampoules',
    'ampoulé',
    'ampoulée',
    'ampoulées',
    'ampoulés',
    'amputa',
    'amputai',
    'amputaient',
    'amputais',
    'amputait',
    'amputant',
    'amputas',
    'amputasse',
    'amputassent',
    'amputasses',
    'amputassiez',
    'amputassions',
    'amputation',
    'amputations',
    'ampute',
    'amputent',
    'amputer',
    'amputera',
    'amputerai',
    'amputeraient',
    'amputerais',
    'amputerait',
    'amputeras',
    'amputerez',
    'amputeriez',
    'amputerions',
    'amputerons',
    'amputeront',
    'amputes',
    'amputez',
    'amputiez',
    'amputions',
    'amputons',
    'amputâmes',
    'amputât',
    'amputâtes',
    'amputèrent',
    'amputé',
    'amputée',
    'amputées',
    'amputés',
    'ampère',
    'ampèremètre',
    'ampèremètres',
    'ampères',
    'amulette',
    'amulettes',
    'amura',
    'amurai',
    'amuraient',
    'amurais',
    'amurait',
    'amurant',
    'amuras',
    'amurasse',
    'amurassent',
    'amurasses',
    'amurassiez',
    'amurassions',
    'amure',
    'amurent',
    'amurer',
    'amurera',
    'amurerai',
    'amureraient',
    'amurerais',
    'amurerait',
    'amureras',
    'amurerez',
    'amureriez',
    'amurerions',
    'amurerons',
    'amureront',
    'amures',
    'amurez',
    'amuriez',
    'amurions',
    'amurons',
    'amurâmes',
    'amurât',
    'amurâtes',
    'amurèrent',
    'amuré',
    'amurée',
    'amurées',
    'amurés',
    'amusa',
    'amusai',
    'amusaient',
    'amusais',
    'amusait',
    'amusant',
    'amusante',
    'amusantes',
    'amusants',
    'amusas',
    'amusasse',
    'amusassent',
    'amusasses',
    'amusassiez',
    'amusassions',
    'amuse',
    'amusement',
    'amusements',
    'amusent',
    'amuser',
    'amusera',
    'amuserai',
    'amuseraient',
    'amuserais',
    'amuserait',
    'amuseras',
    'amuserez',
    'amuseriez',
    'amuserions',
    'amuserons',
    'amuseront',
    'amuses',
    'amusette',
    'amusettes',
    'amuseur',
    'amuseurs',
    'amuseuse',
    'amuseuses',
    'amusez',
    'amusie',
    'amusies',
    'amusiez',
    'amusions',
    'amusons',
    'amusâmes',
    'amusât',
    'amusâtes',
    'amusèrent',
    'amusé',
    'amusée',
    'amusées',
    'amusés',
    'amuï',
    'amuïe',
    'amuïes',
    'amuïmes',
    'amuïr',
    'amuïrent',
    'amuïrez',
    'amuïriez',
    'amuïrions',
    'amuïrons',
    'amuïs',
    'amuïssement',
    'amuïssements',
    'amuïssent',
    'amuïssez',
    'amuïssiez',
    'amuïssions',
    'amuïssons',
    'amuïtes',
    'amygdale',
    'amygdales',
    'amygdalite',
    'amygdalites',
    'amylacé',
    'amylacée',
    'amylacées',
    'amylacés',
    'amylase',
    'amylases',
    'amyle',
    'amyles',
    'amylique',
    'amyliques',
    'amylobacter',
    'amylobacters',
    'amylène',
    'amylènes',
    'amyotrophie',
    'amyotrophies',
    'amène',
    'amènent',
    'amènera',
    'amènerai',
    'amèneraient',
    'amènerais',
    'amènerait',
    'amèneras',
    'amènerez',
    'amèneriez',
    'amènerions',
    'amènerons',
    'amèneront',
    'amènes',
    'amère',
    'amèrement',
    'amères',
    'améliora',
    'améliorable',
    'améliorables',
    'améliorai',
    'amélioraient',
    'améliorais',
    'améliorait',
    'améliorant',
    'améliorante',
    'améliorantes',
    'améliorants',
    'amélioras',
    'améliorasse',
    'améliorasses',
    'amélioration',
    'améliore',
    'améliorent',
    'améliorer',
    'améliorera',
    'améliorerai',
    'améliorerais',
    'améliorerait',
    'amélioreras',
    'améliorerez',
    'amélioreriez',
    'améliorerons',
    'amélioreront',
    'améliores',
    'améliorez',
    'amélioriez',
    'améliorions',
    'améliorons',
    'améliorâmes',
    'améliorât',
    'améliorâtes',
    'améliorèrent',
    'amélioré',
    'améliorée',
    'améliorées',
    'améliorés',
    'aménage',
    'aménagea',
    'aménageable',
    'aménageables',
    'aménageai',
    'aménageaient',
    'aménageais',
    'aménageait',
    'aménageant',
    'aménageas',
    'aménageasse',
    'aménageasses',
    'aménagement',
    'aménagements',
    'aménagent',
    'aménageons',
    'aménager',
    'aménagera',
    'aménagerai',
    'aménagerais',
    'aménagerait',
    'aménageras',
    'aménagerez',
    'aménageriez',
    'aménagerions',
    'aménagerons',
    'aménageront',
    'aménages',
    'aménageur',
    'aménageurs',
    'aménageuse',
    'aménageuses',
    'aménagez',
    'aménageâmes',
    'aménageât',
    'aménageâtes',
    'aménagiez',
    'aménagions',
    'aménagèrent',
    'aménagé',
    'aménagée',
    'aménagées',
    'aménagés',
    'aménité',
    'aménités',
    'aménorrhée',
    'aménorrhées',
    'américain',
    'américaine',
    'américaines',
    'américains',
    'américanisa',
    'américanisai',
    'américanisas',
    'américanise',
    'américaniser',
    'américanises',
    'américanisez',
    'américanisme',
    'américaniste',
    'américanisât',
    'américanisé',
    'américanisée',
    'américanisés',
    'américium',
    'américiums',
    'amérindien',
    'amérindienne',
    'amérindiens',
    'améthyste',
    'améthystes',
    'amétrope',
    'amétropes',
    'amétropie',
    'amétropies',
    'anabaptisme',
    'anabaptismes',
    'anabaptiste',
    'anabaptistes',
    'anabolisant',
    'anabolisante',
    'anabolisants',
    'anabolisme',
    'anabolismes',
    'anabolite',
    'anabolites',
    'anacardier',
    'anacardiers',
    'anachorète',
    'anachorètes',
    'anachronique',
    'anachronisme',
    'anacoluthe',
    'anacoluthes',
    'anaconda',
    'anacondas',
    'anacrouse',
    'anacrouses',
    'anaglyphe',
    'anaglyphes',
    'anaglyptique',
    'anagnoste',
    'anagnostes',
    'anagogie',
    'anagogies',
    'anagogique',
    'anagogiques',
    'anagramme',
    'anagrammes',
    'anal',
    'anale',
    'analecta',
    'analeptique',
    'analeptiques',
    'anales',
    'analgésia',
    'analgésiai',
    'analgésiais',
    'analgésiait',
    'analgésiant',
    'analgésias',
    'analgésiasse',
    'analgésie',
    'analgésient',
    'analgésier',
    'analgésiera',
    'analgésierai',
    'analgésieras',
    'analgésierez',
    'analgésies',
    'analgésiez',
    'analgésiiez',
    'analgésiions',
    'analgésions',
    'analgésique',
    'analgésiques',
    'analgésiâmes',
    'analgésiât',
    'analgésiâtes',
    'analgésié',
    'analgésiée',
    'analgésiées',
    'analgésiés',
    'analité',
    'analités',
    'anallergique',
    'analogie',
    'analogies',
    'analogique',
    'analogiques',
    'analogon',
    'analogons',
    'analogue',
    'analogues',
    'analphabète',
    'analphabètes',
    'analysa',
    'analysable',
    'analysables',
    'analysai',
    'analysaient',
    'analysais',
    'analysait',
    'analysant',
    'analysante',
    'analysantes',
    'analysants',
    'analysas',
    'analysasse',
    'analysassent',
    'analysasses',
    'analysassiez',
    'analyse',
    'analysent',
    'analyser',
    'analysera',
    'analyserai',
    'analyserais',
    'analyserait',
    'analyseras',
    'analyserez',
    'analyseriez',
    'analyserions',
    'analyserons',
    'analyseront',
    'analyses',
    'analyseur',
    'analyseurs',
    'analysez',
    'analysiez',
    'analysions',
    'analysons',
    'analyste',
    'analystes',
    'analysâmes',
    'analysât',
    'analysâtes',
    'analysèrent',
    'analysé',
    'analysée',
    'analysées',
    'analysés',
    'analytique',
    'analytiques',
    'anamnèse',
    'anamnèses',
    'anamorphose',
    'anamorphoses',
    'ananas',
    'anapeste',
    'anapestes',
    'anaphase',
    'anaphases',
    'anaphore',
    'anaphores',
    'anaphorique',
    'anaphoriques',
    'anaphorèse',
    'anaphorèses',
    'anaphrodisie',
    'anaphylaxie',
    'anaphylaxies',
    'anaplastie',
    'anaplasties',
    'anarchie',
    'anarchies',
    'anarchique',
    'anarchiques',
    'anarchisant',
    'anarchisante',
    'anarchisants',
    'anarchisme',
    'anarchismes',
    'anarchiste',
    'anarchistes',
    'anarthrie',
    'anarthries',
    'anasarque',
    'anasarques',
    'anastigmat',
    'anastigmats',
    'anastomose',
    'anastomoser',
    'anastomoses',
    'anastomosez',
    'anastomosiez',
    'anastomosons',
    'anastomosé',
    'anastomosée',
    'anastomosées',
    'anastomosés',
    'anastrophe',
    'anastrophes',
    'anathème',
    'anathèmes',
    'anathématisa',
    'anathématise',
    'anathématisé',
    'anatife',
    'anatifes',
    'anatocisme',
    'anatocismes',
    'anatomie',
    'anatomies',
    'anatomique',
    'anatomiques',
    'anatomisa',
    'anatomisai',
    'anatomisais',
    'anatomisait',
    'anatomisant',
    'anatomisas',
    'anatomisasse',
    'anatomise',
    'anatomisent',
    'anatomiser',
    'anatomisera',
    'anatomiserai',
    'anatomiseras',
    'anatomiserez',
    'anatomises',
    'anatomisez',
    'anatomisiez',
    'anatomisions',
    'anatomisons',
    'anatomiste',
    'anatomistes',
    'anatomisâmes',
    'anatomisât',
    'anatomisâtes',
    'anatomisé',
    'anatomisée',
    'anatomisées',
    'anatomisés',
    'anaux',
    'anavenin',
    'anavenins',
    'anaérobie',
    'anaérobies',
    'ancestral',
    'ancestrale',
    'ancestrales',
    'ancestraux',
    'anche',
    'anches',
    'anchois',
    'ancien',
    'ancienne',
    'anciennement',
    'anciennes',
    'ancienneté',
    'anciennetés',
    'anciens',
    'ancillaire',
    'ancillaires',
    'ancolie',
    'ancolies',
    'ancra',
    'ancrage',
    'ancrages',
    'ancrai',
    'ancraient',
    'ancrais',
    'ancrait',
    'ancrant',
    'ancras',
    'ancrasse',
    'ancrassent',
    'ancrasses',
    'ancrassiez',
    'ancrassions',
    'ancre',
    'ancrent',
    'ancrer',
    'ancrera',
    'ancrerai',
    'ancreraient',
    'ancrerais',
    'ancrerait',
    'ancreras',
    'ancrerez',
    'ancreriez',
    'ancrerions',
    'ancrerons',
    'ancreront',
    'ancres',
    'ancrez',
    'ancriez',
    'ancrions',
    'ancrons',
    'ancrâmes',
    'ancrât',
    'ancrâtes',
    'ancrèrent',
    'ancré',
    'ancrée',
    'ancrées',
    'ancrés',
    'ancêtre',
    'ancêtres',
    'andain',
    'andains',
    'andalou',
    'andalous',
    'andalouse',
    'andalouses',
    'andante',
    'andantes',
    'andantino',
    'andantinos',
    'andin',
    'andine',
    'andines',
    'andins',
    'andouille',
    'andouiller',
    'andouillers',
    'andouilles',
    'andouillette',
    'andrinople',
    'andrinoples',
    'androcée',
    'androcées',
    'androcéphale',
    'androgenèse',
    'androgenèses',
    'androgyne',
    'androgynes',
    'androgène',
    'androgènes',
    'androgénie',
    'androgénies',
    'andrologie',
    'andrologies',
    'andrologue',
    'andrologues',
    'andropause',
    'andropauses',
    'androstérone',
    'androïde',
    'androïdes',
    'andrène',
    'andrènes',
    'andésite',
    'andésites',
    'anecdote',
    'anecdotes',
    'anecdotier',
    'anecdotiers',
    'anecdotique',
    'anecdotiques',
    'anecdotière',
    'anecdotières',
    'anesthésia',
    'anesthésiai',
    'anesthésiais',
    'anesthésiait',
    'anesthésiant',
    'anesthésias',
    'anesthésie',
    'anesthésient',
    'anesthésier',
    'anesthésiera',
    'anesthésies',
    'anesthésiez',
    'anesthésiiez',
    'anesthésions',
    'anesthésique',
    'anesthésiste',
    'anesthésiât',
    'anesthésié',
    'anesthésiée',
    'anesthésiées',
    'anesthésiés',
    'aneth',
    'aneths',
    'angarie',
    'angaries',
    'ange',
    'angelot',
    'angelots',
    'anges',
    'angevin',
    'angevine',
    'angevines',
    'angevins',
    'angiectasie',
    'angiectasies',
    'angine',
    'angines',
    'angineuse',
    'angineuses',
    'angineux',
    'angiocholite',
    'angiographie',
    'angiologie',
    'angiologies',
    'angiome',
    'angiomes',
    'angiosperme',
    'angiospermes',
    'anglais',
    'anglaisa',
    'anglaisai',
    'anglaisaient',
    'anglaisais',
    'anglaisait',
    'anglaisant',
    'anglaisas',
    'anglaisasse',
    'anglaisasses',
    'anglaise',
    'anglaisent',
    'anglaiser',
    'anglaisera',
    'anglaiserai',
    'anglaiserais',
    'anglaiserait',
    'anglaiseras',
    'anglaiserez',
    'anglaiseriez',
    'anglaiserons',
    'anglaiseront',
    'anglaises',
    'anglaisez',
    'anglaisiez',
    'anglaisions',
    'anglaisons',
    'anglaisâmes',
    'anglaisât',
    'anglaisâtes',
    'anglaisèrent',
    'anglaisé',
    'anglaisée',
    'anglaisées',
    'anglaisés',
    'angle',
    'angledozer',
    'angledozers',
    'angles',
    'anglet',
    'anglets',
    'anglican',
    'anglicane',
    'anglicanes',
    'anglicanisme',
    'anglicans',
    'anglicisa',
    'anglicisai',
    'anglicisais',
    'anglicisait',
    'anglicisant',
    'anglicisas',
    'anglicisasse',
    'anglicise',
    'anglicisent',
    'angliciser',
    'anglicisera',
    'angliciserai',
    'angliciseras',
    'angliciserez',
    'anglicises',
    'anglicisez',
    'anglicisiez',
    'anglicisions',
    'anglicisme',
    'anglicismes',
    'anglicisons',
    'angliciste',
    'anglicistes',
    'anglicisâmes',
    'anglicisât',
    'anglicisâtes',
    'anglicisé',
    'anglicisée',
    'anglicisées',
    'anglicisés',
    'anglomane',
    'anglomanes',
    'anglomanie',
    'anglomanies',
    'anglophile',
    'anglophiles',
    'anglophilie',
    'anglophilies',
    'anglophobe',
    'anglophobes',
    'anglophobie',
    'anglophobies',
    'anglophone',
    'anglophones',
    'angoissa',
    'angoissai',
    'angoissaient',
    'angoissais',
    'angoissait',
    'angoissant',
    'angoissante',
    'angoissantes',
    'angoissants',
    'angoissas',
    'angoissasse',
    'angoissasses',
    'angoisse',
    'angoissent',
    'angoisser',
    'angoissera',
    'angoisserai',
    'angoisserais',
    'angoisserait',
    'angoisseras',
    'angoisserez',
    'angoisseriez',
    'angoisserons',
    'angoisseront',
    'angoisses',
    'angoissez',
    'angoissiez',
    'angoissions',
    'angoissons',
    'angoissâmes',
    'angoissât',
    'angoissâtes',
    'angoissèrent',
    'angoissé',
    'angoissée',
    'angoissées',
    'angoissés',
    'angon',
    'angons',
    'angor',
    'angora',
    'angoras',
    'angors',
    'angstroem',
    'angstroems',
    'anguiforme',
    'anguiformes',
    'anguille',
    'anguilles',
    'anguillule',
    'anguillules',
    'anguillère',
    'anguillères',
    'angulaire',
    'angulaires',
    'anguleuse',
    'anguleuses',
    'anguleux',
    'angusticlave',
    'angustura',
    'angusturas',
    'angusture',
    'angustures',
    'angéite',
    'angéites',
    'angélique',
    'angéliques',
    'angélisme',
    'angélismes',
    'angélus',
    'anharmonique',
    'anhidrose',
    'anhidroses',
    'anhydre',
    'anhydres',
    'anhydride',
    'anhydrides',
    'anhydrite',
    'anhydrites',
    'anhèle',
    'anhèlent',
    'anhèles',
    'anhéla',
    'anhélai',
    'anhélaient',
    'anhélais',
    'anhélait',
    'anhélant',
    'anhélas',
    'anhélasse',
    'anhélassent',
    'anhélasses',
    'anhélassiez',
    'anhélassions',
    'anhélation',
    'anhélations',
    'anhéler',
    'anhélera',
    'anhélerai',
    'anhéleraient',
    'anhélerais',
    'anhélerait',
    'anhéleras',
    'anhélerez',
    'anhéleriez',
    'anhélerions',
    'anhélerons',
    'anhéleront',
    'anhélez',
    'anhéliez',
    'anhélions',
    'anhélons',
    'anhélâmes',
    'anhélât',
    'anhélâtes',
    'anhélèrent',
    'anhélé',
    'anicroche',
    'anicroches',
    'aniline',
    'anilines',
    'anilisme',
    'anilismes',
    'anima',
    'animai',
    'animaient',
    'animais',
    'animait',
    'animal',
    'animalcule',
    'animalcules',
    'animale',
    'animalerie',
    'animaleries',
    'animales',
    'animalier',
    'animaliers',
    'animalisa',
    'animalisai',
    'animalisais',
    'animalisait',
    'animalisant',
    'animalisas',
    'animalisasse',
    'animalise',
    'animalisent',
    'animaliser',
    'animalisera',
    'animaliserai',
    'animaliseras',
    'animaliserez',
    'animalises',
    'animalisez',
    'animalisiez',
    'animalisions',
    'animalisons',
    'animalisâmes',
    'animalisât',
    'animalisâtes',
    'animalisé',
    'animalisée',
    'animalisées',
    'animalisés',
    'animalité',
    'animalités',
    'animalière',
    'animalières',
    'animant',
    'animas',
    'animasse',
    'animassent',
    'animasses',
    'animassiez',
    'animassions',
    'animateur',
    'animateurs',
    'animation',
    'animations',
    'animatrice',
    'animatrices',
    'animaux',
    'anime',
    'animent',
    'animer',
    'animera',
    'animerai',
    'animeraient',
    'animerais',
    'animerait',
    'animeras',
    'animerez',
    'animeriez',
    'animerions',
    'animerons',
    'animeront',
    'animes',
    'animez',
    'animiez',
    'animions',
    'animisme',
    'animismes',
    'animiste',
    'animistes',
    'animons',
    'animosité',
    'animosités',
    'animâmes',
    'animât',
    'animâtes',
    'animèrent',
    'animé',
    'animée',
    'animées',
    'animés',
    'anion',
    'anionique',
    'anioniques',
    'anions',
    'anis',
    'anisa',
    'anisai',
    'anisaient',
    'anisais',
    'anisait',
    'anisant',
    'anisas',
    'anisasse',
    'anisassent',
    'anisasses',
    'anisassiez',
    'anisassions',
    'anise',
    'anisent',
    'aniser',
    'anisera',
    'aniserai',
    'aniseraient',
    'aniserais',
    'aniserait',
    'aniseras',
    'aniserez',
    'aniseriez',
    'aniserions',
    'aniserons',
    'aniseront',
    'anises',
    'anisette',
    'anisettes',
    'anisez',
    'anisiez',
    'anisions',
    'anisons',
    'anisotrope',
    'anisotropes',
    'anisotropie',
    'anisotropies',
    'anisâmes',
    'anisât',
    'anisâtes',
    'anisèrent',
    'anisé',
    'anisée',
    'anisées',
    'anisés',
    'ankylosa',
    'ankylosai',
    'ankylosaient',
    'ankylosais',
    'ankylosait',
    'ankylosant',
    'ankylosas',
    'ankylosasse',
    'ankylosasses',
    'ankylose',
    'ankylosent',
    'ankyloser',
    'ankylosera',
    'ankyloserai',
    'ankyloserais',
    'ankyloserait',
    'ankyloseras',
    'ankyloserez',
    'ankyloseriez',
    'ankyloserons',
    'ankyloseront',
    'ankyloses',
    'ankylosez',
    'ankylosiez',
    'ankylosions',
    'ankylosons',
    'ankylostome',
    'ankylostomes',
    'ankylosâmes',
    'ankylosât',
    'ankylosâtes',
    'ankylosèrent',
    'ankylosé',
    'ankylosée',
    'ankylosées',
    'ankylosés',
    'annal',
    'annale',
    'annales',
    'annaliste',
    'annalistes',
    'annalité',
    'annalités',
    'annamite',
    'annamites',
    'annaux',
    'anneau',
    'anneaux',
    'annela',
    'annelai',
    'annelaient',
    'annelais',
    'annelait',
    'annelant',
    'annelas',
    'annelasse',
    'annelassent',
    'annelasses',
    'annelassiez',
    'annelassions',
    'anneler',
    'annelez',
    'anneliez',
    'annelions',
    'annelle',
    'annellent',
    'annellera',
    'annellerai',
    'annellerais',
    'annellerait',
    'annelleras',
    'annellerez',
    'annelleriez',
    'annellerions',
    'annellerons',
    'annelleront',
    'annelles',
    'annelons',
    'annelâmes',
    'annelât',
    'annelâtes',
    'annelèrent',
    'annelé',
    'annelée',
    'annelées',
    'annelés',
    'annexa',
    'annexai',
    'annexaient',
    'annexais',
    'annexait',
    'annexant',
    'annexas',
    'annexasse',
    'annexassent',
    'annexasses',
    'annexassiez',
    'annexassions',
    'annexe',
    'annexent',
    'annexer',
    'annexera',
    'annexerai',
    'annexeraient',
    'annexerais',
    'annexerait',
    'annexeras',
    'annexerez',
    'annexeriez',
    'annexerions',
    'annexerons',
    'annexeront',
    'annexes',
    'annexez',
    'annexiez',
    'annexion',
    'annexions',
    'annexons',
    'annexâmes',
    'annexât',
    'annexâtes',
    'annexèrent',
    'annexé',
    'annexée',
    'annexées',
    'annexés',
    'annihila',
    'annihilai',
    'annihilaient',
    'annihilais',
    'annihilait',
    'annihilant',
    'annihilas',
    'annihilasse',
    'annihilasses',
    'annihilation',
    'annihile',
    'annihilent',
    'annihiler',
    'annihilera',
    'annihilerai',
    'annihilerais',
    'annihilerait',
    'annihileras',
    'annihilerez',
    'annihileriez',
    'annihilerons',
    'annihileront',
    'annihiles',
    'annihilez',
    'annihiliez',
    'annihilions',
    'annihilons',
    'annihilâmes',
    'annihilât',
    'annihilâtes',
    'annihilèrent',
    'annihilé',
    'annihilée',
    'annihilées',
    'annihilés',
    'anniversaire',
    'annonce',
    'annoncent',
    'annoncer',
    'annoncera',
    'annoncerai',
    'annoncerais',
    'annoncerait',
    'annonceras',
    'annoncerez',
    'annonceriez',
    'annoncerions',
    'annoncerons',
    'annonceront',
    'annonces',
    'annonceur',
    'annonceurs',
    'annonceuse',
    'annonceuses',
    'annoncez',
    'annonciateur',
    'annonciation',
    'annoncier',
    'annonciers',
    'annonciez',
    'annoncions',
    'annoncière',
    'annoncières',
    'annoncèrent',
    'annoncé',
    'annoncée',
    'annoncées',
    'annoncés',
    'annone',
    'annones',
    'annonça',
    'annonçai',
    'annonçaient',
    'annonçais',
    'annonçait',
    'annonçant',
    'annonças',
    'annonçasse',
    'annonçassent',
    'annonçasses',
    'annonçassiez',
    'annonçons',
    'annonçâmes',
    'annonçât',
    'annonçâtes',
    'annota',
    'annotai',
    'annotaient',
    'annotais',
    'annotait',
    'annotant',
    'annotas',
    'annotasse',
    'annotassent',
    'annotasses',
    'annotassiez',
    'annotassions',
    'annotateur',
    'annotateurs',
    'annotation',
    'annotations',
    'annotatrice',
    'annotatrices',
    'annote',
    'annotent',
    'annoter',
    'annotera',
    'annoterai',
    'annoteraient',
    'annoterais',
    'annoterait',
    'annoteras',
    'annoterez',
    'annoteriez',
    'annoterions',
    'annoterons',
    'annoteront',
    'annotes',
    'annotez',
    'annotiez',
    'annotions',
    'annotons',
    'annotâmes',
    'annotât',
    'annotâtes',
    'annotèrent',
    'annoté',
    'annotée',
    'annotées',
    'annotés',
    'annuaire',
    'annuaires',
    'annualité',
    'annualités',
    'annuel',
    'annuelle',
    'annuellement',
    'annuelles',
    'annuels',
    'annuitaire',
    'annuitaires',
    'annuité',
    'annuités',
    'annula',
    'annulable',
    'annulables',
    'annulai',
    'annulaient',
    'annulaire',
    'annulaires',
    'annulais',
    'annulait',
    'annulant',
    'annulas',
    'annulasse',
    'annulassent',
    'annulasses',
    'annulassiez',
    'annulassions',
    'annulation',
    'annulations',
    'annule',
    'annulent',
    'annuler',
    'annulera',
    'annulerai',
    'annuleraient',
    'annulerais',
    'annulerait',
    'annuleras',
    'annulerez',
    'annuleriez',
    'annulerions',
    'annulerons',
    'annuleront',
    'annules',
    'annulez',
    'annuliez',
    'annulions',
    'annulons',
    'annulâmes',
    'annulât',
    'annulâtes',
    'annulèrent',
    'annulé',
    'annulée',
    'annulées',
    'annulés',
    'année',
    'années',
    'annélides',
    'anobli',
    'anoblie',
    'anoblies',
    'anoblir',
    'anoblira',
    'anoblirai',
    'anobliraient',
    'anoblirais',
    'anoblirait',
    'anobliras',
    'anoblirent',
    'anoblirez',
    'anobliriez',
    'anoblirions',
    'anoblirons',
    'anobliront',
    'anoblis',
    'anoblissais',
    'anoblissait',
    'anoblissant',
    'anoblisse',
    'anoblissent',
    'anoblisses',
    'anoblissez',
    'anoblissiez',
    'anoblissions',
    'anoblissons',
    'anoblit',
    'anoblîmes',
    'anoblît',
    'anoblîtes',
    'anode',
    'anodes',
    'anodin',
    'anodine',
    'anodines',
    'anodins',
    'anodisa',
    'anodisai',
    'anodisaient',
    'anodisais',
    'anodisait',
    'anodisant',
    'anodisas',
    'anodisasse',
    'anodisassent',
    'anodisasses',
    'anodisassiez',
    'anodise',
    'anodisent',
    'anodiser',
    'anodisera',
    'anodiserai',
    'anodiserais',
    'anodiserait',
    'anodiseras',
    'anodiserez',
    'anodiseriez',
    'anodiserions',
    'anodiserons',
    'anodiseront',
    'anodises',
    'anodisez',
    'anodisiez',
    'anodisions',
    'anodisons',
    'anodisâmes',
    'anodisât',
    'anodisâtes',
    'anodisèrent',
    'anodisé',
    'anodisée',
    'anodisées',
    'anodisés',
    'anodonte',
    'anodontes',
    'anomal',
    'anomale',
    'anomales',
    'anomalie',
    'anomalies',
    'anomaux',
    'anomie',
    'anomies',
    'anonymat',
    'anonymats',
    'anonyme',
    'anonymement',
    'anonymes',
    'anophèle',
    'anophèles',
    'anorak',
    'anoraks',
    'anordi',
    'anordir',
    'anordira',
    'anordirai',
    'anordiraient',
    'anordirais',
    'anordirait',
    'anordiras',
    'anordirent',
    'anordirez',
    'anordiriez',
    'anordirions',
    'anordirons',
    'anordiront',
    'anordis',
    'anordissais',
    'anordissait',
    'anordissant',
    'anordisse',
    'anordissent',
    'anordisses',
    'anordissez',
    'anordissiez',
    'anordissions',
    'anordissons',
    'anordit',
    'anordîmes',
    'anordît',
    'anordîtes',
    'anorexie',
    'anorexies',
    'anorexique',
    'anorexiques',
    'anormal',
    'anormale',
    'anormalement',
    'anormales',
    'anormalité',
    'anormalités',
    'anormaux',
    'anosmie',
    'anosmies',
    'anoure',
    'anoures',
    'anoxémie',
    'anoxémies',
    'anse',
    'anses',
    'ansé',
    'ansée',
    'ansées',
    'ansérine',
    'ansérines',
    'ansés',
    'antagonique',
    'antagoniques',
    'antagonisme',
    'antagonismes',
    'antagoniste',
    'antagonistes',
    'antalgique',
    'antalgiques',
    'antan',
    'antarctique',
    'antarctiques',
    'ante',
    'antenais',
    'antenaise',
    'antenaises',
    'antenne',
    'antennes',
    'antes',
    'anthologie',
    'anthologies',
    'anthonome',
    'anthonomes',
    'anthracite',
    'anthracites',
    'anthracnose',
    'anthracnoses',
    'anthracose',
    'anthracoses',
    'anthracène',
    'anthracènes',
    'anthrax',
    'anthropoïde',
    'anthropoïdes',
    'anthrène',
    'anthrènes',
    'anthère',
    'anthères',
    'anthémis',
    'anthérozoïde',
    'anti',
    'antiamaril',
    'antiamarile',
    'antiamariles',
    'antiamarils',
    'antiatome',
    'antiatomes',
    'antiatomique',
    'antiaérien',
    'antiaérienne',
    'antiaériens',
    'antibiotique',
    'antibois',
    'antibrouillé',
    'antibruit',
    'anticasseur',
    'anticasseurs',
    'anticathode',
    'anticathodes',
    'antichambre',
    'antichambres',
    'antichar',
    'antichars',
    'antichrèse',
    'antichrèses',
    'anticipa',
    'anticipai',
    'anticipaient',
    'anticipais',
    'anticipait',
    'anticipant',
    'anticipas',
    'anticipasse',
    'anticipasses',
    'anticipation',
    'anticipe',
    'anticipent',
    'anticiper',
    'anticipera',
    'anticiperai',
    'anticiperais',
    'anticiperait',
    'anticiperas',
    'anticiperez',
    'anticiperiez',
    'anticiperons',
    'anticiperont',
    'anticipes',
    'anticipez',
    'anticipiez',
    'anticipions',
    'anticipons',
    'anticipâmes',
    'anticipât',
    'anticipâtes',
    'anticipèrent',
    'anticipé',
    'anticipée',
    'anticipées',
    'anticipés',
    'anticlinal',
    'anticlinale',
    'anticlinales',
    'anticlinaux',
    'anticlérical',
    'anticorps',
    'anticyclique',
    'anticyclonal',
    'anticyclone',
    'anticyclones',
    'antidata',
    'antidatai',
    'antidataient',
    'antidatais',
    'antidatait',
    'antidatant',
    'antidatas',
    'antidatasse',
    'antidatasses',
    'antidate',
    'antidatent',
    'antidater',
    'antidatera',
    'antidaterai',
    'antidaterais',
    'antidaterait',
    'antidateras',
    'antidaterez',
    'antidateriez',
    'antidaterons',
    'antidateront',
    'antidates',
    'antidatez',
    'antidatiez',
    'antidations',
    'antidatons',
    'antidatâmes',
    'antidatât',
    'antidatâtes',
    'antidatèrent',
    'antidaté',
    'antidatée',
    'antidatées',
    'antidatés',
    'antidopage',
    'antidopages',
    'antidoping',
    'antidopings',
    'antidote',
    'antidotes',
    'antidumping',
    'antidérapant',
    'antidétonant',
    'antienne',
    'antiennes',
    'antifasciste',
    'antigang',
    'antigel',
    'antigels',
    'antiglisse',
    'antiglisses',
    'antigène',
    'antigènes',
    'antihalo',
    'antihausse',
    'antihausses',
    'antihéros',
    'antilithique',
    'antillais',
    'antillaise',
    'antillaises',
    'antilope',
    'antilopes',
    'antimatière',
    'antimatières',
    'antimissile',
    'antimissiles',
    'antimite',
    'antimites',
    'antimoine',
    'antimoines',
    'antimoniure',
    'antimoniures',
    'antinational',
    'antinazi',
    'antinazie',
    'antinazies',
    'antinazis',
    'antinomie',
    'antinomies',
    'antinomique',
    'antinomiques',
    'antipaludéen',
    'antipape',
    'antipapes',
    'antiparasite',
    'antipathie',
    'antipathies',
    'antipathique',
    'antiphonaire',
    'antiphrase',
    'antiphrases',
    'antipode',
    'antipodes',
    'antipoison',
    'antipoisons',
    'antiquaille',
    'antiquailles',
    'antiquaire',
    'antiquaires',
    'antique',
    'antiques',
    'antiquité',
    'antiquités',
    'antirabique',
    'antirabiques',
    'antiracisme',
    'antiracismes',
    'antiraciste',
    'antiracistes',
    'antiradar',
    'antirides',
    'antirouille',
    'antirouilles',
    'antisepsie',
    'antisepsies',
    'antiseptique',
    'antisocial',
    'antisociale',
    'antisociales',
    'antisociaux',
    'antisportif',
    'antisportifs',
    'antisportive',
    'antistrophe',
    'antistrophes',
    'antisémite',
    'antisémites',
    'antithèse',
    'antithèses',
    'antithétique',
    'antitoxine',
    'antitoxines',
    'antitoxique',
    'antitoxiques',
    'antitrust',
    'antivenimeux',
    'antivol',
    'antivols',
    'antonyme',
    'antonymes',
    'antonymie',
    'antonymies',
    'antre',
    'antres',
    'antécédence',
    'antécédences',
    'antécédent',
    'antécédente',
    'antécédentes',
    'antécédents',
    'antédiluvien',
    'antéfixe',
    'antéfixes',
    'antéposa',
    'antéposai',
    'antéposaient',
    'antéposais',
    'antéposait',
    'antéposant',
    'antéposas',
    'antéposasse',
    'antéposasses',
    'antépose',
    'antéposent',
    'antéposer',
    'antéposera',
    'antéposerai',
    'antéposerais',
    'antéposerait',
    'antéposeras',
    'antéposerez',
    'antéposeriez',
    'antéposerons',
    'antéposeront',
    'antéposes',
    'antéposez',
    'antéposiez',
    'antéposions',
    'antéposons',
    'antéposâmes',
    'antéposât',
    'antéposâtes',
    'antéposèrent',
    'antéposé',
    'antéposée',
    'antéposées',
    'antéposés',
    'antérieur',
    'antérieure',
    'antérieures',
    'antérieurs',
    'antériorité',
    'antériorités',
    'antérograde',
    'antérogrades',
    'anurie',
    'anuries',
    'anus',
    'anxieuse',
    'anxieusement',
    'anxieuses',
    'anxieux',
    'anxiogène',
    'anxiogènes',
    'anxiété',
    'anxiétés',
    'anéanti',
    'anéantie',
    'anéanties',
    'anéantir',
    'anéantira',
    'anéantirai',
    'anéantirais',
    'anéantirait',
    'anéantiras',
    'anéantirent',
    'anéantirez',
    'anéantiriez',
    'anéantirions',
    'anéantirons',
    'anéantiront',
    'anéantis',
    'anéantissais',
    'anéantissait',
    'anéantissant',
    'anéantisse',
    'anéantissent',
    'anéantisses',
    'anéantissez',
    'anéantissiez',
    'anéantissons',
    'anéantit',
    'anéantîmes',
    'anéantît',
    'anéantîtes',
    'anémia',
    'anémiai',
    'anémiaient',
    'anémiais',
    'anémiait',
    'anémiant',
    'anémias',
    'anémiasse',
    'anémiassent',
    'anémiasses',
    'anémiassiez',
    'anémiassions',
    'anémie',
    'anémient',
    'anémier',
    'anémiera',
    'anémierai',
    'anémieraient',
    'anémierais',
    'anémierait',
    'anémieras',
    'anémierez',
    'anémieriez',
    'anémierions',
    'anémierons',
    'anémieront',
    'anémies',
    'anémiez',
    'anémiiez',
    'anémiions',
    'anémions',
    'anémique',
    'anémiques',
    'anémiâmes',
    'anémiât',
    'anémiâtes',
    'anémièrent',
    'anémié',
    'anémiée',
    'anémiées',
    'anémiés',
    'anémographe',
    'anémographes',
    'anémomètre',
    'anémomètres',
    'anémone',
    'anémones',
    'anémophile',
    'anémophiles',
    'anéroïde',
    'anéroïdes',
    'anévrismal',
    'anévrismale',
    'anévrismales',
    'anévrismaux',
    'anévrisme',
    'anévrismes',
    'anévrysme',
    'anévrysmes',
    'aoriste',
    'aoristes',
    'aorte',
    'aortes',
    'aortique',
    'aortiques',
    'aortite',
    'aortites',
    'août',
    'aoûta',
    'aoûtai',
    'aoûtaient',
    'aoûtais',
    'aoûtait',
    'aoûtant',
    'aoûtas',
    'aoûtasse',
    'aoûtassent',
    'aoûtasses',
    'aoûtassiez',
    'aoûtassions',
    'aoûtat',
    'aoûtats',
    'aoûte',
    'aoûtement',
    'aoûtements',
    'aoûtent',
    'aoûter',
    'aoûtera',
    'aoûterai',
    'aoûteraient',
    'aoûterais',
    'aoûterait',
    'aoûteras',
    'aoûterez',
    'aoûteriez',
    'aoûterions',
    'aoûterons',
    'aoûteront',
    'aoûtes',
    'aoûtez',
    'aoûtien',
    'aoûtienne',
    'aoûtiennes',
    'aoûtiens',
    'aoûtiez',
    'aoûtions',
    'aoûtons',
    'aoûtâmes',
    'aoûtât',
    'aoûtâtes',
    'aoûtèrent',
    'aoûté',
    'aoûtée',
    'aoûtées',
    'aoûtés',
    'apache',
    'apaches',
    'apagogie',
    'apagogies',
    'apaisa',
    'apaisai',
    'apaisaient',
    'apaisais',
    'apaisait',
    'apaisant',
    'apaisante',
    'apaisantes',
    'apaisants',
    'apaisas',
    'apaisasse',
    'apaisassent',
    'apaisasses',
    'apaisassiez',
    'apaisassions',
    'apaise',
    'apaisement',
    'apaisements',
    'apaisent',
    'apaiser',
    'apaisera',
    'apaiserai',
    'apaiseraient',
    'apaiserais',
    'apaiserait',
    'apaiseras',
    'apaiserez',
    'apaiseriez',
    'apaiserions',
    'apaiserons',
    'apaiseront',
    'apaises',
    'apaisez',
    'apaisiez',
    'apaisions',
    'apaisons',
    'apaisâmes',
    'apaisât',
    'apaisâtes',
    'apaisèrent',
    'apaisé',
    'apaisée',
    'apaisées',
    'apaisés',
    'apanage',
    'apanagea',
    'apanageai',
    'apanageaient',
    'apanageais',
    'apanageait',
    'apanageant',
    'apanageas',
    'apanageasse',
    'apanageasses',
    'apanagent',
    'apanageons',
    'apanager',
    'apanagera',
    'apanagerai',
    'apanagerais',
    'apanagerait',
    'apanageras',
    'apanagerez',
    'apanageriez',
    'apanagerions',
    'apanagerons',
    'apanageront',
    'apanages',
    'apanagez',
    'apanageâmes',
    'apanageât',
    'apanageâtes',
    'apanagiez',
    'apanagions',
    'apanagèrent',
    'apanagé',
    'apanagée',
    'apanagées',
    'apanagés',
    'apartheid',
    'apartheids',
    'aparté',
    'apartés',
    'apathie',
    'apathies',
    'apathique',
    'apathiques',
    'apatride',
    'apatrides',
    'apepsie',
    'apepsies',
    'aperception',
    'aperceptions',
    'apercevaient',
    'apercevais',
    'apercevait',
    'apercevant',
    'apercevez',
    'aperceviez',
    'apercevions',
    'apercevoir',
    'apercevons',
    'apercevra',
    'apercevrai',
    'apercevrais',
    'apercevrait',
    'apercevras',
    'apercevrez',
    'apercevriez',
    'apercevrions',
    'apercevrons',
    'apercevront',
    'aperture',
    'apertures',
    'aperçois',
    'aperçoit',
    'aperçoive',
    'aperçoivent',
    'aperçoives',
    'aperçu',
    'aperçue',
    'aperçues',
    'aperçurent',
    'aperçus',
    'aperçusse',
    'aperçussent',
    'aperçusses',
    'aperçussiez',
    'aperçussions',
    'aperçut',
    'aperçûmes',
    'aperçût',
    'aperçûtes',
    'apesanteur',
    'apesanteurs',
    'apeura',
    'apeurai',
    'apeuraient',
    'apeurais',
    'apeurait',
    'apeurant',
    'apeuras',
    'apeurasse',
    'apeurassent',
    'apeurasses',
    'apeurassiez',
    'apeurassions',
    'apeure',
    'apeurent',
    'apeurer',
    'apeurera',
    'apeurerai',
    'apeureraient',
    'apeurerais',
    'apeurerait',
    'apeureras',
    'apeurerez',
    'apeureriez',
    'apeurerions',
    'apeurerons',
    'apeureront',
    'apeures',
    'apeurez',
    'apeuriez',
    'apeurions',
    'apeurons',
    'apeurâmes',
    'apeurât',
    'apeurâtes',
    'apeurèrent',
    'apeuré',
    'apeurée',
    'apeurées',
    'apeurés',
    'apex',
    'aphasie',
    'aphasies',
    'aphasique',
    'aphasiques',
    'aphone',
    'aphones',
    'aphonie',
    'aphonies',
    'aphorisme',
    'aphorismes',
    'aphte',
    'aphtes',
    'aphteuse',
    'aphteuses',
    'aphteux',
    'aphylle',
    'aphylles',
    'aphélie',
    'aphélies',
    'aphérèse',
    'aphérèses',
    'apical',
    'apicale',
    'apicales',
    'apicaux',
    'apiculteur',
    'apiculteurs',
    'apicultrice',
    'apicultrices',
    'apiculture',
    'apicultures',
    'apiol',
    'apiols',
    'apion',
    'apions',
    'apiqua',
    'apiquage',
    'apiquages',
    'apiquai',
    'apiquaient',
    'apiquais',
    'apiquait',
    'apiquant',
    'apiquas',
    'apiquasse',
    'apiquassent',
    'apiquasses',
    'apiquassiez',
    'apiquassions',
    'apique',
    'apiquent',
    'apiquer',
    'apiquera',
    'apiquerai',
    'apiqueraient',
    'apiquerais',
    'apiquerait',
    'apiqueras',
    'apiquerez',
    'apiqueriez',
    'apiquerions',
    'apiquerons',
    'apiqueront',
    'apiques',
    'apiquez',
    'apiquiez',
    'apiquions',
    'apiquons',
    'apiquâmes',
    'apiquât',
    'apiquâtes',
    'apiquèrent',
    'apiqué',
    'apiquée',
    'apiquées',
    'apiqués',
    'apis',
    'apitoie',
    'apitoiement',
    'apitoiements',
    'apitoient',
    'apitoiera',
    'apitoierai',
    'apitoierais',
    'apitoierait',
    'apitoieras',
    'apitoierez',
    'apitoieriez',
    'apitoierions',
    'apitoierons',
    'apitoieront',
    'apitoies',
    'apitoya',
    'apitoyai',
    'apitoyaient',
    'apitoyais',
    'apitoyait',
    'apitoyant',
    'apitoyas',
    'apitoyasse',
    'apitoyassent',
    'apitoyasses',
    'apitoyassiez',
    'apitoyer',
    'apitoyez',
    'apitoyiez',
    'apitoyions',
    'apitoyons',
    'apitoyâmes',
    'apitoyât',
    'apitoyâtes',
    'apitoyèrent',
    'apitoyé',
    'apitoyée',
    'apitoyées',
    'apitoyés',
    'apiéceur',
    'apiéceurs',
    'apiéceuse',
    'apiéceuses',
    'aplani',
    'aplanie',
    'aplanies',
    'aplanir',
    'aplanira',
    'aplanirai',
    'aplaniraient',
    'aplanirais',
    'aplanirait',
    'aplaniras',
    'aplanirent',
    'aplanirez',
    'aplaniriez',
    'aplanirions',
    'aplanirons',
    'aplaniront',
    'aplanis',
    'aplanissais',
    'aplanissait',
    'aplanissant',
    'aplanisse',
    'aplanissent',
    'aplanisses',
    'aplanissez',
    'aplanissiez',
    'aplanissions',
    'aplanissons',
    'aplanit',
    'aplanétique',
    'aplanétiques',
    'aplanîmes',
    'aplanît',
    'aplanîtes',
    'aplasie',
    'aplasies',
    'aplat',
    'aplati',
    'aplatie',
    'aplaties',
    'aplatir',
    'aplatira',
    'aplatirai',
    'aplatiraient',
    'aplatirais',
    'aplatirait',
    'aplatiras',
    'aplatirent',
    'aplatirez',
    'aplatiriez',
    'aplatirions',
    'aplatirons',
    'aplatiront',
    'aplatis',
    'aplatissage',
    'aplatissages',
    'aplatissais',
    'aplatissait',
    'aplatissant',
    'aplatisse',
    'aplatissent',
    'aplatisses',
    'aplatisseur',
    'aplatisseurs',
    'aplatissez',
    'aplatissiez',
    'aplatissions',
    'aplatissoir',
    'aplatissoire',
    'aplatissoirs',
    'aplatissons',
    'aplatit',
    'aplats',
    'aplatîmes',
    'aplatît',
    'aplatîtes',
    'aplomb',
    'aplombs',
    'apnée',
    'apnées',
    'apoastre',
    'apoastres',
    'apocalypse',
    'apocalypses',
    'apocope',
    'apocopes',
    'apocryphe',
    'apocryphes',
    'apode',
    'apodes',
    'apodictique',
    'apodictiques',
    'apogamie',
    'apogamies',
    'apogée',
    'apogées',
    'apolitique',
    'apolitiques',
    'apolitisme',
    'apolitismes',
    'apollinien',
    'apollinienne',
    'apolliniens',
    'apollon',
    'apollons',
    'apologie',
    'apologies',
    'apologiste',
    'apologistes',
    'apologue',
    'apologues',
    'apologétique',
    'apomorphine',
    'apomorphines',
    'aponévrose',
    'aponévroses',
    'apophonie',
    'apophonies',
    'apophtegme',
    'apophtegmes',
    'apophysaire',
    'apophysaires',
    'apophyse',
    'apophyses',
    'apoplectique',
    'apoplexie',
    'apoplexies',
    'aporie',
    'apories',
    'aporétique',
    'aporétiques',
    'aposiopèse',
    'aposiopèses',
    'aposta',
    'apostai',
    'apostaient',
    'apostais',
    'apostait',
    'apostant',
    'apostas',
    'apostasia',
    'apostasiai',
    'apostasiais',
    'apostasiait',
    'apostasiant',
    'apostasias',
    'apostasiasse',
    'apostasie',
    'apostasient',
    'apostasier',
    'apostasiera',
    'apostasierai',
    'apostasieras',
    'apostasierez',
    'apostasies',
    'apostasiez',
    'apostasiiez',
    'apostasiions',
    'apostasions',
    'apostasiâmes',
    'apostasiât',
    'apostasiâtes',
    'apostasié',
    'apostasse',
    'apostassent',
    'apostasses',
    'apostassiez',
    'apostassions',
    'apostat',
    'apostate',
    'apostates',
    'apostats',
    'aposte',
    'apostent',
    'aposter',
    'apostera',
    'aposterai',
    'aposteraient',
    'aposterais',
    'aposterait',
    'aposteras',
    'aposterez',
    'aposteriez',
    'aposterions',
    'aposterons',
    'aposteront',
    'apostes',
    'apostez',
    'apostiez',
    'apostilla',
    'apostillai',
    'apostillais',
    'apostillait',
    'apostillant',
    'apostillas',
    'apostillasse',
    'apostille',
    'apostillent',
    'apostiller',
    'apostillera',
    'apostillerai',
    'apostilleras',
    'apostillerez',
    'apostilles',
    'apostillez',
    'apostilliez',
    'apostillions',
    'apostillons',
    'apostillâmes',
    'apostillât',
    'apostillâtes',
    'apostillé',
    'apostillée',
    'apostillées',
    'apostillés',
    'apostions',
    'apostolat',
    'apostolats',
    'apostolique',
    'apostoliques',
    'apostons',
    'apostropha',
    'apostrophai',
    'apostrophais',
    'apostrophait',
    'apostrophant',
    'apostrophas',
    'apostrophe',
    'apostrophent',
    'apostropher',
    'apostrophera',
    'apostrophes',
    'apostrophez',
    'apostrophiez',
    'apostrophons',
    'apostrophât',
    'apostrophé',
    'apostrophée',
    'apostrophées',
    'apostrophés',
    'apostâmes',
    'apostât',
    'apostâtes',
    'apostèrent',
    'aposté',
    'apostée',
    'apostées',
    'apostés',
    'apothicaire',
    'apothicaires',
    'apothème',
    'apothèmes',
    'apothéose',
    'apothéoses',
    'appaira',
    'appairai',
    'appairaient',
    'appairais',
    'appairait',
    'appairant',
    'appairas',
    'appairasse',
    'appairassent',
    'appairasses',
    'appairassiez',
    'appaire',
    'appairent',
    'appairer',
    'appairera',
    'appairerai',
    'appairerais',
    'appairerait',
    'appaireras',
    'appairerez',
    'appaireriez',
    'appairerions',
    'appairerons',
    'appaireront',
    'appaires',
    'appairez',
    'appairiez',
    'appairions',
    'appairons',
    'appairâmes',
    'appairât',
    'appairâtes',
    'appairèrent',
    'appairé',
    'appairée',
    'appairées',
    'appairés',
    'appalachien',
    'appalachiens',
    'apparais',
    'apparaissais',
    'apparaissait',
    'apparaissant',
    'apparaisse',
    'apparaissent',
    'apparaisses',
    'apparaissez',
    'apparaissiez',
    'apparaissons',
    'apparat',
    'apparats',
    'apparaux',
    'apparaît',
    'apparaîtra',
    'apparaîtrai',
    'apparaîtrais',
    'apparaîtrait',
    'apparaîtras',
    'apparaître',
    'apparaîtrez',
    'apparaîtriez',
    'apparaîtrons',
    'apparaîtront',
    'appareil',
    'appareilla',
    'appareillade',
    'appareillage',
    'appareillai',
    'appareillais',
    'appareillait',
    'appareillant',
    'appareillas',
    'appareille',
    'appareillent',
    'appareiller',
    'appareillera',
    'appareilles',
    'appareilleur',
    'appareillez',
    'appareilliez',
    'appareillons',
    'appareillât',
    'appareillé',
    'appareillée',
    'appareillées',
    'appareillés',
    'appareils',
    'apparemment',
    'apparence',
    'apparences',
    'apparent',
    'apparenta',
    'apparentais',
    'apparentait',
    'apparentant',
    'apparente',
    'apparentent',
    'apparenter',
    'apparentera',
    'apparenterai',
    'apparenteras',
    'apparenterez',
    'apparentes',
    'apparentez',
    'apparentiez',
    'apparentions',
    'apparentons',
    'apparents',
    'apparentâmes',
    'apparentâtes',
    'apparenté',
    'apparentée',
    'apparentées',
    'apparentés',
    'apparia',
    'appariai',
    'appariaient',
    'appariais',
    'appariait',
    'appariant',
    'apparias',
    'appariasse',
    'appariassent',
    'appariasses',
    'appariassiez',
    'apparie',
    'appariement',
    'appariements',
    'apparient',
    'apparier',
    'appariera',
    'apparierai',
    'apparierais',
    'apparierait',
    'apparieras',
    'apparierez',
    'apparieriez',
    'apparierions',
    'apparierons',
    'apparieront',
    'apparies',
    'appariez',
    'appariiez',
    'appariions',
    'apparions',
    'appariteur',
    'appariteurs',
    'apparition',
    'apparitions',
    'appariâmes',
    'appariât',
    'appariâtes',
    'apparièrent',
    'apparié',
    'appariée',
    'appariées',
    'appariés',
    'appartement',
    'appartements',
    'appartenais',
    'appartenait',
    'appartenance',
    'appartenant',
    'appartenez',
    'apparteniez',
    'appartenions',
    'appartenir',
    'appartenons',
    'appartenu',
    'appartenue',
    'appartenues',
    'appartenus',
    'appartiendra',
    'appartienne',
    'appartiennes',
    'appartiens',
    'appartient',
    'appartinrent',
    'appartins',
    'appartinsse',
    'appartinsses',
    'appartint',
    'appartînmes',
    'appartînt',
    'appartîntes',
    'apparu',
    'apparue',
    'apparues',
    'apparurent',
    'apparus',
    'apparusse',
    'apparussent',
    'apparusses',
    'apparussiez',
    'apparussions',
    'apparut',
    'apparûmes',
    'apparût',
    'apparûtes',
    'appas',
    'appassionato',
    'appauvri',
    'appauvrie',
    'appauvries',
    'appauvrir',
    'appauvrira',
    'appauvrirai',
    'appauvrirais',
    'appauvrirait',
    'appauvriras',
    'appauvrirent',
    'appauvrirez',
    'appauvririez',
    'appauvrirons',
    'appauvriront',
    'appauvris',
    'appauvrisse',
    'appauvrisses',
    'appauvrissez',
    'appauvrit',
    'appauvrîmes',
    'appauvrît',
    'appauvrîtes',
    'appeau',
    'appeaux',
    'appel',
    'appela',
    'appelai',
    'appelaient',
    'appelais',
    'appelait',
    'appelant',
    'appelante',
    'appelantes',
    'appelants',
    'appelas',
    'appelasse',
    'appelassent',
    'appelasses',
    'appelassiez',
    'appelassions',
    'appeler',
    'appelez',
    'appeliez',
    'appelions',
    'appellatif',
    'appellatifs',
    'appellation',
    'appellations',
    'appellative',
    'appellatives',
    'appelle',
    'appellent',
    'appellera',
    'appellerai',
    'appellerais',
    'appellerait',
    'appelleras',
    'appellerez',
    'appelleriez',
    'appellerions',
    'appellerons',
    'appelleront',
    'appelles',
    'appelons',
    'appels',
    'appelâmes',
    'appelât',
    'appelâtes',
    'appelèrent',
    'appelé',
    'appelée',
    'appelées',
    'appelés',
    'appendice',
    'appendices',
    'appendicite',
    'appendicites',
    'appendre',
    'appentis',
    'appert',
    'appesanti',
    'appesantie',
    'appesanties',
    'appesantir',
    'appesantira',
    'appesantirai',
    'appesantiras',
    'appesantirez',
    'appesantis',
    'appesantisse',
    'appesantit',
    'appesantîmes',
    'appesantît',
    'appesantîtes',
    'applaudi',
    'applaudie',
    'applaudies',
    'applaudir',
    'applaudira',
    'applaudirai',
    'applaudirais',
    'applaudirait',
    'applaudiras',
    'applaudirent',
    'applaudirez',
    'applaudiriez',
    'applaudirons',
    'applaudiront',
    'applaudis',
    'applaudisse',
    'applaudisses',
    'applaudissez',
    'applaudit',
    'applaudîmes',
    'applaudît',
    'applaudîtes',
    'applicable',
    'applicables',
    'applicage',
    'applicages',
    'applicateur',
    'applicateurs',
    'applicatif',
    'applicatifs',
    'application',
    'applications',
    'applicatrice',
    'appliqua',
    'appliquai',
    'appliquaient',
    'appliquais',
    'appliquait',
    'appliquant',
    'appliquas',
    'appliquasse',
    'appliquasses',
    'applique',
    'appliquent',
    'appliquer',
    'appliquera',
    'appliquerai',
    'appliquerais',
    'appliquerait',
    'appliqueras',
    'appliquerez',
    'appliqueriez',
    'appliquerons',
    'appliqueront',
    'appliques',
    'appliquez',
    'appliquiez',
    'appliquions',
    'appliquons',
    'appliquâmes',
    'appliquât',
    'appliquâtes',
    'appliquèrent',
    'appliqué',
    'appliquée',
    'appliquées',
    'appliqués',
    'appoggiature',
    'appoint',
    'appointa',
    'appointage',
    'appointages',
    'appointai',
    'appointaient',
    'appointais',
    'appointait',
    'appointant',
    'appointas',
    'appointasse',
    'appointasses',
    'appointe',
    'appointent',
    'appointer',
    'appointera',
    'appointerai',
    'appointerais',
    'appointerait',
    'appointeras',
    'appointerez',
    'appointeriez',
    'appointerons',
    'appointeront',
    'appointes',
    'appointez',
    'appointi',
    'appointie',
    'appointies',
    'appointiez',
    'appointions',
    'appointir',
    'appointira',
    'appointirai',
    'appointirais',
    'appointirait',
    'appointiras',
    'appointirent',
    'appointirez',
    'appointiriez',
    'appointirons',
    'appointiront',
    'appointis',
    'appointisse',
    'appointisses',
    'appointissez',
    'appointit',
    'appointons',
    'appoints',
    'appointâmes',
    'appointât',
    'appointâtes',
    'appointèrent',
    'appointé',
    'appointée',
    'appointées',
    'appointés',
    'appointîmes',
    'appointît',
    'appointîtes',
    'apponta',
    'appontage',
    'appontages',
    'appontai',
    'appontaient',
    'appontais',
    'appontait',
    'appontant',
    'appontas',
    'appontasse',
    'appontassent',
    'appontasses',
    'appontassiez',
    'apponte',
    'appontement',
    'appontements',
    'appontent',
    'apponter',
    'appontera',
    'apponterai',
    'apponterais',
    'apponterait',
    'apponteras',
    'apponterez',
    'apponteriez',
    'apponterions',
    'apponterons',
    'apponteront',
    'appontes',
    'apponteur',
    'apponteurs',
    'appontez',
    'appontiez',
    'appontions',
    'appontons',
    'appontâmes',
    'appontât',
    'appontâtes',
    'appontèrent',
    'apponté',
    'apport',
    'apporta',
    'apportai',
    'apportaient',
    'apportais',
    'apportait',
    'apportant',
    'apportas',
    'apportasse',
    'apportassent',
    'apportasses',
    'apportassiez',
    'apporte',
    'apportent',
    'apporter',
    'apportera',
    'apporterai',
    'apporterais',
    'apporterait',
    'apporteras',
    'apporterez',
    'apporteriez',
    'apporterions',
    'apporterons',
    'apporteront',
    'apportes',
    'apporteur',
    'apporteurs',
    'apportez',
    'apportiez',
    'apportions',
    'apportons',
    'apports',
    'apportâmes',
    'apportât',
    'apportâtes',
    'apportèrent',
    'apporté',
    'apportée',
    'apportées',
    'apportés',
    'apposa',
    'apposai',
    'apposaient',
    'apposais',
    'apposait',
    'apposant',
    'apposas',
    'apposasse',
    'apposassent',
    'apposasses',
    'apposassiez',
    'apposassions',
    'appose',
    'apposent',
    'apposer',
    'apposera',
    'apposerai',
    'apposeraient',
    'apposerais',
    'apposerait',
    'apposeras',
    'apposerez',
    'apposeriez',
    'apposerions',
    'apposerons',
    'apposeront',
    'apposes',
    'apposez',
    'apposiez',
    'apposions',
    'apposition',
    'appositions',
    'apposons',
    'apposâmes',
    'apposât',
    'apposâtes',
    'apposèrent',
    'apposé',
    'apposée',
    'apposées',
    'apposés',
    'apprenaient',
    'apprenais',
    'apprenait',
    'apprenant',
    'apprenante',
    'apprenantes',
    'apprenants',
    'apprend',
    'apprendra',
    'apprendrai',
    'apprendrais',
    'apprendrait',
    'apprendras',
    'apprendre',
    'apprendrez',
    'apprendriez',
    'apprendrions',
    'apprendrons',
    'apprendront',
    'apprends',
    'apprenez',
    'appreniez',
    'apprenions',
    'apprenne',
    'apprennent',
    'apprennes',
    'apprenons',
    'apprenti',
    'apprentie',
    'apprenties',
    'apprentis',
    'apprirent',
    'appris',
    'apprise',
    'apprises',
    'apprisse',
    'apprissent',
    'apprisses',
    'apprissiez',
    'apprissions',
    'apprit',
    'apprivoisa',
    'apprivoisai',
    'apprivoisais',
    'apprivoisait',
    'apprivoisant',
    'apprivoisas',
    'apprivoise',
    'apprivoisent',
    'apprivoiser',
    'apprivoisera',
    'apprivoises',
    'apprivoiseur',
    'apprivoisez',
    'apprivoisiez',
    'apprivoisons',
    'apprivoisât',
    'apprivoisé',
    'apprivoisée',
    'apprivoisées',
    'apprivoisés',
    'approbateur',
    'approbateurs',
    'approbatif',
    'approbatifs',
    'approbation',
    'approbations',
    'approbative',
    'approbatives',
    'approbatrice',
    'approcha',
    'approchable',
    'approchables',
    'approchai',
    'approchaient',
    'approchais',
    'approchait',
    'approchant',
    'approchante',
    'approchantes',
    'approchants',
    'approchas',
    'approchasse',
    'approchasses',
    'approche',
    'approchent',
    'approcher',
    'approchera',
    'approcherai',
    'approcherais',
    'approcherait',
    'approcheras',
    'approcherez',
    'approcheriez',
    'approcherons',
    'approcheront',
    'approches',
    'approchez',
    'approchiez',
    'approchions',
    'approchons',
    'approchâmes',
    'approchât',
    'approchâtes',
    'approchèrent',
    'approché',
    'approchée',
    'approchées',
    'approchés',
    'approfondi',
    'approfondie',
    'approfondies',
    'approfondir',
    'approfondira',
    'approfondis',
    'approfondit',
    'approfondît',
    'appropria',
    'appropriai',
    'appropriais',
    'appropriait',
    'appropriant',
    'approprias',
    'appropriasse',
    'approprie',
    'approprient',
    'approprier',
    'appropriera',
    'approprierai',
    'approprieras',
    'approprierez',
    'appropries',
    'appropriez',
    'appropriiez',
    'appropriions',
    'approprions',
    'appropriâmes',
    'appropriât',
    'appropriâtes',
    'approprié',
    'appropriée',
    'appropriées',
    'appropriés',
    'approuva',
    'approuvable',
    'approuvables',
    'approuvai',
    'approuvaient',
    'approuvais',
    'approuvait',
    'approuvant',
    'approuvas',
    'approuvasse',
    'approuvasses',
    'approuve',
    'approuvent',
    'approuver',
    'approuvera',
    'approuverai',
    'approuverais',
    'approuverait',
    'approuveras',
    'approuverez',
    'approuveriez',
    'approuverons',
    'approuveront',
    'approuves',
    'approuvez',
    'approuviez',
    'approuvions',
    'approuvons',
    'approuvâmes',
    'approuvât',
    'approuvâtes',
    'approuvèrent',
    'approuvé',
    'approuvée',
    'approuvées',
    'approuvés',
    'approximatif',
    'apprécia',
    'appréciable',
    'appréciables',
    'appréciai',
    'appréciaient',
    'appréciais',
    'appréciait',
    'appréciant',
    'apprécias',
    'appréciasse',
    'appréciasses',
    'appréciateur',
    'appréciatif',
    'appréciatifs',
    'appréciation',
    'appréciative',
    'apprécie',
    'apprécient',
    'apprécier',
    'appréciera',
    'apprécierai',
    'apprécierais',
    'apprécierait',
    'apprécieras',
    'apprécierez',
    'apprécieriez',
    'apprécierons',
    'apprécieront',
    'apprécies',
    'appréciez',
    'appréciiez',
    'appréciions',
    'apprécions',
    'appréciâmes',
    'appréciât',
    'appréciâtes',
    'apprécièrent',
    'apprécié',
    'appréciée',
    'appréciées',
    'appréciés',
    'appréhenda',
    'appréhendai',
    'appréhendais',
    'appréhendait',
    'appréhendant',
    'appréhendas',
    'appréhende',
    'appréhendent',
    'appréhender',
    'appréhendera',
    'appréhendes',
    'appréhendez',
    'appréhendiez',
    'appréhendons',
    'appréhendât',
    'appréhendé',
    'appréhendée',
    'appréhendées',
    'appréhendés',
    'appréhensif',
    'appréhensifs',
    'appréhension',
    'appréhensive',
    'apprêt',
    'apprêta',
    'apprêtage',
    'apprêtages',
    'apprêtai',
    'apprêtaient',
    'apprêtais',
    'apprêtait',
    'apprêtant',
    'apprêtas',
    'apprêtasse',
    'apprêtassent',
    'apprêtasses',
    'apprêtassiez',
    'apprête',
    'apprêtent',
    'apprêter',
    'apprêtera',
    'apprêterai',
    'apprêterais',
    'apprêterait',
    'apprêteras',
    'apprêterez',
    'apprêteriez',
    'apprêterions',
    'apprêterons',
    'apprêteront',
    'apprêtes',
    'apprêteur',
    'apprêteurs',
    'apprêteuse',
    'apprêteuses',
    'apprêtez',
    'apprêtiez',
    'apprêtions',
    'apprêtons',
    'apprêts',
    'apprêtâmes',
    'apprêtât',
    'apprêtâtes',
    'apprêtèrent',
    'apprêté',
    'apprêtée',
    'apprêtées',
    'apprêtés',
    'apprîmes',
    'apprît',
    'apprîtes',
    'appui',
    'appuie',
    'appuient',
    'appuiera',
    'appuierai',
    'appuieraient',
    'appuierais',
    'appuierait',
    'appuieras',
    'appuierez',
    'appuieriez',
    'appuierions',
    'appuierons',
    'appuieront',
    'appuies',
    'appuis',
    'appuya',
    'appuyai',
    'appuyaient',
    'appuyais',
    'appuyait',
    'appuyant',
    'appuyas',
    'appuyasse',
    'appuyassent',
    'appuyasses',
    'appuyassiez',
    'appuyassions',
    'appuyer',
    'appuyez',
    'appuyiez',
    'appuyions',
    'appuyons',
    'appuyâmes',
    'appuyât',
    'appuyâtes',
    'appuyèrent',
    'appuyé',
    'appuyée',
    'appuyées',
    'appuyés',
    'appât',
    'appâta',
    'appâtai',
    'appâtaient',
    'appâtais',
    'appâtait',
    'appâtant',
    'appâtas',
    'appâtasse',
    'appâtassent',
    'appâtasses',
    'appâtassiez',
    'appâtassions',
    'appâte',
    'appâtent',
    'appâter',
    'appâtera',
    'appâterai',
    'appâteraient',
    'appâterais',
    'appâterait',
    'appâteras',
    'appâterez',
    'appâteriez',
    'appâterions',
    'appâterons',
    'appâteront',
    'appâtes',
    'appâtez',
    'appâtiez',
    'appâtions',
    'appâtons',
    'appâts',
    'appâtâmes',
    'appâtât',
    'appâtâtes',
    'appâtèrent',
    'appâté',
    'appâtée',
    'appâtées',
    'appâtés',
    'appète',
    'appètent',
    'appètes',
    'appéta',
    'appétai',
    'appétaient',
    'appétais',
    'appétait',
    'appétant',
    'appétas',
    'appétasse',
    'appétassent',
    'appétasses',
    'appétassiez',
    'appétassions',
    'appétence',
    'appétences',
    'appéter',
    'appétera',
    'appéterai',
    'appéteraient',
    'appéterais',
    'appéterait',
    'appéteras',
    'appéterez',
    'appéteriez',
    'appéterions',
    'appéterons',
    'appéteront',
    'appétez',
    'appétiez',
    'appétions',
    'appétissant',
    'appétissante',
    'appétissants',
    'appétit',
    'appétits',
    'appétons',
    'appétâmes',
    'appétât',
    'appétâtes',
    'appétèrent',
    'appété',
    'appétée',
    'appétées',
    'appétés',
    'apragmatisme',
    'apraxie',
    'apraxies',
    'apriorique',
    'aprioriques',
    'apriorisme',
    'apriorismes',
    'aprioriste',
    'aprioristes',
    'après',
    'apside',
    'apsides',
    'apte',
    'aptes',
    'aptitude',
    'aptitudes',
    'aptère',
    'aptères',
    'aptéryx',
    'apura',
    'apurai',
    'apuraient',
    'apurais',
    'apurait',
    'apurant',
    'apuras',
    'apurasse',
    'apurassent',
    'apurasses',
    'apurassiez',
    'apurassions',
    'apure',
    'apurement',
    'apurements',
    'apurent',
    'apurer',
    'apurera',
    'apurerai',
    'apureraient',
    'apurerais',
    'apurerait',
    'apureras',
    'apurerez',
    'apureriez',
    'apurerions',
    'apurerons',
    'apureront',
    'apures',
    'apurez',
    'apuriez',
    'apurions',
    'apurons',
    'apurâmes',
    'apurât',
    'apurâtes',
    'apurèrent',
    'apuré',
    'apurée',
    'apurées',
    'apurés',
    'apériodique',
    'apériteur',
    'apériteurs',
    'apéritif',
    'apéritifs',
    'apéritive',
    'apéritives',
    'apétale',
    'apétales',
    'apôtre',
    'apôtres',
    'aquaculture',
    'aquacultures',
    'aquafortiste',
    'aquaplane',
    'aquaplanes',
    'aquarelle',
    'aquarelles',
    'aquarelliste',
    'aquarium',
    'aquariums',
    'aquatinte',
    'aquatintes',
    'aquatique',
    'aquatiques',
    'aqueduc',
    'aqueducs',
    'aqueuse',
    'aqueuses',
    'aqueux',
    'aquicole',
    'aquicoles',
    'aquiculteur',
    'aquiculteurs',
    'aquiculture',
    'aquicultures',
    'aquilin',
    'aquilins',
    'aquilon',
    'aquilons',
    'arabe',
    'arabes',
    'arabesque',
    'arabesques',
    'arabica',
    'arabicas',
    'arabique',
    'arabiques',
    'arabisa',
    'arabisai',
    'arabisaient',
    'arabisais',
    'arabisait',
    'arabisant',
    'arabisante',
    'arabisantes',
    'arabisants',
    'arabisas',
    'arabisasse',
    'arabisassent',
    'arabisasses',
    'arabisassiez',
    'arabisation',
    'arabisations',
    'arabise',
    'arabisent',
    'arabiser',
    'arabisera',
    'arabiserai',
    'arabiserais',
    'arabiserait',
    'arabiseras',
    'arabiserez',
    'arabiseriez',
    'arabiserions',
    'arabiserons',
    'arabiseront',
    'arabises',
    'arabisez',
    'arabisiez',
    'arabisions',
    'arabisons',
    'arabisâmes',
    'arabisât',
    'arabisâtes',
    'arabisèrent',
    'arabisé',
    'arabisée',
    'arabisées',
    'arabisés',
    'arable',
    'arables',
    'arabophone',
    'arabophones',
    'arachide',
    'arachides',
    'arachnoïde',
    'arachnoïdes',
    'arachnéen',
    'arachnéenne',
    'arachnéennes',
    'arachnéens',
    'aragonite',
    'aragonites',
    'araignée',
    'araignées',
    'araire',
    'araires',
    'araldite',
    'aramon',
    'aramons',
    'araméen',
    'araméenne',
    'araméennes',
    'araméens',
    'arantèle',
    'arantèles',
    'aranéide',
    'aranéides',
    'aras',
    'arasa',
    'arasai',
    'arasaient',
    'arasais',
    'arasait',
    'arasant',
    'arasas',
    'arasasse',
    'arasassent',
    'arasasses',
    'arasassiez',
    'arasassions',
    'arase',
    'arasement',
    'arasements',
    'arasent',
    'araser',
    'arasera',
    'araserai',
    'araseraient',
    'araserais',
    'araserait',
    'araseras',
    'araserez',
    'araseriez',
    'araserions',
    'araserons',
    'araseront',
    'arases',
    'arasez',
    'arasiez',
    'arasions',
    'arasons',
    'arasâmes',
    'arasât',
    'arasâtes',
    'arasèrent',
    'arasé',
    'arasée',
    'arasées',
    'arasés',
    'aratoire',
    'aratoires',
    'araucaria',
    'araucarias',
    'arbalète',
    'arbalètes',
    'arbalétrier',
    'arbalétriers',
    'arbalétrière',
    'arbitra',
    'arbitrage',
    'arbitrages',
    'arbitragiste',
    'arbitrai',
    'arbitraient',
    'arbitraire',
    'arbitraires',
    'arbitrais',
    'arbitrait',
    'arbitral',
    'arbitrale',
    'arbitrales',
    'arbitrant',
    'arbitras',
    'arbitrasse',
    'arbitrassent',
    'arbitrasses',
    'arbitrassiez',
    'arbitraux',
    'arbitre',
    'arbitrent',
    'arbitrer',
    'arbitrera',
    'arbitrerai',
    'arbitrerais',
    'arbitrerait',
    'arbitreras',
    'arbitrerez',
    'arbitreriez',
    'arbitrerions',
    'arbitrerons',
    'arbitreront',
    'arbitres',
    'arbitrez',
    'arbitriez',
    'arbitrions',
    'arbitrons',
    'arbitrâmes',
    'arbitrât',
    'arbitrâtes',
    'arbitrèrent',
    'arbitré',
    'arbitrée',
    'arbitrées',
    'arbitrés',
    'arbora',
    'arborai',
    'arboraient',
    'arborais',
    'arborait',
    'arborant',
    'arboras',
    'arborasse',
    'arborassent',
    'arborasses',
    'arborassiez',
    'arborassions',
    'arbore',
    'arborent',
    'arborer',
    'arborera',
    'arborerai',
    'arboreraient',
    'arborerais',
    'arborerait',
    'arboreras',
    'arborerez',
    'arboreriez',
    'arborerions',
    'arborerons',
    'arboreront',
    'arbores',
    'arborescence',
    'arborescent',
    'arborescente',
    'arborescents',
    'arboretum',
    'arboretums',
    'arborez',
    'arboricole',
    'arboricoles',
    'arboriez',
    'arborions',
    'arborisa',
    'arborisai',
    'arborisaient',
    'arborisais',
    'arborisait',
    'arborisant',
    'arborisas',
    'arborisasse',
    'arborisasses',
    'arborisation',
    'arborise',
    'arborisent',
    'arboriser',
    'arborisera',
    'arboriserai',
    'arboriserais',
    'arboriserait',
    'arboriseras',
    'arboriserez',
    'arboriseriez',
    'arboriserons',
    'arboriseront',
    'arborises',
    'arborisez',
    'arborisiez',
    'arborisions',
    'arborisons',
    'arborisâmes',
    'arborisât',
    'arborisâtes',
    'arborisèrent',
    'arborisé',
    'arborons',
    'arborâmes',
    'arborât',
    'arborâtes',
    'arborèrent',
    'arboré',
    'arborée',
    'arborées',
    'arborés',
    'arbouse',
    'arbouses',
    'arbousier',
    'arbousiers',
    'arbre',
    'arbres',
    'arbrisseau',
    'arbrisseaux',
    'arbuste',
    'arbustes',
    'arbustif',
    'arbustifs',
    'arbustive',
    'arbustives',
    'arcade',
    'arcades',
    'arcane',
    'arcanes',
    'arcanson',
    'arcansons',
    'arcasse',
    'arcasses',
    'arcature',
    'arcatures',
    'arceau',
    'arceaux',
    'archal',
    'archange',
    'archanges',
    'archaïque',
    'archaïques',
    'archaïsa',
    'archaïsai',
    'archaïsaient',
    'archaïsais',
    'archaïsait',
    'archaïsant',
    'archaïsante',
    'archaïsantes',
    'archaïsants',
    'archaïsas',
    'archaïsasse',
    'archaïsasses',
    'archaïse',
    'archaïsent',
    'archaïser',
    'archaïsera',
    'archaïserai',
    'archaïserais',
    'archaïserait',
    'archaïseras',
    'archaïserez',
    'archaïseriez',
    'archaïserons',
    'archaïseront',
    'archaïses',
    'archaïsez',
    'archaïsiez',
    'archaïsions',
    'archaïsme',
    'archaïsmes',
    'archaïsons',
    'archaïsâmes',
    'archaïsât',
    'archaïsâtes',
    'archaïsèrent',
    'archaïsé',
    'arche',
    'archelle',
    'archelles',
    'archer',
    'archerie',
    'archeries',
    'archers',
    'arches',
    'archet',
    'archets',
    'archevêché',
    'archevêchés',
    'archevêque',
    'archevêques',
    'archiatre',
    'archiatres',
    'archicube',
    'archicubes',
    'archidiacre',
    'archidiacres',
    'archiduc',
    'archiducs',
    'archipel',
    'archipels',
    'archiphonème',
    'archiprêtre',
    'archiprêtres',
    'architecte',
    'architectes',
    'architectura',
    'architecture',
    'architecturé',
    'architrave',
    'architraves',
    'archiva',
    'archivage',
    'archivages',
    'archivai',
    'archivaient',
    'archivais',
    'archivait',
    'archivant',
    'archivas',
    'archivasse',
    'archivassent',
    'archivasses',
    'archivassiez',
    'archive',
    'archivent',
    'archiver',
    'archivera',
    'archiverai',
    'archiverais',
    'archiverait',
    'archiveras',
    'archiverez',
    'archiveriez',
    'archiverions',
    'archiverons',
    'archiveront',
    'archives',
    'archivez',
    'archiviez',
    'archivions',
    'archiviste',
    'archivistes',
    'archivolte',
    'archivoltes',
    'archivons',
    'archivâmes',
    'archivât',
    'archivâtes',
    'archivèrent',
    'archivé',
    'archivée',
    'archivées',
    'archivés',
    'archonte',
    'archontes',
    'archère',
    'archères',
    'archéen',
    'archéenne',
    'archéennes',
    'archéens',
    'archégone',
    'archégones',
    'archéologie',
    'archéologies',
    'archéologue',
    'archéologues',
    'archéoptéryx',
    'archétype',
    'archétypes',
    'arcs',
    'arctique',
    'arctiques',
    'arcure',
    'arcures',
    'ardemment',
    'ardent',
    'ardente',
    'ardentes',
    'ardents',
    'ardeur',
    'ardeurs',
    'ardillon',
    'ardillons',
    'ardoisa',
    'ardoisai',
    'ardoisaient',
    'ardoisais',
    'ardoisait',
    'ardoisant',
    'ardoisas',
    'ardoisasse',
    'ardoisassent',
    'ardoisasses',
    'ardoisassiez',
    'ardoise',
    'ardoisent',
    'ardoiser',
    'ardoisera',
    'ardoiserai',
    'ardoiserais',
    'ardoiserait',
    'ardoiseras',
    'ardoiserez',
    'ardoiseriez',
    'ardoiserions',
    'ardoiserons',
    'ardoiseront',
    'ardoises',
    'ardoisez',
    'ardoisier',
    'ardoisiers',
    'ardoisiez',
    'ardoisions',
    'ardoisière',
    'ardoisières',
    'ardoisons',
    'ardoisâmes',
    'ardoisât',
    'ardoisâtes',
    'ardoisèrent',
    'ardoisé',
    'ardoisée',
    'ardoisées',
    'ardoisés',
    'ardu',
    'ardue',
    'ardues',
    'ardus',
    'arec',
    'arecs',
    'areligieuse',
    'areligieuses',
    'areligieux',
    'ares',
    'argas',
    'argent',
    'argenta',
    'argentai',
    'argentaient',
    'argentais',
    'argentait',
    'argentan',
    'argentans',
    'argentant',
    'argentas',
    'argentasse',
    'argentassent',
    'argentasses',
    'argentassiez',
    'argente',
    'argentent',
    'argenter',
    'argentera',
    'argenterai',
    'argenterais',
    'argenterait',
    'argenteras',
    'argenterez',
    'argenterie',
    'argenteries',
    'argenteriez',
    'argenterions',
    'argenterons',
    'argenteront',
    'argentes',
    'argenteur',
    'argenteurs',
    'argentez',
    'argentier',
    'argentiers',
    'argentiez',
    'argentifère',
    'argentifères',
    'argentin',
    'argentine',
    'argentines',
    'argentins',
    'argentions',
    'argentique',
    'argentiques',
    'argentite',
    'argentites',
    'argentons',
    'argents',
    'argenture',
    'argentures',
    'argentâmes',
    'argentât',
    'argentâtes',
    'argentèrent',
    'argenté',
    'argentée',
    'argentées',
    'argentés',
    'argilacé',
    'argilacée',
    'argilacées',
    'argilacés',
    'argile',
    'argiles',
    'argileuse',
    'argileuses',
    'argileux',
    'arginine',
    'arginines',
    'argon',
    'argonaute',
    'argonautes',
    'argons',
    'argortisé',
    'argot',
    'argotique',
    'argotiques',
    'argotisa',
    'argotisai',
    'argotisaient',
    'argotisais',
    'argotisait',
    'argotisant',
    'argotisas',
    'argotisasse',
    'argotisasses',
    'argotise',
    'argotisent',
    'argotiser',
    'argotisera',
    'argotiserai',
    'argotiserais',
    'argotiserait',
    'argotiseras',
    'argotiserez',
    'argotiseriez',
    'argotiserons',
    'argotiseront',
    'argotises',
    'argotisez',
    'argotisiez',
    'argotisions',
    'argotisme',
    'argotismes',
    'argotisons',
    'argotiste',
    'argotistes',
    'argotisâmes',
    'argotisât',
    'argotisâtes',
    'argotisèrent',
    'argots',
    'argousier',
    'argousiers',
    'argousin',
    'argousins',
    'argua',
    'arguai',
    'arguaient',
    'arguais',
    'arguait',
    'arguant',
    'arguas',
    'arguasse',
    'arguassent',
    'arguasses',
    'arguassiez',
    'arguassions',
    'argue',
    'arguent',
    'arguer',
    'arguera',
    'arguerai',
    'argueraient',
    'arguerais',
    'arguerait',
    'argueras',
    'arguerez',
    'argueriez',
    'arguerions',
    'arguerons',
    'argueront',
    'argues',
    'arguez',
    'arguiez',
    'arguions',
    'argument',
    'argumenta',
    'argumentai',
    'argumentaire',
    'argumentais',
    'argumentait',
    'argumentant',
    'argumentants',
    'argumentas',
    'argumentasse',
    'argumente',
    'argumentent',
    'argumenter',
    'argumentera',
    'argumenterai',
    'argumenteras',
    'argumenterez',
    'argumentes',
    'argumentez',
    'argumentiez',
    'argumentions',
    'argumentons',
    'arguments',
    'argumentâmes',
    'argumentât',
    'argumentâtes',
    'argumenté',
    'argumentée',
    'argumentées',
    'argumentés',
    'arguons',
    'argus',
    'argutie',
    'arguties',
    'arguâmes',
    'arguât',
    'arguâtes',
    'arguèrent',
    'argué',
    'arguée',
    'arguées',
    'argués',
    'argyrisme',
    'argyrismes',
    'argyronète',
    'argyronètes',
    'argyrose',
    'argyroses',
    'aria',
    'arianisme',
    'arianismes',
    'arias',
    'aride',
    'arides',
    'aridité',
    'aridités',
    'arien',
    'arienne',
    'ariennes',
    'ariens',
    'ariette',
    'ariettes',
    'arille',
    'arilles',
    'arioso',
    'ariosos',
    'arisa',
    'arisai',
    'arisaient',
    'arisais',
    'arisait',
    'arisant',
    'arisas',
    'arisasse',
    'arisassent',
    'arisasses',
    'arisassiez',
    'arisassions',
    'arise',
    'arisent',
    'ariser',
    'arisera',
    'ariserai',
    'ariseraient',
    'ariserais',
    'ariserait',
    'ariseras',
    'ariserez',
    'ariseriez',
    'ariserions',
    'ariserons',
    'ariseront',
    'arises',
    'arisez',
    'arisiez',
    'arisions',
    'arisons',
    'aristocrate',
    'aristocrates',
    'aristocratie',
    'aristoloche',
    'aristoloches',
    'arisâmes',
    'arisât',
    'arisâtes',
    'arisèrent',
    'arisé',
    'arithmétique',
    'arlequin',
    'arlequinade',
    'arlequinades',
    'arlequins',
    'arma',
    'armada',
    'armadas',
    'armagnac',
    'armagnacs',
    'armai',
    'armaient',
    'armailli',
    'armaillis',
    'armais',
    'armait',
    'armant',
    'armas',
    'armasse',
    'armassent',
    'armasses',
    'armassiez',
    'armassions',
    'armateur',
    'armateurs',
    'armature',
    'armatures',
    'arme',
    'armement',
    'armements',
    'arment',
    'armer',
    'armera',
    'armerai',
    'armeraient',
    'armerais',
    'armerait',
    'armeras',
    'armerez',
    'armeriez',
    'armerions',
    'armerons',
    'armeront',
    'armes',
    'armet',
    'armets',
    'armeuse',
    'armeuses',
    'armez',
    'armiez',
    'armillaire',
    'armillaires',
    'armilles',
    'arminien',
    'arminienne',
    'arminiennes',
    'arminiens',
    'armions',
    'armistice',
    'armistices',
    'armoire',
    'armoires',
    'armoiries',
    'armoise',
    'armoises',
    'armon',
    'armons',
    'armoria',
    'armoriai',
    'armoriaient',
    'armoriais',
    'armoriait',
    'armorial',
    'armoriale',
    'armoriales',
    'armoriant',
    'armorias',
    'armoriasse',
    'armoriassent',
    'armoriasses',
    'armoriassiez',
    'armoriaux',
    'armorie',
    'armorient',
    'armorier',
    'armoriera',
    'armorierai',
    'armorierais',
    'armorierait',
    'armorieras',
    'armorierez',
    'armorieriez',
    'armorierions',
    'armorierons',
    'armorieront',
    'armories',
    'armoriez',
    'armoriiez',
    'armoriions',
    'armorions',
    'armoriâmes',
    'armoriât',
    'armoriâtes',
    'armorièrent',
    'armorié',
    'armoriée',
    'armoriées',
    'armoriés',
    'armure',
    'armurerie',
    'armureries',
    'armures',
    'armurier',
    'armuriers',
    'armâmes',
    'armât',
    'armâtes',
    'armèrent',
    'armé',
    'armée',
    'armées',
    'arménien',
    'arménienne',
    'arméniennes',
    'arméniens',
    'armés',
    'arnaqua',
    'arnaquai',
    'arnaquaient',
    'arnaquais',
    'arnaquait',
    'arnaquant',
    'arnaquas',
    'arnaquasse',
    'arnaquassent',
    'arnaquasses',
    'arnaquassiez',
    'arnaque',
    'arnaquent',
    'arnaquer',
    'arnaquera',
    'arnaquerai',
    'arnaquerais',
    'arnaquerait',
    'arnaqueras',
    'arnaquerez',
    'arnaqueriez',
    'arnaquerions',
    'arnaquerons',
    'arnaqueront',
    'arnaques',
    'arnaquez',
    'arnaquiez',
    'arnaquions',
    'arnaquons',
    'arnaquâmes',
    'arnaquât',
    'arnaquâtes',
    'arnaquèrent',
    'arnaqué',
    'arnaquée',
    'arnaquées',
    'arnaqués',
    'arnica',
    'arnicas',
    'aromate',
    'aromates',
    'aromatique',
    'aromatiques',
    'aromatisa',
    'aromatisai',
    'aromatisais',
    'aromatisait',
    'aromatisant',
    'aromatisants',
    'aromatisas',
    'aromatisasse',
    'aromatise',
    'aromatisent',
    'aromatiser',
    'aromatisera',
    'aromatiserai',
    'aromatiseras',
    'aromatiserez',
    'aromatises',
    'aromatisez',
    'aromatisiez',
    'aromatisions',
    'aromatisons',
    'aromatisâmes',
    'aromatisât',
    'aromatisâtes',
    'aromatisé',
    'aromatisée',
    'aromatisées',
    'aromatisés',
    'aronde',
    'arondes',
    'arpent',
    'arpenta',
    'arpentage',
    'arpentages',
    'arpentai',
    'arpentaient',
    'arpentais',
    'arpentait',
    'arpentant',
    'arpentas',
    'arpentasse',
    'arpentassent',
    'arpentasses',
    'arpentassiez',
    'arpente',
    'arpentent',
    'arpenter',
    'arpentera',
    'arpenterai',
    'arpenterais',
    'arpenterait',
    'arpenteras',
    'arpenterez',
    'arpenteriez',
    'arpenterions',
    'arpenterons',
    'arpenteront',
    'arpentes',
    'arpenteur',
    'arpenteurs',
    'arpenteuse',
    'arpenteuses',
    'arpentez',
    'arpentiez',
    'arpentions',
    'arpentons',
    'arpents',
    'arpentâmes',
    'arpentât',
    'arpentâtes',
    'arpentèrent',
    'arpenté',
    'arpentée',
    'arpentées',
    'arpentés',
    'arpette',
    'arpettes',
    'arpion',
    'arpions',
    'arpège',
    'arpègent',
    'arpèges',
    'arpète',
    'arpètes',
    'arpégea',
    'arpégeai',
    'arpégeaient',
    'arpégeais',
    'arpégeait',
    'arpégeant',
    'arpégeas',
    'arpégeasse',
    'arpégeassent',
    'arpégeasses',
    'arpégeassiez',
    'arpégeons',
    'arpéger',
    'arpégera',
    'arpégerai',
    'arpégeraient',
    'arpégerais',
    'arpégerait',
    'arpégeras',
    'arpégerez',
    'arpégeriez',
    'arpégerions',
    'arpégerons',
    'arpégeront',
    'arpégez',
    'arpégeâmes',
    'arpégeât',
    'arpégeâtes',
    'arpégiez',
    'arpégions',
    'arpégèrent',
    'arpégé',
    'arpégée',
    'arpégées',
    'arpégés',
    'arqua',
    'arquai',
    'arquaient',
    'arquais',
    'arquait',
    'arquant',
    'arquas',
    'arquasse',
    'arquassent',
    'arquasses',
    'arquassiez',
    'arquassions',
    'arque',
    'arquebusade',
    'arquebusades',
    'arquebuse',
    'arquebuses',
    'arquebusier',
    'arquebusiers',
    'arquent',
    'arquer',
    'arquera',
    'arquerai',
    'arqueraient',
    'arquerais',
    'arquerait',
    'arqueras',
    'arquerez',
    'arqueriez',
    'arquerions',
    'arquerons',
    'arqueront',
    'arques',
    'arquez',
    'arquiez',
    'arquions',
    'arquons',
    'arquâmes',
    'arquât',
    'arquâtes',
    'arquèrent',
    'arqué',
    'arquée',
    'arquées',
    'arqués',
    'arracha',
    'arrachage',
    'arrachages',
    'arrachai',
    'arrachaient',
    'arrachais',
    'arrachait',
    'arrachant',
    'arrachas',
    'arrachasse',
    'arrachassent',
    'arrachasses',
    'arrachassiez',
    'arrache',
    'arrachement',
    'arrachements',
    'arrachent',
    'arracher',
    'arrachera',
    'arracherai',
    'arracherais',
    'arracherait',
    'arracheras',
    'arracherez',
    'arracheriez',
    'arracherions',
    'arracherons',
    'arracheront',
    'arraches',
    'arracheur',
    'arracheurs',
    'arracheuse',
    'arracheuses',
    'arrachez',
    'arrachiez',
    'arrachions',
    'arrachis',
    'arrachons',
    'arrachâmes',
    'arrachât',
    'arrachâtes',
    'arrachèrent',
    'arraché',
    'arrachée',
    'arrachées',
    'arrachés',
    'arraisonna',
    'arraisonnai',
    'arraisonnais',
    'arraisonnait',
    'arraisonnant',
    'arraisonnas',
    'arraisonne',
    'arraisonnent',
    'arraisonner',
    'arraisonnera',
    'arraisonnes',
    'arraisonnez',
    'arraisonniez',
    'arraisonnons',
    'arraisonnât',
    'arraisonné',
    'arraisonnée',
    'arraisonnées',
    'arraisonnés',
    'arrange',
    'arrangea',
    'arrangeable',
    'arrangeables',
    'arrangeai',
    'arrangeaient',
    'arrangeais',
    'arrangeait',
    'arrangeant',
    'arrangeante',
    'arrangeantes',
    'arrangeants',
    'arrangeas',
    'arrangeasse',
    'arrangeasses',
    'arrangement',
    'arrangements',
    'arrangent',
    'arrangeons',
    'arranger',
    'arrangera',
    'arrangerai',
    'arrangerais',
    'arrangerait',
    'arrangeras',
    'arrangerez',
    'arrangeriez',
    'arrangerions',
    'arrangerons',
    'arrangeront',
    'arranges',
    'arrangeur',
    'arrangeurs',
    'arrangez',
    'arrangeâmes',
    'arrangeât',
    'arrangeâtes',
    'arrangiez',
    'arrangions',
    'arrangèrent',
    'arrangé',
    'arrangée',
    'arrangées',
    'arrangés',
    'arrenta',
    'arrentai',
    'arrentaient',
    'arrentais',
    'arrentait',
    'arrentant',
    'arrentas',
    'arrentasse',
    'arrentassent',
    'arrentasses',
    'arrentassiez',
    'arrente',
    'arrentent',
    'arrenter',
    'arrentera',
    'arrenterai',
    'arrenterais',
    'arrenterait',
    'arrenteras',
    'arrenterez',
    'arrenteriez',
    'arrenterions',
    'arrenterons',
    'arrenteront',
    'arrentes',
    'arrentez',
    'arrentiez',
    'arrentions',
    'arrentons',
    'arrentâmes',
    'arrentât',
    'arrentâtes',
    'arrentèrent',
    'arrenté',
    'arrentée',
    'arrentées',
    'arrentés',
    'arrestation',
    'arrestations',
    'arrhes',
    'arrima',
    'arrimage',
    'arrimages',
    'arrimai',
    'arrimaient',
    'arrimais',
    'arrimait',
    'arrimant',
    'arrimas',
    'arrimasse',
    'arrimassent',
    'arrimasses',
    'arrimassiez',
    'arrimassions',
    'arrime',
    'arriment',
    'arrimer',
    'arrimera',
    'arrimerai',
    'arrimeraient',
    'arrimerais',
    'arrimerait',
    'arrimeras',
    'arrimerez',
    'arrimeriez',
    'arrimerions',
    'arrimerons',
    'arrimeront',
    'arrimes',
    'arrimeur',
    'arrimeurs',
    'arrimez',
    'arrimiez',
    'arrimions',
    'arrimons',
    'arrimâmes',
    'arrimât',
    'arrimâtes',
    'arrimèrent',
    'arrimé',
    'arrimée',
    'arrimées',
    'arrimés',
    'arrisa',
    'arrisai',
    'arrisaient',
    'arrisais',
    'arrisait',
    'arrisant',
    'arrisas',
    'arrisasse',
    'arrisassent',
    'arrisasses',
    'arrisassiez',
    'arrisassions',
    'arrise',
    'arrisent',
    'arriser',
    'arrisera',
    'arriserai',
    'arriseraient',
    'arriserais',
    'arriserait',
    'arriseras',
    'arriserez',
    'arriseriez',
    'arriserions',
    'arriserons',
    'arriseront',
    'arrises',
    'arrisez',
    'arrisiez',
    'arrisions',
    'arrisons',
    'arrisâmes',
    'arrisât',
    'arrisâtes',
    'arrisèrent',
    'arrisé',
    'arriva',
    'arrivage',
    'arrivages',
    'arrivai',
    'arrivaient',
    'arrivais',
    'arrivait',
    'arrivant',
    'arrivants',
    'arrivas',
    'arrivasse',
    'arrivassent',
    'arrivasses',
    'arrivassiez',
    'arrivassions',
    'arrive',
    'arrivent',
    'arriver',
    'arrivera',
    'arriverai',
    'arriveraient',
    'arriverais',
    'arriverait',
    'arriveras',
    'arriverez',
    'arriveriez',
    'arriverions',
    'arriverons',
    'arriveront',
    'arrives',
    'arrivez',
    'arriviez',
    'arrivions',
    'arrivisme',
    'arrivismes',
    'arriviste',
    'arrivistes',
    'arrivons',
    'arrivâmes',
    'arrivât',
    'arrivâtes',
    'arrivèrent',
    'arrivé',
    'arrivée',
    'arrivées',
    'arrivés',
    'arrière',
    'arrièrent',
    'arrières',
    'arriéra',
    'arriérai',
    'arriéraient',
    'arriérais',
    'arriérait',
    'arriérant',
    'arriéras',
    'arriérasse',
    'arriérassent',
    'arriérasses',
    'arriérassiez',
    'arriération',
    'arriérations',
    'arriérer',
    'arriérera',
    'arriérerai',
    'arriérerais',
    'arriérerait',
    'arriéreras',
    'arriérerez',
    'arriéreriez',
    'arriérerions',
    'arriérerons',
    'arriéreront',
    'arriérez',
    'arriériez',
    'arriérions',
    'arriérons',
    'arriérâmes',
    'arriérât',
    'arriérâtes',
    'arriérèrent',
    'arriéré',
    'arriérée',
    'arriérées',
    'arriérés',
    'arrobe',
    'arrobes',
    'arroche',
    'arroches',
    'arrogamment',
    'arrogance',
    'arrogances',
    'arrogant',
    'arrogante',
    'arrogantes',
    'arrogants',
    'arroge',
    'arrogea',
    'arrogeaient',
    'arrogeais',
    'arrogeait',
    'arrogeant',
    'arrogeassiez',
    'arrogent',
    'arrogeons',
    'arroger',
    'arrogera',
    'arrogerai',
    'arrogeraient',
    'arrogerais',
    'arrogerait',
    'arrogeras',
    'arrogerez',
    'arrogeriez',
    'arrogerions',
    'arrogerons',
    'arrogeront',
    'arroges',
    'arrogez',
    'arrogeâmes',
    'arrogeâtes',
    'arrogiez',
    'arrogions',
    'arrogèrent',
    'arrogé',
    'arrogée',
    'arrogées',
    'arrogés',
    'arrondi',
    'arrondie',
    'arrondies',
    'arrondir',
    'arrondira',
    'arrondirai',
    'arrondirais',
    'arrondirait',
    'arrondiras',
    'arrondirent',
    'arrondirez',
    'arrondiriez',
    'arrondirions',
    'arrondirons',
    'arrondiront',
    'arrondis',
    'arrondissage',
    'arrondissais',
    'arrondissait',
    'arrondissant',
    'arrondisse',
    'arrondissent',
    'arrondisses',
    'arrondissez',
    'arrondissiez',
    'arrondissons',
    'arrondit',
    'arrondîmes',
    'arrondît',
    'arrondîtes',
    'arrosa',
    'arrosable',
    'arrosables',
    'arrosage',
    'arrosages',
    'arrosai',
    'arrosaient',
    'arrosais',
    'arrosait',
    'arrosant',
    'arrosas',
    'arrosasse',
    'arrosassent',
    'arrosasses',
    'arrosassiez',
    'arrosassions',
    'arrose',
    'arrosement',
    'arrosements',
    'arrosent',
    'arroser',
    'arrosera',
    'arroserai',
    'arroseraient',
    'arroserais',
    'arroserait',
    'arroseras',
    'arroserez',
    'arroseriez',
    'arroserions',
    'arroserons',
    'arroseront',
    'arroses',
    'arroseur',
    'arroseurs',
    'arroseuse',
    'arroseuses',
    'arrosez',
    'arrosiez',
    'arrosions',
    'arrosoir',
    'arrosoirs',
    'arrosons',
    'arrosâmes',
    'arrosât',
    'arrosâtes',
    'arrosèrent',
    'arrosé',
    'arrosée',
    'arrosées',
    'arrosés',
    'arroyo',
    'arroyos',
    'arrérage',
    'arréragea',
    'arrérageai',
    'arrérageais',
    'arrérageait',
    'arrérageant',
    'arrérageas',
    'arrérageasse',
    'arréragent',
    'arrérageons',
    'arrérager',
    'arréragera',
    'arréragerai',
    'arréragerais',
    'arréragerait',
    'arrérageras',
    'arréragerez',
    'arrérageriez',
    'arréragerons',
    'arrérageront',
    'arrérages',
    'arréragez',
    'arrérageâmes',
    'arrérageât',
    'arrérageâtes',
    'arréragiez',
    'arréragions',
    'arréragèrent',
    'arréragé',
    'arréragée',
    'arréragées',
    'arréragés',
    'arrêt',
    'arrêta',
    'arrêtai',
    'arrêtaient',
    'arrêtais',
    'arrêtait',
    'arrêtant',
    'arrêtas',
    'arrêtasse',
    'arrêtassent',
    'arrêtasses',
    'arrêtassiez',
    'arrêtassions',
    'arrête',
    'arrêtent',
    'arrêter',
    'arrêtera',
    'arrêterai',
    'arrêteraient',
    'arrêterais',
    'arrêterait',
    'arrêteras',
    'arrêterez',
    'arrêteriez',
    'arrêterions',
    'arrêterons',
    'arrêteront',
    'arrêtes',
    'arrêtez',
    'arrêtiez',
    'arrêtions',
    'arrêtiste',
    'arrêtistes',
    'arrêtoir',
    'arrêtoirs',
    'arrêtons',
    'arrêts',
    'arrêtâmes',
    'arrêtât',
    'arrêtâtes',
    'arrêtèrent',
    'arrêté',
    'arrêtée',
    'arrêtées',
    'arrêtés',
    'arsenal',
    'arsenaux',
    'arsenic',
    'arsenical',
    'arsenicale',
    'arsenicales',
    'arsenicaux',
    'arsenics',
    'arsin',
    'arsine',
    'arsines',
    'arsins',
    'arsouille',
    'arsouiller',
    'arsouillerez',
    'arsouilles',
    'arsouillez',
    'arsouilliez',
    'arsouillions',
    'arsouillons',
    'arsouillâmes',
    'arsouillâtes',
    'arsouillé',
    'arsouillée',
    'arsouillées',
    'arsouillés',
    'arséniate',
    'arséniates',
    'arsénieux',
    'arsénite',
    'arsénites',
    'arséniure',
    'arséniures',
    'artefact',
    'artefacts',
    'artel',
    'artels',
    'arthralgie',
    'arthralgies',
    'arthrite',
    'arthrites',
    'arthritique',
    'arthritiques',
    'arthritisme',
    'arthritismes',
    'arthrodie',
    'arthrodies',
    'arthropathie',
    'arthropode',
    'arthropodes',
    'arthrose',
    'arthroses',
    'artichaut',
    'artichauts',
    'article',
    'articles',
    'articula',
    'articulai',
    'articulaient',
    'articulaire',
    'articulaires',
    'articulais',
    'articulait',
    'articulant',
    'articulas',
    'articulasse',
    'articulasses',
    'articulation',
    'articule',
    'articulent',
    'articuler',
    'articulera',
    'articulerai',
    'articulerais',
    'articulerait',
    'articuleras',
    'articulerez',
    'articuleriez',
    'articulerons',
    'articuleront',
    'articules',
    'articulet',
    'articulets',
    'articulez',
    'articuliez',
    'articulions',
    'articulons',
    'articulâmes',
    'articulât',
    'articulâtes',
    'articulèrent',
    'articulé',
    'articulée',
    'articulées',
    'articulés',
    'artifice',
    'artifices',
    'artificiel',
    'artificielle',
    'artificiels',
    'artificier',
    'artificiers',
    'artificieuse',
    'artificieux',
    'artillerie',
    'artilleries',
    'artilleur',
    'artilleurs',
    'artimon',
    'artimons',
    'artisan',
    'artisanal',
    'artisanale',
    'artisanales',
    'artisanat',
    'artisanats',
    'artisanaux',
    'artisans',
    'artiste',
    'artistement',
    'artistes',
    'artistique',
    'artistiques',
    'artocarpe',
    'artocarpes',
    'arts',
    'artère',
    'artères',
    'artériel',
    'artérielle',
    'artérielles',
    'artériels',
    'artériole',
    'artérioles',
    'artériotomie',
    'artérite',
    'artérites',
    'artéritique',
    'artéritiques',
    'artésien',
    'artésienne',
    'artésiennes',
    'artésiens',
    'arum',
    'arums',
    'aruspice',
    'aruspices',
    'aryen',
    'aryenne',
    'aryennes',
    'aryens',
    'aryle',
    'aryles',
    'arythmie',
    'arythmies',
    'aryténoïde',
    'aryténoïdes',
    'arçon',
    'arçonna',
    'arçonnai',
    'arçonnaient',
    'arçonnais',
    'arçonnait',
    'arçonnant',
    'arçonnas',
    'arçonnasse',
    'arçonnassent',
    'arçonnasses',
    'arçonnassiez',
    'arçonne',
    'arçonnent',
    'arçonner',
    'arçonnera',
    'arçonnerai',
    'arçonnerais',
    'arçonnerait',
    'arçonneras',
    'arçonnerez',
    'arçonneriez',
    'arçonnerions',
    'arçonnerons',
    'arçonneront',
    'arçonnes',
    'arçonnez',
    'arçonniez',
    'arçonnions',
    'arçonnons',
    'arçonnâmes',
    'arçonnât',
    'arçonnâtes',
    'arçonnèrent',
    'arçonné',
    'arçonnée',
    'arçonnées',
    'arçonnés',
    'arçons',
    'arène',
    'arènes',
    'aréflexie',
    'aréflexies',
    'aréique',
    'aréiques',
    'arénacé',
    'arénacée',
    'arénacées',
    'arénacés',
    'arénicole',
    'arénicoles',
    'aréolaire',
    'aréolaires',
    'aréole',
    'aréoles',
    'aréomètre',
    'aréomètres',
    'aréométrie',
    'aréométries',
    'aréopage',
    'aréopages',
    'aréostyle',
    'aréostyles',
    'aréquier',
    'aréquiers',
    'arête',
    'arêtes',
    'arêtiere',
    'arêtieres',
    'arôme',
    'arômes',
    'asbeste',
    'asbestes',
    'asbestose',
    'asbestoses',
    'ascaride',
    'ascarides',
    'ascaridiase',
    'ascaridiases',
    'ascaridiose',
    'ascaridioses',
    'ascaris',
    'ascendance',
    'ascendances',
    'ascendant',
    'ascendante',
    'ascendantes',
    'ascendants',
    'ascenseur',
    'ascenseurs',
    'ascension',
    'ascensionna',
    'ascensionnai',
    'ascensionnas',
    'ascensionne',
    'ascensionnel',
    'ascensionner',
    'ascensionnes',
    'ascensionnez',
    'ascensionnât',
    'ascensionné',
    'ascensionnée',
    'ascensionnés',
    'ascensions',
    'ascidie',
    'ascidies',
    'ascite',
    'ascites',
    'ascitique',
    'ascitiques',
    'asclépiade',
    'asclépiades',
    'ascèse',
    'ascèses',
    'ascète',
    'ascètes',
    'ascétique',
    'ascétiques',
    'ascétisme',
    'ascétismes',
    'asepsie',
    'asepsies',
    'aseptique',
    'aseptiques',
    'aseptisa',
    'aseptisai',
    'aseptisaient',
    'aseptisais',
    'aseptisait',
    'aseptisant',
    'aseptisas',
    'aseptisasse',
    'aseptisasses',
    'aseptisation',
    'aseptise',
    'aseptisent',
    'aseptiser',
    'aseptisera',
    'aseptiserai',
    'aseptiserais',
    'aseptiserait',
    'aseptiseras',
    'aseptiserez',
    'aseptiseriez',
    'aseptiserons',
    'aseptiseront',
    'aseptises',
    'aseptisez',
    'aseptisiez',
    'aseptisions',
    'aseptisons',
    'aseptisâmes',
    'aseptisât',
    'aseptisâtes',
    'aseptisèrent',
    'aseptisé',
    'aseptisée',
    'aseptisées',
    'aseptisés',
    'asexualité',
    'asexualités',
    'asexuel',
    'asexuelle',
    'asexuelles',
    'asexuels',
    'asexué',
    'asexuée',
    'asexuées',
    'asexués',
    'ashkénaze',
    'ashkénazes',
    'ashram',
    'ashrams',
    'asialie',
    'asialies',
    'asiatique',
    'asiatiques',
    'asilaire',
    'asilaires',
    'asile',
    'asiles',
    'asinien',
    'asinienne',
    'asiniennes',
    'asiniens',
    'asociabilité',
    'asocial',
    'asociale',
    'asociales',
    'asociaux',
    'asparagine',
    'asparagines',
    'asparagus',
    'aspartate',
    'aspartates',
    'aspartique',
    'aspartiques',
    'aspe',
    'aspect',
    'aspecta',
    'aspectai',
    'aspectaient',
    'aspectais',
    'aspectait',
    'aspectant',
    'aspectas',
    'aspectasse',
    'aspectassent',
    'aspectasses',
    'aspectassiez',
    'aspecte',
    'aspectent',
    'aspecter',
    'aspectera',
    'aspecterai',
    'aspecterais',
    'aspecterait',
    'aspecteras',
    'aspecterez',
    'aspecteriez',
    'aspecterions',
    'aspecterons',
    'aspecteront',
    'aspectes',
    'aspectez',
    'aspectiez',
    'aspections',
    'aspectons',
    'aspects',
    'aspectâmes',
    'aspectât',
    'aspectâtes',
    'aspectèrent',
    'aspecté',
    'aspectée',
    'aspectées',
    'aspectés',
    'asperge',
    'aspergea',
    'aspergeai',
    'aspergeaient',
    'aspergeais',
    'aspergeait',
    'aspergeant',
    'aspergeas',
    'aspergeasse',
    'aspergeasses',
    'aspergent',
    'aspergeons',
    'asperger',
    'aspergera',
    'aspergerai',
    'aspergerais',
    'aspergerait',
    'aspergeras',
    'aspergerez',
    'aspergeriez',
    'aspergerions',
    'aspergerons',
    'aspergeront',
    'asperges',
    'aspergez',
    'aspergeâmes',
    'aspergeât',
    'aspergeâtes',
    'aspergiez',
    'aspergille',
    'aspergilles',
    'aspergillose',
    'aspergions',
    'aspergèrent',
    'aspergé',
    'aspergée',
    'aspergées',
    'aspergés',
    'aspermatisme',
    'asperme',
    'aspermes',
    'aspersion',
    'aspersions',
    'aspersoir',
    'aspersoirs',
    'aspes',
    'asphalta',
    'asphaltage',
    'asphaltages',
    'asphaltai',
    'asphaltaient',
    'asphaltais',
    'asphaltait',
    'asphaltant',
    'asphaltas',
    'asphaltasse',
    'asphaltasses',
    'asphalte',
    'asphaltent',
    'asphalter',
    'asphaltera',
    'asphalterai',
    'asphalterais',
    'asphalterait',
    'asphalteras',
    'asphalterez',
    'asphalteriez',
    'asphalterons',
    'asphalteront',
    'asphaltes',
    'asphaltez',
    'asphaltiez',
    'asphaltions',
    'asphaltons',
    'asphaltâmes',
    'asphaltât',
    'asphaltâtes',
    'asphaltèrent',
    'asphalté',
    'asphaltée',
    'asphaltées',
    'asphaltés',
    'asphodèle',
    'asphodèles',
    'asphyxia',
    'asphyxiai',
    'asphyxiaient',
    'asphyxiais',
    'asphyxiait',
    'asphyxiant',
    'asphyxiante',
    'asphyxiantes',
    'asphyxiants',
    'asphyxias',
    'asphyxiasse',
    'asphyxiasses',
    'asphyxie',
    'asphyxient',
    'asphyxier',
    'asphyxiera',
    'asphyxierai',
    'asphyxierais',
    'asphyxierait',
    'asphyxieras',
    'asphyxierez',
    'asphyxieriez',
    'asphyxierons',
    'asphyxieront',
    'asphyxies',
    'asphyxiez',
    'asphyxiiez',
    'asphyxiions',
    'asphyxions',
    'asphyxiâmes',
    'asphyxiât',
    'asphyxiâtes',
    'asphyxièrent',
    'asphyxié',
    'asphyxiée',
    'asphyxiées',
    'asphyxiés',
    'aspic',
    'aspics',
    'aspidistra',
    'aspidistras',
    'aspira',
    'aspirai',
    'aspiraient',
    'aspirais',
    'aspirait',
    'aspirant',
    'aspirante',
    'aspirantes',
    'aspirants',
    'aspiras',
    'aspirasse',
    'aspirassent',
    'aspirasses',
    'aspirassiez',
    'aspirassions',
    'aspirateur',
    'aspirateurs',
    'aspiration',
    'aspirations',
    'aspiratoire',
    'aspiratoires',
    'aspire',
    'aspirent',
    'aspirer',
    'aspirera',
    'aspirerai',
    'aspireraient',
    'aspirerais',
    'aspirerait',
    'aspireras',
    'aspirerez',
    'aspireriez',
    'aspirerions',
    'aspirerons',
    'aspireront',
    'aspires',
    'aspirez',
    'aspiriez',
    'aspirine',
    'aspirines',
    'aspirions',
    'aspirons',
    'aspirâmes',
    'aspirât',
    'aspirâtes',
    'aspirèrent',
    'aspiré',
    'aspirée',
    'aspirées',
    'aspirés',
    'aspérité',
    'aspérités',
    'asque',
    'asques',
    'assagi',
    'assagie',
    'assagies',
    'assagir',
    'assagira',
    'assagirai',
    'assagiraient',
    'assagirais',
    'assagirait',
    'assagiras',
    'assagirent',
    'assagirez',
    'assagiriez',
    'assagirions',
    'assagirons',
    'assagiront',
    'assagis',
    'assagissais',
    'assagissait',
    'assagissant',
    'assagisse',
    'assagissent',
    'assagisses',
    'assagissez',
    'assagissiez',
    'assagissions',
    'assagissons',
    'assagit',
    'assagîmes',
    'assagît',
    'assagîtes',
    'assai',
    'assaillaient',
    'assaillais',
    'assaillait',
    'assaillant',
    'assaillante',
    'assaillantes',
    'assaillants',
    'assaille',
    'assaillent',
    'assailles',
    'assaillez',
    'assailli',
    'assaillie',
    'assaillies',
    'assailliez',
    'assaillions',
    'assaillir',
    'assaillira',
    'assaillirai',
    'assaillirais',
    'assaillirait',
    'assailliras',
    'assaillirent',
    'assaillirez',
    'assailliriez',
    'assaillirons',
    'assailliront',
    'assaillis',
    'assaillisse',
    'assaillisses',
    'assaillit',
    'assaillons',
    'assaillîmes',
    'assaillît',
    'assaillîtes',
    'assaini',
    'assainie',
    'assainies',
    'assainir',
    'assainira',
    'assainirai',
    'assainirais',
    'assainirait',
    'assainiras',
    'assainirent',
    'assainirez',
    'assainiriez',
    'assainirions',
    'assainirons',
    'assainiront',
    'assainis',
    'assainissais',
    'assainissait',
    'assainissant',
    'assainisse',
    'assainissent',
    'assainisses',
    'assainisseur',
    'assainissez',
    'assainissiez',
    'assainissons',
    'assainit',
    'assainîmes',
    'assainît',
    'assainîtes',
    'assaisonna',
    'assaisonnai',
    'assaisonnais',
    'assaisonnait',
    'assaisonnant',
    'assaisonnas',
    'assaisonne',
    'assaisonnent',
    'assaisonner',
    'assaisonnera',
    'assaisonnes',
    'assaisonnez',
    'assaisonniez',
    'assaisonnons',
    'assaisonnât',
    'assaisonné',
    'assaisonnée',
    'assaisonnées',
    'assaisonnés',
    'assarmenta',
    'assarmentai',
    'assarmentais',
    'assarmentait',
    'assarmentant',
    'assarmentas',
    'assarmente',
    'assarmentent',
    'assarmenter',
    'assarmentera',
    'assarmentes',
    'assarmentez',
    'assarmentiez',
    'assarmentons',
    'assarmentât',
    'assarmenté',
    'assarmentée',
    'assarmentées',
    'assarmentés',
    'assassin',
    'assassina',
    'assassinai',
    'assassinais',
    'assassinait',
    'assassinant',
    'assassinas',
    'assassinasse',
    'assassinat',
    'assassinats',
    'assassine',
    'assassinent',
    'assassiner',
    'assassinera',
    'assassinerai',
    'assassineras',
    'assassinerez',
    'assassines',
    'assassinez',
    'assassiniez',
    'assassinions',
    'assassinons',
    'assassins',
    'assassinâmes',
    'assassinât',
    'assassinâtes',
    'assassiné',
    'assassinée',
    'assassinées',
    'assassinés',
    'assaut',
    'assauts',
    'asse',
    'assembla',
    'assemblage',
    'assemblages',
    'assemblai',
    'assemblaient',
    'assemblais',
    'assemblait',
    'assemblant',
    'assemblas',
    'assemblasse',
    'assemblasses',
    'assemble',
    'assemblent',
    'assembler',
    'assemblera',
    'assemblerai',
    'assemblerais',
    'assemblerait',
    'assembleras',
    'assemblerez',
    'assembleriez',
    'assemblerons',
    'assembleront',
    'assembles',
    'assembleur',
    'assembleurs',
    'assembleuse',
    'assembleuses',
    'assemblez',
    'assembliez',
    'assemblions',
    'assemblons',
    'assemblâmes',
    'assemblât',
    'assemblâtes',
    'assemblèrent',
    'assemblé',
    'assemblée',
    'assemblées',
    'assemblés',
    'assena',
    'assenai',
    'assenaient',
    'assenais',
    'assenait',
    'assenant',
    'assenas',
    'assenasse',
    'assenassent',
    'assenasses',
    'assenassiez',
    'assenassions',
    'assener',
    'assenez',
    'asseniez',
    'assenions',
    'assenons',
    'assentiment',
    'assentiments',
    'assenâmes',
    'assenât',
    'assenâtes',
    'assenèrent',
    'assené',
    'assenée',
    'assenées',
    'assenés',
    'asseoir',
    'assermenta',
    'assermentai',
    'assermentais',
    'assermentait',
    'assermentant',
    'assermentas',
    'assermente',
    'assermentent',
    'assermenter',
    'assermentera',
    'assermentes',
    'assermentez',
    'assermentiez',
    'assermentons',
    'assermentât',
    'assermenté',
    'assermentée',
    'assermentées',
    'assermentés',
    'assertion',
    'assertions',
    'asservi',
    'asservie',
    'asservies',
    'asservir',
    'asservira',
    'asservirai',
    'asservirais',
    'asservirait',
    'asserviras',
    'asservirent',
    'asservirez',
    'asserviriez',
    'asservirions',
    'asservirons',
    'asserviront',
    'asservis',
    'asservissais',
    'asservissait',
    'asservissant',
    'asservisse',
    'asservissent',
    'asservisses',
    'asservisseur',
    'asservissez',
    'asservissiez',
    'asservissons',
    'asservit',
    'asservîmes',
    'asservît',
    'asservîtes',
    'asses',
    'assesseur',
    'assesseurs',
    'asseyaient',
    'asseyais',
    'asseyait',
    'asseyant',
    'asseye',
    'asseyent',
    'asseyes',
    'asseyez',
    'asseyiez',
    'asseyions',
    'asseyons',
    'assez',
    'assibila',
    'assibilai',
    'assibilaient',
    'assibilais',
    'assibilait',
    'assibilant',
    'assibilas',
    'assibilasse',
    'assibilasses',
    'assibilation',
    'assibile',
    'assibilent',
    'assibiler',
    'assibilera',
    'assibilerai',
    'assibilerais',
    'assibilerait',
    'assibileras',
    'assibilerez',
    'assibileriez',
    'assibilerons',
    'assibileront',
    'assibiles',
    'assibilez',
    'assibiliez',
    'assibilions',
    'assibilons',
    'assibilâmes',
    'assibilât',
    'assibilâtes',
    'assibilèrent',
    'assibilé',
    'assibilée',
    'assibilées',
    'assibilés',
    'assidu',
    'assidue',
    'assidues',
    'assiduité',
    'assiduités',
    'assidus',
    'assidûment',
    'assied',
    'assieds',
    'assiette',
    'assiettes',
    'assiettée',
    'assiettées',
    'assigna',
    'assignable',
    'assignables',
    'assignai',
    'assignaient',
    'assignais',
    'assignait',
    'assignant',
    'assignas',
    'assignasse',
    'assignassent',
    'assignasses',
    'assignassiez',
    'assignat',
    'assignation',
    'assignations',
    'assignats',
    'assigne',
    'assignent',
    'assigner',
    'assignera',
    'assignerai',
    'assignerais',
    'assignerait',
    'assigneras',
    'assignerez',
    'assigneriez',
    'assignerions',
    'assignerons',
    'assigneront',
    'assignes',
    'assignez',
    'assigniez',
    'assignions',
    'assignons',
    'assignâmes',
    'assignât',
    'assignâtes',
    'assignèrent',
    'assigné',
    'assignée',
    'assignées',
    'assignés',
    'assimila',
    'assimilable',
    'assimilables',
    'assimilai',
    'assimilaient',
    'assimilais',
    'assimilait',
    'assimilant',
    'assimilas',
    'assimilasse',
    'assimilasses',
    'assimilateur',
    'assimilation',
    'assimile',
    'assimilent',
    'assimiler',
    'assimilera',
    'assimilerai',
    'assimilerais',
    'assimilerait',
    'assimileras',
    'assimilerez',
    'assimileriez',
    'assimilerons',
    'assimileront',
    'assimiles',
    'assimilez',
    'assimiliez',
    'assimilions',
    'assimilons',
    'assimilâmes',
    'assimilât',
    'assimilâtes',
    'assimilèrent',
    'assimilé',
    'assimilée',
    'assimilées',
    'assimilés',
    'assirent',
    'assis',
    'assise',
    'assises',
    'assisse',
    'assissent',
    'assisses',
    'assissiez',
    'assissions',
    'assista',
    'assistai',
    'assistaient',
    'assistais',
    'assistait',
    'assistanat',
    'assistanats',
    'assistance',
    'assistances',
    'assistant',
    'assistante',
    'assistantes',
    'assistants',
    'assistas',
    'assistasse',
    'assistassent',
    'assistasses',
    'assistassiez',
    'assiste',
    'assistent',
    'assister',
    'assistera',
    'assisterai',
    'assisterais',
    'assisterait',
    'assisteras',
    'assisterez',
    'assisteriez',
    'assisterions',
    'assisterons',
    'assisteront',
    'assistes',
    'assistez',
    'assistiez',
    'assistions',
    'assistons',
    'assistâmes',
    'assistât',
    'assistâtes',
    'assistèrent',
    'assisté',
    'assistée',
    'assistées',
    'assistés',
    'assit',
    'assiège',
    'assiègent',
    'assièges',
    'assiégea',
    'assiégeai',
    'assiégeaient',
    'assiégeais',
    'assiégeait',
    'assiégeant',
    'assiégeante',
    'assiégeantes',
    'assiégeants',
    'assiégeas',
    'assiégeasse',
    'assiégeasses',
    'assiégeons',
    'assiéger',
    'assiégera',
    'assiégerai',
    'assiégerais',
    'assiégerait',
    'assiégeras',
    'assiégerez',
    'assiégeriez',
    'assiégerions',
    'assiégerons',
    'assiégeront',
    'assiégez',
    'assiégeâmes',
    'assiégeât',
    'assiégeâtes',
    'assiégiez',
    'assiégions',
    'assiégèrent',
    'assiégé',
    'assiégée',
    'assiégées',
    'assiégés',
    'assiéra',
    'assiérai',
    'assiéraient',
    'assiérais',
    'assiérait',
    'assiéras',
    'assiérez',
    'assiériez',
    'assiérions',
    'assiérons',
    'assiéront',
    'associa',
    'associai',
    'associaient',
    'associais',
    'associait',
    'associant',
    'associas',
    'associasse',
    'associassent',
    'associasses',
    'associassiez',
    'associatif',
    'associatifs',
    'association',
    'associations',
    'associative',
    'associatives',
    'associe',
    'associent',
    'associer',
    'associera',
    'associerai',
    'associerais',
    'associerait',
    'associeras',
    'associerez',
    'associeriez',
    'associerions',
    'associerons',
    'associeront',
    'associes',
    'associez',
    'associiez',
    'associions',
    'associons',
    'associâmes',
    'associât',
    'associâtes',
    'associèrent',
    'associé',
    'associée',
    'associées',
    'associés',
    'assoie',
    'assoient',
    'assoies',
    'assoiffant',
    'assoiffer',
    'assoiffé',
    'assoiffée',
    'assoiffées',
    'assoiffés',
    'assoira',
    'assoirai',
    'assoiraient',
    'assoirais',
    'assoirait',
    'assoiras',
    'assoirez',
    'assoiriez',
    'assoirions',
    'assoirons',
    'assoiront',
    'assois',
    'assoit',
    'assola',
    'assolai',
    'assolaient',
    'assolais',
    'assolait',
    'assolant',
    'assolas',
    'assolasse',
    'assolassent',
    'assolasses',
    'assolassiez',
    'assolassions',
    'assole',
    'assolement',
    'assolements',
    'assolent',
    'assoler',
    'assolera',
    'assolerai',
    'assoleraient',
    'assolerais',
    'assolerait',
    'assoleras',
    'assolerez',
    'assoleriez',
    'assolerions',
    'assolerons',
    'assoleront',
    'assoles',
    'assolez',
    'assoliez',
    'assolions',
    'assolons',
    'assolâmes',
    'assolât',
    'assolâtes',
    'assolèrent',
    'assolé',
    'assolée',
    'assolées',
    'assolés',
    'assombri',
    'assombrie',
    'assombries',
    'assombrir',
    'assombrira',
    'assombrirai',
    'assombrirais',
    'assombrirait',
    'assombriras',
    'assombrirent',
    'assombrirez',
    'assombririez',
    'assombrirons',
    'assombriront',
    'assombris',
    'assombrisse',
    'assombrisses',
    'assombrissez',
    'assombrit',
    'assombrîmes',
    'assombrît',
    'assombrîtes',
    'assomma',
    'assommai',
    'assommaient',
    'assommais',
    'assommait',
    'assommant',
    'assommante',
    'assommantes',
    'assommants',
    'assommas',
    'assommasse',
    'assommassent',
    'assommasses',
    'assommassiez',
    'assomme',
    'assomment',
    'assommer',
    'assommera',
    'assommerai',
    'assommerais',
    'assommerait',
    'assommeras',
    'assommerez',
    'assommeriez',
    'assommerions',
    'assommerons',
    'assommeront',
    'assommes',
    'assommeur',
    'assommeurs',
    'assommez',
    'assommiez',
    'assommions',
    'assommoir',
    'assommoirs',
    'assommons',
    'assommâmes',
    'assommât',
    'assommâtes',
    'assommèrent',
    'assommé',
    'assommée',
    'assommées',
    'assommés',
    'assomption',
    'assomptions',
    'assona',
    'assonai',
    'assonaient',
    'assonais',
    'assonait',
    'assonance',
    'assonances',
    'assonancé',
    'assonancée',
    'assonancées',
    'assonancés',
    'assonant',
    'assonante',
    'assonantes',
    'assonants',
    'assonas',
    'assonasse',
    'assonassent',
    'assonasses',
    'assonassiez',
    'assonassions',
    'assone',
    'assonent',
    'assoner',
    'assonera',
    'assonerai',
    'assoneraient',
    'assonerais',
    'assonerait',
    'assoneras',
    'assonerez',
    'assoneriez',
    'assonerions',
    'assonerons',
    'assoneront',
    'assones',
    'assonez',
    'assoniez',
    'assonions',
    'assonons',
    'assonâmes',
    'assonât',
    'assonâtes',
    'assonèrent',
    'assoné',
    'assorti',
    'assortie',
    'assorties',
    'assortiment',
    'assortiments',
    'assortir',
    'assortira',
    'assortirai',
    'assortirais',
    'assortirait',
    'assortiras',
    'assortirent',
    'assortirez',
    'assortiriez',
    'assortirions',
    'assortirons',
    'assortiront',
    'assortis',
    'assortissais',
    'assortissait',
    'assortissant',
    'assortisse',
    'assortissent',
    'assortisses',
    'assortissez',
    'assortissiez',
    'assortissons',
    'assortit',
    'assortîmes',
    'assortît',
    'assortîtes',
    'assoupi',
    'assoupie',
    'assoupies',
    'assoupir',
    'assoupira',
    'assoupirai',
    'assoupirais',
    'assoupirait',
    'assoupiras',
    'assoupirent',
    'assoupirez',
    'assoupiriez',
    'assoupirions',
    'assoupirons',
    'assoupiront',
    'assoupis',
    'assoupissais',
    'assoupissait',
    'assoupissant',
    'assoupisse',
    'assoupissent',
    'assoupisses',
    'assoupissez',
    'assoupissiez',
    'assoupissons',
    'assoupit',
    'assoupli',
    'assouplie',
    'assouplies',
    'assouplir',
    'assouplira',
    'assouplirai',
    'assouplirais',
    'assouplirait',
    'assoupliras',
    'assouplirent',
    'assouplirez',
    'assoupliriez',
    'assouplirons',
    'assoupliront',
    'assouplis',
    'assouplisse',
    'assouplisses',
    'assouplissez',
    'assouplit',
    'assouplîmes',
    'assouplît',
    'assouplîtes',
    'assoupîmes',
    'assoupît',
    'assoupîtes',
    'assourdi',
    'assourdie',
    'assourdies',
    'assourdir',
    'assourdira',
    'assourdirai',
    'assourdirais',
    'assourdirait',
    'assourdiras',
    'assourdirent',
    'assourdirez',
    'assourdiriez',
    'assourdirons',
    'assourdiront',
    'assourdis',
    'assourdisse',
    'assourdisses',
    'assourdissez',
    'assourdit',
    'assourdîmes',
    'assourdît',
    'assourdîtes',
    'assouvi',
    'assouvie',
    'assouvies',
    'assouvir',
    'assouvira',
    'assouvirai',
    'assouvirais',
    'assouvirait',
    'assouviras',
    'assouvirent',
    'assouvirez',
    'assouviriez',
    'assouvirions',
    'assouvirons',
    'assouviront',
    'assouvis',
    'assouvissais',
    'assouvissait',
    'assouvissant',
    'assouvisse',
    'assouvissent',
    'assouvisses',
    'assouvissez',
    'assouvissiez',
    'assouvissons',
    'assouvit',
    'assouvîmes',
    'assouvît',
    'assouvîtes',
    'assoyaient',
    'assoyais',
    'assoyait',
    'assoyant',
    'assoyez',
    'assoyiez',
    'assoyions',
    'assoyons',
    'assujetti',
    'assujettie',
    'assujetties',
    'assujettir',
    'assujettira',
    'assujettirai',
    'assujettiras',
    'assujettirez',
    'assujettis',
    'assujettisse',
    'assujettit',
    'assujettîmes',
    'assujettît',
    'assujettîtes',
    'assuma',
    'assumai',
    'assumaient',
    'assumais',
    'assumait',
    'assumant',
    'assumas',
    'assumasse',
    'assumassent',
    'assumasses',
    'assumassiez',
    'assumassions',
    'assume',
    'assument',
    'assumer',
    'assumera',
    'assumerai',
    'assumeraient',
    'assumerais',
    'assumerait',
    'assumeras',
    'assumerez',
    'assumeriez',
    'assumerions',
    'assumerons',
    'assumeront',
    'assumes',
    'assumez',
    'assumiez',
    'assumions',
    'assumons',
    'assumâmes',
    'assumât',
    'assumâtes',
    'assumèrent',
    'assumé',
    'assumée',
    'assumées',
    'assumés',
    'assura',
    'assurable',
    'assurables',
    'assurai',
    'assuraient',
    'assurais',
    'assurait',
    'assurance',
    'assurances',
    'assurant',
    'assuras',
    'assurasse',
    'assurassent',
    'assurasses',
    'assurassiez',
    'assurassions',
    'assure',
    'assurent',
    'assurer',
    'assurera',
    'assurerai',
    'assureraient',
    'assurerais',
    'assurerait',
    'assureras',
    'assurerez',
    'assureriez',
    'assurerions',
    'assurerons',
    'assureront',
    'assures',
    'assureur',
    'assureurs',
    'assurez',
    'assuriez',
    'assurions',
    'assurons',
    'assurâmes',
    'assurât',
    'assurâtes',
    'assurèrent',
    'assuré',
    'assurée',
    'assurées',
    'assurément',
    'assurés',
    'assuétude',
    'assuétudes',
    'assyrien',
    'assyrienne',
    'assyriennes',
    'assyriens',
    'assyriologie',
    'assyriologue',
    'assèche',
    'assèchement',
    'assèchements',
    'assèchent',
    'assèches',
    'assène',
    'assènent',
    'assènera',
    'assènerai',
    'assèneraient',
    'assènerais',
    'assènerait',
    'assèneras',
    'assènerez',
    'assèneriez',
    'assènerions',
    'assènerons',
    'assèneront',
    'assènes',
    'assécha',
    'asséchai',
    'asséchaient',
    'asséchais',
    'asséchait',
    'asséchant',
    'asséchas',
    'asséchasse',
    'asséchassent',
    'asséchasses',
    'asséchassiez',
    'assécher',
    'asséchera',
    'assécherai',
    'assécherais',
    'assécherait',
    'assécheras',
    'assécherez',
    'assécheriez',
    'assécherions',
    'assécherons',
    'assécheront',
    'asséchez',
    'asséchiez',
    'asséchions',
    'asséchons',
    'asséchâmes',
    'asséchât',
    'asséchâtes',
    'asséchèrent',
    'asséché',
    'asséchée',
    'asséchées',
    'asséchés',
    'asséna',
    'assénai',
    'assénaient',
    'assénais',
    'assénait',
    'assénant',
    'assénas',
    'assénasse',
    'assénassent',
    'assénasses',
    'assénassiez',
    'assénassions',
    'asséner',
    'assénera',
    'assénerai',
    'asséneraient',
    'assénerais',
    'assénerait',
    'asséneras',
    'assénerez',
    'asséneriez',
    'assénerions',
    'assénerons',
    'asséneront',
    'assénez',
    'asséniez',
    'assénions',
    'assénons',
    'assénâmes',
    'assénât',
    'assénâtes',
    'assénèrent',
    'asséné',
    'assénée',
    'assénées',
    'assénés',
    'assîmes',
    'assît',
    'assîtes',
    'astasie',
    'astasies',
    'astate',
    'astates',
    'astatique',
    'astatiques',
    'aster',
    'asters',
    'asthmatique',
    'asthmatiques',
    'asthme',
    'asthmes',
    'asthénie',
    'asthénies',
    'asthénique',
    'asthéniques',
    'asti',
    'asticot',
    'asticota',
    'asticotai',
    'asticotaient',
    'asticotais',
    'asticotait',
    'asticotant',
    'asticotas',
    'asticotasse',
    'asticotasses',
    'asticote',
    'asticotent',
    'asticoter',
    'asticotera',
    'asticoterai',
    'asticoterais',
    'asticoterait',
    'asticoteras',
    'asticoterez',
    'asticoteriez',
    'asticoterons',
    'asticoteront',
    'asticotes',
    'asticotez',
    'asticotiez',
    'asticotions',
    'asticotons',
    'asticots',
    'asticotâmes',
    'asticotât',
    'asticotâtes',
    'asticotèrent',
    'asticoté',
    'asticotée',
    'asticotées',
    'asticotés',
    'astigmate',
    'astigmates',
    'astigmatisme',
    'astiqua',
    'astiquage',
    'astiquages',
    'astiquai',
    'astiquaient',
    'astiquais',
    'astiquait',
    'astiquant',
    'astiquas',
    'astiquasse',
    'astiquassent',
    'astiquasses',
    'astiquassiez',
    'astique',
    'astiquent',
    'astiquer',
    'astiquera',
    'astiquerai',
    'astiquerais',
    'astiquerait',
    'astiqueras',
    'astiquerez',
    'astiqueriez',
    'astiquerions',
    'astiquerons',
    'astiqueront',
    'astiques',
    'astiquez',
    'astiquiez',
    'astiquions',
    'astiquons',
    'astiquâmes',
    'astiquât',
    'astiquâtes',
    'astiquèrent',
    'astiqué',
    'astiquée',
    'astiquées',
    'astiqués',
    'astis',
    'astragale',
    'astragales',
    'astrakan',
    'astrakans',
    'astral',
    'astrale',
    'astrales',
    'astraux',
    'astre',
    'astreignais',
    'astreignait',
    'astreignant',
    'astreignante',
    'astreignants',
    'astreigne',
    'astreignent',
    'astreignes',
    'astreignez',
    'astreigniez',
    'astreignions',
    'astreignis',
    'astreignisse',
    'astreignit',
    'astreignons',
    'astreignîmes',
    'astreignît',
    'astreignîtes',
    'astreindra',
    'astreindrai',
    'astreindrais',
    'astreindrait',
    'astreindras',
    'astreindre',
    'astreindrez',
    'astreindriez',
    'astreindrons',
    'astreindront',
    'astreins',
    'astreint',
    'astreinte',
    'astreintes',
    'astreints',
    'astres',
    'astringence',
    'astringences',
    'astringent',
    'astringente',
    'astringentes',
    'astringents',
    'astrolabe',
    'astrolabes',
    'astrologie',
    'astrologies',
    'astrologique',
    'astrologue',
    'astrologues',
    'astrolâtrie',
    'astrolâtries',
    'astrométrie',
    'astrométries',
    'astronaute',
    'astronautes',
    'astronef',
    'astronefs',
    'astronome',
    'astronomes',
    'astronomie',
    'astronomies',
    'astronomique',
    'astuce',
    'astuces',
    'astucieuse',
    'astucieuses',
    'astucieux',
    'astérie',
    'astéries',
    'astérisque',
    'astérisques',
    'astéroïde',
    'astéroïdes',
    'asymptote',
    'asymptotes',
    'asymptotique',
    'asymétrie',
    'asymétries',
    'asymétrique',
    'asymétriques',
    'asynchrone',
    'asynchrones',
    'asyndète',
    'asyndètes',
    'asynergie',
    'asynergies',
    'asystolie',
    'asystolies',
    'ataraxie',
    'ataraxies',
    'ataraxique',
    'ataraxiques',
    'atavique',
    'ataviques',
    'atavisme',
    'atavismes',
    'ataxie',
    'ataxies',
    'ataxique',
    'ataxiques',
    'atelier',
    'ateliers',
    'atemporel',
    'atemporelle',
    'atemporelles',
    'atemporels',
    'atermoie',
    'atermoiement',
    'atermoient',
    'atermoiera',
    'atermoierai',
    'atermoierais',
    'atermoierait',
    'atermoieras',
    'atermoierez',
    'atermoieriez',
    'atermoierons',
    'atermoieront',
    'atermoies',
    'atermoya',
    'atermoyai',
    'atermoyaient',
    'atermoyais',
    'atermoyait',
    'atermoyant',
    'atermoyas',
    'atermoyasse',
    'atermoyasses',
    'atermoyer',
    'atermoyez',
    'atermoyiez',
    'atermoyions',
    'atermoyons',
    'atermoyâmes',
    'atermoyât',
    'atermoyâtes',
    'atermoyèrent',
    'atermoyé',
    'athanor',
    'athanors',
    'athermane',
    'athermanes',
    'athermique',
    'athermiques',
    'athlète',
    'athlètes',
    'athlétique',
    'athlétiques',
    'athlétisme',
    'athlétismes',
    'athymie',
    'athymies',
    'athée',
    'athées',
    'athéisme',
    'athéismes',
    'athématique',
    'athématiques',
    'athénée',
    'athénées',
    'athérome',
    'athéromes',
    'athétose',
    'athétoses',
    'atlante',
    'atlantes',
    'atlantique',
    'atlantiques',
    'atlantisme',
    'atlantismes',
    'atlas',
    'atmosphère',
    'atmosphères',
    'atoll',
    'atolls',
    'atome',
    'atomes',
    'atomicité',
    'atomicités',
    'atomique',
    'atomiques',
    'atomisa',
    'atomisai',
    'atomisaient',
    'atomisais',
    'atomisait',
    'atomisant',
    'atomisas',
    'atomisasse',
    'atomisassent',
    'atomisasses',
    'atomisassiez',
    'atomisation',
    'atomisations',
    'atomise',
    'atomisent',
    'atomiser',
    'atomisera',
    'atomiserai',
    'atomiserais',
    'atomiserait',
    'atomiseras',
    'atomiserez',
    'atomiseriez',
    'atomiserions',
    'atomiserons',
    'atomiseront',
    'atomises',
    'atomiseur',
    'atomiseurs',
    'atomisez',
    'atomisiez',
    'atomisions',
    'atomisme',
    'atomismes',
    'atomisons',
    'atomiste',
    'atomistes',
    'atomistique',
    'atomistiques',
    'atomisâmes',
    'atomisât',
    'atomisâtes',
    'atomisèrent',
    'atomisé',
    'atomisée',
    'atomisées',
    'atomisés',
    'atonal',
    'atonale',
    'atonales',
    'atonalité',
    'atonalités',
    'atonals',
    'atonaux',
    'atone',
    'atones',
    'atonie',
    'atonies',
    'atonique',
    'atoniques',
    'atour',
    'atours',
    'atout',
    'atouts',
    'atoxique',
    'atoxiques',
    'atrabilaire',
    'atrabilaires',
    'atrabile',
    'atrabiles',
    'atrium',
    'atriums',
    'atroce',
    'atrocement',
    'atroces',
    'atrocité',
    'atrocités',
    'atrophia',
    'atrophiai',
    'atrophiaient',
    'atrophiais',
    'atrophiait',
    'atrophiant',
    'atrophias',
    'atrophiasse',
    'atrophiasses',
    'atrophie',
    'atrophient',
    'atrophier',
    'atrophiera',
    'atrophierai',
    'atrophierais',
    'atrophierait',
    'atrophieras',
    'atrophierez',
    'atrophieriez',
    'atrophierons',
    'atrophieront',
    'atrophies',
    'atrophiez',
    'atrophiiez',
    'atrophiions',
    'atrophions',
    'atrophiâmes',
    'atrophiât',
    'atrophiâtes',
    'atrophièrent',
    'atrophié',
    'atrophiée',
    'atrophiées',
    'atrophiés',
    'atropine',
    'atropines',
    'attabla',
    'attablai',
    'attablaient',
    'attablais',
    'attablait',
    'attablant',
    'attablas',
    'attablasse',
    'attablassent',
    'attablasses',
    'attablassiez',
    'attable',
    'attablent',
    'attabler',
    'attablera',
    'attablerai',
    'attablerais',
    'attablerait',
    'attableras',
    'attablerez',
    'attableriez',
    'attablerions',
    'attablerons',
    'attableront',
    'attables',
    'attablez',
    'attabliez',
    'attablions',
    'attablons',
    'attablâmes',
    'attablât',
    'attablâtes',
    'attablèrent',
    'attablé',
    'attablée',
    'attablées',
    'attablés',
    'attacha',
    'attachai',
    'attachaient',
    'attachais',
    'attachait',
    'attachant',
    'attachante',
    'attachantes',
    'attachants',
    'attachas',
    'attachasse',
    'attachassent',
    'attachasses',
    'attachassiez',
    'attache',
    'attachement',
    'attachements',
    'attachent',
    'attacher',
    'attachera',
    'attacherai',
    'attacherais',
    'attacherait',
    'attacheras',
    'attacherez',
    'attacheriez',
    'attacherions',
    'attacherons',
    'attacheront',
    'attaches',
    'attachez',
    'attachiez',
    'attachions',
    'attachons',
    'attachâmes',
    'attachât',
    'attachâtes',
    'attachèrent',
    'attaché',
    'attachée',
    'attachées',
    'attachés',
    'attagène',
    'attagènes',
    'attaqua',
    'attaquable',
    'attaquables',
    'attaquai',
    'attaquaient',
    'attaquais',
    'attaquait',
    'attaquant',
    'attaquante',
    'attaquantes',
    'attaquants',
    'attaquas',
    'attaquasse',
    'attaquassent',
    'attaquasses',
    'attaquassiez',
    'attaque',
    'attaquent',
    'attaquer',
    'attaquera',
    'attaquerai',
    'attaquerais',
    'attaquerait',
    'attaqueras',
    'attaquerez',
    'attaqueriez',
    'attaquerions',
    'attaquerons',
    'attaqueront',
    'attaques',
    'attaquez',
    'attaquiez',
    'attaquions',
    'attaquons',
    'attaquâmes',
    'attaquât',
    'attaquâtes',
    'attaquèrent',
    'attaqué',
    'attaquée',
    'attaquées',
    'attaqués',
    'attarda',
    'attardai',
    'attardaient',
    'attardais',
    'attardait',
    'attardant',
    'attardas',
    'attardasse',
    'attardassent',
    'attardasses',
    'attardassiez',
    'attarde',
    'attardent',
    'attarder',
    'attardera',
    'attarderai',
    'attarderais',
    'attarderait',
    'attarderas',
    'attarderez',
    'attarderiez',
    'attarderions',
    'attarderons',
    'attarderont',
    'attardes',
    'attardez',
    'attardiez',
    'attardions',
    'attardons',
    'attardâmes',
    'attardât',
    'attardâtes',
    'attardèrent',
    'attardé',
    'attardée',
    'attardées',
    'attardés',
    'atteignable',
    'atteignables',
    'atteignaient',
    'atteignais',
    'atteignait',
    'atteignant',
    'atteigne',
    'atteignent',
    'atteignes',
    'atteignez',
    'atteigniez',
    'atteignions',
    'atteignirent',
    'atteignis',
    'atteignisse',
    'atteignisses',
    'atteignit',
    'atteignons',
    'atteignîmes',
    'atteignît',
    'atteignîtes',
    'atteindra',
    'atteindrai',
    'atteindrais',
    'atteindrait',
    'atteindras',
    'atteindre',
    'atteindrez',
    'atteindriez',
    'atteindrions',
    'atteindrons',
    'atteindront',
    'atteins',
    'atteint',
    'atteinte',
    'atteintes',
    'atteints',
    'attela',
    'attelage',
    'attelages',
    'attelai',
    'attelaient',
    'attelais',
    'attelait',
    'attelant',
    'attelas',
    'attelasse',
    'attelassent',
    'attelasses',
    'attelassiez',
    'attelassions',
    'atteler',
    'attelez',
    'atteliez',
    'attelions',
    'attelle',
    'attellent',
    'attellera',
    'attellerai',
    'attellerais',
    'attellerait',
    'attelleras',
    'attellerez',
    'attelleriez',
    'attellerions',
    'attellerons',
    'attelleront',
    'attelles',
    'attelons',
    'attelâmes',
    'attelât',
    'attelâtes',
    'attelèrent',
    'attelé',
    'attelée',
    'attelées',
    'attelés',
    'attenant',
    'attenante',
    'attenantes',
    'attenants',
    'attend',
    'attendaient',
    'attendais',
    'attendait',
    'attendant',
    'attende',
    'attendent',
    'attendes',
    'attendez',
    'attendiez',
    'attendions',
    'attendirent',
    'attendis',
    'attendisse',
    'attendissent',
    'attendisses',
    'attendissiez',
    'attendit',
    'attendons',
    'attendra',
    'attendrai',
    'attendraient',
    'attendrais',
    'attendrait',
    'attendras',
    'attendre',
    'attendrez',
    'attendri',
    'attendrie',
    'attendries',
    'attendriez',
    'attendrions',
    'attendrir',
    'attendrira',
    'attendrirai',
    'attendrirais',
    'attendrirait',
    'attendriras',
    'attendrirent',
    'attendrirez',
    'attendririez',
    'attendrirons',
    'attendriront',
    'attendris',
    'attendrisse',
    'attendrisses',
    'attendrissez',
    'attendrit',
    'attendrons',
    'attendront',
    'attendrîmes',
    'attendrît',
    'attendrîtes',
    'attends',
    'attendu',
    'attendue',
    'attendues',
    'attendus',
    'attendîmes',
    'attendît',
    'attendîtes',
    'attenta',
    'attentai',
    'attentaient',
    'attentais',
    'attentait',
    'attentant',
    'attentas',
    'attentasse',
    'attentassent',
    'attentasses',
    'attentassiez',
    'attentat',
    'attentatoire',
    'attentats',
    'attente',
    'attentent',
    'attenter',
    'attentera',
    'attenterai',
    'attenterais',
    'attenterait',
    'attenteras',
    'attenterez',
    'attenteriez',
    'attenterions',
    'attenterons',
    'attenteront',
    'attentes',
    'attentez',
    'attentiez',
    'attentif',
    'attentifs',
    'attention',
    'attentionné',
    'attentionnée',
    'attentionnés',
    'attentions',
    'attentisme',
    'attentismes',
    'attentiste',
    'attentistes',
    'attentive',
    'attentives',
    'attentons',
    'attentâmes',
    'attentât',
    'attentâtes',
    'attentèrent',
    'attenté',
    'atterra',
    'atterrage',
    'atterrages',
    'atterrai',
    'atterraient',
    'atterrais',
    'atterrait',
    'atterrant',
    'atterrante',
    'atterrantes',
    'atterrants',
    'atterras',
    'atterrasse',
    'atterrassent',
    'atterrasses',
    'atterrassiez',
    'atterre',
    'atterrent',
    'atterrer',
    'atterrera',
    'atterrerai',
    'atterrerais',
    'atterrerait',
    'atterreras',
    'atterrerez',
    'atterreriez',
    'atterrerions',
    'atterrerons',
    'atterreront',
    'atterres',
    'atterrez',
    'atterri',
    'atterriez',
    'atterrions',
    'atterrir',
    'atterrira',
    'atterrirai',
    'atterrirais',
    'atterrirait',
    'atterriras',
    'atterrirent',
    'atterrirez',
    'atterririez',
    'atterririons',
    'atterrirons',
    'atterriront',
    'atterris',
    'atterrissage',
    'atterrissais',
    'atterrissait',
    'atterrissant',
    'atterrisse',
    'atterrissent',
    'atterrisses',
    'atterrissez',
    'atterrissiez',
    'atterrissons',
    'atterrit',
    'atterrons',
    'atterrâmes',
    'atterrât',
    'atterrâtes',
    'atterrèrent',
    'atterré',
    'atterrée',
    'atterrées',
    'atterrés',
    'atterrîmes',
    'atterrît',
    'atterrîtes',
    'attesta',
    'attestai',
    'attestaient',
    'attestais',
    'attestait',
    'attestant',
    'attestas',
    'attestasse',
    'attestassent',
    'attestasses',
    'attestassiez',
    'attestation',
    'attestations',
    'atteste',
    'attestent',
    'attester',
    'attestera',
    'attesterai',
    'attesterais',
    'attesterait',
    'attesteras',
    'attesterez',
    'attesteriez',
    'attesterions',
    'attesterons',
    'attesteront',
    'attestes',
    'attestez',
    'attestiez',
    'attestions',
    'attestons',
    'attestâmes',
    'attestât',
    'attestâtes',
    'attestèrent',
    'attesté',
    'attestée',
    'attestées',
    'attestés',
    'atticisme',
    'atticismes',
    'attifa',
    'attifai',
    'attifaient',
    'attifais',
    'attifait',
    'attifant',
    'attifas',
    'attifasse',
    'attifassent',
    'attifasses',
    'attifassiez',
    'attifassions',
    'attife',
    'attifement',
    'attifements',
    'attifent',
    'attifer',
    'attifera',
    'attiferai',
    'attiferaient',
    'attiferais',
    'attiferait',
    'attiferas',
    'attiferez',
    'attiferiez',
    'attiferions',
    'attiferons',
    'attiferont',
    'attifes',
    'attifez',
    'attifiez',
    'attifions',
    'attifons',
    'attifâmes',
    'attifât',
    'attifâtes',
    'attifèrent',
    'attifé',
    'attifée',
    'attifées',
    'attifés',
    'attige',
    'attigea',
    'attigeai',
    'attigeaient',
    'attigeais',
    'attigeait',
    'attigeant',
    'attigeas',
    'attigeasse',
    'attigeassent',
    'attigeasses',
    'attigeassiez',
    'attigent',
    'attigeons',
    'attiger',
    'attigera',
    'attigerai',
    'attigeraient',
    'attigerais',
    'attigerait',
    'attigeras',
    'attigerez',
    'attigeriez',
    'attigerions',
    'attigerons',
    'attigeront',
    'attiges',
    'attigez',
    'attigeâmes',
    'attigeât',
    'attigeâtes',
    'attigiez',
    'attigions',
    'attigèrent',
    'attigé',
    'attique',
    'attiques',
    'attira',
    'attirable',
    'attirables',
    'attirai',
    'attiraient',
    'attirail',
    'attirails',
    'attirais',
    'attirait',
    'attirance',
    'attirances',
    'attirant',
    'attirante',
    'attirantes',
    'attirants',
    'attiras',
    'attirasse',
    'attirassent',
    'attirasses',
    'attirassiez',
    'attirassions',
    'attire',
    'attirent',
    'attirer',
    'attirera',
    'attirerai',
    'attireraient',
    'attirerais',
    'attirerait',
    'attireras',
    'attirerez',
    'attireriez',
    'attirerions',
    'attirerons',
    'attireront',
    'attires',
    'attirez',
    'attiriez',
    'attirions',
    'attirons',
    'attirâmes',
    'attirât',
    'attirâtes',
    'attirèrent',
    'attiré',
    'attirée',
    'attirées',
    'attirés',
    'attisa',
    'attisai',
    'attisaient',
    'attisais',
    'attisait',
    'attisant',
    'attisas',
    'attisasse',
    'attisassent',
    'attisasses',
    'attisassiez',
    'attisassions',
    'attise',
    'attisement',
    'attisements',
    'attisent',
    'attiser',
    'attisera',
    'attiserai',
    'attiseraient',
    'attiserais',
    'attiserait',
    'attiseras',
    'attiserez',
    'attiseriez',
    'attiserions',
    'attiserons',
    'attiseront',
    'attises',
    'attisez',
    'attisiez',
    'attisions',
    'attisons',
    'attisâmes',
    'attisât',
    'attisâtes',
    'attisèrent',
    'attisé',
    'attisée',
    'attisées',
    'attisés',
    'attitra',
    'attitrai',
    'attitraient',
    'attitrais',
    'attitrait',
    'attitrant',
    'attitras',
    'attitrasse',
    'attitrassent',
    'attitrasses',
    'attitrassiez',
    'attitre',
    'attitrent',
    'attitrer',
    'attitrera',
    'attitrerai',
    'attitrerais',
    'attitrerait',
    'attitreras',
    'attitrerez',
    'attitreriez',
    'attitrerions',
    'attitrerons',
    'attitreront',
    'attitres',
    'attitrez',
    'attitriez',
    'attitrions',
    'attitrons',
    'attitrâmes',
    'attitrât',
    'attitrâtes',
    'attitrèrent',
    'attitré',
    'attitrée',
    'attitrées',
    'attitrés',
    'attitude',
    'attitudes',
    'attiédi',
    'attiédie',
    'attiédies',
    'attiédir',
    'attiédira',
    'attiédirai',
    'attiédirais',
    'attiédirait',
    'attiédiras',
    'attiédirent',
    'attiédirez',
    'attiédiriez',
    'attiédirions',
    'attiédirons',
    'attiédiront',
    'attiédis',
    'attiédissais',
    'attiédissait',
    'attiédissant',
    'attiédisse',
    'attiédissent',
    'attiédisses',
    'attiédissez',
    'attiédissiez',
    'attiédissons',
    'attiédit',
    'attiédîmes',
    'attiédît',
    'attiédîtes',
    'attorney',
    'attorneys',
    'attouchement',
    'attracteur',
    'attracteurs',
    'attractif',
    'attractifs',
    'attraction',
    'attractions',
    'attractive',
    'attractives',
    'attrait',
    'attraits',
    'attrapa',
    'attrapade',
    'attrapades',
    'attrapage',
    'attrapages',
    'attrapai',
    'attrapaient',
    'attrapais',
    'attrapait',
    'attrapant',
    'attrapas',
    'attrapasse',
    'attrapassent',
    'attrapasses',
    'attrapassiez',
    'attrape',
    'attrapent',
    'attraper',
    'attrapera',
    'attraperai',
    'attraperais',
    'attraperait',
    'attraperas',
    'attraperez',
    'attraperiez',
    'attraperions',
    'attraperons',
    'attraperont',
    'attrapes',
    'attrapez',
    'attrapiez',
    'attrapions',
    'attrapons',
    'attrapâmes',
    'attrapât',
    'attrapâtes',
    'attrapèrent',
    'attrapé',
    'attrapée',
    'attrapées',
    'attrapés',
    'attrayant',
    'attrayante',
    'attrayantes',
    'attrayants',
    'attremper',
    'attribua',
    'attribuable',
    'attribuables',
    'attribuai',
    'attribuaient',
    'attribuais',
    'attribuait',
    'attribuant',
    'attribuas',
    'attribuasse',
    'attribuasses',
    'attribue',
    'attribuent',
    'attribuer',
    'attribuera',
    'attribuerai',
    'attribuerais',
    'attribuerait',
    'attribueras',
    'attribuerez',
    'attribueriez',
    'attribuerons',
    'attribueront',
    'attribues',
    'attribuez',
    'attribuiez',
    'attribuions',
    'attribuons',
    'attribut',
    'attributaire',
    'attributif',
    'attributifs',
    'attribution',
    'attributions',
    'attributive',
    'attributives',
    'attributs',
    'attribuâmes',
    'attribuât',
    'attribuâtes',
    'attribuèrent',
    'attribué',
    'attribuée',
    'attribuées',
    'attribués',
    'attriqua',
    'attriquai',
    'attriquaient',
    'attriquais',
    'attriquait',
    'attriquant',
    'attriquas',
    'attriquasse',
    'attriquasses',
    'attrique',
    'attriquent',
    'attriquer',
    'attriquera',
    'attriquerai',
    'attriquerais',
    'attriquerait',
    'attriqueras',
    'attriquerez',
    'attriqueriez',
    'attriquerons',
    'attriqueront',
    'attriques',
    'attriquez',
    'attriquiez',
    'attriquions',
    'attriquons',
    'attriquâmes',
    'attriquât',
    'attriquâtes',
    'attriquèrent',
    'attriqué',
    'attriquée',
    'attriquées',
    'attriqués',
    'attrista',
    'attristai',
    'attristaient',
    'attristais',
    'attristait',
    'attristant',
    'attristante',
    'attristantes',
    'attristants',
    'attristas',
    'attristasse',
    'attristasses',
    'attriste',
    'attristent',
    'attrister',
    'attristera',
    'attristerai',
    'attristerais',
    'attristerait',
    'attristeras',
    'attristerez',
    'attristeriez',
    'attristerons',
    'attristeront',
    'attristes',
    'attristez',
    'attristiez',
    'attristions',
    'attristons',
    'attristâmes',
    'attristât',
    'attristâtes',
    'attristèrent',
    'attristé',
    'attristée',
    'attristées',
    'attristés',
    'attrition',
    'attritions',
    'attroupa',
    'attroupai',
    'attroupaient',
    'attroupais',
    'attroupait',
    'attroupant',
    'attroupas',
    'attroupasse',
    'attroupasses',
    'attroupe',
    'attroupement',
    'attroupent',
    'attrouper',
    'attroupera',
    'attrouperai',
    'attrouperais',
    'attrouperait',
    'attrouperas',
    'attrouperez',
    'attrouperiez',
    'attrouperons',
    'attrouperont',
    'attroupes',
    'attroupez',
    'attroupiez',
    'attroupions',
    'attroupons',
    'attroupâmes',
    'attroupât',
    'attroupâtes',
    'attroupèrent',
    'attroupé',
    'attroupée',
    'attroupées',
    'attroupés',
    'atténua',
    'atténuai',
    'atténuaient',
    'atténuais',
    'atténuait',
    'atténuant',
    'atténuante',
    'atténuantes',
    'atténuants',
    'atténuas',
    'atténuasse',
    'atténuassent',
    'atténuasses',
    'atténuassiez',
    'atténuateur',
    'atténuateurs',
    'atténuation',
    'atténuations',
    'atténue',
    'atténuent',
    'atténuer',
    'atténuera',
    'atténuerai',
    'atténuerais',
    'atténuerait',
    'atténueras',
    'atténuerez',
    'atténueriez',
    'atténuerions',
    'atténuerons',
    'atténueront',
    'atténues',
    'atténuez',
    'atténuiez',
    'atténuions',
    'atténuons',
    'atténuâmes',
    'atténuât',
    'atténuâtes',
    'atténuèrent',
    'atténué',
    'atténuée',
    'atténuées',
    'atténués',
    'atypique',
    'atypiques',
    'atèle',
    'atèles',
    'aubade',
    'aubades',
    'aubaine',
    'aubaines',
    'aube',
    'auberge',
    'auberges',
    'aubergine',
    'aubergines',
    'aubergiste',
    'aubergistes',
    'aubes',
    'aubette',
    'aubettes',
    'aubier',
    'aubiers',
    'aubin',
    'aubins',
    'auburn',
    'aubère',
    'aubères',
    'aubépine',
    'aubépines',
    'aucuba',
    'aucubas',
    'aucun',
    'aucune',
    'aucunement',
    'aucunes',
    'aucuns',
    'audace',
    'audaces',
    'audacieuse',
    'audacieuses',
    'audacieux',
    'audibilité',
    'audibilités',
    'audible',
    'audibles',
    'audience',
    'audiences',
    'audio',
    'audiogramme',
    'audiogrammes',
    'audiomètre',
    'audiomètres',
    'audiophone',
    'audiophones',
    'audiovisuel',
    'audiovisuels',
    'audit',
    'auditeur',
    'auditeurs',
    'auditif',
    'auditifs',
    'audition',
    'auditionna',
    'auditionnai',
    'auditionnais',
    'auditionnait',
    'auditionnant',
    'auditionnas',
    'auditionne',
    'auditionnent',
    'auditionner',
    'auditionnera',
    'auditionnes',
    'auditionnez',
    'auditionniez',
    'auditionnons',
    'auditionnât',
    'auditionné',
    'auditionnée',
    'auditionnées',
    'auditionnés',
    'auditions',
    'auditive',
    'auditives',
    'auditoire',
    'auditoires',
    'auditorat',
    'auditorats',
    'auditorium',
    'auditoriums',
    'auditrice',
    'auditrices',
    'audits',
    'auge',
    'auges',
    'auget',
    'augets',
    'augment',
    'augmenta',
    'augmentable',
    'augmentables',
    'augmentai',
    'augmentaient',
    'augmentais',
    'augmentait',
    'augmentant',
    'augmentas',
    'augmentasse',
    'augmentasses',
    'augmentatif',
    'augmentatifs',
    'augmentation',
    'augmentative',
    'augmente',
    'augmentent',
    'augmenter',
    'augmentera',
    'augmenterai',
    'augmenterais',
    'augmenterait',
    'augmenteras',
    'augmenterez',
    'augmenteriez',
    'augmenterons',
    'augmenteront',
    'augmentes',
    'augmentez',
    'augmentiez',
    'augmentions',
    'augmentons',
    'augments',
    'augmentâmes',
    'augmentât',
    'augmentâtes',
    'augmentèrent',
    'augmenté',
    'augmentée',
    'augmentées',
    'augmentés',
    'augura',
    'augurai',
    'auguraient',
    'augurais',
    'augurait',
    'augural',
    'augurale',
    'augurales',
    'augurant',
    'auguras',
    'augurasse',
    'augurassent',
    'augurasses',
    'augurassiez',
    'augurassions',
    'auguraux',
    'augure',
    'augurent',
    'augurer',
    'augurera',
    'augurerai',
    'augureraient',
    'augurerais',
    'augurerait',
    'augureras',
    'augurerez',
    'augureriez',
    'augurerions',
    'augurerons',
    'augureront',
    'augures',
    'augurez',
    'auguriez',
    'augurions',
    'augurons',
    'augurâmes',
    'augurât',
    'augurâtes',
    'augurèrent',
    'auguré',
    'augurée',
    'augurées',
    'augurés',
    'auguste',
    'augustes',
    'augustinien',
    'augustiniens',
    'aujourd',
    'aulne',
    'aulnes',
    'aumône',
    'aumônerie',
    'aumôneries',
    'aumônes',
    'aumônier',
    'aumôniers',
    'aumônière',
    'aumônières',
    'aune',
    'aunes',
    'auparavant',
    'auprès',
    'auquel',
    'aura',
    'aurai',
    'auraient',
    'aurais',
    'aurait',
    'aurantiacées',
    'auras',
    'aurez',
    'auriculaire',
    'auriculaires',
    'auricule',
    'auricules',
    'auriez',
    'aurifia',
    'aurifiai',
    'aurifiaient',
    'aurifiais',
    'aurifiait',
    'aurifiant',
    'aurifias',
    'aurifiasse',
    'aurifiassent',
    'aurifiasses',
    'aurifiassiez',
    'aurification',
    'aurifie',
    'aurifient',
    'aurifier',
    'aurifiera',
    'aurifierai',
    'aurifierais',
    'aurifierait',
    'aurifieras',
    'aurifierez',
    'aurifieriez',
    'aurifierions',
    'aurifierons',
    'aurifieront',
    'aurifies',
    'aurifiez',
    'aurifiiez',
    'aurifiions',
    'aurifions',
    'aurifiâmes',
    'aurifiât',
    'aurifiâtes',
    'aurifièrent',
    'aurifié',
    'aurifiée',
    'aurifiées',
    'aurifiés',
    'aurifère',
    'aurifères',
    'aurige',
    'auriges',
    'aurignacien',
    'aurignaciens',
    'aurions',
    'aurochs',
    'aurons',
    'auront',
    'aurore',
    'aurores',
    'auréola',
    'auréolai',
    'auréolaient',
    'auréolais',
    'auréolait',
    'auréolant',
    'auréolas',
    'auréolasse',
    'auréolassent',
    'auréolasses',
    'auréolassiez',
    'auréole',
    'auréolent',
    'auréoler',
    'auréolera',
    'auréolerai',
    'auréolerais',
    'auréolerait',
    'auréoleras',
    'auréolerez',
    'auréoleriez',
    'auréolerions',
    'auréolerons',
    'auréoleront',
    'auréoles',
    'auréolez',
    'auréoliez',
    'auréolions',
    'auréolons',
    'auréolâmes',
    'auréolât',
    'auréolâtes',
    'auréolèrent',
    'auréolé',
    'auréolée',
    'auréolées',
    'auréolés',
    'auréomycine',
    'auréomycines',
    'ausculta',
    'auscultai',
    'auscultaient',
    'auscultais',
    'auscultait',
    'auscultant',
    'auscultas',
    'auscultasse',
    'auscultasses',
    'auscultation',
    'ausculte',
    'auscultent',
    'ausculter',
    'auscultera',
    'ausculterai',
    'ausculterais',
    'ausculterait',
    'ausculteras',
    'ausculterez',
    'ausculteriez',
    'ausculterons',
    'ausculteront',
    'auscultes',
    'auscultez',
    'auscultiez',
    'auscultions',
    'auscultons',
    'auscultâmes',
    'auscultât',
    'auscultâtes',
    'auscultèrent',
    'ausculté',
    'auscultée',
    'auscultées',
    'auscultés',
    'auspices',
    'aussi',
    'aussitôt',
    'austral',
    'australe',
    'australes',
    'australien',
    'australienne',
    'australiens',
    'australs',
    'austraux',
    'austère',
    'austèrement',
    'austères',
    'austérité',
    'austérités',
    'autant',
    'autarcie',
    'autarcies',
    'autarcique',
    'autarciques',
    'autel',
    'autels',
    'auteur',
    'auteurs',
    'authenticité',
    'authentifia',
    'authentifiai',
    'authentifias',
    'authentifie',
    'authentifier',
    'authentifies',
    'authentifiez',
    'authentifiât',
    'authentifié',
    'authentifiée',
    'authentifiés',
    'authentiqua',
    'authentiquai',
    'authentiquas',
    'authentique',
    'authentiquer',
    'authentiques',
    'authentiquez',
    'authentiquât',
    'authentiqué',
    'authentiquée',
    'authentiqués',
    'autisme',
    'autismes',
    'autiste',
    'autistes',
    'autistique',
    'autistiques',
    'auto',
    'autoberge',
    'autoberges',
    'autobus',
    'autocar',
    'autocars',
    'autocassable',
    'autocensure',
    'autocensurer',
    'autocensures',
    'autochenille',
    'autochtone',
    'autochtones',
    'autoclave',
    'autoclaves',
    'autocollant',
    'autocollante',
    'autocollants',
    'autocopie',
    'autocopies',
    'autocrate',
    'autocrates',
    'autocratie',
    'autocraties',
    'autocratique',
    'autocritique',
    'autocuiseur',
    'autocuiseurs',
    'autodafé',
    'autodafés',
    'autodidacte',
    'autodidactes',
    'autodrome',
    'autodromes',
    'autodéfense',
    'autodéfenses',
    'autofinance',
    'autofinancer',
    'autofinances',
    'autofinancez',
    'autofinancé',
    'autofinancée',
    'autofinancés',
    'autofinança',
    'autofocus',
    'autogame',
    'autogames',
    'autogamie',
    'autogamies',
    'autogestion',
    'autogestions',
    'autogire',
    'autogires',
    'autographe',
    'autographes',
    'autographia',
    'autographiai',
    'autographias',
    'autographie',
    'autographier',
    'autographies',
    'autographiez',
    'autographiât',
    'autographié',
    'autographiée',
    'autographiés',
    'autoguidage',
    'autoguidages',
    'autoguider',
    'autoguiderez',
    'autoguidez',
    'autoguidiez',
    'autoguidions',
    'autoguidons',
    'autoguidâmes',
    'autoguidâtes',
    'autoguidé',
    'autoguidée',
    'autoguidées',
    'autoguidés',
    'autogène',
    'autogènes',
    'autogéré',
    'autogérée',
    'autogérées',
    'autogérés',
    'automate',
    'automates',
    'automation',
    'automations',
    'automatique',
    'automatiques',
    'automatisa',
    'automatisai',
    'automatisais',
    'automatisait',
    'automatisant',
    'automatisas',
    'automatise',
    'automatisent',
    'automatiser',
    'automatisera',
    'automatises',
    'automatisez',
    'automatisiez',
    'automatisme',
    'automatismes',
    'automatisons',
    'automatisât',
    'automatisé',
    'automatisée',
    'automatisées',
    'automatisés',
    'automnal',
    'automnale',
    'automnales',
    'automnaux',
    'automne',
    'automnes',
    'automobile',
    'automobiles',
    'automoteur',
    'automoteurs',
    'automotrice',
    'automotrices',
    'automédon',
    'automédons',
    'autoneige',
    'autoneiges',
    'autonome',
    'autonomes',
    'autonomie',
    'autonomies',
    'autonomiste',
    'autonomistes',
    'autonyme',
    'autonymes',
    'autoplastie',
    'autoplasties',
    'autopompe',
    'autopompes',
    'autoportant',
    'autoportante',
    'autoportants',
    'autoporteur',
    'autoporteurs',
    'autoporteuse',
    'autoportrait',
    'autopropulsé',
    'autopsia',
    'autopsiai',
    'autopsiaient',
    'autopsiais',
    'autopsiait',
    'autopsiant',
    'autopsias',
    'autopsiasse',
    'autopsiasses',
    'autopsie',
    'autopsient',
    'autopsier',
    'autopsiera',
    'autopsierai',
    'autopsierais',
    'autopsierait',
    'autopsieras',
    'autopsierez',
    'autopsieriez',
    'autopsierons',
    'autopsieront',
    'autopsies',
    'autopsiez',
    'autopsiiez',
    'autopsiions',
    'autopsions',
    'autopsiâmes',
    'autopsiât',
    'autopsiâtes',
    'autopsièrent',
    'autopsié',
    'autopsiée',
    'autopsiées',
    'autopsiés',
    'autopunition',
    'autoradio',
    'autoradios',
    'autorail',
    'autorails',
    'autorisa',
    'autorisai',
    'autorisaient',
    'autorisais',
    'autorisait',
    'autorisant',
    'autorisas',
    'autorisasse',
    'autorisasses',
    'autorisation',
    'autorise',
    'autorisent',
    'autoriser',
    'autorisera',
    'autoriserai',
    'autoriserais',
    'autoriserait',
    'autoriseras',
    'autoriserez',
    'autoriseriez',
    'autoriserons',
    'autoriseront',
    'autorises',
    'autorisez',
    'autorisiez',
    'autorisions',
    'autorisons',
    'autorisâmes',
    'autorisât',
    'autorisâtes',
    'autorisèrent',
    'autorisé',
    'autorisée',
    'autorisées',
    'autorisés',
    'autoritaire',
    'autoritaires',
    'autorité',
    'autorités',
    'autoroute',
    'autoroutes',
    'autoroutier',
    'autoroutiers',
    'autoroutière',
    'autoréglage',
    'autoréglages',
    'autos',
    'autoscopie',
    'autoscopies',
    'autotomie',
    'autotomies',
    'autotrophe',
    'autotrophes',
    'autour',
    'autovaccin',
    'autovaccins',
    'autre',
    'autrefois',
    'autrement',
    'autres',
    'autrichien',
    'autrichienne',
    'autrichiens',
    'autruche',
    'autruches',
    'autrui',
    'auvent',
    'auvents',
    'auvergnat',
    'auvergnate',
    'auvergnates',
    'auvergnats',
    'auxiliaire',
    'auxiliaires',
    'auxine',
    'auxines',
    'auxquelles',
    'auxquels',
    'avachi',
    'avachie',
    'avachies',
    'avachir',
    'avachira',
    'avachirai',
    'avachiraient',
    'avachirais',
    'avachirait',
    'avachiras',
    'avachirent',
    'avachirez',
    'avachiriez',
    'avachirions',
    'avachirons',
    'avachiront',
    'avachis',
    'avachissais',
    'avachissait',
    'avachissant',
    'avachisse',
    'avachissent',
    'avachisses',
    'avachissez',
    'avachissiez',
    'avachissions',
    'avachissons',
    'avachit',
    'avachîmes',
    'avachît',
    'avachîtes',
    'avaient',
    'avais',
    'avait',
    'aval',
    'avala',
    'avalai',
    'avalaient',
    'avalais',
    'avalait',
    'avalanche',
    'avalanches',
    'avalant',
    'avalas',
    'avalasse',
    'avalassent',
    'avalasses',
    'avalassiez',
    'avalassions',
    'avale',
    'avalent',
    'avaler',
    'avalera',
    'avalerai',
    'avaleraient',
    'avalerais',
    'avalerait',
    'avaleras',
    'avalerez',
    'avaleriez',
    'avalerions',
    'avalerons',
    'avaleront',
    'avales',
    'avaleur',
    'avaleurs',
    'avalez',
    'avaliez',
    'avalions',
    'avalisa',
    'avalisai',
    'avalisaient',
    'avalisais',
    'avalisait',
    'avalisant',
    'avalisas',
    'avalisasse',
    'avalisassent',
    'avalisasses',
    'avalisassiez',
    'avalise',
    'avalisent',
    'avaliser',
    'avalisera',
    'avaliserai',
    'avaliserais',
    'avaliserait',
    'avaliseras',
    'avaliserez',
    'avaliseriez',
    'avaliserions',
    'avaliserons',
    'avaliseront',
    'avalises',
    'avaliseur',
    'avaliseurs',
    'avalisez',
    'avalisiez',
    'avalisions',
    'avalisons',
    'avaliste',
    'avalistes',
    'avalisâmes',
    'avalisât',
    'avalisâtes',
    'avalisèrent',
    'avalisé',
    'avalisée',
    'avalisées',
    'avalisés',
    'avalons',
    'avals',
    'avalâmes',
    'avalât',
    'avalâtes',
    'avalèrent',
    'avalé',
    'avalée',
    'avalées',
    'avalés',
    'avance',
    'avancement',
    'avancements',
    'avancent',
    'avancer',
    'avancera',
    'avancerai',
    'avanceraient',
    'avancerais',
    'avancerait',
    'avanceras',
    'avancerez',
    'avanceriez',
    'avancerions',
    'avancerons',
    'avanceront',
    'avances',
    'avancez',
    'avanciez',
    'avancions',
    'avancèrent',
    'avancé',
    'avancée',
    'avancées',
    'avancés',
    'avanie',
    'avanies',
    'avant',
    'avantage',
    'avantagea',
    'avantageai',
    'avantageais',
    'avantageait',
    'avantageant',
    'avantageas',
    'avantageasse',
    'avantagent',
    'avantageons',
    'avantager',
    'avantagera',
    'avantagerai',
    'avantagerais',
    'avantagerait',
    'avantageras',
    'avantagerez',
    'avantageriez',
    'avantagerons',
    'avantageront',
    'avantages',
    'avantageuse',
    'avantageuses',
    'avantageux',
    'avantagez',
    'avantageâmes',
    'avantageât',
    'avantageâtes',
    'avantagiez',
    'avantagions',
    'avantagèrent',
    'avantagé',
    'avantagée',
    'avantagées',
    'avantagés',
    'avants',
    'avança',
    'avançai',
    'avançaient',
    'avançais',
    'avançait',
    'avançant',
    'avanças',
    'avançasse',
    'avançassent',
    'avançasses',
    'avançassiez',
    'avançassions',
    'avançons',
    'avançâmes',
    'avançât',
    'avançâtes',
    'avare',
    'avares',
    'avaria',
    'avariai',
    'avariaient',
    'avariais',
    'avariait',
    'avariant',
    'avarias',
    'avariasse',
    'avariassent',
    'avariasses',
    'avariassiez',
    'avariassions',
    'avarice',
    'avarices',
    'avaricieuse',
    'avaricieuses',
    'avaricieux',
    'avarie',
    'avarient',
    'avarier',
    'avariera',
    'avarierai',
    'avarieraient',
    'avarierais',
    'avarierait',
    'avarieras',
    'avarierez',
    'avarieriez',
    'avarierions',
    'avarierons',
    'avarieront',
    'avaries',
    'avariez',
    'avariiez',
    'avariions',
    'avarions',
    'avariâmes',
    'avariât',
    'avariâtes',
    'avarièrent',
    'avarié',
    'avariée',
    'avariées',
    'avariés',
    'avatar',
    'avatars',
    'avec',
    'aveline',
    'avelines',
    'avelinier',
    'aveliniers',
    'aven',
    'avenant',
    'avenante',
    'avenantes',
    'avenants',
    'avenir',
    'avenirs',
    'avens',
    'aventura',
    'aventurai',
    'aventuraient',
    'aventurais',
    'aventurait',
    'aventurant',
    'aventuras',
    'aventurasse',
    'aventurasses',
    'aventure',
    'aventurent',
    'aventurer',
    'aventurera',
    'aventurerai',
    'aventurerais',
    'aventurerait',
    'aventureras',
    'aventurerez',
    'aventureriez',
    'aventurerons',
    'aventureront',
    'aventures',
    'aventureuse',
    'aventureuses',
    'aventureux',
    'aventurez',
    'aventurier',
    'aventuriers',
    'aventuriez',
    'aventurine',
    'aventurines',
    'aventurions',
    'aventurisme',
    'aventurismes',
    'aventurière',
    'aventurières',
    'aventurons',
    'aventurâmes',
    'aventurât',
    'aventurâtes',
    'aventurèrent',
    'aventuré',
    'aventurée',
    'aventurées',
    'aventurés',
    'avenu',
    'avenue',
    'avenues',
    'avenus',
    'avers',
    'averse',
    'averses',
    'aversion',
    'aversions',
    'averti',
    'avertie',
    'averties',
    'avertir',
    'avertira',
    'avertirai',
    'avertiraient',
    'avertirais',
    'avertirait',
    'avertiras',
    'avertirent',
    'avertirez',
    'avertiriez',
    'avertirions',
    'avertirons',
    'avertiront',
    'avertis',
    'avertissais',
    'avertissait',
    'avertissant',
    'avertisse',
    'avertissent',
    'avertisses',
    'avertisseur',
    'avertisseurs',
    'avertisseuse',
    'avertissez',
    'avertissiez',
    'avertissions',
    'avertissons',
    'avertit',
    'avertîmes',
    'avertît',
    'avertîtes',
    'aveu',
    'aveugla',
    'aveuglai',
    'aveuglaient',
    'aveuglais',
    'aveuglait',
    'aveuglant',
    'aveuglante',
    'aveuglantes',
    'aveuglants',
    'aveuglas',
    'aveuglasse',
    'aveuglassent',
    'aveuglasses',
    'aveuglassiez',
    'aveugle',
    'aveuglement',
    'aveuglements',
    'aveuglent',
    'aveugler',
    'aveuglera',
    'aveuglerai',
    'aveuglerais',
    'aveuglerait',
    'aveugleras',
    'aveuglerez',
    'aveugleriez',
    'aveuglerions',
    'aveuglerons',
    'aveugleront',
    'aveugles',
    'aveuglette',
    'aveuglettes',
    'aveuglez',
    'aveugliez',
    'aveuglions',
    'aveuglons',
    'aveuglâmes',
    'aveuglât',
    'aveuglâtes',
    'aveuglèrent',
    'aveuglé',
    'aveuglée',
    'aveuglées',
    'aveuglément',
    'aveuglés',
    'aveuli',
    'aveulie',
    'aveulies',
    'aveulir',
    'aveulira',
    'aveulirai',
    'aveuliraient',
    'aveulirais',
    'aveulirait',
    'aveuliras',
    'aveulirent',
    'aveulirez',
    'aveuliriez',
    'aveulirions',
    'aveulirons',
    'aveuliront',
    'aveulis',
    'aveulissais',
    'aveulissait',
    'aveulissant',
    'aveulisse',
    'aveulissent',
    'aveulisses',
    'aveulissez',
    'aveulissiez',
    'aveulissions',
    'aveulissons',
    'aveulit',
    'aveulîmes',
    'aveulît',
    'aveulîtes',
    'aveux',
    'avez',
    'aviaire',
    'aviaires',
    'aviateur',
    'aviateurs',
    'aviation',
    'aviations',
    'aviatrice',
    'aviatrices',
    'avicole',
    'avicoles',
    'aviculteur',
    'aviculteurs',
    'avicultrice',
    'avicultrices',
    'aviculture',
    'avicultures',
    'avide',
    'avidement',
    'avides',
    'avidité',
    'avidités',
    'aviez',
    'avili',
    'avilie',
    'avilies',
    'avilir',
    'avilira',
    'avilirai',
    'aviliraient',
    'avilirais',
    'avilirait',
    'aviliras',
    'avilirent',
    'avilirez',
    'aviliriez',
    'avilirions',
    'avilirons',
    'aviliront',
    'avilis',
    'avilissaient',
    'avilissais',
    'avilissait',
    'avilissant',
    'avilissante',
    'avilissantes',
    'avilissants',
    'avilisse',
    'avilissement',
    'avilissent',
    'avilisses',
    'avilissez',
    'avilissiez',
    'avilissions',
    'avilissons',
    'avilit',
    'avilîmes',
    'avilît',
    'avilîtes',
    'avina',
    'avinai',
    'avinaient',
    'avinais',
    'avinait',
    'avinant',
    'avinas',
    'avinasse',
    'avinassent',
    'avinasses',
    'avinassiez',
    'avinassions',
    'avine',
    'avinent',
    'aviner',
    'avinera',
    'avinerai',
    'avineraient',
    'avinerais',
    'avinerait',
    'avineras',
    'avinerez',
    'avineriez',
    'avinerions',
    'avinerons',
    'avineront',
    'avines',
    'avinez',
    'aviniez',
    'avinions',
    'avinons',
    'avinâmes',
    'avinât',
    'avinâtes',
    'avinèrent',
    'aviné',
    'avinée',
    'avinées',
    'avinés',
    'avion',
    'avionique',
    'avioniques',
    'avionnette',
    'avionnettes',
    'avionneur',
    'avionneurs',
    'avions',
    'aviron',
    'avirons',
    'avis',
    'avisa',
    'avisai',
    'avisaient',
    'avisais',
    'avisait',
    'avisant',
    'avisas',
    'avisasse',
    'avisassent',
    'avisasses',
    'avisassiez',
    'avisassions',
    'avise',
    'avisent',
    'aviser',
    'avisera',
    'aviserai',
    'aviseraient',
    'aviserais',
    'aviserait',
    'aviseras',
    'aviserez',
    'aviseriez',
    'aviserions',
    'aviserons',
    'aviseront',
    'avises',
    'avisez',
    'avisiez',
    'avisions',
    'aviso',
    'avisons',
    'avisos',
    'avisâmes',
    'avisât',
    'avisâtes',
    'avisèrent',
    'avisé',
    'avisée',
    'avisées',
    'avisés',
    'avitailla',
    'avitaillai',
    'avitaillais',
    'avitaillait',
    'avitaillant',
    'avitaillas',
    'avitaillasse',
    'avitaille',
    'avitaillent',
    'avitailler',
    'avitaillera',
    'avitaillerai',
    'avitailleras',
    'avitaillerez',
    'avitailles',
    'avitailleur',
    'avitailleurs',
    'avitaillez',
    'avitailliez',
    'avitaillions',
    'avitaillons',
    'avitaillâmes',
    'avitaillât',
    'avitaillâtes',
    'avitaillé',
    'avitaillée',
    'avitaillées',
    'avitaillés',
    'avitaminose',
    'avitaminoses',
    'aviva',
    'avivage',
    'avivages',
    'avivai',
    'avivaient',
    'avivais',
    'avivait',
    'avivant',
    'avivas',
    'avivasse',
    'avivassent',
    'avivasses',
    'avivassiez',
    'avivassions',
    'avive',
    'avivement',
    'avivements',
    'avivent',
    'aviver',
    'avivera',
    'aviverai',
    'aviveraient',
    'aviverais',
    'aviverait',
    'aviveras',
    'aviverez',
    'aviveriez',
    'aviverions',
    'aviverons',
    'aviveront',
    'avives',
    'avivez',
    'aviviez',
    'avivions',
    'avivons',
    'avivâmes',
    'avivât',
    'avivâtes',
    'avivèrent',
    'avivé',
    'avivée',
    'avivées',
    'avivés',
    'avocaillon',
    'avocaillons',
    'avocasserie',
    'avocasseries',
    'avocassier',
    'avocassiers',
    'avocassière',
    'avocassières',
    'avocat',
    'avocate',
    'avocates',
    'avocatier',
    'avocatiers',
    'avocats',
    'avocette',
    'avocettes',
    'avoine',
    'avoines',
    'avoir',
    'avoirdupoids',
    'avoirs',
    'avoisina',
    'avoisinai',
    'avoisinaient',
    'avoisinais',
    'avoisinait',
    'avoisinant',
    'avoisinante',
    'avoisinantes',
    'avoisinants',
    'avoisinas',
    'avoisinasse',
    'avoisinasses',
    'avoisine',
    'avoisinent',
    'avoisiner',
    'avoisinera',
    'avoisinerai',
    'avoisinerais',
    'avoisinerait',
    'avoisineras',
    'avoisinerez',
    'avoisineriez',
    'avoisinerons',
    'avoisineront',
    'avoisines',
    'avoisinez',
    'avoisiniez',
    'avoisinions',
    'avoisinons',
    'avoisinâmes',
    'avoisinât',
    'avoisinâtes',
    'avoisinèrent',
    'avoisiné',
    'avoisinée',
    'avoisinées',
    'avoisinés',
    'avons',
    'avorta',
    'avortai',
    'avortaient',
    'avortais',
    'avortait',
    'avortant',
    'avortas',
    'avortasse',
    'avortassent',
    'avortasses',
    'avortassiez',
    'avortassions',
    'avorte',
    'avortement',
    'avortements',
    'avortent',
    'avorter',
    'avortera',
    'avorterai',
    'avorteraient',
    'avorterais',
    'avorterait',
    'avorteras',
    'avorterez',
    'avorteriez',
    'avorterions',
    'avorterons',
    'avorteront',
    'avortes',
    'avorteur',
    'avorteurs',
    'avorteuse',
    'avorteuses',
    'avortez',
    'avortiez',
    'avortions',
    'avorton',
    'avortons',
    'avortâmes',
    'avortât',
    'avortâtes',
    'avortèrent',
    'avorté',
    'avortée',
    'avortées',
    'avortés',
    'avoua',
    'avouable',
    'avouables',
    'avouai',
    'avouaient',
    'avouais',
    'avouait',
    'avouant',
    'avouas',
    'avouasse',
    'avouassent',
    'avouasses',
    'avouassiez',
    'avouassions',
    'avoue',
    'avouent',
    'avouer',
    'avouera',
    'avouerai',
    'avoueraient',
    'avouerais',
    'avouerait',
    'avoueras',
    'avouerez',
    'avoueriez',
    'avouerions',
    'avouerons',
    'avoueront',
    'avoues',
    'avouez',
    'avouiez',
    'avouions',
    'avouons',
    'avouâmes',
    'avouât',
    'avouâtes',
    'avouèrent',
    'avoué',
    'avouée',
    'avouées',
    'avoués',
    'avril',
    'avulsion',
    'avulsions',
    'avunculaire',
    'avunculaires',
    'avènement',
    'avènements',
    'avère',
    'avèrent',
    'avères',
    'avéra',
    'avérai',
    'avéraient',
    'avérais',
    'avérait',
    'avérant',
    'avéras',
    'avérasse',
    'avérassent',
    'avérasses',
    'avérassiez',
    'avérassions',
    'avérer',
    'avérera',
    'avérerai',
    'avéreraient',
    'avérerais',
    'avérerait',
    'avéreras',
    'avérerez',
    'avéreriez',
    'avérerions',
    'avérerons',
    'avéreront',
    'avérez',
    'avériez',
    'avérions',
    'avérons',
    'avérâmes',
    'avérât',
    'avérâtes',
    'avérèrent',
    'avéré',
    'avérée',
    'avérées',
    'avérés',
    'axai',
    'axaient',
    'axais',
    'axait',
    'axant',
    'axas',
    'axasse',
    'axassent',
    'axasses',
    'axassiez',
    'axassions',
    'axent',
    'axer',
    'axera',
    'axerai',
    'axeraient',
    'axerais',
    'axerait',
    'axeras',
    'axerez',
    'axeriez',
    'axerions',
    'axerons',
    'axeront',
    'axes',
    'axez',
    'axiale',
    'axiaux',
    'axiez',
    'axile',
    'axiles',
    'axillaire',
    'axillaires',
    'axiologie',
    'axiologies',
    'axiologique',
    'axiologiques',
    'axiomatisa',
    'axiomatisai',
    'axiomatisais',
    'axiomatisait',
    'axiomatisant',
    'axiomatisas',
    'axiomatise',
    'axiomatisent',
    'axiomatiser',
    'axiomatisera',
    'axiomatises',
    'axiomatisez',
    'axiomatisiez',
    'axiomatisons',
    'axiomatisât',
    'axiomatisé',
    'axiomatisée',
    'axiomatisées',
    'axiomatisés',
    'axiome',
    'axiomes',
    'axions',
    'axis',
    'axolotl',
    'axolotls',
    'axone',
    'axones',
    'axonge',
    'axonges',
    'axonométrie',
    'axonométries',
    'axons',
    'axâmes',
    'axât',
    'axâtes',
    'axèrent',
    'axée',
    'axées',
    'axés',
    'ayant',
    'ayatollah',
    'ayatollahs',
    'ayez',
    'ayons',
    'azalée',
    'azalées',
    'azerole',
    'azeroles',
    'azerolier',
    'azeroliers',
    'azimut',
    'azimutal',
    'azimutale',
    'azimutales',
    'azimutaux',
    'azimuts',
    'azimuté',
    'azimutée',
    'azimutées',
    'azimutés',
    'azoospermie',
    'azoospermies',
    'azotate',
    'azotates',
    'azote',
    'azotes',
    'azoteux',
    'azotique',
    'azotiques',
    'azotite',
    'azotites',
    'azoturie',
    'azoturies',
    'azoté',
    'azotée',
    'azotées',
    'azotémie',
    'azotémies',
    'azotés',
    'azoïque',
    'azoïques',
    'aztèque',
    'aztèques',
    'azulejo',
    'azulejos',
    'azur',
    'azura',
    'azurage',
    'azurages',
    'azurai',
    'azuraient',
    'azurais',
    'azurait',
    'azurant',
    'azurants',
    'azuras',
    'azurasse',
    'azurassent',
    'azurasses',
    'azurassiez',
    'azurassions',
    'azure',
    'azurent',
    'azurer',
    'azurera',
    'azurerai',
    'azureraient',
    'azurerais',
    'azurerait',
    'azureras',
    'azurerez',
    'azureriez',
    'azurerions',
    'azurerons',
    'azureront',
    'azures',
    'azurez',
    'azuriez',
    'azurions',
    'azurite',
    'azurites',
    'azurons',
    'azurs',
    'azurâmes',
    'azurât',
    'azurâtes',
    'azurèrent',
    'azuré',
    'azurée',
    'azurées',
    'azurés',
    'azygos',
    'azyme',
    'azymes',
    'aède',
    'aèdes',
    'aère',
    'aèrent',
    'aères',
    'aéra',
    'aérai',
    'aéraient',
    'aérais',
    'aérait',
    'aérant',
    'aéras',
    'aérasse',
    'aérassent',
    'aérasses',
    'aérassiez',
    'aérassions',
    'aérateur',
    'aérateurs',
    'aération',
    'aérations',
    'aérer',
    'aérera',
    'aérerai',
    'aéreraient',
    'aérerais',
    'aérerait',
    'aéreras',
    'aérerez',
    'aéreriez',
    'aérerions',
    'aérerons',
    'aéreront',
    'aérez',
    'aérien',
    'aérienne',
    'aériennes',
    'aériens',
    'aériez',
    'aérions',
    'aérobie',
    'aérobies',
    'aérodrome',
    'aérodromes',
    'aérogare',
    'aérogares',
    'aéroglisseur',
    'aérolite',
    'aérolites',
    'aérolithe',
    'aérolithes',
    'aérologie',
    'aérologies',
    'aéronaute',
    'aéronautes',
    'aéronautique',
    'aéronaval',
    'aéronavale',
    'aéronavales',
    'aéronavals',
    'aéronef',
    'aéronefs',
    'aérons',
    'aérophagie',
    'aérophagies',
    'aéroplane',
    'aéroplanes',
    'aéroport',
    'aéroports',
    'aéroporté',
    'aéroportée',
    'aéroportées',
    'aéroportés',
    'aérosol',
    'aérosols',
    'aérospatial',
    'aérospatiale',
    'aérospatiaux',
    'aérostat',
    'aérostats',
    'aérotrain',
    'aérotrains',
    'aérâmes',
    'aérât',
    'aérâtes',
    'aérèrent',
    'aéré',
    'aérée',
    'aérées',
    'aérés',
    'aînesse',
    'aînesses',
    'aîné',
    'aînée',
    'aînées',
    'aînés',
    'aïeul',
    'aïeule',
    'aïeules',
    'aïeuls',
    'aïeux',
    'aïkido',
    'aïkidos',
    'aïoli',
    'aïolis',
    'baba',
    'babas',
    'babeurre',
    'babeurres',
    'babil',
    'babilla',
    'babillage',
    'babillages',
    'babillai',
    'babillaient',
    'babillais',
    'babillait',
    'babillant',
    'babillard',
    'babillarde',
    'babillardes',
    'babillards',
    'babillas',
    'babillasse',
    'babillassent',
    'babillasses',
    'babillassiez',
    'babille',
    'babillent',
    'babiller',
    'babillera',
    'babillerai',
    'babillerais',
    'babillerait',
    'babilleras',
    'babillerez',
    'babilleriez',
    'babillerions',
    'babillerons',
    'babilleront',
    'babilles',
    'babillez',
    'babilliez',
    'babillions',
    'babillons',
    'babillâmes',
    'babillât',
    'babillâtes',
    'babillèrent',
    'babillé',
    'babils',
    'babine',
    'babines',
    'babiole',
    'babioles',
    'babiroussa',
    'babiroussas',
    'babouche',
    'babouches',
    'babouin',
    'babouins',
    'babouvisme',
    'babouvismes',
    'baby',
    'babys',
    'baccalauréat',
    'baccara',
    'baccarat',
    'bacchanale',
    'bacchanales',
    'bacchante',
    'bacchantes',
    'bacciforme',
    'bacciformes',
    'bachelier',
    'bacheliers',
    'bachelière',
    'bachelières',
    'bachique',
    'bachiques',
    'bachot',
    'bachota',
    'bachotage',
    'bachotages',
    'bachotai',
    'bachotaient',
    'bachotais',
    'bachotait',
    'bachotant',
    'bachotas',
    'bachotasse',
    'bachotassent',
    'bachotasses',
    'bachotassiez',
    'bachote',
    'bachotent',
    'bachoter',
    'bachotera',
    'bachoterai',
    'bachoterais',
    'bachoterait',
    'bachoteras',
    'bachoterez',
    'bachoteriez',
    'bachoterions',
    'bachoterons',
    'bachoteront',
    'bachotes',
    'bachotez',
    'bachotiez',
    'bachotions',
    'bachotons',
    'bachots',
    'bachotâmes',
    'bachotât',
    'bachotâtes',
    'bachotèrent',
    'bachoté',
    'bachotée',
    'bachotées',
    'bachotés',
    'bacillaire',
    'bacillaires',
    'bacille',
    'bacilles',
    'bacilliforme',
    'bacillose',
    'bacilloses',
    'bacon',
    'bacs',
    'bactéricide',
    'bactéricides',
    'bactéridie',
    'bactéridies',
    'bactérie',
    'bactérien',
    'bactérienne',
    'bactériennes',
    'bactériens',
    'bactéries',
    'bacul',
    'baculs',
    'badaud',
    'badaude',
    'badauderie',
    'badauderies',
    'badaudes',
    'badauds',
    'baderne',
    'badernes',
    'badge',
    'badges',
    'badiane',
    'badianes',
    'badigeon',
    'badigeonna',
    'badigeonnage',
    'badigeonnai',
    'badigeonnais',
    'badigeonnait',
    'badigeonnant',
    'badigeonnas',
    'badigeonne',
    'badigeonnent',
    'badigeonner',
    'badigeonnera',
    'badigeonnes',
    'badigeonneur',
    'badigeonnez',
    'badigeonniez',
    'badigeonnons',
    'badigeonnât',
    'badigeonné',
    'badigeonnée',
    'badigeonnées',
    'badigeonnés',
    'badigeons',
    'badin',
    'badina',
    'badinage',
    'badinages',
    'badinai',
    'badinaient',
    'badinais',
    'badinait',
    'badinant',
    'badinas',
    'badinasse',
    'badinassent',
    'badinasses',
    'badinassiez',
    'badinassions',
    'badine',
    'badinent',
    'badiner',
    'badinera',
    'badinerai',
    'badineraient',
    'badinerais',
    'badinerait',
    'badineras',
    'badinerez',
    'badinerie',
    'badineries',
    'badineriez',
    'badinerions',
    'badinerons',
    'badineront',
    'badines',
    'badinez',
    'badiniez',
    'badinions',
    'badinons',
    'badins',
    'badinâmes',
    'badinât',
    'badinâtes',
    'badinèrent',
    'badiné',
    'badminton',
    'baffa',
    'baffai',
    'baffaient',
    'baffais',
    'baffait',
    'baffant',
    'baffas',
    'baffasse',
    'baffassent',
    'baffasses',
    'baffassiez',
    'baffassions',
    'baffe',
    'baffent',
    'baffer',
    'baffera',
    'bafferai',
    'bafferaient',
    'bafferais',
    'bafferait',
    'bafferas',
    'bafferez',
    'bafferiez',
    'bafferions',
    'bafferons',
    'bafferont',
    'baffes',
    'baffez',
    'baffiez',
    'baffions',
    'baffle',
    'baffles',
    'baffons',
    'baffâmes',
    'baffât',
    'baffâtes',
    'baffèrent',
    'baffé',
    'baffée',
    'baffées',
    'baffés',
    'bafoua',
    'bafouai',
    'bafouaient',
    'bafouais',
    'bafouait',
    'bafouant',
    'bafouas',
    'bafouasse',
    'bafouassent',
    'bafouasses',
    'bafouassiez',
    'bafouassions',
    'bafoue',
    'bafouent',
    'bafouer',
    'bafouera',
    'bafouerai',
    'bafoueraient',
    'bafouerais',
    'bafouerait',
    'bafoueras',
    'bafouerez',
    'bafoueriez',
    'bafouerions',
    'bafouerons',
    'bafoueront',
    'bafoues',
    'bafouez',
    'bafouiez',
    'bafouilla',
    'bafouillage',
    'bafouillages',
    'bafouillai',
    'bafouillais',
    'bafouillait',
    'bafouillant',
    'bafouillas',
    'bafouillasse',
    'bafouille',
    'bafouillent',
    'bafouiller',
    'bafouillera',
    'bafouillerai',
    'bafouilleras',
    'bafouillerez',
    'bafouilles',
    'bafouilleur',
    'bafouilleurs',
    'bafouilleuse',
    'bafouillez',
    'bafouilliez',
    'bafouillions',
    'bafouillons',
    'bafouillâmes',
    'bafouillât',
    'bafouillâtes',
    'bafouillé',
    'bafouillée',
    'bafouillées',
    'bafouillés',
    'bafouions',
    'bafouons',
    'bafouâmes',
    'bafouât',
    'bafouâtes',
    'bafouèrent',
    'bafoué',
    'bafouée',
    'bafouées',
    'bafoués',
    'bagad',
    'bagads',
    'bagage',
    'bagages',
    'bagagiste',
    'bagagistes',
    'bagarra',
    'bagarrai',
    'bagarraient',
    'bagarrais',
    'bagarrait',
    'bagarrant',
    'bagarras',
    'bagarrasse',
    'bagarrassent',
    'bagarrasses',
    'bagarrassiez',
    'bagarre',
    'bagarrent',
    'bagarrer',
    'bagarrera',
    'bagarrerai',
    'bagarrerais',
    'bagarrerait',
    'bagarreras',
    'bagarrerez',
    'bagarreriez',
    'bagarrerions',
    'bagarrerons',
    'bagarreront',
    'bagarres',
    'bagarreur',
    'bagarreurs',
    'bagarreuse',
    'bagarreuses',
    'bagarrez',
    'bagarriez',
    'bagarrions',
    'bagarrons',
    'bagarrâmes',
    'bagarrât',
    'bagarrâtes',
    'bagarrèrent',
    'bagarré',
    'bagarrée',
    'bagarrées',
    'bagarrés',
    'bagasse',
    'bagasses',
    'bagatelle',
    'bagatelles',
    'bagnard',
    'bagnards',
    'bagne',
    'bagnes',
    'bagnole',
    'bagnoles',
    'bagou',
    'bagout',
    'bagua',
    'baguage',
    'baguages',
    'baguai',
    'baguaient',
    'baguais',
    'baguait',
    'baguant',
    'baguas',
    'baguasse',
    'baguassent',
    'baguasses',
    'baguassiez',
    'baguassions',
    'bague',
    'baguenauda',
    'baguenaudai',
    'baguenaudais',
    'baguenaudait',
    'baguenaudant',
    'baguenaudas',
    'baguenaude',
    'baguenaudent',
    'baguenauder',
    'baguenaudera',
    'baguenaudes',
    'baguenaudez',
    'baguenaudier',
    'baguenaudiez',
    'baguenaudons',
    'baguenaudât',
    'baguenaudé',
    'baguenaudée',
    'baguenaudées',
    'baguenaudés',
    'baguent',
    'baguer',
    'baguera',
    'baguerai',
    'bagueraient',
    'baguerais',
    'baguerait',
    'bagueras',
    'baguerez',
    'bagueriez',
    'baguerions',
    'baguerons',
    'bagueront',
    'bagues',
    'baguette',
    'baguettes',
    'baguez',
    'baguier',
    'baguiers',
    'baguiez',
    'baguions',
    'baguons',
    'baguâmes',
    'baguât',
    'baguâtes',
    'baguèrent',
    'bagué',
    'baguée',
    'baguées',
    'bagués',
    'bahut',
    'bahuts',
    'baie',
    'baient',
    'baiera',
    'baierai',
    'baieraient',
    'baierais',
    'baierait',
    'baieras',
    'baierez',
    'baieriez',
    'baierions',
    'baierons',
    'baieront',
    'baies',
    'baigna',
    'baignade',
    'baignades',
    'baignai',
    'baignaient',
    'baignais',
    'baignait',
    'baignant',
    'baignas',
    'baignasse',
    'baignassent',
    'baignasses',
    'baignassiez',
    'baignassions',
    'baigne',
    'baignent',
    'baigner',
    'baignera',
    'baignerai',
    'baigneraient',
    'baignerais',
    'baignerait',
    'baigneras',
    'baignerez',
    'baigneriez',
    'baignerions',
    'baignerons',
    'baigneront',
    'baignes',
    'baigneur',
    'baigneurs',
    'baigneuse',
    'baigneuses',
    'baignez',
    'baigniez',
    'baignions',
    'baignoire',
    'baignoires',
    'baignons',
    'baignâmes',
    'baignât',
    'baignâtes',
    'baignèrent',
    'baigné',
    'baignée',
    'baignées',
    'baignés',
    'bail',
    'bailla',
    'baillai',
    'baillaient',
    'baillais',
    'baillait',
    'baillant',
    'baillas',
    'baillasse',
    'baillassent',
    'baillasses',
    'baillassiez',
    'baillassions',
    'baille',
    'baillent',
    'bailler',
    'baillera',
    'baillerai',
    'bailleraient',
    'baillerais',
    'baillerait',
    'bailleras',
    'bailleresse',
    'bailleresses',
    'baillerez',
    'bailleriez',
    'baillerions',
    'baillerons',
    'bailleront',
    'bailles',
    'bailleur',
    'bailleurs',
    'baillez',
    'bailli',
    'bailliage',
    'bailliages',
    'bailliez',
    'baillions',
    'baillis',
    'baillons',
    'baillâmes',
    'baillât',
    'baillâtes',
    'baillèrent',
    'baillé',
    'baillée',
    'baillées',
    'baillés',
    'bain',
    'bains',
    'bais',
    'baisa',
    'baisai',
    'baisaient',
    'baisais',
    'baisait',
    'baisant',
    'baisas',
    'baisasse',
    'baisassent',
    'baisasses',
    'baisassiez',
    'baisassions',
    'baise',
    'baisemain',
    'baisemains',
    'baisement',
    'baisements',
    'baisent',
    'baiser',
    'baisera',
    'baiserai',
    'baiseraient',
    'baiserais',
    'baiserait',
    'baiseras',
    'baiserez',
    'baiseriez',
    'baiserions',
    'baiserons',
    'baiseront',
    'baisers',
    'baises',
    'baiseur',
    'baiseurs',
    'baiseuse',
    'baiseuses',
    'baisez',
    'baisiez',
    'baisions',
    'baisons',
    'baisota',
    'baisotai',
    'baisotaient',
    'baisotais',
    'baisotait',
    'baisotant',
    'baisotas',
    'baisotasse',
    'baisotassent',
    'baisotasses',
    'baisotassiez',
    'baisote',
    'baisotent',
    'baisoter',
    'baisotera',
    'baisoterai',
    'baisoterais',
    'baisoterait',
    'baisoteras',
    'baisoterez',
    'baisoteriez',
    'baisoterions',
    'baisoterons',
    'baisoteront',
    'baisotes',
    'baisotez',
    'baisotiez',
    'baisotions',
    'baisotons',
    'baisotâmes',
    'baisotât',
    'baisotâtes',
    'baisotèrent',
    'baisoté',
    'baisotée',
    'baisotées',
    'baisotés',
    'baissa',
    'baissai',
    'baissaient',
    'baissais',
    'baissait',
    'baissant',
    'baissas',
    'baissasse',
    'baissassent',
    'baissasses',
    'baissassiez',
    'baissassions',
    'baisse',
    'baissent',
    'baisser',
    'baissera',
    'baisserai',
    'baisseraient',
    'baisserais',
    'baisserait',
    'baisseras',
    'baisserez',
    'baisseriez',
    'baisserions',
    'baisserons',
    'baisseront',
    'baisses',
    'baissez',
    'baissier',
    'baissiers',
    'baissiez',
    'baissions',
    'baissière',
    'baissières',
    'baissons',
    'baissâmes',
    'baissât',
    'baissâtes',
    'baissèrent',
    'baissé',
    'baissée',
    'baissées',
    'baissés',
    'baisâmes',
    'baisât',
    'baisâtes',
    'baisèrent',
    'baisé',
    'baisée',
    'baisées',
    'baisés',
    'bajoue',
    'bajoues',
    'bajoyer',
    'bajoyers',
    'bakchich',
    'bakchichs',
    'baklava',
    'baklavas',
    'bakélite',
    'balada',
    'baladai',
    'baladaient',
    'baladais',
    'baladait',
    'baladant',
    'baladas',
    'baladasse',
    'baladassent',
    'baladasses',
    'baladassiez',
    'baladassions',
    'balade',
    'baladent',
    'balader',
    'baladera',
    'baladerai',
    'baladeraient',
    'baladerais',
    'baladerait',
    'baladeras',
    'baladerez',
    'baladeriez',
    'baladerions',
    'baladerons',
    'baladeront',
    'balades',
    'baladeur',
    'baladeurs',
    'baladeuse',
    'baladeuses',
    'baladez',
    'baladiez',
    'baladin',
    'baladins',
    'baladions',
    'baladons',
    'baladâmes',
    'baladât',
    'baladâtes',
    'baladèrent',
    'baladé',
    'baladée',
    'baladées',
    'baladés',
    'balafon',
    'balafons',
    'balafra',
    'balafrai',
    'balafraient',
    'balafrais',
    'balafrait',
    'balafrant',
    'balafras',
    'balafrasse',
    'balafrassent',
    'balafrasses',
    'balafrassiez',
    'balafre',
    'balafrent',
    'balafrer',
    'balafrera',
    'balafrerai',
    'balafrerais',
    'balafrerait',
    'balafreras',
    'balafrerez',
    'balafreriez',
    'balafrerions',
    'balafrerons',
    'balafreront',
    'balafres',
    'balafrez',
    'balafriez',
    'balafrions',
    'balafrons',
    'balafrâmes',
    'balafrât',
    'balafrâtes',
    'balafrèrent',
    'balafré',
    'balafrée',
    'balafrées',
    'balafrés',
    'balai',
    'balaie',
    'balaient',
    'balaiera',
    'balaierai',
    'balaieraient',
    'balaierais',
    'balaierait',
    'balaieras',
    'balaierez',
    'balaieriez',
    'balaierions',
    'balaierons',
    'balaieront',
    'balaies',
    'balais',
    'balalaïka',
    'balalaïkas',
    'balance',
    'balancelle',
    'balancelles',
    'balancement',
    'balancements',
    'balancent',
    'balancer',
    'balancera',
    'balancerai',
    'balancerais',
    'balancerait',
    'balanceras',
    'balancerez',
    'balanceriez',
    'balancerions',
    'balancerons',
    'balanceront',
    'balances',
    'balancez',
    'balancier',
    'balanciers',
    'balanciez',
    'balancine',
    'balancines',
    'balancions',
    'balancèrent',
    'balancé',
    'balancée',
    'balancées',
    'balancés',
    'balane',
    'balanes',
    'balanite',
    'balanites',
    'balança',
    'balançai',
    'balançaient',
    'balançais',
    'balançait',
    'balançant',
    'balanças',
    'balançasse',
    'balançassent',
    'balançasses',
    'balançassiez',
    'balançoire',
    'balançoires',
    'balançons',
    'balançâmes',
    'balançât',
    'balançâtes',
    'balata',
    'balatas',
    'balaya',
    'balayage',
    'balayages',
    'balayai',
    'balayaient',
    'balayais',
    'balayait',
    'balayant',
    'balayas',
    'balayasse',
    'balayassent',
    'balayasses',
    'balayassiez',
    'balayassions',
    'balaye',
    'balayent',
    'balayer',
    'balayera',
    'balayerai',
    'balayeraient',
    'balayerais',
    'balayerait',
    'balayeras',
    'balayerez',
    'balayeriez',
    'balayerions',
    'balayerons',
    'balayeront',
    'balayes',
    'balayette',
    'balayettes',
    'balayeur',
    'balayeurs',
    'balayeuse',
    'balayeuses',
    'balayez',
    'balayiez',
    'balayions',
    'balayons',
    'balayâmes',
    'balayât',
    'balayâtes',
    'balayèrent',
    'balayé',
    'balayée',
    'balayées',
    'balayés',
    'balbutia',
    'balbutiai',
    'balbutiaient',
    'balbutiais',
    'balbutiait',
    'balbutiant',
    'balbutiante',
    'balbutiantes',
    'balbutiants',
    'balbutias',
    'balbutiasse',
    'balbutiasses',
    'balbutie',
    'balbutiement',
    'balbutient',
    'balbutier',
    'balbutiera',
    'balbutierai',
    'balbutierais',
    'balbutierait',
    'balbutieras',
    'balbutierez',
    'balbutieriez',
    'balbutierons',
    'balbutieront',
    'balbuties',
    'balbutiez',
    'balbutiiez',
    'balbutiions',
    'balbutions',
    'balbutiâmes',
    'balbutiât',
    'balbutiâtes',
    'balbutièrent',
    'balbutié',
    'balbutiée',
    'balbutiées',
    'balbutiés',
    'balbuzard',
    'balbuzards',
    'balcon',
    'balconnet',
    'balconnets',
    'balcons',
    'baldaquin',
    'baldaquins',
    'baleina',
    'baleinai',
    'baleinaient',
    'baleinais',
    'baleinait',
    'baleinant',
    'baleinas',
    'baleinasse',
    'baleinassent',
    'baleinasses',
    'baleinassiez',
    'baleine',
    'baleineau',
    'baleineaux',
    'baleinent',
    'baleiner',
    'baleinera',
    'baleinerai',
    'baleinerais',
    'baleinerait',
    'baleineras',
    'baleinerez',
    'baleineriez',
    'baleinerions',
    'baleinerons',
    'baleineront',
    'baleines',
    'baleinez',
    'baleinier',
    'baleiniers',
    'baleiniez',
    'baleinions',
    'baleinière',
    'baleinières',
    'baleinons',
    'baleinâmes',
    'baleinât',
    'baleinâtes',
    'baleinèrent',
    'baleiné',
    'baleinée',
    'baleinées',
    'baleinés',
    'balisa',
    'balisage',
    'balisages',
    'balisai',
    'balisaient',
    'balisais',
    'balisait',
    'balisant',
    'balisas',
    'balisasse',
    'balisassent',
    'balisasses',
    'balisassiez',
    'balisassions',
    'balise',
    'balisent',
    'baliser',
    'balisera',
    'baliserai',
    'baliseraient',
    'baliserais',
    'baliserait',
    'baliseras',
    'baliserez',
    'baliseriez',
    'baliserions',
    'baliserons',
    'baliseront',
    'balises',
    'baliseur',
    'baliseurs',
    'balisez',
    'balisier',
    'balisiers',
    'balisiez',
    'balisions',
    'balisons',
    'baliste',
    'balistes',
    'balistique',
    'balistiques',
    'balisâmes',
    'balisât',
    'balisâtes',
    'balisèrent',
    'balisé',
    'balisée',
    'balisées',
    'balisés',
    'balivage',
    'balivages',
    'baliveau',
    'baliveaux',
    'baliverne',
    'balivernes',
    'balkanique',
    'balkaniques',
    'balkanisa',
    'balkanisai',
    'balkanisais',
    'balkanisait',
    'balkanisant',
    'balkanisas',
    'balkanisasse',
    'balkanise',
    'balkanisent',
    'balkaniser',
    'balkanisera',
    'balkaniserai',
    'balkaniseras',
    'balkaniserez',
    'balkanises',
    'balkanisez',
    'balkanisiez',
    'balkanisions',
    'balkanisons',
    'balkanisâmes',
    'balkanisât',
    'balkanisâtes',
    'balkanisé',
    'balkanisée',
    'balkanisées',
    'balkanisés',
    'balla',
    'ballade',
    'ballades',
    'ballai',
    'ballaient',
    'ballais',
    'ballait',
    'ballant',
    'ballante',
    'ballantes',
    'ballants',
    'ballas',
    'ballasse',
    'ballassent',
    'ballasses',
    'ballassiez',
    'ballassions',
    'ballast',
    'ballasta',
    'ballastage',
    'ballastages',
    'ballastai',
    'ballastaient',
    'ballastais',
    'ballastait',
    'ballastant',
    'ballastas',
    'ballastasse',
    'ballastasses',
    'ballaste',
    'ballastent',
    'ballaster',
    'ballastera',
    'ballasterai',
    'ballasterais',
    'ballasterait',
    'ballasteras',
    'ballasterez',
    'ballasteriez',
    'ballasterons',
    'ballasteront',
    'ballastes',
    'ballastez',
    'ballastiez',
    'ballastions',
    'ballastière',
    'ballastières',
    'ballastons',
    'ballasts',
    'ballastâmes',
    'ballastât',
    'ballastâtes',
    'ballastèrent',
    'ballasté',
    'ballastée',
    'ballastées',
    'ballastés',
    'balle',
    'ballent',
    'baller',
    'ballera',
    'ballerai',
    'balleraient',
    'ballerais',
    'ballerait',
    'balleras',
    'ballerez',
    'balleriez',
    'ballerine',
    'ballerines',
    'ballerions',
    'ballerons',
    'balleront',
    'balles',
    'ballet',
    'balletomane',
    'balletomanes',
    'ballets',
    'ballez',
    'balliez',
    'ballions',
    'ballon',
    'ballonna',
    'ballonnai',
    'ballonnaient',
    'ballonnais',
    'ballonnait',
    'ballonnant',
    'ballonnas',
    'ballonnasse',
    'ballonnasses',
    'ballonne',
    'ballonnement',
    'ballonnent',
    'ballonner',
    'ballonnera',
    'ballonnerai',
    'ballonnerais',
    'ballonnerait',
    'ballonneras',
    'ballonnerez',
    'ballonneriez',
    'ballonnerons',
    'ballonneront',
    'ballonnes',
    'ballonnet',
    'ballonnets',
    'ballonnez',
    'ballonniez',
    'ballonnions',
    'ballonnons',
    'ballonnâmes',
    'ballonnât',
    'ballonnâtes',
    'ballonnèrent',
    'ballonné',
    'ballonnée',
    'ballonnées',
    'ballonnés',
    'ballons',
    'ballot',
    'ballote',
    'ballotes',
    'ballots',
    'ballotta',
    'ballottage',
    'ballottages',
    'ballottai',
    'ballottaient',
    'ballottais',
    'ballottait',
    'ballottant',
    'ballottas',
    'ballottasse',
    'ballottasses',
    'ballotte',
    'ballottement',
    'ballottent',
    'ballotter',
    'ballottera',
    'ballotterai',
    'ballotterais',
    'ballotterait',
    'ballotteras',
    'ballotterez',
    'ballotteriez',
    'ballotterons',
    'ballotteront',
    'ballottes',
    'ballottez',
    'ballottiez',
    'ballottine',
    'ballottines',
    'ballottions',
    'ballottons',
    'ballottâmes',
    'ballottât',
    'ballottâtes',
    'ballottèrent',
    'ballotté',
    'ballottée',
    'ballottées',
    'ballottés',
    'balluchon',
    'balluchons',
    'ballâmes',
    'ballât',
    'ballâtes',
    'ballèrent',
    'ballé',
    'balnéaire',
    'balnéaires',
    'balnéation',
    'balnéations',
    'balourd',
    'balourde',
    'balourdes',
    'balourdise',
    'balourdises',
    'balourds',
    'bals',
    'balsa',
    'balsamier',
    'balsamiers',
    'balsamine',
    'balsamines',
    'balsamique',
    'balsamiques',
    'balte',
    'baltes',
    'balthazar',
    'balthazars',
    'baluchon',
    'baluchons',
    'balustrade',
    'balustrades',
    'balustre',
    'balustres',
    'balzan',
    'balzane',
    'balzanes',
    'balzans',
    'balès',
    'balèvre',
    'balèvres',
    'bambin',
    'bambins',
    'bambocha',
    'bambochai',
    'bambochaient',
    'bambochais',
    'bambochait',
    'bambochant',
    'bambochas',
    'bambochasse',
    'bambochasses',
    'bamboche',
    'bambochent',
    'bambocher',
    'bambochera',
    'bambocherai',
    'bambocherais',
    'bambocherait',
    'bambocheras',
    'bambocherez',
    'bambocheriez',
    'bambocherons',
    'bambocheront',
    'bamboches',
    'bambocheur',
    'bambocheurs',
    'bambocheuse',
    'bambocheuses',
    'bambochez',
    'bambochiez',
    'bambochions',
    'bambochons',
    'bambochâmes',
    'bambochât',
    'bambochâtes',
    'bambochèrent',
    'bamboché',
    'bambou',
    'bamboula',
    'bamboulas',
    'bambous',
    'banal',
    'banale',
    'banalement',
    'banales',
    'banalisa',
    'banalisai',
    'banalisaient',
    'banalisais',
    'banalisait',
    'banalisant',
    'banalisas',
    'banalisasse',
    'banalisasses',
    'banalisation',
    'banalise',
    'banalisent',
    'banaliser',
    'banalisera',
    'banaliserai',
    'banaliserais',
    'banaliserait',
    'banaliseras',
    'banaliserez',
    'banaliseriez',
    'banaliserons',
    'banaliseront',
    'banalises',
    'banalisez',
    'banalisiez',
    'banalisions',
    'banalisons',
    'banalisâmes',
    'banalisât',
    'banalisâtes',
    'banalisèrent',
    'banalisé',
    'banalisée',
    'banalisées',
    'banalisés',
    'banalité',
    'banalités',
    'banals',
    'banane',
    'bananeraie',
    'bananeraies',
    'bananes',
    'bananier',
    'bananiers',
    'banaux',
    'banc',
    'bancable',
    'bancables',
    'bancaire',
    'bancaires',
    'bancal',
    'bancale',
    'bancales',
    'bancals',
    'banche',
    'bancher',
    'banches',
    'banco',
    'bancos',
    'bancroche',
    'bancroches',
    'bancs',
    'banda',
    'bandage',
    'bandages',
    'bandagiste',
    'bandagistes',
    'bandai',
    'bandaient',
    'bandais',
    'bandait',
    'bandant',
    'bandas',
    'bandasse',
    'bandassent',
    'bandasses',
    'bandassiez',
    'bandassions',
    'bande',
    'bandeau',
    'bandeaux',
    'bandelette',
    'bandelettes',
    'bandent',
    'bander',
    'bandera',
    'banderai',
    'banderaient',
    'banderais',
    'banderait',
    'banderas',
    'banderez',
    'banderiez',
    'banderille',
    'banderillero',
    'banderilles',
    'banderions',
    'banderole',
    'banderoles',
    'banderons',
    'banderont',
    'bandes',
    'bandez',
    'bandiez',
    'bandions',
    'bandit',
    'banditisme',
    'banditismes',
    'bandits',
    'bandons',
    'bandonéon',
    'bandonéons',
    'bandoulière',
    'bandoulières',
    'bandâmes',
    'bandât',
    'bandâtes',
    'bandèrent',
    'bandé',
    'bandée',
    'bandées',
    'bandés',
    'bang',
    'bangs',
    'banian',
    'banians',
    'banjo',
    'banjos',
    'banjoïste',
    'banjoïstes',
    'banlieue',
    'banlieues',
    'banlieusard',
    'banlieusarde',
    'banlieusards',
    'banlon',
    'banlons',
    'banna',
    'bannai',
    'bannaient',
    'bannais',
    'bannait',
    'bannant',
    'bannas',
    'bannasse',
    'bannassent',
    'bannasses',
    'bannassiez',
    'bannassions',
    'banne',
    'bannent',
    'banner',
    'bannera',
    'bannerai',
    'banneraient',
    'bannerais',
    'bannerait',
    'banneras',
    'banneret',
    'bannerets',
    'bannerez',
    'banneriez',
    'bannerions',
    'bannerons',
    'banneront',
    'bannes',
    'banneton',
    'bannetons',
    'bannette',
    'bannettes',
    'bannez',
    'banni',
    'bannie',
    'bannies',
    'banniez',
    'bannions',
    'bannir',
    'bannira',
    'bannirai',
    'banniraient',
    'bannirais',
    'bannirait',
    'banniras',
    'bannirent',
    'bannirez',
    'banniriez',
    'bannirions',
    'bannirons',
    'banniront',
    'bannis',
    'bannissaient',
    'bannissais',
    'bannissait',
    'bannissant',
    'bannisse',
    'bannissement',
    'bannissent',
    'bannisses',
    'bannissez',
    'bannissiez',
    'bannissions',
    'bannissons',
    'bannit',
    'bannière',
    'bannières',
    'bannons',
    'bannâmes',
    'bannât',
    'bannâtes',
    'bannèrent',
    'banné',
    'bannée',
    'bannées',
    'bannés',
    'bannîmes',
    'bannît',
    'bannîtes',
    'banqua',
    'banquai',
    'banquaient',
    'banquais',
    'banquait',
    'banquant',
    'banquas',
    'banquasse',
    'banquassent',
    'banquasses',
    'banquassiez',
    'banquassions',
    'banque',
    'banquent',
    'banquer',
    'banquera',
    'banquerai',
    'banqueraient',
    'banquerais',
    'banquerait',
    'banqueras',
    'banquerez',
    'banqueriez',
    'banquerions',
    'banquerons',
    'banqueront',
    'banqueroute',
    'banqueroutes',
    'banques',
    'banquet',
    'banqueta',
    'banquetai',
    'banquetaient',
    'banquetais',
    'banquetait',
    'banquetant',
    'banquetas',
    'banquetasse',
    'banquetasses',
    'banqueter',
    'banqueteur',
    'banqueteurs',
    'banquetez',
    'banquetiez',
    'banquetions',
    'banquetons',
    'banquets',
    'banquette',
    'banquettent',
    'banquettera',
    'banquetterai',
    'banquetteras',
    'banquetterez',
    'banquettes',
    'banquetâmes',
    'banquetât',
    'banquetâtes',
    'banquetèrent',
    'banqueté',
    'banquez',
    'banquier',
    'banquiers',
    'banquiez',
    'banquions',
    'banquise',
    'banquises',
    'banquiste',
    'banquistes',
    'banquière',
    'banquières',
    'banquons',
    'banquâmes',
    'banquât',
    'banquâtes',
    'banquèrent',
    'banqué',
    'banquée',
    'banquées',
    'banqués',
    'bans',
    'bantou',
    'bantoue',
    'bantoues',
    'bantous',
    'baobab',
    'baobabs',
    'baptisa',
    'baptisai',
    'baptisaient',
    'baptisais',
    'baptisait',
    'baptisant',
    'baptisas',
    'baptisasse',
    'baptisassent',
    'baptisasses',
    'baptisassiez',
    'baptise',
    'baptisent',
    'baptiser',
    'baptisera',
    'baptiserai',
    'baptiserais',
    'baptiserait',
    'baptiseras',
    'baptiserez',
    'baptiseriez',
    'baptiserions',
    'baptiserons',
    'baptiseront',
    'baptises',
    'baptisez',
    'baptisiez',
    'baptisions',
    'baptismal',
    'baptismale',
    'baptismales',
    'baptismaux',
    'baptisme',
    'baptismes',
    'baptisons',
    'baptistaire',
    'baptistaires',
    'baptiste',
    'baptistes',
    'baptisâmes',
    'baptisât',
    'baptisâtes',
    'baptisèrent',
    'baptisé',
    'baptisée',
    'baptisées',
    'baptisés',
    'baptême',
    'baptêmes',
    'baquet',
    'baqueta',
    'baquetai',
    'baquetaient',
    'baquetais',
    'baquetait',
    'baquetant',
    'baquetas',
    'baquetasse',
    'baquetassent',
    'baquetasses',
    'baquetassiez',
    'baqueter',
    'baquetez',
    'baquetiez',
    'baquetions',
    'baquetons',
    'baquets',
    'baquette',
    'baquettent',
    'baquettera',
    'baquetterai',
    'baquetterais',
    'baquetterait',
    'baquetteras',
    'baquetterez',
    'baquetteriez',
    'baquetterons',
    'baquetteront',
    'baquettes',
    'baquetures',
    'baquetâmes',
    'baquetât',
    'baquetâtes',
    'baquetèrent',
    'baqueté',
    'baquetée',
    'baquetées',
    'baquetés',
    'baragouin',
    'baragouina',
    'baragouinage',
    'baragouinai',
    'baragouinais',
    'baragouinait',
    'baragouinant',
    'baragouinas',
    'baragouine',
    'baragouinent',
    'baragouiner',
    'baragouinera',
    'baragouines',
    'baragouineur',
    'baragouinez',
    'baragouiniez',
    'baragouinons',
    'baragouins',
    'baragouinât',
    'baragouiné',
    'baragouinée',
    'baragouinées',
    'baragouinés',
    'baraka',
    'barakas',
    'baraqua',
    'baraquai',
    'baraquaient',
    'baraquais',
    'baraquait',
    'baraquant',
    'baraquas',
    'baraquasse',
    'baraquassent',
    'baraquasses',
    'baraquassiez',
    'baraque',
    'baraquement',
    'baraquements',
    'baraquent',
    'baraquer',
    'baraquera',
    'baraquerai',
    'baraquerais',
    'baraquerait',
    'baraqueras',
    'baraquerez',
    'baraqueriez',
    'baraquerions',
    'baraquerons',
    'baraqueront',
    'baraques',
    'baraquez',
    'baraquiez',
    'baraquions',
    'baraquons',
    'baraquâmes',
    'baraquât',
    'baraquâtes',
    'baraquèrent',
    'baraqué',
    'baraterie',
    'barateries',
    'baratin',
    'baratina',
    'baratinai',
    'baratinaient',
    'baratinais',
    'baratinait',
    'baratinant',
    'baratinas',
    'baratinasse',
    'baratinasses',
    'baratine',
    'baratinent',
    'baratiner',
    'baratinera',
    'baratinerai',
    'baratinerais',
    'baratinerait',
    'baratineras',
    'baratinerez',
    'baratineriez',
    'baratinerons',
    'baratineront',
    'baratines',
    'baratineur',
    'baratineurs',
    'baratineuse',
    'baratineuses',
    'baratinez',
    'baratiniez',
    'baratinions',
    'baratinons',
    'baratinâmes',
    'baratinât',
    'baratinâtes',
    'baratinèrent',
    'baratiné',
    'baratinée',
    'baratinées',
    'baratinés',
    'baratta',
    'barattage',
    'barattages',
    'barattai',
    'barattaient',
    'barattais',
    'barattait',
    'barattant',
    'barattas',
    'barattasse',
    'barattassent',
    'barattasses',
    'barattassiez',
    'baratte',
    'barattent',
    'baratter',
    'barattera',
    'baratterai',
    'baratterais',
    'baratterait',
    'baratteras',
    'baratterez',
    'baratteriez',
    'baratterions',
    'baratterons',
    'baratteront',
    'barattes',
    'barattez',
    'barattiez',
    'barattions',
    'barattons',
    'barattâmes',
    'barattât',
    'barattâtes',
    'barattèrent',
    'baratté',
    'barattée',
    'barattées',
    'barattés',
    'barba',
    'barbacane',
    'barbacanes',
    'barbai',
    'barbaient',
    'barbais',
    'barbait',
    'barbant',
    'barbante',
    'barbantes',
    'barbants',
    'barbaque',
    'barbaques',
    'barbare',
    'barbares',
    'barbaresque',
    'barbaresques',
    'barbarie',
    'barbaries',
    'barbarisme',
    'barbarismes',
    'barbas',
    'barbasse',
    'barbassent',
    'barbasses',
    'barbassiez',
    'barbassions',
    'barbe',
    'barbeau',
    'barbeaux',
    'barbecue',
    'barbecues',
    'barbelure',
    'barbelures',
    'barbelé',
    'barbelée',
    'barbelées',
    'barbelés',
    'barbent',
    'barber',
    'barbera',
    'barberai',
    'barberaient',
    'barberais',
    'barberait',
    'barberas',
    'barberez',
    'barberiez',
    'barberions',
    'barberons',
    'barberont',
    'barbes',
    'barbet',
    'barbets',
    'barbette',
    'barbettes',
    'barbez',
    'barbiche',
    'barbiches',
    'barbichette',
    'barbichettes',
    'barbier',
    'barbiers',
    'barbiez',
    'barbifia',
    'barbifiai',
    'barbifiaient',
    'barbifiais',
    'barbifiait',
    'barbifiant',
    'barbifias',
    'barbifiasse',
    'barbifiasses',
    'barbifie',
    'barbifient',
    'barbifier',
    'barbifiera',
    'barbifierai',
    'barbifierais',
    'barbifierait',
    'barbifieras',
    'barbifierez',
    'barbifieriez',
    'barbifierons',
    'barbifieront',
    'barbifies',
    'barbifiez',
    'barbifiiez',
    'barbifiions',
    'barbifions',
    'barbifiâmes',
    'barbifiât',
    'barbifiâtes',
    'barbifièrent',
    'barbifié',
    'barbifiée',
    'barbifiées',
    'barbifiés',
    'barbille',
    'barbilles',
    'barbillon',
    'barbillons',
    'barbions',
    'barbital',
    'barbitals',
    'barbiturique',
    'barbiturisme',
    'barbon',
    'barbons',
    'barbota',
    'barbotage',
    'barbotages',
    'barbotai',
    'barbotaient',
    'barbotais',
    'barbotait',
    'barbotant',
    'barbotas',
    'barbotasse',
    'barbotassent',
    'barbotasses',
    'barbotassiez',
    'barbote',
    'barbotent',
    'barboter',
    'barbotera',
    'barboterai',
    'barboterais',
    'barboterait',
    'barboteras',
    'barboterez',
    'barboteriez',
    'barboterions',
    'barboterons',
    'barboteront',
    'barbotes',
    'barboteur',
    'barboteurs',
    'barboteuse',
    'barboteuses',
    'barbotez',
    'barbotiez',
    'barbotin',
    'barbotine',
    'barbotines',
    'barbotins',
    'barbotions',
    'barbotière',
    'barbotières',
    'barbotons',
    'barbotâmes',
    'barbotât',
    'barbotâtes',
    'barbotèrent',
    'barboté',
    'barbotée',
    'barbotées',
    'barbotés',
    'barbouilla',
    'barbouillage',
    'barbouillai',
    'barbouillais',
    'barbouillait',
    'barbouillant',
    'barbouillas',
    'barbouille',
    'barbouillent',
    'barbouiller',
    'barbouillera',
    'barbouilles',
    'barbouilleur',
    'barbouillez',
    'barbouilliez',
    'barbouillons',
    'barbouillât',
    'barbouillé',
    'barbouillée',
    'barbouillées',
    'barbouillés',
    'barbouze',
    'barbouzes',
    'barbu',
    'barbue',
    'barbues',
    'barbule',
    'barbules',
    'barbus',
    'barbâmes',
    'barbât',
    'barbâtes',
    'barbèrent',
    'barbé',
    'barbée',
    'barbées',
    'barbés',
    'barcarolle',
    'barcarolles',
    'barcasse',
    'barcasses',
    'bard',
    'barda',
    'bardage',
    'bardages',
    'bardai',
    'bardaient',
    'bardais',
    'bardait',
    'bardane',
    'bardanes',
    'bardant',
    'bardas',
    'bardasse',
    'bardassent',
    'bardasses',
    'bardassiez',
    'bardassions',
    'barde',
    'bardeau',
    'bardeaux',
    'bardent',
    'barder',
    'bardera',
    'barderai',
    'barderaient',
    'barderais',
    'barderait',
    'barderas',
    'barderez',
    'barderiez',
    'barderions',
    'barderons',
    'barderont',
    'bardes',
    'bardez',
    'bardiez',
    'bardions',
    'bardis',
    'bardons',
    'bardot',
    'bardots',
    'bards',
    'bardâmes',
    'bardât',
    'bardâtes',
    'bardèrent',
    'bardé',
    'bardée',
    'bardées',
    'bardés',
    'barge',
    'barges',
    'barguigna',
    'barguignai',
    'barguignais',
    'barguignait',
    'barguignant',
    'barguignas',
    'barguignasse',
    'barguigne',
    'barguignent',
    'barguigner',
    'barguignera',
    'barguignerai',
    'barguigneras',
    'barguignerez',
    'barguignes',
    'barguignez',
    'barguigniez',
    'barguignions',
    'barguignons',
    'barguignâmes',
    'barguignât',
    'barguignâtes',
    'barguigné',
    'baril',
    'barillet',
    'barillets',
    'barils',
    'bariola',
    'bariolage',
    'bariolages',
    'bariolai',
    'bariolaient',
    'bariolais',
    'bariolait',
    'bariolant',
    'bariolas',
    'bariolasse',
    'bariolassent',
    'bariolasses',
    'bariolassiez',
    'bariole',
    'bariolent',
    'barioler',
    'bariolera',
    'bariolerai',
    'bariolerais',
    'bariolerait',
    'barioleras',
    'bariolerez',
    'barioleriez',
    'bariolerions',
    'bariolerons',
    'barioleront',
    'barioles',
    'bariolez',
    'barioliez',
    'bariolions',
    'bariolons',
    'bariolure',
    'bariolures',
    'bariolâmes',
    'bariolât',
    'bariolâtes',
    'bariolèrent',
    'bariolé',
    'bariolée',
    'bariolées',
    'bariolés',
    'barlong',
    'barlongs',
    'barlongue',
    'barlongues',
    'barlotière',
    'barlotières',
    'barmaid',
    'barmaids',
    'barman',
    'barmans',
    'barmen',
    'barn',
    'barnabite',
    'barnabites',
    'barns',
    'barographe',
    'barographes',
    'baromètre',
    'baromètres',
    'barométrique',
    'baron',
    'baronna',
    'baronnage',
    'baronnages',
    'baronnai',
    'baronnaient',
    'baronnais',
    'baronnait',
    'baronnant',
    'baronnas',
    'baronnasse',
    'baronnassent',
    'baronnasses',
    'baronnassiez',
    'baronne',
    'baronnent',
    'baronner',
    'baronnera',
    'baronnerai',
    'baronnerais',
    'baronnerait',
    'baronneras',
    'baronnerez',
    'baronneriez',
    'baronnerions',
    'baronnerons',
    'baronneront',
    'baronnes',
    'baronnet',
    'baronnets',
    'baronnette',
    'baronnettes',
    'baronnez',
    'baronnie',
    'baronnies',
    'baronniez',
    'baronnions',
    'baronnons',
    'baronnâmes',
    'baronnât',
    'baronnâtes',
    'baronnèrent',
    'baronné',
    'baronnée',
    'baronnées',
    'baronnés',
    'barons',
    'baroque',
    'baroques',
    'baroquisme',
    'baroquismes',
    'baroscope',
    'baroscopes',
    'baroud',
    'barouda',
    'baroudai',
    'baroudaient',
    'baroudais',
    'baroudait',
    'baroudant',
    'baroudas',
    'baroudasse',
    'baroudassent',
    'baroudasses',
    'baroudassiez',
    'baroude',
    'baroudent',
    'barouder',
    'baroudera',
    'barouderai',
    'barouderais',
    'barouderait',
    'barouderas',
    'barouderez',
    'barouderiez',
    'barouderions',
    'barouderons',
    'barouderont',
    'baroudes',
    'baroudeur',
    'baroudeurs',
    'baroudez',
    'baroudiez',
    'baroudions',
    'baroudons',
    'barouds',
    'baroudâmes',
    'baroudât',
    'baroudâtes',
    'baroudèrent',
    'baroudé',
    'barouf',
    'baroufle',
    'baroufles',
    'baroufs',
    'barque',
    'barques',
    'barquette',
    'barquettes',
    'barra',
    'barracuda',
    'barracudas',
    'barrage',
    'barrages',
    'barrai',
    'barraient',
    'barrais',
    'barrait',
    'barrant',
    'barras',
    'barrasse',
    'barrassent',
    'barrasses',
    'barrassiez',
    'barrassions',
    'barre',
    'barreau',
    'barreaux',
    'barrement',
    'barrements',
    'barrent',
    'barrer',
    'barrera',
    'barrerai',
    'barreraient',
    'barrerais',
    'barrerait',
    'barreras',
    'barrerez',
    'barreriez',
    'barrerions',
    'barrerons',
    'barreront',
    'barres',
    'barrette',
    'barrettes',
    'barreur',
    'barreurs',
    'barreuse',
    'barreuses',
    'barrez',
    'barri',
    'barricada',
    'barricadai',
    'barricadais',
    'barricadait',
    'barricadant',
    'barricadas',
    'barricadasse',
    'barricade',
    'barricadent',
    'barricader',
    'barricadera',
    'barricaderai',
    'barricaderas',
    'barricaderez',
    'barricades',
    'barricadez',
    'barricadiez',
    'barricadions',
    'barricadons',
    'barricadâmes',
    'barricadât',
    'barricadâtes',
    'barricadé',
    'barricadée',
    'barricadées',
    'barricadés',
    'barriez',
    'barrions',
    'barrique',
    'barriques',
    'barrir',
    'barrira',
    'barrirai',
    'barriraient',
    'barrirais',
    'barrirait',
    'barriras',
    'barrirent',
    'barrirez',
    'barririez',
    'barririons',
    'barrirons',
    'barriront',
    'barris',
    'barrissaient',
    'barrissais',
    'barrissait',
    'barrissant',
    'barrisse',
    'barrissement',
    'barrissent',
    'barrisses',
    'barrissez',
    'barrissiez',
    'barrissions',
    'barrissons',
    'barrit',
    'barrière',
    'barrières',
    'barrons',
    'barrot',
    'barrots',
    'barrâmes',
    'barrât',
    'barrâtes',
    'barrèrent',
    'barré',
    'barrée',
    'barrées',
    'barrés',
    'barrîmes',
    'barrît',
    'barrîtes',
    'bars',
    'bartavelle',
    'bartavelles',
    'barycentre',
    'barycentres',
    'barye',
    'baryes',
    'barymétrie',
    'barymétries',
    'baryon',
    'baryons',
    'barysphère',
    'barysphères',
    'baryte',
    'barytes',
    'barytine',
    'barytines',
    'baryton',
    'barytons',
    'baryum',
    'baryums',
    'barzoï',
    'barzoïs',
    'barème',
    'barèmes',
    'barète',
    'barètent',
    'barètera',
    'barèterai',
    'barèteraient',
    'barèterais',
    'barèterait',
    'barèteras',
    'barèterez',
    'barèteriez',
    'barèterions',
    'barèterons',
    'barèteront',
    'barètes',
    'baréta',
    'barétai',
    'barétaient',
    'barétais',
    'barétait',
    'barétant',
    'barétas',
    'barétasse',
    'barétassent',
    'barétasses',
    'barétassiez',
    'barétassions',
    'baréter',
    'barétez',
    'barétiez',
    'barétions',
    'barétons',
    'barétâmes',
    'barétât',
    'barétâtes',
    'barétèrent',
    'barété',
    'basa',
    'basai',
    'basaient',
    'basais',
    'basait',
    'basal',
    'basale',
    'basales',
    'basalte',
    'basaltes',
    'basaltique',
    'basaltiques',
    'basana',
    'basanai',
    'basanaient',
    'basanais',
    'basanait',
    'basanant',
    'basanas',
    'basanasse',
    'basanassent',
    'basanasses',
    'basanassiez',
    'basanassions',
    'basane',
    'basanent',
    'basaner',
    'basanera',
    'basanerai',
    'basaneraient',
    'basanerais',
    'basanerait',
    'basaneras',
    'basanerez',
    'basaneriez',
    'basanerions',
    'basanerons',
    'basaneront',
    'basanes',
    'basanez',
    'basaniez',
    'basanions',
    'basanons',
    'basant',
    'basanâmes',
    'basanât',
    'basanâtes',
    'basanèrent',
    'basané',
    'basanée',
    'basanées',
    'basanés',
    'basas',
    'basasse',
    'basassent',
    'basasses',
    'basassiez',
    'basassions',
    'basaux',
    'bascula',
    'basculai',
    'basculaient',
    'basculais',
    'basculait',
    'basculant',
    'basculante',
    'basculantes',
    'basculants',
    'basculas',
    'basculasse',
    'basculassent',
    'basculasses',
    'basculassiez',
    'bascule',
    'basculement',
    'basculements',
    'basculent',
    'basculer',
    'basculera',
    'basculerai',
    'basculerais',
    'basculerait',
    'basculeras',
    'basculerez',
    'basculeriez',
    'basculerions',
    'basculerons',
    'basculeront',
    'bascules',
    'basculeur',
    'basculeurs',
    'basculez',
    'basculiez',
    'basculions',
    'basculons',
    'basculâmes',
    'basculât',
    'basculâtes',
    'basculèrent',
    'basculé',
    'basculée',
    'basculées',
    'basculés',
    'base',
    'baselle',
    'baselles',
    'basent',
    'baser',
    'basera',
    'baserai',
    'baseraient',
    'baserais',
    'baserait',
    'baseras',
    'baserez',
    'baseriez',
    'baserions',
    'baserons',
    'baseront',
    'bases',
    'basez',
    'basic',
    'basicité',
    'basicités',
    'basics',
    'baside',
    'basides',
    'basiez',
    'basilaire',
    'basilaires',
    'basilic',
    'basilical',
    'basilicale',
    'basilicales',
    'basilicaux',
    'basilique',
    'basiliques',
    'basin',
    'basins',
    'basions',
    'basique',
    'basiques',
    'basket',
    'baskets',
    'basketteur',
    'basketteurs',
    'basketteuse',
    'basketteuses',
    'basoche',
    'basoches',
    'basons',
    'basophile',
    'basophiles',
    'basquaise',
    'basquaises',
    'basque',
    'basques',
    'basquine',
    'basquines',
    'basse',
    'bassement',
    'basses',
    'bassesse',
    'bassesses',
    'basset',
    'bassets',
    'bassin',
    'bassina',
    'bassinai',
    'bassinaient',
    'bassinais',
    'bassinait',
    'bassinant',
    'bassinante',
    'bassinantes',
    'bassinants',
    'bassinas',
    'bassinasse',
    'bassinassent',
    'bassinasses',
    'bassinassiez',
    'bassine',
    'bassinent',
    'bassiner',
    'bassinera',
    'bassinerai',
    'bassinerais',
    'bassinerait',
    'bassineras',
    'bassinerez',
    'bassineriez',
    'bassinerions',
    'bassinerons',
    'bassineront',
    'bassines',
    'bassinet',
    'bassinets',
    'bassinez',
    'bassiniez',
    'bassinions',
    'bassinoire',
    'bassinoires',
    'bassinons',
    'bassins',
    'bassinâmes',
    'bassinât',
    'bassinâtes',
    'bassinèrent',
    'bassiné',
    'bassinée',
    'bassinées',
    'bassinés',
    'bassiste',
    'bassistes',
    'basson',
    'bassons',
    'baste',
    'basterne',
    'basternes',
    'bastes',
    'bastide',
    'bastides',
    'bastidon',
    'bastidons',
    'bastille',
    'bastilles',
    'bastillonna',
    'bastillonnai',
    'bastillonnas',
    'bastillonne',
    'bastillonner',
    'bastillonnes',
    'bastillonnez',
    'bastillonnât',
    'bastillonné',
    'bastillonnée',
    'bastillonnés',
    'bastillé',
    'bastillée',
    'bastillées',
    'bastillés',
    'basting',
    'bastingage',
    'bastingages',
    'bastings',
    'bastion',
    'bastionna',
    'bastionnai',
    'bastionnais',
    'bastionnait',
    'bastionnant',
    'bastionnas',
    'bastionnasse',
    'bastionne',
    'bastionnent',
    'bastionner',
    'bastionnera',
    'bastionnerai',
    'bastionneras',
    'bastionnerez',
    'bastionnes',
    'bastionnez',
    'bastionniez',
    'bastionnions',
    'bastionnons',
    'bastionnâmes',
    'bastionnât',
    'bastionnâtes',
    'bastionné',
    'bastionnée',
    'bastionnées',
    'bastionnés',
    'bastions',
    'bastonnade',
    'bastonnades',
    'bastos',
    'bastringue',
    'bastringues',
    'basâmes',
    'basât',
    'basâtes',
    'basèrent',
    'basé',
    'basée',
    'basées',
    'basés',
    'bataclan',
    'bataclans',
    'batailla',
    'bataillai',
    'bataillaient',
    'bataillais',
    'bataillait',
    'bataillant',
    'bataillas',
    'bataillasse',
    'bataillasses',
    'bataille',
    'bataillent',
    'batailler',
    'bataillera',
    'bataillerai',
    'bataillerais',
    'bataillerait',
    'batailleras',
    'bataillerez',
    'batailleriez',
    'bataillerons',
    'batailleront',
    'batailles',
    'batailleur',
    'batailleurs',
    'batailleuse',
    'batailleuses',
    'bataillez',
    'batailliez',
    'bataillions',
    'bataillon',
    'bataillons',
    'bataillâmes',
    'bataillât',
    'bataillâtes',
    'bataillèrent',
    'bataillé',
    'batardeau',
    'batardeaux',
    'batavia',
    'batavias',
    'batavique',
    'bataviques',
    'batayole',
    'batayoles',
    'bateau',
    'bateaux',
    'batela',
    'batelage',
    'batelages',
    'batelai',
    'batelaient',
    'batelais',
    'batelait',
    'batelant',
    'batelas',
    'batelasse',
    'batelassent',
    'batelasses',
    'batelassiez',
    'batelassions',
    'bateler',
    'batelet',
    'batelets',
    'bateleur',
    'bateleurs',
    'bateleuse',
    'bateleuses',
    'batelez',
    'batelier',
    'bateliers',
    'bateliez',
    'batelions',
    'batelière',
    'batelières',
    'batelle',
    'batellent',
    'batellera',
    'batellerai',
    'batellerais',
    'batellerait',
    'batelleras',
    'batellerez',
    'batellerie',
    'batelleries',
    'batelleriez',
    'batellerions',
    'batellerons',
    'batelleront',
    'batelles',
    'batelons',
    'batelâmes',
    'batelât',
    'batelâtes',
    'batelèrent',
    'batelé',
    'batelée',
    'batelées',
    'batelés',
    'bath',
    'bathyal',
    'bathyale',
    'bathyales',
    'bathyaux',
    'bathymétrie',
    'bathymétries',
    'bathyscaphe',
    'bathyscaphes',
    'bathysphère',
    'bathysphères',
    'batifola',
    'batifolage',
    'batifolages',
    'batifolai',
    'batifolaient',
    'batifolais',
    'batifolait',
    'batifolant',
    'batifolante',
    'batifolantes',
    'batifolants',
    'batifolas',
    'batifolasse',
    'batifolasses',
    'batifole',
    'batifolent',
    'batifoler',
    'batifolera',
    'batifolerai',
    'batifolerais',
    'batifolerait',
    'batifoleras',
    'batifolerez',
    'batifoleriez',
    'batifolerons',
    'batifoleront',
    'batifoles',
    'batifolez',
    'batifoliez',
    'batifolions',
    'batifolons',
    'batifolâmes',
    'batifolât',
    'batifolâtes',
    'batifolèrent',
    'batifolé',
    'batifolée',
    'batifolées',
    'batifolés',
    'batik',
    'batiks',
    'batiste',
    'batistes',
    'batoude',
    'batoudes',
    'batracien',
    'batraciens',
    'bats',
    'battage',
    'battages',
    'battaient',
    'battais',
    'battait',
    'battant',
    'battante',
    'battantes',
    'battants',
    'batte',
    'battellement',
    'battement',
    'battements',
    'battent',
    'batterie',
    'batteries',
    'battes',
    'batteur',
    'batteurs',
    'batteuse',
    'batteuses',
    'battez',
    'battiez',
    'battions',
    'battirent',
    'battis',
    'battisse',
    'battissent',
    'battisses',
    'battissiez',
    'battissions',
    'battit',
    'battitures',
    'battoir',
    'battoirs',
    'battons',
    'battra',
    'battrai',
    'battraient',
    'battrais',
    'battrait',
    'battras',
    'battre',
    'battrez',
    'battriez',
    'battrions',
    'battrons',
    'battront',
    'battu',
    'battue',
    'battues',
    'batture',
    'battures',
    'battus',
    'battée',
    'battées',
    'battîmes',
    'battît',
    'battîtes',
    'baud',
    'baudet',
    'baudets',
    'baudrier',
    'baudriers',
    'baudroie',
    'baudroies',
    'baudruche',
    'baudruches',
    'bauds',
    'bauge',
    'baugea',
    'baugeai',
    'baugeaient',
    'baugeais',
    'baugeait',
    'baugeant',
    'baugeas',
    'baugeasse',
    'baugeassent',
    'baugeasses',
    'baugeassiez',
    'baugeassions',
    'baugent',
    'baugeons',
    'bauger',
    'baugera',
    'baugerai',
    'baugeraient',
    'baugerais',
    'baugerait',
    'baugeras',
    'baugerez',
    'baugeriez',
    'baugerions',
    'baugerons',
    'baugeront',
    'bauges',
    'baugez',
    'baugeâmes',
    'baugeât',
    'baugeâtes',
    'baugiez',
    'baugions',
    'baugèrent',
    'baugé',
    'baugée',
    'baugées',
    'baugés',
    'baume',
    'baumes',
    'baumier',
    'baumiers',
    'bauquière',
    'bauquières',
    'baux',
    'bauxite',
    'bava',
    'bavai',
    'bavaient',
    'bavais',
    'bavait',
    'bavant',
    'bavard',
    'bavarda',
    'bavardage',
    'bavardages',
    'bavardai',
    'bavardaient',
    'bavardais',
    'bavardait',
    'bavardant',
    'bavardas',
    'bavardasse',
    'bavardassent',
    'bavardasses',
    'bavardassiez',
    'bavarde',
    'bavardent',
    'bavarder',
    'bavardera',
    'bavarderai',
    'bavarderais',
    'bavarderait',
    'bavarderas',
    'bavarderez',
    'bavarderiez',
    'bavarderions',
    'bavarderons',
    'bavarderont',
    'bavardes',
    'bavardez',
    'bavardiez',
    'bavardions',
    'bavardons',
    'bavards',
    'bavardâmes',
    'bavardât',
    'bavardâtes',
    'bavardèrent',
    'bavardé',
    'bavarois',
    'bavaroise',
    'bavaroises',
    'bavas',
    'bavassa',
    'bavassai',
    'bavassaient',
    'bavassais',
    'bavassait',
    'bavassant',
    'bavassas',
    'bavassasse',
    'bavassassent',
    'bavassasses',
    'bavassassiez',
    'bavasse',
    'bavassent',
    'bavasser',
    'bavassera',
    'bavasserai',
    'bavasserais',
    'bavasserait',
    'bavasseras',
    'bavasserez',
    'bavasseriez',
    'bavasserions',
    'bavasserons',
    'bavasseront',
    'bavasses',
    'bavassez',
    'bavassiez',
    'bavassions',
    'bavassons',
    'bavassâmes',
    'bavassât',
    'bavassâtes',
    'bavassèrent',
    'bavassé',
    'bave',
    'bavent',
    'baver',
    'bavera',
    'baverai',
    'baveraient',
    'baverais',
    'baverait',
    'baveras',
    'baverez',
    'baveriez',
    'baverions',
    'baverons',
    'baveront',
    'baves',
    'bavette',
    'bavettes',
    'baveuse',
    'baveuses',
    'baveux',
    'bavez',
    'baviez',
    'bavions',
    'bavocha',
    'bavochai',
    'bavochaient',
    'bavochais',
    'bavochait',
    'bavochant',
    'bavochas',
    'bavochasse',
    'bavochassent',
    'bavochasses',
    'bavochassiez',
    'bavoche',
    'bavochent',
    'bavocher',
    'bavochera',
    'bavocherai',
    'bavocherais',
    'bavocherait',
    'bavocheras',
    'bavocherez',
    'bavocheriez',
    'bavocherions',
    'bavocherons',
    'bavocheront',
    'bavoches',
    'bavochez',
    'bavochiez',
    'bavochions',
    'bavochons',
    'bavochure',
    'bavochures',
    'bavochâmes',
    'bavochât',
    'bavochâtes',
    'bavochèrent',
    'bavoché',
    'bavoir',
    'bavoirs',
    'bavolet',
    'bavolets',
    'bavons',
    'bavure',
    'bavures',
    'bavâmes',
    'bavât',
    'bavâtes',
    'bavèrent',
    'bavé',
    'bavée',
    'bavées',
    'bavés',
    'baya',
    'bayadère',
    'bayadères',
    'bayai',
    'bayaient',
    'bayais',
    'bayait',
    'bayant',
    'bayas',
    'bayasse',
    'bayassent',
    'bayasses',
    'bayassiez',
    'bayassions',
    'baye',
    'bayent',
    'bayer',
    'bayera',
    'bayerai',
    'bayeraient',
    'bayerais',
    'bayerait',
    'bayeras',
    'bayerez',
    'bayeriez',
    'bayerions',
    'bayerons',
    'bayeront',
    'bayes',
    'bayez',
    'bayiez',
    'bayions',
    'bayons',
    'bayou',
    'bayous',
    'bayâmes',
    'bayât',
    'bayâtes',
    'bayèrent',
    'bayé',
    'bazar',
    'bazarda',
    'bazardai',
    'bazardaient',
    'bazardais',
    'bazardait',
    'bazardant',
    'bazardas',
    'bazardasse',
    'bazardassent',
    'bazardasses',
    'bazardassiez',
    'bazarde',
    'bazardent',
    'bazarder',
    'bazardera',
    'bazarderai',
    'bazarderais',
    'bazarderait',
    'bazarderas',
    'bazarderez',
    'bazarderiez',
    'bazarderions',
    'bazarderons',
    'bazarderont',
    'bazardes',
    'bazardez',
    'bazardiez',
    'bazardions',
    'bazardons',
    'bazardâmes',
    'bazardât',
    'bazardâtes',
    'bazardèrent',
    'bazardé',
    'bazardée',
    'bazardées',
    'bazardés',
    'bazars',
    'bazooka',
    'bazookas',
    'baïonnette',
    'baïonnettes',
    'baïram',
    'beagle',
    'beagles',
    'beatnik',
    'beatniks',
    'beau',
    'beauceron',
    'beauceronne',
    'beauceronnes',
    'beaucerons',
    'beaucoup',
    'beauf',
    'beaufs',
    'beaujolais',
    'beaupré',
    'beauprés',
    'beauté',
    'beautés',
    'beaux',
    'becfigue',
    'becfigues',
    'becqua',
    'becquai',
    'becquaient',
    'becquais',
    'becquait',
    'becquant',
    'becquas',
    'becquasse',
    'becquassent',
    'becquasses',
    'becquassiez',
    'becquassions',
    'becque',
    'becquent',
    'becquer',
    'becquera',
    'becquerai',
    'becqueraient',
    'becquerais',
    'becquerait',
    'becqueras',
    'becquerel',
    'becquerels',
    'becquerez',
    'becqueriez',
    'becquerions',
    'becquerons',
    'becqueront',
    'becques',
    'becqueta',
    'becquetai',
    'becquetaient',
    'becquetais',
    'becquetait',
    'becquetance',
    'becquetances',
    'becquetant',
    'becquetas',
    'becquetasse',
    'becquetasses',
    'becqueter',
    'becquetez',
    'becquetiez',
    'becquetions',
    'becquetons',
    'becquette',
    'becquettent',
    'becquettera',
    'becquetterai',
    'becquetteras',
    'becquetterez',
    'becquettes',
    'becquetâmes',
    'becquetât',
    'becquetâtes',
    'becquetèrent',
    'becqueté',
    'becquetée',
    'becquetées',
    'becquetés',
    'becquez',
    'becquiez',
    'becquions',
    'becquons',
    'becquâmes',
    'becquât',
    'becquâtes',
    'becquèrent',
    'becqué',
    'becquée',
    'becquées',
    'becqués',
    'becs',
    'becta',
    'bectai',
    'bectaient',
    'bectais',
    'bectait',
    'bectant',
    'bectas',
    'bectasse',
    'bectassent',
    'bectasses',
    'bectassiez',
    'bectassions',
    'becte',
    'bectent',
    'becter',
    'bectera',
    'becterai',
    'becteraient',
    'becterais',
    'becterait',
    'becteras',
    'becterez',
    'becteriez',
    'becterions',
    'becterons',
    'becteront',
    'bectes',
    'bectez',
    'bectiez',
    'bections',
    'bectons',
    'bectâmes',
    'bectât',
    'bectâtes',
    'bectèrent',
    'becté',
    'bectée',
    'bectées',
    'bectés',
    'bedaine',
    'bedaines',
    'bedeau',
    'bedeaux',
    'bedon',
    'bedonna',
    'bedonnai',
    'bedonnaient',
    'bedonnais',
    'bedonnait',
    'bedonnant',
    'bedonnante',
    'bedonnantes',
    'bedonnants',
    'bedonnas',
    'bedonnasse',
    'bedonnassent',
    'bedonnasses',
    'bedonnassiez',
    'bedonne',
    'bedonnent',
    'bedonner',
    'bedonnera',
    'bedonnerai',
    'bedonnerais',
    'bedonnerait',
    'bedonneras',
    'bedonnerez',
    'bedonneriez',
    'bedonnerions',
    'bedonnerons',
    'bedonneront',
    'bedonnes',
    'bedonnez',
    'bedonniez',
    'bedonnions',
    'bedonnons',
    'bedonnâmes',
    'bedonnât',
    'bedonnâtes',
    'bedonnèrent',
    'bedonné',
    'bedons',
    'beefsteak',
    'beefsteaks',
    'beffroi',
    'beffrois',
    'behaviorisme',
    'behavioriste',
    'beige',
    'beiges',
    'beigne',
    'beignes',
    'beignet',
    'beignets',
    'belette',
    'belettes',
    'belge',
    'belges',
    'belgicisme',
    'belgicismes',
    'belladone',
    'belle',
    'bellement',
    'belles',
    'bellicisme',
    'bellicismes',
    'belliciste',
    'bellicistes',
    'belligérance',
    'belligérant',
    'belligérante',
    'belligérants',
    'belliqueuse',
    'belliqueuses',
    'belliqueux',
    'belluaire',
    'belluaires',
    'bellâtre',
    'bellâtres',
    'belon',
    'belons',
    'belote',
    'belotes',
    'belouga',
    'belougas',
    'beltrami',
    'belvédère',
    'belvédères',
    'bengali',
    'bengalis',
    'benjamin',
    'benjamine',
    'benjamines',
    'benjamins',
    'benjoin',
    'benne',
    'bennes',
    'benoît',
    'benoîte',
    'benoîtement',
    'benoîtes',
    'benoîts',
    'benthique',
    'benthiques',
    'benthos',
    'bentonite',
    'bentonites',
    'benzine',
    'benzines',
    'benzoate',
    'benzoates',
    'benzol',
    'benzolisme',
    'benzolismes',
    'benzols',
    'benzène',
    'benzénique',
    'benzéniques',
    'benêt',
    'benêts',
    'berbère',
    'berbères',
    'bercail',
    'berce',
    'berceau',
    'berceaux',
    'bercement',
    'bercements',
    'bercent',
    'bercer',
    'bercera',
    'bercerai',
    'berceraient',
    'bercerais',
    'bercerait',
    'berceras',
    'bercerez',
    'berceriez',
    'bercerions',
    'bercerons',
    'berceront',
    'berces',
    'berceur',
    'berceurs',
    'berceuse',
    'berceuses',
    'bercez',
    'berciez',
    'bercions',
    'bercèrent',
    'bercé',
    'bercée',
    'bercées',
    'bercés',
    'bergamasque',
    'bergamasques',
    'bergamote',
    'bergamotier',
    'bergamotiers',
    'berge',
    'berger',
    'bergerie',
    'bergeries',
    'bergers',
    'berges',
    'bergère',
    'bergères',
    'berkélium',
    'berkéliums',
    'berline',
    'berlines',
    'berlingot',
    'berlingots',
    'berlue',
    'berme',
    'bermes',
    'bermuda',
    'bermudas',
    'berna',
    'bernache',
    'bernaches',
    'bernacle',
    'bernacles',
    'bernai',
    'bernaient',
    'bernais',
    'bernait',
    'bernant',
    'bernardin',
    'bernardine',
    'bernardines',
    'bernardins',
    'bernas',
    'bernasse',
    'bernassent',
    'bernasses',
    'bernassiez',
    'bernassions',
    'berne',
    'bernent',
    'berner',
    'bernera',
    'bernerai',
    'berneraient',
    'bernerais',
    'bernerait',
    'berneras',
    'bernerez',
    'berneriez',
    'bernerions',
    'bernerons',
    'berneront',
    'bernes',
    'bernez',
    'bernicle',
    'bernicles',
    'berniez',
    'bernions',
    'bernique',
    'berniques',
    'bernons',
    'bernouilli',
    'bernâmes',
    'bernât',
    'bernâtes',
    'bernèrent',
    'berné',
    'bernée',
    'bernées',
    'bernés',
    'berrichon',
    'berrichonne',
    'berrichonnes',
    'berrichons',
    'bers',
    'bersaglier',
    'bersagliers',
    'berthon',
    'berthons',
    'berça',
    'berçai',
    'berçaient',
    'berçais',
    'berçait',
    'berçant',
    'berçante',
    'berçantes',
    'berças',
    'berçasse',
    'berçassent',
    'berçasses',
    'berçassiez',
    'berçassions',
    'berçons',
    'berçâmes',
    'berçât',
    'berçâtes',
    'besace',
    'besaces',
    'besaiguë',
    'besaiguës',
    'besant',
    'besants',
    'besogna',
    'besognai',
    'besognaient',
    'besognais',
    'besognait',
    'besognant',
    'besognas',
    'besognasse',
    'besognassent',
    'besognasses',
    'besognassiez',
    'besogne',
    'besognent',
    'besogner',
    'besognera',
    'besognerai',
    'besognerais',
    'besognerait',
    'besogneras',
    'besognerez',
    'besogneriez',
    'besognerions',
    'besognerons',
    'besogneront',
    'besognes',
    'besogneuse',
    'besogneuses',
    'besogneux',
    'besognez',
    'besogniez',
    'besognions',
    'besognons',
    'besognâmes',
    'besognât',
    'besognâtes',
    'besognèrent',
    'besogné',
    'besoin',
    'besoins',
    'bessemer',
    'bessemers',
    'bestiaire',
    'bestiaires',
    'bestial',
    'bestiale',
    'bestialement',
    'bestiales',
    'bestialité',
    'bestialités',
    'bestiaux',
    'bestiole',
    'bestioles',
    'bette',
    'betterave',
    'betteraves',
    'betteravier',
    'betteraviers',
    'betteravière',
    'bettes',
    'betti',
    'beugla',
    'beuglai',
    'beuglaient',
    'beuglais',
    'beuglait',
    'beuglant',
    'beuglante',
    'beuglantes',
    'beuglants',
    'beuglas',
    'beuglasse',
    'beuglassent',
    'beuglasses',
    'beuglassiez',
    'beuglassions',
    'beugle',
    'beuglement',
    'beuglements',
    'beuglent',
    'beugler',
    'beuglera',
    'beuglerai',
    'beugleraient',
    'beuglerais',
    'beuglerait',
    'beugleras',
    'beuglerez',
    'beugleriez',
    'beuglerions',
    'beuglerons',
    'beugleront',
    'beugles',
    'beuglez',
    'beugliez',
    'beuglions',
    'beuglons',
    'beuglâmes',
    'beuglât',
    'beuglâtes',
    'beuglèrent',
    'beuglé',
    'beuglée',
    'beuglées',
    'beuglés',
    'beur',
    'beurra',
    'beurrai',
    'beurraient',
    'beurrais',
    'beurrait',
    'beurrant',
    'beurras',
    'beurrasse',
    'beurrassent',
    'beurrasses',
    'beurrassiez',
    'beurrassions',
    'beurre',
    'beurrent',
    'beurrer',
    'beurrera',
    'beurrerai',
    'beurreraient',
    'beurrerais',
    'beurrerait',
    'beurreras',
    'beurrerez',
    'beurrerie',
    'beurreries',
    'beurreriez',
    'beurrerions',
    'beurrerons',
    'beurreront',
    'beurres',
    'beurrez',
    'beurrier',
    'beurriers',
    'beurriez',
    'beurrions',
    'beurrons',
    'beurrâmes',
    'beurrât',
    'beurrâtes',
    'beurrèrent',
    'beurré',
    'beurrée',
    'beurrées',
    'beurrés',
    'beurs',
    'beuverie',
    'beuveries',
    'beylical',
    'beylicale',
    'beylicales',
    'beylicat',
    'beylicats',
    'beylicaux',
    'beylisme',
    'beylismes',
    'beys',
    'biacide',
    'biacides',
    'biacuminé',
    'biacuminée',
    'biacuminées',
    'biacuminés',
    'biais',
    'biaisa',
    'biaisai',
    'biaisaient',
    'biaisais',
    'biaisait',
    'biaisant',
    'biaisas',
    'biaisasse',
    'biaisassent',
    'biaisasses',
    'biaisassiez',
    'biaisassions',
    'biaise',
    'biaisent',
    'biaiser',
    'biaisera',
    'biaiserai',
    'biaiseraient',
    'biaiserais',
    'biaiserait',
    'biaiseras',
    'biaiserez',
    'biaiseriez',
    'biaiserions',
    'biaiserons',
    'biaiseront',
    'biaises',
    'biaisez',
    'biaisiez',
    'biaisions',
    'biaisons',
    'biaisâmes',
    'biaisât',
    'biaisâtes',
    'biaisèrent',
    'biaisé',
    'biaisée',
    'biaisées',
    'biaisés',
    'bianchi',
    'bibelot',
    'bibelota',
    'bibelotai',
    'bibelotaient',
    'bibelotais',
    'bibelotait',
    'bibelotant',
    'bibelotas',
    'bibelotasse',
    'bibelotasses',
    'bibelote',
    'bibelotent',
    'bibeloter',
    'bibelotera',
    'bibeloterai',
    'bibeloterais',
    'bibeloterait',
    'bibeloteras',
    'bibeloterez',
    'bibeloteriez',
    'bibeloterons',
    'bibeloteront',
    'bibelotes',
    'bibelotez',
    'bibelotiez',
    'bibelotions',
    'bibelotons',
    'bibelots',
    'bibelotâmes',
    'bibelotât',
    'bibelotâtes',
    'bibelotèrent',
    'bibeloté',
    'biberon',
    'biberonna',
    'biberonnai',
    'biberonnais',
    'biberonnait',
    'biberonnant',
    'biberonnas',
    'biberonnasse',
    'biberonne',
    'biberonnent',
    'biberonner',
    'biberonnera',
    'biberonnerai',
    'biberonneras',
    'biberonnerez',
    'biberonnes',
    'biberonnez',
    'biberonniez',
    'biberonnions',
    'biberonnons',
    'biberonnâmes',
    'biberonnât',
    'biberonnâtes',
    'biberonné',
    'biberons',
    'bibi',
    'bibine',
    'bibines',
    'bibis',
    'bible',
    'bibles',
    'bibliobus',
    'bibliographe',
    'bibliomanie',
    'bibliomanies',
    'bibliophile',
    'bibliophiles',
    'bibliophilie',
    'bibliothèque',
    'biblique',
    'bibliques',
    'bicamérisme',
    'bicamérismes',
    'bicarbonate',
    'bicarbonates',
    'bicarré',
    'bicarrée',
    'bicarrées',
    'bicarrés',
    'bicentenaire',
    'biceps',
    'bicha',
    'bichai',
    'bichaient',
    'bichais',
    'bichait',
    'bichant',
    'bichas',
    'bichasse',
    'bichassent',
    'bichasses',
    'bichassiez',
    'bichassions',
    'biche',
    'bichent',
    'bicher',
    'bichera',
    'bicherai',
    'bicheraient',
    'bicherais',
    'bicherait',
    'bicheras',
    'bicherez',
    'bicheriez',
    'bicherions',
    'bicherons',
    'bicheront',
    'biches',
    'bichette',
    'bichettes',
    'bichez',
    'bichiez',
    'bichions',
    'bichlamar',
    'bichlamars',
    'bichlorure',
    'bichof',
    'bichon',
    'bichonna',
    'bichonnai',
    'bichonnaient',
    'bichonnais',
    'bichonnait',
    'bichonnant',
    'bichonnas',
    'bichonnasse',
    'bichonnasses',
    'bichonne',
    'bichonnent',
    'bichonner',
    'bichonnera',
    'bichonnerai',
    'bichonnerais',
    'bichonnerait',
    'bichonneras',
    'bichonnerez',
    'bichonneriez',
    'bichonnerons',
    'bichonneront',
    'bichonnes',
    'bichonnez',
    'bichonniez',
    'bichonnions',
    'bichonnons',
    'bichonnâmes',
    'bichonnât',
    'bichonnâtes',
    'bichonnèrent',
    'bichonné',
    'bichonnée',
    'bichonnées',
    'bichonnés',
    'bichons',
    'bichota',
    'bichotai',
    'bichotaient',
    'bichotais',
    'bichotait',
    'bichotant',
    'bichotas',
    'bichotasse',
    'bichotassent',
    'bichotasses',
    'bichotassiez',
    'bichote',
    'bichotent',
    'bichoter',
    'bichotera',
    'bichoterai',
    'bichoterais',
    'bichoterait',
    'bichoteras',
    'bichoterez',
    'bichoteriez',
    'bichoterions',
    'bichoterons',
    'bichoteront',
    'bichotes',
    'bichotez',
    'bichotiez',
    'bichotions',
    'bichotons',
    'bichotâmes',
    'bichotât',
    'bichotâtes',
    'bichotèrent',
    'bichoté',
    'bichromate',
    'bichromates',
    'bichromie',
    'bichromies',
    'bichâmes',
    'bichât',
    'bichâtes',
    'bichèrent',
    'biché',
    'bickford',
    'bickfords',
    'bicolore',
    'bicolores',
    'biconcave',
    'biconcaves',
    'biconvexe',
    'biconvexes',
    'bicoque',
    'bicoques',
    'bicorne',
    'bicornes',
    'bicot',
    'bicots',
    'bics',
    'biculturel',
    'biculturelle',
    'biculturels',
    'bicycle',
    'bicycles',
    'bicyclette',
    'bicyclettes',
    'bicéphale',
    'bicéphales',
    'bidasse',
    'bidasses',
    'bide',
    'bident',
    'bidents',
    'bides',
    'bidet',
    'bidets',
    'bidoche',
    'bidoches',
    'bidon',
    'bidonna',
    'bidonnai',
    'bidonnaient',
    'bidonnais',
    'bidonnait',
    'bidonnant',
    'bidonnante',
    'bidonnantes',
    'bidonnants',
    'bidonnas',
    'bidonnasse',
    'bidonnassent',
    'bidonnasses',
    'bidonnassiez',
    'bidonne',
    'bidonnent',
    'bidonner',
    'bidonnera',
    'bidonnerai',
    'bidonnerais',
    'bidonnerait',
    'bidonneras',
    'bidonnerez',
    'bidonneriez',
    'bidonnerions',
    'bidonnerons',
    'bidonneront',
    'bidonnes',
    'bidonnez',
    'bidonniez',
    'bidonnions',
    'bidonnons',
    'bidonnâmes',
    'bidonnât',
    'bidonnâtes',
    'bidonnèrent',
    'bidonné',
    'bidonnée',
    'bidonnées',
    'bidonnés',
    'bidons',
    'bidonville',
    'bidonvilles',
    'bidouilla',
    'bidouillage',
    'bidouillages',
    'bidouillai',
    'bidouillais',
    'bidouillait',
    'bidouillant',
    'bidouillas',
    'bidouillasse',
    'bidouille',
    'bidouillent',
    'bidouiller',
    'bidouillera',
    'bidouillerai',
    'bidouilleras',
    'bidouillerez',
    'bidouilles',
    'bidouillez',
    'bidouilliez',
    'bidouillions',
    'bidouillons',
    'bidouillâmes',
    'bidouillât',
    'bidouillâtes',
    'bidouillé',
    'bidouillée',
    'bidouillées',
    'bidouillés',
    'bidule',
    'bidules',
    'bief',
    'biefs',
    'bielle',
    'bielles',
    'biellette',
    'biellettes',
    'bien',
    'bienfaisance',
    'bienfaisant',
    'bienfaisante',
    'bienfaisants',
    'bienfait',
    'bienfaiteur',
    'bienfaiteurs',
    'bienfaitrice',
    'bienfaits',
    'bienheureuse',
    'bienheureux',
    'biennal',
    'biennale',
    'biennales',
    'biennaux',
    'biens',
    'bienséance',
    'bienséances',
    'bienséant',
    'bienséante',
    'bienséantes',
    'bienséants',
    'bientôt',
    'bienveillant',
    'bienvenir',
    'bienvenu',
    'bienvenue',
    'bienvenues',
    'bienvenus',
    'biface',
    'bifaces',
    'biffa',
    'biffage',
    'biffages',
    'biffai',
    'biffaient',
    'biffais',
    'biffait',
    'biffant',
    'biffas',
    'biffasse',
    'biffassent',
    'biffasses',
    'biffassiez',
    'biffassions',
    'biffe',
    'biffent',
    'biffer',
    'biffera',
    'bifferai',
    'bifferaient',
    'bifferais',
    'bifferait',
    'bifferas',
    'bifferez',
    'bifferiez',
    'bifferions',
    'bifferons',
    'bifferont',
    'biffes',
    'biffez',
    'biffiez',
    'biffin',
    'biffins',
    'biffions',
    'biffons',
    'biffure',
    'biffures',
    'biffâmes',
    'biffât',
    'biffâtes',
    'biffèrent',
    'biffé',
    'biffée',
    'biffées',
    'biffés',
    'bifide',
    'bifides',
    'bifilaire',
    'bifilaires',
    'bifocal',
    'bifocale',
    'bifocales',
    'bifocaux',
    'bifteck',
    'biftecks',
    'bifurcation',
    'bifurcations',
    'bifurqua',
    'bifurquai',
    'bifurquaient',
    'bifurquais',
    'bifurquait',
    'bifurquant',
    'bifurquas',
    'bifurquasse',
    'bifurquasses',
    'bifurque',
    'bifurquent',
    'bifurquer',
    'bifurquera',
    'bifurquerai',
    'bifurquerais',
    'bifurquerait',
    'bifurqueras',
    'bifurquerez',
    'bifurqueriez',
    'bifurquerons',
    'bifurqueront',
    'bifurques',
    'bifurquez',
    'bifurquiez',
    'bifurquions',
    'bifurquons',
    'bifurquâmes',
    'bifurquât',
    'bifurquâtes',
    'bifurquèrent',
    'bifurqué',
    'bigame',
    'bigames',
    'bigamie',
    'bigarade',
    'bigarades',
    'bigaradier',
    'bigaradiers',
    'bigarra',
    'bigarrai',
    'bigarraient',
    'bigarrais',
    'bigarrait',
    'bigarrant',
    'bigarras',
    'bigarrasse',
    'bigarrassent',
    'bigarrasses',
    'bigarrassiez',
    'bigarre',
    'bigarreau',
    'bigarreaux',
    'bigarrent',
    'bigarrer',
    'bigarrera',
    'bigarrerai',
    'bigarrerais',
    'bigarrerait',
    'bigarreras',
    'bigarrerez',
    'bigarreriez',
    'bigarrerions',
    'bigarrerons',
    'bigarreront',
    'bigarres',
    'bigarrez',
    'bigarriez',
    'bigarrions',
    'bigarrons',
    'bigarrure',
    'bigarrures',
    'bigarrâmes',
    'bigarrât',
    'bigarrâtes',
    'bigarrèrent',
    'bigarré',
    'bigarrée',
    'bigarrées',
    'bigarrés',
    'bigla',
    'biglai',
    'biglaient',
    'biglais',
    'biglait',
    'biglant',
    'biglas',
    'biglasse',
    'biglassent',
    'biglasses',
    'biglassiez',
    'biglassions',
    'bigle',
    'biglent',
    'bigler',
    'biglera',
    'biglerai',
    'bigleraient',
    'biglerais',
    'biglerait',
    'bigleras',
    'biglerez',
    'bigleriez',
    'biglerions',
    'biglerons',
    'bigleront',
    'bigles',
    'bigleuse',
    'bigleuses',
    'bigleux',
    'biglez',
    'bigliez',
    'biglions',
    'biglons',
    'biglâmes',
    'biglât',
    'biglâtes',
    'biglèrent',
    'biglé',
    'biglée',
    'biglées',
    'biglés',
    'bignonia',
    'bignonias',
    'bigophone',
    'bigophones',
    'bigorna',
    'bigornai',
    'bigornaient',
    'bigornais',
    'bigornait',
    'bigornant',
    'bigornas',
    'bigornasse',
    'bigornassent',
    'bigornasses',
    'bigornassiez',
    'bigorne',
    'bigorneau',
    'bigorneaux',
    'bigornent',
    'bigorner',
    'bigornera',
    'bigornerai',
    'bigornerais',
    'bigornerait',
    'bigorneras',
    'bigornerez',
    'bigorneriez',
    'bigornerions',
    'bigornerons',
    'bigorneront',
    'bigornes',
    'bigornez',
    'bigorniez',
    'bigornions',
    'bigornons',
    'bigornâmes',
    'bigornât',
    'bigornâtes',
    'bigornèrent',
    'bigorné',
    'bigornée',
    'bigornées',
    'bigornés',
    'bigot',
    'bigote',
    'bigoterie',
    'bigoteries',
    'bigotes',
    'bigotisme',
    'bigotismes',
    'bigots',
    'bigouden',
    'bigoudi',
    'bigoudis',
    'bigre',
    'bigrement',
    'bigue',
    'bigues',
    'biguine',
    'biguines',
    'biharmonique',
    'bihoreau',
    'bihoreaus',
    'bijectif',
    'bijectifs',
    'bijection',
    'bijections',
    'bijective',
    'bijectives',
    'bijou',
    'bijouterie',
    'bijouteries',
    'bijoutier',
    'bijoutiers',
    'bijoutière',
    'bijoutières',
    'bijoux',
    'bikini',
    'bikinis',
    'bila',
    'bilabiale',
    'bilabiales',
    'bilabié',
    'bilabiée',
    'bilabiées',
    'bilabiés',
    'bilai',
    'bilaient',
    'bilais',
    'bilait',
    'bilame',
    'bilames',
    'bilan',
    'bilans',
    'bilant',
    'bilaplacien',
    'bilas',
    'bilasse',
    'bilassent',
    'bilasses',
    'bilassiez',
    'bilassions',
    'bilatéral',
    'bilatérale',
    'bilatérales',
    'bilatéraux',
    'bilboquet',
    'bilboquets',
    'bile',
    'bilent',
    'biler',
    'bilera',
    'bilerai',
    'bileraient',
    'bilerais',
    'bilerait',
    'bileras',
    'bilerez',
    'bileriez',
    'bilerions',
    'bilerons',
    'bileront',
    'biles',
    'bileuse',
    'bileuses',
    'bileux',
    'bilez',
    'bilharzie',
    'bilharzies',
    'bilharziose',
    'bilharzioses',
    'biliaire',
    'biliaires',
    'bilieuse',
    'bilieuses',
    'bilieux',
    'biliez',
    'bilingue',
    'bilingues',
    'bilinguisme',
    'bilinguismes',
    'bilions',
    'bilirubine',
    'bilirubines',
    'bill',
    'billard',
    'billards',
    'bille',
    'billebauda',
    'billebaudai',
    'billebaudais',
    'billebaudait',
    'billebaudant',
    'billebaudas',
    'billebaude',
    'billebaudent',
    'billebauder',
    'billebaudera',
    'billebaudes',
    'billebaudez',
    'billebaudiez',
    'billebaudons',
    'billebaudât',
    'billebaudé',
    'biller',
    'billes',
    'billet',
    'billets',
    'billette',
    'billetterie',
    'billetteries',
    'billettes',
    'billeté',
    'billetée',
    'billetées',
    'billetés',
    'billevesée',
    'billevesées',
    'billion',
    'billions',
    'billon',
    'billonna',
    'billonnage',
    'billonnages',
    'billonnai',
    'billonnaient',
    'billonnais',
    'billonnait',
    'billonnant',
    'billonnas',
    'billonnasse',
    'billonnasses',
    'billonne',
    'billonnent',
    'billonner',
    'billonnera',
    'billonnerai',
    'billonnerais',
    'billonnerait',
    'billonneras',
    'billonnerez',
    'billonneriez',
    'billonnerons',
    'billonneront',
    'billonnes',
    'billonnez',
    'billonniez',
    'billonnions',
    'billonnons',
    'billonnâmes',
    'billonnât',
    'billonnâtes',
    'billonnèrent',
    'billonné',
    'billonnée',
    'billonnées',
    'billonnés',
    'billons',
    'billot',
    'billots',
    'bills',
    'bilobé',
    'bilobée',
    'bilobées',
    'bilobés',
    'biloculaire',
    'biloculaires',
    'bilons',
    'biloqua',
    'biloquai',
    'biloquaient',
    'biloquais',
    'biloquait',
    'biloquant',
    'biloquas',
    'biloquasse',
    'biloquassent',
    'biloquasses',
    'biloquassiez',
    'biloque',
    'biloquent',
    'biloquer',
    'biloquera',
    'biloquerai',
    'biloquerais',
    'biloquerait',
    'biloqueras',
    'biloquerez',
    'biloqueriez',
    'biloquerions',
    'biloquerons',
    'biloqueront',
    'biloques',
    'biloquez',
    'biloquiez',
    'biloquions',
    'biloquons',
    'biloquâmes',
    'biloquât',
    'biloquâtes',
    'biloquèrent',
    'biloqué',
    'biloquée',
    'biloquées',
    'biloqués',
    'bilâmes',
    'bilât',
    'bilâtes',
    'bilèrent',
    'bilé',
    'bilée',
    'bilées',
    'bilés',
    'bimane',
    'bimanes',
    'bimbeloterie',
    'bimensuel',
    'bimensuelle',
    'bimensuelles',
    'bimensuels',
    'bimestriel',
    'bimestrielle',
    'bimestriels',
    'bimillénaire',
    'bimoteur',
    'bimoteurs',
    'bimétallique',
    'bimétallisme',
    'bimétalliste',
    'bina',
    'binage',
    'binages',
    'binai',
    'binaient',
    'binaire',
    'binaires',
    'binais',
    'binait',
    'binant',
    'binard',
    'binards',
    'binas',
    'binasse',
    'binassent',
    'binasses',
    'binassiez',
    'binassions',
    'binational',
    'binationale',
    'binationales',
    'binationaux',
    'bine',
    'binent',
    'biner',
    'binera',
    'binerai',
    'bineraient',
    'binerais',
    'binerait',
    'bineras',
    'binerez',
    'bineriez',
    'binerions',
    'binerons',
    'bineront',
    'bines',
    'binette',
    'binettes',
    'bineuse',
    'bineuses',
    'binez',
    'bingo',
    'bingos',
    'biniez',
    'binions',
    'biniou',
    'binious',
    'binoclard',
    'binoclarde',
    'binoclardes',
    'binoclards',
    'binocle',
    'binocles',
    'binoculaire',
    'binoculaires',
    'binons',
    'binormale',
    'binâmes',
    'binât',
    'binâtes',
    'binèrent',
    'biné',
    'binée',
    'binées',
    'binés',
    'biochimie',
    'biochimies',
    'biochimiques',
    'biochimiste',
    'biochimistes',
    'biocide',
    'biocides',
    'biocénose',
    'biocénoses',
    'biogenèse',
    'biogenèses',
    'biographe',
    'biographes',
    'biographie',
    'biographies',
    'biographique',
    'biologie',
    'biologies',
    'biologique',
    'biologiques',
    'biologiste',
    'biologistes',
    'biomasse',
    'biomasses',
    'biomécanique',
    'biomédical',
    'biomédicale',
    'biomédicales',
    'biomédicaux',
    'bionique',
    'bioniques',
    'biophysique',
    'biophysiques',
    'biopsie',
    'biopsies',
    'biosphère',
    'biosphères',
    'biosynthèse',
    'biosynthèses',
    'biothérapie',
    'biothérapies',
    'biotique',
    'biotiques',
    'biotite',
    'biotites',
    'biotope',
    'biotopes',
    'biotype',
    'biotypes',
    'biotypologie',
    'bioxyde',
    'bioxydes',
    'bioénergie',
    'bioénergies',
    'bipale',
    'bipales',
    'biparti',
    'bipartie',
    'biparties',
    'bipartis',
    'bipartisme',
    'bipartismes',
    'bipartite',
    'bipartites',
    'bipartition',
    'bipartitions',
    'bipasser',
    'bipenné',
    'bipennée',
    'bipennées',
    'bipennés',
    'biphasé',
    'biphasée',
    'biphasées',
    'biphasés',
    'bipied',
    'bipieds',
    'biplace',
    'biplaces',
    'biplan',
    'biplans',
    'bipolaire',
    'bipolaires',
    'bipolarité',
    'bipolarités',
    'bipoutre',
    'bipoutres',
    'bipède',
    'bipèdes',
    'bique',
    'biques',
    'biquet',
    'biquets',
    'biquette',
    'biquettes',
    'biquotidien',
    'biquotidiens',
    'birbe',
    'birbes',
    'biroute',
    'biroutes',
    'birème',
    'birèmes',
    'biréacteur',
    'biréacteurs',
    'biréfringent',
    'bisa',
    'bisai',
    'bisaient',
    'bisais',
    'bisait',
    'bisannuel',
    'bisannuelle',
    'bisannuelles',
    'bisannuels',
    'bisant',
    'bisas',
    'bisasse',
    'bisassent',
    'bisasses',
    'bisassiez',
    'bisassions',
    'bisaïeul',
    'bisaïeule',
    'bisaïeules',
    'bisaïeuls',
    'bisbille',
    'bisbilles',
    'biscaïen',
    'biscaïenne',
    'biscaïennes',
    'biscaïens',
    'biscornu',
    'biscornue',
    'biscornues',
    'biscornus',
    'biscotte',
    'biscotterie',
    'biscotteries',
    'biscottes',
    'biscuit',
    'biscuita',
    'biscuitai',
    'biscuitaient',
    'biscuitais',
    'biscuitait',
    'biscuitant',
    'biscuitas',
    'biscuitasse',
    'biscuitasses',
    'biscuite',
    'biscuitent',
    'biscuiter',
    'biscuitera',
    'biscuiterai',
    'biscuiterais',
    'biscuiterait',
    'biscuiteras',
    'biscuiterez',
    'biscuiterie',
    'biscuiteries',
    'biscuiteriez',
    'biscuiterons',
    'biscuiteront',
    'biscuites',
    'biscuitez',
    'biscuitiez',
    'biscuitions',
    'biscuitons',
    'biscuits',
    'biscuitâmes',
    'biscuitât',
    'biscuitâtes',
    'biscuitèrent',
    'biscuité',
    'biscuitée',
    'biscuitées',
    'biscuités',
    'biscôme',
    'biscômes',
    'bise',
    'biseau',
    'biseauta',
    'biseautage',
    'biseautages',
    'biseautai',
    'biseautaient',
    'biseautais',
    'biseautait',
    'biseautant',
    'biseautas',
    'biseautasse',
    'biseautasses',
    'biseaute',
    'biseautent',
    'biseauter',
    'biseautera',
    'biseauterai',
    'biseauterais',
    'biseauterait',
    'biseauteras',
    'biseauterez',
    'biseauteriez',
    'biseauterons',
    'biseauteront',
    'biseautes',
    'biseautez',
    'biseautiez',
    'biseautions',
    'biseautons',
    'biseautâmes',
    'biseautât',
    'biseautâtes',
    'biseautèrent',
    'biseauté',
    'biseautée',
    'biseautées',
    'biseautés',
    'biseaux',
    'bisegmenta',
    'bisegmentai',
    'bisegmentais',
    'bisegmentait',
    'bisegmentant',
    'bisegmentas',
    'bisegmente',
    'bisegmentent',
    'bisegmenter',
    'bisegmentera',
    'bisegmentes',
    'bisegmentez',
    'bisegmentiez',
    'bisegmentons',
    'bisegmentât',
    'bisegmenté',
    'bisegmentée',
    'bisegmentées',
    'bisegmentés',
    'bisent',
    'biser',
    'bisera',
    'biserai',
    'biseraient',
    'biserais',
    'biserait',
    'biseras',
    'biserez',
    'biseriez',
    'biserions',
    'biserons',
    'biseront',
    'bises',
    'biset',
    'bisets',
    'bisexualité',
    'bisexualités',
    'bisexuel',
    'bisexuelle',
    'bisexuelles',
    'bisexuels',
    'bisexué',
    'bisexuée',
    'bisexuées',
    'bisexués',
    'bisez',
    'bisiez',
    'bisions',
    'bismuth',
    'bismuthine',
    'bismuthines',
    'bismuths',
    'bison',
    'bisons',
    'bisou',
    'bisous',
    'bisqua',
    'bisquai',
    'bisquaient',
    'bisquais',
    'bisquait',
    'bisquant',
    'bisquas',
    'bisquasse',
    'bisquassent',
    'bisquasses',
    'bisquassiez',
    'bisquassions',
    'bisque',
    'bisquent',
    'bisquer',
    'bisquera',
    'bisquerai',
    'bisqueraient',
    'bisquerais',
    'bisquerait',
    'bisqueras',
    'bisquerez',
    'bisqueriez',
    'bisquerions',
    'bisquerons',
    'bisqueront',
    'bisques',
    'bisquez',
    'bisquiez',
    'bisquions',
    'bisquons',
    'bisquâmes',
    'bisquât',
    'bisquâtes',
    'bisquèrent',
    'bisqué',
    'bisquée',
    'bisquées',
    'bisqués',
    'bissa',
    'bissai',
    'bissaient',
    'bissais',
    'bissait',
    'bissant',
    'bissas',
    'bissasse',
    'bissassent',
    'bissasses',
    'bissassiez',
    'bissassions',
    'bisse',
    'bissecteur',
    'bissecteurs',
    'bissection',
    'bissections',
    'bissectrice',
    'bissectrices',
    'bissent',
    'bisser',
    'bissera',
    'bisserai',
    'bisseraient',
    'bisserais',
    'bisserait',
    'bisseras',
    'bisserez',
    'bisseriez',
    'bisserions',
    'bisserons',
    'bisseront',
    'bisses',
    'bissexte',
    'bissextes',
    'bissextile',
    'bissextiles',
    'bissexualité',
    'bissexuel',
    'bissexuelle',
    'bissexuelles',
    'bissexuels',
    'bissexué',
    'bissexuée',
    'bissexuées',
    'bissexués',
    'bissez',
    'bissiez',
    'bissions',
    'bissons',
    'bissâmes',
    'bissât',
    'bissâtes',
    'bissèrent',
    'bissé',
    'bissée',
    'bissées',
    'bissés',
    'bistorte',
    'bistortes',
    'bistouille',
    'bistouilles',
    'bistouri',
    'bistouris',
    'bistourna',
    'bistournage',
    'bistournages',
    'bistournai',
    'bistournais',
    'bistournait',
    'bistournant',
    'bistournas',
    'bistournasse',
    'bistourne',
    'bistournent',
    'bistourner',
    'bistournera',
    'bistournerai',
    'bistourneras',
    'bistournerez',
    'bistournes',
    'bistournez',
    'bistourniez',
    'bistournions',
    'bistournons',
    'bistournâmes',
    'bistournât',
    'bistournâtes',
    'bistourné',
    'bistournée',
    'bistournées',
    'bistournés',
    'bistra',
    'bistrai',
    'bistraient',
    'bistrais',
    'bistrait',
    'bistrant',
    'bistras',
    'bistrasse',
    'bistrassent',
    'bistrasses',
    'bistrassiez',
    'bistrassions',
    'bistre',
    'bistrent',
    'bistrer',
    'bistrera',
    'bistrerai',
    'bistreraient',
    'bistrerais',
    'bistrerait',
    'bistreras',
    'bistrerez',
    'bistreriez',
    'bistrerions',
    'bistrerons',
    'bistreront',
    'bistres',
    'bistrez',
    'bistriez',
    'bistrions',
    'bistro',
    'bistrons',
    'bistros',
    'bistrot',
    'bistrots',
    'bistrâmes',
    'bistrât',
    'bistrâtes',
    'bistrèrent',
    'bistré',
    'bistrée',
    'bistrées',
    'bistrés',
    'bisulfate',
    'bisulfates',
    'bisulfure',
    'bisulfures',
    'bisâmes',
    'bisât',
    'bisâtes',
    'bisèrent',
    'bisé',
    'bisée',
    'bisées',
    'bisés',
    'bita',
    'bitai',
    'bitaient',
    'bitais',
    'bitait',
    'bitant',
    'bitas',
    'bitasse',
    'bitassent',
    'bitasses',
    'bitassiez',
    'bitassions',
    'bite',
    'bitension',
    'bitensions',
    'bitent',
    'biter',
    'bitera',
    'biterai',
    'biteraient',
    'biterais',
    'biterait',
    'biteras',
    'biterez',
    'biteriez',
    'biterions',
    'biterons',
    'biteront',
    'bites',
    'bitez',
    'bitiez',
    'bitions',
    'bitonal',
    'bitonale',
    'bitonales',
    'bitonaux',
    'bitons',
    'bitord',
    'bitords',
    'bitos',
    'bits',
    'bitta',
    'bittai',
    'bittaient',
    'bittais',
    'bittait',
    'bittant',
    'bittas',
    'bittasse',
    'bittassent',
    'bittasses',
    'bittassiez',
    'bittassions',
    'bitte',
    'bittent',
    'bitter',
    'bittera',
    'bitterai',
    'bitteraient',
    'bitterais',
    'bitterait',
    'bitteras',
    'bitterez',
    'bitteriez',
    'bitterions',
    'bitterons',
    'bitteront',
    'bittes',
    'bittez',
    'bittiez',
    'bittions',
    'bittons',
    'bittura',
    'bitturai',
    'bitturaient',
    'bitturais',
    'bitturait',
    'bitturant',
    'bitturas',
    'bitturasse',
    'bitturassent',
    'bitturasses',
    'bitturassiez',
    'bitture',
    'bitturent',
    'bitturer',
    'bitturera',
    'bitturerai',
    'bitturerais',
    'bitturerait',
    'bittureras',
    'bitturerez',
    'bittureriez',
    'bitturerions',
    'bitturerons',
    'bittureront',
    'bittures',
    'bitturez',
    'bitturiez',
    'bitturions',
    'bitturons',
    'bitturâmes',
    'bitturât',
    'bitturâtes',
    'bitturèrent',
    'bitturé',
    'bitturée',
    'bitturées',
    'bitturés',
    'bittâmes',
    'bittât',
    'bittâtes',
    'bittèrent',
    'bitté',
    'bittée',
    'bittées',
    'bittés',
    'bituma',
    'bitumage',
    'bitumages',
    'bitumai',
    'bitumaient',
    'bitumais',
    'bitumait',
    'bitumant',
    'bitumas',
    'bitumasse',
    'bitumassent',
    'bitumasses',
    'bitumassiez',
    'bitumassions',
    'bitume',
    'bitument',
    'bitumer',
    'bitumera',
    'bitumerai',
    'bitumeraient',
    'bitumerais',
    'bitumerait',
    'bitumeras',
    'bitumerez',
    'bitumeriez',
    'bitumerions',
    'bitumerons',
    'bitumeront',
    'bitumes',
    'bitumeuse',
    'bitumeuses',
    'bitumeux',
    'bitumez',
    'bitumiez',
    'bitumina',
    'bituminai',
    'bituminaient',
    'bituminais',
    'bituminait',
    'bituminant',
    'bituminas',
    'bituminasse',
    'bituminasses',
    'bitumine',
    'bituminent',
    'bituminer',
    'bituminera',
    'bituminerai',
    'bituminerais',
    'bituminerait',
    'bitumineras',
    'bituminerez',
    'bitumineriez',
    'bituminerons',
    'bitumineront',
    'bitumines',
    'bitumineuse',
    'bitumineuses',
    'bitumineux',
    'bituminez',
    'bituminiez',
    'bituminions',
    'bituminons',
    'bituminâmes',
    'bituminât',
    'bituminâtes',
    'bituminèrent',
    'bituminé',
    'bituminée',
    'bituminées',
    'bituminés',
    'bitumions',
    'bitumons',
    'bitumâmes',
    'bitumât',
    'bitumâtes',
    'bitumèrent',
    'bitumé',
    'bitumée',
    'bitumées',
    'bitumés',
    'bitura',
    'biturai',
    'bituraient',
    'biturais',
    'biturait',
    'biturant',
    'bituras',
    'biturasse',
    'biturassent',
    'biturasses',
    'biturassiez',
    'biturassions',
    'biturbine',
    'biturbines',
    'biture',
    'biturent',
    'biturer',
    'biturera',
    'biturerai',
    'bitureraient',
    'biturerais',
    'biturerait',
    'bitureras',
    'biturerez',
    'bitureriez',
    'biturerions',
    'biturerons',
    'bitureront',
    'bitures',
    'biturez',
    'bituriez',
    'biturions',
    'biturons',
    'biturâmes',
    'biturât',
    'biturâtes',
    'biturèrent',
    'bituré',
    'biturée',
    'biturées',
    'biturés',
    'bitâmes',
    'bitât',
    'bitâtes',
    'bitèrent',
    'bité',
    'bitée',
    'bitées',
    'bités',
    'bivalence',
    'bivalences',
    'bivalent',
    'bivalente',
    'bivalentes',
    'bivalents',
    'bivalve',
    'bivalves',
    'biveau',
    'biveaux',
    'bivouac',
    'bivouacs',
    'bivouaqua',
    'bivouaquai',
    'bivouaquais',
    'bivouaquait',
    'bivouaquant',
    'bivouaquas',
    'bivouaquasse',
    'bivouaque',
    'bivouaquent',
    'bivouaquer',
    'bivouaquera',
    'bivouaquerai',
    'bivouaqueras',
    'bivouaquerez',
    'bivouaques',
    'bivouaquez',
    'bivouaquiez',
    'bivouaquions',
    'bivouaquons',
    'bivouaquâmes',
    'bivouaquât',
    'bivouaquâtes',
    'bivouaqué',
    'bizarre',
    'bizarrement',
    'bizarrerie',
    'bizarreries',
    'bizarres',
    'bizarroïde',
    'bizarroïdes',
    'bizut',
    'bizuta',
    'bizutage',
    'bizutages',
    'bizutai',
    'bizutaient',
    'bizutais',
    'bizutait',
    'bizutant',
    'bizutas',
    'bizutasse',
    'bizutassent',
    'bizutasses',
    'bizutassiez',
    'bizutassions',
    'bizute',
    'bizutent',
    'bizuter',
    'bizutera',
    'bizuterai',
    'bizuteraient',
    'bizuterais',
    'bizuterait',
    'bizuteras',
    'bizuterez',
    'bizuteriez',
    'bizuterions',
    'bizuterons',
    'bizuteront',
    'bizutes',
    'bizutez',
    'bizutiez',
    'bizutions',
    'bizutons',
    'bizuts',
    'bizutâmes',
    'bizutât',
    'bizutâtes',
    'bizutèrent',
    'bizuté',
    'bizutée',
    'bizutées',
    'bizutés',
    'bière',
    'bières',
    'blabla',
    'blablabla',
    'blablablas',
    'blablas',
    'blablata',
    'blablatai',
    'blablataient',
    'blablatais',
    'blablatait',
    'blablatant',
    'blablatas',
    'blablatasse',
    'blablatasses',
    'blablate',
    'blablatent',
    'blablater',
    'blablatera',
    'blablaterai',
    'blablaterais',
    'blablaterait',
    'blablateras',
    'blablaterez',
    'blablateriez',
    'blablaterons',
    'blablateront',
    'blablates',
    'blablatez',
    'blablatiez',
    'blablations',
    'blablatons',
    'blablatâmes',
    'blablatât',
    'blablatâtes',
    'blablatèrent',
    'blablaté',
    'black',
    'blackboula',
    'blackboulage',
    'blackboulai',
    'blackboulais',
    'blackboulait',
    'blackboulant',
    'blackboulas',
    'blackboule',
    'blackboulent',
    'blackbouler',
    'blackboulera',
    'blackboules',
    'blackboulez',
    'blackbouliez',
    'blackboulons',
    'blackboulât',
    'blackboulé',
    'blackboulée',
    'blackboulées',
    'blackboulés',
    'blacks',
    'blafard',
    'blafarde',
    'blafardes',
    'blafards',
    'blagua',
    'blaguai',
    'blaguaient',
    'blaguais',
    'blaguait',
    'blaguant',
    'blaguas',
    'blaguasse',
    'blaguassent',
    'blaguasses',
    'blaguassiez',
    'blaguassions',
    'blague',
    'blaguent',
    'blaguer',
    'blaguera',
    'blaguerai',
    'blagueraient',
    'blaguerais',
    'blaguerait',
    'blagueras',
    'blaguerez',
    'blagueriez',
    'blaguerions',
    'blaguerons',
    'blagueront',
    'blagues',
    'blagueur',
    'blagueurs',
    'blagueuse',
    'blagueuses',
    'blaguez',
    'blaguiez',
    'blaguions',
    'blaguons',
    'blaguâmes',
    'blaguât',
    'blaguâtes',
    'blaguèrent',
    'blagué',
    'blaguée',
    'blaguées',
    'blagués',
    'blair',
    'blaira',
    'blairai',
    'blairaient',
    'blairais',
    'blairait',
    'blairant',
    'blairas',
    'blairasse',
    'blairassent',
    'blairasses',
    'blairassiez',
    'blairassions',
    'blaire',
    'blaireau',
    'blaireaux',
    'blairent',
    'blairer',
    'blairera',
    'blairerai',
    'blaireraient',
    'blairerais',
    'blairerait',
    'blaireras',
    'blairerez',
    'blaireriez',
    'blairerions',
    'blairerons',
    'blaireront',
    'blaires',
    'blairez',
    'blairiez',
    'blairions',
    'blairons',
    'blairs',
    'blairâmes',
    'blairât',
    'blairâtes',
    'blairèrent',
    'blairé',
    'blairée',
    'blairées',
    'blairés',
    'blanc',
    'blanchaille',
    'blanchailles',
    'blanche',
    'blanches',
    'blanchet',
    'blanchets',
    'blancheur',
    'blancheurs',
    'blanchi',
    'blanchie',
    'blanchies',
    'blanchiment',
    'blanchiments',
    'blanchir',
    'blanchira',
    'blanchirai',
    'blanchirais',
    'blanchirait',
    'blanchiras',
    'blanchirent',
    'blanchirez',
    'blanchiriez',
    'blanchirions',
    'blanchirons',
    'blanchiront',
    'blanchis',
    'blanchissage',
    'blanchissais',
    'blanchissait',
    'blanchissant',
    'blanchisse',
    'blanchissent',
    'blanchisses',
    'blanchisseur',
    'blanchissez',
    'blanchissiez',
    'blanchissons',
    'blanchit',
    'blanchâtre',
    'blanchâtres',
    'blanchîmes',
    'blanchît',
    'blanchîtes',
    'blancs',
    'blandice',
    'blandices',
    'blanquette',
    'blanquettes',
    'blaps',
    'blasa',
    'blasai',
    'blasaient',
    'blasais',
    'blasait',
    'blasant',
    'blasas',
    'blasasse',
    'blasassent',
    'blasasses',
    'blasassiez',
    'blasassions',
    'blase',
    'blasement',
    'blasements',
    'blasent',
    'blaser',
    'blasera',
    'blaserai',
    'blaseraient',
    'blaserais',
    'blaserait',
    'blaseras',
    'blaserez',
    'blaseriez',
    'blaserions',
    'blaserons',
    'blaseront',
    'blases',
    'blasez',
    'blasiez',
    'blasions',
    'blason',
    'blasonna',
    'blasonnai',
    'blasonnaient',
    'blasonnais',
    'blasonnait',
    'blasonnant',
    'blasonnas',
    'blasonnasse',
    'blasonnasses',
    'blasonne',
    'blasonnent',
    'blasonner',
    'blasonnera',
    'blasonnerai',
    'blasonnerais',
    'blasonnerait',
    'blasonneras',
    'blasonnerez',
    'blasonneriez',
    'blasonnerons',
    'blasonneront',
    'blasonnes',
    'blasonnez',
    'blasonniez',
    'blasonnions',
    'blasonnons',
    'blasonnâmes',
    'blasonnât',
    'blasonnâtes',
    'blasonnèrent',
    'blasonné',
    'blasonnée',
    'blasonnées',
    'blasonnés',
    'blasons',
    'blasphème',
    'blasphèment',
    'blasphèmes',
    'blasphéma',
    'blasphémai',
    'blasphémais',
    'blasphémait',
    'blasphémant',
    'blasphémas',
    'blasphémasse',
    'blasphémer',
    'blasphémera',
    'blasphémerai',
    'blasphémeras',
    'blasphémerez',
    'blasphémez',
    'blasphémiez',
    'blasphémions',
    'blasphémons',
    'blasphémâmes',
    'blasphémât',
    'blasphémâtes',
    'blasphémé',
    'blasphémée',
    'blasphémées',
    'blasphémés',
    'blastoderme',
    'blastodermes',
    'blastogenèse',
    'blastomycose',
    'blastopore',
    'blastopores',
    'blastula',
    'blastulas',
    'blasâmes',
    'blasât',
    'blasâtes',
    'blasèrent',
    'blasé',
    'blasée',
    'blasées',
    'blasés',
    'blatte',
    'blattes',
    'blatère',
    'blatèrent',
    'blatères',
    'blatéra',
    'blatérai',
    'blatéraient',
    'blatérais',
    'blatérait',
    'blatérant',
    'blatéras',
    'blatérasse',
    'blatérassent',
    'blatérasses',
    'blatérassiez',
    'blatérer',
    'blatérera',
    'blatérerai',
    'blatérerais',
    'blatérerait',
    'blatéreras',
    'blatérerez',
    'blatéreriez',
    'blatérerions',
    'blatérerons',
    'blatéreront',
    'blatérez',
    'blatériez',
    'blatérions',
    'blatérons',
    'blatérâmes',
    'blatérât',
    'blatérâtes',
    'blatérèrent',
    'blatéré',
    'blatérée',
    'blatérées',
    'blatérés',
    'blazer',
    'blazers',
    'bled',
    'bleds',
    'blende',
    'blendes',
    'blennie',
    'blennies',
    'blennorragie',
    'blennorrhée',
    'blennorrhées',
    'blessa',
    'blessai',
    'blessaient',
    'blessais',
    'blessait',
    'blessant',
    'blessante',
    'blessantes',
    'blessants',
    'blessas',
    'blessasse',
    'blessassent',
    'blessasses',
    'blessassiez',
    'blessassions',
    'blesse',
    'blessent',
    'blesser',
    'blessera',
    'blesserai',
    'blesseraient',
    'blesserais',
    'blesserait',
    'blesseras',
    'blesserez',
    'blesseriez',
    'blesserions',
    'blesserons',
    'blesseront',
    'blesses',
    'blessez',
    'blessiez',
    'blessions',
    'blessons',
    'blessure',
    'blessures',
    'blessâmes',
    'blessât',
    'blessâtes',
    'blessèrent',
    'blessé',
    'blessée',
    'blessées',
    'blessés',
    'blet',
    'blets',
    'blette',
    'blettes',
    'bletti',
    'blettir',
    'blettira',
    'blettirai',
    'blettiraient',
    'blettirais',
    'blettirait',
    'blettiras',
    'blettirent',
    'blettirez',
    'blettiriez',
    'blettirions',
    'blettirons',
    'blettiront',
    'blettis',
    'blettissais',
    'blettissait',
    'blettissant',
    'blettisse',
    'blettissent',
    'blettisses',
    'blettissez',
    'blettissiez',
    'blettissions',
    'blettissons',
    'blettissure',
    'blettissures',
    'blettit',
    'blettîmes',
    'blettît',
    'blettîtes',
    'bleu',
    'bleue',
    'bleues',
    'bleuet',
    'bleuetière',
    'bleuetières',
    'bleuets',
    'bleui',
    'bleuie',
    'bleuies',
    'bleuir',
    'bleuira',
    'bleuirai',
    'bleuiraient',
    'bleuirais',
    'bleuirait',
    'bleuiras',
    'bleuirent',
    'bleuirez',
    'bleuiriez',
    'bleuirions',
    'bleuirons',
    'bleuiront',
    'bleuis',
    'bleuissaient',
    'bleuissais',
    'bleuissait',
    'bleuissant',
    'bleuisse',
    'bleuissement',
    'bleuissent',
    'bleuisses',
    'bleuissez',
    'bleuissiez',
    'bleuissions',
    'bleuissons',
    'bleuit',
    'bleus',
    'bleusaille',
    'bleusailles',
    'bleuta',
    'bleutai',
    'bleutaient',
    'bleutais',
    'bleutait',
    'bleutant',
    'bleutas',
    'bleutasse',
    'bleutassent',
    'bleutasses',
    'bleutassiez',
    'bleutassions',
    'bleute',
    'bleutent',
    'bleuter',
    'bleutera',
    'bleuterai',
    'bleuteraient',
    'bleuterais',
    'bleuterait',
    'bleuteras',
    'bleuterez',
    'bleuteriez',
    'bleuterions',
    'bleuterons',
    'bleuteront',
    'bleutes',
    'bleutez',
    'bleutiez',
    'bleutions',
    'bleutons',
    'bleutâmes',
    'bleutât',
    'bleutâtes',
    'bleutèrent',
    'bleuté',
    'bleutée',
    'bleutées',
    'bleutés',
    'bleuâtre',
    'bleuâtres',
    'bleuîmes',
    'bleuît',
    'bleuîtes',
    'blinda',
    'blindage',
    'blindages',
    'blindai',
    'blindaient',
    'blindais',
    'blindait',
    'blindant',
    'blindas',
    'blindasse',
    'blindassent',
    'blindasses',
    'blindassiez',
    'blindassions',
    'blinde',
    'blindent',
    'blinder',
    'blindera',
    'blinderai',
    'blinderaient',
    'blinderais',
    'blinderait',
    'blinderas',
    'blinderez',
    'blinderiez',
    'blinderions',
    'blinderons',
    'blinderont',
    'blindes',
    'blindez',
    'blindiez',
    'blindions',
    'blindons',
    'blindâmes',
    'blindât',
    'blindâtes',
    'blindèrent',
    'blindé',
    'blindée',
    'blindées',
    'blindés',
    'blister',
    'blisters',
    'blizzard',
    'blizzards',
    'bloc',
    'blocage',
    'blocages',
    'blocaille',
    'blocailles',
    'blockhaus',
    'blocs',
    'blocus',
    'blond',
    'blondasse',
    'blondasses',
    'blonde',
    'blondel',
    'blondels',
    'blondes',
    'blondeur',
    'blondeurs',
    'blondi',
    'blondie',
    'blondies',
    'blondin',
    'blondine',
    'blondines',
    'blondinet',
    'blondinets',
    'blondinette',
    'blondinettes',
    'blondins',
    'blondir',
    'blondira',
    'blondiraient',
    'blondirait',
    'blondirent',
    'blondiront',
    'blondis',
    'blondissais',
    'blondissait',
    'blondissant',
    'blondisse',
    'blondissent',
    'blondisses',
    'blondissez',
    'blondissiez',
    'blondissions',
    'blondissons',
    'blondit',
    'blondoie',
    'blondoient',
    'blondoiera',
    'blondoierai',
    'blondoierais',
    'blondoierait',
    'blondoieras',
    'blondoierez',
    'blondoieriez',
    'blondoierons',
    'blondoieront',
    'blondoies',
    'blondoya',
    'blondoyai',
    'blondoyaient',
    'blondoyais',
    'blondoyait',
    'blondoyant',
    'blondoyas',
    'blondoyasse',
    'blondoyasses',
    'blondoyer',
    'blondoyez',
    'blondoyiez',
    'blondoyions',
    'blondoyons',
    'blondoyâmes',
    'blondoyât',
    'blondoyâtes',
    'blondoyèrent',
    'blondoyé',
    'blonds',
    'blondîmes',
    'blondît',
    'blondîtes',
    'bloomer',
    'bloomers',
    'bloqua',
    'bloquai',
    'bloquaient',
    'bloquais',
    'bloquait',
    'bloquant',
    'bloquante',
    'bloquantes',
    'bloquants',
    'bloquas',
    'bloquasse',
    'bloquassent',
    'bloquasses',
    'bloquassiez',
    'bloquassions',
    'bloque',
    'bloquent',
    'bloquer',
    'bloquera',
    'bloquerai',
    'bloqueraient',
    'bloquerais',
    'bloquerait',
    'bloqueras',
    'bloquerez',
    'bloqueriez',
    'bloquerions',
    'bloquerons',
    'bloqueront',
    'bloques',
    'bloquez',
    'bloquiez',
    'bloquions',
    'bloquons',
    'bloquâmes',
    'bloquât',
    'bloquâtes',
    'bloquèrent',
    'bloqué',
    'bloquée',
    'bloquées',
    'bloqués',
    'blotti',
    'blottie',
    'blotties',
    'blottir',
    'blottira',
    'blottirai',
    'blottiraient',
    'blottirais',
    'blottirait',
    'blottiras',
    'blottirent',
    'blottirez',
    'blottiriez',
    'blottirions',
    'blottirons',
    'blottiront',
    'blottis',
    'blottissais',
    'blottissait',
    'blottissant',
    'blottisse',
    'blottissent',
    'blottisses',
    'blottissez',
    'blottissiez',
    'blottissions',
    'blottissons',
    'blottit',
    'blottîmes',
    'blottît',
    'blottîtes',
    'blousa',
    'blousai',
    'blousaient',
    'blousais',
    'blousait',
    'blousant',
    'blousas',
    'blousasse',
    'blousassent',
    'blousasses',
    'blousassiez',
    'blousassions',
    'blouse',
    'blousent',
    'blouser',
    'blousera',
    'blouserai',
    'blouseraient',
    'blouserais',
    'blouserait',
    'blouseras',
    'blouserez',
    'blouseriez',
    'blouserions',
    'blouserons',
    'blouseront',
    'blouses',
    'blousez',
    'blousiez',
    'blousions',
    'blouson',
    'blousons',
    'blousâmes',
    'blousât',
    'blousâtes',
    'blousèrent',
    'blousé',
    'blousée',
    'blousées',
    'blousés',
    'blues',
    'bluet',
    'bluets',
    'bluette',
    'bluettes',
    'bluff',
    'bluffa',
    'bluffai',
    'bluffaient',
    'bluffais',
    'bluffait',
    'bluffant',
    'bluffas',
    'bluffasse',
    'bluffassent',
    'bluffasses',
    'bluffassiez',
    'bluffassions',
    'bluffe',
    'bluffent',
    'bluffer',
    'bluffera',
    'blufferai',
    'blufferaient',
    'blufferais',
    'blufferait',
    'blufferas',
    'blufferez',
    'blufferiez',
    'blufferions',
    'blufferons',
    'blufferont',
    'bluffes',
    'bluffeur',
    'bluffeurs',
    'bluffeuse',
    'bluffeuses',
    'bluffez',
    'bluffiez',
    'bluffions',
    'bluffons',
    'bluffs',
    'bluffâmes',
    'bluffât',
    'bluffâtes',
    'bluffèrent',
    'bluffé',
    'bluffée',
    'bluffées',
    'bluffés',
    'bluta',
    'blutage',
    'blutages',
    'blutai',
    'blutaient',
    'blutais',
    'blutait',
    'blutant',
    'blutas',
    'blutasse',
    'blutassent',
    'blutasses',
    'blutassiez',
    'blutassions',
    'blute',
    'blutent',
    'bluter',
    'blutera',
    'bluterai',
    'bluteraient',
    'bluterais',
    'bluterait',
    'bluteras',
    'bluterez',
    'bluteriez',
    'bluterions',
    'bluterons',
    'bluteront',
    'blutes',
    'blutez',
    'blutiez',
    'blutions',
    'blutoir',
    'blutoirs',
    'blutons',
    'blutâmes',
    'blutât',
    'blutâtes',
    'blutèrent',
    'bluté',
    'blutée',
    'blutées',
    'blutés',
    'blâma',
    'blâmable',
    'blâmables',
    'blâmai',
    'blâmaient',
    'blâmais',
    'blâmait',
    'blâmant',
    'blâmas',
    'blâmasse',
    'blâmassent',
    'blâmasses',
    'blâmassiez',
    'blâmassions',
    'blâme',
    'blâment',
    'blâmer',
    'blâmera',
    'blâmerai',
    'blâmeraient',
    'blâmerais',
    'blâmerait',
    'blâmeras',
    'blâmerez',
    'blâmeriez',
    'blâmerions',
    'blâmerons',
    'blâmeront',
    'blâmes',
    'blâmez',
    'blâmiez',
    'blâmions',
    'blâmons',
    'blâmâmes',
    'blâmât',
    'blâmâtes',
    'blâmèrent',
    'blâmé',
    'blâmée',
    'blâmées',
    'blâmés',
    'blèche',
    'blèches',
    'blèse',
    'blèsement',
    'blèsements',
    'blèsent',
    'blèses',
    'blépharite',
    'blépharites',
    'blés',
    'blésa',
    'blésai',
    'blésaient',
    'blésais',
    'blésait',
    'blésant',
    'blésas',
    'blésasse',
    'blésassent',
    'blésasses',
    'blésassiez',
    'blésassions',
    'bléser',
    'blésera',
    'bléserai',
    'bléseraient',
    'bléserais',
    'bléserait',
    'bléseras',
    'bléserez',
    'bléseriez',
    'bléserions',
    'bléserons',
    'bléseront',
    'blésez',
    'blésiez',
    'blésions',
    'blésité',
    'blésités',
    'blésons',
    'blésâmes',
    'blésât',
    'blésâtes',
    'blésèrent',
    'blésé',
    'blésée',
    'blésées',
    'blésés',
    'blêmaient',
    'blêmais',
    'blêmait',
    'blêmant',
    'blême',
    'blêmera',
    'blêmerai',
    'blêmeraient',
    'blêmerais',
    'blêmerait',
    'blêmeras',
    'blêmerez',
    'blêmeriez',
    'blêmerions',
    'blêmerons',
    'blêmeront',
    'blêmes',
    'blêmez',
    'blêmi',
    'blêmie',
    'blêmies',
    'blêmiez',
    'blêmions',
    'blêmir',
    'blêmira',
    'blêmirai',
    'blêmiraient',
    'blêmirais',
    'blêmirait',
    'blêmiras',
    'blêmirent',
    'blêmirez',
    'blêmiriez',
    'blêmirions',
    'blêmirons',
    'blêmiront',
    'blêmis',
    'blêmissaient',
    'blêmissais',
    'blêmissait',
    'blêmissant',
    'blêmisse',
    'blêmissement',
    'blêmissent',
    'blêmisses',
    'blêmissez',
    'blêmissiez',
    'blêmissions',
    'blêmissons',
    'blêmit',
    'blêmons',
    'blêmîmes',
    'blêmît',
    'blêmîtes',
    'boas',
    'bobard',
    'bobards',
    'bobina',
    'bobinage',
    'bobinages',
    'bobinai',
    'bobinaient',
    'bobinais',
    'bobinait',
    'bobinant',
    'bobinas',
    'bobinasse',
    'bobinassent',
    'bobinasses',
    'bobinassiez',
    'bobinassions',
    'bobine',
    'bobinent',
    'bobiner',
    'bobinera',
    'bobinerai',
    'bobineraient',
    'bobinerais',
    'bobinerait',
    'bobineras',
    'bobinerez',
    'bobineriez',
    'bobinerions',
    'bobinerons',
    'bobineront',
    'bobines',
    'bobinette',
    'bobinettes',
    'bobineur',
    'bobineurs',
    'bobineuse',
    'bobineuses',
    'bobinez',
    'bobinier',
    'bobiniers',
    'bobiniez',
    'bobinions',
    'bobinoir',
    'bobinoirs',
    'bobinons',
    'bobinâmes',
    'bobinât',
    'bobinâtes',
    'bobinèrent',
    'bobiné',
    'bobinée',
    'bobinées',
    'bobinés',
    'bobo',
    'bobonne',
    'bobonnes',
    'bobos',
    'bobs',
    'bobsleigh',
    'bobsleighs',
    'bobèche',
    'bobèches',
    'bocage',
    'bocager',
    'bocagers',
    'bocages',
    'bocagère',
    'bocagères',
    'bocal',
    'bocard',
    'bocarda',
    'bocardage',
    'bocardages',
    'bocardai',
    'bocardaient',
    'bocardais',
    'bocardait',
    'bocardant',
    'bocardas',
    'bocardasse',
    'bocardassent',
    'bocardasses',
    'bocardassiez',
    'bocarde',
    'bocardent',
    'bocarder',
    'bocardera',
    'bocarderai',
    'bocarderais',
    'bocarderait',
    'bocarderas',
    'bocarderez',
    'bocarderiez',
    'bocarderions',
    'bocarderons',
    'bocarderont',
    'bocardes',
    'bocardez',
    'bocardiez',
    'bocardions',
    'bocardons',
    'bocards',
    'bocardâmes',
    'bocardât',
    'bocardâtes',
    'bocardèrent',
    'bocardé',
    'bocardée',
    'bocardées',
    'bocardés',
    'bocaux',
    'boche',
    'boches',
    'bock',
    'bocks',
    'bodhisattva',
    'boetta',
    'boettai',
    'boettaient',
    'boettais',
    'boettait',
    'boettant',
    'boettas',
    'boettasse',
    'boettassent',
    'boettasses',
    'boettassiez',
    'boettassions',
    'boette',
    'boettent',
    'boetter',
    'boettera',
    'boetterai',
    'boetteraient',
    'boetterais',
    'boetterait',
    'boetteras',
    'boetterez',
    'boetteriez',
    'boetterions',
    'boetterons',
    'boetteront',
    'boettes',
    'boettez',
    'boettiez',
    'boettions',
    'boettons',
    'boettâmes',
    'boettât',
    'boettâtes',
    'boettèrent',
    'boetté',
    'boettée',
    'boettées',
    'boettés',
    'boeuf',
    'boeufs',
    'boghei',
    'bogheis',
    'bogie',
    'bogies',
    'bogue',
    'bogues',
    'bohème',
    'bohèmes',
    'bohémien',
    'bohémienne',
    'bohémiennes',
    'bohémiens',
    'boille',
    'boilles',
    'boira',
    'boirai',
    'boiraient',
    'boirais',
    'boirait',
    'boiras',
    'boire',
    'boirez',
    'boiriez',
    'boirions',
    'boirons',
    'boiront',
    'bois',
    'boisa',
    'boisage',
    'boisages',
    'boisai',
    'boisaient',
    'boisais',
    'boisait',
    'boisant',
    'boisas',
    'boisasse',
    'boisassent',
    'boisasses',
    'boisassiez',
    'boisassions',
    'boise',
    'boisement',
    'boisements',
    'boisent',
    'boiser',
    'boisera',
    'boiserai',
    'boiseraient',
    'boiserais',
    'boiserait',
    'boiseras',
    'boiserez',
    'boiserie',
    'boiseries',
    'boiseriez',
    'boiserions',
    'boiserons',
    'boiseront',
    'boises',
    'boiseur',
    'boiseurs',
    'boisez',
    'boisiez',
    'boisions',
    'boisons',
    'boisseau',
    'boisseaux',
    'boisselier',
    'boisseliers',
    'boissellerie',
    'boisson',
    'boissons',
    'boisâmes',
    'boisât',
    'boisâtes',
    'boisèrent',
    'boisé',
    'boisée',
    'boisées',
    'boisés',
    'boit',
    'boita',
    'boitai',
    'boitaient',
    'boitais',
    'boitait',
    'boitant',
    'boitas',
    'boitasse',
    'boitassent',
    'boitasses',
    'boitassiez',
    'boitassions',
    'boite',
    'boitement',
    'boitements',
    'boitent',
    'boiter',
    'boitera',
    'boiterai',
    'boiteraient',
    'boiterais',
    'boiterait',
    'boiteras',
    'boiterez',
    'boiterie',
    'boiteries',
    'boiteriez',
    'boiterions',
    'boiterons',
    'boiteront',
    'boites',
    'boiteuse',
    'boiteuses',
    'boiteux',
    'boitez',
    'boitiez',
    'boitilla',
    'boitillai',
    'boitillaient',
    'boitillais',
    'boitillait',
    'boitillant',
    'boitillante',
    'boitillantes',
    'boitillants',
    'boitillas',
    'boitillasse',
    'boitillasses',
    'boitille',
    'boitillement',
    'boitillent',
    'boitiller',
    'boitillera',
    'boitillerai',
    'boitillerais',
    'boitillerait',
    'boitilleras',
    'boitillerez',
    'boitilleriez',
    'boitillerons',
    'boitilleront',
    'boitilles',
    'boitillez',
    'boitilliez',
    'boitillions',
    'boitillons',
    'boitillâmes',
    'boitillât',
    'boitillâtes',
    'boitillèrent',
    'boitillé',
    'boitions',
    'boitons',
    'boitâmes',
    'boitât',
    'boitâtes',
    'boitèrent',
    'boité',
    'boive',
    'boivent',
    'boives',
    'bolchevik',
    'bolcheviks',
    'bolchevisme',
    'bolchevismes',
    'bolcheviste',
    'bolchevistes',
    'bolchévisa',
    'bolchévisai',
    'bolchévisais',
    'bolchévisait',
    'bolchévisant',
    'bolchévisas',
    'bolchévise',
    'bolchévisent',
    'bolchéviser',
    'bolchévisera',
    'bolchévises',
    'bolchévisez',
    'bolchévisiez',
    'bolchévisons',
    'bolchévisât',
    'bolchévisé',
    'bolchévisée',
    'bolchévisées',
    'bolchévisés',
    'boldo',
    'boldos',
    'bolduc',
    'bolducs',
    'bolet',
    'bolets',
    'bolide',
    'bolides',
    'bolier',
    'boliers',
    'bolivar',
    'bolivares',
    'bolivars',
    'bollard',
    'bollards',
    'bolomètre',
    'bolomètres',
    'bols',
    'bolée',
    'bolées',
    'boléro',
    'boléros',
    'bomba',
    'bombage',
    'bombages',
    'bombagiste',
    'bombagistes',
    'bombai',
    'bombaient',
    'bombais',
    'bombait',
    'bombance',
    'bombances',
    'bombant',
    'bombante',
    'bombantes',
    'bombants',
    'bombarda',
    'bombardai',
    'bombardaient',
    'bombardais',
    'bombardait',
    'bombardant',
    'bombardas',
    'bombardasse',
    'bombardasses',
    'bombarde',
    'bombardement',
    'bombardent',
    'bombarder',
    'bombardera',
    'bombarderai',
    'bombarderais',
    'bombarderait',
    'bombarderas',
    'bombarderez',
    'bombarderiez',
    'bombarderons',
    'bombarderont',
    'bombardes',
    'bombardez',
    'bombardier',
    'bombardiers',
    'bombardiez',
    'bombardions',
    'bombardon',
    'bombardons',
    'bombardâmes',
    'bombardât',
    'bombardâtes',
    'bombardèrent',
    'bombardé',
    'bombardée',
    'bombardées',
    'bombardés',
    'bombas',
    'bombasse',
    'bombassent',
    'bombasses',
    'bombassiez',
    'bombassions',
    'bombe',
    'bombement',
    'bombements',
    'bombent',
    'bomber',
    'bombera',
    'bomberai',
    'bomberaient',
    'bomberais',
    'bomberait',
    'bomberas',
    'bomberez',
    'bomberiez',
    'bomberions',
    'bomberons',
    'bomberont',
    'bombes',
    'bombez',
    'bombiez',
    'bombions',
    'bombons',
    'bombyx',
    'bombâmes',
    'bombât',
    'bombâtes',
    'bombèrent',
    'bombé',
    'bombée',
    'bombées',
    'bombés',
    'bonace',
    'bonaces',
    'bonapartisme',
    'bonapartiste',
    'bonasse',
    'bonasserie',
    'bonasseries',
    'bonasses',
    'bonbon',
    'bonbonne',
    'bonbonnes',
    'bonbonnière',
    'bonbonnières',
    'bonbons',
    'bond',
    'bonda',
    'bondai',
    'bondaient',
    'bondais',
    'bondait',
    'bondant',
    'bondas',
    'bondasse',
    'bondassent',
    'bondasses',
    'bondassiez',
    'bondassions',
    'bonde',
    'bondelle',
    'bondelles',
    'bondent',
    'bonder',
    'bondera',
    'bonderai',
    'bonderaient',
    'bonderais',
    'bonderait',
    'bonderas',
    'bonderez',
    'bonderiez',
    'bonderions',
    'bonderons',
    'bonderont',
    'bondes',
    'bondez',
    'bondi',
    'bondieuserie',
    'bondiez',
    'bondions',
    'bondir',
    'bondira',
    'bondirai',
    'bondiraient',
    'bondirais',
    'bondirait',
    'bondiras',
    'bondirent',
    'bondirez',
    'bondiriez',
    'bondirions',
    'bondirons',
    'bondiront',
    'bondis',
    'bondissaient',
    'bondissais',
    'bondissait',
    'bondissant',
    'bondissante',
    'bondissantes',
    'bondissants',
    'bondisse',
    'bondissement',
    'bondissent',
    'bondisses',
    'bondissez',
    'bondissiez',
    'bondissions',
    'bondissons',
    'bondit',
    'bondon',
    'bondonna',
    'bondonnai',
    'bondonnaient',
    'bondonnais',
    'bondonnait',
    'bondonnant',
    'bondonnas',
    'bondonnasse',
    'bondonnasses',
    'bondonne',
    'bondonnent',
    'bondonner',
    'bondonnera',
    'bondonnerai',
    'bondonnerais',
    'bondonnerait',
    'bondonneras',
    'bondonnerez',
    'bondonneriez',
    'bondonnerons',
    'bondonneront',
    'bondonnes',
    'bondonnez',
    'bondonniez',
    'bondonnions',
    'bondonnons',
    'bondonnâmes',
    'bondonnât',
    'bondonnâtes',
    'bondonnèrent',
    'bondonné',
    'bondonnée',
    'bondonnées',
    'bondonnés',
    'bondons',
    'bondrée',
    'bondrées',
    'bonds',
    'bondâmes',
    'bondât',
    'bondâtes',
    'bondèrent',
    'bondé',
    'bondée',
    'bondées',
    'bondérisa',
    'bondérisai',
    'bondérisais',
    'bondérisait',
    'bondérisant',
    'bondérisas',
    'bondérisasse',
    'bondérise',
    'bondérisent',
    'bondériser',
    'bondérisera',
    'bondériserai',
    'bondériseras',
    'bondériserez',
    'bondérises',
    'bondérisez',
    'bondérisiez',
    'bondérisions',
    'bondérisons',
    'bondérisâmes',
    'bondérisât',
    'bondérisâtes',
    'bondérisé',
    'bondérisée',
    'bondérisées',
    'bondérisés',
    'bondés',
    'bondîmes',
    'bondît',
    'bondîtes',
    'bonheur',
    'bonheurs',
    'bonhomie',
    'bonhomies',
    'bonhomme',
    'boni',
    'boniche',
    'boniches',
    'bonichon',
    'bonichons',
    'bonifia',
    'bonifiai',
    'bonifiaient',
    'bonifiais',
    'bonifiait',
    'bonifiant',
    'bonifiante',
    'bonifiantes',
    'bonifiants',
    'bonifias',
    'bonifiasse',
    'bonifiassent',
    'bonifiasses',
    'bonifiassiez',
    'bonification',
    'bonifie',
    'bonifient',
    'bonifier',
    'bonifiera',
    'bonifierai',
    'bonifierais',
    'bonifierait',
    'bonifieras',
    'bonifierez',
    'bonifieriez',
    'bonifierions',
    'bonifierons',
    'bonifieront',
    'bonifies',
    'bonifiez',
    'bonifiiez',
    'bonifiions',
    'bonifions',
    'bonifiâmes',
    'bonifiât',
    'bonifiâtes',
    'bonifièrent',
    'bonifié',
    'bonifiée',
    'bonifiées',
    'bonifiés',
    'boniment',
    'bonimenta',
    'bonimentai',
    'bonimentais',
    'bonimentait',
    'bonimentant',
    'bonimentas',
    'bonimentasse',
    'bonimente',
    'bonimentent',
    'bonimenter',
    'bonimentera',
    'bonimenterai',
    'bonimenteras',
    'bonimenterez',
    'bonimentes',
    'bonimenteur',
    'bonimenteurs',
    'bonimenteuse',
    'bonimentez',
    'bonimentiez',
    'bonimentions',
    'bonimentons',
    'boniments',
    'bonimentâmes',
    'bonimentât',
    'bonimentâtes',
    'bonimenté',
    'bonis',
    'bonite',
    'bonites',
    'bonjour',
    'bonjours',
    'bonne',
    'bonnement',
    'bonnes',
    'bonnet',
    'bonneteau',
    'bonneteaux',
    'bonneterie',
    'bonneteries',
    'bonneteur',
    'bonneteurs',
    'bonnetier',
    'bonnetiers',
    'bonnetière',
    'bonnetières',
    'bonnets',
    'bonnette',
    'bonnettes',
    'bons',
    'bonsaï',
    'bonsaïs',
    'bonshommes',
    'bonsoir',
    'bonsoirs',
    'bonté',
    'bontés',
    'bonus',
    'bonze',
    'bonzerie',
    'bonzeries',
    'bonzes',
    'bookmaker',
    'bookmakers',
    'booléen',
    'booléenne',
    'booléennes',
    'booléens',
    'boom',
    'boomerang',
    'boomerangs',
    'booms',
    'booster',
    'boosters',
    'bootlegger',
    'bootleggers',
    'boots',
    'boqueteau',
    'boqueteaux',
    'bora',
    'boras',
    'borate',
    'borates',
    'borax',
    'borborygme',
    'borborygmes',
    'bord',
    'borda',
    'bordage',
    'bordages',
    'bordai',
    'bordaient',
    'bordais',
    'bordait',
    'bordant',
    'bordas',
    'bordasse',
    'bordassent',
    'bordasses',
    'bordassiez',
    'bordassions',
    'borde',
    'bordeaux',
    'bordel',
    'bordelais',
    'bordelaise',
    'bordelaises',
    'bordels',
    'bordent',
    'border',
    'bordera',
    'borderai',
    'borderaient',
    'borderais',
    'borderait',
    'borderas',
    'bordereau',
    'bordereaux',
    'borderez',
    'borderie',
    'borderies',
    'borderiez',
    'borderions',
    'borderons',
    'borderont',
    'bordes',
    'bordez',
    'bordier',
    'bordiers',
    'bordiez',
    'bordigue',
    'bordigues',
    'bordions',
    'bordière',
    'bordières',
    'bordons',
    'bords',
    'bordure',
    'bordures',
    'bordâmes',
    'bordât',
    'bordâtes',
    'bordèrent',
    'bordé',
    'bordée',
    'bordées',
    'bordélique',
    'bordéliques',
    'bordés',
    'bore',
    'bores',
    'borgne',
    'borgnes',
    'boriqué',
    'boriqués',
    'borna',
    'bornage',
    'bornages',
    'bornai',
    'bornaient',
    'bornais',
    'bornait',
    'bornant',
    'bornas',
    'bornasse',
    'bornassent',
    'bornasses',
    'bornassiez',
    'bornassions',
    'borne',
    'bornent',
    'borner',
    'bornera',
    'bornerai',
    'borneraient',
    'bornerais',
    'bornerait',
    'borneras',
    'bornerez',
    'borneriez',
    'bornerions',
    'bornerons',
    'borneront',
    'bornes',
    'bornez',
    'borniez',
    'bornions',
    'bornoie',
    'bornoient',
    'bornoiera',
    'bornoierai',
    'bornoierais',
    'bornoierait',
    'bornoieras',
    'bornoierez',
    'bornoieriez',
    'bornoierions',
    'bornoierons',
    'bornoieront',
    'bornoies',
    'bornons',
    'bornoya',
    'bornoyai',
    'bornoyaient',
    'bornoyais',
    'bornoyait',
    'bornoyant',
    'bornoyas',
    'bornoyasse',
    'bornoyassent',
    'bornoyasses',
    'bornoyassiez',
    'bornoyer',
    'bornoyez',
    'bornoyiez',
    'bornoyions',
    'bornoyons',
    'bornoyâmes',
    'bornoyât',
    'bornoyâtes',
    'bornoyèrent',
    'bornoyé',
    'bornoyée',
    'bornoyées',
    'bornoyés',
    'bornâmes',
    'bornât',
    'bornâtes',
    'bornèrent',
    'borné',
    'bornée',
    'bornées',
    'bornés',
    'bort',
    'borts',
    'bortsch',
    'bortschs',
    'boréal',
    'boréale',
    'boréales',
    'boréals',
    'boréaux',
    'bosco',
    'boscos',
    'boscot',
    'boscots',
    'boscotte',
    'boscottes',
    'bosquet',
    'bosquets',
    'boss',
    'bossa',
    'bossage',
    'bossages',
    'bossai',
    'bossaient',
    'bossais',
    'bossait',
    'bossant',
    'bossas',
    'bossasse',
    'bossassent',
    'bossasses',
    'bossassiez',
    'bossassions',
    'bosse',
    'bossela',
    'bosselage',
    'bosselages',
    'bosselai',
    'bosselaient',
    'bosselais',
    'bosselait',
    'bosselant',
    'bosselas',
    'bosselasse',
    'bosselassent',
    'bosselasses',
    'bosselassiez',
    'bosseler',
    'bosselez',
    'bosseliez',
    'bosselions',
    'bosselle',
    'bossellement',
    'bossellent',
    'bossellera',
    'bossellerai',
    'bossellerais',
    'bossellerait',
    'bosselleras',
    'bossellerez',
    'bosselleriez',
    'bossellerons',
    'bosselleront',
    'bosselles',
    'bosselons',
    'bosselure',
    'bosselures',
    'bosselâmes',
    'bosselât',
    'bosselâtes',
    'bosselèrent',
    'bosselé',
    'bosselée',
    'bosselées',
    'bosselés',
    'bossent',
    'bosser',
    'bossera',
    'bosserai',
    'bosseraient',
    'bosserais',
    'bosserait',
    'bosseras',
    'bosserez',
    'bosseriez',
    'bosserions',
    'bosserons',
    'bosseront',
    'bosses',
    'bossette',
    'bossettes',
    'bosseur',
    'bosseurs',
    'bosseuse',
    'bosseuses',
    'bossez',
    'bossiez',
    'bossions',
    'bossoir',
    'bossoirs',
    'bossons',
    'bossu',
    'bossua',
    'bossuai',
    'bossuaient',
    'bossuais',
    'bossuait',
    'bossuant',
    'bossuas',
    'bossuasse',
    'bossuassent',
    'bossuasses',
    'bossuassiez',
    'bossuassions',
    'bossue',
    'bossuent',
    'bossuer',
    'bossuera',
    'bossuerai',
    'bossueraient',
    'bossuerais',
    'bossuerait',
    'bossueras',
    'bossuerez',
    'bossueriez',
    'bossuerions',
    'bossuerons',
    'bossueront',
    'bossues',
    'bossuez',
    'bossuiez',
    'bossuions',
    'bossuons',
    'bossus',
    'bossuâmes',
    'bossuât',
    'bossuâtes',
    'bossuèrent',
    'bossué',
    'bossuée',
    'bossuées',
    'bossués',
    'bossâmes',
    'bossât',
    'bossâtes',
    'bossèrent',
    'bossé',
    'bossée',
    'bossées',
    'bossés',
    'boston',
    'bostonner',
    'bostons',
    'bostryche',
    'bostryches',
    'botanique',
    'botaniques',
    'botanisa',
    'botanisai',
    'botanisaient',
    'botanisais',
    'botanisait',
    'botanisant',
    'botanisas',
    'botanisasse',
    'botanisasses',
    'botanise',
    'botanisent',
    'botaniser',
    'botanisera',
    'botaniserai',
    'botaniserais',
    'botaniserait',
    'botaniseras',
    'botaniserez',
    'botaniseriez',
    'botaniserons',
    'botaniseront',
    'botanises',
    'botanisez',
    'botanisiez',
    'botanisions',
    'botanisons',
    'botaniste',
    'botanistes',
    'botanisâmes',
    'botanisât',
    'botanisâtes',
    'botanisèrent',
    'botanisé',
    'bote',
    'botes',
    'bots',
    'botta',
    'bottai',
    'bottaient',
    'bottais',
    'bottait',
    'bottant',
    'bottas',
    'bottasse',
    'bottassent',
    'bottasses',
    'bottassiez',
    'bottassions',
    'botte',
    'bottela',
    'bottelage',
    'bottelages',
    'bottelai',
    'bottelaient',
    'bottelais',
    'bottelait',
    'bottelant',
    'bottelas',
    'bottelasse',
    'bottelassent',
    'bottelasses',
    'bottelassiez',
    'botteler',
    'botteleur',
    'botteleurs',
    'botteleuse',
    'botteleuses',
    'bottelez',
    'botteliez',
    'bottelions',
    'bottelle',
    'bottellent',
    'bottellera',
    'bottellerai',
    'bottellerais',
    'bottellerait',
    'bottelleras',
    'bottellerez',
    'bottelleriez',
    'bottellerons',
    'bottelleront',
    'bottelles',
    'bottelons',
    'bottelâmes',
    'bottelât',
    'bottelâtes',
    'bottelèrent',
    'bottelé',
    'bottelée',
    'bottelées',
    'bottelés',
    'bottent',
    'botter',
    'bottera',
    'botterai',
    'botteraient',
    'botterais',
    'botterait',
    'botteras',
    'botterez',
    'botteriez',
    'botterions',
    'botterons',
    'botteront',
    'bottes',
    'bottez',
    'bottier',
    'bottiers',
    'bottiez',
    'bottillon',
    'bottillons',
    'bottin',
    'bottine',
    'bottines',
    'bottins',
    'bottions',
    'bottons',
    'bottâmes',
    'bottât',
    'bottâtes',
    'bottèrent',
    'botté',
    'bottée',
    'bottées',
    'bottés',
    'botulique',
    'botuliques',
    'botulisme',
    'boubou',
    'boubouler',
    'boubous',
    'bouc',
    'boucan',
    'boucana',
    'boucanage',
    'boucanages',
    'boucanai',
    'boucanaient',
    'boucanais',
    'boucanait',
    'boucanant',
    'boucanas',
    'boucanasse',
    'boucanassent',
    'boucanasses',
    'boucanassiez',
    'boucane',
    'boucanent',
    'boucaner',
    'boucanera',
    'boucanerai',
    'boucanerais',
    'boucanerait',
    'boucaneras',
    'boucanerez',
    'boucaneriez',
    'boucanerions',
    'boucanerons',
    'boucaneront',
    'boucanes',
    'boucanez',
    'boucanier',
    'boucaniers',
    'boucaniez',
    'boucanions',
    'boucanons',
    'boucans',
    'boucanâmes',
    'boucanât',
    'boucanâtes',
    'boucanèrent',
    'boucané',
    'boucanée',
    'boucanées',
    'boucanés',
    'boucau',
    'boucaus',
    'boucha',
    'bouchage',
    'bouchages',
    'bouchai',
    'bouchaient',
    'bouchais',
    'bouchait',
    'bouchant',
    'boucharda',
    'bouchardai',
    'bouchardais',
    'bouchardait',
    'bouchardant',
    'bouchardas',
    'bouchardasse',
    'boucharde',
    'bouchardent',
    'boucharder',
    'bouchardera',
    'boucharderai',
    'boucharderas',
    'boucharderez',
    'bouchardes',
    'bouchardez',
    'bouchardiez',
    'bouchardions',
    'bouchardons',
    'bouchardâmes',
    'bouchardât',
    'bouchardâtes',
    'bouchardé',
    'bouchardée',
    'bouchardées',
    'bouchardés',
    'bouchas',
    'bouchasse',
    'bouchassent',
    'bouchasses',
    'bouchassiez',
    'bouchassions',
    'bouche',
    'bouchent',
    'boucher',
    'bouchera',
    'boucherai',
    'boucheraient',
    'boucherais',
    'boucherait',
    'boucheras',
    'boucherez',
    'boucherie',
    'boucheries',
    'boucheriez',
    'boucherions',
    'boucherons',
    'boucheront',
    'bouchers',
    'bouches',
    'bouchez',
    'bouchiez',
    'bouchions',
    'bouchon',
    'bouchonna',
    'bouchonnai',
    'bouchonnais',
    'bouchonnait',
    'bouchonnant',
    'bouchonnas',
    'bouchonnasse',
    'bouchonne',
    'bouchonnent',
    'bouchonner',
    'bouchonnera',
    'bouchonnerai',
    'bouchonneras',
    'bouchonnerez',
    'bouchonnes',
    'bouchonnez',
    'bouchonnier',
    'bouchonniers',
    'bouchonniez',
    'bouchonnions',
    'bouchonnons',
    'bouchonnâmes',
    'bouchonnât',
    'bouchonnâtes',
    'bouchonné',
    'bouchonnée',
    'bouchonnées',
    'bouchonnés',
    'bouchons',
    'bouchot',
    'bouchoteur',
    'bouchoteurs',
    'bouchots',
    'bouchâmes',
    'bouchât',
    'bouchâtes',
    'bouchère',
    'bouchèrent',
    'bouchères',
    'bouché',
    'bouchée',
    'bouchées',
    'bouchés',
    'boucla',
    'bouclage',
    'bouclages',
    'bouclai',
    'bouclaient',
    'bouclais',
    'bouclait',
    'bouclant',
    'bouclas',
    'bouclasse',
    'bouclassent',
    'bouclasses',
    'bouclassiez',
    'bouclassions',
    'boucle',
    'bouclent',
    'boucler',
    'bouclera',
    'bouclerai',
    'boucleraient',
    'bouclerais',
    'bouclerait',
    'boucleras',
    'bouclerez',
    'boucleriez',
    'bouclerions',
    'bouclerons',
    'boucleront',
    'boucles',
    'bouclette',
    'bouclettes',
    'bouclez',
    'bouclier',
    'boucliers',
    'boucliez',
    'bouclions',
    'bouclons',
    'bouclâmes',
    'bouclât',
    'bouclâtes',
    'bouclèrent',
    'bouclé',
    'bouclée',
    'bouclées',
    'bouclés',
    'boucs',
    'bouda',
    'boudai',
    'boudaient',
    'boudais',
    'boudait',
    'boudant',
    'boudas',
    'boudasse',
    'boudassent',
    'boudasses',
    'boudassiez',
    'boudassions',
    'bouddha',
    'bouddhas',
    'bouddhique',
    'bouddhiques',
    'bouddhisme',
    'bouddhiste',
    'bouddhistes',
    'boude',
    'boudent',
    'bouder',
    'boudera',
    'bouderai',
    'bouderaient',
    'bouderais',
    'bouderait',
    'bouderas',
    'bouderez',
    'bouderie',
    'bouderies',
    'bouderiez',
    'bouderions',
    'bouderons',
    'bouderont',
    'boudes',
    'boudeur',
    'boudeurs',
    'boudeuse',
    'boudeuses',
    'boudez',
    'boudiez',
    'boudin',
    'boudina',
    'boudinage',
    'boudinages',
    'boudinai',
    'boudinaient',
    'boudinais',
    'boudinait',
    'boudinant',
    'boudinas',
    'boudinasse',
    'boudinassent',
    'boudinasses',
    'boudinassiez',
    'boudine',
    'boudinent',
    'boudiner',
    'boudinera',
    'boudinerai',
    'boudinerais',
    'boudinerait',
    'boudineras',
    'boudinerez',
    'boudineriez',
    'boudinerions',
    'boudinerons',
    'boudineront',
    'boudines',
    'boudineuse',
    'boudineuses',
    'boudinez',
    'boudiniez',
    'boudinions',
    'boudinons',
    'boudins',
    'boudinâmes',
    'boudinât',
    'boudinâtes',
    'boudinèrent',
    'boudiné',
    'boudinée',
    'boudinées',
    'boudinés',
    'boudions',
    'boudoir',
    'boudoirs',
    'boudons',
    'boudâmes',
    'boudât',
    'boudâtes',
    'boudèrent',
    'boudé',
    'boudée',
    'boudées',
    'boudés',
    'boue',
    'boues',
    'boueur',
    'boueurs',
    'boueuse',
    'boueuses',
    'boueux',
    'bouffa',
    'bouffai',
    'bouffaient',
    'bouffais',
    'bouffait',
    'bouffant',
    'bouffante',
    'bouffantes',
    'bouffants',
    'bouffarde',
    'bouffardes',
    'bouffas',
    'bouffasse',
    'bouffassent',
    'bouffasses',
    'bouffassiez',
    'bouffassions',
    'bouffe',
    'bouffent',
    'bouffer',
    'bouffera',
    'boufferai',
    'boufferaient',
    'boufferais',
    'boufferait',
    'boufferas',
    'boufferez',
    'boufferiez',
    'boufferions',
    'boufferons',
    'boufferont',
    'bouffes',
    'bouffetance',
    'bouffetances',
    'bouffette',
    'bouffettes',
    'bouffez',
    'bouffi',
    'bouffie',
    'bouffies',
    'bouffiez',
    'bouffions',
    'bouffir',
    'bouffira',
    'bouffirai',
    'bouffiraient',
    'bouffirais',
    'bouffirait',
    'bouffiras',
    'bouffirent',
    'bouffirez',
    'bouffiriez',
    'bouffirions',
    'bouffirons',
    'bouffiront',
    'bouffis',
    'bouffissais',
    'bouffissait',
    'bouffissant',
    'bouffisse',
    'bouffissent',
    'bouffisses',
    'bouffissez',
    'bouffissiez',
    'bouffissions',
    'bouffissons',
    'bouffissure',
    'bouffissures',
    'bouffit',
    'bouffon',
    'bouffonna',
    'bouffonnai',
    'bouffonnais',
    'bouffonnait',
    'bouffonnant',
    'bouffonnas',
    'bouffonnasse',
    'bouffonne',
    'bouffonnent',
    'bouffonner',
    'bouffonnera',
    'bouffonnerai',
    'bouffonneras',
    'bouffonnerez',
    'bouffonnerie',
    'bouffonnes',
    'bouffonnez',
    'bouffonniez',
    'bouffonnions',
    'bouffonnons',
    'bouffonnâmes',
    'bouffonnât',
    'bouffonnâtes',
    'bouffonné',
    'bouffons',
    'bouffâmes',
    'bouffât',
    'bouffâtes',
    'bouffèrent',
    'bouffé',
    'bouffée',
    'bouffées',
    'bouffés',
    'bouffîmes',
    'bouffît',
    'bouffîtes',
    'bouge',
    'bougea',
    'bougeai',
    'bougeaient',
    'bougeais',
    'bougeait',
    'bougeant',
    'bougeas',
    'bougeasse',
    'bougeassent',
    'bougeasses',
    'bougeassiez',
    'bougeassions',
    'bougent',
    'bougeoir',
    'bougeoirs',
    'bougeons',
    'bougeotte',
    'bougeottes',
    'bouger',
    'bougera',
    'bougerai',
    'bougeraient',
    'bougerais',
    'bougerait',
    'bougeras',
    'bougerez',
    'bougeriez',
    'bougerions',
    'bougerons',
    'bougeront',
    'bouges',
    'bougez',
    'bougeâmes',
    'bougeât',
    'bougeâtes',
    'bougie',
    'bougies',
    'bougiez',
    'bougions',
    'bougnat',
    'bougnats',
    'bougon',
    'bougonna',
    'bougonnai',
    'bougonnaient',
    'bougonnais',
    'bougonnait',
    'bougonnant',
    'bougonnas',
    'bougonnasse',
    'bougonnasses',
    'bougonne',
    'bougonnement',
    'bougonnent',
    'bougonner',
    'bougonnera',
    'bougonnerai',
    'bougonnerais',
    'bougonnerait',
    'bougonneras',
    'bougonnerez',
    'bougonneriez',
    'bougonnerons',
    'bougonneront',
    'bougonnes',
    'bougonnez',
    'bougonniez',
    'bougonnions',
    'bougonnons',
    'bougonnâmes',
    'bougonnât',
    'bougonnâtes',
    'bougonnèrent',
    'bougonné',
    'bougons',
    'bougran',
    'bougrans',
    'bougre',
    'bougrement',
    'bougres',
    'bougèrent',
    'bougé',
    'bougée',
    'bougées',
    'bougés',
    'bouif',
    'bouifs',
    'bouillaient',
    'bouillais',
    'bouillait',
    'bouillant',
    'bouillante',
    'bouillantes',
    'bouillants',
    'bouille',
    'bouillent',
    'bouilles',
    'bouilleur',
    'bouilleurs',
    'bouillez',
    'bouilli',
    'bouillie',
    'bouillies',
    'bouilliez',
    'bouillions',
    'bouillir',
    'bouillira',
    'bouillirai',
    'bouillirais',
    'bouillirait',
    'bouilliras',
    'bouillirent',
    'bouillirez',
    'bouilliriez',
    'bouillirions',
    'bouillirons',
    'bouilliront',
    'bouillis',
    'bouillisse',
    'bouillissent',
    'bouillisses',
    'bouillissiez',
    'bouillit',
    'bouilloire',
    'bouilloires',
    'bouillon',
    'bouillonna',
    'bouillonnai',
    'bouillonnais',
    'bouillonnait',
    'bouillonnant',
    'bouillonnas',
    'bouillonne',
    'bouillonnent',
    'bouillonner',
    'bouillonnera',
    'bouillonnes',
    'bouillonnez',
    'bouillonniez',
    'bouillonnons',
    'bouillonnât',
    'bouillonné',
    'bouillonnée',
    'bouillonnées',
    'bouillonnés',
    'bouillons',
    'bouillotta',
    'bouillottai',
    'bouillottais',
    'bouillottait',
    'bouillottant',
    'bouillottas',
    'bouillotte',
    'bouillottent',
    'bouillotter',
    'bouillottera',
    'bouillottes',
    'bouillottez',
    'bouillottiez',
    'bouillottons',
    'bouillottât',
    'bouillotté',
    'bouillîmes',
    'bouillît',
    'bouillîtes',
    'boula',
    'boulai',
    'boulaie',
    'boulaient',
    'boulaies',
    'boulais',
    'boulait',
    'boulange',
    'boulangea',
    'boulangeai',
    'boulangeais',
    'boulangeait',
    'boulangeant',
    'boulangeas',
    'boulangeasse',
    'boulangent',
    'boulangeons',
    'boulanger',
    'boulangera',
    'boulangerai',
    'boulangerais',
    'boulangerait',
    'boulangeras',
    'boulangerez',
    'boulangerie',
    'boulangeries',
    'boulangeriez',
    'boulangerons',
    'boulangeront',
    'boulangers',
    'boulanges',
    'boulangez',
    'boulangeâmes',
    'boulangeât',
    'boulangeâtes',
    'boulangiez',
    'boulangions',
    'boulangisme',
    'boulangismes',
    'boulangiste',
    'boulangistes',
    'boulangère',
    'boulangèrent',
    'boulangères',
    'boulangé',
    'boulangée',
    'boulangées',
    'boulangés',
    'boulant',
    'boulas',
    'boulasse',
    'boulassent',
    'boulasses',
    'boulassiez',
    'boulassions',
    'boulbène',
    'boulbènes',
    'bouldozeur',
    'bouldozeurs',
    'boule',
    'bouleau',
    'bouleaux',
    'bouledogue',
    'bouledogues',
    'boulent',
    'bouler',
    'boulera',
    'boulerai',
    'bouleraient',
    'boulerais',
    'boulerait',
    'bouleras',
    'boulerez',
    'bouleriez',
    'boulerions',
    'boulerons',
    'bouleront',
    'boules',
    'boulet',
    'boulets',
    'boulette',
    'boulettes',
    'bouleté',
    'bouletée',
    'bouletées',
    'bouletés',
    'boulevard',
    'boulevardier',
    'boulevards',
    'bouleversa',
    'bouleversai',
    'bouleversais',
    'bouleversait',
    'bouleversant',
    'bouleversas',
    'bouleverse',
    'bouleversent',
    'bouleverser',
    'bouleversera',
    'bouleverses',
    'bouleversez',
    'bouleversiez',
    'bouleversons',
    'bouleversât',
    'bouleversé',
    'bouleversée',
    'bouleversées',
    'bouleversés',
    'boulez',
    'boulier',
    'bouliers',
    'bouliez',
    'boulimie',
    'boulimies',
    'boulimique',
    'boulimiques',
    'boulin',
    'bouline',
    'boulines',
    'boulingrin',
    'boulingrins',
    'boulinier',
    'bouliniers',
    'boulinière',
    'boulinières',
    'boulins',
    'boulions',
    'bouliste',
    'boulistes',
    'boulocher',
    'boulodrome',
    'boulodromes',
    'bouloir',
    'bouloirs',
    'boulon',
    'boulonna',
    'boulonnage',
    'boulonnages',
    'boulonnai',
    'boulonnaient',
    'boulonnais',
    'boulonnait',
    'boulonnant',
    'boulonnas',
    'boulonnasse',
    'boulonnasses',
    'boulonne',
    'boulonnent',
    'boulonner',
    'boulonnera',
    'boulonnerai',
    'boulonnerais',
    'boulonnerait',
    'boulonneras',
    'boulonnerez',
    'boulonnerie',
    'boulonneries',
    'boulonneriez',
    'boulonnerons',
    'boulonneront',
    'boulonnes',
    'boulonnez',
    'boulonniez',
    'boulonnions',
    'boulonnons',
    'boulonnâmes',
    'boulonnât',
    'boulonnâtes',
    'boulonnèrent',
    'boulonné',
    'boulonnée',
    'boulonnées',
    'boulonnés',
    'boulons',
    'boulot',
    'boulots',
    'boulotta',
    'boulottai',
    'boulottaient',
    'boulottais',
    'boulottait',
    'boulottant',
    'boulottas',
    'boulottasse',
    'boulottasses',
    'boulotte',
    'boulottent',
    'boulotter',
    'boulottera',
    'boulotterai',
    'boulotterais',
    'boulotterait',
    'boulotteras',
    'boulotterez',
    'boulotteriez',
    'boulotterons',
    'boulotteront',
    'boulottes',
    'boulottez',
    'boulottiez',
    'boulottions',
    'boulottons',
    'boulottâmes',
    'boulottât',
    'boulottâtes',
    'boulottèrent',
    'boulotté',
    'boulottée',
    'boulottées',
    'boulottés',
    'boulâmes',
    'boulât',
    'boulâtes',
    'boulèrent',
    'boulé',
    'boulée',
    'boulées',
    'boulés',
    'boum',
    'boume',
    'boument',
    'boumer',
    'boumera',
    'boumerai',
    'boumeraient',
    'boumerais',
    'boumerait',
    'boumeras',
    'boumerez',
    'boumeriez',
    'boumerions',
    'boumerons',
    'boumeront',
    'boumes',
    'boumé',
    'bouquet',
    'bouquetier',
    'bouquetiers',
    'bouquetin',
    'bouquetins',
    'bouquetière',
    'bouquetières',
    'bouquets',
    'bouquin',
    'bouquina',
    'bouquinai',
    'bouquinaient',
    'bouquinais',
    'bouquinait',
    'bouquinant',
    'bouquinas',
    'bouquinasse',
    'bouquinasses',
    'bouquine',
    'bouquinent',
    'bouquiner',
    'bouquinera',
    'bouquinerai',
    'bouquinerais',
    'bouquinerait',
    'bouquineras',
    'bouquinerez',
    'bouquinerie',
    'bouquineries',
    'bouquineriez',
    'bouquinerons',
    'bouquineront',
    'bouquines',
    'bouquineur',
    'bouquineurs',
    'bouquineuse',
    'bouquineuses',
    'bouquinez',
    'bouquiniez',
    'bouquinions',
    'bouquiniste',
    'bouquinistes',
    'bouquinons',
    'bouquins',
    'bouquinâmes',
    'bouquinât',
    'bouquinâtes',
    'bouquinèrent',
    'bouquiné',
    'bouquinée',
    'bouquinées',
    'bouquinés',
    'bourbe',
    'bourbes',
    'bourbeuse',
    'bourbeuses',
    'bourbeux',
    'bourbier',
    'bourbiers',
    'bourbillon',
    'bourbillons',
    'bourbon',
    'bourbonien',
    'bourbonienne',
    'bourboniens',
    'bourbons',
    'bourda',
    'bourdai',
    'bourdaient',
    'bourdaine',
    'bourdaines',
    'bourdais',
    'bourdait',
    'bourdant',
    'bourdas',
    'bourdasse',
    'bourdassent',
    'bourdasses',
    'bourdassiez',
    'bourdassions',
    'bourde',
    'bourdent',
    'bourder',
    'bourdera',
    'bourderai',
    'bourderaient',
    'bourderais',
    'bourderait',
    'bourderas',
    'bourderez',
    'bourderiez',
    'bourderions',
    'bourderons',
    'bourderont',
    'bourdes',
    'bourdez',
    'bourdiez',
    'bourdions',
    'bourdon',
    'bourdonna',
    'bourdonnai',
    'bourdonnais',
    'bourdonnait',
    'bourdonnant',
    'bourdonnante',
    'bourdonnants',
    'bourdonnas',
    'bourdonnasse',
    'bourdonne',
    'bourdonnent',
    'bourdonner',
    'bourdonnera',
    'bourdonnerai',
    'bourdonneras',
    'bourdonnerez',
    'bourdonnes',
    'bourdonnez',
    'bourdonniez',
    'bourdonnions',
    'bourdonnons',
    'bourdonnâmes',
    'bourdonnât',
    'bourdonnâtes',
    'bourdonné',
    'bourdonnée',
    'bourdonnées',
    'bourdonnés',
    'bourdons',
    'bourdâmes',
    'bourdât',
    'bourdâtes',
    'bourdèrent',
    'bourdé',
    'bourg',
    'bourgade',
    'bourgades',
    'bourgeois',
    'bourgeoise',
    'bourgeoises',
    'bourgeoisial',
    'bourgeoisie',
    'bourgeoisies',
    'bourgeon',
    'bourgeonna',
    'bourgeonnai',
    'bourgeonnais',
    'bourgeonnait',
    'bourgeonnant',
    'bourgeonnas',
    'bourgeonne',
    'bourgeonnent',
    'bourgeonner',
    'bourgeonnera',
    'bourgeonnes',
    'bourgeonnez',
    'bourgeonniez',
    'bourgeonnons',
    'bourgeonnât',
    'bourgeonné',
    'bourgeonnée',
    'bourgeonnées',
    'bourgeonnés',
    'bourgeons',
    'bourgeron',
    'bourgerons',
    'bourgmestre',
    'bourgmestres',
    'bourgogne',
    'bourgognes',
    'bourgs',
    'bourguignon',
    'bourguignons',
    'bourlingua',
    'bourlinguai',
    'bourlinguais',
    'bourlinguait',
    'bourlinguant',
    'bourlinguas',
    'bourlingue',
    'bourlinguent',
    'bourlinguer',
    'bourlinguera',
    'bourlingues',
    'bourlingueur',
    'bourlinguez',
    'bourlinguiez',
    'bourlinguons',
    'bourlinguât',
    'bourlingué',
    'bourra',
    'bourrache',
    'bourraches',
    'bourrade',
    'bourrades',
    'bourrage',
    'bourrages',
    'bourrai',
    'bourraient',
    'bourrais',
    'bourrait',
    'bourrant',
    'bourras',
    'bourrasque',
    'bourrasques',
    'bourrasse',
    'bourrassent',
    'bourrasses',
    'bourrassiez',
    'bourrassions',
    'bourratif',
    'bourratifs',
    'bourrative',
    'bourratives',
    'bourre',
    'bourreau',
    'bourreaux',
    'bourrela',
    'bourrelai',
    'bourrelaient',
    'bourrelais',
    'bourrelait',
    'bourrelant',
    'bourrelas',
    'bourrelasse',
    'bourrelasses',
    'bourreler',
    'bourrelet',
    'bourrelets',
    'bourrelez',
    'bourrelier',
    'bourreliers',
    'bourreliez',
    'bourrelions',
    'bourrelle',
    'bourrellent',
    'bourrellera',
    'bourrellerai',
    'bourrelleras',
    'bourrellerez',
    'bourrellerie',
    'bourrelles',
    'bourrelons',
    'bourrelâmes',
    'bourrelât',
    'bourrelâtes',
    'bourrelèrent',
    'bourrelé',
    'bourrelée',
    'bourrelées',
    'bourrelés',
    'bourrent',
    'bourrer',
    'bourrera',
    'bourrerai',
    'bourreraient',
    'bourrerais',
    'bourrerait',
    'bourreras',
    'bourrerez',
    'bourreriez',
    'bourrerions',
    'bourrerons',
    'bourreront',
    'bourres',
    'bourrette',
    'bourrettes',
    'bourrez',
    'bourriche',
    'bourriches',
    'bourrichon',
    'bourrichons',
    'bourricot',
    'bourricots',
    'bourriez',
    'bourrin',
    'bourrins',
    'bourrions',
    'bourriqua',
    'bourriquai',
    'bourriquais',
    'bourriquait',
    'bourriquant',
    'bourriquas',
    'bourriquasse',
    'bourrique',
    'bourriquent',
    'bourriquer',
    'bourriquera',
    'bourriquerai',
    'bourriqueras',
    'bourriquerez',
    'bourriques',
    'bourriquet',
    'bourriquets',
    'bourriquez',
    'bourriquiez',
    'bourriquions',
    'bourriquons',
    'bourriquâmes',
    'bourriquât',
    'bourriquâtes',
    'bourriqué',
    'bourroir',
    'bourroirs',
    'bourrons',
    'bourru',
    'bourrue',
    'bourrues',
    'bourrus',
    'bourrâmes',
    'bourrât',
    'bourrâtes',
    'bourrèlement',
    'bourrèrent',
    'bourré',
    'bourrée',
    'bourrées',
    'bourrés',
    'bourse',
    'bourses',
    'boursicota',
    'boursicotage',
    'boursicotai',
    'boursicotais',
    'boursicotait',
    'boursicotant',
    'boursicotas',
    'boursicote',
    'boursicotent',
    'boursicoter',
    'boursicotera',
    'boursicotes',
    'boursicoteur',
    'boursicotez',
    'boursicotier',
    'boursicotiez',
    'boursicotons',
    'boursicotât',
    'boursicoté',
    'boursier',
    'boursiers',
    'boursière',
    'boursières',
    'boursoufla',
    'boursouflage',
    'boursouflai',
    'boursouflais',
    'boursouflait',
    'boursouflant',
    'boursouflas',
    'boursoufle',
    'boursouflent',
    'boursoufler',
    'boursouflera',
    'boursoufles',
    'boursouflez',
    'boursoufliez',
    'boursouflons',
    'boursouflure',
    'boursouflât',
    'boursouflé',
    'boursouflée',
    'boursouflées',
    'boursouflés',
    'bous',
    'bouscueil',
    'bouscueils',
    'bouscula',
    'bousculade',
    'bousculades',
    'bousculai',
    'bousculaient',
    'bousculais',
    'bousculait',
    'bousculant',
    'bousculas',
    'bousculasse',
    'bousculasses',
    'bouscule',
    'bousculent',
    'bousculer',
    'bousculera',
    'bousculerai',
    'bousculerais',
    'bousculerait',
    'bousculeras',
    'bousculerez',
    'bousculeriez',
    'bousculerons',
    'bousculeront',
    'bouscules',
    'bousculez',
    'bousculiez',
    'bousculions',
    'bousculons',
    'bousculâmes',
    'bousculât',
    'bousculâtes',
    'bousculèrent',
    'bousculé',
    'bousculée',
    'bousculées',
    'bousculés',
    'bouse',
    'bouses',
    'bouseux',
    'bousier',
    'bousiers',
    'bousilla',
    'bousillage',
    'bousillages',
    'bousillai',
    'bousillaient',
    'bousillais',
    'bousillait',
    'bousillant',
    'bousillas',
    'bousillasse',
    'bousillasses',
    'bousille',
    'bousillent',
    'bousiller',
    'bousillera',
    'bousillerai',
    'bousillerais',
    'bousillerait',
    'bousilleras',
    'bousillerez',
    'bousilleriez',
    'bousillerons',
    'bousilleront',
    'bousilles',
    'bousilleur',
    'bousilleurs',
    'bousilleuse',
    'bousilleuses',
    'bousillez',
    'bousilliez',
    'bousillions',
    'bousillons',
    'bousillâmes',
    'bousillât',
    'bousillâtes',
    'bousillèrent',
    'bousillé',
    'bousillée',
    'bousillées',
    'bousillés',
    'bousin',
    'bousins',
    'boussole',
    'boussoles',
    'boustifailla',
    'boustifaille',
    'boustifaillé',
    'bout',
    'bouta',
    'boutade',
    'boutades',
    'boutai',
    'boutaient',
    'boutais',
    'boutait',
    'boutant',
    'boutas',
    'boutasse',
    'boutassent',
    'boutasses',
    'boutassiez',
    'boutassions',
    'boute',
    'boutefeu',
    'boutefeux',
    'bouteille',
    'bouteiller',
    'bouteillers',
    'bouteilles',
    'bouteillon',
    'bouteillons',
    'boutent',
    'bouter',
    'boutera',
    'bouterai',
    'bouteraient',
    'bouterais',
    'bouterait',
    'bouteras',
    'bouterez',
    'bouteriez',
    'bouterions',
    'bouterolle',
    'bouterolles',
    'bouterons',
    'bouteront',
    'bouteroue',
    'bouteroues',
    'boutes',
    'bouteur',
    'bouteurs',
    'boutez',
    'boutiez',
    'boutions',
    'boutique',
    'boutiques',
    'boutiquier',
    'boutiquiers',
    'boutiquière',
    'boutiquières',
    'boutisse',
    'boutisses',
    'boutoir',
    'boutoirs',
    'bouton',
    'boutonna',
    'boutonnage',
    'boutonnages',
    'boutonnai',
    'boutonnaient',
    'boutonnais',
    'boutonnait',
    'boutonnant',
    'boutonnas',
    'boutonnasse',
    'boutonnasses',
    'boutonne',
    'boutonnent',
    'boutonner',
    'boutonnera',
    'boutonnerai',
    'boutonnerais',
    'boutonnerait',
    'boutonneras',
    'boutonnerez',
    'boutonneriez',
    'boutonnerons',
    'boutonneront',
    'boutonnes',
    'boutonneuse',
    'boutonneuses',
    'boutonneux',
    'boutonnez',
    'boutonnier',
    'boutonniers',
    'boutonniez',
    'boutonnions',
    'boutonnière',
    'boutonnières',
    'boutonnons',
    'boutonnâmes',
    'boutonnât',
    'boutonnâtes',
    'boutonnèrent',
    'boutonné',
    'boutonnée',
    'boutonnées',
    'boutonnés',
    'boutons',
    'boutre',
    'boutres',
    'bouts',
    'boutura',
    'bouturage',
    'bouturages',
    'bouturai',
    'bouturaient',
    'bouturais',
    'bouturait',
    'bouturant',
    'bouturas',
    'bouturasse',
    'bouturassent',
    'bouturasses',
    'bouturassiez',
    'bouture',
    'bouturent',
    'bouturer',
    'bouturera',
    'bouturerai',
    'bouturerais',
    'bouturerait',
    'boutureras',
    'bouturerez',
    'boutureriez',
    'bouturerions',
    'bouturerons',
    'boutureront',
    'boutures',
    'bouturez',
    'bouturiez',
    'bouturions',
    'bouturons',
    'bouturâmes',
    'bouturât',
    'bouturâtes',
    'bouturèrent',
    'bouturé',
    'boutâmes',
    'boutât',
    'boutâtes',
    'boutèrent',
    'bouté',
    'boutée',
    'boutées',
    'boutés',
    'bouverie',
    'bouveries',
    'bouvet',
    'bouveteuse',
    'bouveteuses',
    'bouvets',
    'bouvier',
    'bouviers',
    'bouvillon',
    'bouvillons',
    'bouvière',
    'bouvières',
    'bouvreuil',
    'bouvreuils',
    'bouvril',
    'bouvrils',
    'bouée',
    'bouées',
    'bovarysme',
    'bovarysmes',
    'bovidé',
    'bovidés',
    'bovin',
    'bovine',
    'bovines',
    'bovins',
    'bowling',
    'bowlings',
    'boxa',
    'boxai',
    'boxaient',
    'boxais',
    'boxait',
    'boxant',
    'boxas',
    'boxasse',
    'boxassent',
    'boxasses',
    'boxassiez',
    'boxassions',
    'boxe',
    'boxent',
    'boxer',
    'boxera',
    'boxerai',
    'boxeraient',
    'boxerais',
    'boxerait',
    'boxeras',
    'boxerez',
    'boxeriez',
    'boxerions',
    'boxerons',
    'boxeront',
    'boxers',
    'boxes',
    'boxeur',
    'boxeurs',
    'boxez',
    'boxiez',
    'boxions',
    'boxons',
    'boxâmes',
    'boxât',
    'boxâtes',
    'boxèrent',
    'boxé',
    'boxée',
    'boxées',
    'boxés',
    'boyard',
    'boyards',
    'boyau',
    'boyauderie',
    'boyauderies',
    'boyaudier',
    'boyaudiers',
    'boyaudière',
    'boyaudières',
    'boyauter',
    'boyaux',
    'boycott',
    'boycotta',
    'boycottage',
    'boycottages',
    'boycottai',
    'boycottaient',
    'boycottais',
    'boycottait',
    'boycottant',
    'boycottas',
    'boycottasse',
    'boycottasses',
    'boycotte',
    'boycottent',
    'boycotter',
    'boycottera',
    'boycotterai',
    'boycotterais',
    'boycotterait',
    'boycotteras',
    'boycotterez',
    'boycotteriez',
    'boycotterons',
    'boycotteront',
    'boycottes',
    'boycotteur',
    'boycotteurs',
    'boycotteuse',
    'boycotteuses',
    'boycottez',
    'boycottiez',
    'boycottions',
    'boycottons',
    'boycotts',
    'boycottâmes',
    'boycottât',
    'boycottâtes',
    'boycottèrent',
    'boycotté',
    'boycottée',
    'boycottées',
    'boycottés',
    'boys',
    'boësse',
    'boësses',
    'boëte',
    'boëtes',
    'boîte',
    'boîtes',
    'boîtier',
    'boîtiers',
    'brabant',
    'brabants',
    'brabançon',
    'brabançonne',
    'brabançonnes',
    'brabançons',
    'bracelet',
    'bracelets',
    'brachial',
    'brachiale',
    'brachiales',
    'brachiaux',
    'braconna',
    'braconnage',
    'braconnages',
    'braconnai',
    'braconnaient',
    'braconnais',
    'braconnait',
    'braconnant',
    'braconnas',
    'braconnasse',
    'braconnasses',
    'braconne',
    'braconnent',
    'braconner',
    'braconnera',
    'braconnerai',
    'braconnerais',
    'braconnerait',
    'braconneras',
    'braconnerez',
    'braconneriez',
    'braconnerons',
    'braconneront',
    'braconnes',
    'braconnez',
    'braconnier',
    'braconniers',
    'braconniez',
    'braconnions',
    'braconnière',
    'braconnières',
    'braconnons',
    'braconnâmes',
    'braconnât',
    'braconnâtes',
    'braconnèrent',
    'braconné',
    'braconnée',
    'braconnées',
    'braconnés',
    'bractéal',
    'bractéale',
    'bractéales',
    'bractéaux',
    'bractée',
    'bractées',
    'brada',
    'bradage',
    'bradages',
    'bradai',
    'bradaient',
    'bradais',
    'bradait',
    'bradant',
    'bradas',
    'bradasse',
    'bradassent',
    'bradasses',
    'bradassiez',
    'bradassions',
    'brade',
    'bradel',
    'bradent',
    'brader',
    'bradera',
    'braderai',
    'braderaient',
    'braderais',
    'braderait',
    'braderas',
    'braderez',
    'braderie',
    'braderies',
    'braderiez',
    'braderions',
    'braderons',
    'braderont',
    'brades',
    'bradeur',
    'bradeurs',
    'bradeuse',
    'bradeuses',
    'bradez',
    'bradiez',
    'bradions',
    'bradons',
    'bradycardie',
    'bradycardies',
    'bradype',
    'bradypes',
    'bradâmes',
    'bradât',
    'bradâtes',
    'bradèrent',
    'bradé',
    'bradée',
    'bradées',
    'bradés',
    'braguette',
    'braguettes',
    'brahmane',
    'brahmanes',
    'brahmanique',
    'brahmaniques',
    'brahmanisme',
    'brahmanismes',
    'brai',
    'braie',
    'braient',
    'braiera',
    'braierai',
    'braieraient',
    'braierais',
    'braierait',
    'braieras',
    'braierez',
    'braieriez',
    'braierions',
    'braierons',
    'braieront',
    'braies',
    'brailla',
    'braillai',
    'braillaient',
    'braillais',
    'braillait',
    'braillant',
    'braillard',
    'braillarde',
    'braillardes',
    'braillards',
    'braillas',
    'braillasse',
    'braillassent',
    'braillasses',
    'braillassiez',
    'braille',
    'braillement',
    'braillements',
    'braillent',
    'brailler',
    'braillera',
    'braillerai',
    'braillerais',
    'braillerait',
    'brailleras',
    'braillerez',
    'brailleriez',
    'braillerions',
    'braillerons',
    'brailleront',
    'brailles',
    'brailleur',
    'brailleurs',
    'brailleuse',
    'brailleuses',
    'braillez',
    'brailliez',
    'braillions',
    'braillons',
    'braillâmes',
    'braillât',
    'braillâtes',
    'braillèrent',
    'braillé',
    'braillée',
    'braillées',
    'braillés',
    'braiment',
    'braiments',
    'braira',
    'brairaient',
    'brairait',
    'braire',
    'brairont',
    'brais',
    'braisa',
    'braisai',
    'braisaient',
    'braisais',
    'braisait',
    'braisant',
    'braisas',
    'braisasse',
    'braisassent',
    'braisasses',
    'braisassiez',
    'braisassions',
    'braise',
    'braisent',
    'braiser',
    'braisera',
    'braiserai',
    'braiseraient',
    'braiserais',
    'braiserait',
    'braiseras',
    'braiserez',
    'braiseriez',
    'braiserions',
    'braiserons',
    'braiseront',
    'braises',
    'braisez',
    'braisiez',
    'braisions',
    'braisière',
    'braisières',
    'braisons',
    'braisâmes',
    'braisât',
    'braisâtes',
    'braisèrent',
    'braisé',
    'braisée',
    'braisées',
    'braisés',
    'brait',
    'brama',
    'bramai',
    'bramaient',
    'bramais',
    'bramait',
    'bramant',
    'bramas',
    'bramasse',
    'bramassent',
    'bramasses',
    'bramassiez',
    'bramassions',
    'brame',
    'bramement',
    'bramements',
    'brament',
    'bramer',
    'bramera',
    'bramerai',
    'brameraient',
    'bramerais',
    'bramerait',
    'brameras',
    'bramerez',
    'brameriez',
    'bramerions',
    'bramerons',
    'brameront',
    'brames',
    'bramez',
    'bramiez',
    'bramions',
    'bramons',
    'bramâmes',
    'bramât',
    'bramâtes',
    'bramèrent',
    'bramé',
    'bramée',
    'bramées',
    'bramés',
    'bran',
    'brancard',
    'brancarder',
    'brancardier',
    'brancardiers',
    'brancardière',
    'brancards',
    'brancha',
    'branchage',
    'branchages',
    'branchai',
    'branchaient',
    'branchais',
    'branchait',
    'branchant',
    'branchas',
    'branchasse',
    'branchassent',
    'branchasses',
    'branchassiez',
    'branche',
    'branchement',
    'branchements',
    'branchent',
    'brancher',
    'branchera',
    'brancherai',
    'brancherais',
    'brancherait',
    'brancheras',
    'brancherez',
    'brancheriez',
    'brancherions',
    'brancherons',
    'brancheront',
    'branches',
    'branchette',
    'branchettes',
    'branchez',
    'branchial',
    'branchiale',
    'branchiales',
    'branchiaux',
    'branchies',
    'branchiez',
    'branchions',
    'branchons',
    'branchu',
    'branchue',
    'branchues',
    'branchus',
    'branchâmes',
    'branchât',
    'branchâtes',
    'branchèrent',
    'branché',
    'branchée',
    'branchées',
    'branchés',
    'brandade',
    'brandades',
    'brande',
    'brandebourg',
    'brandebourgs',
    'brandes',
    'brandi',
    'brandie',
    'brandies',
    'brandilla',
    'brandillai',
    'brandillais',
    'brandillait',
    'brandillant',
    'brandillas',
    'brandillasse',
    'brandille',
    'brandillent',
    'brandiller',
    'brandillera',
    'brandillerai',
    'brandilleras',
    'brandillerez',
    'brandilles',
    'brandillez',
    'brandilliez',
    'brandillions',
    'brandillons',
    'brandillâmes',
    'brandillât',
    'brandillâtes',
    'brandillé',
    'brandillée',
    'brandillées',
    'brandillés',
    'brandir',
    'brandira',
    'brandirai',
    'brandiraient',
    'brandirais',
    'brandirait',
    'brandiras',
    'brandirent',
    'brandirez',
    'brandiriez',
    'brandirions',
    'brandirons',
    'brandiront',
    'brandis',
    'brandissais',
    'brandissait',
    'brandissant',
    'brandisse',
    'brandissent',
    'brandisses',
    'brandissez',
    'brandissiez',
    'brandissions',
    'brandissons',
    'brandit',
    'brandon',
    'brandons',
    'brandy',
    'brandîmes',
    'brandît',
    'brandîtes',
    'branla',
    'branlai',
    'branlaient',
    'branlais',
    'branlait',
    'branlant',
    'branlante',
    'branlantes',
    'branlants',
    'branlas',
    'branlasse',
    'branlassent',
    'branlasses',
    'branlassiez',
    'branlassions',
    'branle',
    'branlement',
    'branlements',
    'branlent',
    'branler',
    'branlera',
    'branlerai',
    'branleraient',
    'branlerais',
    'branlerait',
    'branleras',
    'branlerez',
    'branleriez',
    'branlerions',
    'branlerons',
    'branleront',
    'branles',
    'branlez',
    'branliez',
    'branlions',
    'branlons',
    'branlâmes',
    'branlât',
    'branlâtes',
    'branlèrent',
    'branlé',
    'branlée',
    'branlées',
    'branlés',
    'brans',
    'brante',
    'brantes',
    'braqua',
    'braquage',
    'braquages',
    'braquai',
    'braquaient',
    'braquais',
    'braquait',
    'braquant',
    'braquas',
    'braquasse',
    'braquassent',
    'braquasses',
    'braquassiez',
    'braquassions',
    'braque',
    'braquemart',
    'braquemarts',
    'braquent',
    'braquer',
    'braquera',
    'braquerai',
    'braqueraient',
    'braquerais',
    'braquerait',
    'braqueras',
    'braquerez',
    'braqueriez',
    'braquerions',
    'braquerons',
    'braqueront',
    'braques',
    'braquet',
    'braquets',
    'braquez',
    'braquiez',
    'braquions',
    'braquons',
    'braquâmes',
    'braquât',
    'braquâtes',
    'braquèrent',
    'braqué',
    'braquée',
    'braquées',
    'braqués',
    'bras',
    'brasa',
    'brasage',
    'brasages',
    'brasai',
    'brasaient',
    'brasais',
    'brasait',
    'brasant',
    'brasas',
    'brasasse',
    'brasassent',
    'brasasses',
    'brasassiez',
    'brasassions',
    'brase',
    'brasent',
    'braser',
    'brasera',
    'braserai',
    'braseraient',
    'braserais',
    'braserait',
    'braseras',
    'braserez',
    'braseriez',
    'braserions',
    'brasero',
    'braserons',
    'braseront',
    'braseros',
    'brases',
    'brasez',
    'brasier',
    'brasiers',
    'brasiez',
    'brasilla',
    'brasillai',
    'brasillaient',
    'brasillais',
    'brasillait',
    'brasillant',
    'brasillas',
    'brasillasse',
    'brasillasses',
    'brasille',
    'brasillent',
    'brasiller',
    'brasillera',
    'brasillerai',
    'brasillerais',
    'brasillerait',
    'brasilleras',
    'brasillerez',
    'brasilleriez',
    'brasillerons',
    'brasilleront',
    'brasilles',
    'brasillez',
    'brasilliez',
    'brasillions',
    'brasillons',
    'brasillâmes',
    'brasillât',
    'brasillâtes',
    'brasillèrent',
    'brasillé',
    'brasions',
    'brasons',
    'brassa',
    'brassage',
    'brassages',
    'brassai',
    'brassaient',
    'brassais',
    'brassait',
    'brassant',
    'brassard',
    'brassards',
    'brassas',
    'brassasse',
    'brassassent',
    'brassasses',
    'brassassiez',
    'brassassions',
    'brasse',
    'brassent',
    'brasser',
    'brassera',
    'brasserai',
    'brasseraient',
    'brasserais',
    'brasserait',
    'brasseras',
    'brasserez',
    'brasserie',
    'brasseries',
    'brasseriez',
    'brasserions',
    'brasserons',
    'brasseront',
    'brasses',
    'brasseur',
    'brasseurs',
    'brasseuse',
    'brasseuses',
    'brasseyer',
    'brassez',
    'brassiez',
    'brassin',
    'brassins',
    'brassions',
    'brassière',
    'brassières',
    'brassons',
    'brassâmes',
    'brassât',
    'brassâtes',
    'brassèrent',
    'brassé',
    'brassée',
    'brassées',
    'brassés',
    'brasure',
    'brasures',
    'brasâmes',
    'brasât',
    'brasâtes',
    'brasèrent',
    'brasé',
    'brasée',
    'brasées',
    'brasés',
    'brava',
    'bravache',
    'bravaches',
    'bravade',
    'bravades',
    'bravai',
    'bravaient',
    'bravais',
    'bravait',
    'bravant',
    'bravas',
    'bravasse',
    'bravassent',
    'bravasses',
    'bravassiez',
    'bravassions',
    'brave',
    'bravement',
    'bravent',
    'braver',
    'bravera',
    'braverai',
    'braveraient',
    'braverais',
    'braverait',
    'braveras',
    'braverez',
    'braveriez',
    'braverions',
    'braverons',
    'braveront',
    'braves',
    'bravez',
    'braviez',
    'bravions',
    'bravo',
    'bravons',
    'bravos',
    'bravoure',
    'bravoures',
    'bravâmes',
    'bravât',
    'bravâtes',
    'bravèrent',
    'bravé',
    'bravée',
    'bravées',
    'bravés',
    'braya',
    'brayai',
    'brayaient',
    'brayais',
    'brayait',
    'brayant',
    'brayas',
    'brayasse',
    'brayassent',
    'brayasses',
    'brayassiez',
    'brayassions',
    'braye',
    'brayent',
    'brayer',
    'brayera',
    'brayerai',
    'brayeraient',
    'brayerais',
    'brayerait',
    'brayeras',
    'brayerez',
    'brayeriez',
    'brayerions',
    'brayerons',
    'brayeront',
    'brayes',
    'brayez',
    'brayiez',
    'brayions',
    'brayons',
    'brayâmes',
    'brayât',
    'brayâtes',
    'brayèrent',
    'brayé',
    'brayée',
    'brayées',
    'brayés',
    'break',
    'breakfast',
    'breakfasts',
    'breaks',
    'brebis',
    'bredouilla',
    'bredouillage',
    'bredouillai',
    'bredouillais',
    'bredouillait',
    'bredouillant',
    'bredouillas',
    'bredouille',
    'bredouillent',
    'bredouiller',
    'bredouillera',
    'bredouilles',
    'bredouilleur',
    'bredouillez',
    'bredouilliez',
    'bredouillis',
    'bredouillons',
    'bredouillât',
    'bredouillé',
    'bredouillée',
    'bredouillées',
    'bredouillés',
    'bref',
    'brefs',
    'brelan',
    'brelans',
    'brella',
    'brellai',
    'brellaient',
    'brellais',
    'brellait',
    'brellant',
    'brellas',
    'brellasse',
    'brellassent',
    'brellasses',
    'brellassiez',
    'brellassions',
    'brelle',
    'brellent',
    'breller',
    'brellera',
    'brellerai',
    'brelleraient',
    'brellerais',
    'brellerait',
    'brelleras',
    'brellerez',
    'brelleriez',
    'brellerions',
    'brellerons',
    'brelleront',
    'brelles',
    'brellez',
    'brelliez',
    'brellions',
    'brellons',
    'brellâmes',
    'brellât',
    'brellâtes',
    'brellèrent',
    'brellé',
    'brellée',
    'brellées',
    'brellés',
    'breloque',
    'breloques',
    'bresse',
    'bretelle',
    'bretelles',
    'bretessé',
    'bretessée',
    'bretessées',
    'bretessés',
    'breton',
    'bretonnant',
    'bretonnante',
    'bretonnantes',
    'bretonnants',
    'bretonne',
    'bretonnes',
    'bretons',
    'bretta',
    'brettai',
    'brettaient',
    'brettais',
    'brettait',
    'brettant',
    'brettas',
    'brettasse',
    'brettassent',
    'brettasses',
    'brettassiez',
    'brettassions',
    'brette',
    'brettela',
    'brettelai',
    'brettelaient',
    'brettelais',
    'brettelait',
    'brettelant',
    'brettelas',
    'brettelasse',
    'brettelasses',
    'bretteler',
    'brettelez',
    'bretteliez',
    'brettelions',
    'brettelle',
    'brettellent',
    'brettellera',
    'brettellerai',
    'brettelleras',
    'brettellerez',
    'brettelles',
    'brettelons',
    'brettelâmes',
    'brettelât',
    'brettelâtes',
    'brettelèrent',
    'brettelé',
    'brettelée',
    'brettelées',
    'brettelés',
    'brettent',
    'bretter',
    'brettera',
    'bretterai',
    'bretteraient',
    'bretterais',
    'bretterait',
    'bretteras',
    'bretterez',
    'bretteriez',
    'bretterions',
    'bretterons',
    'bretteront',
    'brettes',
    'bretteur',
    'bretteurs',
    'brettez',
    'brettiez',
    'brettions',
    'brettons',
    'brettâmes',
    'brettât',
    'brettâtes',
    'brettèrent',
    'bretté',
    'brettée',
    'brettées',
    'brettés',
    'bretzel',
    'bretzels',
    'bretèche',
    'bretèches',
    'breuvage',
    'breuvages',
    'brevet',
    'breveta',
    'brevetable',
    'brevetables',
    'brevetai',
    'brevetaient',
    'brevetais',
    'brevetait',
    'brevetant',
    'brevetas',
    'brevetasse',
    'brevetassent',
    'brevetasses',
    'brevetassiez',
    'breveter',
    'brevetez',
    'brevetiez',
    'brevetions',
    'brevetons',
    'brevets',
    'brevette',
    'brevettent',
    'brevettera',
    'brevetterai',
    'brevetterais',
    'brevetterait',
    'brevetteras',
    'brevetterez',
    'brevetteriez',
    'brevetterons',
    'brevetteront',
    'brevettes',
    'brevetâmes',
    'brevetât',
    'brevetâtes',
    'brevetèrent',
    'breveté',
    'brevetée',
    'brevetées',
    'brevetés',
    'briard',
    'briards',
    'bribes',
    'bric',
    'brick',
    'bricks',
    'bricola',
    'bricolage',
    'bricolages',
    'bricolai',
    'bricolaient',
    'bricolais',
    'bricolait',
    'bricolant',
    'bricolas',
    'bricolasse',
    'bricolassent',
    'bricolasses',
    'bricolassiez',
    'bricole',
    'bricolent',
    'bricoler',
    'bricolera',
    'bricolerai',
    'bricolerais',
    'bricolerait',
    'bricoleras',
    'bricolerez',
    'bricoleriez',
    'bricolerions',
    'bricolerons',
    'bricoleront',
    'bricoles',
    'bricoleur',
    'bricoleurs',
    'bricoleuse',
    'bricoleuses',
    'bricolez',
    'bricoliez',
    'bricolions',
    'bricolons',
    'bricolâmes',
    'bricolât',
    'bricolâtes',
    'bricolèrent',
    'bricolé',
    'bricolée',
    'bricolées',
    'bricolés',
    'brida',
    'bridai',
    'bridaient',
    'bridais',
    'bridait',
    'bridant',
    'bridas',
    'bridasse',
    'bridassent',
    'bridasses',
    'bridassiez',
    'bridassions',
    'bride',
    'brident',
    'brider',
    'bridera',
    'briderai',
    'brideraient',
    'briderais',
    'briderait',
    'brideras',
    'briderez',
    'brideriez',
    'briderions',
    'briderons',
    'brideront',
    'brides',
    'bridez',
    'bridge',
    'bridgea',
    'bridgeai',
    'bridgeaient',
    'bridgeais',
    'bridgeait',
    'bridgeant',
    'bridgeas',
    'bridgeasse',
    'bridgeassent',
    'bridgeasses',
    'bridgeassiez',
    'bridgent',
    'bridgeons',
    'bridger',
    'bridgera',
    'bridgerai',
    'bridgeraient',
    'bridgerais',
    'bridgerait',
    'bridgeras',
    'bridgerez',
    'bridgeriez',
    'bridgerions',
    'bridgerons',
    'bridgeront',
    'bridges',
    'bridgeur',
    'bridgeurs',
    'bridgeuse',
    'bridgeuses',
    'bridgez',
    'bridgeâmes',
    'bridgeât',
    'bridgeâtes',
    'bridgiez',
    'bridgions',
    'bridgèrent',
    'bridgé',
    'bridiez',
    'bridions',
    'bridon',
    'bridons',
    'bridâmes',
    'bridât',
    'bridâtes',
    'bridèrent',
    'bridé',
    'bridée',
    'bridées',
    'bridés',
    'brie',
    'briefing',
    'briefings',
    'bries',
    'brifa',
    'brifai',
    'brifaient',
    'brifais',
    'brifait',
    'brifant',
    'brifas',
    'brifasse',
    'brifassent',
    'brifasses',
    'brifassiez',
    'brifassions',
    'brife',
    'brifent',
    'brifer',
    'brifera',
    'briferai',
    'briferaient',
    'briferais',
    'briferait',
    'briferas',
    'briferez',
    'briferiez',
    'briferions',
    'briferons',
    'briferont',
    'brifes',
    'brifez',
    'briffa',
    'briffai',
    'briffaient',
    'briffais',
    'briffait',
    'briffant',
    'briffas',
    'briffasse',
    'briffassent',
    'briffasses',
    'briffassiez',
    'briffassions',
    'briffe',
    'briffent',
    'briffer',
    'briffera',
    'brifferai',
    'brifferaient',
    'brifferais',
    'brifferait',
    'brifferas',
    'brifferez',
    'brifferiez',
    'brifferions',
    'brifferons',
    'brifferont',
    'briffes',
    'briffez',
    'briffiez',
    'briffions',
    'briffons',
    'briffâmes',
    'briffât',
    'briffâtes',
    'briffèrent',
    'briffé',
    'briffée',
    'briffées',
    'briffés',
    'brifiez',
    'brifions',
    'brifons',
    'brifâmes',
    'brifât',
    'brifâtes',
    'brifèrent',
    'brifé',
    'brifée',
    'brifées',
    'brifés',
    'brigade',
    'brigades',
    'brigadier',
    'brigadiers',
    'brigand',
    'briganda',
    'brigandage',
    'brigandages',
    'brigandai',
    'brigandaient',
    'brigandais',
    'brigandait',
    'brigandant',
    'brigandas',
    'brigandasse',
    'brigandasses',
    'brigande',
    'brigandent',
    'brigander',
    'brigandera',
    'briganderai',
    'briganderais',
    'briganderait',
    'briganderas',
    'briganderez',
    'briganderiez',
    'briganderons',
    'briganderont',
    'brigandes',
    'brigandez',
    'brigandiez',
    'brigandine',
    'brigandines',
    'brigandions',
    'brigandons',
    'brigands',
    'brigandâmes',
    'brigandât',
    'brigandâtes',
    'brigandèrent',
    'brigandé',
    'brigandée',
    'brigandées',
    'brigandés',
    'brigantin',
    'brigantine',
    'brigantines',
    'brigantins',
    'brightisme',
    'brightismes',
    'brigua',
    'briguai',
    'briguaient',
    'briguais',
    'briguait',
    'briguant',
    'briguas',
    'briguasse',
    'briguassent',
    'briguasses',
    'briguassiez',
    'briguassions',
    'brigue',
    'briguent',
    'briguer',
    'briguera',
    'briguerai',
    'brigueraient',
    'briguerais',
    'briguerait',
    'brigueras',
    'briguerez',
    'brigueriez',
    'briguerions',
    'briguerons',
    'brigueront',
    'brigues',
    'briguez',
    'briguiez',
    'briguions',
    'briguons',
    'briguâmes',
    'briguât',
    'briguâtes',
    'briguèrent',
    'brigué',
    'briguée',
    'briguées',
    'brigués',
    'brilla',
    'brillai',
    'brillaient',
    'brillais',
    'brillait',
    'brillamment',
    'brillance',
    'brillances',
    'brillant',
    'brillanta',
    'brillantage',
    'brillantages',
    'brillantai',
    'brillantais',
    'brillantait',
    'brillantant',
    'brillantante',
    'brillantants',
    'brillantas',
    'brillantasse',
    'brillante',
    'brillantent',
    'brillanter',
    'brillantera',
    'brillanterai',
    'brillanteras',
    'brillanterez',
    'brillantes',
    'brillantez',
    'brillantiez',
    'brillantina',
    'brillantinai',
    'brillantinas',
    'brillantine',
    'brillantiner',
    'brillantines',
    'brillantinez',
    'brillantinât',
    'brillantiné',
    'brillantinée',
    'brillantinés',
    'brillantions',
    'brillantons',
    'brillants',
    'brillantâmes',
    'brillantât',
    'brillantâtes',
    'brillanté',
    'brillantée',
    'brillantées',
    'brillantés',
    'brillas',
    'brillasse',
    'brillassent',
    'brillasses',
    'brillassiez',
    'brillassions',
    'brille',
    'brillent',
    'briller',
    'brillera',
    'brillerai',
    'brilleraient',
    'brillerais',
    'brillerait',
    'brilleras',
    'brillerez',
    'brilleriez',
    'brillerions',
    'brillerons',
    'brilleront',
    'brilles',
    'brillez',
    'brilliez',
    'brillions',
    'brillons',
    'brillâmes',
    'brillât',
    'brillâtes',
    'brillèrent',
    'brillé',
    'brima',
    'brimade',
    'brimades',
    'brimai',
    'brimaient',
    'brimais',
    'brimait',
    'brimant',
    'brimas',
    'brimasse',
    'brimassent',
    'brimasses',
    'brimassiez',
    'brimassions',
    'brimbala',
    'brimbalai',
    'brimbalaient',
    'brimbalais',
    'brimbalait',
    'brimbalant',
    'brimbalas',
    'brimbalasse',
    'brimbalasses',
    'brimbale',
    'brimbalement',
    'brimbalent',
    'brimbaler',
    'brimbalera',
    'brimbalerai',
    'brimbalerais',
    'brimbalerait',
    'brimbaleras',
    'brimbalerez',
    'brimbaleriez',
    'brimbalerons',
    'brimbaleront',
    'brimbales',
    'brimbalez',
    'brimbaliez',
    'brimbalions',
    'brimbalons',
    'brimbalâmes',
    'brimbalât',
    'brimbalâtes',
    'brimbalèrent',
    'brimbalé',
    'brimbalée',
    'brimbalées',
    'brimbalés',
    'brimborion',
    'brimborions',
    'brime',
    'briment',
    'brimer',
    'brimera',
    'brimerai',
    'brimeraient',
    'brimerais',
    'brimerait',
    'brimeras',
    'brimerez',
    'brimeriez',
    'brimerions',
    'brimerons',
    'brimeront',
    'brimes',
    'brimez',
    'brimiez',
    'brimions',
    'brimons',
    'brimâmes',
    'brimât',
    'brimâtes',
    'brimèrent',
    'brimé',
    'brimée',
    'brimées',
    'brimés',
    'brin',
    'brindezingue',
    'brindille',
    'brindilles',
    'bringue',
    'bringuebaler',
    'bringueballa',
    'bringueballe',
    'bringueballé',
    'bringues',
    'brinquebala',
    'brinquebalai',
    'brinquebalas',
    'brinquebale',
    'brinquebaler',
    'brinquebales',
    'brinquebalez',
    'brinqueballa',
    'brinqueballe',
    'brinqueballé',
    'brinquebalât',
    'brinquebalé',
    'brinquebalée',
    'brinquebalés',
    'brins',
    'brio',
    'brioche',
    'brioches',
    'brioché',
    'briochée',
    'briochées',
    'briochés',
    'brios',
    'briqua',
    'briquai',
    'briquaient',
    'briquais',
    'briquait',
    'briquant',
    'briquas',
    'briquasse',
    'briquassent',
    'briquasses',
    'briquassiez',
    'briquassions',
    'brique',
    'briquent',
    'briquer',
    'briquera',
    'briquerai',
    'briqueraient',
    'briquerais',
    'briquerait',
    'briqueras',
    'briquerez',
    'briqueriez',
    'briquerions',
    'briquerons',
    'briqueront',
    'briques',
    'briquet',
    'briqueta',
    'briquetage',
    'briquetages',
    'briquetai',
    'briquetaient',
    'briquetais',
    'briquetait',
    'briquetant',
    'briquetas',
    'briquetasse',
    'briquetasses',
    'briqueter',
    'briqueterie',
    'briqueteries',
    'briquetez',
    'briquetier',
    'briquetiers',
    'briquetiez',
    'briquetions',
    'briquetons',
    'briquets',
    'briquette',
    'briquettent',
    'briquettera',
    'briquetterai',
    'briquetteras',
    'briquetterez',
    'briquettes',
    'briquetâmes',
    'briquetât',
    'briquetâtes',
    'briquetèrent',
    'briqueté',
    'briquetée',
    'briquetées',
    'briquetés',
    'briquez',
    'briquiez',
    'briquions',
    'briquons',
    'briquâmes',
    'briquât',
    'briquâtes',
    'briquèrent',
    'briqué',
    'briquée',
    'briquées',
    'briqués',
    'bris',
    'brisa',
    'brisai',
    'brisaient',
    'brisais',
    'brisait',
    'brisant',
    'brisants',
    'brisas',
    'brisasse',
    'brisassent',
    'brisasses',
    'brisassiez',
    'brisassions',
    'briscard',
    'briscards',
    'brise',
    'brisement',
    'brisements',
    'brisent',
    'briser',
    'brisera',
    'briserai',
    'briseraient',
    'briserais',
    'briserait',
    'briseras',
    'briserez',
    'briseriez',
    'briserions',
    'briserons',
    'briseront',
    'brises',
    'briseur',
    'briseurs',
    'briseuse',
    'briseuses',
    'brisez',
    'brisiez',
    'brisions',
    'brisis',
    'briska',
    'briskas',
    'brisons',
    'brisque',
    'brisques',
    'bristol',
    'bristols',
    'brisure',
    'brisures',
    'brisâmes',
    'brisât',
    'brisâtes',
    'brisèrent',
    'brisé',
    'brisée',
    'brisées',
    'brisés',
    'britannique',
    'britanniques',
    'brièvement',
    'brièveté',
    'brièvetés',
    'broc',
    'brocanta',
    'brocantage',
    'brocantages',
    'brocantai',
    'brocantaient',
    'brocantais',
    'brocantait',
    'brocantant',
    'brocantas',
    'brocantasse',
    'brocantasses',
    'brocante',
    'brocantent',
    'brocanter',
    'brocantera',
    'brocanterai',
    'brocanterais',
    'brocanterait',
    'brocanteras',
    'brocanterez',
    'brocanteriez',
    'brocanterons',
    'brocanteront',
    'brocantes',
    'brocanteur',
    'brocanteurs',
    'brocanteuse',
    'brocanteuses',
    'brocantez',
    'brocantiez',
    'brocantions',
    'brocantons',
    'brocantâmes',
    'brocantât',
    'brocantâtes',
    'brocantèrent',
    'brocanté',
    'brocantée',
    'brocantées',
    'brocantés',
    'brocard',
    'brocarda',
    'brocardai',
    'brocardaient',
    'brocardais',
    'brocardait',
    'brocardant',
    'brocardas',
    'brocardasse',
    'brocardasses',
    'brocarde',
    'brocardent',
    'brocarder',
    'brocardera',
    'brocarderai',
    'brocarderais',
    'brocarderait',
    'brocarderas',
    'brocarderez',
    'brocarderiez',
    'brocarderons',
    'brocarderont',
    'brocardes',
    'brocardez',
    'brocardiez',
    'brocardions',
    'brocardons',
    'brocards',
    'brocardâmes',
    'brocardât',
    'brocardâtes',
    'brocardèrent',
    'brocardé',
    'brocardée',
    'brocardées',
    'brocardés',
    'brocatelle',
    'brocatelles',
    'brocha',
    'brochage',
    'brochages',
    'brochai',
    'brochaient',
    'brochais',
    'brochait',
    'brochant',
    'brochante',
    'brochantes',
    'brochants',
    'brochas',
    'brochasse',
    'brochassent',
    'brochasses',
    'brochassiez',
    'brochassions',
    'broche',
    'brochent',
    'brocher',
    'brochera',
    'brocherai',
    'brocheraient',
    'brocherais',
    'brocherait',
    'brocheras',
    'brocherez',
    'brocheriez',
    'brocherions',
    'brocherons',
    'brocheront',
    'broches',
    'brochet',
    'brocheton',
    'brochetons',
    'brochets',
    'brochette',
    'brochettes',
    'brocheur',
    'brocheurs',
    'brocheuse',
    'brocheuses',
    'brochez',
    'brochiez',
    'brochions',
    'brochons',
    'brochure',
    'brochures',
    'brochâmes',
    'brochât',
    'brochâtes',
    'brochèrent',
    'broché',
    'brochée',
    'brochées',
    'brochés',
    'brocoli',
    'brocolis',
    'brocs',
    'broda',
    'brodai',
    'brodaient',
    'brodais',
    'brodait',
    'brodant',
    'brodas',
    'brodasse',
    'brodassent',
    'brodasses',
    'brodassiez',
    'brodassions',
    'brode',
    'brodent',
    'brodequin',
    'brodequins',
    'broder',
    'brodera',
    'broderai',
    'broderaient',
    'broderais',
    'broderait',
    'broderas',
    'broderez',
    'broderie',
    'broderies',
    'broderiez',
    'broderions',
    'broderons',
    'broderont',
    'brodes',
    'brodeur',
    'brodeurs',
    'brodeuse',
    'brodeuses',
    'brodez',
    'brodiez',
    'brodions',
    'brodons',
    'brodâmes',
    'brodât',
    'brodâtes',
    'brodèrent',
    'brodé',
    'brodée',
    'brodées',
    'brodés',
    'broie',
    'broiement',
    'broiements',
    'broient',
    'broiera',
    'broierai',
    'broieraient',
    'broierais',
    'broierait',
    'broieras',
    'broierez',
    'broieriez',
    'broierions',
    'broierons',
    'broieront',
    'broies',
    'bromate',
    'bromates',
    'brome',
    'bromes',
    'bromhydrique',
    'bromique',
    'bromiques',
    'bromisme',
    'bromismes',
    'bromure',
    'bromures',
    'broncha',
    'bronchai',
    'bronchaient',
    'bronchais',
    'bronchait',
    'bronchant',
    'bronchas',
    'bronchasse',
    'bronchassent',
    'bronchasses',
    'bronchassiez',
    'bronche',
    'bronchent',
    'broncher',
    'bronchera',
    'broncherai',
    'broncherais',
    'broncherait',
    'broncheras',
    'broncherez',
    'broncheriez',
    'broncherions',
    'broncherons',
    'broncheront',
    'bronches',
    'bronchez',
    'bronchiez',
    'bronchiole',
    'bronchioles',
    'bronchions',
    'bronchique',
    'bronchiques',
    'bronchite',
    'bronchites',
    'bronchiteuse',
    'bronchiteux',
    'bronchitique',
    'broncho',
    'bronchons',
    'bronchâmes',
    'bronchât',
    'bronchâtes',
    'bronchèrent',
    'bronché',
    'brontosaure',
    'brontosaures',
    'bronza',
    'bronzage',
    'bronzages',
    'bronzai',
    'bronzaient',
    'bronzais',
    'bronzait',
    'bronzant',
    'bronzante',
    'bronzantes',
    'bronzants',
    'bronzas',
    'bronzasse',
    'bronzassent',
    'bronzasses',
    'bronzassiez',
    'bronzassions',
    'bronze',
    'bronzent',
    'bronzer',
    'bronzera',
    'bronzerai',
    'bronzeraient',
    'bronzerais',
    'bronzerait',
    'bronzeras',
    'bronzerez',
    'bronzeriez',
    'bronzerions',
    'bronzerons',
    'bronzeront',
    'bronzes',
    'bronzeur',
    'bronzeurs',
    'bronzez',
    'bronzier',
    'bronziers',
    'bronziez',
    'bronzions',
    'bronzons',
    'bronzâmes',
    'bronzât',
    'bronzâtes',
    'bronzèrent',
    'bronzé',
    'bronzée',
    'bronzées',
    'bronzés',
    'brook',
    'brooks',
    'broquette',
    'broquettes',
    'brossa',
    'brossage',
    'brossages',
    'brossai',
    'brossaient',
    'brossais',
    'brossait',
    'brossant',
    'brossas',
    'brossasse',
    'brossassent',
    'brossasses',
    'brossassiez',
    'brossassions',
    'brosse',
    'brossent',
    'brosser',
    'brossera',
    'brosserai',
    'brosseraient',
    'brosserais',
    'brosserait',
    'brosseras',
    'brosserez',
    'brosserie',
    'brosseries',
    'brosseriez',
    'brosserions',
    'brosserons',
    'brosseront',
    'brosses',
    'brossez',
    'brossier',
    'brossiers',
    'brossiez',
    'brossions',
    'brossière',
    'brossières',
    'brossons',
    'brossâmes',
    'brossât',
    'brossâtes',
    'brossèrent',
    'brossé',
    'brossée',
    'brossées',
    'brossés',
    'brou',
    'brouet',
    'brouets',
    'brouetta',
    'brouettai',
    'brouettaient',
    'brouettais',
    'brouettait',
    'brouettant',
    'brouettas',
    'brouettasse',
    'brouettasses',
    'brouette',
    'brouettent',
    'brouetter',
    'brouettera',
    'brouetterai',
    'brouetterais',
    'brouetterait',
    'brouetteras',
    'brouetterez',
    'brouetteriez',
    'brouetterons',
    'brouetteront',
    'brouettes',
    'brouettez',
    'brouettiez',
    'brouettions',
    'brouettons',
    'brouettâmes',
    'brouettât',
    'brouettâtes',
    'brouettèrent',
    'brouetté',
    'brouettée',
    'brouettées',
    'brouettés',
    'brouhaha',
    'brouhahas',
    'brouilla',
    'brouillage',
    'brouillages',
    'brouillai',
    'brouillaient',
    'brouillais',
    'brouillait',
    'brouillamini',
    'brouillant',
    'brouillard',
    'brouillards',
    'brouillas',
    'brouillassa',
    'brouillasse',
    'brouillasser',
    'brouillasses',
    'brouillassât',
    'brouillassé',
    'brouille',
    'brouillent',
    'brouiller',
    'brouillera',
    'brouillerai',
    'brouillerais',
    'brouillerait',
    'brouilleras',
    'brouillerez',
    'brouillerie',
    'brouilleries',
    'brouilleriez',
    'brouillerons',
    'brouilleront',
    'brouilles',
    'brouilleur',
    'brouilleurs',
    'brouillez',
    'brouilliez',
    'brouillions',
    'brouillon',
    'brouillonna',
    'brouillonnai',
    'brouillonnas',
    'brouillonne',
    'brouillonner',
    'brouillonnes',
    'brouillonnez',
    'brouillonnât',
    'brouillonné',
    'brouillonnée',
    'brouillonnés',
    'brouillons',
    'brouillâmes',
    'brouillât',
    'brouillâtes',
    'brouillèrent',
    'brouillé',
    'brouillée',
    'brouillées',
    'brouillés',
    'broum',
    'brous',
    'broussaille',
    'broussailles',
    'broussard',
    'broussards',
    'brousse',
    'brousses',
    'broussin',
    'broussins',
    'brout',
    'brouta',
    'broutai',
    'broutaient',
    'broutais',
    'broutait',
    'broutant',
    'broutard',
    'broutards',
    'broutas',
    'broutasse',
    'broutassent',
    'broutasses',
    'broutassiez',
    'broutassions',
    'broute',
    'broutement',
    'broutements',
    'broutent',
    'brouter',
    'broutera',
    'brouterai',
    'brouteraient',
    'brouterais',
    'brouterait',
    'brouteras',
    'brouterez',
    'brouteriez',
    'brouterions',
    'brouterons',
    'brouteront',
    'broutes',
    'broutez',
    'broutiez',
    'broutille',
    'broutilles',
    'broutions',
    'broutons',
    'brouts',
    'broutâmes',
    'broutât',
    'broutâtes',
    'broutèrent',
    'brouté',
    'broutée',
    'broutées',
    'broutés',
    'browning',
    'brownings',
    'broya',
    'broyage',
    'broyages',
    'broyai',
    'broyaient',
    'broyais',
    'broyait',
    'broyant',
    'broyas',
    'broyasse',
    'broyassent',
    'broyasses',
    'broyassiez',
    'broyassions',
    'broyer',
    'broyeur',
    'broyeurs',
    'broyeuse',
    'broyeuses',
    'broyez',
    'broyiez',
    'broyions',
    'broyons',
    'broyâmes',
    'broyât',
    'broyâtes',
    'broyèrent',
    'broyé',
    'broyée',
    'broyées',
    'broyés',
    'brrr',
    'bruant',
    'bruants',
    'brucelles',
    'brucellose',
    'brucelloses',
    'bruche',
    'bruches',
    'brucine',
    'brucines',
    'brugnon',
    'brugnonier',
    'brugnoniers',
    'brugnons',
    'brui',
    'bruie',
    'bruies',
    'bruina',
    'bruinait',
    'bruinant',
    'bruine',
    'bruiner',
    'bruinera',
    'bruinerait',
    'bruines',
    'bruineuse',
    'bruineuses',
    'bruineux',
    'bruinât',
    'bruinèrent',
    'bruiné',
    'bruir',
    'bruira',
    'bruirai',
    'bruiraient',
    'bruirais',
    'bruirait',
    'bruiras',
    'bruire',
    'bruirent',
    'bruirez',
    'bruiriez',
    'bruirions',
    'bruirons',
    'bruiront',
    'bruis',
    'bruissage',
    'bruissages',
    'bruissaient',
    'bruissais',
    'bruissait',
    'bruissant',
    'bruisse',
    'bruissement',
    'bruissements',
    'bruissent',
    'bruisses',
    'bruissez',
    'bruissiez',
    'bruissions',
    'bruissons',
    'bruit',
    'bruita',
    'bruitage',
    'bruitages',
    'bruitai',
    'bruitaient',
    'bruitais',
    'bruitait',
    'bruitant',
    'bruitas',
    'bruitasse',
    'bruitassent',
    'bruitasses',
    'bruitassiez',
    'bruitassions',
    'bruite',
    'bruitent',
    'bruiter',
    'bruitera',
    'bruiterai',
    'bruiteraient',
    'bruiterais',
    'bruiterait',
    'bruiteras',
    'bruiterez',
    'bruiteriez',
    'bruiterions',
    'bruiterons',
    'bruiteront',
    'bruites',
    'bruiteur',
    'bruiteurs',
    'bruiteuse',
    'bruiteuses',
    'bruitez',
    'bruitiez',
    'bruitions',
    'bruitons',
    'bruits',
    'bruitâmes',
    'bruitât',
    'bruitâtes',
    'bruitèrent',
    'bruité',
    'bruma',
    'brumaire',
    'brumait',
    'brumassa',
    'brumassait',
    'brumasse',
    'brumasser',
    'brumassera',
    'brumasserait',
    'brumassât',
    'brumassé',
    'brume',
    'brumer',
    'brumera',
    'brumerait',
    'brumes',
    'brumeuse',
    'brumeuses',
    'brumeux',
    'brumisateur',
    'brumisateurs',
    'brumât',
    'brumé',
    'brun',
    'brunante',
    'brunantes',
    'brunch',
    'brunchs',
    'brune',
    'brunes',
    'brunet',
    'brunets',
    'brunette',
    'brunettes',
    'bruni',
    'brunie',
    'brunies',
    'brunir',
    'brunira',
    'brunirai',
    'bruniraient',
    'brunirais',
    'brunirait',
    'bruniras',
    'brunirent',
    'brunirez',
    'bruniriez',
    'brunirions',
    'brunirons',
    'bruniront',
    'brunis',
    'brunissage',
    'brunissages',
    'brunissaient',
    'brunissais',
    'brunissait',
    'brunissant',
    'brunissante',
    'brunissantes',
    'brunissants',
    'brunisse',
    'brunissement',
    'brunissent',
    'brunisses',
    'brunisseur',
    'brunisseurs',
    'brunisseuse',
    'brunisseuses',
    'brunissez',
    'brunissiez',
    'brunissions',
    'brunissoir',
    'brunissoirs',
    'brunissons',
    'brunissure',
    'brunissures',
    'brunit',
    'bruns',
    'brunâtre',
    'brunâtres',
    'brunîmes',
    'brunît',
    'brunîtes',
    'brus',
    'brushing',
    'brushings',
    'brusqua',
    'brusquai',
    'brusquaient',
    'brusquais',
    'brusquait',
    'brusquant',
    'brusquas',
    'brusquasse',
    'brusquassent',
    'brusquasses',
    'brusquassiez',
    'brusque',
    'brusquement',
    'brusquent',
    'brusquer',
    'brusquera',
    'brusquerai',
    'brusquerais',
    'brusquerait',
    'brusqueras',
    'brusquerez',
    'brusquerie',
    'brusqueries',
    'brusqueriez',
    'brusquerions',
    'brusquerons',
    'brusqueront',
    'brusques',
    'brusquez',
    'brusquiez',
    'brusquions',
    'brusquons',
    'brusquâmes',
    'brusquât',
    'brusquâtes',
    'brusquèrent',
    'brusqué',
    'brusquée',
    'brusquées',
    'brusqués',
    'brut',
    'brutal',
    'brutale',
    'brutalement',
    'brutales',
    'brutalisa',
    'brutalisai',
    'brutalisais',
    'brutalisait',
    'brutalisant',
    'brutalisas',
    'brutalisasse',
    'brutalise',
    'brutalisent',
    'brutaliser',
    'brutalisera',
    'brutaliserai',
    'brutaliseras',
    'brutaliserez',
    'brutalises',
    'brutalisez',
    'brutalisiez',
    'brutalisions',
    'brutalisons',
    'brutalisâmes',
    'brutalisât',
    'brutalisâtes',
    'brutalisé',
    'brutalisée',
    'brutalisées',
    'brutalisés',
    'brutalité',
    'brutalités',
    'brutaux',
    'brute',
    'brutes',
    'bruts',
    'bruyamment',
    'bruyant',
    'bruyante',
    'bruyantes',
    'bruyants',
    'bruyère',
    'bruyères',
    'bruîmes',
    'bruît',
    'bruîtes',
    'bryologie',
    'bryologies',
    'bryone',
    'bryones',
    'brèche',
    'brèches',
    'brèle',
    'brèlent',
    'brèles',
    'brème',
    'brèmes',
    'brève',
    'brèves',
    'bréchet',
    'bréchets',
    'bréla',
    'brélai',
    'brélaient',
    'brélais',
    'brélait',
    'brélant',
    'brélas',
    'brélasse',
    'brélassent',
    'brélasses',
    'brélassiez',
    'brélassions',
    'bréler',
    'brélera',
    'brélerai',
    'bréleraient',
    'brélerais',
    'brélerait',
    'bréleras',
    'brélerez',
    'bréleriez',
    'brélerions',
    'brélerons',
    'bréleront',
    'brélez',
    'bréliez',
    'brélions',
    'brélons',
    'brélâmes',
    'brélât',
    'brélâtes',
    'brélèrent',
    'brélé',
    'brélée',
    'brélées',
    'brélés',
    'brésil',
    'brésilien',
    'brésilienne',
    'brésiliennes',
    'brésiliens',
    'brésilla',
    'brésillai',
    'brésillaient',
    'brésillais',
    'brésillait',
    'brésillant',
    'brésillas',
    'brésillasse',
    'brésillasses',
    'brésille',
    'brésillent',
    'brésiller',
    'brésillera',
    'brésillerai',
    'brésillerais',
    'brésillerait',
    'brésilleras',
    'brésillerez',
    'brésilleriez',
    'brésillerons',
    'brésilleront',
    'brésilles',
    'brésillez',
    'brésilliez',
    'brésillions',
    'brésillons',
    'brésillâmes',
    'brésillât',
    'brésillâtes',
    'brésillèrent',
    'brésillé',
    'brésillée',
    'brésillées',
    'brésillés',
    'bréviaire',
    'bréviaires',
    'bréviligne',
    'brévilignes',
    'brévité',
    'brévités',
    'brêla',
    'brêlai',
    'brêlaient',
    'brêlais',
    'brêlait',
    'brêlant',
    'brêlas',
    'brêlasse',
    'brêlassent',
    'brêlasses',
    'brêlassiez',
    'brêlassions',
    'brêle',
    'brêlent',
    'brêler',
    'brêlera',
    'brêlerai',
    'brêleraient',
    'brêlerais',
    'brêlerait',
    'brêleras',
    'brêlerez',
    'brêleriez',
    'brêlerions',
    'brêlerons',
    'brêleront',
    'brêles',
    'brêlez',
    'brêliez',
    'brêlions',
    'brêlons',
    'brêlâmes',
    'brêlât',
    'brêlâtes',
    'brêlèrent',
    'brêlé',
    'brêlée',
    'brêlées',
    'brêlés',
    'brûla',
    'brûlage',
    'brûlages',
    'brûlai',
    'brûlaient',
    'brûlais',
    'brûlait',
    'brûlant',
    'brûlante',
    'brûlantes',
    'brûlants',
    'brûlas',
    'brûlasse',
    'brûlassent',
    'brûlasses',
    'brûlassiez',
    'brûlassions',
    'brûle',
    'brûlent',
    'brûler',
    'brûlera',
    'brûlerai',
    'brûleraient',
    'brûlerais',
    'brûlerait',
    'brûleras',
    'brûlerez',
    'brûlerie',
    'brûleries',
    'brûleriez',
    'brûlerions',
    'brûlerons',
    'brûleront',
    'brûles',
    'brûleur',
    'brûleurs',
    'brûlez',
    'brûliez',
    'brûlions',
    'brûlis',
    'brûloir',
    'brûloirs',
    'brûlons',
    'brûlot',
    'brûlots',
    'brûlure',
    'brûlures',
    'brûlâmes',
    'brûlât',
    'brûlâtes',
    'brûlèrent',
    'brûlé',
    'brûlée',
    'brûlées',
    'brûlés',
    'buanderie',
    'buanderies',
    'buandier',
    'buandiers',
    'buandière',
    'buandières',
    'bubale',
    'bubales',
    'bubon',
    'bubonique',
    'buboniques',
    'bubons',
    'buccal',
    'buccale',
    'buccales',
    'buccaux',
    'buccin',
    'buccinateur',
    'buccinateurs',
    'buccins',
    'bucolique',
    'bucoliques',
    'bucrane',
    'bucranes',
    'budget',
    'budgets',
    'budgétaire',
    'budgétaires',
    'budgéter',
    'budgétisa',
    'budgétisai',
    'budgétisais',
    'budgétisait',
    'budgétisant',
    'budgétisas',
    'budgétisasse',
    'budgétise',
    'budgétisent',
    'budgétiser',
    'budgétisera',
    'budgétiserai',
    'budgétiseras',
    'budgétiserez',
    'budgétises',
    'budgétisez',
    'budgétisiez',
    'budgétisions',
    'budgétisons',
    'budgétisâmes',
    'budgétisât',
    'budgétisâtes',
    'budgétisé',
    'budgétisée',
    'budgétisées',
    'budgétisés',
    'budgétivore',
    'budgétivores',
    'bues',
    'buffet',
    'buffetier',
    'buffetiers',
    'buffetière',
    'buffetières',
    'buffets',
    'buffle',
    'buffler',
    'buffles',
    'buffleterie',
    'buffleteries',
    'buggy',
    'buggys',
    'bugle',
    'bugles',
    'buglosse',
    'buglosses',
    'bugrane',
    'bugranes',
    'building',
    'buildings',
    'buire',
    'buires',
    'buis',
    'buisson',
    'buissonneuse',
    'buissonneux',
    'buissonnier',
    'buissonniers',
    'buissonnière',
    'buissons',
    'bulbaire',
    'bulbaires',
    'bulbe',
    'bulbes',
    'bulbeuse',
    'bulbeuses',
    'bulbeux',
    'bulbille',
    'bulbilles',
    'bulgare',
    'bulgares',
    'bullaire',
    'bullaires',
    'bulldozer',
    'bulldozers',
    'bulle',
    'bulles',
    'bulletin',
    'bulletins',
    'bulleuse',
    'bulleuses',
    'bulleux',
    'buna',
    'bungalow',
    'bungalows',
    'bunker',
    'bunkers',
    'bupreste',
    'buprestes',
    'buraliste',
    'buralistes',
    'bure',
    'bureau',
    'bureaucrate',
    'bureaucrates',
    'bureaucratie',
    'bureautique',
    'bureautiques',
    'bureaux',
    'burelle',
    'burelles',
    'burelé',
    'burelée',
    'burelées',
    'burelés',
    'burent',
    'bures',
    'burette',
    'burettes',
    'burgau',
    'burgaus',
    'burin',
    'burina',
    'burinage',
    'burinages',
    'burinai',
    'burinaient',
    'burinais',
    'burinait',
    'burinant',
    'burinas',
    'burinasse',
    'burinassent',
    'burinasses',
    'burinassiez',
    'burinassions',
    'burine',
    'burinent',
    'buriner',
    'burinera',
    'burinerai',
    'burineraient',
    'burinerais',
    'burinerait',
    'burineras',
    'burinerez',
    'burineriez',
    'burinerions',
    'burinerons',
    'burineront',
    'burines',
    'burineur',
    'burineurs',
    'burinez',
    'buriniez',
    'burinions',
    'burinons',
    'burins',
    'burinâmes',
    'burinât',
    'burinâtes',
    'burinèrent',
    'buriné',
    'burinée',
    'burinées',
    'burinés',
    'burlesque',
    'burlesques',
    'burlingue',
    'burlingues',
    'burnous',
    'buron',
    'burons',
    'busard',
    'busards',
    'busc',
    'buscs',
    'buse',
    'buses',
    'bush',
    'bushes',
    'business',
    'businessman',
    'businessmen',
    'busquer',
    'busqué',
    'busquée',
    'busquées',
    'busqués',
    'busse',
    'bussent',
    'busserole',
    'busseroles',
    'busses',
    'bussiez',
    'bussions',
    'buste',
    'bustes',
    'bustier',
    'bustiers',
    'buta',
    'butadiène',
    'butadiènes',
    'butai',
    'butaient',
    'butais',
    'butait',
    'butane',
    'butanier',
    'butaniers',
    'butant',
    'butas',
    'butasse',
    'butassent',
    'butasses',
    'butassiez',
    'butassions',
    'bute',
    'butent',
    'buter',
    'butera',
    'buterai',
    'buteraient',
    'buterais',
    'buterait',
    'buteras',
    'buterez',
    'buteriez',
    'buterions',
    'buterons',
    'buteront',
    'butes',
    'buteur',
    'buteurs',
    'butez',
    'butiez',
    'butin',
    'butina',
    'butinai',
    'butinaient',
    'butinais',
    'butinait',
    'butinant',
    'butinas',
    'butinasse',
    'butinassent',
    'butinasses',
    'butinassiez',
    'butinassions',
    'butine',
    'butinent',
    'butiner',
    'butinera',
    'butinerai',
    'butineraient',
    'butinerais',
    'butinerait',
    'butineras',
    'butinerez',
    'butineriez',
    'butinerions',
    'butinerons',
    'butineront',
    'butines',
    'butineur',
    'butineurs',
    'butineuse',
    'butineuses',
    'butinez',
    'butiniez',
    'butinions',
    'butinons',
    'butins',
    'butinâmes',
    'butinât',
    'butinâtes',
    'butinèrent',
    'butiné',
    'butinée',
    'butinées',
    'butinés',
    'butions',
    'butoir',
    'butoirs',
    'butome',
    'butomes',
    'butons',
    'butor',
    'butors',
    'buts',
    'butta',
    'buttage',
    'buttages',
    'buttai',
    'buttaient',
    'buttais',
    'buttait',
    'buttant',
    'buttas',
    'buttasse',
    'buttassent',
    'buttasses',
    'buttassiez',
    'buttassions',
    'butte',
    'buttent',
    'butter',
    'buttera',
    'butterai',
    'butteraient',
    'butterais',
    'butterait',
    'butteras',
    'butterez',
    'butteriez',
    'butterions',
    'butterons',
    'butteront',
    'buttes',
    'buttez',
    'buttiez',
    'buttions',
    'buttoir',
    'buttoirs',
    'buttons',
    'buttâmes',
    'buttât',
    'buttâtes',
    'buttèrent',
    'butté',
    'buttée',
    'buttées',
    'buttés',
    'butylique',
    'butyliques',
    'butylène',
    'butylènes',
    'butyrate',
    'butyrates',
    'butyreuse',
    'butyreuses',
    'butyreux',
    'butyrine',
    'butyrines',
    'butyrique',
    'butyriques',
    'butyromètre',
    'butyromètres',
    'butâmes',
    'butât',
    'butâtes',
    'butèrent',
    'buté',
    'butée',
    'butées',
    'butés',
    'buvable',
    'buvables',
    'buvaient',
    'buvais',
    'buvait',
    'buvant',
    'buvard',
    'buvards',
    'buvetier',
    'buvetiers',
    'buvetière',
    'buvetières',
    'buvette',
    'buvettes',
    'buveur',
    'buveurs',
    'buveuse',
    'buveuses',
    'buvez',
    'buviez',
    'buvions',
    'buvons',
    'buvota',
    'buvotai',
    'buvotaient',
    'buvotais',
    'buvotait',
    'buvotant',
    'buvotas',
    'buvotasse',
    'buvotassent',
    'buvotasses',
    'buvotassiez',
    'buvotassions',
    'buvote',
    'buvotent',
    'buvoter',
    'buvotera',
    'buvoterai',
    'buvoteraient',
    'buvoterais',
    'buvoterait',
    'buvoteras',
    'buvoterez',
    'buvoteriez',
    'buvoterions',
    'buvoterons',
    'buvoteront',
    'buvotes',
    'buvotez',
    'buvotiez',
    'buvotions',
    'buvotons',
    'buvotâmes',
    'buvotât',
    'buvotâtes',
    'buvotèrent',
    'buvoté',
    'buvée',
    'buvées',
    'buée',
    'buées',
    'byssinose',
    'byssinoses',
    'byssus',
    'byzantin',
    'byzantine',
    'byzantines',
    'byzantinisme',
    'byzantiniste',
    'byzantins',
    'bâbord',
    'bâbordais',
    'bâcha',
    'bâchage',
    'bâchages',
    'bâchai',
    'bâchaient',
    'bâchais',
    'bâchait',
    'bâchant',
    'bâchas',
    'bâchasse',
    'bâchassent',
    'bâchasses',
    'bâchassiez',
    'bâchassions',
    'bâche',
    'bâchent',
    'bâcher',
    'bâchera',
    'bâcherai',
    'bâcheraient',
    'bâcherais',
    'bâcherait',
    'bâcheras',
    'bâcherez',
    'bâcheriez',
    'bâcherions',
    'bâcherons',
    'bâcheront',
    'bâches',
    'bâchez',
    'bâchiez',
    'bâchions',
    'bâchons',
    'bâchâmes',
    'bâchât',
    'bâchâtes',
    'bâchèrent',
    'bâché',
    'bâchée',
    'bâchées',
    'bâchés',
    'bâcla',
    'bâclage',
    'bâclages',
    'bâclai',
    'bâclaient',
    'bâclais',
    'bâclait',
    'bâclant',
    'bâclas',
    'bâclasse',
    'bâclassent',
    'bâclasses',
    'bâclassiez',
    'bâclassions',
    'bâcle',
    'bâclent',
    'bâcler',
    'bâclera',
    'bâclerai',
    'bâcleraient',
    'bâclerais',
    'bâclerait',
    'bâcleras',
    'bâclerez',
    'bâcleriez',
    'bâclerions',
    'bâclerons',
    'bâcleront',
    'bâcles',
    'bâclez',
    'bâcliez',
    'bâclions',
    'bâclons',
    'bâclâmes',
    'bâclât',
    'bâclâtes',
    'bâclèrent',
    'bâclé',
    'bâclée',
    'bâclées',
    'bâclés',
    'bâfra',
    'bâfrai',
    'bâfraient',
    'bâfrais',
    'bâfrait',
    'bâfrant',
    'bâfras',
    'bâfrasse',
    'bâfrassent',
    'bâfrasses',
    'bâfrassiez',
    'bâfrassions',
    'bâfre',
    'bâfrent',
    'bâfrer',
    'bâfrera',
    'bâfrerai',
    'bâfreraient',
    'bâfrerais',
    'bâfrerait',
    'bâfreras',
    'bâfrerez',
    'bâfreriez',
    'bâfrerions',
    'bâfrerons',
    'bâfreront',
    'bâfres',
    'bâfreur',
    'bâfreurs',
    'bâfreuse',
    'bâfreuses',
    'bâfrez',
    'bâfriez',
    'bâfrions',
    'bâfrons',
    'bâfrâmes',
    'bâfrât',
    'bâfrâtes',
    'bâfrèrent',
    'bâfré',
    'bâfrée',
    'bâfrées',
    'bâfrés',
    'bâilla',
    'bâillai',
    'bâillaient',
    'bâillais',
    'bâillait',
    'bâillant',
    'bâillas',
    'bâillasse',
    'bâillassent',
    'bâillasses',
    'bâillassiez',
    'bâillassions',
    'bâille',
    'bâillement',
    'bâillements',
    'bâillent',
    'bâiller',
    'bâillera',
    'bâillerai',
    'bâilleraient',
    'bâillerais',
    'bâillerait',
    'bâilleras',
    'bâillerez',
    'bâilleriez',
    'bâillerions',
    'bâillerons',
    'bâilleront',
    'bâilles',
    'bâillez',
    'bâilliez',
    'bâillions',
    'bâillon',
    'bâillonna',
    'bâillonnai',
    'bâillonnais',
    'bâillonnait',
    'bâillonnant',
    'bâillonnas',
    'bâillonnasse',
    'bâillonne',
    'bâillonnent',
    'bâillonner',
    'bâillonnera',
    'bâillonnerai',
    'bâillonneras',
    'bâillonnerez',
    'bâillonnes',
    'bâillonnez',
    'bâillonniez',
    'bâillonnions',
    'bâillonnons',
    'bâillonnâmes',
    'bâillonnât',
    'bâillonnâtes',
    'bâillonné',
    'bâillonnée',
    'bâillonnées',
    'bâillonnés',
    'bâillons',
    'bâillâmes',
    'bâillât',
    'bâillâtes',
    'bâillèrent',
    'bâillé',
    'bâta',
    'bâtai',
    'bâtaient',
    'bâtais',
    'bâtait',
    'bâtant',
    'bâtard',
    'bâtarde',
    'bâtardes',
    'bâtardise',
    'bâtardises',
    'bâtards',
    'bâtas',
    'bâtasse',
    'bâtassent',
    'bâtasses',
    'bâtassiez',
    'bâtassions',
    'bâte',
    'bâtent',
    'bâter',
    'bâtera',
    'bâterai',
    'bâteraient',
    'bâterais',
    'bâterait',
    'bâteras',
    'bâterez',
    'bâteriez',
    'bâterions',
    'bâterons',
    'bâteront',
    'bâtes',
    'bâtez',
    'bâti',
    'bâtie',
    'bâties',
    'bâtiez',
    'bâtiment',
    'bâtiments',
    'bâtions',
    'bâtir',
    'bâtira',
    'bâtirai',
    'bâtiraient',
    'bâtirais',
    'bâtirait',
    'bâtiras',
    'bâtirent',
    'bâtirez',
    'bâtiriez',
    'bâtirions',
    'bâtirons',
    'bâtiront',
    'bâtis',
    'bâtissaient',
    'bâtissais',
    'bâtissait',
    'bâtissant',
    'bâtisse',
    'bâtissent',
    'bâtisses',
    'bâtisseur',
    'bâtisseurs',
    'bâtisseuse',
    'bâtisseuses',
    'bâtissez',
    'bâtissiez',
    'bâtissions',
    'bâtissons',
    'bâtit',
    'bâton',
    'bâtonna',
    'bâtonnai',
    'bâtonnaient',
    'bâtonnais',
    'bâtonnait',
    'bâtonnant',
    'bâtonnas',
    'bâtonnasse',
    'bâtonnassent',
    'bâtonnasses',
    'bâtonnassiez',
    'bâtonnat',
    'bâtonnats',
    'bâtonne',
    'bâtonnent',
    'bâtonner',
    'bâtonnera',
    'bâtonnerai',
    'bâtonnerais',
    'bâtonnerait',
    'bâtonneras',
    'bâtonnerez',
    'bâtonneriez',
    'bâtonnerions',
    'bâtonnerons',
    'bâtonneront',
    'bâtonnes',
    'bâtonnet',
    'bâtonnets',
    'bâtonnez',
    'bâtonnier',
    'bâtonniers',
    'bâtonniez',
    'bâtonnions',
    'bâtonnons',
    'bâtonnâmes',
    'bâtonnât',
    'bâtonnâtes',
    'bâtonnèrent',
    'bâtonné',
    'bâtonnée',
    'bâtonnées',
    'bâtonnés',
    'bâtons',
    'bâtâmes',
    'bâtât',
    'bâtâtes',
    'bâtèrent',
    'bâté',
    'bâtée',
    'bâtées',
    'bâtés',
    'bâtîmes',
    'bâtît',
    'bâtîtes',
    'bègue',
    'bègues',
    'bèque',
    'bèquent',
    'bèques',
    'béai',
    'béaient',
    'béais',
    'béait',
    'béance',
    'béances',
    'béant',
    'béante',
    'béantes',
    'béants',
    'béarnais',
    'béarnaise',
    'béarnaises',
    'béas',
    'béasse',
    'béassent',
    'béasses',
    'béassiez',
    'béassions',
    'béat',
    'béate',
    'béatement',
    'béates',
    'béatifia',
    'béatifiai',
    'béatifiaient',
    'béatifiais',
    'béatifiait',
    'béatifiant',
    'béatifiante',
    'béatifiantes',
    'béatifiants',
    'béatifias',
    'béatifiasse',
    'béatifiasses',
    'béatifie',
    'béatifient',
    'béatifier',
    'béatifiera',
    'béatifierai',
    'béatifierais',
    'béatifierait',
    'béatifieras',
    'béatifierez',
    'béatifieriez',
    'béatifierons',
    'béatifieront',
    'béatifies',
    'béatifiez',
    'béatifiiez',
    'béatifiions',
    'béatifions',
    'béatifique',
    'béatifiques',
    'béatifiâmes',
    'béatifiât',
    'béatifiâtes',
    'béatifièrent',
    'béatifié',
    'béatifiée',
    'béatifiées',
    'béatifiés',
    'béatitude',
    'béatitudes',
    'béats',
    'bébé',
    'bébés',
    'bécane',
    'bécanes',
    'bécarre',
    'bécarres',
    'bécasse',
    'bécasseau',
    'bécasseaux',
    'bécasses',
    'bécassine',
    'bécassines',
    'béchamel',
    'béchamels',
    'béchique',
    'béchiques',
    'bécot',
    'bécota',
    'bécotai',
    'bécotaient',
    'bécotais',
    'bécotait',
    'bécotant',
    'bécotas',
    'bécotasse',
    'bécotassent',
    'bécotasses',
    'bécotassiez',
    'bécotassions',
    'bécote',
    'bécotent',
    'bécoter',
    'bécotera',
    'bécoterai',
    'bécoteraient',
    'bécoterais',
    'bécoterait',
    'bécoteras',
    'bécoterez',
    'bécoteriez',
    'bécoterions',
    'bécoterons',
    'bécoteront',
    'bécotes',
    'bécotez',
    'bécotiez',
    'bécotions',
    'bécotons',
    'bécots',
    'bécotâmes',
    'bécotât',
    'bécotâtes',
    'bécotèrent',
    'bécoté',
    'bécotée',
    'bécotées',
    'bécotés',
    'bédane',
    'bédanes',
    'bédouin',
    'bédouine',
    'bédouines',
    'bédouins',
    'bédégar',
    'bédégars',
    'béent',
    'béer',
    'béera',
    'béerai',
    'béeraient',
    'béerais',
    'béerait',
    'béeras',
    'béerez',
    'béeriez',
    'béerions',
    'béerons',
    'béeront',
    'bées',
    'béez',
    'bégaie',
    'bégaiement',
    'bégaiements',
    'bégaient',
    'bégaiera',
    'bégaierai',
    'bégaieraient',
    'bégaierais',
    'bégaierait',
    'bégaieras',
    'bégaierez',
    'bégaieriez',
    'bégaierions',
    'bégaierons',
    'bégaieront',
    'bégaies',
    'bégaya',
    'bégayai',
    'bégayaient',
    'bégayais',
    'bégayait',
    'bégayant',
    'bégayas',
    'bégayasse',
    'bégayassent',
    'bégayasses',
    'bégayassiez',
    'bégayassions',
    'bégaye',
    'bégayent',
    'bégayer',
    'bégayera',
    'bégayerai',
    'bégayeraient',
    'bégayerais',
    'bégayerait',
    'bégayeras',
    'bégayerez',
    'bégayeriez',
    'bégayerions',
    'bégayerons',
    'bégayeront',
    'bégayes',
    'bégayeur',
    'bégayeurs',
    'bégayeuse',
    'bégayeuses',
    'bégayez',
    'bégayiez',
    'bégayions',
    'bégayons',
    'bégayâmes',
    'bégayât',
    'bégayâtes',
    'bégayèrent',
    'bégayé',
    'bégayée',
    'bégayées',
    'bégayés',
    'bégonia',
    'bégonias',
    'bégu',
    'bégueta',
    'béguetai',
    'béguetaient',
    'béguetais',
    'béguetait',
    'béguetant',
    'béguetas',
    'béguetasse',
    'béguetassent',
    'béguetasses',
    'béguetassiez',
    'bégueter',
    'béguetez',
    'béguetiez',
    'béguetions',
    'béguetons',
    'béguetâmes',
    'béguetât',
    'béguetâtes',
    'béguetèrent',
    'bégueté',
    'bégueule',
    'bégueulerie',
    'bégueuleries',
    'bégueules',
    'béguin',
    'béguinage',
    'béguinages',
    'béguine',
    'béguines',
    'béguins',
    'bégum',
    'bégums',
    'béguète',
    'béguètement',
    'béguètements',
    'béguètent',
    'béguètera',
    'béguèterai',
    'béguèterais',
    'béguèterait',
    'béguèteras',
    'béguèterez',
    'béguèteriez',
    'béguèterions',
    'béguèterons',
    'béguèteront',
    'béguètes',
    'béguë',
    'béhaviorisme',
    'béhavioriste',
    'béiez',
    'béions',
    'béjaune',
    'béjaunes',
    'béké',
    'békés',
    'bélandre',
    'bélandres',
    'bélemnite',
    'bélemnites',
    'bélier',
    'béliers',
    'bélinographe',
    'bélière',
    'bélières',
    'bélouga',
    'bélougas',
    'béluga',
    'bélugas',
    'bélître',
    'bélîtres',
    'bémol',
    'bémolisa',
    'bémolisai',
    'bémolisaient',
    'bémolisais',
    'bémolisait',
    'bémolisant',
    'bémolisas',
    'bémolisasse',
    'bémolisasses',
    'bémolise',
    'bémolisent',
    'bémoliser',
    'bémolisera',
    'bémoliserai',
    'bémoliserais',
    'bémoliserait',
    'bémoliseras',
    'bémoliserez',
    'bémoliseriez',
    'bémoliserons',
    'bémoliseront',
    'bémolises',
    'bémolisez',
    'bémolisiez',
    'bémolisions',
    'bémolisons',
    'bémolisâmes',
    'bémolisât',
    'bémolisâtes',
    'bémolisèrent',
    'bémolisé',
    'bémolisée',
    'bémolisées',
    'bémolisés',
    'bémols',
    'bénarde',
    'bénardes',
    'bénef',
    'bénefs',
    'béni',
    'bénie',
    'bénies',
    'bénigne',
    'bénignement',
    'bénignes',
    'bénignité',
    'bénignités',
    'bénin',
    'bénins',
    'bénir',
    'bénira',
    'bénirai',
    'béniraient',
    'bénirais',
    'bénirait',
    'béniras',
    'bénirent',
    'bénirez',
    'béniriez',
    'bénirions',
    'bénirons',
    'béniront',
    'bénis',
    'bénissaient',
    'bénissais',
    'bénissait',
    'bénissant',
    'bénisse',
    'bénissent',
    'bénisses',
    'bénisseur',
    'bénisseurs',
    'bénisseuse',
    'bénisseuses',
    'bénissez',
    'bénissiez',
    'bénissions',
    'bénissons',
    'bénit',
    'bénite',
    'bénites',
    'bénitier',
    'bénitiers',
    'bénits',
    'bénédicité',
    'bénédicités',
    'bénédictin',
    'bénédictine',
    'bénédictines',
    'bénédictins',
    'bénédiction',
    'bénédictions',
    'bénéfice',
    'bénéfices',
    'bénéficia',
    'bénéficiai',
    'bénéficiaire',
    'bénéficiais',
    'bénéficiait',
    'bénéficiant',
    'bénéficias',
    'bénéficiasse',
    'bénéficie',
    'bénéficient',
    'bénéficier',
    'bénéficiera',
    'bénéficierai',
    'bénéficieras',
    'bénéficierez',
    'bénéficies',
    'bénéficiez',
    'bénéficiiez',
    'bénéficiions',
    'bénéficions',
    'bénéficiâmes',
    'bénéficiât',
    'bénéficiâtes',
    'bénéficié',
    'bénéfique',
    'bénéfiques',
    'bénévolat',
    'bénévolats',
    'bénévole',
    'bénévolement',
    'bénévoles',
    'bénîmes',
    'bénît',
    'bénîtes',
    'béons',
    'béotien',
    'béotienne',
    'béotiennes',
    'béotiens',
    'béotisme',
    'béotismes',
    'béqua',
    'béquai',
    'béquaient',
    'béquais',
    'béquait',
    'béquant',
    'béquas',
    'béquasse',
    'béquassent',
    'béquasses',
    'béquassiez',
    'béquassions',
    'béquer',
    'béquera',
    'béquerai',
    'béqueraient',
    'béquerais',
    'béquerait',
    'béqueras',
    'béquerez',
    'béqueriez',
    'béquerions',
    'béquerons',
    'béqueront',
    'béqueta',
    'béquetai',
    'béquetaient',
    'béquetais',
    'béquetait',
    'béquetant',
    'béquetas',
    'béquetasse',
    'béquetassent',
    'béquetasses',
    'béquetassiez',
    'béqueter',
    'béquetez',
    'béquetiez',
    'béquetions',
    'béquetons',
    'béquette',
    'béquettent',
    'béquettera',
    'béquetterai',
    'béquetterais',
    'béquetterait',
    'béquetteras',
    'béquetterez',
    'béquetteriez',
    'béquetterons',
    'béquetteront',
    'béquettes',
    'béquetâmes',
    'béquetât',
    'béquetâtes',
    'béquetèrent',
    'béqueté',
    'béquetée',
    'béquetées',
    'béquetés',
    'béquez',
    'béquiez',
    'béquilla',
    'béquillai',
    'béquillaient',
    'béquillais',
    'béquillait',
    'béquillant',
    'béquillas',
    'béquillasse',
    'béquillasses',
    'béquille',
    'béquillent',
    'béquiller',
    'béquillera',
    'béquillerai',
    'béquillerais',
    'béquillerait',
    'béquilleras',
    'béquillerez',
    'béquilleriez',
    'béquillerons',
    'béquilleront',
    'béquilles',
    'béquillez',
    'béquilliez',
    'béquillions',
    'béquillons',
    'béquillâmes',
    'béquillât',
    'béquillâtes',
    'béquillèrent',
    'béquillé',
    'béquillée',
    'béquillées',
    'béquillés',
    'béquions',
    'béquons',
    'béquâmes',
    'béquât',
    'béquâtes',
    'béquèrent',
    'béqué',
    'béquée',
    'béquées',
    'béqués',
    'béret',
    'bérets',
    'béribéri',
    'béryl',
    'béryllium',
    'bérylliums',
    'béryls',
    'bésef',
    'bésicles',
    'bésigue',
    'bésigues',
    'bétail',
    'bétaillère',
    'bétaillères',
    'bétails',
    'bétel',
    'bétels',
    'bétoine',
    'bétoines',
    'bétoire',
    'bétoires',
    'béton',
    'bétonna',
    'bétonnage',
    'bétonnages',
    'bétonnai',
    'bétonnaient',
    'bétonnais',
    'bétonnait',
    'bétonnant',
    'bétonnas',
    'bétonnasse',
    'bétonnassent',
    'bétonnasses',
    'bétonnassiez',
    'bétonne',
    'bétonnent',
    'bétonner',
    'bétonnera',
    'bétonnerai',
    'bétonnerais',
    'bétonnerait',
    'bétonneras',
    'bétonnerez',
    'bétonneriez',
    'bétonnerions',
    'bétonnerons',
    'bétonneront',
    'bétonnes',
    'bétonneuse',
    'bétonneuses',
    'bétonnez',
    'bétonniez',
    'bétonnions',
    'bétonnière',
    'bétonnières',
    'bétonnons',
    'bétonnâmes',
    'bétonnât',
    'bétonnâtes',
    'bétonnèrent',
    'bétonné',
    'bétonnée',
    'bétonnées',
    'bétonnés',
    'bétons',
    'bétyle',
    'bétyles',
    'bévatron',
    'bévatrons',
    'bévue',
    'bévues',
    'bézoard',
    'bézoards',
    'béâmes',
    'béât',
    'béâtes',
    'béèrent',
    'bêcha',
    'bêchage',
    'bêchages',
    'bêchai',
    'bêchaient',
    'bêchais',
    'bêchait',
    'bêchant',
    'bêchas',
    'bêchasse',
    'bêchassent',
    'bêchasses',
    'bêchassiez',
    'bêchassions',
    'bêche',
    'bêchent',
    'bêcher',
    'bêchera',
    'bêcherai',
    'bêcheraient',
    'bêcherais',
    'bêcherait',
    'bêcheras',
    'bêcherez',
    'bêcheriez',
    'bêcherions',
    'bêcherons',
    'bêcheront',
    'bêches',
    'bêcheur',
    'bêcheurs',
    'bêcheuse',
    'bêcheuses',
    'bêcheveter',
    'bêchez',
    'bêchiez',
    'bêchions',
    'bêchons',
    'bêchâmes',
    'bêchât',
    'bêchâtes',
    'bêchèrent',
    'bêché',
    'bêchée',
    'bêchées',
    'bêchés',
    'bêla',
    'bêlai',
    'bêlaient',
    'bêlais',
    'bêlait',
    'bêlant',
    'bêlante',
    'bêlantes',
    'bêlants',
    'bêlas',
    'bêlasse',
    'bêlassent',
    'bêlasses',
    'bêlassiez',
    'bêlassions',
    'bêle',
    'bêlement',
    'bêlements',
    'bêlent',
    'bêler',
    'bêlera',
    'bêlerai',
    'bêleraient',
    'bêlerais',
    'bêlerait',
    'bêleras',
    'bêlerez',
    'bêleriez',
    'bêlerions',
    'bêlerons',
    'bêleront',
    'bêles',
    'bêlez',
    'bêliez',
    'bêlions',
    'bêlons',
    'bêlâmes',
    'bêlât',
    'bêlâtes',
    'bêlèrent',
    'bêlé',
    'bêlée',
    'bêlées',
    'bêlés',
    'bêta',
    'bêtas',
    'bêtasse',
    'bêtasses',
    'bêtathérapie',
    'bêtatron',
    'bêtatrons',
    'bête',
    'bêtement',
    'bêtes',
    'bêtifia',
    'bêtifiai',
    'bêtifiaient',
    'bêtifiais',
    'bêtifiait',
    'bêtifiant',
    'bêtifias',
    'bêtifiasse',
    'bêtifiassent',
    'bêtifiasses',
    'bêtifiassiez',
    'bêtifie',
    'bêtifient',
    'bêtifier',
    'bêtifiera',
    'bêtifierai',
    'bêtifierais',
    'bêtifierait',
    'bêtifieras',
    'bêtifierez',
    'bêtifieriez',
    'bêtifierions',
    'bêtifierons',
    'bêtifieront',
    'bêtifies',
    'bêtifiez',
    'bêtifiiez',
    'bêtifiions',
    'bêtifions',
    'bêtifiâmes',
    'bêtifiât',
    'bêtifiâtes',
    'bêtifièrent',
    'bêtifié',
    'bêtisa',
    'bêtisai',
    'bêtisaient',
    'bêtisais',
    'bêtisait',
    'bêtisant',
    'bêtisas',
    'bêtisasse',
    'bêtisassent',
    'bêtisasses',
    'bêtisassiez',
    'bêtisassions',
    'bêtise',
    'bêtisent',
    'bêtiser',
    'bêtisera',
    'bêtiserai',
    'bêtiseraient',
    'bêtiserais',
    'bêtiserait',
    'bêtiseras',
    'bêtiserez',
    'bêtiseriez',
    'bêtiserions',
    'bêtiserons',
    'bêtiseront',
    'bêtises',
    'bêtisez',
    'bêtisier',
    'bêtisiers',
    'bêtisiez',
    'bêtisions',
    'bêtisons',
    'bêtisâmes',
    'bêtisât',
    'bêtisâtes',
    'bêtisèrent',
    'bêtisé',
    'bôme',
    'bômes',
    'bûcha',
    'bûchai',
    'bûchaient',
    'bûchais',
    'bûchait',
    'bûchant',
    'bûchas',
    'bûchasse',
    'bûchassent',
    'bûchasses',
    'bûchassiez',
    'bûchassions',
    'bûche',
    'bûchent',
    'bûcher',
    'bûchera',
    'bûcherai',
    'bûcheraient',
    'bûcherais',
    'bûcherait',
    'bûcheras',
    'bûcherez',
    'bûcheriez',
    'bûcherions',
    'bûcheron',
    'bûcheronne',
    'bûcheronnes',
    'bûcherons',
    'bûcheront',
    'bûchers',
    'bûches',
    'bûchette',
    'bûchettes',
    'bûcheur',
    'bûcheurs',
    'bûcheuse',
    'bûcheuses',
    'bûchez',
    'bûchiez',
    'bûchions',
    'bûchons',
    'bûchâmes',
    'bûchât',
    'bûchâtes',
    'bûchèrent',
    'bûché',
    'bûchée',
    'bûchées',
    'bûchés',
    'bûmes',
    'bûtes',
    'boeuf',
    'boeufs',
    'cabala',
    'cabalai',
    'cabalaient',
    'cabalais',
    'cabalait',
    'cabalant',
    'cabalas',
    'cabalasse',
    'cabalassent',
    'cabalasses',
    'cabalassiez',
    'cabalassions',
    'cabale',
    'cabalent',
    'cabaler',
    'cabalera',
    'cabalerai',
    'cabaleraient',
    'cabalerais',
    'cabalerait',
    'cabaleras',
    'cabalerez',
    'cabaleriez',
    'cabalerions',
    'cabalerons',
    'cabaleront',
    'cabales',
    'cabalez',
    'cabaliez',
    'cabalions',
    'cabaliste',
    'cabalistes',
    'cabalistique',
    'cabalons',
    'cabalâmes',
    'cabalât',
    'cabalâtes',
    'cabalèrent',
    'cabalé',
    'caban',
    'cabana',
    'cabanai',
    'cabanaient',
    'cabanais',
    'cabanait',
    'cabanant',
    'cabanas',
    'cabanasse',
    'cabanassent',
    'cabanasses',
    'cabanassiez',
    'cabanassions',
    'cabane',
    'cabanent',
    'cabaner',
    'cabanera',
    'cabanerai',
    'cabaneraient',
    'cabanerais',
    'cabanerait',
    'cabaneras',
    'cabanerez',
    'cabaneriez',
    'cabanerions',
    'cabanerons',
    'cabaneront',
    'cabanes',
    'cabanez',
    'cabaniez',
    'cabanions',
    'cabanon',
    'cabanons',
    'cabans',
    'cabanâmes',
    'cabanât',
    'cabanâtes',
    'cabanèrent',
    'cabané',
    'cabanée',
    'cabanées',
    'cabanés',
    'cabaret',
    'cabaretier',
    'cabaretiers',
    'cabaretière',
    'cabaretières',
    'cabarets',
    'cabas',
    'cabasset',
    'cabassets',
    'cabernet',
    'cabernets',
    'cabestan',
    'cabestans',
    'cabiai',
    'cabiais',
    'cabillaud',
    'cabillauds',
    'cabillot',
    'cabillots',
    'cabine',
    'cabines',
    'cabinet',
    'cabinets',
    'cabochard',
    'cabocharde',
    'cabochardes',
    'cabochards',
    'caboche',
    'caboches',
    'cabochon',
    'cabochons',
    'cabossa',
    'cabossai',
    'cabossaient',
    'cabossais',
    'cabossait',
    'cabossant',
    'cabossas',
    'cabossasse',
    'cabossassent',
    'cabossasses',
    'cabossassiez',
    'cabosse',
    'cabossent',
    'cabosser',
    'cabossera',
    'cabosserai',
    'cabosserais',
    'cabosserait',
    'cabosseras',
    'cabosserez',
    'cabosseriez',
    'cabosserions',
    'cabosserons',
    'cabosseront',
    'cabosses',
    'cabossez',
    'cabossiez',
    'cabossions',
    'cabossons',
    'cabossâmes',
    'cabossât',
    'cabossâtes',
    'cabossèrent',
    'cabossé',
    'cabossée',
    'cabossées',
    'cabossés',
    'cabot',
    'cabota',
    'cabotage',
    'cabotages',
    'cabotai',
    'cabotaient',
    'cabotais',
    'cabotait',
    'cabotant',
    'cabotas',
    'cabotasse',
    'cabotassent',
    'cabotasses',
    'cabotassiez',
    'cabotassions',
    'cabote',
    'cabotent',
    'caboter',
    'cabotera',
    'caboterai',
    'caboteraient',
    'caboterais',
    'caboterait',
    'caboteras',
    'caboterez',
    'caboteriez',
    'caboterions',
    'caboterons',
    'caboteront',
    'cabotes',
    'caboteur',
    'caboteurs',
    'cabotez',
    'cabotiez',
    'cabotin',
    'cabotina',
    'cabotinage',
    'cabotinages',
    'cabotinai',
    'cabotinaient',
    'cabotinais',
    'cabotinait',
    'cabotinant',
    'cabotinas',
    'cabotinasse',
    'cabotinasses',
    'cabotine',
    'cabotinent',
    'cabotiner',
    'cabotinera',
    'cabotinerai',
    'cabotinerais',
    'cabotinerait',
    'cabotineras',
    'cabotinerez',
    'cabotineriez',
    'cabotinerons',
    'cabotineront',
    'cabotines',
    'cabotinez',
    'cabotiniez',
    'cabotinions',
    'cabotinons',
    'cabotins',
    'cabotinâmes',
    'cabotinât',
    'cabotinâtes',
    'cabotinèrent',
    'cabotiné',
    'cabotions',
    'cabotons',
    'cabots',
    'cabotâmes',
    'cabotât',
    'cabotâtes',
    'cabotèrent',
    'caboté',
    'caboulot',
    'caboulots',
    'cabra',
    'cabrai',
    'cabraient',
    'cabrais',
    'cabrait',
    'cabrant',
    'cabras',
    'cabrasse',
    'cabrassent',
    'cabrasses',
    'cabrassiez',
    'cabrassions',
    'cabre',
    'cabrent',
    'cabrer',
    'cabrera',
    'cabrerai',
    'cabreraient',
    'cabrerais',
    'cabrerait',
    'cabreras',
    'cabrerez',
    'cabreriez',
    'cabrerions',
    'cabrerons',
    'cabreront',
    'cabres',
    'cabrez',
    'cabri',
    'cabriez',
    'cabriola',
    'cabriolai',
    'cabriolaient',
    'cabriolais',
    'cabriolait',
    'cabriolant',
    'cabriolas',
    'cabriolasse',
    'cabriolasses',
    'cabriole',
    'cabriolent',
    'cabrioler',
    'cabriolera',
    'cabriolerai',
    'cabriolerais',
    'cabriolerait',
    'cabrioleras',
    'cabriolerez',
    'cabrioleriez',
    'cabriolerons',
    'cabrioleront',
    'cabrioles',
    'cabriolet',
    'cabriolets',
    'cabriolez',
    'cabrioliez',
    'cabriolions',
    'cabriolons',
    'cabriolâmes',
    'cabriolât',
    'cabriolâtes',
    'cabriolèrent',
    'cabriolé',
    'cabrions',
    'cabris',
    'cabrons',
    'cabrâmes',
    'cabrât',
    'cabrâtes',
    'cabrèrent',
    'cabré',
    'cabrée',
    'cabrées',
    'cabrés',
    'cabs',
    'cabus',
    'caca',
    'cacaba',
    'cacabai',
    'cacabaient',
    'cacabais',
    'cacabait',
    'cacabant',
    'cacabas',
    'cacabasse',
    'cacabassent',
    'cacabasses',
    'cacabassiez',
    'cacabassions',
    'cacabe',
    'cacabent',
    'cacaber',
    'cacabera',
    'cacaberai',
    'cacaberaient',
    'cacaberais',
    'cacaberait',
    'cacaberas',
    'cacaberez',
    'cacaberiez',
    'cacaberions',
    'cacaberons',
    'cacaberont',
    'cacabes',
    'cacabez',
    'cacabiez',
    'cacabions',
    'cacabons',
    'cacabâmes',
    'cacabât',
    'cacabâtes',
    'cacabèrent',
    'cacabé',
    'cacahouète',
    'cacahouètes',
    'cacahuète',
    'cacahuètes',
    'cacao',
    'cacaos',
    'cacaotier',
    'cacaotiers',
    'cacaotière',
    'cacaotières',
    'cacaoté',
    'cacaotée',
    'cacaotées',
    'cacaotés',
    'cacaoyer',
    'cacaoyers',
    'cacaoyère',
    'cacaoyères',
    'cacarda',
    'cacardai',
    'cacardaient',
    'cacardais',
    'cacardait',
    'cacardant',
    'cacardas',
    'cacardasse',
    'cacardassent',
    'cacardasses',
    'cacardassiez',
    'cacarde',
    'cacardent',
    'cacarder',
    'cacardera',
    'cacarderai',
    'cacarderais',
    'cacarderait',
    'cacarderas',
    'cacarderez',
    'cacarderiez',
    'cacarderions',
    'cacarderons',
    'cacarderont',
    'cacardes',
    'cacardez',
    'cacardiez',
    'cacardions',
    'cacardons',
    'cacardâmes',
    'cacardât',
    'cacardâtes',
    'cacardèrent',
    'cacardé',
    'cacas',
    'cacatois',
    'cacatoès',
    'cacha',
    'cachai',
    'cachaient',
    'cachais',
    'cachait',
    'cachalot',
    'cachalots',
    'cachant',
    'cachas',
    'cachasse',
    'cachassent',
    'cachasses',
    'cachassiez',
    'cachassions',
    'cache',
    'cachectique',
    'cachectiques',
    'cachemire',
    'cachemires',
    'cachent',
    'cacher',
    'cachera',
    'cacherai',
    'cacheraient',
    'cacherais',
    'cacherait',
    'cacheras',
    'cacherez',
    'cacheriez',
    'cacherions',
    'cacherons',
    'cacheront',
    'caches',
    'cachet',
    'cacheta',
    'cachetage',
    'cachetages',
    'cachetai',
    'cachetaient',
    'cachetais',
    'cachetait',
    'cachetant',
    'cachetas',
    'cachetasse',
    'cachetassent',
    'cachetasses',
    'cachetassiez',
    'cacheter',
    'cachetez',
    'cachetiez',
    'cachetions',
    'cachetons',
    'cachets',
    'cachette',
    'cachettent',
    'cachettera',
    'cachetterai',
    'cachetterais',
    'cachetterait',
    'cachetteras',
    'cachetterez',
    'cachetteriez',
    'cachetterons',
    'cachetteront',
    'cachettes',
    'cachetâmes',
    'cachetât',
    'cachetâtes',
    'cachetèrent',
    'cacheté',
    'cachetée',
    'cachetées',
    'cachetés',
    'cachexie',
    'cachexies',
    'cachez',
    'cachiez',
    'cachions',
    'cachons',
    'cachot',
    'cachots',
    'cachotterie',
    'cachotteries',
    'cachottier',
    'cachottiers',
    'cachottière',
    'cachottières',
    'cachou',
    'cachous',
    'cachucha',
    'cachuchas',
    'cachâmes',
    'cachât',
    'cachâtes',
    'cachèrent',
    'caché',
    'cachée',
    'cachées',
    'cachés',
    'cacique',
    'caciques',
    'cacochyme',
    'cacochymes',
    'cacodylate',
    'cacodylates',
    'cacographe',
    'cacographes',
    'cacographie',
    'cacographies',
    'cacolet',
    'cacolets',
    'cacologie',
    'cacologies',
    'cacophonie',
    'cacophonies',
    'cacophonique',
    'cactus',
    'cadancha',
    'cadanchai',
    'cadanchaient',
    'cadanchais',
    'cadanchait',
    'cadanchant',
    'cadanchas',
    'cadanchasse',
    'cadanchasses',
    'cadanche',
    'cadanchent',
    'cadancher',
    'cadanchera',
    'cadancherai',
    'cadancherais',
    'cadancherait',
    'cadancheras',
    'cadancherez',
    'cadancheriez',
    'cadancherons',
    'cadancheront',
    'cadanches',
    'cadanchez',
    'cadanchiez',
    'cadanchions',
    'cadanchons',
    'cadanchâmes',
    'cadanchât',
    'cadanchâtes',
    'cadanchèrent',
    'cadanché',
    'cadastra',
    'cadastrai',
    'cadastraient',
    'cadastrais',
    'cadastrait',
    'cadastral',
    'cadastrale',
    'cadastrales',
    'cadastrant',
    'cadastras',
    'cadastrasse',
    'cadastrasses',
    'cadastraux',
    'cadastre',
    'cadastrent',
    'cadastrer',
    'cadastrera',
    'cadastrerai',
    'cadastrerais',
    'cadastrerait',
    'cadastreras',
    'cadastrerez',
    'cadastreriez',
    'cadastrerons',
    'cadastreront',
    'cadastres',
    'cadastrez',
    'cadastriez',
    'cadastrions',
    'cadastrons',
    'cadastrâmes',
    'cadastrât',
    'cadastrâtes',
    'cadastrèrent',
    'cadastré',
    'cadastrée',
    'cadastrées',
    'cadastrés',
    'cadavre',
    'cadavres',
    'cadavéreuse',
    'cadavéreuses',
    'cadavéreux',
    'cadavérique',
    'cadavériques',
    'caddie',
    'caddies',
    'caddy',
    'cade',
    'cadeau',
    'cadeaux',
    'cadenas',
    'cadenassa',
    'cadenassai',
    'cadenassais',
    'cadenassait',
    'cadenassant',
    'cadenassas',
    'cadenassasse',
    'cadenasse',
    'cadenassent',
    'cadenasser',
    'cadenassera',
    'cadenasserai',
    'cadenasseras',
    'cadenasserez',
    'cadenasses',
    'cadenassez',
    'cadenassiez',
    'cadenassions',
    'cadenassons',
    'cadenassâmes',
    'cadenassât',
    'cadenassâtes',
    'cadenassé',
    'cadenassée',
    'cadenassées',
    'cadenassés',
    'cadence',
    'cadencent',
    'cadencer',
    'cadencera',
    'cadencerai',
    'cadencerais',
    'cadencerait',
    'cadenceras',
    'cadencerez',
    'cadenceriez',
    'cadencerions',
    'cadencerons',
    'cadenceront',
    'cadences',
    'cadencez',
    'cadenciez',
    'cadencions',
    'cadencèrent',
    'cadencé',
    'cadencée',
    'cadencées',
    'cadencés',
    'cadenette',
    'cadenettes',
    'cadença',
    'cadençai',
    'cadençaient',
    'cadençais',
    'cadençait',
    'cadençant',
    'cadenças',
    'cadençasse',
    'cadençassent',
    'cadençasses',
    'cadençassiez',
    'cadençons',
    'cadençâmes',
    'cadençât',
    'cadençâtes',
    'cades',
    'cadet',
    'cadets',
    'cadette',
    'cadettes',
    'cadi',
    'cadis',
    'cadmia',
    'cadmiage',
    'cadmiages',
    'cadmiai',
    'cadmiaient',
    'cadmiais',
    'cadmiait',
    'cadmiant',
    'cadmias',
    'cadmiasse',
    'cadmiassent',
    'cadmiasses',
    'cadmiassiez',
    'cadmiassions',
    'cadmie',
    'cadmient',
    'cadmier',
    'cadmiera',
    'cadmierai',
    'cadmieraient',
    'cadmierais',
    'cadmierait',
    'cadmieras',
    'cadmierez',
    'cadmieriez',
    'cadmierions',
    'cadmierons',
    'cadmieront',
    'cadmies',
    'cadmiez',
    'cadmiiez',
    'cadmiions',
    'cadmions',
    'cadmium',
    'cadmiums',
    'cadmiâmes',
    'cadmiât',
    'cadmiâtes',
    'cadmièrent',
    'cadmié',
    'cadmiée',
    'cadmiées',
    'cadmiés',
    'cadogan',
    'cadogans',
    'cadra',
    'cadrage',
    'cadrages',
    'cadrai',
    'cadraient',
    'cadrais',
    'cadrait',
    'cadran',
    'cadrans',
    'cadrant',
    'cadrante',
    'cadrantes',
    'cadrants',
    'cadras',
    'cadrasse',
    'cadrassent',
    'cadrasses',
    'cadrassiez',
    'cadrassions',
    'cadrat',
    'cadrats',
    'cadrature',
    'cadratures',
    'cadre',
    'cadrent',
    'cadrer',
    'cadrera',
    'cadrerai',
    'cadreraient',
    'cadrerais',
    'cadrerait',
    'cadreras',
    'cadrerez',
    'cadreriez',
    'cadrerions',
    'cadrerons',
    'cadreront',
    'cadres',
    'cadreur',
    'cadreurs',
    'cadreuse',
    'cadreuses',
    'cadrez',
    'cadriez',
    'cadrions',
    'cadrons',
    'cadrâmes',
    'cadrât',
    'cadrâtes',
    'cadrèrent',
    'cadré',
    'cadrée',
    'cadrées',
    'cadrés',
    'caduc',
    'caducité',
    'caducités',
    'caducs',
    'caducée',
    'caducées',
    'caduque',
    'caduques',
    'caecal',
    'caecale',
    'caecales',
    'caecaux',
    'caecum',
    'caecums',
    'caesium',
    'caesiums',
    'caetera',
    'cafard',
    'cafarda',
    'cafardage',
    'cafardages',
    'cafardai',
    'cafardaient',
    'cafardais',
    'cafardait',
    'cafardant',
    'cafardas',
    'cafardasse',
    'cafardassent',
    'cafardasses',
    'cafardassiez',
    'cafarde',
    'cafardent',
    'cafarder',
    'cafardera',
    'cafarderai',
    'cafarderais',
    'cafarderait',
    'cafarderas',
    'cafarderez',
    'cafarderiez',
    'cafarderions',
    'cafarderons',
    'cafarderont',
    'cafardes',
    'cafardeur',
    'cafardeurs',
    'cafardeuse',
    'cafardeuses',
    'cafardeux',
    'cafardez',
    'cafardiez',
    'cafardions',
    'cafardons',
    'cafards',
    'cafardâmes',
    'cafardât',
    'cafardâtes',
    'cafardèrent',
    'cafardé',
    'cafardée',
    'cafardées',
    'cafardés',
    'cafetan',
    'cafetans',
    'cafetier',
    'cafetiers',
    'cafetière',
    'cafetières',
    'cafouilla',
    'cafouillage',
    'cafouillages',
    'cafouillai',
    'cafouillais',
    'cafouillait',
    'cafouillant',
    'cafouillas',
    'cafouillasse',
    'cafouille',
    'cafouillent',
    'cafouiller',
    'cafouillera',
    'cafouillerai',
    'cafouilleras',
    'cafouillerez',
    'cafouilles',
    'cafouillez',
    'cafouilliez',
    'cafouillions',
    'cafouillis',
    'cafouillons',
    'cafouillâmes',
    'cafouillât',
    'cafouillâtes',
    'cafouillé',
    'cafre',
    'cafres',
    'cafta',
    'caftai',
    'caftaient',
    'caftais',
    'caftait',
    'caftan',
    'caftans',
    'caftant',
    'caftas',
    'caftasse',
    'caftassent',
    'caftasses',
    'caftassiez',
    'caftassions',
    'cafte',
    'caftent',
    'cafter',
    'caftera',
    'cafterai',
    'cafteraient',
    'cafterais',
    'cafterait',
    'cafteras',
    'cafterez',
    'cafteriez',
    'cafterions',
    'cafterons',
    'cafteront',
    'caftes',
    'caftez',
    'caftiez',
    'caftions',
    'caftons',
    'caftâmes',
    'caftât',
    'caftâtes',
    'caftèrent',
    'cafté',
    'caftée',
    'caftées',
    'caftés',
    'café',
    'caféier',
    'caféiers',
    'caféine',
    'caféines',
    'caféisme',
    'caféismes',
    'caféière',
    'caféières',
    'cafés',
    'cafétéria',
    'cafétérias',
    'cage',
    'cageot',
    'cageots',
    'cagerotte',
    'cagerottes',
    'cages',
    'caget',
    'cagets',
    'cagibi',
    'cagibis',
    'cagna',
    'cagnai',
    'cagnaient',
    'cagnais',
    'cagnait',
    'cagnant',
    'cagnard',
    'cagnarda',
    'cagnardai',
    'cagnardaient',
    'cagnardais',
    'cagnardait',
    'cagnardant',
    'cagnardas',
    'cagnardasse',
    'cagnardasses',
    'cagnarde',
    'cagnardent',
    'cagnarder',
    'cagnardera',
    'cagnarderai',
    'cagnarderais',
    'cagnarderait',
    'cagnarderas',
    'cagnarderez',
    'cagnarderiez',
    'cagnarderons',
    'cagnarderont',
    'cagnardes',
    'cagnardez',
    'cagnardiez',
    'cagnardions',
    'cagnardons',
    'cagnards',
    'cagnardâmes',
    'cagnardât',
    'cagnardâtes',
    'cagnardèrent',
    'cagnardé',
    'cagnas',
    'cagnasse',
    'cagnassent',
    'cagnasses',
    'cagnassiez',
    'cagnassions',
    'cagne',
    'cagnent',
    'cagner',
    'cagnera',
    'cagnerai',
    'cagneraient',
    'cagnerais',
    'cagnerait',
    'cagneras',
    'cagnerez',
    'cagneriez',
    'cagnerions',
    'cagnerons',
    'cagneront',
    'cagnes',
    'cagneuse',
    'cagneuses',
    'cagneux',
    'cagnez',
    'cagniez',
    'cagnions',
    'cagnons',
    'cagnotte',
    'cagnottes',
    'cagnâmes',
    'cagnât',
    'cagnâtes',
    'cagnèrent',
    'cagné',
    'cagot',
    'cagote',
    'cagoterie',
    'cagoteries',
    'cagotes',
    'cagots',
    'cagoulard',
    'cagoularde',
    'cagoulardes',
    'cagoulards',
    'cagoule',
    'cagoules',
    'cahier',
    'cahiers',
    'cahot',
    'cahota',
    'cahotai',
    'cahotaient',
    'cahotais',
    'cahotait',
    'cahotant',
    'cahotante',
    'cahotantes',
    'cahotants',
    'cahotas',
    'cahotasse',
    'cahotassent',
    'cahotasses',
    'cahotassiez',
    'cahotassions',
    'cahote',
    'cahotement',
    'cahotements',
    'cahotent',
    'cahoter',
    'cahotera',
    'cahoterai',
    'cahoteraient',
    'cahoterais',
    'cahoterait',
    'cahoteras',
    'cahoterez',
    'cahoteriez',
    'cahoterions',
    'cahoterons',
    'cahoteront',
    'cahotes',
    'cahoteuse',
    'cahoteuses',
    'cahoteux',
    'cahotez',
    'cahotiez',
    'cahotions',
    'cahotons',
    'cahots',
    'cahotâmes',
    'cahotât',
    'cahotâtes',
    'cahotèrent',
    'cahoté',
    'cahotée',
    'cahotées',
    'cahotés',
    'cahute',
    'cahutes',
    'cailla',
    'caillai',
    'caillaient',
    'caillais',
    'caillait',
    'caillant',
    'caillas',
    'caillasse',
    'caillassent',
    'caillasses',
    'caillassiez',
    'caillassions',
    'caille',
    'caillebotis',
    'caillebottai',
    'caillebotte',
    'caillebotter',
    'caillebottes',
    'caillebottez',
    'caillebotté',
    'caillebottée',
    'caillebottés',
    'caillement',
    'caillements',
    'caillent',
    'cailler',
    'caillera',
    'caillerai',
    'cailleraient',
    'caillerais',
    'caillerait',
    'cailleras',
    'caillerez',
    'cailleriez',
    'caillerions',
    'caillerons',
    'cailleront',
    'cailles',
    'cailleta',
    'cailletai',
    'cailletaient',
    'cailletais',
    'cailletait',
    'cailletant',
    'cailletas',
    'cailletasse',
    'cailletasses',
    'cailleter',
    'cailletez',
    'cailletiez',
    'cailletions',
    'cailletons',
    'caillette',
    'caillettent',
    'caillettera',
    'cailletterai',
    'cailletteras',
    'cailletterez',
    'caillettes',
    'cailletâmes',
    'cailletât',
    'cailletâtes',
    'cailletèrent',
    'cailleté',
    'caillez',
    'cailliez',
    'caillions',
    'caillons',
    'caillot',
    'caillots',
    'caillou',
    'caillouta',
    'cailloutage',
    'cailloutages',
    'cailloutai',
    'cailloutais',
    'cailloutait',
    'cailloutant',
    'cailloutante',
    'cailloutants',
    'cailloutas',
    'cailloutasse',
    'cailloute',
    'cailloutent',
    'caillouter',
    'cailloutera',
    'caillouterai',
    'caillouteras',
    'caillouterez',
    'cailloutes',
    'caillouteuse',
    'caillouteux',
    'cailloutez',
    'cailloutiez',
    'cailloutions',
    'cailloutis',
    'cailloutons',
    'cailloutâmes',
    'cailloutât',
    'cailloutâtes',
    'caillouté',
    'cailloutée',
    'cailloutées',
    'cailloutés',
    'cailloux',
    'caillâmes',
    'caillât',
    'caillâtes',
    'caillèrent',
    'caillé',
    'caillée',
    'caillées',
    'caillés',
    'cairn',
    'cairns',
    'cairote',
    'cairotes',
    'caisse',
    'caisserie',
    'caisseries',
    'caisses',
    'caissette',
    'caissettes',
    'caissier',
    'caissiers',
    'caissière',
    'caissières',
    'caisson',
    'caissons',
    'cajeput',
    'cajeputier',
    'cajeputiers',
    'cajeputs',
    'cajola',
    'cajolai',
    'cajolaient',
    'cajolais',
    'cajolait',
    'cajolant',
    'cajolante',
    'cajolantes',
    'cajolants',
    'cajolas',
    'cajolasse',
    'cajolassent',
    'cajolasses',
    'cajolassiez',
    'cajolassions',
    'cajole',
    'cajolent',
    'cajoler',
    'cajolera',
    'cajolerai',
    'cajoleraient',
    'cajolerais',
    'cajolerait',
    'cajoleras',
    'cajolerez',
    'cajolerie',
    'cajoleries',
    'cajoleriez',
    'cajolerions',
    'cajolerons',
    'cajoleront',
    'cajoles',
    'cajoleur',
    'cajoleurs',
    'cajoleuse',
    'cajoleuses',
    'cajolez',
    'cajoliez',
    'cajolions',
    'cajolons',
    'cajolâmes',
    'cajolât',
    'cajolâtes',
    'cajolèrent',
    'cajolé',
    'cajolée',
    'cajolées',
    'cajolés',
    'cajou',
    'cajous',
    'cajun',
    'cajuns',
    'cake',
    'cakes',
    'cala',
    'calabrais',
    'calabraise',
    'calabraises',
    'caladium',
    'caladiums',
    'calage',
    'calages',
    'calai',
    'calaient',
    'calais',
    'calaison',
    'calaisons',
    'calait',
    'calamar',
    'calamars',
    'calambac',
    'calambacs',
    'calame',
    'calames',
    'calamina',
    'calaminage',
    'calaminages',
    'calaminai',
    'calaminaient',
    'calaminais',
    'calaminait',
    'calaminant',
    'calaminas',
    'calaminasse',
    'calaminasses',
    'calamine',
    'calaminent',
    'calaminer',
    'calaminera',
    'calaminerai',
    'calaminerais',
    'calaminerait',
    'calamineras',
    'calaminerez',
    'calamineriez',
    'calaminerons',
    'calamineront',
    'calamines',
    'calaminez',
    'calaminiez',
    'calaminions',
    'calaminons',
    'calaminâmes',
    'calaminât',
    'calaminâtes',
    'calaminèrent',
    'calaminé',
    'calaminée',
    'calaminées',
    'calaminés',
    'calamistra',
    'calamistrai',
    'calamistrais',
    'calamistrait',
    'calamistrant',
    'calamistras',
    'calamistre',
    'calamistrent',
    'calamistrer',
    'calamistrera',
    'calamistres',
    'calamistrez',
    'calamistriez',
    'calamistrons',
    'calamistrât',
    'calamistré',
    'calamistrée',
    'calamistrées',
    'calamistrés',
    'calamiteuse',
    'calamiteuses',
    'calamiteux',
    'calamité',
    'calamités',
    'calancha',
    'calanchai',
    'calanchaient',
    'calanchais',
    'calanchait',
    'calanchant',
    'calanchas',
    'calanchasse',
    'calanchasses',
    'calanche',
    'calanchent',
    'calancher',
    'calanchera',
    'calancherai',
    'calancherais',
    'calancherait',
    'calancheras',
    'calancherez',
    'calancheriez',
    'calancherons',
    'calancheront',
    'calanches',
    'calanchez',
    'calanchiez',
    'calanchions',
    'calanchons',
    'calanchâmes',
    'calanchât',
    'calanchâtes',
    'calanchèrent',
    'calanché',
    'calandra',
    'calandrage',
    'calandrages',
    'calandrai',
    'calandraient',
    'calandrais',
    'calandrait',
    'calandrant',
    'calandras',
    'calandrasse',
    'calandrasses',
    'calandre',
    'calandrent',
    'calandrer',
    'calandrera',
    'calandrerai',
    'calandrerais',
    'calandrerait',
    'calandreras',
    'calandrerez',
    'calandreriez',
    'calandrerons',
    'calandreront',
    'calandres',
    'calandreur',
    'calandreurs',
    'calandreuse',
    'calandreuses',
    'calandrez',
    'calandriez',
    'calandrions',
    'calandrons',
    'calandrâmes',
    'calandrât',
    'calandrâtes',
    'calandrèrent',
    'calandré',
    'calandrée',
    'calandrées',
    'calandrés',
    'calanque',
    'calanques',
    'calant',
    'calao',
    'calaos',
    'calas',
    'calasse',
    'calassent',
    'calasses',
    'calassiez',
    'calassions',
    'calcaire',
    'calcaires',
    'calcanéum',
    'calcanéums',
    'calcicole',
    'calcicoles',
    'calcifié',
    'calcifiée',
    'calcifiées',
    'calcifiés',
    'calcin',
    'calcina',
    'calcinai',
    'calcinaient',
    'calcinais',
    'calcinait',
    'calcinant',
    'calcinas',
    'calcinasse',
    'calcinassent',
    'calcinasses',
    'calcinassiez',
    'calcination',
    'calcinations',
    'calcine',
    'calcinent',
    'calciner',
    'calcinera',
    'calcinerai',
    'calcinerais',
    'calcinerait',
    'calcineras',
    'calcinerez',
    'calcineriez',
    'calcinerions',
    'calcinerons',
    'calcineront',
    'calcines',
    'calcinez',
    'calciniez',
    'calcinions',
    'calcinons',
    'calcins',
    'calcinâmes',
    'calcinât',
    'calcinâtes',
    'calcinèrent',
    'calciné',
    'calcinée',
    'calcinées',
    'calcinés',
    'calcique',
    'calciques',
    'calcite',
    'calcites',
    'calcium',
    'calciurie',
    'calciuries',
    'calcul',
    'calcula',
    'calculable',
    'calculables',
    'calculai',
    'calculaient',
    'calculais',
    'calculait',
    'calculant',
    'calculas',
    'calculasse',
    'calculassent',
    'calculasses',
    'calculassiez',
    'calculateur',
    'calculateurs',
    'calculatrice',
    'calcule',
    'calculent',
    'calculer',
    'calculera',
    'calculerai',
    'calculerais',
    'calculerait',
    'calculeras',
    'calculerez',
    'calculeriez',
    'calculerions',
    'calculerons',
    'calculeront',
    'calcules',
    'calculette',
    'calculettes',
    'calculeuse',
    'calculeuses',
    'calculeux',
    'calculez',
    'calculiez',
    'calculions',
    'calculons',
    'calculs',
    'calculâmes',
    'calculât',
    'calculâtes',
    'calculèrent',
    'calculé',
    'calculée',
    'calculées',
    'calculés',
    'calcédoine',
    'calcédoines',
    'calcémie',
    'calcémies',
    'calcéolaire',
    'calcéolaires',
    'caldarium',
    'caldariums',
    'caldeira',
    'caldeiras',
    'cale',
    'calebasse',
    'calebasses',
    'calebassier',
    'calebassiers',
    'calembour',
    'calembours',
    'calendes',
    'calendrier',
    'calendriers',
    'calent',
    'calepin',
    'calepins',
    'caler',
    'calera',
    'calerai',
    'caleraient',
    'calerais',
    'calerait',
    'caleras',
    'calerez',
    'caleriez',
    'calerions',
    'calerons',
    'caleront',
    'cales',
    'caleta',
    'caletai',
    'caletaient',
    'caletais',
    'caletait',
    'caletant',
    'caletas',
    'caletasse',
    'caletassent',
    'caletasses',
    'caletassiez',
    'caletassions',
    'caleter',
    'caletez',
    'caletiez',
    'caletions',
    'caletons',
    'calette',
    'calettent',
    'calettera',
    'caletterai',
    'caletterais',
    'caletterait',
    'caletteras',
    'caletterez',
    'caletteriez',
    'caletterions',
    'caletterons',
    'caletteront',
    'calettes',
    'caletâmes',
    'caletât',
    'caletâtes',
    'caletèrent',
    'caleté',
    'caletée',
    'caletées',
    'caletés',
    'calez',
    'caleçon',
    'caleçons',
    'calf',
    'calfat',
    'calfata',
    'calfatage',
    'calfatages',
    'calfatai',
    'calfataient',
    'calfatais',
    'calfatait',
    'calfatant',
    'calfatas',
    'calfatasse',
    'calfatassent',
    'calfatasses',
    'calfatassiez',
    'calfate',
    'calfatent',
    'calfater',
    'calfatera',
    'calfaterai',
    'calfaterais',
    'calfaterait',
    'calfateras',
    'calfaterez',
    'calfateriez',
    'calfaterions',
    'calfaterons',
    'calfateront',
    'calfates',
    'calfatez',
    'calfatiez',
    'calfations',
    'calfatons',
    'calfats',
    'calfatâmes',
    'calfatât',
    'calfatâtes',
    'calfatèrent',
    'calfaté',
    'calfatée',
    'calfatées',
    'calfatés',
    'calfeutra',
    'calfeutrage',
    'calfeutrages',
    'calfeutrai',
    'calfeutrais',
    'calfeutrait',
    'calfeutrant',
    'calfeutras',
    'calfeutrasse',
    'calfeutre',
    'calfeutrent',
    'calfeutrer',
    'calfeutrera',
    'calfeutrerai',
    'calfeutreras',
    'calfeutrerez',
    'calfeutres',
    'calfeutrez',
    'calfeutriez',
    'calfeutrions',
    'calfeutrons',
    'calfeutrâmes',
    'calfeutrât',
    'calfeutrâtes',
    'calfeutré',
    'calfeutrée',
    'calfeutrées',
    'calfeutrés',
    'calfs',
    'calibra',
    'calibrage',
    'calibrages',
    'calibrai',
    'calibraient',
    'calibrais',
    'calibrait',
    'calibrant',
    'calibras',
    'calibrasse',
    'calibrassent',
    'calibrasses',
    'calibrassiez',
    'calibration',
    'calibrations',
    'calibre',
    'calibrent',
    'calibrer',
    'calibrera',
    'calibrerai',
    'calibrerais',
    'calibrerait',
    'calibreras',
    'calibrerez',
    'calibreriez',
    'calibrerions',
    'calibrerons',
    'calibreront',
    'calibres',
    'calibreur',
    'calibreurs',
    'calibreuse',
    'calibreuses',
    'calibrez',
    'calibriez',
    'calibrions',
    'calibrons',
    'calibrâmes',
    'calibrât',
    'calibrâtes',
    'calibrèrent',
    'calibré',
    'calibrée',
    'calibrées',
    'calibrés',
    'calice',
    'calices',
    'calicot',
    'calicots',
    'calicule',
    'calicules',
    'calier',
    'caliers',
    'caliez',
    'califat',
    'califats',
    'calife',
    'califes',
    'californium',
    'californiums',
    'califourchon',
    'calions',
    'caliorne',
    'caliornes',
    'calisson',
    'calissons',
    'calleuse',
    'calleuses',
    'calleux',
    'calligramme',
    'calligrammes',
    'calligraphe',
    'calligraphes',
    'calligraphia',
    'calligraphie',
    'calligraphié',
    'callipyge',
    'callipyges',
    'callosité',
    'callosités',
    'calma',
    'calmai',
    'calmaient',
    'calmais',
    'calmait',
    'calmant',
    'calmante',
    'calmantes',
    'calmants',
    'calmar',
    'calmars',
    'calmas',
    'calmasse',
    'calmassent',
    'calmasses',
    'calmassiez',
    'calmassions',
    'calme',
    'calmement',
    'calment',
    'calmer',
    'calmera',
    'calmerai',
    'calmeraient',
    'calmerais',
    'calmerait',
    'calmeras',
    'calmerez',
    'calmeriez',
    'calmerions',
    'calmerons',
    'calmeront',
    'calmes',
    'calmez',
    'calmi',
    'calmiez',
    'calmions',
    'calmir',
    'calmira',
    'calmirai',
    'calmiraient',
    'calmirais',
    'calmirait',
    'calmiras',
    'calmirent',
    'calmirez',
    'calmiriez',
    'calmirions',
    'calmirons',
    'calmiront',
    'calmis',
    'calmissaient',
    'calmissais',
    'calmissait',
    'calmissant',
    'calmisse',
    'calmissent',
    'calmisses',
    'calmissez',
    'calmissiez',
    'calmissions',
    'calmissons',
    'calmit',
    'calmons',
    'calmâmes',
    'calmât',
    'calmâtes',
    'calmèrent',
    'calmé',
    'calmée',
    'calmées',
    'calmés',
    'calmîmes',
    'calmît',
    'calmîtes',
    'calo',
    'calomel',
    'calomels',
    'calomnia',
    'calomniai',
    'calomniaient',
    'calomniais',
    'calomniait',
    'calomniant',
    'calomnias',
    'calomniasse',
    'calomniasses',
    'calomniateur',
    'calomnie',
    'calomnient',
    'calomnier',
    'calomniera',
    'calomnierai',
    'calomnierais',
    'calomnierait',
    'calomnieras',
    'calomnierez',
    'calomnieriez',
    'calomnierons',
    'calomnieront',
    'calomnies',
    'calomnieuse',
    'calomnieuses',
    'calomnieux',
    'calomniez',
    'calomniiez',
    'calomniions',
    'calomnions',
    'calomniâmes',
    'calomniât',
    'calomniâtes',
    'calomnièrent',
    'calomnié',
    'calomniée',
    'calomniées',
    'calomniés',
    'calons',
    'caloporteur',
    'calorie',
    'calories',
    'calorifique',
    'calorifiques',
    'calorifuge',
    'calorifugea',
    'calorifugeai',
    'calorifugeas',
    'calorifugent',
    'calorifuger',
    'calorifugera',
    'calorifuges',
    'calorifugez',
    'calorifugeât',
    'calorifugiez',
    'calorifugé',
    'calorifugée',
    'calorifugées',
    'calorifugés',
    'calorifère',
    'calorifères',
    'calorimètre',
    'calorimètres',
    'calorimétrie',
    'calorique',
    'caloriques',
    'calorisation',
    'calos',
    'calot',
    'calotin',
    'calotins',
    'calots',
    'calotta',
    'calottai',
    'calottaient',
    'calottais',
    'calottait',
    'calottant',
    'calottas',
    'calottasse',
    'calottassent',
    'calottasses',
    'calottassiez',
    'calotte',
    'calottent',
    'calotter',
    'calottera',
    'calotterai',
    'calotterais',
    'calotterait',
    'calotteras',
    'calotterez',
    'calotteriez',
    'calotterions',
    'calotterons',
    'calotteront',
    'calottes',
    'calottez',
    'calottiez',
    'calottions',
    'calottons',
    'calottâmes',
    'calottât',
    'calottâtes',
    'calottèrent',
    'calotté',
    'calottée',
    'calottées',
    'calottés',
    'caloyer',
    'caloyers',
    'caloyère',
    'caloyères',
    'calqua',
    'calquage',
    'calquages',
    'calquai',
    'calquaient',
    'calquais',
    'calquait',
    'calquant',
    'calquas',
    'calquasse',
    'calquassent',
    'calquasses',
    'calquassiez',
    'calquassions',
    'calque',
    'calquent',
    'calquer',
    'calquera',
    'calquerai',
    'calqueraient',
    'calquerais',
    'calquerait',
    'calqueras',
    'calquerez',
    'calqueriez',
    'calquerions',
    'calquerons',
    'calqueront',
    'calques',
    'calquez',
    'calquiez',
    'calquions',
    'calquons',
    'calquâmes',
    'calquât',
    'calquâtes',
    'calquèrent',
    'calqué',
    'calquée',
    'calquées',
    'calqués',
    'cals',
    'calta',
    'caltai',
    'caltaient',
    'caltais',
    'caltait',
    'caltant',
    'caltas',
    'caltasse',
    'caltassent',
    'caltasses',
    'caltassiez',
    'caltassions',
    'calte',
    'caltent',
    'calter',
    'caltera',
    'calterai',
    'calteraient',
    'calterais',
    'calterait',
    'calteras',
    'calterez',
    'calteriez',
    'calterions',
    'calterons',
    'calteront',
    'caltes',
    'caltez',
    'caltiez',
    'caltions',
    'caltons',
    'caltâmes',
    'caltât',
    'caltâtes',
    'caltèrent',
    'calté',
    'caltée',
    'caltées',
    'caltés',
    'calumet',
    'calumets',
    'calva',
    'calvados',
    'calvaire',
    'calvaires',
    'calvas',
    'calville',
    'calvilles',
    'calvinisme',
    'calviniste',
    'calvinistes',
    'calvitie',
    'calvities',
    'calypso',
    'calypsos',
    'calâmes',
    'calât',
    'calâtes',
    'calèche',
    'calèches',
    'calèrent',
    'calé',
    'calédonien',
    'calédonienne',
    'calédoniens',
    'calée',
    'calées',
    'caléidoscope',
    'calés',
    'camail',
    'camails',
    'camaldule',
    'camaldules',
    'camarade',
    'camaraderie',
    'camaraderies',
    'camarades',
    'camard',
    'camarde',
    'camardes',
    'camards',
    'camarilla',
    'camarillas',
    'camaïeu',
    'camaïeux',
    'cambial',
    'cambiale',
    'cambiales',
    'cambiaux',
    'cambiste',
    'cambistes',
    'cambium',
    'cambodgien',
    'cambodgienne',
    'cambodgiens',
    'cambouis',
    'cambra',
    'cambrage',
    'cambrages',
    'cambrai',
    'cambraient',
    'cambrais',
    'cambrait',
    'cambrant',
    'cambras',
    'cambrasse',
    'cambrassent',
    'cambrasses',
    'cambrassiez',
    'cambrassions',
    'cambre',
    'cambrement',
    'cambrements',
    'cambrent',
    'cambrer',
    'cambrera',
    'cambrerai',
    'cambreraient',
    'cambrerais',
    'cambrerait',
    'cambreras',
    'cambrerez',
    'cambreriez',
    'cambrerions',
    'cambrerons',
    'cambreront',
    'cambres',
    'cambrez',
    'cambrien',
    'cambrienne',
    'cambriennes',
    'cambriens',
    'cambriez',
    'cambriola',
    'cambriolage',
    'cambriolages',
    'cambriolai',
    'cambriolais',
    'cambriolait',
    'cambriolant',
    'cambriolas',
    'cambriolasse',
    'cambriole',
    'cambriolent',
    'cambrioler',
    'cambriolera',
    'cambriolerai',
    'cambrioleras',
    'cambriolerez',
    'cambrioles',
    'cambrioleur',
    'cambrioleurs',
    'cambrioleuse',
    'cambriolez',
    'cambrioliez',
    'cambriolions',
    'cambriolons',
    'cambriolâmes',
    'cambriolât',
    'cambriolâtes',
    'cambriolé',
    'cambriolée',
    'cambriolées',
    'cambriolés',
    'cambrions',
    'cambrons',
    'cambrousard',
    'cambrousards',
    'cambrousse',
    'cambrousses',
    'cambrure',
    'cambrures',
    'cambrâmes',
    'cambrât',
    'cambrâtes',
    'cambrèrent',
    'cambré',
    'cambrée',
    'cambrées',
    'cambrés',
    'cambuse',
    'cambuses',
    'cambusier',
    'cambusiers',
    'cambuta',
    'cambutai',
    'cambutaient',
    'cambutais',
    'cambutait',
    'cambutant',
    'cambutas',
    'cambutasse',
    'cambutassent',
    'cambutasses',
    'cambutassiez',
    'cambute',
    'cambutent',
    'cambuter',
    'cambutera',
    'cambuterai',
    'cambuterais',
    'cambuterait',
    'cambuteras',
    'cambuterez',
    'cambuteriez',
    'cambuterions',
    'cambuterons',
    'cambuteront',
    'cambutes',
    'cambutez',
    'cambutiez',
    'cambutions',
    'cambutons',
    'cambutâmes',
    'cambutât',
    'cambutâtes',
    'cambutèrent',
    'cambuté',
    'cambutée',
    'cambutées',
    'cambutés',
    'came',
    'cameline',
    'camelines',
    'camelle',
    'camelles',
    'camelot',
    'camelota',
    'camelotai',
    'camelotaient',
    'camelotais',
    'camelotait',
    'camelotant',
    'camelotas',
    'camelotasse',
    'camelotasses',
    'camelote',
    'camelotent',
    'cameloter',
    'camelotera',
    'cameloterai',
    'cameloterais',
    'cameloterait',
    'cameloteras',
    'cameloterez',
    'cameloteriez',
    'cameloterons',
    'cameloteront',
    'camelotes',
    'camelotez',
    'camelotiez',
    'camelotions',
    'camelotons',
    'camelots',
    'camelotâmes',
    'camelotât',
    'camelotâtes',
    'camelotèrent',
    'cameloté',
    'camembert',
    'camemberts',
    'camer',
    'cameraman',
    'cameramen',
    'camerlingue',
    'camerlingues',
    'cames',
    'camion',
    'camionna',
    'camionnage',
    'camionnages',
    'camionnai',
    'camionnaient',
    'camionnais',
    'camionnait',
    'camionnant',
    'camionnas',
    'camionnasse',
    'camionnasses',
    'camionne',
    'camionnent',
    'camionner',
    'camionnera',
    'camionnerai',
    'camionnerais',
    'camionnerait',
    'camionneras',
    'camionnerez',
    'camionneriez',
    'camionnerons',
    'camionneront',
    'camionnes',
    'camionnette',
    'camionnettes',
    'camionneur',
    'camionneurs',
    'camionnez',
    'camionniez',
    'camionnions',
    'camionnons',
    'camionnâmes',
    'camionnât',
    'camionnâtes',
    'camionnèrent',
    'camionné',
    'camionnée',
    'camionnées',
    'camionnés',
    'camions',
    'camisard',
    'camisards',
    'camisole',
    'camisoles',
    'camomille',
    'camomilles',
    'camoufla',
    'camouflage',
    'camouflages',
    'camouflai',
    'camouflaient',
    'camouflais',
    'camouflait',
    'camouflant',
    'camouflante',
    'camouflantes',
    'camouflants',
    'camouflas',
    'camouflasse',
    'camouflasses',
    'camoufle',
    'camouflent',
    'camoufler',
    'camouflera',
    'camouflerai',
    'camouflerais',
    'camouflerait',
    'camoufleras',
    'camouflerez',
    'camoufleriez',
    'camouflerons',
    'camoufleront',
    'camoufles',
    'camouflet',
    'camouflets',
    'camouflez',
    'camoufliez',
    'camouflions',
    'camouflons',
    'camouflâmes',
    'camouflât',
    'camouflâtes',
    'camouflèrent',
    'camouflé',
    'camouflée',
    'camouflées',
    'camouflés',
    'camp',
    'campa',
    'campagnard',
    'campagnarde',
    'campagnardes',
    'campagnards',
    'campagne',
    'campagnes',
    'campagnol',
    'campagnols',
    'campai',
    'campaient',
    'campais',
    'campait',
    'campane',
    'campanes',
    'campanile',
    'campaniles',
    'campant',
    'campanule',
    'campanules',
    'campas',
    'campasse',
    'campassent',
    'campasses',
    'campassiez',
    'campassions',
    'campe',
    'campement',
    'campements',
    'campent',
    'camper',
    'campera',
    'camperai',
    'camperaient',
    'camperais',
    'camperait',
    'camperas',
    'camperez',
    'camperiez',
    'camperions',
    'camperons',
    'camperont',
    'campes',
    'campeur',
    'campeurs',
    'campeuse',
    'campeuses',
    'campez',
    'camphre',
    'camphres',
    'camphrier',
    'camphriers',
    'camphré',
    'camphrée',
    'camphrées',
    'camphrés',
    'campiez',
    'camping',
    'campings',
    'campions',
    'campons',
    'campos',
    'camps',
    'campus',
    'campâmes',
    'campât',
    'campâtes',
    'campèrent',
    'campé',
    'campée',
    'campées',
    'campés',
    'campêche',
    'campêches',
    'camus',
    'camée',
    'camées',
    'camélia',
    'camélias',
    'caméline',
    'camélines',
    'caméléon',
    'caméléons',
    'caméra',
    'caméras',
    'camérier',
    'camériers',
    'camériste',
    'caméristes',
    'cana',
    'canada',
    'canadianisme',
    'canadien',
    'canadienne',
    'canadiennes',
    'canadiens',
    'canai',
    'canaient',
    'canaille',
    'canaillerie',
    'canailleries',
    'canailles',
    'canais',
    'canait',
    'canal',
    'canalicule',
    'canalicules',
    'canalisa',
    'canalisable',
    'canalisables',
    'canalisai',
    'canalisaient',
    'canalisais',
    'canalisait',
    'canalisant',
    'canalisas',
    'canalisasse',
    'canalisasses',
    'canalisation',
    'canalise',
    'canalisent',
    'canaliser',
    'canalisera',
    'canaliserai',
    'canaliserais',
    'canaliserait',
    'canaliseras',
    'canaliserez',
    'canaliseriez',
    'canaliserons',
    'canaliseront',
    'canalises',
    'canalisez',
    'canalisiez',
    'canalisions',
    'canalisons',
    'canalisâmes',
    'canalisât',
    'canalisâtes',
    'canalisèrent',
    'canalisé',
    'canalisée',
    'canalisées',
    'canalisés',
    'canant',
    'cananéen',
    'cananéenne',
    'cananéennes',
    'cananéens',
    'canapé',
    'canapés',
    'canard',
    'canarda',
    'canardai',
    'canardaient',
    'canardais',
    'canardait',
    'canardant',
    'canardas',
    'canardasse',
    'canardassent',
    'canardasses',
    'canardassiez',
    'canarde',
    'canardeau',
    'canardeaus',
    'canardent',
    'canarder',
    'canardera',
    'canarderai',
    'canarderais',
    'canarderait',
    'canarderas',
    'canarderez',
    'canarderiez',
    'canarderions',
    'canarderons',
    'canarderont',
    'canardes',
    'canardez',
    'canardiez',
    'canardions',
    'canardière',
    'canardières',
    'canardons',
    'canards',
    'canardâmes',
    'canardât',
    'canardâtes',
    'canardèrent',
    'canardé',
    'canardée',
    'canardées',
    'canardés',
    'canari',
    'canaris',
    'canas',
    'canasse',
    'canassent',
    'canasses',
    'canassiez',
    'canassions',
    'canasson',
    'canassons',
    'canasta',
    'canaux',
    'cancale',
    'cancales',
    'cancan',
    'cancana',
    'cancanai',
    'cancanaient',
    'cancanais',
    'cancanait',
    'cancanant',
    'cancanas',
    'cancanasse',
    'cancanassent',
    'cancanasses',
    'cancanassiez',
    'cancane',
    'cancanent',
    'cancaner',
    'cancanera',
    'cancanerai',
    'cancanerais',
    'cancanerait',
    'cancaneras',
    'cancanerez',
    'cancaneriez',
    'cancanerions',
    'cancanerons',
    'cancaneront',
    'cancanes',
    'cancanez',
    'cancanier',
    'cancaniers',
    'cancaniez',
    'cancanions',
    'cancanière',
    'cancanières',
    'cancanons',
    'cancans',
    'cancanâmes',
    'cancanât',
    'cancanâtes',
    'cancanèrent',
    'cancané',
    'cancel',
    'cancels',
    'cancer',
    'cancers',
    'canche',
    'canches',
    'cancre',
    'cancrelat',
    'cancrelats',
    'cancres',
    'cancéreuse',
    'cancéreuses',
    'cancéreux',
    'cancérigène',
    'cancérigènes',
    'cancériser',
    'cancérologie',
    'cancérologue',
    'candela',
    'candelas',
    'candeur',
    'candeurs',
    'candi',
    'candidat',
    'candidate',
    'candidates',
    'candidats',
    'candidature',
    'candidatures',
    'candide',
    'candidement',
    'candides',
    'candie',
    'candies',
    'candir',
    'candira',
    'candirai',
    'candiraient',
    'candirais',
    'candirait',
    'candiras',
    'candirent',
    'candirez',
    'candiriez',
    'candirions',
    'candirons',
    'candiront',
    'candis',
    'candissaient',
    'candissais',
    'candissait',
    'candissant',
    'candisse',
    'candissent',
    'candisses',
    'candissez',
    'candissiez',
    'candissions',
    'candissons',
    'candit',
    'candélabre',
    'candélabres',
    'candîmes',
    'candît',
    'candîtes',
    'cane',
    'canent',
    'canepetière',
    'canepetières',
    'caner',
    'canera',
    'canerai',
    'caneraient',
    'canerais',
    'canerait',
    'caneras',
    'canerez',
    'caneriez',
    'canerions',
    'canerons',
    'caneront',
    'canes',
    'caneton',
    'canetons',
    'canette',
    'canettes',
    'canevas',
    'canez',
    'cangue',
    'cangues',
    'caniche',
    'caniches',
    'caniculaire',
    'caniculaires',
    'canicule',
    'canicules',
    'caniez',
    'canif',
    'canifs',
    'canin',
    'canine',
    'canines',
    'canins',
    'canions',
    'canisse',
    'canisses',
    'canitie',
    'canities',
    'caniveau',
    'caniveaux',
    'canna',
    'cannabis',
    'cannage',
    'cannages',
    'cannai',
    'cannaient',
    'cannais',
    'cannait',
    'cannant',
    'cannas',
    'cannasse',
    'cannassent',
    'cannasses',
    'cannassiez',
    'cannassions',
    'canne',
    'cannela',
    'cannelai',
    'cannelaient',
    'cannelais',
    'cannelait',
    'cannelant',
    'cannelas',
    'cannelasse',
    'cannelassent',
    'cannelasses',
    'cannelassiez',
    'canneler',
    'cannelez',
    'cannelier',
    'canneliers',
    'canneliez',
    'cannelions',
    'cannelle',
    'cannellent',
    'cannellera',
    'cannellerai',
    'cannellerais',
    'cannellerait',
    'cannelleras',
    'cannellerez',
    'cannelleriez',
    'cannellerons',
    'cannelleront',
    'cannelles',
    'cannelloni',
    'cannellonis',
    'cannelons',
    'cannelure',
    'cannelures',
    'cannelâmes',
    'cannelât',
    'cannelâtes',
    'cannelèrent',
    'cannelé',
    'cannelée',
    'cannelées',
    'cannelés',
    'cannent',
    'canner',
    'cannera',
    'cannerai',
    'canneraient',
    'cannerais',
    'cannerait',
    'canneras',
    'cannerez',
    'canneriez',
    'cannerions',
    'cannerons',
    'canneront',
    'cannes',
    'cannetille',
    'cannetilles',
    'canneur',
    'canneurs',
    'canneuse',
    'canneuses',
    'cannez',
    'cannibale',
    'cannibales',
    'cannibalisme',
    'canniez',
    'cannions',
    'cannisse',
    'cannisses',
    'cannons',
    'cannâmes',
    'cannât',
    'cannâtes',
    'cannèrent',
    'canné',
    'cannée',
    'cannées',
    'cannés',
    'canon',
    'canonial',
    'canoniale',
    'canoniales',
    'canoniaux',
    'canonicat',
    'canonicats',
    'canonique',
    'canoniques',
    'canonisa',
    'canonisable',
    'canonisables',
    'canonisai',
    'canonisaient',
    'canonisais',
    'canonisait',
    'canonisant',
    'canonisas',
    'canonisasse',
    'canonisasses',
    'canonisation',
    'canonise',
    'canonisent',
    'canoniser',
    'canonisera',
    'canoniserai',
    'canoniserais',
    'canoniserait',
    'canoniseras',
    'canoniserez',
    'canoniseriez',
    'canoniserons',
    'canoniseront',
    'canonises',
    'canonisez',
    'canonisiez',
    'canonisions',
    'canonisons',
    'canoniste',
    'canonistes',
    'canonisâmes',
    'canonisât',
    'canonisâtes',
    'canonisèrent',
    'canonisé',
    'canonisée',
    'canonisées',
    'canonisés',
    'canonna',
    'canonnade',
    'canonnades',
    'canonnage',
    'canonnages',
    'canonnai',
    'canonnaient',
    'canonnais',
    'canonnait',
    'canonnant',
    'canonnas',
    'canonnasse',
    'canonnassent',
    'canonnasses',
    'canonnassiez',
    'canonne',
    'canonnent',
    'canonner',
    'canonnera',
    'canonnerai',
    'canonnerais',
    'canonnerait',
    'canonneras',
    'canonnerez',
    'canonneriez',
    'canonnerions',
    'canonnerons',
    'canonneront',
    'canonnes',
    'canonnez',
    'canonnier',
    'canonniers',
    'canonniez',
    'canonnions',
    'canonnière',
    'canonnières',
    'canonnons',
    'canonnâmes',
    'canonnât',
    'canonnâtes',
    'canonnèrent',
    'canonné',
    'canonnée',
    'canonnées',
    'canonnés',
    'canons',
    'canope',
    'canopes',
    'canot',
    'canota',
    'canotage',
    'canotages',
    'canotai',
    'canotaient',
    'canotais',
    'canotait',
    'canotant',
    'canotas',
    'canotasse',
    'canotassent',
    'canotasses',
    'canotassiez',
    'canotassions',
    'canote',
    'canotent',
    'canoter',
    'canotera',
    'canoterai',
    'canoteraient',
    'canoterais',
    'canoterait',
    'canoteras',
    'canoterez',
    'canoteriez',
    'canoterions',
    'canoterons',
    'canoteront',
    'canotes',
    'canoteur',
    'canoteurs',
    'canoteuse',
    'canoteuses',
    'canotez',
    'canotier',
    'canotiers',
    'canotiez',
    'canotions',
    'canotons',
    'canots',
    'canotâmes',
    'canotât',
    'canotâtes',
    'canotèrent',
    'canoté',
    'canoéiste',
    'canoéistes',
    'canoë',
    'canoës',
    'cantabile',
    'cantal',
    'cantaloup',
    'cantaloups',
    'cantals',
    'cantate',
    'cantates',
    'cantatrice',
    'cantatrices',
    'canter',
    'canters',
    'cantharide',
    'cantharides',
    'cantharidine',
    'cantilever',
    'cantilevers',
    'cantilène',
    'cantilènes',
    'cantine',
    'cantiner',
    'cantines',
    'cantinier',
    'cantiniers',
    'cantinière',
    'cantinières',
    'cantique',
    'cantiques',
    'canton',
    'cantonade',
    'cantonal',
    'cantonale',
    'cantonales',
    'cantonaux',
    'cantonna',
    'cantonnai',
    'cantonnaient',
    'cantonnais',
    'cantonnait',
    'cantonnant',
    'cantonnas',
    'cantonnasse',
    'cantonnasses',
    'cantonne',
    'cantonnement',
    'cantonnent',
    'cantonner',
    'cantonnera',
    'cantonnerai',
    'cantonnerais',
    'cantonnerait',
    'cantonneras',
    'cantonnerez',
    'cantonneriez',
    'cantonnerons',
    'cantonneront',
    'cantonnes',
    'cantonnez',
    'cantonnier',
    'cantonniers',
    'cantonniez',
    'cantonnions',
    'cantonnière',
    'cantonnières',
    'cantonnons',
    'cantonnâmes',
    'cantonnât',
    'cantonnâtes',
    'cantonnèrent',
    'cantonné',
    'cantonnée',
    'cantonnées',
    'cantonnés',
    'cantons',
    'cantre',
    'cantres',
    'canula',
    'canulai',
    'canulaient',
    'canulais',
    'canulait',
    'canulant',
    'canular',
    'canularesque',
    'canulars',
    'canulas',
    'canulasse',
    'canulassent',
    'canulasses',
    'canulassiez',
    'canulassions',
    'canule',
    'canulent',
    'canuler',
    'canulera',
    'canulerai',
    'canuleraient',
    'canulerais',
    'canulerait',
    'canuleras',
    'canulerez',
    'canuleriez',
    'canulerions',
    'canulerons',
    'canuleront',
    'canules',
    'canulez',
    'canuliez',
    'canulions',
    'canulons',
    'canulâmes',
    'canulât',
    'canulâtes',
    'canulèrent',
    'canulé',
    'canulée',
    'canulées',
    'canulés',
    'canut',
    'canuts',
    'canutuse',
    'canutuses',
    'canyon',
    'canyons',
    'canzone',
    'canzones',
    'canâmes',
    'canât',
    'canâtes',
    'canèrent',
    'cané',
    'canéphore',
    'canéphores',
    'caoua',
    'caouas',
    'caoutchouc',
    'caoutchoucs',
    'caoutchouta',
    'caoutchoutai',
    'caoutchoutas',
    'caoutchoute',
    'caoutchouter',
    'caoutchoutes',
    'caoutchoutez',
    'caoutchoutât',
    'caoutchouté',
    'caoutchoutée',
    'caoutchoutés',
    'capable',
    'capables',
    'capacité',
    'capacités',
    'caparaçon',
    'caparaçonna',
    'caparaçonnai',
    'caparaçonnas',
    'caparaçonne',
    'caparaçonner',
    'caparaçonnes',
    'caparaçonnez',
    'caparaçonnât',
    'caparaçonné',
    'caparaçonnée',
    'caparaçonnés',
    'caparaçons',
    'cape',
    'capela',
    'capelage',
    'capelages',
    'capelai',
    'capelaient',
    'capelais',
    'capelait',
    'capelan',
    'capelans',
    'capelant',
    'capelas',
    'capelasse',
    'capelassent',
    'capelasses',
    'capelassiez',
    'capelassions',
    'capeler',
    'capelet',
    'capelets',
    'capelez',
    'capeliez',
    'capeline',
    'capelines',
    'capelions',
    'capelle',
    'capellent',
    'capellera',
    'capellerai',
    'capellerais',
    'capellerait',
    'capelleras',
    'capellerez',
    'capelleriez',
    'capellerions',
    'capellerons',
    'capelleront',
    'capelles',
    'capelons',
    'capelâmes',
    'capelât',
    'capelâtes',
    'capelèrent',
    'capelé',
    'capelée',
    'capelées',
    'capelés',
    'caper',
    'capes',
    'capeya',
    'capeyai',
    'capeyaient',
    'capeyais',
    'capeyait',
    'capeyant',
    'capeyas',
    'capeyasse',
    'capeyassent',
    'capeyasses',
    'capeyassiez',
    'capeyassions',
    'capeye',
    'capeyent',
    'capeyer',
    'capeyera',
    'capeyerai',
    'capeyeraient',
    'capeyerais',
    'capeyerait',
    'capeyeras',
    'capeyerez',
    'capeyeriez',
    'capeyerions',
    'capeyerons',
    'capeyeront',
    'capeyes',
    'capeyez',
    'capeyiez',
    'capeyions',
    'capeyons',
    'capeyâmes',
    'capeyât',
    'capeyâtes',
    'capeyèrent',
    'capeyé',
    'capharnaüm',
    'capharnaüms',
    'capillaire',
    'capillaires',
    'capillarite',
    'capillarites',
    'capillarité',
    'capillarités',
    'capilotade',
    'capilotades',
    'capiston',
    'capistons',
    'capitaine',
    'capitainerie',
    'capitaines',
    'capital',
    'capitale',
    'capitales',
    'capitalisa',
    'capitalisai',
    'capitalisais',
    'capitalisait',
    'capitalisant',
    'capitalisas',
    'capitalise',
    'capitalisent',
    'capitaliser',
    'capitalisera',
    'capitalises',
    'capitalisez',
    'capitalisiez',
    'capitalisme',
    'capitalismes',
    'capitalisons',
    'capitaliste',
    'capitalistes',
    'capitalisât',
    'capitalisé',
    'capitalisée',
    'capitalisées',
    'capitalisés',
    'capitaux',
    'capiteuse',
    'capiteuses',
    'capiteux',
    'capitole',
    'capitoles',
    'capitolin',
    'capitoline',
    'capitolines',
    'capitolins',
    'capiton',
    'capitonna',
    'capitonnage',
    'capitonnages',
    'capitonnai',
    'capitonnais',
    'capitonnait',
    'capitonnant',
    'capitonnas',
    'capitonnasse',
    'capitonne',
    'capitonnent',
    'capitonner',
    'capitonnera',
    'capitonnerai',
    'capitonneras',
    'capitonnerez',
    'capitonnes',
    'capitonnez',
    'capitonniez',
    'capitonnions',
    'capitonnons',
    'capitonnâmes',
    'capitonnât',
    'capitonnâtes',
    'capitonné',
    'capitonnée',
    'capitonnées',
    'capitonnés',
    'capitons',
    'capitoul',
    'capitouls',
    'capitula',
    'capitulai',
    'capitulaient',
    'capitulaire',
    'capitulaires',
    'capitulais',
    'capitulait',
    'capitulant',
    'capitulard',
    'capitularde',
    'capitulardes',
    'capitulards',
    'capitulas',
    'capitulasse',
    'capitulasses',
    'capitulation',
    'capitule',
    'capitulent',
    'capituler',
    'capitulera',
    'capitulerai',
    'capitulerais',
    'capitulerait',
    'capituleras',
    'capitulerez',
    'capituleriez',
    'capitulerons',
    'capituleront',
    'capitules',
    'capitulez',
    'capituliez',
    'capitulions',
    'capitulons',
    'capitulâmes',
    'capitulât',
    'capitulâtes',
    'capitulèrent',
    'capitulé',
    'capité',
    'capitée',
    'capitées',
    'capités',
    'capon',
    'caponna',
    'caponnai',
    'caponnaient',
    'caponnais',
    'caponnait',
    'caponnant',
    'caponnas',
    'caponnasse',
    'caponnassent',
    'caponnasses',
    'caponnassiez',
    'caponne',
    'caponnent',
    'caponner',
    'caponnera',
    'caponnerai',
    'caponnerais',
    'caponnerait',
    'caponneras',
    'caponnerez',
    'caponneriez',
    'caponnerions',
    'caponnerons',
    'caponneront',
    'caponnes',
    'caponnez',
    'caponniez',
    'caponnions',
    'caponnière',
    'caponnières',
    'caponnons',
    'caponnâmes',
    'caponnât',
    'caponnâtes',
    'caponnèrent',
    'caponné',
    'capons',
    'caporal',
    'caporalisa',
    'caporalisai',
    'caporalisais',
    'caporalisait',
    'caporalisant',
    'caporalisas',
    'caporalise',
    'caporalisent',
    'caporaliser',
    'caporalisera',
    'caporalises',
    'caporalisez',
    'caporalisiez',
    'caporalisme',
    'caporalismes',
    'caporalisons',
    'caporalisât',
    'caporalisé',
    'caporalisée',
    'caporalisées',
    'caporalisés',
    'caporaux',
    'capot',
    'capota',
    'capotage',
    'capotages',
    'capotai',
    'capotaient',
    'capotais',
    'capotait',
    'capotant',
    'capotas',
    'capotasse',
    'capotassent',
    'capotasses',
    'capotassiez',
    'capotassions',
    'capote',
    'capotent',
    'capoter',
    'capotera',
    'capoterai',
    'capoteraient',
    'capoterais',
    'capoterait',
    'capoteras',
    'capoterez',
    'capoteriez',
    'capoterions',
    'capoterons',
    'capoteront',
    'capotes',
    'capotez',
    'capotiez',
    'capotions',
    'capotons',
    'capots',
    'capotâmes',
    'capotât',
    'capotâtes',
    'capotèrent',
    'capoté',
    'capotée',
    'capotées',
    'capotés',
    'cappa',
    'cappas',
    'capricant',
    'capricante',
    'capricantes',
    'capricants',
    'capriccio',
    'capriccios',
    'caprice',
    'caprices',
    'capricieuse',
    'capricieuses',
    'capricieux',
    'capricorne',
    'capricornes',
    'caprin',
    'caprine',
    'caprines',
    'caprins',
    'capron',
    'caprons',
    'caprylique',
    'capryliques',
    'caps',
    'capselle',
    'capselles',
    'capside',
    'capsides',
    'capsula',
    'capsulage',
    'capsulages',
    'capsulai',
    'capsulaient',
    'capsulaire',
    'capsulaires',
    'capsulais',
    'capsulait',
    'capsulant',
    'capsulas',
    'capsulasse',
    'capsulassent',
    'capsulasses',
    'capsulassiez',
    'capsule',
    'capsulent',
    'capsuler',
    'capsulera',
    'capsulerai',
    'capsulerais',
    'capsulerait',
    'capsuleras',
    'capsulerez',
    'capsuleriez',
    'capsulerions',
    'capsulerons',
    'capsuleront',
    'capsules',
    'capsulez',
    'capsuliez',
    'capsulions',
    'capsulons',
    'capsulâmes',
    'capsulât',
    'capsulâtes',
    'capsulèrent',
    'capsulé',
    'capsulée',
    'capsulées',
    'capsulés',
    'capta',
    'captage',
    'captages',
    'captai',
    'captaient',
    'captais',
    'captait',
    'captal',
    'captals',
    'captant',
    'captas',
    'captasse',
    'captassent',
    'captasses',
    'captassiez',
    'captassions',
    'captateur',
    'captateurs',
    'captatif',
    'captatifs',
    'captation',
    'captations',
    'captative',
    'captatives',
    'captativité',
    'captativités',
    'captatoire',
    'captatoires',
    'captatrice',
    'captatrices',
    'capte',
    'captent',
    'capter',
    'captera',
    'capterai',
    'capteraient',
    'capterais',
    'capterait',
    'capteras',
    'capterez',
    'capteriez',
    'capterions',
    'capterons',
    'capteront',
    'captes',
    'capteur',
    'capteurs',
    'captez',
    'captieuse',
    'captieuses',
    'captieux',
    'captiez',
    'captif',
    'captifs',
    'captions',
    'captiva',
    'captivai',
    'captivaient',
    'captivais',
    'captivait',
    'captivant',
    'captivante',
    'captivantes',
    'captivants',
    'captivas',
    'captivasse',
    'captivassent',
    'captivasses',
    'captivassiez',
    'captive',
    'captivent',
    'captiver',
    'captivera',
    'captiverai',
    'captiverais',
    'captiverait',
    'captiveras',
    'captiverez',
    'captiveriez',
    'captiverions',
    'captiverons',
    'captiveront',
    'captives',
    'captivez',
    'captiviez',
    'captivions',
    'captivité',
    'captivités',
    'captivons',
    'captivâmes',
    'captivât',
    'captivâtes',
    'captivèrent',
    'captivé',
    'captivée',
    'captivées',
    'captivés',
    'captons',
    'captura',
    'capturai',
    'capturaient',
    'capturais',
    'capturait',
    'capturant',
    'capturas',
    'capturasse',
    'capturassent',
    'capturasses',
    'capturassiez',
    'capture',
    'capturent',
    'capturer',
    'capturera',
    'capturerai',
    'capturerais',
    'capturerait',
    'captureras',
    'capturerez',
    'captureriez',
    'capturerions',
    'capturerons',
    'captureront',
    'captures',
    'capturez',
    'capturiez',
    'capturions',
    'capturons',
    'capturâmes',
    'capturât',
    'capturâtes',
    'capturèrent',
    'capturé',
    'capturée',
    'capturées',
    'capturés',
    'captâmes',
    'captât',
    'captâtes',
    'captèrent',
    'capté',
    'captée',
    'captées',
    'captés',
    'capuce',
    'capuces',
    'capuche',
    'capuches',
    'capuchon',
    'capuchonna',
    'capuchonnai',
    'capuchonnais',
    'capuchonnait',
    'capuchonnant',
    'capuchonnas',
    'capuchonne',
    'capuchonnent',
    'capuchonner',
    'capuchonnera',
    'capuchonnes',
    'capuchonnez',
    'capuchonniez',
    'capuchonnons',
    'capuchonnât',
    'capuchonné',
    'capuchonnée',
    'capuchonnées',
    'capuchonnés',
    'capuchons',
    'capucin',
    'capucinade',
    'capucinades',
    'capucine',
    'capucines',
    'capucins',
    'capulet',
    'capulets',
    'capéa',
    'capéai',
    'capéaient',
    'capéais',
    'capéait',
    'capéant',
    'capéas',
    'capéasse',
    'capéassent',
    'capéasses',
    'capéassiez',
    'capéassions',
    'capée',
    'capéent',
    'capéer',
    'capéera',
    'capéerai',
    'capéeraient',
    'capéerais',
    'capéerait',
    'capéeras',
    'capéerez',
    'capéeriez',
    'capéerions',
    'capéerons',
    'capéeront',
    'capées',
    'capéez',
    'capéiez',
    'capéions',
    'capéons',
    'capésien',
    'capésienne',
    'capésiennes',
    'capésiens',
    'capétien',
    'capétienne',
    'capétiennes',
    'capétiens',
    'capéâmes',
    'capéât',
    'capéâtes',
    'capéèrent',
    'capéé',
    'caqua',
    'caquai',
    'caquaient',
    'caquais',
    'caquait',
    'caquant',
    'caquas',
    'caquasse',
    'caquassent',
    'caquasses',
    'caquassiez',
    'caquassions',
    'caque',
    'caquelon',
    'caquelons',
    'caquent',
    'caquer',
    'caquera',
    'caquerai',
    'caqueraient',
    'caquerais',
    'caquerait',
    'caqueras',
    'caquerez',
    'caqueriez',
    'caquerions',
    'caquerons',
    'caqueront',
    'caques',
    'caquet',
    'caqueta',
    'caquetage',
    'caquetages',
    'caquetai',
    'caquetaient',
    'caquetais',
    'caquetait',
    'caquetant',
    'caquetante',
    'caquetantes',
    'caquetants',
    'caquetas',
    'caquetasse',
    'caquetassent',
    'caquetasses',
    'caquetassiez',
    'caqueter',
    'caquetez',
    'caquetiez',
    'caquetions',
    'caquetons',
    'caquets',
    'caquette',
    'caquettent',
    'caquettera',
    'caquetterai',
    'caquetterais',
    'caquetterait',
    'caquetteras',
    'caquetterez',
    'caquetteriez',
    'caquetterons',
    'caquetteront',
    'caquettes',
    'caquetâmes',
    'caquetât',
    'caquetâtes',
    'caquetèrent',
    'caqueté',
    'caquez',
    'caquiez',
    'caquions',
    'caquons',
    'caquâmes',
    'caquât',
    'caquâtes',
    'caquèrent',
    'caquètement',
    'caquètements',
    'caqué',
    'caquée',
    'caquées',
    'caqués',
    'carabe',
    'carabes',
    'carabin',
    'carabine',
    'carabines',
    'carabinier',
    'carabiniers',
    'carabins',
    'carabiné',
    'carabinée',
    'carabinées',
    'carabinés',
    'caracal',
    'caracals',
    'caraco',
    'caracola',
    'caracolai',
    'caracolaient',
    'caracolais',
    'caracolait',
    'caracolant',
    'caracolas',
    'caracolasse',
    'caracolasses',
    'caracole',
    'caracolent',
    'caracoler',
    'caracolera',
    'caracolerai',
    'caracolerais',
    'caracolerait',
    'caracoleras',
    'caracolerez',
    'caracoleriez',
    'caracolerons',
    'caracoleront',
    'caracoles',
    'caracolez',
    'caracoliez',
    'caracolions',
    'caracolons',
    'caracolâmes',
    'caracolât',
    'caracolâtes',
    'caracolèrent',
    'caracolé',
    'caracos',
    'caractère',
    'caractères',
    'caractériel',
    'caractériels',
    'caractérisa',
    'caractérisai',
    'caractérisas',
    'caractérise',
    'caractériser',
    'caractérises',
    'caractérisez',
    'caractérisât',
    'caractérisé',
    'caractérisée',
    'caractérisés',
    'caracul',
    'caraculs',
    'carafe',
    'carafes',
    'carafon',
    'carafons',
    'carambola',
    'carambolage',
    'carambolages',
    'carambolai',
    'carambolais',
    'carambolait',
    'carambolant',
    'carambolas',
    'carambolasse',
    'carambole',
    'carambolent',
    'caramboler',
    'carambolera',
    'carambolerai',
    'caramboleras',
    'carambolerez',
    'caramboles',
    'carambolez',
    'caramboliez',
    'carambolions',
    'carambolons',
    'carambolâmes',
    'carambolât',
    'carambolâtes',
    'carambolé',
    'carambolée',
    'carambolées',
    'carambolés',
    'caramel',
    'caramels',
    'caramélisa',
    'caramélisai',
    'caramélisais',
    'caramélisait',
    'caramélisant',
    'caramélisas',
    'caramélise',
    'caramélisent',
    'caraméliser',
    'caramélisera',
    'caramélises',
    'caramélisez',
    'caramélisiez',
    'caramélisons',
    'caramélisât',
    'caramélisé',
    'caramélisée',
    'caramélisées',
    'caramélisés',
    'caramélé',
    'caramélée',
    'caramélées',
    'caramélés',
    'carapace',
    'carapaces',
    'carapata',
    'carapatai',
    'carapataient',
    'carapatais',
    'carapatait',
    'carapatant',
    'carapatas',
    'carapatasse',
    'carapatasses',
    'carapate',
    'carapatent',
    'carapater',
    'carapatera',
    'carapaterai',
    'carapaterais',
    'carapaterait',
    'carapateras',
    'carapaterez',
    'carapateriez',
    'carapaterons',
    'carapateront',
    'carapates',
    'carapatez',
    'carapatiez',
    'carapations',
    'carapatons',
    'carapatâmes',
    'carapatât',
    'carapatâtes',
    'carapatèrent',
    'carapaté',
    'carapatée',
    'carapatées',
    'carapatés',
    'carat',
    'carats',
    'caravanage',
    'caravanages',
    'caravane',
    'caravanes',
    'caravanier',
    'caravaniers',
    'caravaning',
    'caravanière',
    'caravanières',
    'caravelle',
    'caravelles',
    'caraïbe',
    'caraïbes',
    'carbonari',
    'carbonaro',
    'carbonata',
    'carbonatai',
    'carbonatais',
    'carbonatait',
    'carbonatant',
    'carbonatas',
    'carbonatasse',
    'carbonate',
    'carbonatent',
    'carbonater',
    'carbonatera',
    'carbonaterai',
    'carbonateras',
    'carbonaterez',
    'carbonates',
    'carbonatez',
    'carbonatiez',
    'carbonations',
    'carbonatons',
    'carbonatâmes',
    'carbonatât',
    'carbonatâtes',
    'carbonaté',
    'carbonatée',
    'carbonatées',
    'carbonatés',
    'carbone',
    'carbones',
    'carbonifère',
    'carbonifères',
    'carbonique',
    'carboniques',
    'carbonisa',
    'carbonisai',
    'carbonisais',
    'carbonisait',
    'carbonisant',
    'carbonisas',
    'carbonisasse',
    'carbonise',
    'carbonisent',
    'carboniser',
    'carbonisera',
    'carboniserai',
    'carboniseras',
    'carboniserez',
    'carbonises',
    'carbonisez',
    'carbonisiez',
    'carbonisions',
    'carbonisons',
    'carbonisâmes',
    'carbonisât',
    'carbonisâtes',
    'carbonisé',
    'carbonisée',
    'carbonisées',
    'carbonisés',
    'carbonnade',
    'carbonnades',
    'carbonyle',
    'carbonyles',
    'carboné',
    'carbonée',
    'carbonées',
    'carbonés',
    'carborundum',
    'carborundums',
    'carboxylase',
    'carboxylases',
    'carboxyle',
    'carboxyles',
    'carbura',
    'carburai',
    'carburaient',
    'carburais',
    'carburait',
    'carburant',
    'carburants',
    'carburas',
    'carburasse',
    'carburassent',
    'carburasses',
    'carburassiez',
    'carburateur',
    'carburateurs',
    'carburation',
    'carburations',
    'carbure',
    'carburent',
    'carburer',
    'carburera',
    'carburerai',
    'carburerais',
    'carburerait',
    'carbureras',
    'carburerez',
    'carbureriez',
    'carburerions',
    'carburerons',
    'carbureront',
    'carbures',
    'carburez',
    'carburiez',
    'carburions',
    'carburons',
    'carburâmes',
    'carburât',
    'carburâtes',
    'carburèrent',
    'carburé',
    'carburée',
    'carburées',
    'carburés',
    'carcailla',
    'carcaillai',
    'carcaillais',
    'carcaillait',
    'carcaillant',
    'carcaillas',
    'carcaillasse',
    'carcaille',
    'carcaillent',
    'carcailler',
    'carcaillera',
    'carcaillerai',
    'carcailleras',
    'carcaillerez',
    'carcailles',
    'carcaillez',
    'carcailliez',
    'carcaillions',
    'carcaillons',
    'carcaillâmes',
    'carcaillât',
    'carcaillâtes',
    'carcaillé',
    'carcajou',
    'carcajous',
    'carcan',
    'carcans',
    'carcasse',
    'carcasses',
    'carcel',
    'carcels',
    'carcinogène',
    'carcinogènes',
    'carcinologie',
    'carcinome',
    'carcinomes',
    'carcéral',
    'carcérale',
    'carcérales',
    'carcéraux',
    'carda',
    'cardage',
    'cardages',
    'cardai',
    'cardaient',
    'cardais',
    'cardait',
    'cardamine',
    'cardamines',
    'cardamome',
    'cardamomes',
    'cardan',
    'cardans',
    'cardant',
    'cardas',
    'cardasse',
    'cardassent',
    'cardasses',
    'cardassiez',
    'cardassions',
    'carde',
    'cardent',
    'carder',
    'cardera',
    'carderai',
    'carderaient',
    'carderais',
    'carderait',
    'carderas',
    'carderez',
    'carderiez',
    'carderions',
    'carderons',
    'carderont',
    'cardes',
    'cardeur',
    'cardeurs',
    'cardeuse',
    'cardeuses',
    'cardez',
    'cardia',
    'cardial',
    'cardiale',
    'cardiales',
    'cardialgie',
    'cardialgies',
    'cardiaque',
    'cardiaques',
    'cardias',
    'cardiaux',
    'cardiez',
    'cardigan',
    'cardigans',
    'cardinal',
    'cardinalat',
    'cardinalats',
    'cardinale',
    'cardinales',
    'cardinalice',
    'cardinalices',
    'cardinaux',
    'cardiogramme',
    'cardiographe',
    'cardiologie',
    'cardiologies',
    'cardiologue',
    'cardiologues',
    'cardions',
    'cardiopathie',
    'cardiotomie',
    'cardiotomies',
    'cardioïde',
    'cardioïdes',
    'cardite',
    'cardites',
    'cardon',
    'cardons',
    'cardâmes',
    'cardât',
    'cardâtes',
    'cardère',
    'cardèrent',
    'cardères',
    'cardé',
    'cardée',
    'cardées',
    'cardés',
    'carence',
    'carencent',
    'carencer',
    'carencera',
    'carencerai',
    'carencerais',
    'carencerait',
    'carenceras',
    'carencerez',
    'carenceriez',
    'carencerions',
    'carencerons',
    'carenceront',
    'carences',
    'carencez',
    'carenciez',
    'carencions',
    'carencèrent',
    'carencé',
    'carencée',
    'carencées',
    'carencés',
    'carentiel',
    'carentielle',
    'carentielles',
    'carentiels',
    'carença',
    'carençai',
    'carençaient',
    'carençais',
    'carençait',
    'carençant',
    'carenças',
    'carençasse',
    'carençassent',
    'carençasses',
    'carençassiez',
    'carençons',
    'carençâmes',
    'carençât',
    'carençâtes',
    'caressa',
    'caressai',
    'caressaient',
    'caressais',
    'caressait',
    'caressant',
    'caressante',
    'caressantes',
    'caressants',
    'caressas',
    'caressasse',
    'caressassent',
    'caressasses',
    'caressassiez',
    'caresse',
    'caressent',
    'caresser',
    'caressera',
    'caresserai',
    'caresserais',
    'caresserait',
    'caresseras',
    'caresserez',
    'caresseriez',
    'caresserions',
    'caresserons',
    'caresseront',
    'caresses',
    'caressez',
    'caressiez',
    'caressions',
    'caressons',
    'caressâmes',
    'caressât',
    'caressâtes',
    'caressèrent',
    'caressé',
    'caressée',
    'caressées',
    'caressés',
    'carex',
    'cargaison',
    'cargaisons',
    'cargo',
    'cargos',
    'cargua',
    'carguai',
    'carguaient',
    'carguais',
    'carguait',
    'carguant',
    'carguas',
    'carguasse',
    'carguassent',
    'carguasses',
    'carguassiez',
    'carguassions',
    'cargue',
    'carguent',
    'carguer',
    'carguera',
    'carguerai',
    'cargueraient',
    'carguerais',
    'carguerait',
    'cargueras',
    'carguerez',
    'cargueriez',
    'carguerions',
    'carguerons',
    'cargueront',
    'cargues',
    'carguez',
    'carguiez',
    'carguions',
    'carguons',
    'carguâmes',
    'carguât',
    'carguâtes',
    'carguèrent',
    'cargué',
    'carguée',
    'carguées',
    'cargués',
    'cari',
    'caria',
    'cariacou',
    'cariacous',
    'cariai',
    'cariaient',
    'cariais',
    'cariait',
    'cariant',
    'carias',
    'cariasse',
    'cariassent',
    'cariasses',
    'cariassiez',
    'cariassions',
    'cariatide',
    'cariatides',
    'caribou',
    'caribous',
    'caricatura',
    'caricaturai',
    'caricaturais',
    'caricaturait',
    'caricatural',
    'caricaturale',
    'caricaturant',
    'caricaturas',
    'caricaturaux',
    'caricature',
    'caricaturent',
    'caricaturer',
    'caricaturera',
    'caricatures',
    'caricaturez',
    'caricaturiez',
    'caricaturons',
    'caricaturât',
    'caricaturé',
    'caricaturée',
    'caricaturées',
    'caricaturés',
    'carie',
    'carient',
    'carier',
    'cariera',
    'carierai',
    'carieraient',
    'carierais',
    'carierait',
    'carieras',
    'carierez',
    'carieriez',
    'carierions',
    'carierons',
    'carieront',
    'caries',
    'carieuse',
    'carieuses',
    'carieux',
    'cariez',
    'cariiez',
    'cariions',
    'carillon',
    'carillonna',
    'carillonnai',
    'carillonnais',
    'carillonnait',
    'carillonnant',
    'carillonnas',
    'carillonne',
    'carillonnent',
    'carillonner',
    'carillonnera',
    'carillonnes',
    'carillonneur',
    'carillonnez',
    'carillonniez',
    'carillonnons',
    'carillonnât',
    'carillonné',
    'carillonnée',
    'carillonnées',
    'carillonnés',
    'carillons',
    'carions',
    'caris',
    'cariste',
    'caristes',
    'caritatif',
    'caritatifs',
    'caritative',
    'caritatives',
    'cariâmes',
    'cariât',
    'cariâtes',
    'carièrent',
    'carié',
    'cariée',
    'cariées',
    'cariés',
    'carlin',
    'carline',
    'carlines',
    'carlingue',
    'carlingues',
    'carlinguier',
    'carlinguiers',
    'carlins',
    'carlisme',
    'carlismes',
    'carliste',
    'carlistes',
    'carma',
    'carmagnole',
    'carmagnoles',
    'carmai',
    'carmaient',
    'carmais',
    'carmait',
    'carmant',
    'carmas',
    'carmasse',
    'carmassent',
    'carmasses',
    'carmassiez',
    'carmassions',
    'carme',
    'carmeline',
    'carmelines',
    'carment',
    'carmer',
    'carmera',
    'carmerai',
    'carmeraient',
    'carmerais',
    'carmerait',
    'carmeras',
    'carmerez',
    'carmeriez',
    'carmerions',
    'carmerons',
    'carmeront',
    'carmes',
    'carmez',
    'carmiez',
    'carmin',
    'carmina',
    'carminai',
    'carminaient',
    'carminais',
    'carminait',
    'carminant',
    'carminas',
    'carminasse',
    'carminassent',
    'carminasses',
    'carminassiez',
    'carminatif',
    'carminatifs',
    'carminative',
    'carminatives',
    'carmine',
    'carminent',
    'carminer',
    'carminera',
    'carminerai',
    'carminerais',
    'carminerait',
    'carmineras',
    'carminerez',
    'carmineriez',
    'carminerions',
    'carminerons',
    'carmineront',
    'carmines',
    'carminez',
    'carminiez',
    'carminions',
    'carminons',
    'carmins',
    'carminâmes',
    'carminât',
    'carminâtes',
    'carminèrent',
    'carminé',
    'carminée',
    'carminées',
    'carminés',
    'carmions',
    'carmons',
    'carmâmes',
    'carmât',
    'carmâtes',
    'carmèrent',
    'carmé',
    'carmée',
    'carmées',
    'carmélite',
    'carmélites',
    'carmés',
    'carnage',
    'carnages',
    'carnassier',
    'carnassiers',
    'carnassière',
    'carnassières',
    'carnation',
    'carnations',
    'carnaval',
    'carnavals',
    'carne',
    'carneau',
    'carneaux',
    'carnes',
    'carnet',
    'carnets',
    'carnier',
    'carniers',
    'carnifia',
    'carnifiai',
    'carnifiaient',
    'carnifiais',
    'carnifiait',
    'carnifiant',
    'carnifias',
    'carnifiasse',
    'carnifiasses',
    'carnifie',
    'carnifient',
    'carnifier',
    'carnifiera',
    'carnifierai',
    'carnifierais',
    'carnifierait',
    'carnifieras',
    'carnifierez',
    'carnifieriez',
    'carnifierons',
    'carnifieront',
    'carnifies',
    'carnifiez',
    'carnifiiez',
    'carnifiions',
    'carnifions',
    'carnifiâmes',
    'carnifiât',
    'carnifiâtes',
    'carnifièrent',
    'carnifié',
    'carnifiée',
    'carnifiées',
    'carnifiés',
    'carnivore',
    'carnivores',
    'carnotset',
    'carnotsets',
    'carnèle',
    'carnèles',
    'carné',
    'carnée',
    'carnées',
    'carnés',
    'carolingien',
    'carolingiens',
    'carolus',
    'caronade',
    'caronades',
    'caroncule',
    'caroncules',
    'carotide',
    'carotides',
    'carotta',
    'carottage',
    'carottages',
    'carottai',
    'carottaient',
    'carottais',
    'carottait',
    'carottant',
    'carottas',
    'carottasse',
    'carottassent',
    'carottasses',
    'carottassiez',
    'carotte',
    'carottent',
    'carotter',
    'carottera',
    'carotterai',
    'carotterais',
    'carotterait',
    'carotteras',
    'carotterez',
    'carotteriez',
    'carotterions',
    'carotterons',
    'carotteront',
    'carottes',
    'carotteur',
    'carotteurs',
    'carotteuse',
    'carotteuses',
    'carottez',
    'carottier',
    'carottiers',
    'carottiez',
    'carottions',
    'carottière',
    'carottières',
    'carottons',
    'carottâmes',
    'carottât',
    'carottâtes',
    'carottèrent',
    'carotté',
    'carottée',
    'carottées',
    'carottés',
    'carotène',
    'carotènes',
    'caroube',
    'caroubes',
    'caroubier',
    'caroubiers',
    'carpatique',
    'carpatiques',
    'carpe',
    'carpeau',
    'carpeaux',
    'carpelle',
    'carpelles',
    'carpes',
    'carpette',
    'carpettes',
    'carpien',
    'carpienne',
    'carpiennes',
    'carpiens',
    'carpillon',
    'carpillons',
    'carpocapse',
    'carpocapses',
    'carra',
    'carrai',
    'carraient',
    'carrais',
    'carrait',
    'carrant',
    'carrare',
    'carrares',
    'carras',
    'carrasse',
    'carrassent',
    'carrasses',
    'carrassiez',
    'carrassions',
    'carre',
    'carreau',
    'carreaux',
    'carrefour',
    'carrefours',
    'carrela',
    'carrelage',
    'carrelages',
    'carrelai',
    'carrelaient',
    'carrelais',
    'carrelait',
    'carrelant',
    'carrelas',
    'carrelasse',
    'carrelassent',
    'carrelasses',
    'carrelassiez',
    'carreler',
    'carrelet',
    'carrelets',
    'carreleur',
    'carreleurs',
    'carrelez',
    'carreliez',
    'carrelions',
    'carrelle',
    'carrellent',
    'carrellera',
    'carrellerai',
    'carrellerais',
    'carrellerait',
    'carrelleras',
    'carrellerez',
    'carrelleriez',
    'carrellerons',
    'carrelleront',
    'carrelles',
    'carrelons',
    'carrelâmes',
    'carrelât',
    'carrelâtes',
    'carrelèrent',
    'carrelé',
    'carrelée',
    'carrelées',
    'carrelés',
    'carrent',
    'carrer',
    'carrera',
    'carrerai',
    'carreraient',
    'carrerais',
    'carrerait',
    'carreras',
    'carrerez',
    'carreriez',
    'carrerions',
    'carrerons',
    'carreront',
    'carres',
    'carrez',
    'carrick',
    'carricks',
    'carrier',
    'carriers',
    'carriez',
    'carriole',
    'carrioles',
    'carrions',
    'carrière',
    'carrières',
    'carriérisme',
    'carriérismes',
    'carriériste',
    'carriéristes',
    'carroie',
    'carroient',
    'carroiera',
    'carroierai',
    'carroierais',
    'carroierait',
    'carroieras',
    'carroierez',
    'carroieriez',
    'carroierions',
    'carroierons',
    'carroieront',
    'carroies',
    'carrons',
    'carrossa',
    'carrossable',
    'carrossables',
    'carrossage',
    'carrossages',
    'carrossai',
    'carrossaient',
    'carrossais',
    'carrossait',
    'carrossant',
    'carrossas',
    'carrossasse',
    'carrossasses',
    'carrosse',
    'carrossent',
    'carrosser',
    'carrossera',
    'carrosserai',
    'carrosserais',
    'carrosserait',
    'carrosseras',
    'carrosserez',
    'carrosserie',
    'carrosseries',
    'carrosseriez',
    'carrosserons',
    'carrosseront',
    'carrosses',
    'carrossez',
    'carrossier',
    'carrossiers',
    'carrossiez',
    'carrossions',
    'carrossons',
    'carrossâmes',
    'carrossât',
    'carrossâtes',
    'carrossèrent',
    'carrossé',
    'carrossée',
    'carrossées',
    'carrossés',
    'carrousel',
    'carrousels',
    'carroya',
    'carroyage',
    'carroyages',
    'carroyai',
    'carroyaient',
    'carroyais',
    'carroyait',
    'carroyant',
    'carroyas',
    'carroyasse',
    'carroyassent',
    'carroyasses',
    'carroyassiez',
    'carroyer',
    'carroyez',
    'carroyiez',
    'carroyions',
    'carroyons',
    'carroyâmes',
    'carroyât',
    'carroyâtes',
    'carroyèrent',
    'carroyé',
    'carroyée',
    'carroyées',
    'carroyés',
    'carrure',
    'carrures',
    'carry',
    'carrys',
    'carrâmes',
    'carrât',
    'carrâtes',
    'carrèrent',
    'carré',
    'carrée',
    'carrées',
    'carrément',
    'carrés',
    'cars',
    'cartable',
    'cartables',
    'cartayer',
    'carte',
    'cartel',
    'cartels',
    'carter',
    'carters',
    'cartes',
    'carthaginois',
    'cartier',
    'cartiers',
    'cartilage',
    'cartilages',
    'cartographe',
    'cartographes',
    'cartographie',
    'cartomancie',
    'cartomancien',
    'cartomancies',
    'carton',
    'cartonna',
    'cartonnage',
    'cartonnages',
    'cartonnai',
    'cartonnaient',
    'cartonnais',
    'cartonnait',
    'cartonnant',
    'cartonnas',
    'cartonnasse',
    'cartonnasses',
    'cartonne',
    'cartonnent',
    'cartonner',
    'cartonnera',
    'cartonnerai',
    'cartonnerais',
    'cartonnerait',
    'cartonneras',
    'cartonnerez',
    'cartonnerie',
    'cartonneries',
    'cartonneriez',
    'cartonnerons',
    'cartonneront',
    'cartonnes',
    'cartonneuse',
    'cartonneuses',
    'cartonneux',
    'cartonnez',
    'cartonnier',
    'cartonniers',
    'cartonniez',
    'cartonnions',
    'cartonnière',
    'cartonnières',
    'cartonnons',
    'cartonnâmes',
    'cartonnât',
    'cartonnâtes',
    'cartonnèrent',
    'cartonné',
    'cartonnée',
    'cartonnées',
    'cartonnés',
    'cartons',
    'cartoon',
    'cartoons',
    'cartothèque',
    'cartothèques',
    'cartouche',
    'cartoucherie',
    'cartouches',
    'cartouchière',
    'cartésien',
    'cartésienne',
    'cartésiennes',
    'cartésiens',
    'caryopse',
    'caryopses',
    'carène',
    'carènent',
    'carènes',
    'caréna',
    'carénage',
    'carénages',
    'carénai',
    'carénaient',
    'carénais',
    'carénait',
    'carénant',
    'carénas',
    'carénasse',
    'carénassent',
    'carénasses',
    'carénassiez',
    'carénassions',
    'caréner',
    'carénera',
    'carénerai',
    'caréneraient',
    'carénerais',
    'carénerait',
    'caréneras',
    'carénerez',
    'caréneriez',
    'carénerions',
    'carénerons',
    'caréneront',
    'carénez',
    'caréniez',
    'carénions',
    'carénons',
    'carénâmes',
    'carénât',
    'carénâtes',
    'carénèrent',
    'caréné',
    'carénée',
    'carénées',
    'carénés',
    'carême',
    'carêmes',
    'casa',
    'casai',
    'casaient',
    'casais',
    'casait',
    'casanier',
    'casaniers',
    'casanière',
    'casanières',
    'casant',
    'casaque',
    'casaques',
    'casaquin',
    'casaquins',
    'casas',
    'casasse',
    'casassent',
    'casasses',
    'casassiez',
    'casassions',
    'casbah',
    'casbahs',
    'cascada',
    'cascadai',
    'cascadaient',
    'cascadais',
    'cascadait',
    'cascadant',
    'cascadas',
    'cascadasse',
    'cascadassent',
    'cascadasses',
    'cascadassiez',
    'cascade',
    'cascadent',
    'cascader',
    'cascadera',
    'cascaderai',
    'cascaderais',
    'cascaderait',
    'cascaderas',
    'cascaderez',
    'cascaderiez',
    'cascaderions',
    'cascaderons',
    'cascaderont',
    'cascades',
    'cascadeur',
    'cascadeurs',
    'cascadeuse',
    'cascadeuses',
    'cascadez',
    'cascadiez',
    'cascadions',
    'cascadons',
    'cascadâmes',
    'cascadât',
    'cascadâtes',
    'cascadèrent',
    'cascadé',
    'cascatelle',
    'cascatelles',
    'case',
    'casemata',
    'casematai',
    'casemataient',
    'casematais',
    'casematait',
    'casematant',
    'casematas',
    'casematasse',
    'casematasses',
    'casemate',
    'casematent',
    'casemater',
    'casematera',
    'casematerai',
    'casematerais',
    'casematerait',
    'casemateras',
    'casematerez',
    'casemateriez',
    'casematerons',
    'casemateront',
    'casemates',
    'casematez',
    'casematiez',
    'casemations',
    'casematons',
    'casematâmes',
    'casematât',
    'casematâtes',
    'casematèrent',
    'casematé',
    'casematée',
    'casematées',
    'casematés',
    'casent',
    'caser',
    'casera',
    'caserai',
    'caseraient',
    'caserais',
    'caserait',
    'caseras',
    'caserez',
    'caseriez',
    'caserions',
    'caserna',
    'casernai',
    'casernaient',
    'casernais',
    'casernait',
    'casernant',
    'casernas',
    'casernasse',
    'casernassent',
    'casernasses',
    'casernassiez',
    'caserne',
    'casernement',
    'casernements',
    'casernent',
    'caserner',
    'casernera',
    'casernerai',
    'casernerais',
    'casernerait',
    'caserneras',
    'casernerez',
    'caserneriez',
    'casernerions',
    'casernerons',
    'caserneront',
    'casernes',
    'casernez',
    'casernier',
    'caserniers',
    'caserniez',
    'casernions',
    'casernons',
    'casernâmes',
    'casernât',
    'casernâtes',
    'casernèrent',
    'caserné',
    'casernée',
    'casernées',
    'casernés',
    'caserons',
    'caseront',
    'cases',
    'casez',
    'cash',
    'casher',
    'cashmere',
    'cashmeres',
    'casier',
    'casiers',
    'casiez',
    'casimir',
    'casimirs',
    'casino',
    'casinos',
    'casions',
    'casoar',
    'casoars',
    'casons',
    'casqua',
    'casquai',
    'casquaient',
    'casquais',
    'casquait',
    'casquant',
    'casquas',
    'casquasse',
    'casquassent',
    'casquasses',
    'casquassiez',
    'casquassions',
    'casque',
    'casquent',
    'casquer',
    'casquera',
    'casquerai',
    'casqueraient',
    'casquerais',
    'casquerait',
    'casqueras',
    'casquerez',
    'casqueriez',
    'casquerions',
    'casquerons',
    'casqueront',
    'casques',
    'casquette',
    'casquettes',
    'casquez',
    'casquiez',
    'casquions',
    'casquons',
    'casquâmes',
    'casquât',
    'casquâtes',
    'casquèrent',
    'casqué',
    'casquée',
    'casquées',
    'casqués',
    'cassa',
    'cassable',
    'cassables',
    'cassage',
    'cassages',
    'cassai',
    'cassaient',
    'cassais',
    'cassait',
    'cassant',
    'cassante',
    'cassantes',
    'cassants',
    'cassas',
    'cassasse',
    'cassassent',
    'cassasses',
    'cassassiez',
    'cassassions',
    'cassate',
    'cassates',
    'cassation',
    'cassations',
    'casse',
    'casseau',
    'casseaux',
    'cassement',
    'cassements',
    'cassent',
    'casser',
    'cassera',
    'casserai',
    'casseraient',
    'casserais',
    'casserait',
    'casseras',
    'casserez',
    'casseriez',
    'casserions',
    'casserole',
    'casseroles',
    'casserons',
    'casseront',
    'casses',
    'cassetin',
    'cassetins',
    'cassette',
    'cassettes',
    'casseur',
    'casseurs',
    'casseuse',
    'casseuses',
    'cassez',
    'cassier',
    'cassiers',
    'cassiez',
    'cassine',
    'cassines',
    'cassions',
    'cassis',
    'cassitérite',
    'cassitérites',
    'cassolette',
    'cassolettes',
    'casson',
    'cassonade',
    'cassonades',
    'cassons',
    'cassoulet',
    'cassoulets',
    'cassure',
    'cassures',
    'cassâmes',
    'cassât',
    'cassâtes',
    'cassèrent',
    'cassé',
    'cassée',
    'cassées',
    'cassés',
    'castagna',
    'castagnai',
    'castagnaient',
    'castagnais',
    'castagnait',
    'castagnant',
    'castagnas',
    'castagnasse',
    'castagnasses',
    'castagne',
    'castagnent',
    'castagner',
    'castagnera',
    'castagnerai',
    'castagnerais',
    'castagnerait',
    'castagneras',
    'castagnerez',
    'castagneriez',
    'castagnerons',
    'castagneront',
    'castagnes',
    'castagnettes',
    'castagnez',
    'castagniez',
    'castagnions',
    'castagnons',
    'castagnâmes',
    'castagnât',
    'castagnâtes',
    'castagnèrent',
    'castagné',
    'castagnée',
    'castagnées',
    'castagnés',
    'caste',
    'castel',
    'castels',
    'castes',
    'castigliano',
    'castillan',
    'castillane',
    'castillanes',
    'castillans',
    'castine',
    'castines',
    'castor',
    'castors',
    'castoréum',
    'castoréums',
    'castra',
    'castrai',
    'castraient',
    'castrais',
    'castrait',
    'castrant',
    'castras',
    'castrasse',
    'castrassent',
    'castrasses',
    'castrassiez',
    'castrassions',
    'castrat',
    'castrateur',
    'castrateurs',
    'castration',
    'castrations',
    'castratrice',
    'castratrices',
    'castrats',
    'castre',
    'castrent',
    'castrer',
    'castrera',
    'castrerai',
    'castreraient',
    'castrerais',
    'castrerait',
    'castreras',
    'castrerez',
    'castreriez',
    'castrerions',
    'castrerons',
    'castreront',
    'castres',
    'castrez',
    'castriez',
    'castrions',
    'castrons',
    'castrâmes',
    'castrât',
    'castrâtes',
    'castrèrent',
    'castré',
    'castrée',
    'castrées',
    'castrés',
    'casuel',
    'casuelle',
    'casuelles',
    'casuels',
    'casuiste',
    'casuistes',
    'casuistique',
    'casuistiques',
    'casâmes',
    'casât',
    'casâtes',
    'casèrent',
    'casé',
    'casée',
    'casées',
    'caséfia',
    'caséfiai',
    'caséfiaient',
    'caséfiais',
    'caséfiait',
    'caséfiant',
    'caséfias',
    'caséfiasse',
    'caséfiassent',
    'caséfiasses',
    'caséfiassiez',
    'caséfie',
    'caséfient',
    'caséfier',
    'caséfiera',
    'caséfierai',
    'caséfierais',
    'caséfierait',
    'caséfieras',
    'caséfierez',
    'caséfieriez',
    'caséfierions',
    'caséfierons',
    'caséfieront',
    'caséfies',
    'caséfiez',
    'caséfiiez',
    'caséfiions',
    'caséfions',
    'caséfiâmes',
    'caséfiât',
    'caséfiâtes',
    'caséfièrent',
    'caséfié',
    'caséfiée',
    'caséfiées',
    'caséfiés',
    'caséine',
    'casés',
    'catabolisme',
    'catabolismes',
    'catachrèse',
    'catachrèses',
    'cataclysme',
    'cataclysmes',
    'catacombes',
    'catadioptre',
    'catadioptres',
    'catafalque',
    'catafalques',
    'cataire',
    'cataires',
    'catalan',
    'catalane',
    'catalanes',
    'catalans',
    'catalectique',
    'catalepsie',
    'catalepsies',
    'cataleptique',
    'catalogne',
    'catalognes',
    'catalogua',
    'cataloguai',
    'cataloguais',
    'cataloguait',
    'cataloguant',
    'cataloguas',
    'cataloguasse',
    'catalogue',
    'cataloguent',
    'cataloguer',
    'cataloguera',
    'cataloguerai',
    'catalogueras',
    'cataloguerez',
    'catalogues',
    'cataloguez',
    'cataloguiez',
    'cataloguions',
    'cataloguons',
    'cataloguâmes',
    'cataloguât',
    'cataloguâtes',
    'catalogué',
    'cataloguée',
    'cataloguées',
    'catalogués',
    'catalpa',
    'catalpas',
    'catalysa',
    'catalysai',
    'catalysaient',
    'catalysais',
    'catalysait',
    'catalysant',
    'catalysas',
    'catalysasse',
    'catalysasses',
    'catalyse',
    'catalysent',
    'catalyser',
    'catalysera',
    'catalyserai',
    'catalyserais',
    'catalyserait',
    'catalyseras',
    'catalyserez',
    'catalyseriez',
    'catalyserons',
    'catalyseront',
    'catalyses',
    'catalyseur',
    'catalyseurs',
    'catalysez',
    'catalysiez',
    'catalysions',
    'catalysons',
    'catalysâmes',
    'catalysât',
    'catalysâtes',
    'catalysèrent',
    'catalysé',
    'catalysée',
    'catalysées',
    'catalysés',
    'catalytique',
    'catalytiques',
    'catamaran',
    'catamarans',
    'cataphote',
    'cataphotes',
    'cataplasme',
    'cataplasmes',
    'catapulta',
    'catapultage',
    'catapultages',
    'catapultai',
    'catapultais',
    'catapultait',
    'catapultant',
    'catapultas',
    'catapultasse',
    'catapulte',
    'catapultent',
    'catapulter',
    'catapultera',
    'catapulterai',
    'catapulteras',
    'catapulterez',
    'catapultes',
    'catapultez',
    'catapultiez',
    'catapultions',
    'catapultons',
    'catapultâmes',
    'catapultât',
    'catapultâtes',
    'catapulté',
    'catapultée',
    'catapultées',
    'catapultés',
    'cataracte',
    'cataractes',
    'catarrhal',
    'catarrhale',
    'catarrhales',
    'catarrhaux',
    'catarrhe',
    'catarrhes',
    'catarrheuse',
    'catarrheuses',
    'catarrheux',
    'catastropha',
    'catastrophai',
    'catastrophas',
    'catastrophe',
    'catastropher',
    'catastrophes',
    'catastrophez',
    'catastrophât',
    'catastrophé',
    'catastrophée',
    'catastrophés',
    'catch',
    'catcha',
    'catchai',
    'catchaient',
    'catchais',
    'catchait',
    'catchant',
    'catchas',
    'catchasse',
    'catchassent',
    'catchasses',
    'catchassiez',
    'catchassions',
    'catche',
    'catchent',
    'catcher',
    'catchera',
    'catcherai',
    'catcheraient',
    'catcherais',
    'catcherait',
    'catcheras',
    'catcherez',
    'catcheriez',
    'catcherions',
    'catcherons',
    'catcheront',
    'catches',
    'catcheur',
    'catcheurs',
    'catcheuse',
    'catcheuses',
    'catchez',
    'catchiez',
    'catchions',
    'catchons',
    'catchs',
    'catchâmes',
    'catchât',
    'catchâtes',
    'catchèrent',
    'catché',
    'cathare',
    'cathares',
    'catharsique',
    'catharsiques',
    'catherinette',
    'cathode',
    'cathodes',
    'cathodique',
    'cathodiques',
    'catholicisme',
    'catholicité',
    'catholicités',
    'catholique',
    'catholiques',
    'cathédrale',
    'cathédrales',
    'cathéter',
    'cathéters',
    'cathétérisme',
    'cati',
    'catia',
    'catilinaire',
    'catilinaires',
    'catimini',
    'catin',
    'catins',
    'cation',
    'cationique',
    'cationiques',
    'cations',
    'catir',
    'catis',
    'catissage',
    'catissages',
    'catoblépas',
    'catogan',
    'catogans',
    'catoptrique',
    'catoptriques',
    'cattleya',
    'cattleyas',
    'catéchisa',
    'catéchisai',
    'catéchisais',
    'catéchisait',
    'catéchisant',
    'catéchisas',
    'catéchisasse',
    'catéchise',
    'catéchisent',
    'catéchiser',
    'catéchisera',
    'catéchiserai',
    'catéchiseras',
    'catéchiserez',
    'catéchises',
    'catéchisez',
    'catéchisiez',
    'catéchisions',
    'catéchisme',
    'catéchismes',
    'catéchisons',
    'catéchiste',
    'catéchistes',
    'catéchisâmes',
    'catéchisât',
    'catéchisâtes',
    'catéchisé',
    'catéchisée',
    'catéchisées',
    'catéchisés',
    'catéchumène',
    'catéchumènes',
    'catéchuménat',
    'catégorie',
    'catégoriel',
    'catégorielle',
    'catégoriels',
    'catégories',
    'catégorique',
    'catégoriques',
    'catégorisa',
    'catégorisais',
    'catégorisait',
    'catégorisant',
    'catégorise',
    'catégorisent',
    'catégoriser',
    'catégorisera',
    'catégorises',
    'catégorisez',
    'catégorisiez',
    'catégorisons',
    'catégorisé',
    'catégorisée',
    'catégorisées',
    'catégorisés',
    'catégorème',
    'catégorèmes',
    'caténaire',
    'caténaires',
    'caucasien',
    'caucasienne',
    'caucasiennes',
    'caucasiens',
    'cauchemar',
    'cauchemarda',
    'cauchemardai',
    'cauchemardas',
    'cauchemarde',
    'cauchemarder',
    'cauchemardes',
    'cauchemardez',
    'cauchemardât',
    'cauchemardé',
    'cauchemars',
    'caudal',
    'caudale',
    'caudales',
    'caudataire',
    'caudataires',
    'caudaux',
    'caudillo',
    'caudillos',
    'caudrette',
    'caudrettes',
    'caulescent',
    'caulescente',
    'caulescentes',
    'caulescents',
    'cauri',
    'cauris',
    'causa',
    'causai',
    'causaient',
    'causais',
    'causait',
    'causal',
    'causale',
    'causales',
    'causalisme',
    'causalismes',
    'causalité',
    'causalités',
    'causals',
    'causant',
    'causante',
    'causantes',
    'causants',
    'causas',
    'causasse',
    'causassent',
    'causasses',
    'causassiez',
    'causassions',
    'causatif',
    'causatifs',
    'causative',
    'causatives',
    'causaux',
    'cause',
    'causent',
    'causer',
    'causera',
    'causerai',
    'causeraient',
    'causerais',
    'causerait',
    'causeras',
    'causerez',
    'causerie',
    'causeries',
    'causeriez',
    'causerions',
    'causerons',
    'causeront',
    'causes',
    'causette',
    'causettes',
    'causeur',
    'causeurs',
    'causeuse',
    'causeuses',
    'causez',
    'causiez',
    'causions',
    'causons',
    'causse',
    'causses',
    'causticité',
    'causticités',
    'caustique',
    'caustiques',
    'causâmes',
    'causât',
    'causâtes',
    'causèrent',
    'causé',
    'causée',
    'causées',
    'causés',
    'cauteleuse',
    'cauteleuses',
    'cauteleux',
    'caution',
    'cautionna',
    'cautionnai',
    'cautionnais',
    'cautionnait',
    'cautionnant',
    'cautionnas',
    'cautionnasse',
    'cautionne',
    'cautionnent',
    'cautionner',
    'cautionnera',
    'cautionnerai',
    'cautionneras',
    'cautionnerez',
    'cautionnes',
    'cautionnez',
    'cautionniez',
    'cautionnions',
    'cautionnons',
    'cautionnâmes',
    'cautionnât',
    'cautionnâtes',
    'cautionné',
    'cautionnée',
    'cautionnées',
    'cautionnés',
    'cautions',
    'cautèle',
    'cautèles',
    'cautère',
    'cautères',
    'cautérisa',
    'cautérisai',
    'cautérisais',
    'cautérisait',
    'cautérisant',
    'cautérisante',
    'cautérisants',
    'cautérisas',
    'cautérisasse',
    'cautérise',
    'cautérisent',
    'cautériser',
    'cautérisera',
    'cautériserai',
    'cautériseras',
    'cautériserez',
    'cautérises',
    'cautérisez',
    'cautérisiez',
    'cautérisions',
    'cautérisons',
    'cautérisâmes',
    'cautérisât',
    'cautérisâtes',
    'cautérisé',
    'cautérisée',
    'cautérisées',
    'cautérisés',
    'cava',
    'cavai',
    'cavaient',
    'cavaillon',
    'cavaillons',
    'cavais',
    'cavait',
    'cavala',
    'cavalai',
    'cavalaient',
    'cavalais',
    'cavalait',
    'cavalant',
    'cavalas',
    'cavalasse',
    'cavalassent',
    'cavalasses',
    'cavalassiez',
    'cavalassions',
    'cavalcada',
    'cavalcadai',
    'cavalcadais',
    'cavalcadait',
    'cavalcadant',
    'cavalcadas',
    'cavalcadasse',
    'cavalcade',
    'cavalcadent',
    'cavalcader',
    'cavalcadera',
    'cavalcaderai',
    'cavalcaderas',
    'cavalcaderez',
    'cavalcades',
    'cavalcadez',
    'cavalcadiez',
    'cavalcadions',
    'cavalcadons',
    'cavalcadâmes',
    'cavalcadât',
    'cavalcadâtes',
    'cavalcadé',
    'cavale',
    'cavalent',
    'cavaler',
    'cavalera',
    'cavalerai',
    'cavaleraient',
    'cavalerais',
    'cavalerait',
    'cavaleras',
    'cavalerez',
    'cavalerie',
    'cavaleries',
    'cavaleriez',
    'cavalerions',
    'cavalerons',
    'cavaleront',
    'cavales',
    'cavaleur',
    'cavaleurs',
    'cavaleuse',
    'cavaleuses',
    'cavalez',
    'cavalier',
    'cavaliers',
    'cavaliez',
    'cavalions',
    'cavalière',
    'cavalières',
    'cavalons',
    'cavalâmes',
    'cavalât',
    'cavalâtes',
    'cavalèrent',
    'cavalé',
    'cavalée',
    'cavalées',
    'cavalés',
    'cavant',
    'cavas',
    'cavasse',
    'cavassent',
    'cavasses',
    'cavassiez',
    'cavassions',
    'cavatine',
    'cavatines',
    'cave',
    'caveau',
    'caveaux',
    'cavent',
    'caver',
    'cavera',
    'caverai',
    'caveraient',
    'caverais',
    'caverait',
    'caveras',
    'caverez',
    'caveriez',
    'caverions',
    'caverne',
    'cavernes',
    'caverneuse',
    'caverneuses',
    'caverneux',
    'cavernicole',
    'cavernicoles',
    'caverons',
    'caveront',
    'caves',
    'cavet',
    'cavets',
    'cavez',
    'caviar',
    'caviarda',
    'caviardai',
    'caviardaient',
    'caviardais',
    'caviardait',
    'caviardant',
    'caviardas',
    'caviardasse',
    'caviardasses',
    'caviarde',
    'caviardent',
    'caviarder',
    'caviardera',
    'caviarderai',
    'caviarderais',
    'caviarderait',
    'caviarderas',
    'caviarderez',
    'caviarderiez',
    'caviarderons',
    'caviarderont',
    'caviardes',
    'caviardez',
    'caviardiez',
    'caviardions',
    'caviardons',
    'caviardâmes',
    'caviardât',
    'caviardâtes',
    'caviardèrent',
    'caviardé',
    'caviardée',
    'caviardées',
    'caviardés',
    'caviars',
    'cavicorne',
    'cavicornes',
    'caviez',
    'cavions',
    'caviste',
    'cavistes',
    'cavitation',
    'cavitations',
    'cavité',
    'cavités',
    'cavons',
    'cavâmes',
    'cavât',
    'cavâtes',
    'cavèrent',
    'cavé',
    'cavée',
    'cavées',
    'cavés',
    'caïd',
    'caïds',
    'caïeu',
    'caïeux',
    'caïman',
    'caïmans',
    'caïque',
    'caïques',
    'ceci',
    'cedex',
    'ceignaient',
    'ceignais',
    'ceignait',
    'ceignant',
    'ceigne',
    'ceignent',
    'ceignes',
    'ceignez',
    'ceigniez',
    'ceignions',
    'ceignirent',
    'ceignis',
    'ceignisse',
    'ceignissent',
    'ceignisses',
    'ceignissiez',
    'ceignissions',
    'ceignit',
    'ceignons',
    'ceignîmes',
    'ceignît',
    'ceignîtes',
    'ceindra',
    'ceindrai',
    'ceindraient',
    'ceindrais',
    'ceindrait',
    'ceindras',
    'ceindre',
    'ceindrez',
    'ceindriez',
    'ceindrions',
    'ceindrons',
    'ceindront',
    'ceins',
    'ceint',
    'ceinte',
    'ceintes',
    'ceints',
    'ceintura',
    'ceinturage',
    'ceinturages',
    'ceinturai',
    'ceinturaient',
    'ceinturais',
    'ceinturait',
    'ceinturant',
    'ceinturas',
    'ceinturasse',
    'ceinturasses',
    'ceinture',
    'ceinturent',
    'ceinturer',
    'ceinturera',
    'ceinturerai',
    'ceinturerais',
    'ceinturerait',
    'ceintureras',
    'ceinturerez',
    'ceintureriez',
    'ceinturerons',
    'ceintureront',
    'ceintures',
    'ceinturez',
    'ceinturiez',
    'ceinturions',
    'ceinturon',
    'ceinturons',
    'ceinturâmes',
    'ceinturât',
    'ceinturâtes',
    'ceinturèrent',
    'ceinturé',
    'ceinturée',
    'ceinturées',
    'ceinturés',
    'cela',
    'celai',
    'celaient',
    'celais',
    'celait',
    'celant',
    'celas',
    'celasse',
    'celassent',
    'celasses',
    'celassiez',
    'celassions',
    'celebret',
    'celebrets',
    'celer',
    'celez',
    'celiez',
    'celions',
    'cella',
    'cellas',
    'celle',
    'celles',
    'cellier',
    'celliers',
    'cellophane',
    'cellophanes',
    'cellulaire',
    'cellulaires',
    'cellular',
    'cellulars',
    'cellule',
    'cellules',
    'cellulite',
    'cellulites',
    'cellulose',
    'celluloses',
    'cellulosique',
    'celluloïd',
    'celluloïds',
    'cellérier',
    'cellériers',
    'cellérière',
    'cellérières',
    'celons',
    'celte',
    'celtes',
    'celtique',
    'celtiques',
    'celui',
    'celâmes',
    'celât',
    'celâtes',
    'celèrent',
    'celé',
    'celée',
    'celées',
    'celés',
    'cendra',
    'cendrai',
    'cendraient',
    'cendrais',
    'cendrait',
    'cendrant',
    'cendras',
    'cendrasse',
    'cendrassent',
    'cendrasses',
    'cendrassiez',
    'cendrassions',
    'cendre',
    'cendrent',
    'cendrer',
    'cendrera',
    'cendrerai',
    'cendreraient',
    'cendrerais',
    'cendrerait',
    'cendreras',
    'cendrerez',
    'cendreriez',
    'cendrerions',
    'cendrerons',
    'cendreront',
    'cendres',
    'cendreuse',
    'cendreuses',
    'cendreux',
    'cendrez',
    'cendrier',
    'cendriers',
    'cendriez',
    'cendrillon',
    'cendrillons',
    'cendrions',
    'cendrons',
    'cendrâmes',
    'cendrât',
    'cendrâtes',
    'cendrèrent',
    'cendré',
    'cendrée',
    'cendrées',
    'cendrés',
    'cenelle',
    'cenelles',
    'cens',
    'censeur',
    'censeurs',
    'censier',
    'censiers',
    'censitaire',
    'censitaires',
    'censière',
    'censières',
    'censorat',
    'censorats',
    'censorial',
    'censoriale',
    'censoriales',
    'censoriaux',
    'censura',
    'censurai',
    'censuraient',
    'censurais',
    'censurait',
    'censurant',
    'censuras',
    'censurasse',
    'censurassent',
    'censurasses',
    'censurassiez',
    'censure',
    'censurent',
    'censurer',
    'censurera',
    'censurerai',
    'censurerais',
    'censurerait',
    'censureras',
    'censurerez',
    'censureriez',
    'censurerions',
    'censurerons',
    'censureront',
    'censures',
    'censurez',
    'censuriez',
    'censurions',
    'censurons',
    'censurâmes',
    'censurât',
    'censurâtes',
    'censurèrent',
    'censuré',
    'censurée',
    'censurées',
    'censurés',
    'censé',
    'censée',
    'censées',
    'censément',
    'censés',
    'cent',
    'centaine',
    'centaines',
    'centaure',
    'centaures',
    'centaurée',
    'centaurées',
    'centavo',
    'centavos',
    'centenaire',
    'centenaires',
    'centenier',
    'centeniers',
    'centennal',
    'centennale',
    'centennales',
    'centennaux',
    'centiare',
    'centiares',
    'centibar',
    'centibars',
    'centigrade',
    'centigrades',
    'centigramme',
    'centigrammes',
    'centilitre',
    'centilitres',
    'centime',
    'centimes',
    'centimètre',
    'centimètres',
    'centième',
    'centièmes',
    'centra',
    'centrage',
    'centrages',
    'centrai',
    'centraient',
    'centrais',
    'centrait',
    'central',
    'centrale',
    'centrales',
    'centralisa',
    'centralisai',
    'centralisais',
    'centralisait',
    'centralisant',
    'centralisas',
    'centralise',
    'centralisent',
    'centraliser',
    'centralisera',
    'centralises',
    'centralisez',
    'centralisiez',
    'centralisme',
    'centralismes',
    'centralisons',
    'centralisât',
    'centralisé',
    'centralisée',
    'centralisées',
    'centralisés',
    'centrant',
    'centras',
    'centrasse',
    'centrassent',
    'centrasses',
    'centrassiez',
    'centrassions',
    'centraux',
    'centre',
    'centrent',
    'centrer',
    'centrera',
    'centrerai',
    'centreraient',
    'centrerais',
    'centrerait',
    'centreras',
    'centrerez',
    'centreriez',
    'centrerions',
    'centrerons',
    'centreront',
    'centres',
    'centreur',
    'centreurs',
    'centrez',
    'centriez',
    'centrifuge',
    'centrifugea',
    'centrifugeai',
    'centrifugeas',
    'centrifugent',
    'centrifuger',
    'centrifugera',
    'centrifuges',
    'centrifugeur',
    'centrifugez',
    'centrifugeât',
    'centrifugiez',
    'centrifugé',
    'centrifugée',
    'centrifugées',
    'centrifugés',
    'centrions',
    'centripète',
    'centripètes',
    'centrisme',
    'centrismes',
    'centriste',
    'centristes',
    'centrons',
    'centrosome',
    'centrosomes',
    'centrâmes',
    'centrât',
    'centrâtes',
    'centrèrent',
    'centré',
    'centrée',
    'centrées',
    'centrés',
    'cents',
    'centupla',
    'centuplai',
    'centuplaient',
    'centuplais',
    'centuplait',
    'centuplant',
    'centuplas',
    'centuplasse',
    'centuplasses',
    'centuple',
    'centuplent',
    'centupler',
    'centuplera',
    'centuplerai',
    'centuplerais',
    'centuplerait',
    'centupleras',
    'centuplerez',
    'centupleriez',
    'centuplerons',
    'centupleront',
    'centuples',
    'centuplez',
    'centupliez',
    'centuplions',
    'centuplons',
    'centuplâmes',
    'centuplât',
    'centuplâtes',
    'centuplèrent',
    'centuplé',
    'centuplée',
    'centuplées',
    'centuplés',
    'centurie',
    'centuries',
    'centurion',
    'centurions',
    'centésimal',
    'centésimale',
    'centésimales',
    'centésimaux',
    'cependant',
    'ceps',
    'cerbère',
    'cerbères',
    'cerce',
    'cerceau',
    'cerceaux',
    'cerces',
    'cercla',
    'cerclage',
    'cerclages',
    'cerclai',
    'cerclaient',
    'cerclais',
    'cerclait',
    'cerclant',
    'cerclas',
    'cerclasse',
    'cerclassent',
    'cerclasses',
    'cerclassiez',
    'cerclassions',
    'cercle',
    'cerclent',
    'cercler',
    'cerclera',
    'cerclerai',
    'cercleraient',
    'cerclerais',
    'cerclerait',
    'cercleras',
    'cerclerez',
    'cercleriez',
    'cerclerions',
    'cerclerons',
    'cercleront',
    'cercles',
    'cerclez',
    'cercliez',
    'cerclions',
    'cerclons',
    'cerclâmes',
    'cerclât',
    'cerclâtes',
    'cerclèrent',
    'cerclé',
    'cerclée',
    'cerclées',
    'cerclés',
    'cercueil',
    'cercueils',
    'cerf',
    'cerfeuil',
    'cerfeuils',
    'cerfs',
    'cerisaie',
    'cerisaies',
    'cerise',
    'cerises',
    'cerisette',
    'cerisettes',
    'cerisier',
    'cerisiers',
    'cerna',
    'cernai',
    'cernaient',
    'cernais',
    'cernait',
    'cernant',
    'cernas',
    'cernasse',
    'cernassent',
    'cernasses',
    'cernassiez',
    'cernassions',
    'cerne',
    'cerneau',
    'cerneaux',
    'cernent',
    'cerner',
    'cernera',
    'cernerai',
    'cerneraient',
    'cernerais',
    'cernerait',
    'cerneras',
    'cernerez',
    'cerneriez',
    'cernerions',
    'cernerons',
    'cerneront',
    'cernes',
    'cernez',
    'cerniez',
    'cernions',
    'cernons',
    'cernâmes',
    'cernât',
    'cernâtes',
    'cernèrent',
    'cerné',
    'cernée',
    'cernées',
    'cernés',
    'certain',
    'certaine',
    'certainement',
    'certaines',
    'certains',
    'certes',
    'certifia',
    'certifiai',
    'certifiaient',
    'certifiais',
    'certifiait',
    'certifiant',
    'certifias',
    'certifiasse',
    'certifiasses',
    'certificat',
    'certificats',
    'certifie',
    'certifient',
    'certifier',
    'certifiera',
    'certifierai',
    'certifierais',
    'certifierait',
    'certifieras',
    'certifierez',
    'certifieriez',
    'certifierons',
    'certifieront',
    'certifies',
    'certifiez',
    'certifiiez',
    'certifiions',
    'certifions',
    'certifiâmes',
    'certifiât',
    'certifiâtes',
    'certifièrent',
    'certifié',
    'certifiée',
    'certifiées',
    'certifiés',
    'certitude',
    'certitudes',
    'cerveau',
    'cerveaux',
    'cervelas',
    'cervelet',
    'cervelets',
    'cervelle',
    'cervelles',
    'cervical',
    'cervicale',
    'cervicales',
    'cervicaux',
    'cervier',
    'cerviers',
    'cervoise',
    'cervoises',
    'cessa',
    'cessai',
    'cessaient',
    'cessais',
    'cessait',
    'cessant',
    'cessante',
    'cessantes',
    'cessants',
    'cessas',
    'cessasse',
    'cessassent',
    'cessasses',
    'cessassiez',
    'cessassions',
    'cessation',
    'cessations',
    'cesse',
    'cessent',
    'cesser',
    'cessera',
    'cesserai',
    'cesseraient',
    'cesserais',
    'cesserait',
    'cesseras',
    'cesserez',
    'cesseriez',
    'cesserions',
    'cesserons',
    'cesseront',
    'cesses',
    'cessez',
    'cessibilité',
    'cessibilités',
    'cessible',
    'cessibles',
    'cessiez',
    'cession',
    'cessionnaire',
    'cessions',
    'cessons',
    'cessâmes',
    'cessât',
    'cessâtes',
    'cessèrent',
    'cessé',
    'cessée',
    'cessées',
    'cessés',
    'ceste',
    'cestes',
    'cetera',
    'cette',
    'ceux',
    'chabichou',
    'chabichous',
    'chabla',
    'chablai',
    'chablaient',
    'chablais',
    'chablait',
    'chablant',
    'chablas',
    'chablasse',
    'chablassent',
    'chablasses',
    'chablassiez',
    'chablassions',
    'chable',
    'chablent',
    'chabler',
    'chablera',
    'chablerai',
    'chableraient',
    'chablerais',
    'chablerait',
    'chableras',
    'chablerez',
    'chableriez',
    'chablerions',
    'chablerons',
    'chableront',
    'chables',
    'chablez',
    'chabliez',
    'chablions',
    'chablis',
    'chablons',
    'chablâmes',
    'chablât',
    'chablâtes',
    'chablèrent',
    'chablé',
    'chablée',
    'chablées',
    'chablés',
    'chaboche',
    'chabot',
    'chabots',
    'chabraque',
    'chabraques',
    'chabrol',
    'chabrols',
    'chabrot',
    'chabrots',
    'chacal',
    'chacals',
    'chacone',
    'chacones',
    'chaconne',
    'chaconnes',
    'chacun',
    'chacune',
    'chadburn',
    'chadburns',
    'chadouf',
    'chadoufs',
    'chafouin',
    'chafouine',
    'chafouines',
    'chafouins',
    'chagrin',
    'chagrina',
    'chagrinai',
    'chagrinaient',
    'chagrinais',
    'chagrinait',
    'chagrinant',
    'chagrinante',
    'chagrinantes',
    'chagrinants',
    'chagrinas',
    'chagrinasse',
    'chagrinasses',
    'chagrine',
    'chagrinent',
    'chagriner',
    'chagrinera',
    'chagrinerai',
    'chagrinerais',
    'chagrinerait',
    'chagrineras',
    'chagrinerez',
    'chagrineriez',
    'chagrinerons',
    'chagrineront',
    'chagrines',
    'chagrinez',
    'chagriniez',
    'chagrinions',
    'chagrinons',
    'chagrins',
    'chagrinâmes',
    'chagrinât',
    'chagrinâtes',
    'chagrinèrent',
    'chagriné',
    'chagrinée',
    'chagrinées',
    'chagrinés',
    'chah',
    'chahs',
    'chahut',
    'chahuta',
    'chahutai',
    'chahutaient',
    'chahutais',
    'chahutait',
    'chahutant',
    'chahutante',
    'chahutantes',
    'chahutants',
    'chahutas',
    'chahutasse',
    'chahutassent',
    'chahutasses',
    'chahutassiez',
    'chahute',
    'chahutent',
    'chahuter',
    'chahutera',
    'chahuterai',
    'chahuterais',
    'chahuterait',
    'chahuteras',
    'chahuterez',
    'chahuteriez',
    'chahuterions',
    'chahuterons',
    'chahuteront',
    'chahutes',
    'chahuteur',
    'chahuteurs',
    'chahuteuse',
    'chahuteuses',
    'chahutez',
    'chahutiez',
    'chahutions',
    'chahutons',
    'chahuts',
    'chahutâmes',
    'chahutât',
    'chahutâtes',
    'chahutèrent',
    'chahuté',
    'chahutée',
    'chahutées',
    'chahutés',
    'chai',
    'chair',
    'chaire',
    'chaires',
    'chairs',
    'chais',
    'chaise',
    'chaises',
    'chaisier',
    'chaisiers',
    'chaisière',
    'chaisières',
    'chaland',
    'chalands',
    'chalaze',
    'chalazes',
    'chalazion',
    'chalazions',
    'chalcopyrite',
    'chalcosine',
    'chalcosines',
    'chaldéen',
    'chaldéenne',
    'chaldéennes',
    'chaldéens',
    'chalet',
    'chalets',
    'chaleur',
    'chaleureuse',
    'chaleureuses',
    'chaleureux',
    'chaleurs',
    'challenge',
    'challengea',
    'challengeai',
    'challengeais',
    'challengeait',
    'challengeant',
    'challengeas',
    'challengent',
    'challengeons',
    'challenger',
    'challengera',
    'challengerai',
    'challengeras',
    'challengerez',
    'challengers',
    'challenges',
    'challengeur',
    'challengeurs',
    'challengez',
    'challengeât',
    'challengiez',
    'challengions',
    'challengé',
    'challengée',
    'challengées',
    'challengés',
    'chaloir',
    'chaloupa',
    'chaloupai',
    'chaloupaient',
    'chaloupais',
    'chaloupait',
    'chaloupant',
    'chaloupas',
    'chaloupasse',
    'chaloupasses',
    'chaloupe',
    'chaloupent',
    'chalouper',
    'chaloupera',
    'chalouperai',
    'chalouperais',
    'chalouperait',
    'chalouperas',
    'chalouperez',
    'chalouperiez',
    'chalouperons',
    'chalouperont',
    'chaloupes',
    'chaloupez',
    'chaloupiez',
    'chaloupions',
    'chaloupons',
    'chaloupâmes',
    'chaloupât',
    'chaloupâtes',
    'chaloupèrent',
    'chaloupé',
    'chaloupée',
    'chaloupées',
    'chaloupés',
    'chalumeau',
    'chalumeaux',
    'chalut',
    'chalutage',
    'chalutages',
    'chalutier',
    'chalutiers',
    'chaluts',
    'chamade',
    'chamades',
    'chamailla',
    'chamaillai',
    'chamaillais',
    'chamaillait',
    'chamaillant',
    'chamaillas',
    'chamaillasse',
    'chamaille',
    'chamaillent',
    'chamailler',
    'chamaillera',
    'chamaillerai',
    'chamailleras',
    'chamaillerez',
    'chamaillerie',
    'chamailles',
    'chamailleur',
    'chamailleurs',
    'chamailleuse',
    'chamaillez',
    'chamailliez',
    'chamaillions',
    'chamaillons',
    'chamaillâmes',
    'chamaillât',
    'chamaillâtes',
    'chamaillé',
    'chamaillée',
    'chamaillées',
    'chamaillés',
    'chamanisme',
    'chamanismes',
    'chamarra',
    'chamarrai',
    'chamarraient',
    'chamarrais',
    'chamarrait',
    'chamarrant',
    'chamarras',
    'chamarrasse',
    'chamarrasses',
    'chamarre',
    'chamarrent',
    'chamarrer',
    'chamarrera',
    'chamarrerai',
    'chamarrerais',
    'chamarrerait',
    'chamarreras',
    'chamarrerez',
    'chamarreriez',
    'chamarrerons',
    'chamarreront',
    'chamarres',
    'chamarrez',
    'chamarriez',
    'chamarrions',
    'chamarrons',
    'chamarrure',
    'chamarrures',
    'chamarrâmes',
    'chamarrât',
    'chamarrâtes',
    'chamarrèrent',
    'chamarré',
    'chamarrée',
    'chamarrées',
    'chamarrés',
    'chambard',
    'chambarda',
    'chambardai',
    'chambardais',
    'chambardait',
    'chambardant',
    'chambardas',
    'chambardasse',
    'chambarde',
    'chambardent',
    'chambarder',
    'chambardera',
    'chambarderai',
    'chambarderas',
    'chambarderez',
    'chambardes',
    'chambardez',
    'chambardiez',
    'chambardions',
    'chambardons',
    'chambards',
    'chambardâmes',
    'chambardât',
    'chambardâtes',
    'chambardé',
    'chambardée',
    'chambardées',
    'chambardés',
    'chambellan',
    'chambellans',
    'chambertin',
    'chambertins',
    'chamboula',
    'chamboulai',
    'chamboulais',
    'chamboulait',
    'chamboulant',
    'chamboulas',
    'chamboulasse',
    'chamboule',
    'chamboulent',
    'chambouler',
    'chamboulera',
    'chamboulerai',
    'chambouleras',
    'chamboulerez',
    'chamboules',
    'chamboulez',
    'chambouliez',
    'chamboulions',
    'chamboulons',
    'chamboulâmes',
    'chamboulât',
    'chamboulâtes',
    'chamboulé',
    'chamboulée',
    'chamboulées',
    'chamboulés',
    'chambra',
    'chambrai',
    'chambraient',
    'chambrais',
    'chambrait',
    'chambranle',
    'chambranles',
    'chambrant',
    'chambras',
    'chambrasse',
    'chambrassent',
    'chambrasses',
    'chambrassiez',
    'chambre',
    'chambrent',
    'chambrer',
    'chambrera',
    'chambrerai',
    'chambrerais',
    'chambrerait',
    'chambreras',
    'chambrerez',
    'chambreriez',
    'chambrerions',
    'chambrerons',
    'chambreront',
    'chambres',
    'chambrette',
    'chambrettes',
    'chambrez',
    'chambrier',
    'chambriers',
    'chambriez',
    'chambrions',
    'chambrière',
    'chambrières',
    'chambrons',
    'chambrâmes',
    'chambrât',
    'chambrâtes',
    'chambrèrent',
    'chambré',
    'chambrée',
    'chambrées',
    'chambrés',
    'chameau',
    'chameaux',
    'chamelier',
    'chameliers',
    'chamelle',
    'chamelles',
    'chamois',
    'chamoisa',
    'chamoisage',
    'chamoisages',
    'chamoisai',
    'chamoisaient',
    'chamoisais',
    'chamoisait',
    'chamoisant',
    'chamoisas',
    'chamoisasse',
    'chamoisasses',
    'chamoise',
    'chamoisent',
    'chamoiser',
    'chamoisera',
    'chamoiserai',
    'chamoiserais',
    'chamoiserait',
    'chamoiseras',
    'chamoiserez',
    'chamoiserie',
    'chamoiseries',
    'chamoiseriez',
    'chamoiserons',
    'chamoiseront',
    'chamoises',
    'chamoisez',
    'chamoisiez',
    'chamoisions',
    'chamoisons',
    'chamoisâmes',
    'chamoisât',
    'chamoisâtes',
    'chamoisèrent',
    'chamoisé',
    'chamoisée',
    'chamoisées',
    'chamoisés',
    'champ',
    'champagne',
    'champagnes',
    'champagnisa',
    'champagnisai',
    'champagnisas',
    'champagnise',
    'champagniser',
    'champagnises',
    'champagnisez',
    'champagnisât',
    'champagnisé',
    'champagnisée',
    'champagnisés',
    'champart',
    'champarts',
    'champenois',
    'champenoise',
    'champenoises',
    'champi',
    'champignon',
    'champignons',
    'champion',
    'championnat',
    'championnats',
    'championne',
    'championnes',
    'champions',
    'champis',
    'champleva',
    'champlevai',
    'champlevais',
    'champlevait',
    'champlevant',
    'champlevas',
    'champlevasse',
    'champlever',
    'champlevez',
    'champleviez',
    'champlevions',
    'champlevons',
    'champlevâmes',
    'champlevât',
    'champlevâtes',
    'champlevé',
    'champlevée',
    'champlevées',
    'champlevés',
    'champlève',
    'champlèvent',
    'champlèvera',
    'champlèverai',
    'champlèveras',
    'champlèverez',
    'champlèves',
    'champs',
    'champêtre',
    'champêtres',
    'chamérops',
    'chance',
    'chancel',
    'chancela',
    'chancelai',
    'chancelaient',
    'chancelais',
    'chancelait',
    'chancelant',
    'chancelante',
    'chancelantes',
    'chancelants',
    'chancelas',
    'chancelasse',
    'chancelasses',
    'chanceler',
    'chancelez',
    'chancelier',
    'chanceliers',
    'chanceliez',
    'chancelions',
    'chancelière',
    'chancelières',
    'chancelle',
    'chancellent',
    'chancellera',
    'chancellerai',
    'chancelleras',
    'chancellerez',
    'chancellerie',
    'chancelles',
    'chancelons',
    'chancels',
    'chancelâmes',
    'chancelât',
    'chancelâtes',
    'chancelèrent',
    'chancelé',
    'chances',
    'chanceuse',
    'chanceuses',
    'chanceux',
    'chanci',
    'chancir',
    'chancira',
    'chancirai',
    'chanciraient',
    'chancirais',
    'chancirait',
    'chanciras',
    'chancirent',
    'chancirez',
    'chanciriez',
    'chancirions',
    'chancirons',
    'chanciront',
    'chancis',
    'chancissais',
    'chancissait',
    'chancissant',
    'chancisse',
    'chancissent',
    'chancisses',
    'chancissez',
    'chancissiez',
    'chancissions',
    'chancissons',
    'chancit',
    'chancre',
    'chancres',
    'chancîmes',
    'chancît',
    'chancîtes',
    'chandail',
    'chandails',
    'chandeleur',
    'chandeleurs',
    'chandelier',
    'chandeliers',
    'chandelle',
    'chandelles',
    'chanfrein',
    'chanfreina',
    'chanfreinai',
    'chanfreinais',
    'chanfreinait',
    'chanfreinant',
    'chanfreinas',
    'chanfreine',
    'chanfreinent',
    'chanfreiner',
    'chanfreinera',
    'chanfreines',
    'chanfreinez',
    'chanfreiniez',
    'chanfreinons',
    'chanfreins',
    'chanfreinât',
    'chanfreiné',
    'chanfreinée',
    'chanfreinées',
    'chanfreinés',
    'change',
    'changea',
    'changeable',
    'changeables',
    'changeai',
    'changeaient',
    'changeais',
    'changeait',
    'changeant',
    'changeante',
    'changeantes',
    'changeants',
    'changeas',
    'changeasse',
    'changeassent',
    'changeasses',
    'changeassiez',
    'changement',
    'changements',
    'changent',
    'changeons',
    'changer',
    'changera',
    'changerai',
    'changeraient',
    'changerais',
    'changerait',
    'changeras',
    'changerez',
    'changeriez',
    'changerions',
    'changerons',
    'changeront',
    'changes',
    'changeur',
    'changeurs',
    'changez',
    'changeâmes',
    'changeât',
    'changeâtes',
    'changiez',
    'changions',
    'changèrent',
    'changé',
    'changée',
    'changées',
    'changés',
    'chanlatte',
    'chanlattes',
    'chanoine',
    'chanoines',
    'chanoinesse',
    'chanoinesses',
    'chanson',
    'chansonna',
    'chansonnai',
    'chansonnais',
    'chansonnait',
    'chansonnant',
    'chansonnas',
    'chansonnasse',
    'chansonne',
    'chansonnent',
    'chansonner',
    'chansonnera',
    'chansonnerai',
    'chansonneras',
    'chansonnerez',
    'chansonnes',
    'chansonnette',
    'chansonnez',
    'chansonnier',
    'chansonniers',
    'chansonniez',
    'chansonnions',
    'chansonnière',
    'chansonnons',
    'chansonnâmes',
    'chansonnât',
    'chansonnâtes',
    'chansonné',
    'chansonnée',
    'chansonnées',
    'chansonnés',
    'chansons',
    'chanstiqua',
    'chanstiquai',
    'chanstiquais',
    'chanstiquait',
    'chanstiquant',
    'chanstiquas',
    'chanstique',
    'chanstiquent',
    'chanstiquer',
    'chanstiquera',
    'chanstiques',
    'chanstiquez',
    'chanstiquiez',
    'chanstiquons',
    'chanstiquât',
    'chanstiqué',
    'chanstiquée',
    'chanstiquées',
    'chanstiqués',
    'chant',
    'chanta',
    'chantage',
    'chantages',
    'chantai',
    'chantaient',
    'chantais',
    'chantait',
    'chantant',
    'chantante',
    'chantantes',
    'chantants',
    'chantas',
    'chantasse',
    'chantassent',
    'chantasses',
    'chantassiez',
    'chantassions',
    'chante',
    'chanteau',
    'chanteaux',
    'chantefable',
    'chantefables',
    'chantent',
    'chantepleure',
    'chanter',
    'chantera',
    'chanterai',
    'chanteraient',
    'chanterais',
    'chanterait',
    'chanteras',
    'chanterelle',
    'chanterelles',
    'chanterez',
    'chanteriez',
    'chanterions',
    'chanterons',
    'chanteront',
    'chantes',
    'chanteur',
    'chanteurs',
    'chanteuse',
    'chanteuses',
    'chantez',
    'chantier',
    'chantiers',
    'chantiez',
    'chantignole',
    'chantignoles',
    'chantilly',
    'chantions',
    'chantonna',
    'chantonnai',
    'chantonnais',
    'chantonnait',
    'chantonnant',
    'chantonnas',
    'chantonnasse',
    'chantonne',
    'chantonnent',
    'chantonner',
    'chantonnera',
    'chantonnerai',
    'chantonneras',
    'chantonnerez',
    'chantonnes',
    'chantonnez',
    'chantonniez',
    'chantonnions',
    'chantonnons',
    'chantonnâmes',
    'chantonnât',
    'chantonnâtes',
    'chantonné',
    'chantonnée',
    'chantonnées',
    'chantonnés',
    'chantons',
    'chantoung',
    'chantoungs',
    'chantourna',
    'chantournai',
    'chantournais',
    'chantournait',
    'chantournant',
    'chantournas',
    'chantourne',
    'chantournent',
    'chantourner',
    'chantournera',
    'chantournes',
    'chantournez',
    'chantourniez',
    'chantournons',
    'chantournât',
    'chantourné',
    'chantournée',
    'chantournées',
    'chantournés',
    'chantre',
    'chantres',
    'chants',
    'chantâmes',
    'chantât',
    'chantâtes',
    'chantèrent',
    'chanté',
    'chantée',
    'chantées',
    'chantés',
    'chanvre',
    'chanvres',
    'chanvrier',
    'chanvriers',
    'chanvrière',
    'chanvrières',
    'chançard',
    'chançarde',
    'chançardes',
    'chançards',
    'chaos',
    'chaotique',
    'chaotiques',
    'chaouch',
    'chaouchs',
    'chaparda',
    'chapardage',
    'chapardages',
    'chapardai',
    'chapardaient',
    'chapardais',
    'chapardait',
    'chapardant',
    'chapardas',
    'chapardasse',
    'chapardasses',
    'chaparde',
    'chapardent',
    'chaparder',
    'chapardera',
    'chaparderai',
    'chaparderais',
    'chaparderait',
    'chaparderas',
    'chaparderez',
    'chaparderiez',
    'chaparderons',
    'chaparderont',
    'chapardes',
    'chapardeur',
    'chapardeurs',
    'chapardeuse',
    'chapardeuses',
    'chapardez',
    'chapardiez',
    'chapardions',
    'chapardons',
    'chapardâmes',
    'chapardât',
    'chapardâtes',
    'chapardèrent',
    'chapardé',
    'chapardée',
    'chapardées',
    'chapardés',
    'chape',
    'chapeau',
    'chapeauta',
    'chapeautai',
    'chapeautais',
    'chapeautait',
    'chapeautant',
    'chapeautas',
    'chapeautasse',
    'chapeaute',
    'chapeautent',
    'chapeauter',
    'chapeautera',
    'chapeauterai',
    'chapeauteras',
    'chapeauterez',
    'chapeautes',
    'chapeautez',
    'chapeautiez',
    'chapeautions',
    'chapeautons',
    'chapeautâmes',
    'chapeautât',
    'chapeautâtes',
    'chapeauté',
    'chapeautée',
    'chapeautées',
    'chapeautés',
    'chapeaux',
    'chapela',
    'chapelai',
    'chapelaient',
    'chapelain',
    'chapelains',
    'chapelais',
    'chapelait',
    'chapelant',
    'chapelas',
    'chapelasse',
    'chapelassent',
    'chapelasses',
    'chapelassiez',
    'chapeler',
    'chapelet',
    'chapelets',
    'chapelez',
    'chapelier',
    'chapeliers',
    'chapeliez',
    'chapelions',
    'chapelière',
    'chapelières',
    'chapelle',
    'chapellenie',
    'chapellenies',
    'chapellent',
    'chapellera',
    'chapellerai',
    'chapellerais',
    'chapellerait',
    'chapelleras',
    'chapellerez',
    'chapellerie',
    'chapelleries',
    'chapelleriez',
    'chapellerons',
    'chapelleront',
    'chapelles',
    'chapelons',
    'chapelure',
    'chapelures',
    'chapelâmes',
    'chapelât',
    'chapelâtes',
    'chapelèrent',
    'chapelé',
    'chapelée',
    'chapelées',
    'chapelés',
    'chaperon',
    'chaperonna',
    'chaperonnai',
    'chaperonnais',
    'chaperonnait',
    'chaperonnant',
    'chaperonnas',
    'chaperonne',
    'chaperonnent',
    'chaperonner',
    'chaperonnera',
    'chaperonnes',
    'chaperonnez',
    'chaperonniez',
    'chaperonnons',
    'chaperonnât',
    'chaperonné',
    'chaperonnée',
    'chaperonnées',
    'chaperonnés',
    'chaperons',
    'chapes',
    'chapiteau',
    'chapiteaux',
    'chapitra',
    'chapitrai',
    'chapitraient',
    'chapitrais',
    'chapitrait',
    'chapitrant',
    'chapitras',
    'chapitrasse',
    'chapitrasses',
    'chapitre',
    'chapitrent',
    'chapitrer',
    'chapitrera',
    'chapitrerai',
    'chapitrerais',
    'chapitrerait',
    'chapitreras',
    'chapitrerez',
    'chapitreriez',
    'chapitrerons',
    'chapitreront',
    'chapitres',
    'chapitrez',
    'chapitriez',
    'chapitrions',
    'chapitrons',
    'chapitrâmes',
    'chapitrât',
    'chapitrâtes',
    'chapitrèrent',
    'chapitré',
    'chapitrée',
    'chapitrées',
    'chapitrés',
    'chaplinesque',
    'chapon',
    'chaponna',
    'chaponnai',
    'chaponnaient',
    'chaponnais',
    'chaponnait',
    'chaponnant',
    'chaponnas',
    'chaponnasse',
    'chaponnasses',
    'chaponne',
    'chaponnent',
    'chaponner',
    'chaponnera',
    'chaponnerai',
    'chaponnerais',
    'chaponnerait',
    'chaponneras',
    'chaponnerez',
    'chaponneriez',
    'chaponnerons',
    'chaponneront',
    'chaponnes',
    'chaponnez',
    'chaponniez',
    'chaponnions',
    'chaponnons',
    'chaponnâmes',
    'chaponnât',
    'chaponnâtes',
    'chaponnèrent',
    'chaponné',
    'chaponnée',
    'chaponnées',
    'chaponnés',
    'chapons',
    'chapska',
    'chapskas',
    'chaptalisa',
    'chaptalisai',
    'chaptalisais',
    'chaptalisait',
    'chaptalisant',
    'chaptalisas',
    'chaptalise',
    'chaptalisent',
    'chaptaliser',
    'chaptalisera',
    'chaptalises',
    'chaptalisez',
    'chaptalisiez',
    'chaptalisons',
    'chaptalisât',
    'chaptalisé',
    'chaptalisée',
    'chaptalisées',
    'chaptalisés',
    'chapé',
    'chapée',
    'chapées',
    'chapés',
    'chaque',
    'char',
    'charabia',
    'charabias',
    'charade',
    'charades',
    'charançon',
    'charançonné',
    'charançonnée',
    'charançonnés',
    'charançons',
    'charbon',
    'charbonna',
    'charbonnage',
    'charbonnages',
    'charbonnai',
    'charbonnais',
    'charbonnait',
    'charbonnant',
    'charbonnas',
    'charbonnasse',
    'charbonne',
    'charbonnent',
    'charbonner',
    'charbonnera',
    'charbonnerai',
    'charbonneras',
    'charbonnerez',
    'charbonnes',
    'charbonneuse',
    'charbonneux',
    'charbonnez',
    'charbonnier',
    'charbonniers',
    'charbonniez',
    'charbonnions',
    'charbonnière',
    'charbonnons',
    'charbonnâmes',
    'charbonnât',
    'charbonnâtes',
    'charbonné',
    'charbonnée',
    'charbonnées',
    'charbonnés',
    'charbons',
    'charcuta',
    'charcutai',
    'charcutaient',
    'charcutais',
    'charcutait',
    'charcutant',
    'charcutas',
    'charcutasse',
    'charcutasses',
    'charcute',
    'charcutent',
    'charcuter',
    'charcutera',
    'charcuterai',
    'charcuterais',
    'charcuterait',
    'charcuteras',
    'charcuterez',
    'charcuterie',
    'charcuteries',
    'charcuteriez',
    'charcuterons',
    'charcuteront',
    'charcutes',
    'charcutez',
    'charcutier',
    'charcutiers',
    'charcutiez',
    'charcutions',
    'charcutière',
    'charcutières',
    'charcutons',
    'charcutâmes',
    'charcutât',
    'charcutâtes',
    'charcutèrent',
    'charcuté',
    'charcutée',
    'charcutées',
    'charcutés',
    'chardon',
    'chardonneret',
    'chardons',
    'charge',
    'chargea',
    'chargeai',
    'chargeaient',
    'chargeais',
    'chargeait',
    'chargeant',
    'chargeas',
    'chargeasse',
    'chargeassent',
    'chargeasses',
    'chargeassiez',
    'chargement',
    'chargements',
    'chargent',
    'chargeons',
    'charger',
    'chargera',
    'chargerai',
    'chargeraient',
    'chargerais',
    'chargerait',
    'chargeras',
    'chargerez',
    'chargeriez',
    'chargerions',
    'chargerons',
    'chargeront',
    'charges',
    'chargeur',
    'chargeurs',
    'chargez',
    'chargeâmes',
    'chargeât',
    'chargeâtes',
    'chargiez',
    'chargions',
    'chargèrent',
    'chargé',
    'chargée',
    'chargées',
    'chargés',
    'chariot',
    'chariotage',
    'chariotages',
    'charioter',
    'chariots',
    'charisme',
    'charismes',
    'charitable',
    'charitables',
    'charité',
    'charités',
    'charivari',
    'charivaris',
    'charlatan',
    'charlatans',
    'charleston',
    'charlestons',
    'charlotte',
    'charlottes',
    'charma',
    'charmai',
    'charmaient',
    'charmais',
    'charmait',
    'charmant',
    'charmante',
    'charmantes',
    'charmants',
    'charmas',
    'charmasse',
    'charmassent',
    'charmasses',
    'charmassiez',
    'charmassions',
    'charme',
    'charment',
    'charmer',
    'charmera',
    'charmerai',
    'charmeraient',
    'charmerais',
    'charmerait',
    'charmeras',
    'charmerez',
    'charmeriez',
    'charmerions',
    'charmerons',
    'charmeront',
    'charmes',
    'charmeur',
    'charmeurs',
    'charmeuse',
    'charmeuses',
    'charmez',
    'charmiez',
    'charmille',
    'charmilles',
    'charmions',
    'charmons',
    'charmâmes',
    'charmât',
    'charmâtes',
    'charmèrent',
    'charmé',
    'charmée',
    'charmées',
    'charmés',
    'charnel',
    'charnelle',
    'charnelles',
    'charnels',
    'charnier',
    'charniers',
    'charnière',
    'charnières',
    'charnu',
    'charnue',
    'charnues',
    'charnus',
    'charognard',
    'charognards',
    'charogne',
    'charognes',
    'charpenta',
    'charpentage',
    'charpentages',
    'charpentai',
    'charpentais',
    'charpentait',
    'charpentant',
    'charpentas',
    'charpentasse',
    'charpente',
    'charpentent',
    'charpenter',
    'charpentera',
    'charpenterai',
    'charpenteras',
    'charpenterez',
    'charpenterie',
    'charpentes',
    'charpentez',
    'charpentier',
    'charpentiers',
    'charpentiez',
    'charpentions',
    'charpentons',
    'charpentâmes',
    'charpentât',
    'charpentâtes',
    'charpenté',
    'charpentée',
    'charpentées',
    'charpentés',
    'charpie',
    'charpies',
    'charretier',
    'charretiers',
    'charretin',
    'charretins',
    'charretière',
    'charretières',
    'charreton',
    'charretons',
    'charrette',
    'charrettes',
    'charretée',
    'charretées',
    'charria',
    'charriage',
    'charriages',
    'charriai',
    'charriaient',
    'charriais',
    'charriait',
    'charriant',
    'charrias',
    'charriasse',
    'charriassent',
    'charriasses',
    'charriassiez',
    'charrie',
    'charrient',
    'charrier',
    'charriera',
    'charrierai',
    'charrierais',
    'charrierait',
    'charrieras',
    'charrierez',
    'charrieriez',
    'charrierions',
    'charrierons',
    'charrieront',
    'charries',
    'charriez',
    'charriiez',
    'charriions',
    'charrions',
    'charriâmes',
    'charriât',
    'charriâtes',
    'charrièrent',
    'charrié',
    'charriée',
    'charriées',
    'charriés',
    'charroi',
    'charroie',
    'charroient',
    'charroiera',
    'charroierai',
    'charroierais',
    'charroierait',
    'charroieras',
    'charroierez',
    'charroieriez',
    'charroierons',
    'charroieront',
    'charroies',
    'charrois',
    'charron',
    'charronnage',
    'charronnages',
    'charrons',
    'charroya',
    'charroyai',
    'charroyaient',
    'charroyais',
    'charroyait',
    'charroyant',
    'charroyas',
    'charroyasse',
    'charroyasses',
    'charroyer',
    'charroyez',
    'charroyiez',
    'charroyions',
    'charroyons',
    'charroyâmes',
    'charroyât',
    'charroyâtes',
    'charroyèrent',
    'charroyé',
    'charroyée',
    'charroyées',
    'charroyés',
    'charruage',
    'charruages',
    'charrue',
    'charrues',
    'chars',
    'charte',
    'charter',
    'charters',
    'chartes',
    'chartisme',
    'chartismes',
    'chartiste',
    'chartistes',
    'chartreuse',
    'chartreuses',
    'chartreux',
    'chartrier',
    'chartriers',
    'chas',
    'chassa',
    'chassai',
    'chassaient',
    'chassais',
    'chassait',
    'chassant',
    'chassas',
    'chassasse',
    'chassassent',
    'chassasses',
    'chassassiez',
    'chassassions',
    'chasse',
    'chasselas',
    'chasseneuil',
    'chassent',
    'chassepot',
    'chassepots',
    'chasser',
    'chassera',
    'chasserai',
    'chasseraient',
    'chasserais',
    'chasserait',
    'chasseras',
    'chasseresse',
    'chasseresses',
    'chasserez',
    'chasseriez',
    'chasserions',
    'chasserons',
    'chasseront',
    'chasses',
    'chasseur',
    'chasseurs',
    'chasseuse',
    'chasseuses',
    'chassez',
    'chassie',
    'chassies',
    'chassieuse',
    'chassieuses',
    'chassieux',
    'chassiez',
    'chassions',
    'chassons',
    'chassâmes',
    'chassât',
    'chassâtes',
    'chassèrent',
    'chassé',
    'chassée',
    'chassées',
    'chassés',
    'chaste',
    'chastement',
    'chastes',
    'chasteté',
    'chastetés',
    'chasuble',
    'chasublerie',
    'chasubleries',
    'chasubles',
    'chat',
    'chatière',
    'chatières',
    'chatoie',
    'chatoiement',
    'chatoiements',
    'chatoient',
    'chatoiera',
    'chatoierai',
    'chatoierais',
    'chatoierait',
    'chatoieras',
    'chatoierez',
    'chatoieriez',
    'chatoierions',
    'chatoierons',
    'chatoieront',
    'chatoies',
    'chaton',
    'chatonna',
    'chatonnai',
    'chatonnaient',
    'chatonnais',
    'chatonnait',
    'chatonnant',
    'chatonnas',
    'chatonnasse',
    'chatonnasses',
    'chatonne',
    'chatonnent',
    'chatonner',
    'chatonnera',
    'chatonnerai',
    'chatonnerais',
    'chatonnerait',
    'chatonneras',
    'chatonnerez',
    'chatonneriez',
    'chatonnerons',
    'chatonneront',
    'chatonnes',
    'chatonnez',
    'chatonniez',
    'chatonnions',
    'chatonnons',
    'chatonnâmes',
    'chatonnât',
    'chatonnâtes',
    'chatonnèrent',
    'chatonné',
    'chatons',
    'chatouilla',
    'chatouillai',
    'chatouillais',
    'chatouillait',
    'chatouillant',
    'chatouillas',
    'chatouille',
    'chatouillent',
    'chatouiller',
    'chatouillera',
    'chatouilles',
    'chatouilleux',
    'chatouillez',
    'chatouilliez',
    'chatouillis',
    'chatouillons',
    'chatouillât',
    'chatouillé',
    'chatouillée',
    'chatouillées',
    'chatouillés',
    'chatoya',
    'chatoyai',
    'chatoyaient',
    'chatoyais',
    'chatoyait',
    'chatoyant',
    'chatoyante',
    'chatoyantes',
    'chatoyants',
    'chatoyas',
    'chatoyasse',
    'chatoyassent',
    'chatoyasses',
    'chatoyassiez',
    'chatoyer',
    'chatoyez',
    'chatoyiez',
    'chatoyions',
    'chatoyons',
    'chatoyâmes',
    'chatoyât',
    'chatoyâtes',
    'chatoyèrent',
    'chatoyé',
    'chats',
    'chatte',
    'chattemite',
    'chattemites',
    'chatterie',
    'chatteries',
    'chatterton',
    'chattertons',
    'chattes',
    'chaud',
    'chaude',
    'chaudeau',
    'chaudeaux',
    'chaudement',
    'chaudes',
    'chaudière',
    'chaudières',
    'chaudron',
    'chaudronnier',
    'chaudrons',
    'chauds',
    'chauffa',
    'chauffage',
    'chauffages',
    'chauffagiste',
    'chauffai',
    'chauffaient',
    'chauffais',
    'chauffait',
    'chauffant',
    'chauffante',
    'chauffantes',
    'chauffants',
    'chauffard',
    'chauffards',
    'chauffas',
    'chauffasse',
    'chauffassent',
    'chauffasses',
    'chauffassiez',
    'chauffe',
    'chauffent',
    'chauffer',
    'chauffera',
    'chaufferai',
    'chaufferais',
    'chaufferait',
    'chaufferas',
    'chaufferette',
    'chaufferez',
    'chaufferie',
    'chaufferies',
    'chaufferiez',
    'chaufferions',
    'chaufferons',
    'chaufferont',
    'chauffes',
    'chauffeur',
    'chauffeurs',
    'chauffeuse',
    'chauffeuses',
    'chauffez',
    'chauffiez',
    'chauffions',
    'chauffons',
    'chauffâmes',
    'chauffât',
    'chauffâtes',
    'chauffèrent',
    'chauffé',
    'chauffée',
    'chauffées',
    'chauffés',
    'chaufour',
    'chaufournier',
    'chaufours',
    'chaula',
    'chaulage',
    'chaulages',
    'chaulai',
    'chaulaient',
    'chaulais',
    'chaulait',
    'chaulant',
    'chaulas',
    'chaulasse',
    'chaulassent',
    'chaulasses',
    'chaulassiez',
    'chaulassions',
    'chaule',
    'chaulent',
    'chauler',
    'chaulera',
    'chaulerai',
    'chauleraient',
    'chaulerais',
    'chaulerait',
    'chauleras',
    'chaulerez',
    'chauleriez',
    'chaulerions',
    'chaulerons',
    'chauleront',
    'chaules',
    'chauleuse',
    'chauleuses',
    'chaulez',
    'chauliez',
    'chaulions',
    'chaulons',
    'chaulâmes',
    'chaulât',
    'chaulâtes',
    'chaulèrent',
    'chaulé',
    'chaulée',
    'chaulées',
    'chaulés',
    'chauma',
    'chaumai',
    'chaumaient',
    'chaumais',
    'chaumait',
    'chaumant',
    'chaumas',
    'chaumasse',
    'chaumassent',
    'chaumasses',
    'chaumassiez',
    'chaumassions',
    'chaume',
    'chaument',
    'chaumer',
    'chaumera',
    'chaumerai',
    'chaumeraient',
    'chaumerais',
    'chaumerait',
    'chaumeras',
    'chaumerez',
    'chaumeriez',
    'chaumerions',
    'chaumerons',
    'chaumeront',
    'chaumes',
    'chaumez',
    'chaumiez',
    'chaumine',
    'chaumines',
    'chaumions',
    'chaumière',
    'chaumières',
    'chaumons',
    'chaumâmes',
    'chaumât',
    'chaumâtes',
    'chaumèrent',
    'chaumé',
    'chaumée',
    'chaumées',
    'chaumés',
    'chaussa',
    'chaussai',
    'chaussaient',
    'chaussais',
    'chaussait',
    'chaussant',
    'chaussante',
    'chaussantes',
    'chaussants',
    'chaussas',
    'chaussasse',
    'chaussassent',
    'chaussasses',
    'chaussassiez',
    'chausse',
    'chaussent',
    'chausser',
    'chaussera',
    'chausserai',
    'chausserais',
    'chausserait',
    'chausseras',
    'chausserez',
    'chausseriez',
    'chausserions',
    'chausserons',
    'chausseront',
    'chausses',
    'chaussette',
    'chaussettes',
    'chausseur',
    'chausseurs',
    'chaussez',
    'chaussiez',
    'chaussions',
    'chausson',
    'chaussons',
    'chaussure',
    'chaussures',
    'chaussâmes',
    'chaussât',
    'chaussâtes',
    'chaussèrent',
    'chaussé',
    'chaussée',
    'chaussées',
    'chaussés',
    'chaut',
    'chauve',
    'chauves',
    'chauvi',
    'chauvin',
    'chauvine',
    'chauvines',
    'chauvinisme',
    'chauvinismes',
    'chauvins',
    'chauvir',
    'chauvira',
    'chauvirai',
    'chauviraient',
    'chauvirais',
    'chauvirait',
    'chauviras',
    'chauvirent',
    'chauvirez',
    'chauviriez',
    'chauvirions',
    'chauvirons',
    'chauviront',
    'chauvis',
    'chauvissais',
    'chauvissait',
    'chauvissant',
    'chauvisse',
    'chauvissent',
    'chauvisses',
    'chauvissez',
    'chauvissiez',
    'chauvissions',
    'chauvissons',
    'chauvit',
    'chauvîmes',
    'chauvît',
    'chauvîtes',
    'chaux',
    'chavira',
    'chavirai',
    'chaviraient',
    'chavirais',
    'chavirait',
    'chavirant',
    'chaviras',
    'chavirasse',
    'chavirassent',
    'chavirasses',
    'chavirassiez',
    'chavire',
    'chavirement',
    'chavirements',
    'chavirent',
    'chavirer',
    'chavirera',
    'chavirerai',
    'chavirerais',
    'chavirerait',
    'chavireras',
    'chavirerez',
    'chavireriez',
    'chavirerions',
    'chavirerons',
    'chavireront',
    'chavires',
    'chavirez',
    'chaviriez',
    'chavirions',
    'chavirons',
    'chavirâmes',
    'chavirât',
    'chavirâtes',
    'chavirèrent',
    'chaviré',
    'chavirée',
    'chavirées',
    'chavirés',
    'chaîna',
    'chaînage',
    'chaînages',
    'chaînai',
    'chaînaient',
    'chaînais',
    'chaînait',
    'chaînant',
    'chaînas',
    'chaînasse',
    'chaînassent',
    'chaînasses',
    'chaînassiez',
    'chaînassions',
    'chaîne',
    'chaînent',
    'chaîner',
    'chaînera',
    'chaînerai',
    'chaîneraient',
    'chaînerais',
    'chaînerait',
    'chaîneras',
    'chaînerez',
    'chaîneriez',
    'chaînerions',
    'chaînerons',
    'chaîneront',
    'chaînes',
    'chaînette',
    'chaînettes',
    'chaîneur',
    'chaîneurs',
    'chaîneuse',
    'chaîneuses',
    'chaînez',
    'chaînier',
    'chaîniers',
    'chaîniez',
    'chaînions',
    'chaîniste',
    'chaînistes',
    'chaînon',
    'chaînons',
    'chaînâmes',
    'chaînât',
    'chaînâtes',
    'chaînèrent',
    'chaîné',
    'chaînée',
    'chaînées',
    'chaînés',
    'check',
    'checks',
    'cheddite',
    'cheddites',
    'chef',
    'cheffe',
    'chefferie',
    'chefferies',
    'cheffes',
    'chefs',
    'cheftaine',
    'cheftaines',
    'cheik',
    'cheikh',
    'cheikhs',
    'cheiks',
    'cheire',
    'cheires',
    'chelem',
    'chelems',
    'chelingua',
    'chelinguai',
    'chelinguais',
    'chelinguait',
    'chelinguant',
    'chelinguas',
    'chelinguasse',
    'chelingue',
    'chelinguent',
    'chelinguer',
    'chelinguera',
    'chelinguerai',
    'chelingueras',
    'chelinguerez',
    'chelingues',
    'chelinguez',
    'chelinguiez',
    'chelinguions',
    'chelinguons',
    'chelinguâmes',
    'chelinguât',
    'chelinguâtes',
    'chelingué',
    'chelinguée',
    'chelinguées',
    'chelingués',
    'chelléen',
    'chelléenne',
    'chelléennes',
    'chelléens',
    'chemin',
    'chemina',
    'cheminai',
    'cheminaient',
    'cheminais',
    'cheminait',
    'cheminant',
    'cheminas',
    'cheminasse',
    'cheminassent',
    'cheminasses',
    'cheminassiez',
    'chemine',
    'cheminement',
    'cheminements',
    'cheminent',
    'cheminer',
    'cheminera',
    'cheminerai',
    'cheminerais',
    'cheminerait',
    'chemineras',
    'cheminerez',
    'chemineriez',
    'cheminerions',
    'cheminerons',
    'chemineront',
    'chemines',
    'cheminez',
    'cheminiez',
    'cheminions',
    'cheminons',
    'cheminot',
    'cheminots',
    'chemins',
    'cheminâmes',
    'cheminât',
    'cheminâtes',
    'cheminèrent',
    'cheminé',
    'cheminée',
    'cheminées',
    'chemisa',
    'chemisage',
    'chemisages',
    'chemisai',
    'chemisaient',
    'chemisais',
    'chemisait',
    'chemisant',
    'chemisas',
    'chemisasse',
    'chemisassent',
    'chemisasses',
    'chemisassiez',
    'chemise',
    'chemisent',
    'chemiser',
    'chemisera',
    'chemiserai',
    'chemiserais',
    'chemiserait',
    'chemiseras',
    'chemiserez',
    'chemiserie',
    'chemiseries',
    'chemiseriez',
    'chemiserions',
    'chemiserons',
    'chemiseront',
    'chemises',
    'chemisette',
    'chemisettes',
    'chemisez',
    'chemisier',
    'chemisiers',
    'chemisiez',
    'chemisions',
    'chemisière',
    'chemisières',
    'chemisons',
    'chemisâmes',
    'chemisât',
    'chemisâtes',
    'chemisèrent',
    'chemisé',
    'chemisée',
    'chemisées',
    'chemisés',
    'chenal',
    'chenapan',
    'chenapans',
    'chenaux',
    'chenet',
    'chenets',
    'chenil',
    'chenille',
    'chenilles',
    'chenillette',
    'chenillettes',
    'chenillé',
    'chenillée',
    'chenillées',
    'chenillés',
    'chenils',
    'chenu',
    'chenue',
    'chenues',
    'chenus',
    'cheptel',
    'cheptels',
    'cher',
    'chercha',
    'cherchai',
    'cherchaient',
    'cherchais',
    'cherchait',
    'cherchant',
    'cherchas',
    'cherchasse',
    'cherchassent',
    'cherchasses',
    'cherchassiez',
    'cherche',
    'cherchent',
    'chercher',
    'cherchera',
    'chercherai',
    'chercherais',
    'chercherait',
    'chercheras',
    'chercherez',
    'chercheriez',
    'chercherions',
    'chercherons',
    'chercheront',
    'cherches',
    'chercheur',
    'chercheurs',
    'chercheuse',
    'chercheuses',
    'cherchez',
    'cherchiez',
    'cherchions',
    'cherchons',
    'cherchâmes',
    'cherchât',
    'cherchâtes',
    'cherchèrent',
    'cherché',
    'cherchée',
    'cherchées',
    'cherchés',
    'chergui',
    'cherguis',
    'cherra',
    'cherrai',
    'cherraient',
    'cherrais',
    'cherrait',
    'cherrant',
    'cherras',
    'cherrasse',
    'cherrassent',
    'cherrasses',
    'cherrassiez',
    'cherrassions',
    'cherre',
    'cherrent',
    'cherrer',
    'cherrera',
    'cherrerai',
    'cherreraient',
    'cherrerais',
    'cherrerait',
    'cherreras',
    'cherrerez',
    'cherreriez',
    'cherrerions',
    'cherrerons',
    'cherreront',
    'cherres',
    'cherrez',
    'cherriez',
    'cherrions',
    'cherrons',
    'cherrâmes',
    'cherrât',
    'cherrâtes',
    'cherrèrent',
    'cherré',
    'chers',
    'cherté',
    'chertés',
    'chervis',
    'chester',
    'chesters',
    'cheval',
    'chevala',
    'chevalai',
    'chevalaient',
    'chevalais',
    'chevalait',
    'chevalant',
    'chevalas',
    'chevalasse',
    'chevalassent',
    'chevalasses',
    'chevalassiez',
    'chevale',
    'chevalement',
    'chevalements',
    'chevalent',
    'chevaler',
    'chevalera',
    'chevalerai',
    'chevalerais',
    'chevalerait',
    'chevaleras',
    'chevalerez',
    'chevalerie',
    'chevaleries',
    'chevaleriez',
    'chevalerions',
    'chevalerons',
    'chevaleront',
    'chevales',
    'chevalet',
    'chevalets',
    'chevalez',
    'chevalier',
    'chevaliers',
    'chevaliez',
    'chevalin',
    'chevaline',
    'chevalines',
    'chevalins',
    'chevalions',
    'chevalière',
    'chevalières',
    'chevalons',
    'chevalâmes',
    'chevalât',
    'chevalâtes',
    'chevalèrent',
    'chevalé',
    'chevalée',
    'chevalées',
    'chevalés',
    'chevaucha',
    'chevauchai',
    'chevauchais',
    'chevauchait',
    'chevauchant',
    'chevauchas',
    'chevauchasse',
    'chevauche',
    'chevauchent',
    'chevaucher',
    'chevauchera',
    'chevaucherai',
    'chevaucheras',
    'chevaucherez',
    'chevauches',
    'chevauchez',
    'chevauchiez',
    'chevauchions',
    'chevauchons',
    'chevauchâmes',
    'chevauchât',
    'chevauchâtes',
    'chevauché',
    'chevauchée',
    'chevauchées',
    'chevauchés',
    'chevaux',
    'chevelu',
    'chevelue',
    'chevelues',
    'chevelure',
    'chevelures',
    'chevelus',
    'chevet',
    'chevets',
    'cheveu',
    'cheveux',
    'chevilla',
    'chevillai',
    'chevillaient',
    'chevillais',
    'chevillait',
    'chevillant',
    'chevillard',
    'chevillards',
    'chevillas',
    'chevillasse',
    'chevillasses',
    'cheville',
    'chevillent',
    'cheviller',
    'chevillera',
    'chevillerai',
    'chevillerais',
    'chevillerait',
    'chevilleras',
    'chevillerez',
    'chevilleriez',
    'chevillerons',
    'chevilleront',
    'chevilles',
    'chevillez',
    'chevilliez',
    'chevillions',
    'chevillons',
    'chevillâmes',
    'chevillât',
    'chevillâtes',
    'chevillèrent',
    'chevillé',
    'chevillée',
    'chevillées',
    'chevillés',
    'cheviotte',
    'cheviottes',
    'chevreau',
    'chevreaux',
    'chevreta',
    'chevretai',
    'chevretaient',
    'chevretais',
    'chevretait',
    'chevretant',
    'chevretas',
    'chevretasse',
    'chevretasses',
    'chevreter',
    'chevretez',
    'chevretiez',
    'chevretions',
    'chevretons',
    'chevrette',
    'chevrettent',
    'chevretter',
    'chevrettera',
    'chevretterai',
    'chevretteras',
    'chevretterez',
    'chevrettes',
    'chevretâmes',
    'chevretât',
    'chevretâtes',
    'chevretèrent',
    'chevreté',
    'chevreuil',
    'chevreuils',
    'chevrier',
    'chevriers',
    'chevrière',
    'chevrières',
    'chevron',
    'chevronna',
    'chevronnai',
    'chevronnais',
    'chevronnait',
    'chevronnant',
    'chevronnas',
    'chevronnasse',
    'chevronne',
    'chevronnent',
    'chevronner',
    'chevronnera',
    'chevronnerai',
    'chevronneras',
    'chevronnerez',
    'chevronnes',
    'chevronnez',
    'chevronniez',
    'chevronnions',
    'chevronnons',
    'chevronnâmes',
    'chevronnât',
    'chevronnâtes',
    'chevronné',
    'chevronnée',
    'chevronnées',
    'chevronnés',
    'chevrons',
    'chevrota',
    'chevrotai',
    'chevrotaient',
    'chevrotais',
    'chevrotait',
    'chevrotant',
    'chevrotante',
    'chevrotantes',
    'chevrotants',
    'chevrotas',
    'chevrotasse',
    'chevrotasses',
    'chevrote',
    'chevrotement',
    'chevrotent',
    'chevroter',
    'chevrotera',
    'chevroterai',
    'chevroterais',
    'chevroterait',
    'chevroteras',
    'chevroterez',
    'chevroteriez',
    'chevroterons',
    'chevroteront',
    'chevrotes',
    'chevrotez',
    'chevrotiez',
    'chevrotin',
    'chevrotine',
    'chevrotines',
    'chevrotins',
    'chevrotions',
    'chevrotons',
    'chevrotâmes',
    'chevrotât',
    'chevrotâtes',
    'chevrotèrent',
    'chevroté',
    'chevêche',
    'chevêches',
    'chevêtre',
    'chevêtres',
    'chez',
    'chia',
    'chiada',
    'chiadai',
    'chiadaient',
    'chiadais',
    'chiadait',
    'chiadant',
    'chiadas',
    'chiadasse',
    'chiadassent',
    'chiadasses',
    'chiadassiez',
    'chiadassions',
    'chiade',
    'chiadent',
    'chiader',
    'chiadera',
    'chiaderai',
    'chiaderaient',
    'chiaderais',
    'chiaderait',
    'chiaderas',
    'chiaderez',
    'chiaderiez',
    'chiaderions',
    'chiaderons',
    'chiaderont',
    'chiades',
    'chiadez',
    'chiadiez',
    'chiadions',
    'chiadons',
    'chiadâmes',
    'chiadât',
    'chiadâtes',
    'chiadèrent',
    'chiadé',
    'chiadée',
    'chiadées',
    'chiadés',
    'chiai',
    'chiaient',
    'chiais',
    'chiait',
    'chiala',
    'chialai',
    'chialaient',
    'chialais',
    'chialait',
    'chialant',
    'chialas',
    'chialasse',
    'chialassent',
    'chialasses',
    'chialassiez',
    'chialassions',
    'chiale',
    'chialent',
    'chialer',
    'chialera',
    'chialerai',
    'chialeraient',
    'chialerais',
    'chialerait',
    'chialeras',
    'chialerez',
    'chialeriez',
    'chialerions',
    'chialerons',
    'chialeront',
    'chiales',
    'chialez',
    'chialiez',
    'chialions',
    'chialons',
    'chialâmes',
    'chialât',
    'chialâtes',
    'chialèrent',
    'chialé',
    'chiant',
    'chiante',
    'chiantes',
    'chianti',
    'chiantis',
    'chiants',
    'chias',
    'chiasma',
    'chiasmas',
    'chiasme',
    'chiasmes',
    'chiasse',
    'chiassent',
    'chiasses',
    'chiassiez',
    'chiassions',
    'chibouque',
    'chibouques',
    'chic',
    'chicana',
    'chicanai',
    'chicanaient',
    'chicanais',
    'chicanait',
    'chicanant',
    'chicanas',
    'chicanasse',
    'chicanassent',
    'chicanasses',
    'chicanassiez',
    'chicane',
    'chicanent',
    'chicaner',
    'chicanera',
    'chicanerai',
    'chicanerais',
    'chicanerait',
    'chicaneras',
    'chicanerez',
    'chicanerie',
    'chicaneries',
    'chicaneriez',
    'chicanerions',
    'chicanerons',
    'chicaneront',
    'chicanes',
    'chicaneur',
    'chicaneurs',
    'chicaneuse',
    'chicaneuses',
    'chicanez',
    'chicanier',
    'chicaniers',
    'chicaniez',
    'chicanions',
    'chicanière',
    'chicanières',
    'chicanons',
    'chicanâmes',
    'chicanât',
    'chicanâtes',
    'chicanèrent',
    'chicané',
    'chicanée',
    'chicanées',
    'chicanés',
    'chiche',
    'chichement',
    'chiches',
    'chichi',
    'chichis',
    'chichiteuse',
    'chichiteuses',
    'chichiteux',
    'chicon',
    'chicons',
    'chicorée',
    'chicorées',
    'chicot',
    'chicota',
    'chicotai',
    'chicotaient',
    'chicotais',
    'chicotait',
    'chicotant',
    'chicotas',
    'chicotasse',
    'chicotassent',
    'chicotasses',
    'chicotassiez',
    'chicote',
    'chicotent',
    'chicoter',
    'chicotera',
    'chicoterai',
    'chicoterais',
    'chicoterait',
    'chicoteras',
    'chicoterez',
    'chicoteriez',
    'chicoterions',
    'chicoterons',
    'chicoteront',
    'chicotes',
    'chicotez',
    'chicotiez',
    'chicotin',
    'chicotins',
    'chicotions',
    'chicotons',
    'chicots',
    'chicotâmes',
    'chicotât',
    'chicotâtes',
    'chicotèrent',
    'chicoté',
    'chics',
    'chie',
    'chien',
    'chiendent',
    'chiendents',
    'chienlit',
    'chienlits',
    'chienna',
    'chiennai',
    'chiennaient',
    'chiennais',
    'chiennait',
    'chiennant',
    'chiennas',
    'chiennasse',
    'chiennassent',
    'chiennasses',
    'chiennassiez',
    'chienne',
    'chiennent',
    'chienner',
    'chiennera',
    'chiennerai',
    'chiennerais',
    'chiennerait',
    'chienneras',
    'chiennerez',
    'chiennerie',
    'chienneries',
    'chienneriez',
    'chiennerions',
    'chiennerons',
    'chienneront',
    'chiennes',
    'chiennez',
    'chienniez',
    'chiennions',
    'chiennons',
    'chiennâmes',
    'chiennât',
    'chiennâtes',
    'chiennèrent',
    'chienné',
    'chiens',
    'chient',
    'chier',
    'chiera',
    'chierai',
    'chieraient',
    'chierais',
    'chierait',
    'chieras',
    'chierez',
    'chierie',
    'chieries',
    'chieriez',
    'chierions',
    'chierons',
    'chieront',
    'chies',
    'chiez',
    'chiffe',
    'chiffes',
    'chiffon',
    'chiffonna',
    'chiffonnade',
    'chiffonnades',
    'chiffonnage',
    'chiffonnages',
    'chiffonnai',
    'chiffonnais',
    'chiffonnait',
    'chiffonnant',
    'chiffonnas',
    'chiffonnasse',
    'chiffonne',
    'chiffonnent',
    'chiffonner',
    'chiffonnera',
    'chiffonnerai',
    'chiffonneras',
    'chiffonnerez',
    'chiffonnes',
    'chiffonnez',
    'chiffonnier',
    'chiffonniers',
    'chiffonniez',
    'chiffonnions',
    'chiffonnière',
    'chiffonnons',
    'chiffonnâmes',
    'chiffonnât',
    'chiffonnâtes',
    'chiffonné',
    'chiffonnée',
    'chiffonnées',
    'chiffonnés',
    'chiffons',
    'chiffra',
    'chiffrable',
    'chiffrables',
    'chiffrage',
    'chiffrages',
    'chiffrai',
    'chiffraient',
    'chiffrais',
    'chiffrait',
    'chiffrant',
    'chiffras',
    'chiffrasse',
    'chiffrassent',
    'chiffrasses',
    'chiffrassiez',
    'chiffre',
    'chiffrement',
    'chiffrements',
    'chiffrent',
    'chiffrer',
    'chiffrera',
    'chiffrerai',
    'chiffrerais',
    'chiffrerait',
    'chiffreras',
    'chiffrerez',
    'chiffreriez',
    'chiffrerions',
    'chiffrerons',
    'chiffreront',
    'chiffres',
    'chiffreur',
    'chiffreurs',
    'chiffreuse',
    'chiffreuses',
    'chiffrez',
    'chiffrier',
    'chiffriers',
    'chiffriez',
    'chiffrions',
    'chiffrons',
    'chiffrâmes',
    'chiffrât',
    'chiffrâtes',
    'chiffrèrent',
    'chiffré',
    'chiffrée',
    'chiffrées',
    'chiffrés',
    'chignole',
    'chignoles',
    'chignon',
    'chignons',
    'chiiez',
    'chiions',
    'chiite',
    'chiites',
    'chilien',
    'chilienne',
    'chiliennes',
    'chiliens',
    'chimie',
    'chimies',
    'chimique',
    'chimiquement',
    'chimiques',
    'chimisme',
    'chimismes',
    'chimiste',
    'chimistes',
    'chimpanzé',
    'chimpanzés',
    'chimère',
    'chimères',
    'chimérique',
    'chimériques',
    'china',
    'chinage',
    'chinages',
    'chinai',
    'chinaient',
    'chinais',
    'chinait',
    'chinant',
    'chinas',
    'chinasse',
    'chinassent',
    'chinasses',
    'chinassiez',
    'chinassions',
    'chinchilla',
    'chinchillas',
    'chine',
    'chinent',
    'chiner',
    'chinera',
    'chinerai',
    'chineraient',
    'chinerais',
    'chinerait',
    'chineras',
    'chinerez',
    'chineriez',
    'chinerions',
    'chinerons',
    'chineront',
    'chines',
    'chineur',
    'chineurs',
    'chineuse',
    'chineuses',
    'chinez',
    'chiniez',
    'chinions',
    'chinois',
    'chinoisa',
    'chinoisai',
    'chinoisaient',
    'chinoisais',
    'chinoisait',
    'chinoisant',
    'chinoisas',
    'chinoisasse',
    'chinoisasses',
    'chinoise',
    'chinoisent',
    'chinoiser',
    'chinoisera',
    'chinoiserai',
    'chinoiserais',
    'chinoiserait',
    'chinoiseras',
    'chinoiserez',
    'chinoiserie',
    'chinoiseries',
    'chinoiseriez',
    'chinoiserons',
    'chinoiseront',
    'chinoises',
    'chinoisez',
    'chinoisiez',
    'chinoisions',
    'chinoisons',
    'chinoisâmes',
    'chinoisât',
    'chinoisâtes',
    'chinoisèrent',
    'chinoisé',
    'chinons',
    'chinook',
    'chinooks',
    'chintz',
    'chinure',
    'chinures',
    'chinâmes',
    'chinât',
    'chinâtes',
    'chinèrent',
    'chiné',
    'chinée',
    'chinées',
    'chinés',
    'chions',
    'chiot',
    'chiots',
    'chiottes',
    'chiourme',
    'chiourmes',
    'chipa',
    'chipai',
    'chipaient',
    'chipais',
    'chipait',
    'chipant',
    'chipas',
    'chipasse',
    'chipassent',
    'chipasses',
    'chipassiez',
    'chipassions',
    'chipe',
    'chipent',
    'chiper',
    'chipera',
    'chiperai',
    'chiperaient',
    'chiperais',
    'chiperait',
    'chiperas',
    'chiperez',
    'chiperiez',
    'chiperions',
    'chiperons',
    'chiperont',
    'chipes',
    'chipez',
    'chipie',
    'chipies',
    'chipiez',
    'chipions',
    'chipolata',
    'chipolatas',
    'chipons',
    'chipota',
    'chipotage',
    'chipotages',
    'chipotai',
    'chipotaient',
    'chipotais',
    'chipotait',
    'chipotant',
    'chipotas',
    'chipotasse',
    'chipotassent',
    'chipotasses',
    'chipotassiez',
    'chipote',
    'chipotent',
    'chipoter',
    'chipotera',
    'chipoterai',
    'chipoterais',
    'chipoterait',
    'chipoteras',
    'chipoterez',
    'chipoteriez',
    'chipoterions',
    'chipoterons',
    'chipoteront',
    'chipotes',
    'chipoteur',
    'chipoteurs',
    'chipoteuse',
    'chipoteuses',
    'chipotez',
    'chipotiez',
    'chipotions',
    'chipotons',
    'chipotâmes',
    'chipotât',
    'chipotâtes',
    'chipotèrent',
    'chipoté',
    'chipotée',
    'chipotées',
    'chipotés',
    'chips',
    'chipâmes',
    'chipât',
    'chipâtes',
    'chipèrent',
    'chipé',
    'chipée',
    'chipées',
    'chipés',
    'chiqua',
    'chiquai',
    'chiquaient',
    'chiquais',
    'chiquait',
    'chiquant',
    'chiquas',
    'chiquasse',
    'chiquassent',
    'chiquasses',
    'chiquassiez',
    'chiquassions',
    'chique',
    'chiquement',
    'chiquenaude',
    'chiquenaudes',
    'chiquent',
    'chiquer',
    'chiquera',
    'chiquerai',
    'chiqueraient',
    'chiquerais',
    'chiquerait',
    'chiqueras',
    'chiquerez',
    'chiqueriez',
    'chiquerions',
    'chiquerons',
    'chiqueront',
    'chiques',
    'chiqueur',
    'chiqueurs',
    'chiqueuse',
    'chiqueuses',
    'chiquez',
    'chiquiez',
    'chiquions',
    'chiquons',
    'chiquâmes',
    'chiquât',
    'chiquâtes',
    'chiquèrent',
    'chiqué',
    'chiquée',
    'chiquées',
    'chiqués',
    'chirographia',
    'chirographie',
    'chirographié',
    'chiromancie',
    'chiromancien',
    'chiromancies',
    'chiropractie',
    'chiropraxie',
    'chiropraxies',
    'chirurgical',
    'chirurgicale',
    'chirurgicaux',
    'chirurgie',
    'chirurgien',
    'chirurgienne',
    'chirurgiens',
    'chirurgies',
    'chistera',
    'chisteras',
    'chitine',
    'chitines',
    'chitineuse',
    'chitineuses',
    'chitineux',
    'chiton',
    'chitons',
    'chiure',
    'chiures',
    'chiâmes',
    'chiât',
    'chiâtes',
    'chièrent',
    'chié',
    'chiée',
    'chiées',
    'chiés',
    'chlamyde',
    'chlamydes',
    'chleuhe',
    'chleuhes',
    'chlingua',
    'chlinguai',
    'chlinguaient',
    'chlinguais',
    'chlinguait',
    'chlinguant',
    'chlinguas',
    'chlinguasse',
    'chlinguasses',
    'chlingue',
    'chlinguent',
    'chlinguer',
    'chlinguera',
    'chlinguerai',
    'chlinguerais',
    'chlinguerait',
    'chlingueras',
    'chlinguerez',
    'chlingueriez',
    'chlinguerons',
    'chlingueront',
    'chlingues',
    'chlinguez',
    'chlinguiez',
    'chlinguions',
    'chlinguons',
    'chlinguâmes',
    'chlinguât',
    'chlinguâtes',
    'chlinguèrent',
    'chlingué',
    'chlinguée',
    'chlinguées',
    'chlingués',
    'chlora',
    'chlorai',
    'chloraient',
    'chlorais',
    'chlorait',
    'chloral',
    'chlorals',
    'chlorant',
    'chloras',
    'chlorasse',
    'chlorassent',
    'chlorasses',
    'chlorassiez',
    'chlorassions',
    'chlorate',
    'chlorates',
    'chlore',
    'chlorent',
    'chlorer',
    'chlorera',
    'chlorerai',
    'chloreraient',
    'chlorerais',
    'chlorerait',
    'chloreras',
    'chlorerez',
    'chloreriez',
    'chlorerions',
    'chlorerons',
    'chloreront',
    'chlores',
    'chlorez',
    'chlorhydrate',
    'chloriez',
    'chlorions',
    'chlorique',
    'chloriques',
    'chloroforma',
    'chloroformai',
    'chloroformas',
    'chloroforme',
    'chloroformer',
    'chloroformes',
    'chloroformez',
    'chloroformât',
    'chloroformé',
    'chloroformée',
    'chloroformés',
    'chlorons',
    'chlorophylle',
    'chlorose',
    'chloroses',
    'chlorotique',
    'chlorotiques',
    'chlorura',
    'chlorurai',
    'chloruraient',
    'chlorurais',
    'chlorurait',
    'chlorurant',
    'chloruras',
    'chlorurasse',
    'chlorurasses',
    'chlorure',
    'chlorurent',
    'chlorurer',
    'chlorurera',
    'chlorurerai',
    'chlorurerais',
    'chlorurerait',
    'chlorureras',
    'chlorurerez',
    'chlorureriez',
    'chlorurerons',
    'chlorureront',
    'chlorures',
    'chlorurez',
    'chloruriez',
    'chlorurions',
    'chlorurons',
    'chlorurâmes',
    'chlorurât',
    'chlorurâtes',
    'chlorurèrent',
    'chloruré',
    'chlorurée',
    'chlorurées',
    'chlorurés',
    'chlorâmes',
    'chlorât',
    'chlorâtes',
    'chlorèrent',
    'chloré',
    'chlorée',
    'chlorées',
    'chlorés',
    'choc',
    'chochotte',
    'chochottes',
    'chocolat',
    'chocolaterie',
    'chocolatier',
    'chocolatiers',
    'chocolatière',
    'chocolats',
    'chocolaté',
    'chocolatée',
    'chocolatées',
    'chocolatés',
    'chocottes',
    'chocs',
    'choeur',
    'choeurs',
    'choie',
    'choient',
    'choiera',
    'choierai',
    'choieraient',
    'choierais',
    'choierait',
    'choieras',
    'choierez',
    'choieriez',
    'choierions',
    'choierons',
    'choieront',
    'choies',
    'choir',
    'choirai',
    'choirais',
    'chois',
    'choisi',
    'choisie',
    'choisies',
    'choisir',
    'choisira',
    'choisirai',
    'choisiraient',
    'choisirais',
    'choisirait',
    'choisiras',
    'choisirent',
    'choisirez',
    'choisiriez',
    'choisirions',
    'choisirons',
    'choisiront',
    'choisis',
    'choisissais',
    'choisissait',
    'choisissant',
    'choisisse',
    'choisissent',
    'choisisses',
    'choisissez',
    'choisissiez',
    'choisissions',
    'choisissons',
    'choisit',
    'choisîmes',
    'choisît',
    'choisîtes',
    'choit',
    'choix',
    'cholagogue',
    'cholagogues',
    'cholestérol',
    'cholestérols',
    'choline',
    'cholines',
    'cholurie',
    'choluries',
    'cholécystite',
    'cholédoque',
    'cholédoques',
    'cholémie',
    'cholémies',
    'choléra',
    'choléras',
    'cholériforme',
    'cholérine',
    'cholérines',
    'cholérique',
    'cholériques',
    'chondriome',
    'chondriomes',
    'chondriosome',
    'chopa',
    'chopai',
    'chopaient',
    'chopais',
    'chopait',
    'chopant',
    'chopas',
    'chopasse',
    'chopassent',
    'chopasses',
    'chopassiez',
    'chopassions',
    'chope',
    'chopent',
    'choper',
    'chopera',
    'choperai',
    'choperaient',
    'choperais',
    'choperait',
    'choperas',
    'choperez',
    'choperiez',
    'choperions',
    'choperons',
    'choperont',
    'chopes',
    'chopez',
    'chopiez',
    'chopina',
    'chopinai',
    'chopinaient',
    'chopinais',
    'chopinait',
    'chopinant',
    'chopinas',
    'chopinasse',
    'chopinassent',
    'chopinasses',
    'chopinassiez',
    'chopine',
    'chopinent',
    'chopiner',
    'chopinera',
    'chopinerai',
    'chopinerais',
    'chopinerait',
    'chopineras',
    'chopinerez',
    'chopineriez',
    'chopinerions',
    'chopinerons',
    'chopineront',
    'chopines',
    'chopinez',
    'chopiniez',
    'chopinions',
    'chopinons',
    'chopinâmes',
    'chopinât',
    'chopinâtes',
    'chopinèrent',
    'chopiné',
    'chopions',
    'chopons',
    'choppa',
    'choppai',
    'choppaient',
    'choppais',
    'choppait',
    'choppant',
    'choppas',
    'choppasse',
    'choppassent',
    'choppasses',
    'choppassiez',
    'choppassions',
    'choppe',
    'choppent',
    'chopper',
    'choppera',
    'chopperai',
    'chopperaient',
    'chopperais',
    'chopperait',
    'chopperas',
    'chopperez',
    'chopperiez',
    'chopperions',
    'chopperons',
    'chopperont',
    'choppes',
    'choppez',
    'choppiez',
    'choppions',
    'choppons',
    'choppâmes',
    'choppât',
    'choppâtes',
    'choppèrent',
    'choppé',
    'chopâmes',
    'chopât',
    'chopâtes',
    'chopèrent',
    'chopé',
    'chopée',
    'chopées',
    'chopés',
    'choqua',
    'choquai',
    'choquaient',
    'choquais',
    'choquait',
    'choquant',
    'choquante',
    'choquantes',
    'choquants',
    'choquas',
    'choquasse',
    'choquassent',
    'choquasses',
    'choquassiez',
    'choquassions',
    'choque',
    'choquent',
    'choquer',
    'choquera',
    'choquerai',
    'choqueraient',
    'choquerais',
    'choquerait',
    'choqueras',
    'choquerez',
    'choqueriez',
    'choquerions',
    'choquerons',
    'choqueront',
    'choques',
    'choquez',
    'choquiez',
    'choquions',
    'choquons',
    'choquâmes',
    'choquât',
    'choquâtes',
    'choquèrent',
    'choqué',
    'choquée',
    'choquées',
    'choqués',
    'choral',
    'chorale',
    'chorales',
    'chorals',
    'choraux',
    'chordés',
    'choreute',
    'choreutes',
    'chorion',
    'chorions',
    'choriste',
    'choristes',
    'chorizo',
    'chorizos',
    'choroïde',
    'choroïdes',
    'choroïdien',
    'choroïdienne',
    'choroïdiens',
    'chorus',
    'chorège',
    'chorèges',
    'chorée',
    'chorées',
    'chorégraphe',
    'chorégraphes',
    'chorégraphie',
    'choréique',
    'choréiques',
    'chose',
    'choses',
    'chosifia',
    'chosifiai',
    'chosifiaient',
    'chosifiais',
    'chosifiait',
    'chosifiant',
    'chosifias',
    'chosifiasse',
    'chosifiasses',
    'chosifie',
    'chosifient',
    'chosifier',
    'chosifiera',
    'chosifierai',
    'chosifierais',
    'chosifierait',
    'chosifieras',
    'chosifierez',
    'chosifieriez',
    'chosifierons',
    'chosifieront',
    'chosifies',
    'chosifiez',
    'chosifiiez',
    'chosifiions',
    'chosifions',
    'chosifiâmes',
    'chosifiât',
    'chosifiâtes',
    'chosifièrent',
    'chosifié',
    'chosifiée',
    'chosifiées',
    'chosifiés',
    'chott',
    'chotts',
    'chou',
    'chouan',
    'chouannerie',
    'chouanneries',
    'chouans',
    'choucas',
    'chouchou',
    'chouchous',
    'chouchouta',
    'chouchoutai',
    'chouchoutais',
    'chouchoutait',
    'chouchoutant',
    'chouchoutas',
    'chouchoute',
    'chouchoutent',
    'chouchouter',
    'chouchoutera',
    'chouchoutes',
    'chouchoutez',
    'chouchoutiez',
    'chouchoutons',
    'chouchoutât',
    'chouchouté',
    'chouchoutée',
    'chouchoutées',
    'chouchoutés',
    'choucroute',
    'choucroutes',
    'chouette',
    'chouettes',
    'chouleur',
    'chouleurs',
    'chourava',
    'chouravai',
    'chouravaient',
    'chouravais',
    'chouravait',
    'chouravant',
    'chouravas',
    'chouravasse',
    'chouravasses',
    'chourave',
    'chouravent',
    'chouraver',
    'chouravera',
    'chouraverai',
    'chouraverais',
    'chouraverait',
    'chouraveras',
    'chouraverez',
    'chouraveriez',
    'chouraverons',
    'chouraveront',
    'chouraves',
    'chouravez',
    'chouraviez',
    'chouravions',
    'chouravons',
    'chouravâmes',
    'chouravât',
    'chouravâtes',
    'chouravèrent',
    'chouravé',
    'chouravée',
    'chouravées',
    'chouravés',
    'chourina',
    'chourinai',
    'chourinaient',
    'chourinais',
    'chourinait',
    'chourinant',
    'chourinas',
    'chourinasse',
    'chourinasses',
    'chourine',
    'chourinent',
    'chouriner',
    'chourinera',
    'chourinerai',
    'chourinerais',
    'chourinerait',
    'chourineras',
    'chourinerez',
    'chourineriez',
    'chourinerons',
    'chourineront',
    'chourines',
    'chourinez',
    'chouriniez',
    'chourinions',
    'chourinons',
    'chourinâmes',
    'chourinât',
    'chourinâtes',
    'chourinèrent',
    'chouriné',
    'chourinée',
    'chourinées',
    'chourinés',
    'choux',
    'choya',
    'choyai',
    'choyaient',
    'choyais',
    'choyait',
    'choyant',
    'choyas',
    'choyasse',
    'choyassent',
    'choyasses',
    'choyassiez',
    'choyassions',
    'choyer',
    'choyez',
    'choyiez',
    'choyions',
    'choyons',
    'choyâmes',
    'choyât',
    'choyâtes',
    'choyèrent',
    'choyé',
    'choyée',
    'choyées',
    'choyés',
    'chrisme',
    'chrismes',
    'christ',
    'christiania',
    'christianias',
    'christianisa',
    'christianise',
    'christianisé',
    'christique',
    'christiques',
    'christologie',
    'christs',
    'chroma',
    'chromage',
    'chromages',
    'chromai',
    'chromaient',
    'chromais',
    'chromait',
    'chromant',
    'chromas',
    'chromasse',
    'chromassent',
    'chromasses',
    'chromassiez',
    'chromassions',
    'chromate',
    'chromates',
    'chromatine',
    'chromatines',
    'chromatique',
    'chromatiques',
    'chromatisme',
    'chromatismes',
    'chromatopsie',
    'chrome',
    'chroment',
    'chromer',
    'chromera',
    'chromerai',
    'chromeraient',
    'chromerais',
    'chromerait',
    'chromeras',
    'chromerez',
    'chromeriez',
    'chromerions',
    'chromerons',
    'chromeront',
    'chromes',
    'chromez',
    'chromiez',
    'chromions',
    'chromique',
    'chromiques',
    'chromiser',
    'chromiste',
    'chromistes',
    'chromo',
    'chromogène',
    'chromogènes',
    'chromons',
    'chromos',
    'chromosome',
    'chromosomes',
    'chromosphère',
    'chromotypie',
    'chromotypies',
    'chromâmes',
    'chromât',
    'chromâtes',
    'chromèrent',
    'chromé',
    'chromée',
    'chromées',
    'chromés',
    'chronaxie',
    'chronaxies',
    'chronicité',
    'chronicités',
    'chroniqua',
    'chroniquai',
    'chroniquais',
    'chroniquait',
    'chroniquant',
    'chroniquas',
    'chroniquasse',
    'chronique',
    'chroniquent',
    'chroniquer',
    'chroniquera',
    'chroniquerai',
    'chroniqueras',
    'chroniquerez',
    'chroniques',
    'chroniqueur',
    'chroniqueurs',
    'chroniqueuse',
    'chroniquez',
    'chroniquiez',
    'chroniquions',
    'chroniquons',
    'chroniquâmes',
    'chroniquât',
    'chroniquâtes',
    'chroniqué',
    'chrono',
    'chronologie',
    'chronologies',
    'chronomètre',
    'chronomètres',
    'chronométra',
    'chronométrai',
    'chronométras',
    'chronométrer',
    'chronométrez',
    'chronométrie',
    'chronométrât',
    'chronométré',
    'chronométrée',
    'chronométrés',
    'chronos',
    'chrouma',
    'chroumai',
    'chroumaient',
    'chroumais',
    'chroumait',
    'chroumant',
    'chroumas',
    'chroumasse',
    'chroumassent',
    'chroumasses',
    'chroumassiez',
    'chroume',
    'chroument',
    'chroumer',
    'chroumes',
    'chroumez',
    'chroumiez',
    'chroumions',
    'chroumons',
    'chroumâmes',
    'chroumât',
    'chroumâtes',
    'chroumèrent',
    'chroumé',
    'chroumée',
    'chroumées',
    'chroumés',
    'chrysalide',
    'chrysalides',
    'chrysanthème',
    'chrysobéryl',
    'chrysobéryls',
    'chrysocale',
    'chrysocales',
    'chrysolithe',
    'chrysolithes',
    'chrysomèle',
    'chrysomèles',
    'chrysoprase',
    'chrysoprases',
    'chrémeau',
    'chrémeaux',
    'chrétien',
    'chrétienne',
    'chrétiennes',
    'chrétiens',
    'chrétienté',
    'chrétientés',
    'chthonien',
    'chthonienne',
    'chthoniennes',
    'chthoniens',
    'chuchota',
    'chuchotai',
    'chuchotaient',
    'chuchotais',
    'chuchotait',
    'chuchotant',
    'chuchotas',
    'chuchotasse',
    'chuchotasses',
    'chuchote',
    'chuchotement',
    'chuchotent',
    'chuchoter',
    'chuchotera',
    'chuchoterai',
    'chuchoterais',
    'chuchoterait',
    'chuchoteras',
    'chuchoterez',
    'chuchoterie',
    'chuchoteries',
    'chuchoteriez',
    'chuchoterons',
    'chuchoteront',
    'chuchotes',
    'chuchotez',
    'chuchotiez',
    'chuchotions',
    'chuchotis',
    'chuchotons',
    'chuchotâmes',
    'chuchotât',
    'chuchotâtes',
    'chuchotèrent',
    'chuchoté',
    'chuchotée',
    'chuchotées',
    'chuchotés',
    'chue',
    'chues',
    'chuinta',
    'chuintai',
    'chuintaient',
    'chuintais',
    'chuintait',
    'chuintant',
    'chuintas',
    'chuintasse',
    'chuintassent',
    'chuintasses',
    'chuintassiez',
    'chuinte',
    'chuintement',
    'chuintements',
    'chuintent',
    'chuinter',
    'chuintera',
    'chuinterai',
    'chuinterais',
    'chuinterait',
    'chuinteras',
    'chuinterez',
    'chuinteriez',
    'chuinterions',
    'chuinterons',
    'chuinteront',
    'chuintes',
    'chuintez',
    'chuintiez',
    'chuintions',
    'chuintons',
    'chuintâmes',
    'chuintât',
    'chuintâtes',
    'chuintèrent',
    'chuinté',
    'chus',
    'chut',
    'chuta',
    'chutai',
    'chutaient',
    'chutais',
    'chutait',
    'chutant',
    'chutas',
    'chutasse',
    'chutassent',
    'chutasses',
    'chutassiez',
    'chutassions',
    'chute',
    'chutent',
    'chuter',
    'chutera',
    'chuterai',
    'chuteraient',
    'chuterais',
    'chuterait',
    'chuteras',
    'chuterez',
    'chuteriez',
    'chuterions',
    'chuterons',
    'chuteront',
    'chutes',
    'chutez',
    'chutiez',
    'chutions',
    'chutons',
    'chutâmes',
    'chutât',
    'chutâtes',
    'chutèrent',
    'chuté',
    'chutée',
    'chutées',
    'chutés',
    'chyle',
    'chyles',
    'chylifère',
    'chylifères',
    'chyme',
    'chymes',
    'châle',
    'châles',
    'châlit',
    'châlits',
    'châsse',
    'châsses',
    'châssis',
    'châtaigne',
    'châtaigner',
    'châtaigners',
    'châtaignes',
    'châtaignier',
    'châtaigniers',
    'châtain',
    'châtains',
    'château',
    'châteaux',
    'châtelain',
    'châtelaine',
    'châtelaines',
    'châtelains',
    'châtellenie',
    'châtellenies',
    'châtia',
    'châtiai',
    'châtiaient',
    'châtiais',
    'châtiait',
    'châtiant',
    'châtias',
    'châtiasse',
    'châtiassent',
    'châtiasses',
    'châtiassiez',
    'châtiassions',
    'châtie',
    'châtient',
    'châtier',
    'châtiera',
    'châtierai',
    'châtieraient',
    'châtierais',
    'châtierait',
    'châtieras',
    'châtierez',
    'châtieriez',
    'châtierions',
    'châtierons',
    'châtieront',
    'châties',
    'châtiez',
    'châtiiez',
    'châtiions',
    'châtiment',
    'châtiments',
    'châtions',
    'châtiâmes',
    'châtiât',
    'châtiâtes',
    'châtièrent',
    'châtié',
    'châtiée',
    'châtiées',
    'châtiés',
    'châtra',
    'châtrai',
    'châtraient',
    'châtrais',
    'châtrait',
    'châtrant',
    'châtras',
    'châtrasse',
    'châtrassent',
    'châtrasses',
    'châtrassiez',
    'châtrassions',
    'châtre',
    'châtrent',
    'châtrer',
    'châtrera',
    'châtrerai',
    'châtreraient',
    'châtrerais',
    'châtrerait',
    'châtreras',
    'châtrerez',
    'châtreriez',
    'châtrerions',
    'châtrerons',
    'châtreront',
    'châtres',
    'châtrez',
    'châtriez',
    'châtrions',
    'châtrons',
    'châtrâmes',
    'châtrât',
    'châtrâtes',
    'châtrèrent',
    'châtré',
    'châtrée',
    'châtrées',
    'châtrés',
    'chèche',
    'chèches',
    'chènevis',
    'chènevière',
    'chènevières',
    'chèque',
    'chèques',
    'chère',
    'chèrement',
    'chères',
    'chèvre',
    'chèvres',
    'chébec',
    'chébecs',
    'chéchia',
    'chéchias',
    'chélicère',
    'chélicères',
    'chélidoine',
    'chélidoines',
    'chénopode',
    'chénopodes',
    'chéquier',
    'chéquiers',
    'chéra',
    'chérai',
    'chéraient',
    'chérais',
    'chérait',
    'chérant',
    'chéras',
    'chérasse',
    'chérassent',
    'chérasses',
    'chérassiez',
    'chérassions',
    'chére',
    'chérent',
    'chérer',
    'chérera',
    'chérerai',
    'chéreraient',
    'chérerais',
    'chérerait',
    'chéreras',
    'chérerez',
    'chéreriez',
    'chérerions',
    'chérerons',
    'chéreront',
    'chéres',
    'chérez',
    'chéri',
    'chérie',
    'chéries',
    'chériez',
    'chérif',
    'chérifien',
    'chérifienne',
    'chérifiennes',
    'chérifiens',
    'chérifs',
    'chérions',
    'chérir',
    'chérira',
    'chérirai',
    'chériraient',
    'chérirais',
    'chérirait',
    'chériras',
    'chérirent',
    'chérirez',
    'chéririez',
    'chéririons',
    'chérirons',
    'chériront',
    'chéris',
    'chérissaient',
    'chérissais',
    'chérissait',
    'chérissant',
    'chérisse',
    'chérissent',
    'chérisses',
    'chérissez',
    'chérissiez',
    'chérissions',
    'chérissons',
    'chérit',
    'chérons',
    'chérot',
    'chérots',
    'chérubin',
    'chérubins',
    'chérâmes',
    'chérât',
    'chérâtes',
    'chérèrent',
    'chéré',
    'chérîmes',
    'chérît',
    'chérîtes',
    'chétif',
    'chétifs',
    'chétive',
    'chétivement',
    'chétives',
    'chênaie',
    'chênaies',
    'chêne',
    'chênes',
    'chôma',
    'chômable',
    'chômables',
    'chômage',
    'chômages',
    'chômai',
    'chômaient',
    'chômais',
    'chômait',
    'chômant',
    'chômas',
    'chômasse',
    'chômassent',
    'chômasses',
    'chômassiez',
    'chômassions',
    'chôme',
    'chôment',
    'chômer',
    'chômera',
    'chômerai',
    'chômeraient',
    'chômerais',
    'chômerait',
    'chômeras',
    'chômerez',
    'chômeriez',
    'chômerions',
    'chômerons',
    'chômeront',
    'chômes',
    'chômeur',
    'chômeurs',
    'chômeuse',
    'chômeuses',
    'chômez',
    'chômiez',
    'chômions',
    'chômons',
    'chômâmes',
    'chômât',
    'chômâtes',
    'chômèrent',
    'chômé',
    'chômée',
    'chômées',
    'chômés',
    'chût',
    'choeur',
    'choeurs',
    'ciao',
    'cibiche',
    'cibiches',
    'cibiste',
    'cibistes',
    'cible',
    'cibler',
    'cibles',
    'ciboire',
    'ciboires',
    'ciborium',
    'ciboriums',
    'ciboule',
    'ciboules',
    'ciboulette',
    'ciboulettes',
    'ciboulot',
    'ciboulots',
    'cicatrice',
    'cicatrices',
    'cicatriciel',
    'cicatriciels',
    'cicatricule',
    'cicatricules',
    'cicatrisa',
    'cicatrisable',
    'cicatrisai',
    'cicatrisais',
    'cicatrisait',
    'cicatrisant',
    'cicatrisante',
    'cicatrisants',
    'cicatrisas',
    'cicatrisasse',
    'cicatrise',
    'cicatrisent',
    'cicatriser',
    'cicatrisera',
    'cicatriserai',
    'cicatriseras',
    'cicatriserez',
    'cicatrises',
    'cicatrisez',
    'cicatrisiez',
    'cicatrisions',
    'cicatrisons',
    'cicatrisâmes',
    'cicatrisât',
    'cicatrisâtes',
    'cicatrisé',
    'cicatrisée',
    'cicatrisées',
    'cicatrisés',
    'cicindèle',
    'cicindèles',
    'cicutine',
    'cicutines',
    'cicéro',
    'cicérone',
    'cicérones',
    'cicéronien',
    'cicéronienne',
    'cicéroniens',
    'cicéros',
    'cidre',
    'cidrerie',
    'cidreries',
    'cidres',
    'ciel',
    'ciels',
    'cierge',
    'cierges',
    'cieux',
    'cigale',
    'cigales',
    'cigare',
    'cigares',
    'cigarette',
    'cigarettes',
    'cigarillo',
    'cigarillos',
    'cigarière',
    'cigarières',
    'cigogne',
    'cigogneau',
    'cigogneaux',
    'cigognes',
    'ciguë',
    'ciguës',
    'ciliaire',
    'ciliaires',
    'cilice',
    'cilices',
    'cilié',
    'ciliée',
    'ciliées',
    'ciliés',
    'cilla',
    'cillai',
    'cillaient',
    'cillais',
    'cillait',
    'cillant',
    'cillas',
    'cillasse',
    'cillassent',
    'cillasses',
    'cillassiez',
    'cillassions',
    'cille',
    'cillement',
    'cillements',
    'cillent',
    'ciller',
    'cillera',
    'cillerai',
    'cilleraient',
    'cillerais',
    'cillerait',
    'cilleras',
    'cillerez',
    'cilleriez',
    'cillerions',
    'cillerons',
    'cilleront',
    'cilles',
    'cillez',
    'cilliez',
    'cillions',
    'cillons',
    'cillâmes',
    'cillât',
    'cillâtes',
    'cillèrent',
    'cillé',
    'cillée',
    'cillées',
    'cillés',
    'cils',
    'cimaise',
    'cimaises',
    'cime',
    'ciment',
    'cimenta',
    'cimentai',
    'cimentaient',
    'cimentais',
    'cimentait',
    'cimentant',
    'cimentas',
    'cimentasse',
    'cimentassent',
    'cimentasses',
    'cimentassiez',
    'cimentation',
    'cimentations',
    'cimente',
    'cimentent',
    'cimenter',
    'cimentera',
    'cimenterai',
    'cimenterais',
    'cimenterait',
    'cimenteras',
    'cimenterez',
    'cimenterie',
    'cimenteries',
    'cimenteriez',
    'cimenterions',
    'cimenterons',
    'cimenteront',
    'cimentes',
    'cimentez',
    'cimentier',
    'cimentiers',
    'cimentiez',
    'cimentions',
    'cimentons',
    'ciments',
    'cimentâmes',
    'cimentât',
    'cimentâtes',
    'cimentèrent',
    'cimenté',
    'cimentée',
    'cimentées',
    'cimentés',
    'cimes',
    'cimeterre',
    'cimeterres',
    'cimetière',
    'cimetières',
    'cimier',
    'cimiers',
    'cinabre',
    'cinabres',
    'cinchonine',
    'cinchonines',
    'cincle',
    'cincles',
    'cingalais',
    'cingalaise',
    'cingalaises',
    'cingla',
    'cinglai',
    'cinglaient',
    'cinglais',
    'cinglait',
    'cinglant',
    'cinglante',
    'cinglantes',
    'cinglants',
    'cinglas',
    'cinglasse',
    'cinglassent',
    'cinglasses',
    'cinglassiez',
    'cinglassions',
    'cingle',
    'cinglent',
    'cingler',
    'cinglera',
    'cinglerai',
    'cingleraient',
    'cinglerais',
    'cinglerait',
    'cingleras',
    'cinglerez',
    'cingleriez',
    'cinglerions',
    'cinglerons',
    'cingleront',
    'cingles',
    'cinglez',
    'cingliez',
    'cinglions',
    'cinglons',
    'cinglâmes',
    'cinglât',
    'cinglâtes',
    'cinglèrent',
    'cinglé',
    'cinglée',
    'cinglées',
    'cinglés',
    'cinnamome',
    'cinnamomes',
    'cinoche',
    'cinoches',
    'cinoque',
    'cinoques',
    'cinq',
    'cinquantaine',
    'cinquante',
    'cinquantième',
    'cinquième',
    'cinquièmes',
    'cintra',
    'cintrage',
    'cintrages',
    'cintrai',
    'cintraient',
    'cintrais',
    'cintrait',
    'cintrant',
    'cintras',
    'cintrasse',
    'cintrassent',
    'cintrasses',
    'cintrassiez',
    'cintrassions',
    'cintre',
    'cintrent',
    'cintrer',
    'cintrera',
    'cintrerai',
    'cintreraient',
    'cintrerais',
    'cintrerait',
    'cintreras',
    'cintrerez',
    'cintreriez',
    'cintrerions',
    'cintrerons',
    'cintreront',
    'cintres',
    'cintrez',
    'cintriez',
    'cintrions',
    'cintrons',
    'cintrâmes',
    'cintrât',
    'cintrâtes',
    'cintrèrent',
    'cintré',
    'cintrée',
    'cintrées',
    'cintrés',
    'ciné',
    'cinéaste',
    'cinéastes',
    'cinéma',
    'cinémas',
    'cinémascope',
    'cinémascopes',
    'cinémathèque',
    'cinématique',
    'cinématiques',
    'cinémomètre',
    'cinémomètres',
    'cinéphile',
    'cinéphiles',
    'cinéraire',
    'cinéraires',
    'cinérama',
    'cinérite',
    'cinérites',
    'cinés',
    'cinétique',
    'cinétiques',
    'cinétir',
    'cinétirs',
    'cipaye',
    'cipayes',
    'cipolin',
    'cipolins',
    'cippe',
    'cippes',
    'cira',
    'cirage',
    'cirages',
    'cirai',
    'ciraient',
    'cirais',
    'cirait',
    'cirant',
    'ciras',
    'cirasse',
    'cirassent',
    'cirasses',
    'cirassiez',
    'cirassions',
    'circadien',
    'circadienne',
    'circadiennes',
    'circadiens',
    'circoncira',
    'circoncirai',
    'circoncirais',
    'circoncirait',
    'circonciras',
    'circoncire',
    'circoncirent',
    'circoncirez',
    'circonciriez',
    'circoncirons',
    'circonciront',
    'circoncis',
    'circoncisais',
    'circoncisait',
    'circoncisant',
    'circoncisez',
    'circoncisiez',
    'circoncision',
    'circoncisons',
    'circoncisse',
    'circoncisses',
    'circoncit',
    'circoncîmes',
    'circoncît',
    'circoncîtes',
    'circonflexe',
    'circonflexes',
    'circonscrira',
    'circonscrire',
    'circonscris',
    'circonscrit',
    'circonscrite',
    'circonscrits',
    'circonscrive',
    'circonspect',
    'circonspecte',
    'circonspects',
    'circonstance',
    'circonvenais',
    'circonvenait',
    'circonvenant',
    'circonvenez',
    'circonveniez',
    'circonvenir',
    'circonvenons',
    'circonvenu',
    'circonvenue',
    'circonvenues',
    'circonvenus',
    'circonvienne',
    'circonviens',
    'circonvient',
    'circonvins',
    'circonvinsse',
    'circonvint',
    'circonvînmes',
    'circonvînt',
    'circonvîntes',
    'circuit',
    'circuits',
    'circula',
    'circulai',
    'circulaient',
    'circulaire',
    'circulaires',
    'circulais',
    'circulait',
    'circulant',
    'circulariser',
    'circularité',
    'circularités',
    'circulas',
    'circulasse',
    'circulassent',
    'circulasses',
    'circulassiez',
    'circulation',
    'circulations',
    'circulatoire',
    'circule',
    'circulent',
    'circuler',
    'circulera',
    'circulerai',
    'circulerais',
    'circulerait',
    'circuleras',
    'circulerez',
    'circuleriez',
    'circulerions',
    'circulerons',
    'circuleront',
    'circules',
    'circulez',
    'circuliez',
    'circulions',
    'circulons',
    'circulâmes',
    'circulât',
    'circulâtes',
    'circulèrent',
    'circulé',
    'cire',
    'cirent',
    'cirer',
    'cirera',
    'cirerai',
    'cireraient',
    'cirerais',
    'cirerait',
    'cireras',
    'cirerez',
    'cireriez',
    'cirerions',
    'cirerons',
    'cireront',
    'cires',
    'cireur',
    'cireurs',
    'cireuse',
    'cireuses',
    'cireux',
    'cirez',
    'cirier',
    'ciriers',
    'ciriez',
    'cirions',
    'cirière',
    'cirières',
    'ciron',
    'cirons',
    'cirque',
    'cirques',
    'cirre',
    'cirres',
    'cirrhose',
    'cirrhoses',
    'cirrus',
    'cirâmes',
    'cirât',
    'cirâtes',
    'cirèrent',
    'ciré',
    'cirée',
    'cirées',
    'cirés',
    'cisailla',
    'cisaillai',
    'cisaillaient',
    'cisaillais',
    'cisaillait',
    'cisaillant',
    'cisaillas',
    'cisaillasse',
    'cisaillasses',
    'cisaille',
    'cisaillement',
    'cisaillent',
    'cisailler',
    'cisaillera',
    'cisaillerai',
    'cisaillerais',
    'cisaillerait',
    'cisailleras',
    'cisaillerez',
    'cisailleriez',
    'cisaillerons',
    'cisailleront',
    'cisailles',
    'cisaillez',
    'cisailliez',
    'cisaillions',
    'cisaillons',
    'cisaillâmes',
    'cisaillât',
    'cisaillâtes',
    'cisaillèrent',
    'cisaillé',
    'cisaillée',
    'cisaillées',
    'cisaillés',
    'cisalpin',
    'cisalpins',
    'ciseau',
    'ciseaux',
    'cisela',
    'ciselai',
    'ciselaient',
    'ciselais',
    'ciselait',
    'ciselant',
    'ciselas',
    'ciselasse',
    'ciselassent',
    'ciselasses',
    'ciselassiez',
    'ciselassions',
    'ciseler',
    'ciselet',
    'ciselets',
    'ciseleur',
    'ciseleurs',
    'ciselez',
    'ciseliez',
    'ciselions',
    'cisellement',
    'cisellements',
    'ciselons',
    'ciselure',
    'ciselures',
    'ciselâmes',
    'ciselât',
    'ciselâtes',
    'ciselèrent',
    'ciselé',
    'ciselée',
    'ciselées',
    'ciselés',
    'cisoires',
    'ciste',
    'cistercien',
    'cistercienne',
    'cisterciens',
    'cistes',
    'cistre',
    'cistres',
    'cistron',
    'cistrons',
    'cistude',
    'cistudes',
    'cisèle',
    'cisèlement',
    'cisèlements',
    'cisèlent',
    'cisèlera',
    'cisèlerai',
    'cisèleraient',
    'cisèlerais',
    'cisèlerait',
    'cisèleras',
    'cisèlerez',
    'cisèleriez',
    'cisèlerions',
    'cisèlerons',
    'cisèleront',
    'cisèles',
    'cisélera',
    'cisélerai',
    'ciséleraient',
    'cisélerais',
    'cisélerait',
    'ciséleras',
    'cisélerez',
    'ciséleriez',
    'cisélerions',
    'cisélerons',
    'ciséleront',
    'cita',
    'citadelle',
    'citadelles',
    'citadin',
    'citadine',
    'citadines',
    'citadins',
    'citai',
    'citaient',
    'citais',
    'citait',
    'citant',
    'citas',
    'citasse',
    'citassent',
    'citasses',
    'citassiez',
    'citassions',
    'citation',
    'citations',
    'citatteur',
    'citatteurs',
    'citattrice',
    'citattrices',
    'cite',
    'citent',
    'citer',
    'citera',
    'citerai',
    'citeraient',
    'citerais',
    'citerait',
    'citeras',
    'citerez',
    'citeriez',
    'citerions',
    'citerne',
    'citernes',
    'citerons',
    'citeront',
    'cites',
    'citez',
    'cithare',
    'cithares',
    'cithariste',
    'citharistes',
    'citiez',
    'citions',
    'citons',
    'citoyen',
    'citoyenne',
    'citoyennes',
    'citoyenneté',
    'citoyennetés',
    'citoyens',
    'citrate',
    'citrates',
    'citrin',
    'citrine',
    'citrines',
    'citrins',
    'citrique',
    'citriques',
    'citron',
    'citronnade',
    'citronnades',
    'citronnelle',
    'citronnelles',
    'citronnier',
    'citronniers',
    'citronné',
    'citronnée',
    'citronnées',
    'citronnés',
    'citrons',
    'citrouille',
    'citrouilles',
    'citrus',
    'citâmes',
    'citât',
    'citâtes',
    'citèrent',
    'cité',
    'citée',
    'citées',
    'cités',
    'civelle',
    'civelles',
    'civet',
    'civets',
    'civette',
    'civettes',
    'civil',
    'civile',
    'civilement',
    'civiles',
    'civilisa',
    'civilisable',
    'civilisables',
    'civilisai',
    'civilisaient',
    'civilisais',
    'civilisait',
    'civilisant',
    'civilisas',
    'civilisasse',
    'civilisasses',
    'civilisateur',
    'civilisation',
    'civilise',
    'civilisent',
    'civiliser',
    'civilisera',
    'civiliserai',
    'civiliserais',
    'civiliserait',
    'civiliseras',
    'civiliserez',
    'civiliseriez',
    'civiliserons',
    'civiliseront',
    'civilises',
    'civilisez',
    'civilisiez',
    'civilisions',
    'civilisons',
    'civiliste',
    'civilistes',
    'civilisâmes',
    'civilisât',
    'civilisâtes',
    'civilisèrent',
    'civilisé',
    'civilisée',
    'civilisées',
    'civilisés',
    'civilité',
    'civilités',
    'civils',
    'civique',
    'civiques',
    'civisme',
    'civismes',
    'civière',
    'civières',
    'clabaud',
    'clabauda',
    'clabaudage',
    'clabaudages',
    'clabaudai',
    'clabaudaient',
    'clabaudais',
    'clabaudait',
    'clabaudant',
    'clabaudas',
    'clabaudasse',
    'clabaudasses',
    'clabaude',
    'clabaudent',
    'clabauder',
    'clabaudera',
    'clabauderai',
    'clabauderais',
    'clabauderait',
    'clabauderas',
    'clabauderez',
    'clabauderie',
    'clabauderies',
    'clabauderiez',
    'clabauderons',
    'clabauderont',
    'clabaudes',
    'clabaudeur',
    'clabaudeurs',
    'clabaudeuse',
    'clabaudeuses',
    'clabaudez',
    'clabaudiez',
    'clabaudions',
    'clabaudons',
    'clabauds',
    'clabaudâmes',
    'clabaudât',
    'clabaudâtes',
    'clabaudèrent',
    'clabaudé',
    'clabot',
    'clabota',
    'clabotage',
    'clabotages',
    'clabotai',
    'clabotaient',
    'clabotais',
    'clabotait',
    'clabotant',
    'clabotas',
    'clabotasse',
    'clabotassent',
    'clabotasses',
    'clabotassiez',
    'clabote',
    'clabotent',
    'claboter',
    'clabotera',
    'claboterai',
    'claboterais',
    'claboterait',
    'claboteras',
    'claboterez',
    'claboteriez',
    'claboterions',
    'claboterons',
    'claboteront',
    'clabotes',
    'clabotez',
    'clabotiez',
    'clabotions',
    'clabotons',
    'clabots',
    'clabotâmes',
    'clabotât',
    'clabotâtes',
    'clabotèrent',
    'claboté',
    'clabotée',
    'clabotées',
    'clabotés',
    'clade',
    'clades',
    'clafoutis',
    'claie',
    'claies',
    'clair',
    'clairance',
    'clairances',
    'claire',
    'clairement',
    'claires',
    'clairet',
    'clairets',
    'clairette',
    'clairettes',
    'clairière',
    'clairières',
    'clairon',
    'claironna',
    'claironnai',
    'claironnais',
    'claironnait',
    'claironnant',
    'claironnante',
    'claironnants',
    'claironnas',
    'claironnasse',
    'claironne',
    'claironnent',
    'claironner',
    'claironnera',
    'claironnerai',
    'claironneras',
    'claironnerez',
    'claironnes',
    'claironnez',
    'claironniez',
    'claironnions',
    'claironnons',
    'claironnâmes',
    'claironnât',
    'claironnâtes',
    'claironné',
    'claironnée',
    'claironnées',
    'claironnés',
    'clairons',
    'clairs',
    'clairsemé',
    'clairsemée',
    'clairsemées',
    'clairsemés',
    'clairvoyance',
    'clairvoyant',
    'clairvoyante',
    'clairvoyants',
    'clam',
    'clama',
    'clamai',
    'clamaient',
    'clamais',
    'clamait',
    'clamant',
    'clamas',
    'clamasse',
    'clamassent',
    'clamasses',
    'clamassiez',
    'clamassions',
    'clame',
    'clamecer',
    'clament',
    'clamer',
    'clamera',
    'clamerai',
    'clameraient',
    'clamerais',
    'clamerait',
    'clameras',
    'clamerez',
    'clameriez',
    'clamerions',
    'clamerons',
    'clameront',
    'clames',
    'clameur',
    'clameurs',
    'clamez',
    'clamiez',
    'clamions',
    'clamons',
    'clamp',
    'clampa',
    'clampai',
    'clampaient',
    'clampais',
    'clampait',
    'clampant',
    'clampas',
    'clampasse',
    'clampassent',
    'clampasses',
    'clampassiez',
    'clampassions',
    'clampe',
    'clampent',
    'clamper',
    'clampera',
    'clamperai',
    'clamperaient',
    'clamperais',
    'clamperait',
    'clamperas',
    'clamperez',
    'clamperiez',
    'clamperions',
    'clamperons',
    'clamperont',
    'clampes',
    'clampez',
    'clampiez',
    'clampions',
    'clampons',
    'clamps',
    'clampsa',
    'clampsai',
    'clampsaient',
    'clampsais',
    'clampsait',
    'clampsant',
    'clampsas',
    'clampsasse',
    'clampsassent',
    'clampsasses',
    'clampsassiez',
    'clampse',
    'clampsent',
    'clampser',
    'clampsera',
    'clampserai',
    'clampserais',
    'clampserait',
    'clampseras',
    'clampserez',
    'clampseriez',
    'clampserions',
    'clampserons',
    'clampseront',
    'clampses',
    'clampsez',
    'clampsiez',
    'clampsions',
    'clampsons',
    'clampsâmes',
    'clampsât',
    'clampsâtes',
    'clampsèrent',
    'clampsé',
    'clampsée',
    'clampsées',
    'clampsés',
    'clampâmes',
    'clampât',
    'clampâtes',
    'clampèrent',
    'clampé',
    'clampée',
    'clampées',
    'clampés',
    'clams',
    'clamsa',
    'clamsai',
    'clamsaient',
    'clamsais',
    'clamsait',
    'clamsant',
    'clamsas',
    'clamsasse',
    'clamsassent',
    'clamsasses',
    'clamsassiez',
    'clamsassions',
    'clamse',
    'clamsent',
    'clamser',
    'clamsera',
    'clamserai',
    'clamseraient',
    'clamserais',
    'clamserait',
    'clamseras',
    'clamserez',
    'clamseriez',
    'clamserions',
    'clamserons',
    'clamseront',
    'clamses',
    'clamsez',
    'clamsiez',
    'clamsions',
    'clamsons',
    'clamsâmes',
    'clamsât',
    'clamsâtes',
    'clamsèrent',
    'clamsé',
    'clamâmes',
    'clamât',
    'clamâtes',
    'clamèrent',
    'clamé',
    'clamée',
    'clamées',
    'clamés',
    'clan',
    'clandestin',
    'clandestine',
    'clandestines',
    'clandestins',
    'clandé',
    'clandés',
    'clanique',
    'claniques',
    'clans',
    'clapa',
    'clapai',
    'clapaient',
    'clapais',
    'clapait',
    'clapant',
    'clapas',
    'clapasse',
    'clapassent',
    'clapasses',
    'clapassiez',
    'clapassions',
    'clape',
    'clapent',
    'claper',
    'clapera',
    'claperai',
    'claperaient',
    'claperais',
    'claperait',
    'claperas',
    'claperez',
    'claperiez',
    'claperions',
    'claperons',
    'claperont',
    'clapes',
    'clapet',
    'clapets',
    'clapeyron',
    'clapez',
    'clapi',
    'clapier',
    'clapiers',
    'clapiez',
    'clapions',
    'clapir',
    'clapira',
    'clapirai',
    'clapiraient',
    'clapirais',
    'clapirait',
    'clapiras',
    'clapirent',
    'clapirez',
    'clapiriez',
    'clapirions',
    'clapirons',
    'clapiront',
    'clapis',
    'clapissaient',
    'clapissais',
    'clapissait',
    'clapissant',
    'clapisse',
    'clapissent',
    'clapisses',
    'clapissez',
    'clapissiez',
    'clapissions',
    'clapissons',
    'clapit',
    'clapons',
    'clapota',
    'clapotage',
    'clapotages',
    'clapotai',
    'clapotaient',
    'clapotais',
    'clapotait',
    'clapotant',
    'clapotante',
    'clapotantes',
    'clapotants',
    'clapotas',
    'clapotasse',
    'clapotassent',
    'clapotasses',
    'clapotassiez',
    'clapote',
    'clapotement',
    'clapotements',
    'clapotent',
    'clapoter',
    'clapotera',
    'clapoterai',
    'clapoterais',
    'clapoterait',
    'clapoteras',
    'clapoterez',
    'clapoteriez',
    'clapoterions',
    'clapoterons',
    'clapoteront',
    'clapotes',
    'clapotez',
    'clapotiez',
    'clapotions',
    'clapotis',
    'clapotons',
    'clapotâmes',
    'clapotât',
    'clapotâtes',
    'clapotèrent',
    'clapoté',
    'clappa',
    'clappai',
    'clappaient',
    'clappais',
    'clappait',
    'clappant',
    'clappas',
    'clappasse',
    'clappassent',
    'clappasses',
    'clappassiez',
    'clappassions',
    'clappe',
    'clappement',
    'clappements',
    'clappent',
    'clapper',
    'clappera',
    'clapperai',
    'clapperaient',
    'clapperais',
    'clapperait',
    'clapperas',
    'clapperez',
    'clapperiez',
    'clapperions',
    'clapperons',
    'clapperont',
    'clappes',
    'clappez',
    'clappiez',
    'clappions',
    'clappons',
    'clappâmes',
    'clappât',
    'clappâtes',
    'clappèrent',
    'clappé',
    'clapsa',
    'clapsai',
    'clapsaient',
    'clapsais',
    'clapsait',
    'clapsant',
    'clapsas',
    'clapsasse',
    'clapsassent',
    'clapsasses',
    'clapsassiez',
    'clapsassions',
    'clapse',
    'clapsent',
    'clapser',
    'clapsera',
    'clapserai',
    'clapseraient',
    'clapserais',
    'clapserait',
    'clapseras',
    'clapserez',
    'clapseriez',
    'clapserions',
    'clapserons',
    'clapseront',
    'clapses',
    'clapsez',
    'clapsiez',
    'clapsions',
    'clapsons',
    'clapsâmes',
    'clapsât',
    'clapsâtes',
    'clapsèrent',
    'clapsé',
    'clapâmes',
    'clapât',
    'clapâtes',
    'clapèrent',
    'clapé',
    'clapîmes',
    'clapît',
    'clapîtes',
    'claqua',
    'claquage',
    'claquages',
    'claquai',
    'claquaient',
    'claquais',
    'claquait',
    'claquant',
    'claquante',
    'claquantes',
    'claquants',
    'claquas',
    'claquasse',
    'claquassent',
    'claquasses',
    'claquassiez',
    'claquassions',
    'claque',
    'claquement',
    'claquements',
    'claquemura',
    'claquemurai',
    'claquemurais',
    'claquemurait',
    'claquemurant',
    'claquemuras',
    'claquemure',
    'claquemurent',
    'claquemurer',
    'claquemurera',
    'claquemures',
    'claquemurez',
    'claquemuriez',
    'claquemurons',
    'claquemurât',
    'claquemuré',
    'claquemurée',
    'claquemurées',
    'claquemurés',
    'claquent',
    'claquer',
    'claquera',
    'claquerai',
    'claqueraient',
    'claquerais',
    'claquerait',
    'claqueras',
    'claquerez',
    'claqueriez',
    'claquerions',
    'claquerons',
    'claqueront',
    'claques',
    'claquet',
    'claqueta',
    'claquetai',
    'claquetaient',
    'claquetais',
    'claquetait',
    'claquetant',
    'claquetas',
    'claquetasse',
    'claquetasses',
    'claqueter',
    'claquetez',
    'claquetiez',
    'claquetions',
    'claquetons',
    'claquets',
    'claquette',
    'claquettent',
    'claquettera',
    'claquetterai',
    'claquetteras',
    'claquetterez',
    'claquettes',
    'claquetâmes',
    'claquetât',
    'claquetâtes',
    'claquetèrent',
    'claqueté',
    'claquez',
    'claquiez',
    'claquions',
    'claquoir',
    'claquoirs',
    'claquons',
    'claquâmes',
    'claquât',
    'claquâtes',
    'claquèrent',
    'claqué',
    'claquée',
    'claquées',
    'claqués',
    'clarifia',
    'clarifiai',
    'clarifiaient',
    'clarifiais',
    'clarifiait',
    'clarifiant',
    'clarifias',
    'clarifiasse',
    'clarifiasses',
    'clarifie',
    'clarifient',
    'clarifier',
    'clarifiera',
    'clarifierai',
    'clarifierais',
    'clarifierait',
    'clarifieras',
    'clarifierez',
    'clarifieriez',
    'clarifierons',
    'clarifieront',
    'clarifies',
    'clarifiez',
    'clarifiiez',
    'clarifiions',
    'clarifions',
    'clarifiâmes',
    'clarifiât',
    'clarifiâtes',
    'clarifièrent',
    'clarifié',
    'clarifiée',
    'clarifiées',
    'clarifiés',
    'clarine',
    'clarines',
    'clarinette',
    'clarinettes',
    'clarisse',
    'clarisses',
    'clarté',
    'clartés',
    'classa',
    'classable',
    'classables',
    'classai',
    'classaient',
    'classais',
    'classait',
    'classant',
    'classas',
    'classasse',
    'classassent',
    'classasses',
    'classassiez',
    'classassions',
    'classe',
    'classement',
    'classements',
    'classent',
    'classer',
    'classera',
    'classerai',
    'classeraient',
    'classerais',
    'classerait',
    'classeras',
    'classerez',
    'classeriez',
    'classerions',
    'classerons',
    'classeront',
    'classes',
    'classeur',
    'classeurs',
    'classez',
    'classicisme',
    'classicismes',
    'classiez',
    'classifia',
    'classifiai',
    'classifiais',
    'classifiait',
    'classifiant',
    'classifias',
    'classifiasse',
    'classifie',
    'classifient',
    'classifier',
    'classifiera',
    'classifierai',
    'classifieras',
    'classifierez',
    'classifies',
    'classifiez',
    'classifiiez',
    'classifiions',
    'classifions',
    'classifiâmes',
    'classifiât',
    'classifiâtes',
    'classifié',
    'classifiée',
    'classifiées',
    'classifiés',
    'classions',
    'classique',
    'classiques',
    'classons',
    'classâmes',
    'classât',
    'classâtes',
    'classèrent',
    'classé',
    'classée',
    'classées',
    'classés',
    'clastique',
    'clastiques',
    'claudicant',
    'claudicante',
    'claudicantes',
    'claudicants',
    'claudication',
    'claudiqua',
    'claudiquai',
    'claudiquais',
    'claudiquait',
    'claudiquant',
    'claudiquas',
    'claudiquasse',
    'claudique',
    'claudiquent',
    'claudiquer',
    'claudiquera',
    'claudiquerai',
    'claudiqueras',
    'claudiquerez',
    'claudiques',
    'claudiquez',
    'claudiquiez',
    'claudiquions',
    'claudiquons',
    'claudiquâmes',
    'claudiquât',
    'claudiquâtes',
    'claudiqué',
    'clause',
    'clauses',
    'claustra',
    'claustrai',
    'claustraient',
    'claustrais',
    'claustrait',
    'claustral',
    'claustrale',
    'claustrales',
    'claustrant',
    'claustras',
    'claustrasse',
    'claustrasses',
    'claustration',
    'claustraux',
    'claustre',
    'claustrent',
    'claustrer',
    'claustrera',
    'claustrerai',
    'claustrerais',
    'claustrerait',
    'claustreras',
    'claustrerez',
    'claustreriez',
    'claustrerons',
    'claustreront',
    'claustres',
    'claustrez',
    'claustriez',
    'claustrions',
    'claustrons',
    'claustrâmes',
    'claustrât',
    'claustrâtes',
    'claustrèrent',
    'claustré',
    'claustrée',
    'claustrées',
    'claustrés',
    'clausule',
    'clausules',
    'clausus',
    'clava',
    'clavai',
    'clavaient',
    'clavaire',
    'clavaires',
    'clavais',
    'clavait',
    'clavant',
    'clavas',
    'clavasse',
    'clavassent',
    'clavasses',
    'clavassiez',
    'clavassions',
    'clave',
    'claveau',
    'claveaus',
    'clavecin',
    'claveciniste',
    'clavecins',
    'clavelé',
    'clavelée',
    'clavelées',
    'clavelés',
    'clavent',
    'claver',
    'clavera',
    'claverai',
    'claveraient',
    'claverais',
    'claverait',
    'claveras',
    'claverez',
    'claveriez',
    'claverions',
    'claverons',
    'claveront',
    'claves',
    'claveta',
    'clavetage',
    'clavetages',
    'clavetai',
    'clavetaient',
    'clavetais',
    'clavetait',
    'clavetant',
    'clavetas',
    'clavetasse',
    'clavetassent',
    'clavetasses',
    'clavetassiez',
    'claveter',
    'clavetez',
    'clavetiez',
    'clavetions',
    'clavetons',
    'clavetta',
    'clavettai',
    'clavettaient',
    'clavettais',
    'clavettait',
    'clavettant',
    'clavettas',
    'clavettasse',
    'clavettasses',
    'clavette',
    'clavettent',
    'clavetter',
    'clavettera',
    'clavetterai',
    'clavetterais',
    'clavetterait',
    'clavetteras',
    'clavetterez',
    'clavetteriez',
    'clavetterons',
    'clavetteront',
    'clavettes',
    'clavettez',
    'clavettiez',
    'clavettions',
    'clavettons',
    'clavettâmes',
    'clavettât',
    'clavettâtes',
    'clavettèrent',
    'clavetté',
    'clavettée',
    'clavettées',
    'clavettés',
    'clavetâmes',
    'clavetât',
    'clavetâtes',
    'clavetèrent',
    'claveté',
    'clavetée',
    'clavetées',
    'clavetés',
    'clavez',
    'clavicorde',
    'clavicordes',
    'clavicule',
    'clavicules',
    'clavier',
    'claviers',
    'claviez',
    'clavions',
    'claviste',
    'clavistes',
    'clavons',
    'clavâmes',
    'clavât',
    'clavâtes',
    'clavèrent',
    'clavé',
    'clavée',
    'clavées',
    'clavés',
    'clayette',
    'clayettes',
    'claymore',
    'claymores',
    'clayon',
    'clayonna',
    'clayonnage',
    'clayonnages',
    'clayonnai',
    'clayonnaient',
    'clayonnais',
    'clayonnait',
    'clayonnant',
    'clayonnas',
    'clayonnasse',
    'clayonnasses',
    'clayonne',
    'clayonnent',
    'clayonner',
    'clayonnera',
    'clayonnerai',
    'clayonnerais',
    'clayonnerait',
    'clayonneras',
    'clayonnerez',
    'clayonneriez',
    'clayonnerons',
    'clayonneront',
    'clayonnes',
    'clayonnez',
    'clayonniez',
    'clayonnions',
    'clayonnons',
    'clayonnâmes',
    'clayonnât',
    'clayonnâtes',
    'clayonnèrent',
    'clayonné',
    'clayonnée',
    'clayonnées',
    'clayonnés',
    'clayons',
    'clayère',
    'clayères',
    'clearing',
    'clearings',
    'clebs',
    'clef',
    'clefs',
    'clenche',
    'clenches',
    'clephte',
    'clephtes',
    'clepsydre',
    'clepsydres',
    'cleptomane',
    'cleptomanes',
    'cleptomanie',
    'cleptomanies',
    'clerc',
    'clercs',
    'clergie',
    'clergies',
    'clergyman',
    'clergymen',
    'clergé',
    'clergés',
    'clic',
    'clicha',
    'clichage',
    'clichages',
    'clichai',
    'clichaient',
    'clichais',
    'clichait',
    'clichant',
    'clichas',
    'clichasse',
    'clichassent',
    'clichasses',
    'clichassiez',
    'clichassions',
    'cliche',
    'clichent',
    'clicher',
    'clichera',
    'clicherai',
    'clicheraient',
    'clicherais',
    'clicherait',
    'clicheras',
    'clicherez',
    'clicherie',
    'clicheries',
    'clicheriez',
    'clicherions',
    'clicherons',
    'clicheront',
    'cliches',
    'clicheur',
    'clicheurs',
    'clichez',
    'clichiez',
    'clichions',
    'clichons',
    'clichâmes',
    'clichât',
    'clichâtes',
    'clichèrent',
    'cliché',
    'clichée',
    'clichées',
    'clichés',
    'clics',
    'client',
    'cliente',
    'clientes',
    'clients',
    'clientèle',
    'clientèles',
    'cligna',
    'clignai',
    'clignaient',
    'clignais',
    'clignait',
    'clignant',
    'clignas',
    'clignasse',
    'clignassent',
    'clignasses',
    'clignassiez',
    'clignassions',
    'cligne',
    'clignement',
    'clignements',
    'clignent',
    'cligner',
    'clignera',
    'clignerai',
    'cligneraient',
    'clignerais',
    'clignerait',
    'cligneras',
    'clignerez',
    'cligneriez',
    'clignerions',
    'clignerons',
    'cligneront',
    'clignes',
    'clignez',
    'cligniez',
    'clignions',
    'clignons',
    'clignota',
    'clignotai',
    'clignotaient',
    'clignotais',
    'clignotait',
    'clignotant',
    'clignotante',
    'clignotantes',
    'clignotants',
    'clignotas',
    'clignotasse',
    'clignotasses',
    'clignote',
    'clignotement',
    'clignotent',
    'clignoter',
    'clignotera',
    'clignoterai',
    'clignoterais',
    'clignoterait',
    'clignoteras',
    'clignoterez',
    'clignoteriez',
    'clignoterons',
    'clignoteront',
    'clignotes',
    'clignotez',
    'clignotiez',
    'clignotions',
    'clignotons',
    'clignotâmes',
    'clignotât',
    'clignotâtes',
    'clignotèrent',
    'clignoté',
    'clignâmes',
    'clignât',
    'clignâtes',
    'clignèrent',
    'cligné',
    'clignée',
    'clignées',
    'clignés',
    'climat',
    'climatique',
    'climatiques',
    'climatisa',
    'climatisai',
    'climatisais',
    'climatisait',
    'climatisant',
    'climatisante',
    'climatisants',
    'climatisas',
    'climatisasse',
    'climatise',
    'climatisent',
    'climatiser',
    'climatisera',
    'climatiserai',
    'climatiseras',
    'climatiserez',
    'climatises',
    'climatiseur',
    'climatiseurs',
    'climatisez',
    'climatisiez',
    'climatisions',
    'climatisme',
    'climatismes',
    'climatisons',
    'climatisâmes',
    'climatisât',
    'climatisâtes',
    'climatisé',
    'climatisée',
    'climatisées',
    'climatisés',
    'climatologie',
    'climatologue',
    'climats',
    'climatère',
    'climatères',
    'climatérique',
    'clin',
    'clinfoc',
    'clinfocs',
    'clinicat',
    'clinicats',
    'clinicien',
    'clinicienne',
    'cliniciennes',
    'cliniciens',
    'clinique',
    'cliniquement',
    'cliniques',
    'clinomètre',
    'clinomètres',
    'clinquant',
    'clinquante',
    'clinquantes',
    'clinquants',
    'clins',
    'clip',
    'clips',
    'clique',
    'cliquer',
    'cliques',
    'cliquet',
    'cliqueta',
    'cliquetai',
    'cliquetaient',
    'cliquetais',
    'cliquetait',
    'cliquetant',
    'cliquetas',
    'cliquetasse',
    'cliquetasses',
    'cliqueter',
    'cliquetez',
    'cliquetiez',
    'cliquetions',
    'cliquetis',
    'cliquetons',
    'cliquets',
    'cliquette',
    'cliquettent',
    'cliquettera',
    'cliquetterai',
    'cliquetteras',
    'cliquetterez',
    'cliquettes',
    'cliquetâmes',
    'cliquetât',
    'cliquetâtes',
    'cliquetèrent',
    'cliqueté',
    'cliquètement',
    'clissa',
    'clissai',
    'clissaient',
    'clissais',
    'clissait',
    'clissant',
    'clissas',
    'clissasse',
    'clissassent',
    'clissasses',
    'clissassiez',
    'clissassions',
    'clisse',
    'clissent',
    'clisser',
    'clissera',
    'clisserai',
    'clisseraient',
    'clisserais',
    'clisserait',
    'clisseras',
    'clisserez',
    'clisseriez',
    'clisserions',
    'clisserons',
    'clisseront',
    'clisses',
    'clissez',
    'clissiez',
    'clissions',
    'clissons',
    'clissâmes',
    'clissât',
    'clissâtes',
    'clissèrent',
    'clissé',
    'clissée',
    'clissées',
    'clissés',
    'clitoridien',
    'clitoridiens',
    'clitoris',
    'cliva',
    'clivable',
    'clivables',
    'clivage',
    'clivages',
    'clivai',
    'clivaient',
    'clivais',
    'clivait',
    'clivant',
    'clivas',
    'clivasse',
    'clivassent',
    'clivasses',
    'clivassiez',
    'clivassions',
    'clive',
    'clivent',
    'cliver',
    'clivera',
    'cliverai',
    'cliveraient',
    'cliverais',
    'cliverait',
    'cliveras',
    'cliverez',
    'cliveriez',
    'cliverions',
    'cliverons',
    'cliveront',
    'clives',
    'clivez',
    'cliviez',
    'clivions',
    'clivons',
    'clivâmes',
    'clivât',
    'clivâtes',
    'clivèrent',
    'clivé',
    'clivée',
    'clivées',
    'clivés',
    'cloaque',
    'cloaques',
    'clocha',
    'clochai',
    'clochaient',
    'clochais',
    'clochait',
    'clochant',
    'clochard',
    'clocharde',
    'clochardes',
    'clochardisa',
    'clochardisai',
    'clochardisas',
    'clochardise',
    'clochardiser',
    'clochardises',
    'clochardisez',
    'clochardisât',
    'clochardisé',
    'clochardisée',
    'clochardisés',
    'clochards',
    'clochas',
    'clochasse',
    'clochassent',
    'clochasses',
    'clochassiez',
    'clochassions',
    'cloche',
    'clochent',
    'clocher',
    'clochera',
    'clocherai',
    'clocheraient',
    'clocherais',
    'clocherait',
    'clocheras',
    'clocherez',
    'clocheriez',
    'clocherions',
    'clocherons',
    'clocheront',
    'clochers',
    'cloches',
    'clocheton',
    'clochetons',
    'clochette',
    'clochettes',
    'clochez',
    'clochiez',
    'clochions',
    'clochons',
    'clochâmes',
    'clochât',
    'clochâtes',
    'clochèrent',
    'cloché',
    'clochée',
    'clochées',
    'clochés',
    'clodo',
    'clodos',
    'cloison',
    'cloisonna',
    'cloisonnai',
    'cloisonnais',
    'cloisonnait',
    'cloisonnant',
    'cloisonnante',
    'cloisonnants',
    'cloisonnas',
    'cloisonnasse',
    'cloisonne',
    'cloisonnent',
    'cloisonner',
    'cloisonnera',
    'cloisonnerai',
    'cloisonneras',
    'cloisonnerez',
    'cloisonnes',
    'cloisonnez',
    'cloisonniez',
    'cloisonnions',
    'cloisonnons',
    'cloisonnâmes',
    'cloisonnât',
    'cloisonnâtes',
    'cloisonné',
    'cloisonnée',
    'cloisonnées',
    'cloisonnés',
    'cloisons',
    'clone',
    'cloner',
    'clones',
    'clope',
    'clopes',
    'clopina',
    'clopinai',
    'clopinaient',
    'clopinais',
    'clopinait',
    'clopinant',
    'clopinas',
    'clopinasse',
    'clopinassent',
    'clopinasses',
    'clopinassiez',
    'clopine',
    'clopinent',
    'clopiner',
    'clopinera',
    'clopinerai',
    'clopinerais',
    'clopinerait',
    'clopineras',
    'clopinerez',
    'clopineriez',
    'clopinerions',
    'clopinerons',
    'clopineront',
    'clopines',
    'clopinettes',
    'clopinez',
    'clopiniez',
    'clopinions',
    'clopinons',
    'clopinâmes',
    'clopinât',
    'clopinâtes',
    'clopinèrent',
    'clopiné',
    'cloporte',
    'cloportes',
    'cloqua',
    'cloquai',
    'cloquaient',
    'cloquais',
    'cloquait',
    'cloquant',
    'cloquas',
    'cloquasse',
    'cloquassent',
    'cloquasses',
    'cloquassiez',
    'cloquassions',
    'cloque',
    'cloquent',
    'cloquer',
    'cloquera',
    'cloquerai',
    'cloqueraient',
    'cloquerais',
    'cloquerait',
    'cloqueras',
    'cloquerez',
    'cloqueriez',
    'cloquerions',
    'cloquerons',
    'cloqueront',
    'cloques',
    'cloquez',
    'cloquiez',
    'cloquions',
    'cloquons',
    'cloquâmes',
    'cloquât',
    'cloquâtes',
    'cloquèrent',
    'cloqué',
    'clora',
    'clorai',
    'cloraient',
    'clorais',
    'clorait',
    'cloras',
    'clore',
    'clorez',
    'cloriez',
    'clorions',
    'clorons',
    'cloront',
    'clos',
    'closant',
    'close',
    'closent',
    'closerie',
    'closeries',
    'closes',
    'closez',
    'closiez',
    'closions',
    'closons',
    'clou',
    'cloua',
    'clouai',
    'clouaient',
    'clouais',
    'clouait',
    'clouant',
    'clouas',
    'clouasse',
    'clouassent',
    'clouasses',
    'clouassiez',
    'clouassions',
    'cloue',
    'clouent',
    'clouer',
    'clouera',
    'clouerai',
    'cloueraient',
    'clouerais',
    'clouerait',
    'cloueras',
    'clouerez',
    'cloueriez',
    'clouerions',
    'clouerons',
    'cloueront',
    'cloues',
    'clouez',
    'clouiez',
    'clouions',
    'clouons',
    'clous',
    'clouta',
    'cloutage',
    'cloutages',
    'cloutai',
    'cloutaient',
    'cloutais',
    'cloutait',
    'cloutant',
    'cloutard',
    'cloutards',
    'cloutas',
    'cloutasse',
    'cloutassent',
    'cloutasses',
    'cloutassiez',
    'cloutassions',
    'cloute',
    'cloutent',
    'clouter',
    'cloutera',
    'clouterai',
    'clouteraient',
    'clouterais',
    'clouterait',
    'clouteras',
    'clouterez',
    'clouterie',
    'clouteries',
    'clouteriez',
    'clouterions',
    'clouterons',
    'clouteront',
    'cloutes',
    'cloutez',
    'cloutier',
    'cloutiers',
    'cloutiez',
    'cloutions',
    'cloutons',
    'cloutâmes',
    'cloutât',
    'cloutâtes',
    'cloutèrent',
    'clouté',
    'cloutée',
    'cloutées',
    'cloutés',
    'clouâmes',
    'clouât',
    'clouâtes',
    'clouèrent',
    'cloué',
    'clouée',
    'clouées',
    'cloués',
    'clovisse',
    'clovisses',
    'clown',
    'clownerie',
    'clowneries',
    'clownesque',
    'clownesques',
    'clowns',
    'cloyère',
    'cloyères',
    'cloîtra',
    'cloîtrai',
    'cloîtraient',
    'cloîtrais',
    'cloîtrait',
    'cloîtrant',
    'cloîtras',
    'cloîtrasse',
    'cloîtrassent',
    'cloîtrasses',
    'cloîtrassiez',
    'cloître',
    'cloîtrent',
    'cloîtrer',
    'cloîtrera',
    'cloîtrerai',
    'cloîtrerais',
    'cloîtrerait',
    'cloîtreras',
    'cloîtrerez',
    'cloîtreriez',
    'cloîtrerions',
    'cloîtrerons',
    'cloîtreront',
    'cloîtres',
    'cloîtrez',
    'cloîtriez',
    'cloîtrions',
    'cloîtrons',
    'cloîtrâmes',
    'cloîtrât',
    'cloîtrâtes',
    'cloîtrèrent',
    'cloîtré',
    'cloîtrée',
    'cloîtrées',
    'cloîtrés',
    'club',
    'clubiste',
    'clubistes',
    'clubs',
    'clunisien',
    'clunisienne',
    'clunisiennes',
    'clunisiens',
    'cluse',
    'cluses',
    'clystère',
    'clystères',
    'clématite',
    'clématites',
    'clémence',
    'clémences',
    'clément',
    'clémente',
    'clémentes',
    'clémentine',
    'clémentines',
    'clémentinier',
    'cléments',
    'clérical',
    'cléricale',
    'cléricales',
    'cléricalisme',
    'cléricature',
    'cléricatures',
    'cléricaux',
    'clés',
    'clôt',
    'clôtura',
    'clôturai',
    'clôturaient',
    'clôturais',
    'clôturait',
    'clôturant',
    'clôturas',
    'clôturasse',
    'clôturassent',
    'clôturasses',
    'clôturassiez',
    'clôture',
    'clôturent',
    'clôturer',
    'clôturera',
    'clôturerai',
    'clôturerais',
    'clôturerait',
    'clôtureras',
    'clôturerez',
    'clôtureriez',
    'clôturerions',
    'clôturerons',
    'clôtureront',
    'clôtures',
    'clôturez',
    'clôturiez',
    'clôturions',
    'clôturons',
    'clôturâmes',
    'clôturât',
    'clôturâtes',
    'clôturèrent',
    'clôturé',
    'clôturée',
    'clôturées',
    'clôturés',
    'cnémide',
    'cnémides',
    'coaccusé',
    'coaccusée',
    'coaccusées',
    'coaccusés',
    'coach',
    'coaches',
    'coacquéreur',
    'coacquéreurs',
    'coadjuteur',
    'coadjuteurs',
    'coadjutrice',
    'coadjutrices',
    'coagula',
    'coagulable',
    'coagulables',
    'coagulai',
    'coagulaient',
    'coagulais',
    'coagulait',
    'coagulant',
    'coagulante',
    'coagulantes',
    'coagulants',
    'coagulas',
    'coagulasse',
    'coagulassent',
    'coagulasses',
    'coagulassiez',
    'coagulateur',
    'coagulateurs',
    'coagulation',
    'coagulations',
    'coagulatrice',
    'coagule',
    'coagulent',
    'coaguler',
    'coagulera',
    'coagulerai',
    'coagulerais',
    'coagulerait',
    'coaguleras',
    'coagulerez',
    'coaguleriez',
    'coagulerions',
    'coagulerons',
    'coaguleront',
    'coagules',
    'coagulez',
    'coaguliez',
    'coagulions',
    'coagulons',
    'coagulum',
    'coagulums',
    'coagulâmes',
    'coagulât',
    'coagulâtes',
    'coagulèrent',
    'coagulé',
    'coagulée',
    'coagulées',
    'coagulés',
    'coalescence',
    'coalescences',
    'coalescer',
    'coalisa',
    'coalisai',
    'coalisaient',
    'coalisais',
    'coalisait',
    'coalisant',
    'coalisas',
    'coalisasse',
    'coalisassent',
    'coalisasses',
    'coalisassiez',
    'coalise',
    'coalisent',
    'coaliser',
    'coalisera',
    'coaliserai',
    'coaliserais',
    'coaliserait',
    'coaliseras',
    'coaliserez',
    'coaliseriez',
    'coaliserions',
    'coaliserons',
    'coaliseront',
    'coalises',
    'coalisez',
    'coalisiez',
    'coalisions',
    'coalisons',
    'coalisâmes',
    'coalisât',
    'coalisâtes',
    'coalisèrent',
    'coalisé',
    'coalisée',
    'coalisées',
    'coalisés',
    'coalition',
    'coalitions',
    'coaltar',
    'coaltars',
    'coaptation',
    'coaptations',
    'coarctation',
    'coarctations',
    'coassa',
    'coassai',
    'coassaient',
    'coassais',
    'coassait',
    'coassant',
    'coassas',
    'coassasse',
    'coassassent',
    'coassasses',
    'coassassiez',
    'coassassions',
    'coasse',
    'coassement',
    'coassements',
    'coassent',
    'coasser',
    'coassera',
    'coasserai',
    'coasseraient',
    'coasserais',
    'coasserait',
    'coasseras',
    'coasserez',
    'coasseriez',
    'coasserions',
    'coasserons',
    'coasseront',
    'coasses',
    'coassez',
    'coassiez',
    'coassions',
    'coassocié',
    'coassociée',
    'coassociées',
    'coassociés',
    'coassons',
    'coassurance',
    'coassurances',
    'coassâmes',
    'coassât',
    'coassâtes',
    'coassèrent',
    'coassé',
    'coati',
    'coatis',
    'coauteur',
    'coauteurs',
    'coaxial',
    'coaxiale',
    'coaxiales',
    'coaxiaux',
    'cobalt',
    'cobaye',
    'cobayes',
    'cobol',
    'cobra',
    'cobras',
    'cobéa',
    'cobéas',
    'coca',
    'cocagne',
    'cocarde',
    'cocardes',
    'cocardier',
    'cocardiers',
    'cocardière',
    'cocardières',
    'cocas',
    'cocasse',
    'cocasserie',
    'cocasseries',
    'cocasses',
    'cocaution',
    'cocaïne',
    'cocaïnomane',
    'cocaïnomanes',
    'cocaïnomanie',
    'coccidie',
    'coccidies',
    'coccidiose',
    'coccidioses',
    'coccinelle',
    'coccinelles',
    'coccygien',
    'coccygienne',
    'coccygiennes',
    'coccygiens',
    'coccyx',
    'cocha',
    'cochai',
    'cochaient',
    'cochais',
    'cochait',
    'cochant',
    'cochas',
    'cochasse',
    'cochassent',
    'cochasses',
    'cochassiez',
    'cochassions',
    'coche',
    'cochenille',
    'cochenilles',
    'cochent',
    'cocher',
    'cochera',
    'cocherai',
    'cocheraient',
    'cocherais',
    'cocherait',
    'cocheras',
    'cocherez',
    'cocheriez',
    'cocherions',
    'cocherons',
    'cocheront',
    'cochers',
    'coches',
    'cochez',
    'cochiez',
    'cochions',
    'cochléaire',
    'cochléaires',
    'cochléaria',
    'cochléarias',
    'cochon',
    'cochonceté',
    'cochoncetés',
    'cochonna',
    'cochonnai',
    'cochonnaient',
    'cochonnaille',
    'cochonnais',
    'cochonnait',
    'cochonnant',
    'cochonnas',
    'cochonnasse',
    'cochonnasses',
    'cochonne',
    'cochonnent',
    'cochonner',
    'cochonnera',
    'cochonnerai',
    'cochonnerais',
    'cochonnerait',
    'cochonneras',
    'cochonnerez',
    'cochonnerie',
    'cochonneries',
    'cochonneriez',
    'cochonnerons',
    'cochonneront',
    'cochonnes',
    'cochonnet',
    'cochonnets',
    'cochonnez',
    'cochonniez',
    'cochonnions',
    'cochonnons',
    'cochonnâmes',
    'cochonnât',
    'cochonnâtes',
    'cochonnèrent',
    'cochonné',
    'cochonnée',
    'cochonnées',
    'cochonnés',
    'cochons',
    'cochylis',
    'cochâmes',
    'cochât',
    'cochâtes',
    'cochère',
    'cochèrent',
    'cochères',
    'coché',
    'cochée',
    'cochées',
    'cochés',
    'cocker',
    'cockers',
    'cockney',
    'cockneys',
    'cockpit',
    'cockpits',
    'cocktail',
    'cocktails',
    'coco',
    'cocon',
    'cocons',
    'cocorico',
    'cocoricos',
    'cocos',
    'cocotier',
    'cocotiers',
    'cocotte',
    'cocottes',
    'cocréancier',
    'cocréanciers',
    'cocréancière',
    'coction',
    'coctions',
    'cocu',
    'cocuage',
    'cocuages',
    'cocufia',
    'cocufiai',
    'cocufiaient',
    'cocufiais',
    'cocufiait',
    'cocufiant',
    'cocufias',
    'cocufiasse',
    'cocufiassent',
    'cocufiasses',
    'cocufiassiez',
    'cocufie',
    'cocufient',
    'cocufier',
    'cocufiera',
    'cocufierai',
    'cocufierais',
    'cocufierait',
    'cocufieras',
    'cocufierez',
    'cocufieriez',
    'cocufierions',
    'cocufierons',
    'cocufieront',
    'cocufies',
    'cocufiez',
    'cocufiiez',
    'cocufiions',
    'cocufions',
    'cocufiâmes',
    'cocufiât',
    'cocufiâtes',
    'cocufièrent',
    'cocufié',
    'cocufiée',
    'cocufiées',
    'cocufiés',
    'cocus',
    'cocyclique',
    'cocycliques',
    'coda',
    'codage',
    'codages',
    'codai',
    'codaient',
    'codais',
    'codait',
    'codant',
    'codas',
    'codasse',
    'codassent',
    'codasses',
    'codassiez',
    'codassions',
    'code',
    'codemandeur',
    'codemandeurs',
    'codent',
    'coder',
    'codera',
    'coderai',
    'coderaient',
    'coderais',
    'coderait',
    'coderas',
    'coderez',
    'coderiez',
    'coderions',
    'coderons',
    'coderont',
    'codes',
    'codeur',
    'codeurs',
    'codeuse',
    'codeuses',
    'codex',
    'codez',
    'codicille',
    'codicilles',
    'codiez',
    'codifia',
    'codifiai',
    'codifiaient',
    'codifiais',
    'codifiait',
    'codifiant',
    'codifias',
    'codifiasse',
    'codifiassent',
    'codifiasses',
    'codifiassiez',
    'codificateur',
    'codification',
    'codifie',
    'codifient',
    'codifier',
    'codifiera',
    'codifierai',
    'codifierais',
    'codifierait',
    'codifieras',
    'codifierez',
    'codifieriez',
    'codifierions',
    'codifierons',
    'codifieront',
    'codifies',
    'codifiez',
    'codifiiez',
    'codifiions',
    'codifions',
    'codifiâmes',
    'codifiât',
    'codifiâtes',
    'codifièrent',
    'codifié',
    'codifiée',
    'codifiées',
    'codifiés',
    'codions',
    'codirecteur',
    'codirecteurs',
    'codirection',
    'codirections',
    'codirectrice',
    'codominance',
    'codominances',
    'codon',
    'codons',
    'codâmes',
    'codât',
    'codâtes',
    'codèrent',
    'codé',
    'codébiteur',
    'codébiteurs',
    'codébitrice',
    'codébitrices',
    'codée',
    'codées',
    'codéine',
    'codés',
    'codétenteur',
    'codétenteurs',
    'codétentrice',
    'codétenu',
    'codétenue',
    'codétenues',
    'codétenus',
    'coefficient',
    'coefficients',
    'coelacanthe',
    'coelacanthes',
    'coeliaque',
    'coeliaques',
    'coelioscopie',
    'coenzyme',
    'coenzymes',
    'coercibilité',
    'coercible',
    'coercibles',
    'coercitif',
    'coercitifs',
    'coercition',
    'coercitions',
    'coercitive',
    'coercitives',
    'coeur',
    'coeurs',
    'coexista',
    'coexistai',
    'coexistaient',
    'coexistais',
    'coexistait',
    'coexistant',
    'coexistante',
    'coexistantes',
    'coexistants',
    'coexistas',
    'coexistasse',
    'coexistasses',
    'coexiste',
    'coexistence',
    'coexistences',
    'coexistent',
    'coexister',
    'coexistera',
    'coexisterai',
    'coexisterais',
    'coexisterait',
    'coexisteras',
    'coexisterez',
    'coexisteriez',
    'coexisterons',
    'coexisteront',
    'coexistes',
    'coexistez',
    'coexistiez',
    'coexistions',
    'coexistons',
    'coexistâmes',
    'coexistât',
    'coexistâtes',
    'coexistèrent',
    'coexisté',
    'coextensif',
    'coextensifs',
    'coextensive',
    'coextensives',
    'cofacé',
    'cofacée',
    'cofacées',
    'cofacés',
    'coffin',
    'coffins',
    'coffra',
    'coffrage',
    'coffrages',
    'coffrai',
    'coffraient',
    'coffrais',
    'coffrait',
    'coffrant',
    'coffras',
    'coffrasse',
    'coffrassent',
    'coffrasses',
    'coffrassiez',
    'coffrassions',
    'coffre',
    'coffrent',
    'coffrer',
    'coffrera',
    'coffrerai',
    'coffreraient',
    'coffrerais',
    'coffrerait',
    'coffreras',
    'coffrerez',
    'coffreriez',
    'coffrerions',
    'coffrerons',
    'coffreront',
    'coffres',
    'coffret',
    'coffrets',
    'coffrez',
    'coffriez',
    'coffrions',
    'coffrons',
    'coffrâmes',
    'coffrât',
    'coffrâtes',
    'coffrèrent',
    'coffré',
    'coffrée',
    'coffrées',
    'coffrés',
    'cogestion',
    'cogestions',
    'cogita',
    'cogitai',
    'cogitaient',
    'cogitais',
    'cogitait',
    'cogitant',
    'cogitante',
    'cogitantes',
    'cogitants',
    'cogitas',
    'cogitasse',
    'cogitassent',
    'cogitasses',
    'cogitassiez',
    'cogitassions',
    'cogitation',
    'cogitations',
    'cogite',
    'cogitent',
    'cogiter',
    'cogitera',
    'cogiterai',
    'cogiteraient',
    'cogiterais',
    'cogiterait',
    'cogiteras',
    'cogiterez',
    'cogiteriez',
    'cogiterions',
    'cogiterons',
    'cogiteront',
    'cogites',
    'cogitez',
    'cogitiez',
    'cogitions',
    'cogito',
    'cogitons',
    'cogitâmes',
    'cogitât',
    'cogitâtes',
    'cogitèrent',
    'cogité',
    'cogitée',
    'cogitées',
    'cogités',
    'cogna',
    'cognac',
    'cognacs',
    'cognai',
    'cognaient',
    'cognais',
    'cognait',
    'cognant',
    'cognas',
    'cognasse',
    'cognassent',
    'cognasses',
    'cognassier',
    'cognassiers',
    'cognassiez',
    'cognassions',
    'cognat',
    'cognation',
    'cognations',
    'cognats',
    'cogne',
    'cognement',
    'cognements',
    'cognent',
    'cogner',
    'cognera',
    'cognerai',
    'cogneraient',
    'cognerais',
    'cognerait',
    'cogneras',
    'cognerez',
    'cogneriez',
    'cognerions',
    'cognerons',
    'cogneront',
    'cognes',
    'cognez',
    'cogniez',
    'cognions',
    'cognitif',
    'cognitifs',
    'cognitive',
    'cognitives',
    'cognons',
    'cognâmes',
    'cognât',
    'cognâtes',
    'cognèrent',
    'cogné',
    'cognée',
    'cognées',
    'cognés',
    'cogère',
    'cogèrent',
    'cogères',
    'cogéra',
    'cogéraient',
    'cogérais',
    'cogérait',
    'cogérance',
    'cogérances',
    'cogérant',
    'cogérante',
    'cogérantes',
    'cogérants',
    'cogérer',
    'cogérera',
    'cogérerai',
    'cogéreraient',
    'cogérerais',
    'cogérerait',
    'cogéreras',
    'cogérerez',
    'cogéreriez',
    'cogérerions',
    'cogérerons',
    'cogéreront',
    'cogérez',
    'cogériez',
    'cogérions',
    'cogérons',
    'cogérèrent',
    'cogéré',
    'cogérée',
    'cogérées',
    'cogérés',
    'cohabita',
    'cohabitai',
    'cohabitaient',
    'cohabitais',
    'cohabitait',
    'cohabitant',
    'cohabitante',
    'cohabitantes',
    'cohabitants',
    'cohabitas',
    'cohabitasse',
    'cohabitasses',
    'cohabitation',
    'cohabite',
    'cohabitent',
    'cohabiter',
    'cohabitera',
    'cohabiterai',
    'cohabiterais',
    'cohabiterait',
    'cohabiteras',
    'cohabiterez',
    'cohabiteriez',
    'cohabiterons',
    'cohabiteront',
    'cohabites',
    'cohabitez',
    'cohabitiez',
    'cohabitions',
    'cohabitons',
    'cohabitâmes',
    'cohabitât',
    'cohabitâtes',
    'cohabitèrent',
    'cohabité',
    'cohorte',
    'cohortes',
    'cohue',
    'cohues',
    'cohérence',
    'cohérences',
    'cohérent',
    'cohérente',
    'cohérentes',
    'cohérents',
    'cohéreur',
    'cohéreurs',
    'cohérita',
    'cohéritai',
    'cohéritaient',
    'cohéritais',
    'cohéritait',
    'cohéritant',
    'cohéritas',
    'cohéritasse',
    'cohéritasses',
    'cohérite',
    'cohéritent',
    'cohériter',
    'cohéritera',
    'cohériterai',
    'cohériterais',
    'cohériterait',
    'cohériteras',
    'cohériterez',
    'cohériteriez',
    'cohériterons',
    'cohériteront',
    'cohérites',
    'cohéritez',
    'cohéritier',
    'cohéritiers',
    'cohéritiez',
    'cohéritions',
    'cohéritière',
    'cohéritières',
    'cohéritons',
    'cohéritâmes',
    'cohéritât',
    'cohéritâtes',
    'cohéritèrent',
    'cohérité',
    'cohésif',
    'cohésifs',
    'cohésion',
    'cohésions',
    'cohésive',
    'cohésives',
    'coiffa',
    'coiffai',
    'coiffaient',
    'coiffais',
    'coiffait',
    'coiffant',
    'coiffante',
    'coiffantes',
    'coiffants',
    'coiffas',
    'coiffasse',
    'coiffassent',
    'coiffasses',
    'coiffassiez',
    'coiffassions',
    'coiffe',
    'coiffent',
    'coiffer',
    'coiffera',
    'coifferai',
    'coifferaient',
    'coifferais',
    'coifferait',
    'coifferas',
    'coifferez',
    'coifferiez',
    'coifferions',
    'coifferons',
    'coifferont',
    'coiffes',
    'coiffeur',
    'coiffeurs',
    'coiffeuse',
    'coiffeuses',
    'coiffez',
    'coiffiez',
    'coiffions',
    'coiffons',
    'coiffure',
    'coiffures',
    'coiffâmes',
    'coiffât',
    'coiffâtes',
    'coiffèrent',
    'coiffé',
    'coiffée',
    'coiffées',
    'coiffés',
    'coin',
    'coince',
    'coincement',
    'coincements',
    'coincent',
    'coincer',
    'coincera',
    'coincerai',
    'coinceraient',
    'coincerais',
    'coincerait',
    'coinceras',
    'coincerez',
    'coinceriez',
    'coincerions',
    'coincerons',
    'coinceront',
    'coinces',
    'coincez',
    'coinciez',
    'coincions',
    'coincèrent',
    'coincé',
    'coincée',
    'coincées',
    'coincés',
    'coing',
    'coings',
    'coins',
    'coinça',
    'coinçai',
    'coinçaient',
    'coinçais',
    'coinçait',
    'coinçant',
    'coinças',
    'coinçasse',
    'coinçassent',
    'coinçasses',
    'coinçassiez',
    'coinçassions',
    'coinçons',
    'coinçâmes',
    'coinçât',
    'coinçâtes',
    'cois',
    'coite',
    'coites',
    'coke',
    'cokerie',
    'cokeries',
    'cokéfaction',
    'cokéfactions',
    'cokéfia',
    'cokéfiai',
    'cokéfiaient',
    'cokéfiais',
    'cokéfiait',
    'cokéfiant',
    'cokéfiante',
    'cokéfiantes',
    'cokéfiants',
    'cokéfias',
    'cokéfiasse',
    'cokéfiassent',
    'cokéfiasses',
    'cokéfiassiez',
    'cokéfie',
    'cokéfient',
    'cokéfier',
    'cokéfiera',
    'cokéfierai',
    'cokéfierais',
    'cokéfierait',
    'cokéfieras',
    'cokéfierez',
    'cokéfieriez',
    'cokéfierions',
    'cokéfierons',
    'cokéfieront',
    'cokéfies',
    'cokéfiez',
    'cokéfiiez',
    'cokéfiions',
    'cokéfions',
    'cokéfiâmes',
    'cokéfiât',
    'cokéfiâtes',
    'cokéfièrent',
    'cokéfié',
    'cokéfiée',
    'cokéfiées',
    'cokéfiés',
    'cola',
    'colature',
    'colatures',
    'colback',
    'colbacks',
    'colchicine',
    'colchicines',
    'colchique',
    'colchiques',
    'colcotar',
    'colcotars',
    'colibacille',
    'colibacilles',
    'colibri',
    'colibris',
    'colicitant',
    'colicitante',
    'colicitantes',
    'colicitants',
    'colifichet',
    'colifichets',
    'colimaçon',
    'colimaçons',
    'colin',
    'colineau',
    'colineaux',
    'colinot',
    'colinots',
    'colins',
    'colique',
    'coliques',
    'colis',
    'colistier',
    'colistiers',
    'colistière',
    'colistières',
    'colite',
    'colites',
    'colla',
    'collabora',
    'collaborai',
    'collaborais',
    'collaborait',
    'collaborant',
    'collaboras',
    'collaborasse',
    'collabore',
    'collaborent',
    'collaborer',
    'collaborera',
    'collaborerai',
    'collaboreras',
    'collaborerez',
    'collabores',
    'collaborez',
    'collaboriez',
    'collaborions',
    'collaborons',
    'collaborâmes',
    'collaborât',
    'collaborâtes',
    'collaboré',
    'collaborée',
    'collaborées',
    'collaborés',
    'collage',
    'collages',
    'collagène',
    'collagènes',
    'collai',
    'collaient',
    'collais',
    'collait',
    'collant',
    'collante',
    'collantes',
    'collants',
    'collapsus',
    'collargol',
    'collas',
    'collasse',
    'collassent',
    'collasses',
    'collassiez',
    'collassions',
    'collateur',
    'collateurs',
    'collation',
    'collationna',
    'collationnai',
    'collationnas',
    'collationne',
    'collationner',
    'collationnes',
    'collationnez',
    'collationnât',
    'collationné',
    'collationnée',
    'collationnés',
    'collations',
    'collatéral',
    'collatérale',
    'collatérales',
    'collatéraux',
    'colle',
    'collecta',
    'collectage',
    'collectages',
    'collectai',
    'collectaient',
    'collectais',
    'collectait',
    'collectant',
    'collectas',
    'collectasse',
    'collectasses',
    'collecte',
    'collectent',
    'collecter',
    'collectera',
    'collecterai',
    'collecterais',
    'collecterait',
    'collecteras',
    'collecterez',
    'collecteriez',
    'collecterons',
    'collecteront',
    'collectes',
    'collecteur',
    'collecteurs',
    'collectez',
    'collectiez',
    'collectif',
    'collectifs',
    'collection',
    'collectionna',
    'collectionne',
    'collectionné',
    'collections',
    'collective',
    'collectives',
    'collectivisa',
    'collectivise',
    'collectivisé',
    'collectivité',
    'collectons',
    'collectrice',
    'collectrices',
    'collectâmes',
    'collectât',
    'collectâtes',
    'collectèrent',
    'collecté',
    'collectée',
    'collectées',
    'collectés',
    'collent',
    'coller',
    'collera',
    'collerai',
    'colleraient',
    'collerais',
    'collerait',
    'colleras',
    'collerette',
    'collerettes',
    'collerez',
    'colleriez',
    'collerions',
    'collerons',
    'colleront',
    'colles',
    'collet',
    'colleta',
    'colletai',
    'colletaient',
    'colletais',
    'colletait',
    'colletant',
    'colletas',
    'colletasse',
    'colletassent',
    'colletasses',
    'colletassiez',
    'colleter',
    'colleteur',
    'colleteurs',
    'colletez',
    'colletiez',
    'colletions',
    'colletons',
    'collets',
    'collette',
    'collettent',
    'collettera',
    'colletterai',
    'colletterais',
    'colletterait',
    'colletteras',
    'colletterez',
    'colletteriez',
    'colletterons',
    'colletteront',
    'collettes',
    'colletâmes',
    'colletât',
    'colletâtes',
    'colletèrent',
    'colleté',
    'colletée',
    'colletées',
    'colletés',
    'colleur',
    'colleurs',
    'colleuse',
    'colleuses',
    'colley',
    'colleys',
    'collez',
    'collier',
    'colliers',
    'colliez',
    'collige',
    'colligea',
    'colligeai',
    'colligeaient',
    'colligeais',
    'colligeait',
    'colligeant',
    'colligeas',
    'colligeasse',
    'colligeasses',
    'colligent',
    'colligeons',
    'colliger',
    'colligera',
    'colligerai',
    'colligerais',
    'colligerait',
    'colligeras',
    'colligerez',
    'colligeriez',
    'colligerions',
    'colligerons',
    'colligeront',
    'colliges',
    'colligez',
    'colligeâmes',
    'colligeât',
    'colligeâtes',
    'colligiez',
    'colligions',
    'colligèrent',
    'colligé',
    'colligée',
    'colligées',
    'colligés',
    'collimateur',
    'collimateurs',
    'collimation',
    'collimations',
    'colline',
    'collines',
    'collions',
    'collision',
    'collisions',
    'collocation',
    'collocations',
    'collodion',
    'collodions',
    'collons',
    'colloqua',
    'colloquai',
    'colloquaient',
    'colloquais',
    'colloquait',
    'colloquant',
    'colloquas',
    'colloquasse',
    'colloquasses',
    'colloque',
    'colloquent',
    'colloquer',
    'colloquera',
    'colloquerai',
    'colloquerais',
    'colloquerait',
    'colloqueras',
    'colloquerez',
    'colloqueriez',
    'colloquerons',
    'colloqueront',
    'colloques',
    'colloquez',
    'colloquiez',
    'colloquions',
    'colloquons',
    'colloquâmes',
    'colloquât',
    'colloquâtes',
    'colloquèrent',
    'colloqué',
    'colloquée',
    'colloquées',
    'colloqués',
    'colloïdal',
    'colloïdale',
    'colloïdales',
    'colloïdaux',
    'colloïde',
    'colloïdes',
    'collusion',
    'collusions',
    'collusoire',
    'collusoires',
    'collutoire',
    'collutoires',
    'colluvion',
    'colluvions',
    'collyre',
    'collyres',
    'collâmes',
    'collât',
    'collâtes',
    'collège',
    'collèges',
    'collègue',
    'collègues',
    'collèrent',
    'collé',
    'collée',
    'collées',
    'collégial',
    'collégiale',
    'collégiales',
    'collégialité',
    'collégiaux',
    'collégien',
    'collégienne',
    'collégiennes',
    'collégiens',
    'collés',
    'colmata',
    'colmatage',
    'colmatages',
    'colmatai',
    'colmataient',
    'colmatais',
    'colmatait',
    'colmatant',
    'colmatas',
    'colmatasse',
    'colmatassent',
    'colmatasses',
    'colmatassiez',
    'colmate',
    'colmatent',
    'colmater',
    'colmatera',
    'colmaterai',
    'colmaterais',
    'colmaterait',
    'colmateras',
    'colmaterez',
    'colmateriez',
    'colmaterions',
    'colmaterons',
    'colmateront',
    'colmates',
    'colmatez',
    'colmatiez',
    'colmations',
    'colmatons',
    'colmatâmes',
    'colmatât',
    'colmatâtes',
    'colmatèrent',
    'colmaté',
    'colmatée',
    'colmatées',
    'colmatés',
    'colocase',
    'colocases',
    'colocataire',
    'colocataires',
    'cologarithme',
    'colombage',
    'colombages',
    'colombe',
    'colombes',
    'colombier',
    'colombiers',
    'colombin',
    'colombine',
    'colombines',
    'colombins',
    'colombophile',
    'colon',
    'colonage',
    'colonages',
    'colonat',
    'colonats',
    'colonel',
    'colonelle',
    'colonelles',
    'colonels',
    'colonial',
    'coloniale',
    'coloniales',
    'colonialisme',
    'colonialiste',
    'coloniaux',
    'colonie',
    'colonies',
    'colonisa',
    'colonisai',
    'colonisaient',
    'colonisais',
    'colonisait',
    'colonisant',
    'colonisas',
    'colonisasse',
    'colonisasses',
    'colonisateur',
    'colonisation',
    'colonise',
    'colonisent',
    'coloniser',
    'colonisera',
    'coloniserai',
    'coloniserais',
    'coloniserait',
    'coloniseras',
    'coloniserez',
    'coloniseriez',
    'coloniserons',
    'coloniseront',
    'colonises',
    'colonisez',
    'colonisiez',
    'colonisions',
    'colonisons',
    'colonisâmes',
    'colonisât',
    'colonisâtes',
    'colonisèrent',
    'colonisé',
    'colonisée',
    'colonisées',
    'colonisés',
    'colonnade',
    'colonnades',
    'colonne',
    'colonnes',
    'colonnette',
    'colonnettes',
    'colons',
    'colophane',
    'colophanes',
    'coloquinte',
    'coloquintes',
    'colora',
    'colorai',
    'coloraient',
    'colorais',
    'colorait',
    'colorant',
    'colorante',
    'colorantes',
    'colorants',
    'coloras',
    'colorasse',
    'colorassent',
    'colorasses',
    'colorassiez',
    'colorassions',
    'coloration',
    'colorations',
    'colore',
    'colorent',
    'colorer',
    'colorera',
    'colorerai',
    'coloreraient',
    'colorerais',
    'colorerait',
    'coloreras',
    'colorerez',
    'coloreriez',
    'colorerions',
    'colorerons',
    'coloreront',
    'colores',
    'colorez',
    'coloria',
    'coloriage',
    'coloriages',
    'coloriai',
    'coloriaient',
    'coloriais',
    'coloriait',
    'coloriant',
    'colorias',
    'coloriasse',
    'coloriassent',
    'coloriasses',
    'coloriassiez',
    'colorie',
    'colorient',
    'colorier',
    'coloriera',
    'colorierai',
    'colorierais',
    'colorierait',
    'colorieras',
    'colorierez',
    'colorieriez',
    'colorierions',
    'colorierons',
    'colorieront',
    'colories',
    'coloriez',
    'coloriiez',
    'coloriions',
    'colorimètre',
    'colorimètres',
    'colorimétrie',
    'colorions',
    'coloris',
    'colorisation',
    'coloriste',
    'coloristes',
    'coloriâmes',
    'coloriât',
    'coloriâtes',
    'colorièrent',
    'colorié',
    'coloriée',
    'coloriées',
    'coloriés',
    'colorlinks',
    'colorons',
    'colorâmes',
    'colorât',
    'colorâtes',
    'colorèrent',
    'coloré',
    'colorée',
    'colorées',
    'colorés',
    'colossal',
    'colossale',
    'colossales',
    'colossaux',
    'colosse',
    'colosses',
    'colostrum',
    'colostrums',
    'colourall',
    'colporta',
    'colportage',
    'colportages',
    'colportai',
    'colportaient',
    'colportais',
    'colportait',
    'colportant',
    'colportas',
    'colportasse',
    'colportasses',
    'colporte',
    'colportent',
    'colporter',
    'colportera',
    'colporterai',
    'colporterais',
    'colporterait',
    'colporteras',
    'colporterez',
    'colporteriez',
    'colporterons',
    'colporteront',
    'colportes',
    'colporteur',
    'colporteurs',
    'colporteuse',
    'colporteuses',
    'colportez',
    'colportiez',
    'colportions',
    'colportons',
    'colportâmes',
    'colportât',
    'colportâtes',
    'colportèrent',
    'colporté',
    'colportée',
    'colportées',
    'colportés',
    'colposcopie',
    'colposcopies',
    'cols',
    'colt',
    'coltina',
    'coltinage',
    'coltinages',
    'coltinai',
    'coltinaient',
    'coltinais',
    'coltinait',
    'coltinant',
    'coltinas',
    'coltinasse',
    'coltinassent',
    'coltinasses',
    'coltinassiez',
    'coltine',
    'coltinent',
    'coltiner',
    'coltinera',
    'coltinerai',
    'coltinerais',
    'coltinerait',
    'coltineras',
    'coltinerez',
    'coltineriez',
    'coltinerions',
    'coltinerons',
    'coltineront',
    'coltines',
    'coltinez',
    'coltiniez',
    'coltinions',
    'coltinons',
    'coltinâmes',
    'coltinât',
    'coltinâtes',
    'coltinèrent',
    'coltiné',
    'coltinée',
    'coltinées',
    'coltinés',
    'colts',
    'columbarium',
    'columbariums',
    'columelle',
    'columelles',
    'colvert',
    'colverts',
    'colza',
    'colzatier',
    'colzatiers',
    'colère',
    'colères',
    'colégataire',
    'colégataires',
    'coléoptère',
    'coléoptères',
    'coléreuse',
    'coléreuses',
    'coléreux',
    'colérique',
    'colériques',
    'coma',
    'comas',
    'comateuse',
    'comateuses',
    'comateux',
    'combat',
    'combatif',
    'combatifs',
    'combative',
    'combatives',
    'combativité',
    'combativités',
    'combats',
    'combattaient',
    'combattais',
    'combattait',
    'combattant',
    'combattante',
    'combattantes',
    'combattants',
    'combatte',
    'combattent',
    'combattes',
    'combattez',
    'combattiez',
    'combattions',
    'combattirent',
    'combattis',
    'combattisse',
    'combattisses',
    'combattit',
    'combattons',
    'combattra',
    'combattrai',
    'combattrais',
    'combattrait',
    'combattras',
    'combattre',
    'combattrez',
    'combattriez',
    'combattrions',
    'combattrons',
    'combattront',
    'combattu',
    'combattue',
    'combattues',
    'combattus',
    'combattîmes',
    'combattît',
    'combattîtes',
    'combe',
    'combes',
    'combien',
    'combientième',
    'combina',
    'combinable',
    'combinables',
    'combinai',
    'combinaient',
    'combinais',
    'combinaison',
    'combinaisons',
    'combinait',
    'combinant',
    'combinard',
    'combinarde',
    'combinardes',
    'combinards',
    'combinas',
    'combinasse',
    'combinassent',
    'combinasses',
    'combinassiez',
    'combinat',
    'combinateur',
    'combinateurs',
    'combinatoire',
    'combinats',
    'combine',
    'combinent',
    'combiner',
    'combinera',
    'combinerai',
    'combinerais',
    'combinerait',
    'combineras',
    'combinerez',
    'combineriez',
    'combinerions',
    'combinerons',
    'combineront',
    'combines',
    'combinez',
    'combiniez',
    'combinions',
    'combinons',
    'combinâmes',
    'combinât',
    'combinâtes',
    'combinèrent',
    'combiné',
    'combinée',
    'combinées',
    'combinés',
    'combla',
    'comblai',
    'comblaient',
    'comblais',
    'comblait',
    'comblanchien',
    'comblant',
    'comblas',
    'comblasse',
    'comblassent',
    'comblasses',
    'comblassiez',
    'comblassions',
    'comble',
    'comblement',
    'comblements',
    'comblent',
    'combler',
    'comblera',
    'comblerai',
    'combleraient',
    'comblerais',
    'comblerait',
    'combleras',
    'comblerez',
    'combleriez',
    'comblerions',
    'comblerons',
    'combleront',
    'combles',
    'comblez',
    'combliez',
    'comblions',
    'comblons',
    'comblâmes',
    'comblât',
    'comblâtes',
    'comblèrent',
    'comblé',
    'comblée',
    'comblées',
    'comblés',
    'comburant',
    'comburante',
    'comburantes',
    'comburants',
    'combustible',
    'combustibles',
    'combustion',
    'combustions',
    'comestible',
    'comestibles',
    'comice',
    'comices',
    'comics',
    'comique',
    'comiquement',
    'comiques',
    'comité',
    'comités',
    'comma',
    'commanda',
    'commandai',
    'commandaient',
    'commandais',
    'commandait',
    'commandant',
    'commandante',
    'commandantes',
    'commandants',
    'commandas',
    'commandasse',
    'commandasses',
    'commande',
    'commandement',
    'commandent',
    'commander',
    'commandera',
    'commanderai',
    'commanderais',
    'commanderait',
    'commanderas',
    'commanderez',
    'commanderie',
    'commanderies',
    'commanderiez',
    'commanderons',
    'commanderont',
    'commandes',
    'commandeur',
    'commandeurs',
    'commandeuse',
    'commandeuses',
    'commandez',
    'commandiez',
    'commandions',
    'commandita',
    'commanditai',
    'commanditais',
    'commanditait',
    'commanditant',
    'commanditas',
    'commandite',
    'commanditent',
    'commanditer',
    'commanditera',
    'commandites',
    'commanditez',
    'commanditiez',
    'commanditons',
    'commanditât',
    'commandité',
    'commanditée',
    'commanditées',
    'commandités',
    'commando',
    'commandons',
    'commandos',
    'commandâmes',
    'commandât',
    'commandâtes',
    'commandèrent',
    'commandé',
    'commandée',
    'commandées',
    'commandés',
    'commas',
    'comme',
    'commence',
    'commencement',
    'commencent',
    'commencer',
    'commencera',
    'commencerai',
    'commencerais',
    'commencerait',
    'commenceras',
    'commencerez',
    'commenceriez',
    'commencerons',
    'commenceront',
    'commences',
    'commencez',
    'commenciez',
    'commencions',
    'commencèrent',
    'commencé',
    'commencée',
    'commencées',
    'commencés',
    'commensal',
    'commensale',
    'commensales',
    'commensaux',
    'comment',
    'commenta',
    'commentai',
    'commentaient',
    'commentaire',
    'commentaires',
    'commentais',
    'commentait',
    'commentant',
    'commentas',
    'commentasse',
    'commentasses',
    'commentateur',
    'commente',
    'commentent',
    'commenter',
    'commentera',
    'commenterai',
    'commenterais',
    'commenterait',
    'commenteras',
    'commenterez',
    'commenteriez',
    'commenterons',
    'commenteront',
    'commentes',
    'commentez',
    'commentiez',
    'commentions',
    'commentons',
    'commentâmes',
    'commentât',
    'commentâtes',
    'commentèrent',
    'commenté',
    'commentée',
    'commentées',
    'commentés',
    'commença',
    'commençai',
    'commençaient',
    'commençais',
    'commençait',
    'commençant',
    'commençante',
    'commençantes',
    'commençants',
    'commenças',
    'commençasse',
    'commençasses',
    'commençons',
    'commençâmes',
    'commençât',
    'commençâtes',
    'commerce',
    'commercent',
    'commercer',
    'commercera',
    'commercerai',
    'commercerais',
    'commercerait',
    'commerceras',
    'commercerez',
    'commerceriez',
    'commercerons',
    'commerceront',
    'commerces',
    'commercez',
    'commercial',
    'commerciale',
    'commerciales',
    'commerciaux',
    'commerciez',
    'commercions',
    'commercèrent',
    'commercé',
    'commerça',
    'commerçai',
    'commerçaient',
    'commerçais',
    'commerçait',
    'commerçant',
    'commerçante',
    'commerçantes',
    'commerçants',
    'commerças',
    'commerçasse',
    'commerçasses',
    'commerçons',
    'commerçâmes',
    'commerçât',
    'commerçâtes',
    'commet',
    'commets',
    'commettaient',
    'commettais',
    'commettait',
    'commettant',
    'commettante',
    'commettantes',
    'commettants',
    'commette',
    'commettent',
    'commettes',
    'commettez',
    'commettiez',
    'commettions',
    'commettons',
    'commettra',
    'commettrai',
    'commettrais',
    'commettrait',
    'commettras',
    'commettre',
    'commettrez',
    'commettriez',
    'commettrions',
    'commettrons',
    'commettront',
    'comminatoire',
    'comminutif',
    'comminutifs',
    'comminutive',
    'comminutives',
    'commirent',
    'commis',
    'commise',
    'commises',
    'commissaire',
    'commissaires',
    'commissariat',
    'commisse',
    'commissent',
    'commisses',
    'commissiez',
    'commission',
    'commissionna',
    'commissionne',
    'commissionné',
    'commissions',
    'commissoire',
    'commissoires',
    'commissural',
    'commissurale',
    'commissuraux',
    'commissure',
    'commissures',
    'commit',
    'commode',
    'commodes',
    'commodité',
    'commodités',
    'commodore',
    'commodores',
    'commodément',
    'commotion',
    'commotionna',
    'commotionnai',
    'commotionnas',
    'commotionne',
    'commotionner',
    'commotionnes',
    'commotionnez',
    'commotionnât',
    'commotionné',
    'commotionnée',
    'commotionnés',
    'commotions',
    'commua',
    'commuable',
    'commuables',
    'commuai',
    'commuaient',
    'commuais',
    'commuait',
    'commuant',
    'commuas',
    'commuasse',
    'commuassent',
    'commuasses',
    'commuassiez',
    'commuassions',
    'commue',
    'commuent',
    'commuer',
    'commuera',
    'commuerai',
    'commueraient',
    'commuerais',
    'commuerait',
    'commueras',
    'commuerez',
    'commueriez',
    'commuerions',
    'commuerons',
    'commueront',
    'commues',
    'commuez',
    'commuiez',
    'commuions',
    'commun',
    'communal',
    'communale',
    'communales',
    'communalise',
    'communaliser',
    'communalises',
    'communalisez',
    'communalisé',
    'communalisée',
    'communalisés',
    'communard',
    'communarde',
    'communardes',
    'communards',
    'communauté',
    'communautés',
    'communaux',
    'commune',
    'communes',
    'communia',
    'communiai',
    'communiaient',
    'communiais',
    'communiait',
    'communiant',
    'communiante',
    'communiantes',
    'communiants',
    'communias',
    'communiasse',
    'communiasses',
    'communicable',
    'communicant',
    'communicante',
    'communicants',
    'communicatif',
    'communie',
    'communient',
    'communier',
    'communiera',
    'communierai',
    'communierais',
    'communierait',
    'communieras',
    'communierez',
    'communieriez',
    'communierons',
    'communieront',
    'communies',
    'communiez',
    'communiiez',
    'communiions',
    'communion',
    'communions',
    'communiqua',
    'communiquai',
    'communiquais',
    'communiquait',
    'communiquant',
    'communiquas',
    'communique',
    'communiquent',
    'communiquer',
    'communiquera',
    'communiques',
    'communiquez',
    'communiquiez',
    'communiquons',
    'communiquât',
    'communiqué',
    'communiquée',
    'communiquées',
    'communiqués',
    'communisant',
    'communisante',
    'communisants',
    'communisme',
    'communismes',
    'communiste',
    'communistes',
    'communiâmes',
    'communiât',
    'communiâtes',
    'communièrent',
    'communié',
    'communs',
    'communément',
    'commuons',
    'commuta',
    'commutable',
    'commutables',
    'commutai',
    'commutaient',
    'commutais',
    'commutait',
    'commutant',
    'commutas',
    'commutasse',
    'commutassent',
    'commutasses',
    'commutassiez',
    'commutateur',
    'commutateurs',
    'commutatif',
    'commutatifs',
    'commutation',
    'commutations',
    'commutative',
    'commutatives',
    'commute',
    'commutent',
    'commuter',
    'commutera',
    'commuterai',
    'commuterais',
    'commuterait',
    'commuteras',
    'commuterez',
    'commuteriez',
    'commuterions',
    'commuterons',
    'commuteront',
    'commutes',
    'commutez',
    'commutiez',
    'commutions',
    'commutons',
    'commutâmes',
    'commutât',
    'commutâtes',
    'commutèrent',
    'commuté',
    'commutée',
    'commutées',
    'commutés',
    'commuâmes',
    'commuât',
    'commuâtes',
    'commuèrent',
    'commué',
    'commuée',
    'commuées',
    'commués',
    'commère',
    'commèrent',
    'commères',
    'commémora',
    'commémorai',
    'commémorais',
    'commémorait',
    'commémorant',
    'commémoras',
    'commémorasse',
    'commémoratif',
    'commémore',
    'commémorent',
    'commémorer',
    'commémorera',
    'commémorerai',
    'commémoreras',
    'commémorerez',
    'commémores',
    'commémorez',
    'commémoriez',
    'commémorions',
    'commémorons',
    'commémorâmes',
    'commémorât',
    'commémorâtes',
    'commémoré',
    'commémorée',
    'commémorées',
    'commémorés',
    'comméra',
    'commérage',
    'commérages',
    'commérai',
    'comméraient',
    'commérais',
    'commérait',
    'commérant',
    'comméras',
    'commérasse',
    'commérassent',
    'commérasses',
    'commérassiez',
    'commérer',
    'commérera',
    'commérerai',
    'commérerais',
    'commérerait',
    'comméreras',
    'commérerez',
    'comméreriez',
    'commérerions',
    'commérerons',
    'comméreront',
    'commérez',
    'commériez',
    'commérions',
    'commérons',
    'commérâmes',
    'commérât',
    'commérâtes',
    'commérèrent',
    'comméré',
    'commîmes',
    'commît',
    'commîtes',
    'compacité',
    'compacités',
    'compact',
    'compactage',
    'compactages',
    'compacte',
    'compactes',
    'compacts',
    'compagne',
    'compagnes',
    'compagnie',
    'compagnies',
    'compagnon',
    'compagnons',
    'compara',
    'comparable',
    'comparables',
    'comparai',
    'comparaient',
    'comparais',
    'comparaison',
    'comparaisons',
    'comparaisse',
    'comparaisses',
    'comparaissez',
    'comparait',
    'comparant',
    'comparas',
    'comparasse',
    'comparassent',
    'comparasses',
    'comparassiez',
    'comparateur',
    'comparateurs',
    'comparatif',
    'comparatifs',
    'comparatisme',
    'comparatiste',
    'comparative',
    'comparatives',
    'comparatrice',
    'comparaît',
    'comparaîtra',
    'comparaîtrai',
    'comparaîtras',
    'comparaître',
    'comparaîtrez',
    'compare',
    'comparent',
    'comparer',
    'comparera',
    'comparerai',
    'comparerais',
    'comparerait',
    'compareras',
    'comparerez',
    'compareriez',
    'comparerions',
    'comparerons',
    'compareront',
    'compares',
    'comparez',
    'compariez',
    'comparions',
    'comparons',
    'comparse',
    'comparses',
    'compartiment',
    'comparu',
    'comparue',
    'comparues',
    'comparurent',
    'comparus',
    'comparusse',
    'comparussent',
    'comparusses',
    'comparussiez',
    'comparut',
    'comparution',
    'comparutions',
    'comparâmes',
    'comparât',
    'comparâtes',
    'comparèrent',
    'comparé',
    'comparée',
    'comparées',
    'comparés',
    'comparûmes',
    'comparût',
    'comparûtes',
    'compas',
    'compassa',
    'compassai',
    'compassaient',
    'compassais',
    'compassait',
    'compassant',
    'compassas',
    'compassasse',
    'compassasses',
    'compasse',
    'compassent',
    'compasser',
    'compassera',
    'compasserai',
    'compasserais',
    'compasserait',
    'compasseras',
    'compasserez',
    'compasseriez',
    'compasserons',
    'compasseront',
    'compasses',
    'compassez',
    'compassiez',
    'compassion',
    'compassions',
    'compassons',
    'compassâmes',
    'compassât',
    'compassâtes',
    'compassèrent',
    'compassé',
    'compassée',
    'compassées',
    'compassés',
    'compati',
    'compatible',
    'compatibles',
    'compatir',
    'compatira',
    'compatirai',
    'compatirais',
    'compatirait',
    'compatiras',
    'compatirent',
    'compatirez',
    'compatiriez',
    'compatirions',
    'compatirons',
    'compatiront',
    'compatis',
    'compatissais',
    'compatissait',
    'compatissant',
    'compatisse',
    'compatissent',
    'compatisses',
    'compatissez',
    'compatissiez',
    'compatissons',
    'compatit',
    'compatriote',
    'compatriotes',
    'compatîmes',
    'compatît',
    'compatîtes',
    'compendieuse',
    'compendieux',
    'compendium',
    'compendiums',
    'compensa',
    'compensable',
    'compensables',
    'compensai',
    'compensaient',
    'compensais',
    'compensait',
    'compensant',
    'compensas',
    'compensasse',
    'compensasses',
    'compensateur',
    'compensation',
    'compense',
    'compensent',
    'compenser',
    'compensera',
    'compenserai',
    'compenserais',
    'compenserait',
    'compenseras',
    'compenserez',
    'compenseriez',
    'compenserons',
    'compenseront',
    'compenses',
    'compensez',
    'compensiez',
    'compensions',
    'compensons',
    'compensâmes',
    'compensât',
    'compensâtes',
    'compensèrent',
    'compensé',
    'compensée',
    'compensées',
    'compensés',
    'compila',
    'compilai',
    'compilaient',
    'compilais',
    'compilait',
    'compilant',
    'compilas',
    'compilasse',
    'compilassent',
    'compilasses',
    'compilassiez',
    'compilateur',
    'compilateurs',
    'compilation',
    'compilations',
    'compilatrice',
    'compile',
    'compilent',
    'compiler',
    'compilera',
    'compilerai',
    'compilerais',
    'compilerait',
    'compileras',
    'compilerez',
    'compileriez',
    'compilerions',
    'compilerons',
    'compileront',
    'compiles',
    'compilez',
    'compiliez',
    'compilions',
    'compilons',
    'compilâmes',
    'compilât',
    'compilâtes',
    'compilèrent',
    'compilé',
    'compilée',
    'compilées',
    'compilés',
    'compissa',
    'compissai',
    'compissaient',
    'compissais',
    'compissait',
    'compissant',
    'compissas',
    'compissasse',
    'compissasses',
    'compisse',
    'compissent',
    'compisser',
    'compissera',
    'compisserai',
    'compisserais',
    'compisserait',
    'compisseras',
    'compisserez',
    'compisseriez',
    'compisserons',
    'compisseront',
    'compisses',
    'compissez',
    'compissiez',
    'compissions',
    'compissons',
    'compissâmes',
    'compissât',
    'compissâtes',
    'compissèrent',
    'compissé',
    'compissée',
    'compissées',
    'compissés',
    'complainte',
    'complaintes',
    'complaira',
    'complairai',
    'complairais',
    'complairait',
    'complairas',
    'complaire',
    'complairez',
    'complairiez',
    'complairions',
    'complairons',
    'complairont',
    'complais',
    'complaisais',
    'complaisait',
    'complaisance',
    'complaisant',
    'complaisante',
    'complaisants',
    'complaise',
    'complaisent',
    'complaises',
    'complaisez',
    'complaisiez',
    'complaisions',
    'complaisons',
    'complanter',
    'complaît',
    'complet',
    'complets',
    'complexa',
    'complexai',
    'complexaient',
    'complexais',
    'complexait',
    'complexant',
    'complexas',
    'complexasse',
    'complexasses',
    'complexe',
    'complexent',
    'complexer',
    'complexera',
    'complexerai',
    'complexerais',
    'complexerait',
    'complexeras',
    'complexerez',
    'complexeriez',
    'complexerons',
    'complexeront',
    'complexes',
    'complexez',
    'complexiez',
    'complexifia',
    'complexifiai',
    'complexifias',
    'complexifie',
    'complexifier',
    'complexifies',
    'complexifiez',
    'complexifiât',
    'complexifié',
    'complexifiée',
    'complexifiés',
    'complexion',
    'complexions',
    'complexité',
    'complexités',
    'complexons',
    'complexâmes',
    'complexât',
    'complexâtes',
    'complexèrent',
    'complexé',
    'complexée',
    'complexées',
    'complexés',
    'complication',
    'complice',
    'complices',
    'complicité',
    'complicités',
    'complies',
    'compliment',
    'complimenta',
    'complimentai',
    'complimentas',
    'complimente',
    'complimenter',
    'complimentes',
    'complimentez',
    'compliments',
    'complimentât',
    'complimenté',
    'complimentée',
    'complimentés',
    'compliqua',
    'compliquai',
    'compliquais',
    'compliquait',
    'compliquant',
    'compliquas',
    'compliquasse',
    'complique',
    'compliquent',
    'compliquer',
    'compliquera',
    'compliquerai',
    'compliqueras',
    'compliquerez',
    'compliques',
    'compliquez',
    'compliquiez',
    'compliquions',
    'compliquons',
    'compliquâmes',
    'compliquât',
    'compliquâtes',
    'compliqué',
    'compliquée',
    'compliquées',
    'compliqués',
    'complot',
    'complota',
    'complotai',
    'complotaient',
    'complotais',
    'complotait',
    'complotant',
    'complotas',
    'complotasse',
    'complotasses',
    'complote',
    'complotent',
    'comploter',
    'complotera',
    'comploterai',
    'comploterais',
    'comploterait',
    'comploteras',
    'comploterez',
    'comploteriez',
    'comploterons',
    'comploteront',
    'complotes',
    'comploteur',
    'comploteurs',
    'comploteuse',
    'comploteuses',
    'complotez',
    'complotiez',
    'complotions',
    'complotons',
    'complots',
    'complotâmes',
    'complotât',
    'complotâtes',
    'complotèrent',
    'comploté',
    'complotée',
    'complotées',
    'complotés',
    'complu',
    'complurent',
    'complus',
    'complusse',
    'complussent',
    'complusses',
    'complussiez',
    'complussions',
    'complut',
    'complète',
    'complètement',
    'complètent',
    'complètes',
    'complément',
    'compléments',
    'compléta',
    'complétai',
    'complétaient',
    'complétais',
    'complétait',
    'complétant',
    'complétas',
    'complétasse',
    'complétasses',
    'compléter',
    'complétera',
    'compléterai',
    'compléterais',
    'compléterait',
    'compléteras',
    'compléterez',
    'compléteriez',
    'compléterons',
    'compléteront',
    'complétez',
    'complétiez',
    'complétif',
    'complétifs',
    'complétion',
    'complétions',
    'complétive',
    'complétives',
    'complétons',
    'complétâmes',
    'complétât',
    'complétâtes',
    'complétèrent',
    'complété',
    'complétée',
    'complétées',
    'complétés',
    'complûmes',
    'complût',
    'complûtes',
    'componction',
    'componctions',
    'componé',
    'componée',
    'componées',
    'componés',
    'comporta',
    'comportai',
    'comportaient',
    'comportais',
    'comportait',
    'comportant',
    'comportas',
    'comportasse',
    'comportasses',
    'comporte',
    'comportement',
    'comportent',
    'comporter',
    'comportera',
    'comporterai',
    'comporterais',
    'comporterait',
    'comporteras',
    'comporterez',
    'comporteriez',
    'comporterons',
    'comporteront',
    'comportes',
    'comportez',
    'comportiez',
    'comportions',
    'comportons',
    'comportâmes',
    'comportât',
    'comportâtes',
    'comportèrent',
    'comporté',
    'comportée',
    'comportées',
    'comportés',
    'composa',
    'composai',
    'composaient',
    'composais',
    'composait',
    'composant',
    'composante',
    'composantes',
    'composants',
    'composas',
    'composasse',
    'composassent',
    'composasses',
    'composassiez',
    'compose',
    'composent',
    'composer',
    'composera',
    'composerai',
    'composerais',
    'composerait',
    'composeras',
    'composerasse',
    'composerez',
    'composeriez',
    'composerions',
    'composerons',
    'composeront',
    'composerâmes',
    'composerât',
    'composerâtes',
    'composes',
    'composeur',
    'composeurs',
    'composeuse',
    'composeuses',
    'composez',
    'composiez',
    'composions',
    'composite',
    'composites',
    'compositeur',
    'compositeurs',
    'composition',
    'compositions',
    'compositrice',
    'composons',
    'compost',
    'composta',
    'compostage',
    'compostages',
    'compostai',
    'compostaient',
    'compostais',
    'compostait',
    'compostant',
    'compostas',
    'compostasse',
    'compostasses',
    'composte',
    'compostent',
    'composter',
    'compostera',
    'composterai',
    'composterais',
    'composterait',
    'composteras',
    'composterez',
    'composteriez',
    'composterons',
    'composteront',
    'compostes',
    'composteur',
    'composteurs',
    'compostez',
    'compostiez',
    'compostions',
    'compostons',
    'composts',
    'compostâmes',
    'compostât',
    'compostâtes',
    'compostèrent',
    'composté',
    'compostée',
    'compostées',
    'compostés',
    'composâmes',
    'composât',
    'composâtes',
    'composèrent',
    'composé',
    'composée',
    'composées',
    'composés',
    'compote',
    'compotes',
    'compotier',
    'compotiers',
    'compound',
    'comprenaient',
    'comprenais',
    'comprenait',
    'comprenant',
    'comprend',
    'comprendra',
    'comprendrai',
    'comprendrais',
    'comprendrait',
    'comprendras',
    'comprendre',
    'comprendrez',
    'comprendriez',
    'comprendrons',
    'comprendront',
    'comprends',
    'comprenette',
    'comprenettes',
    'comprenez',
    'compreniez',
    'comprenions',
    'comprenne',
    'comprennent',
    'comprennes',
    'comprenons',
    'compressa',
    'compressai',
    'compressais',
    'compressait',
    'compressant',
    'compressas',
    'compressasse',
    'compresse',
    'compressent',
    'compresser',
    'compressera',
    'compresserai',
    'compresseras',
    'compresserez',
    'compresses',
    'compresseur',
    'compresseurs',
    'compressez',
    'compressible',
    'compressiez',
    'compressif',
    'compressifs',
    'compression',
    'compressions',
    'compressive',
    'compressives',
    'compressons',
    'compressâmes',
    'compressât',
    'compressâtes',
    'compressé',
    'compressée',
    'compressées',
    'compressés',
    'comprima',
    'comprimable',
    'comprimables',
    'comprimai',
    'comprimaient',
    'comprimais',
    'comprimait',
    'comprimant',
    'comprimante',
    'comprimantes',
    'comprimants',
    'comprimas',
    'comprimasse',
    'comprimasses',
    'comprime',
    'compriment',
    'comprimer',
    'comprimera',
    'comprimerai',
    'comprimerais',
    'comprimerait',
    'comprimeras',
    'comprimerez',
    'comprimeriez',
    'comprimerons',
    'comprimeront',
    'comprimes',
    'comprimez',
    'comprimiez',
    'comprimions',
    'comprimons',
    'comprimâmes',
    'comprimât',
    'comprimâtes',
    'comprimèrent',
    'comprimé',
    'comprimée',
    'comprimées',
    'comprimés',
    'comprirent',
    'compris',
    'comprise',
    'comprises',
    'comprisse',
    'comprissent',
    'comprisses',
    'comprissiez',
    'comprissions',
    'comprit',
    'compromet',
    'compromets',
    'compromette',
    'compromettes',
    'compromettez',
    'compromettra',
    'compromettre',
    'compromirent',
    'compromis',
    'compromise',
    'compromises',
    'compromisse',
    'compromisses',
    'compromit',
    'compromîmes',
    'compromît',
    'compromîtes',
    'compréhensif',
    'comprîmes',
    'comprît',
    'comprîtes',
    'compta',
    'comptabilisa',
    'comptabilise',
    'comptabilisé',
    'comptabilité',
    'comptable',
    'comptables',
    'comptage',
    'comptages',
    'comptai',
    'comptaient',
    'comptais',
    'comptait',
    'comptant',
    'comptas',
    'comptasse',
    'comptassent',
    'comptasses',
    'comptassiez',
    'comptassions',
    'compte',
    'comptent',
    'compter',
    'comptera',
    'compterai',
    'compteraient',
    'compterais',
    'compterait',
    'compteras',
    'compterez',
    'compteriez',
    'compterions',
    'compterons',
    'compteront',
    'comptes',
    'compteur',
    'compteurs',
    'comptez',
    'comptiez',
    'comptine',
    'comptines',
    'comptions',
    'comptoir',
    'comptoirs',
    'comptons',
    'comptâmes',
    'comptât',
    'comptâtes',
    'comptèrent',
    'compté',
    'comptée',
    'comptées',
    'comptés',
    'compulsa',
    'compulsai',
    'compulsaient',
    'compulsais',
    'compulsait',
    'compulsant',
    'compulsas',
    'compulsasse',
    'compulsasses',
    'compulse',
    'compulsent',
    'compulser',
    'compulsera',
    'compulserai',
    'compulserais',
    'compulserait',
    'compulseras',
    'compulserez',
    'compulseriez',
    'compulserons',
    'compulseront',
    'compulses',
    'compulsez',
    'compulsiez',
    'compulsif',
    'compulsifs',
    'compulsion',
    'compulsions',
    'compulsive',
    'compulsives',
    'compulsons',
    'compulsâmes',
    'compulsât',
    'compulsâtes',
    'compulsèrent',
    'compulsé',
    'compulsée',
    'compulsées',
    'compulsés',
    'comput',
    'computa',
    'computai',
    'computaient',
    'computais',
    'computait',
    'computant',
    'computas',
    'computasse',
    'computassent',
    'computasses',
    'computassiez',
    'computation',
    'computations',
    'compute',
    'computent',
    'computer',
    'computera',
    'computerai',
    'computerais',
    'computerait',
    'computeras',
    'computerez',
    'computeriez',
    'computerions',
    'computerons',
    'computeront',
    'computes',
    'computez',
    'computiez',
    'computions',
    'computons',
    'computs',
    'computâmes',
    'computât',
    'computâtes',
    'computèrent',
    'computé',
    'computée',
    'computées',
    'computés',
    'compère',
    'compères',
    'compète',
    'compètent',
    'compètes',
    'compérage',
    'compérages',
    'compéta',
    'compétai',
    'compétaient',
    'compétais',
    'compétait',
    'compétant',
    'compétas',
    'compétasse',
    'compétassent',
    'compétasses',
    'compétassiez',
    'compétence',
    'compétences',
    'compétent',
    'compétente',
    'compétentes',
    'compétents',
    'compéter',
    'compétera',
    'compéterai',
    'compéterais',
    'compéterait',
    'compéteras',
    'compéterez',
    'compéteriez',
    'compéterions',
    'compéterons',
    'compéteront',
    'compétez',
    'compétiez',
    'compétions',
    'compétiteur',
    'compétiteurs',
    'compétitif',
    'compétitifs',
    'compétition',
    'compétitions',
    'compétitive',
    'compétitives',
    'compétitrice',
    'compétons',
    'compétâmes',
    'compétât',
    'compétâtes',
    'compétèrent',
    'compété',
    'comtal',
    'comtale',
    'comtales',
    'comtaux',
    'comte',
    'comtes',
    'comtesse',
    'comtesses',
    'comté',
    'comtés',
    'comète',
    'comètes',
    'comédie',
    'comédien',
    'comédienne',
    'comédiennes',
    'comédiens',
    'comédies',
    'comédon',
    'comédons',
    'cométaire',
    'cométaires',
    'conard',
    'conarde',
    'conardes',
    'conards',
    'conasse',
    'conasses',
    'conatif',
    'conatifs',
    'conation',
    'conations',
    'conative',
    'conatives',
    'concassa',
    'concassage',
    'concassages',
    'concassai',
    'concassaient',
    'concassais',
    'concassait',
    'concassant',
    'concassas',
    'concassasse',
    'concassasses',
    'concasse',
    'concassent',
    'concasser',
    'concassera',
    'concasserai',
    'concasserais',
    'concasserait',
    'concasseras',
    'concasserez',
    'concasseriez',
    'concasserons',
    'concasseront',
    'concasses',
    'concasseur',
    'concasseurs',
    'concassez',
    'concassiez',
    'concassions',
    'concassons',
    'concassâmes',
    'concassât',
    'concassâtes',
    'concassèrent',
    'concassé',
    'concassée',
    'concassées',
    'concassés',
    'concatène',
    'concatènent',
    'concatènes',
    'concaténa',
    'concaténai',
    'concaténais',
    'concaténait',
    'concaténant',
    'concaténas',
    'concaténasse',
    'concaténer',
    'concaténera',
    'concaténerai',
    'concaténeras',
    'concaténerez',
    'concaténez',
    'concaténiez',
    'concaténions',
    'concaténons',
    'concaténâmes',
    'concaténât',
    'concaténâtes',
    'concaténé',
    'concaténée',
    'concaténées',
    'concaténés',
    'concave',
    'concaves',
    'concavité',
    'concavités',
    'concentra',
    'concentrai',
    'concentrais',
    'concentrait',
    'concentrant',
    'concentras',
    'concentrasse',
    'concentre',
    'concentrent',
    'concentrer',
    'concentrera',
    'concentrerai',
    'concentreras',
    'concentrerez',
    'concentres',
    'concentrez',
    'concentriez',
    'concentrions',
    'concentrique',
    'concentrons',
    'concentrâmes',
    'concentrât',
    'concentrâtes',
    'concentré',
    'concentrée',
    'concentrées',
    'concentrés',
    'concept',
    'conceptacle',
    'conceptacles',
    'concepteur',
    'concepteurs',
    'conception',
    'conceptions',
    'conceptisme',
    'conceptismes',
    'conceptrice',
    'conceptrices',
    'concepts',
    'conceptuel',
    'conceptuelle',
    'conceptuels',
    'concerna',
    'concernai',
    'concernaient',
    'concernais',
    'concernait',
    'concernant',
    'concernas',
    'concernasse',
    'concernasses',
    'concerne',
    'concernent',
    'concerner',
    'concernera',
    'concernerai',
    'concernerais',
    'concernerait',
    'concerneras',
    'concernerez',
    'concerneriez',
    'concernerons',
    'concerneront',
    'concernes',
    'concernez',
    'concerniez',
    'concernions',
    'concernons',
    'concernâmes',
    'concernât',
    'concernâtes',
    'concernèrent',
    'concerné',
    'concernée',
    'concernées',
    'concernés',
    'concert',
    'concerta',
    'concertai',
    'concertaient',
    'concertais',
    'concertait',
    'concertant',
    'concertante',
    'concertantes',
    'concertants',
    'concertas',
    'concertasse',
    'concertasses',
    'concertation',
    'concerte',
    'concertent',
    'concerter',
    'concertera',
    'concerterai',
    'concerterais',
    'concerterait',
    'concerteras',
    'concerterez',
    'concerteriez',
    'concerterons',
    'concerteront',
    'concertes',
    'concertez',
    'concertiez',
    'concertino',
    'concertinos',
    'concertions',
    'concertiste',
    'concertistes',
    'concerto',
    'concertons',
    'concertos',
    'concerts',
    'concertâmes',
    'concertât',
    'concertâtes',
    'concertèrent',
    'concerté',
    'concertée',
    'concertées',
    'concertés',
    'concessif',
    'concessifs',
    'concession',
    'concessions',
    'concessive',
    'concessives',
    'concetti',
    'concevable',
    'concevables',
    'concevaient',
    'concevais',
    'concevait',
    'concevant',
    'concevez',
    'conceviez',
    'concevions',
    'concevoir',
    'concevons',
    'concevra',
    'concevrai',
    'concevraient',
    'concevrais',
    'concevrait',
    'concevras',
    'concevrez',
    'concevriez',
    'concevrions',
    'concevrons',
    'concevront',
    'conchoïdal',
    'conchoïdale',
    'conchoïdales',
    'conchoïdaux',
    'conchoïde',
    'conchoïdes',
    'conchylien',
    'conchylienne',
    'conchyliens',
    'concierge',
    'conciergerie',
    'concierges',
    'concile',
    'conciles',
    'concilia',
    'conciliable',
    'conciliables',
    'conciliabule',
    'conciliai',
    'conciliaient',
    'conciliaire',
    'conciliaires',
    'conciliais',
    'conciliait',
    'conciliant',
    'conciliante',
    'conciliantes',
    'conciliants',
    'concilias',
    'conciliasse',
    'conciliasses',
    'conciliateur',
    'conciliation',
    'concilie',
    'concilient',
    'concilier',
    'conciliera',
    'concilierai',
    'concilierais',
    'concilierait',
    'concilieras',
    'concilierez',
    'concilieriez',
    'concilierons',
    'concilieront',
    'concilies',
    'conciliez',
    'conciliiez',
    'conciliions',
    'concilions',
    'conciliâmes',
    'conciliât',
    'conciliâtes',
    'concilièrent',
    'concilié',
    'conciliée',
    'conciliées',
    'conciliés',
    'concis',
    'concise',
    'concises',
    'concision',
    'concisions',
    'concitoyen',
    'concitoyenne',
    'concitoyens',
    'conclave',
    'conclaves',
    'conclaviste',
    'conclavistes',
    'conclu',
    'concluaient',
    'concluais',
    'concluait',
    'concluant',
    'concluante',
    'concluantes',
    'concluants',
    'conclue',
    'concluent',
    'conclues',
    'concluez',
    'concluiez',
    'concluions',
    'concluons',
    'conclura',
    'conclurai',
    'concluraient',
    'conclurais',
    'conclurait',
    'concluras',
    'conclure',
    'conclurent',
    'conclurez',
    'concluriez',
    'conclurions',
    'conclurons',
    'concluront',
    'conclus',
    'conclusion',
    'conclusions',
    'conclusse',
    'conclussent',
    'conclusses',
    'conclussiez',
    'conclussions',
    'conclut',
    'conclûmes',
    'conclût',
    'conclûtes',
    'concocta',
    'concoctai',
    'concoctaient',
    'concoctais',
    'concoctait',
    'concoctant',
    'concoctas',
    'concoctasse',
    'concoctasses',
    'concocte',
    'concoctent',
    'concocter',
    'concoctera',
    'concocterai',
    'concocterais',
    'concocterait',
    'concocteras',
    'concocterez',
    'concocteriez',
    'concocterons',
    'concocteront',
    'concoctes',
    'concoctez',
    'concoctiez',
    'concoctions',
    'concoctons',
    'concoctâmes',
    'concoctât',
    'concoctâtes',
    'concoctèrent',
    'concocté',
    'concoctée',
    'concoctées',
    'concoctés',
    'concombre',
    'concombres',
    'concomitance',
    'concomitant',
    'concomitante',
    'concomitants',
    'concorda',
    'concordai',
    'concordaient',
    'concordais',
    'concordait',
    'concordance',
    'concordances',
    'concordant',
    'concordante',
    'concordantes',
    'concordants',
    'concordas',
    'concordasse',
    'concordasses',
    'concordat',
    'concordats',
    'concorde',
    'concordent',
    'concorder',
    'concordera',
    'concorderai',
    'concorderais',
    'concorderait',
    'concorderas',
    'concorderez',
    'concorderiez',
    'concorderons',
    'concorderont',
    'concordes',
    'concordez',
    'concordiez',
    'concordions',
    'concordons',
    'concordâmes',
    'concordât',
    'concordâtes',
    'concordèrent',
    'concordé',
    'concordée',
    'concordées',
    'concordés',
    'concouraient',
    'concourais',
    'concourait',
    'concourant',
    'concourante',
    'concourantes',
    'concourants',
    'concoure',
    'concourent',
    'concoures',
    'concourez',
    'concouriez',
    'concourions',
    'concourir',
    'concourons',
    'concourra',
    'concourrai',
    'concourrais',
    'concourrait',
    'concourras',
    'concourrez',
    'concourriez',
    'concourrions',
    'concourrons',
    'concourront',
    'concours',
    'concourt',
    'concouru',
    'concourue',
    'concourues',
    'concoururent',
    'concourus',
    'concourusse',
    'concourusses',
    'concourut',
    'concourûmes',
    'concourût',
    'concourûtes',
    'concret',
    'concrets',
    'concrète',
    'concrètement',
    'concrètent',
    'concrètes',
    'concréta',
    'concrétai',
    'concrétaient',
    'concrétais',
    'concrétait',
    'concrétant',
    'concrétas',
    'concrétasse',
    'concrétasses',
    'concréter',
    'concrétera',
    'concréterai',
    'concréterais',
    'concréterait',
    'concréteras',
    'concréterez',
    'concréteriez',
    'concréterons',
    'concréteront',
    'concrétez',
    'concrétiez',
    'concrétion',
    'concrétions',
    'concrétisa',
    'concrétisai',
    'concrétisais',
    'concrétisait',
    'concrétisant',
    'concrétisas',
    'concrétise',
    'concrétisent',
    'concrétiser',
    'concrétisera',
    'concrétises',
    'concrétisez',
    'concrétisiez',
    'concrétisons',
    'concrétisât',
    'concrétisé',
    'concrétisée',
    'concrétisées',
    'concrétisés',
    'concrétons',
    'concrétâmes',
    'concrétât',
    'concrétâtes',
    'concrétèrent',
    'concrété',
    'concrétée',
    'concrétées',
    'concrétés',
    'concubin',
    'concubinage',
    'concubinages',
    'concubine',
    'concubines',
    'concubins',
    'concupiscent',
    'concurrence',
    'concurrencer',
    'concurrences',
    'concurrencez',
    'concurrencé',
    'concurrencée',
    'concurrencés',
    'concurrent',
    'concurrente',
    'concurrentes',
    'concurrents',
    'concurrença',
    'concurrençai',
    'concurrenças',
    'concurrençât',
    'concussion',
    'concussions',
    'concède',
    'concèdent',
    'concèdes',
    'concéda',
    'concédai',
    'concédaient',
    'concédais',
    'concédait',
    'concédant',
    'concédas',
    'concédasse',
    'concédassent',
    'concédasses',
    'concédassiez',
    'concéder',
    'concédera',
    'concéderai',
    'concéderais',
    'concéderait',
    'concéderas',
    'concéderez',
    'concéderiez',
    'concéderions',
    'concéderons',
    'concéderont',
    'concédez',
    'concédiez',
    'concédions',
    'concédons',
    'concédâmes',
    'concédât',
    'concédâtes',
    'concédèrent',
    'concédé',
    'concédée',
    'concédées',
    'concédés',
    'concélèbre',
    'concélèbrent',
    'concélèbres',
    'concélébra',
    'concélébrai',
    'concélébrais',
    'concélébrait',
    'concélébrant',
    'concélébras',
    'concélébrer',
    'concélébrera',
    'concélébrez',
    'concélébriez',
    'concélébrons',
    'concélébrât',
    'concélébré',
    'concélébrée',
    'concélébrées',
    'concélébrés',
    'condamna',
    'condamnable',
    'condamnables',
    'condamnai',
    'condamnaient',
    'condamnais',
    'condamnait',
    'condamnant',
    'condamnas',
    'condamnasse',
    'condamnasses',
    'condamnation',
    'condamne',
    'condamnent',
    'condamner',
    'condamnera',
    'condamnerai',
    'condamnerais',
    'condamnerait',
    'condamneras',
    'condamnerez',
    'condamneriez',
    'condamnerons',
    'condamneront',
    'condamnes',
    'condamnez',
    'condamniez',
    'condamnions',
    'condamnons',
    'condamnâmes',
    'condamnât',
    'condamnâtes',
    'condamnèrent',
    'condamné',
    'condamnée',
    'condamnées',
    'condamnés',
    'condensa',
    'condensable',
    'condensables',
    'condensai',
    'condensaient',
    'condensais',
    'condensait',
    'condensant',
    'condensas',
    'condensasse',
    'condensasses',
    'condensateur',
    'condensation',
    'condense',
    'condensent',
    'condenser',
    'condensera',
    'condenserai',
    'condenserais',
    'condenserait',
    'condenseras',
    'condenserez',
    'condenseriez',
    'condenserons',
    'condenseront',
    'condenses',
    'condenseur',
    'condenseurs',
    'condensez',
    'condensiez',
    'condensions',
    'condensons',
    'condensâmes',
    'condensât',
    'condensâtes',
    'condensèrent',
    'condensé',
    'condensée',
    'condensées',
    'condensés',
    'condescend',
    'condescende',
    'condescendes',
    'condescendez',
    'condescendis',
    'condescendit',
    'condescendra',
    'condescendre',
    'condescends',
    'condescendu',
    'condescendue',
    'condescendus',
    'condescendît',
    'condiment',
    'condiments',
    'condisciple',
    'condisciples',
    'condition',
    'conditionna',
    'conditionnai',
    'conditionnas',
    'conditionne',
    'conditionnel',
    'conditionner',
    'conditionnes',
    'conditionnez',
    'conditionnât',
    'conditionné',
    'conditionnée',
    'conditionnés',
    'conditions',
    'condoléances',
    'condom',
    'condominium',
    'condominiums',
    'condoms',
    'condor',
    'condors',
    'condottiere',
    'condottieres',
    'conductance',
    'conductances',
    'conducteur',
    'conducteurs',
    'conductible',
    'conductibles',
    'conduction',
    'conductions',
    'conductivité',
    'conductrice',
    'conductrices',
    'conduira',
    'conduirai',
    'conduiraient',
    'conduirais',
    'conduirait',
    'conduiras',
    'conduire',
    'conduirez',
    'conduiriez',
    'conduirions',
    'conduirons',
    'conduiront',
    'conduis',
    'conduisaient',
    'conduisais',
    'conduisait',
    'conduisant',
    'conduise',
    'conduisent',
    'conduises',
    'conduisez',
    'conduisiez',
    'conduisions',
    'conduisirent',
    'conduisis',
    'conduisisse',
    'conduisisses',
    'conduisit',
    'conduisons',
    'conduisîmes',
    'conduisît',
    'conduisîtes',
    'conduit',
    'conduite',
    'conduites',
    'conduits',
    'condyle',
    'condyles',
    'condylien',
    'condylienne',
    'condyliennes',
    'condyliens',
    'condylome',
    'condylomes',
    'condé',
    'condés',
    'conf',
    'confection',
    'confectionna',
    'confectionne',
    'confectionné',
    'confections',
    'confer',
    'conferve',
    'conferves',
    'confessa',
    'confessai',
    'confessaient',
    'confessais',
    'confessait',
    'confessant',
    'confessas',
    'confessasse',
    'confessasses',
    'confesse',
    'confessent',
    'confesser',
    'confessera',
    'confesserai',
    'confesserais',
    'confesserait',
    'confesseras',
    'confesserez',
    'confesseriez',
    'confesserons',
    'confesseront',
    'confesses',
    'confesseur',
    'confesseurs',
    'confessez',
    'confessiez',
    'confession',
    'confessions',
    'confessons',
    'confessâmes',
    'confessât',
    'confessâtes',
    'confessèrent',
    'confessé',
    'confessée',
    'confessées',
    'confessés',
    'confetti',
    'confettis',
    'confia',
    'confiai',
    'confiaient',
    'confiais',
    'confiait',
    'confiance',
    'confiances',
    'confiant',
    'confiante',
    'confiantes',
    'confiants',
    'confias',
    'confiasse',
    'confiassent',
    'confiasses',
    'confiassiez',
    'confiassions',
    'confidence',
    'confidences',
    'confident',
    'confidente',
    'confidentes',
    'confidentiel',
    'confidents',
    'confie',
    'confient',
    'confier',
    'confiera',
    'confierai',
    'confieraient',
    'confierais',
    'confierait',
    'confieras',
    'confierez',
    'confieriez',
    'confierions',
    'confierons',
    'confieront',
    'confies',
    'confiez',
    'configura',
    'configurai',
    'configurais',
    'configurait',
    'configurant',
    'configuras',
    'configurasse',
    'configure',
    'configurent',
    'configurer',
    'configurera',
    'configurerai',
    'configureras',
    'configurerez',
    'configures',
    'configurez',
    'configuriez',
    'configurions',
    'configurons',
    'configurâmes',
    'configurât',
    'configurâtes',
    'configuré',
    'configurée',
    'configurées',
    'configurés',
    'confiiez',
    'confiions',
    'confina',
    'confinai',
    'confinaient',
    'confinais',
    'confinait',
    'confinant',
    'confinas',
    'confinasse',
    'confinassent',
    'confinasses',
    'confinassiez',
    'confine',
    'confinement',
    'confinements',
    'confinent',
    'confiner',
    'confinera',
    'confinerai',
    'confinerais',
    'confinerait',
    'confineras',
    'confinerez',
    'confineriez',
    'confinerions',
    'confinerons',
    'confineront',
    'confines',
    'confinez',
    'confiniez',
    'confinions',
    'confinons',
    'confins',
    'confinâmes',
    'confinât',
    'confinâtes',
    'confinèrent',
    'confiné',
    'confinée',
    'confinées',
    'confinés',
    'confions',
    'confira',
    'confirai',
    'confiraient',
    'confirais',
    'confirait',
    'confiras',
    'confire',
    'confirent',
    'confirez',
    'confiriez',
    'confirions',
    'confirma',
    'confirmai',
    'confirmaient',
    'confirmais',
    'confirmait',
    'confirmand',
    'confirmande',
    'confirmandes',
    'confirmands',
    'confirmant',
    'confirmas',
    'confirmasse',
    'confirmasses',
    'confirmatif',
    'confirmatifs',
    'confirmation',
    'confirmative',
    'confirme',
    'confirment',
    'confirmer',
    'confirmera',
    'confirmerai',
    'confirmerais',
    'confirmerait',
    'confirmeras',
    'confirmerez',
    'confirmeriez',
    'confirmerons',
    'confirmeront',
    'confirmes',
    'confirmez',
    'confirmiez',
    'confirmions',
    'confirmons',
    'confirmâmes',
    'confirmât',
    'confirmâtes',
    'confirmèrent',
    'confirmé',
    'confirmée',
    'confirmées',
    'confirmés',
    'confirons',
    'confiront',
    'confis',
    'confisaient',
    'confisais',
    'confisait',
    'confisant',
    'confiscable',
    'confiscables',
    'confiscation',
    'confise',
    'confisent',
    'confiserie',
    'confiseries',
    'confises',
    'confiseur',
    'confiseurs',
    'confiseuse',
    'confiseuses',
    'confisez',
    'confisiez',
    'confisions',
    'confisons',
    'confisqua',
    'confisquai',
    'confisquais',
    'confisquait',
    'confisquant',
    'confisquas',
    'confisquasse',
    'confisque',
    'confisquent',
    'confisquer',
    'confisquera',
    'confisquerai',
    'confisqueras',
    'confisquerez',
    'confisques',
    'confisquez',
    'confisquiez',
    'confisquions',
    'confisquons',
    'confisquâmes',
    'confisquât',
    'confisquâtes',
    'confisqué',
    'confisquée',
    'confisquées',
    'confisqués',
    'confisse',
    'confissent',
    'confisses',
    'confissiez',
    'confissions',
    'confit',
    'confite',
    'confiteor',
    'confites',
    'confits',
    'confiture',
    'confiturerie',
    'confitures',
    'confiturier',
    'confituriers',
    'confiturière',
    'confiâmes',
    'confiât',
    'confiâtes',
    'confièrent',
    'confié',
    'confiée',
    'confiées',
    'confiés',
    'conflictuel',
    'conflictuels',
    'conflit',
    'conflits',
    'conflua',
    'confluai',
    'confluaient',
    'confluais',
    'confluait',
    'confluant',
    'confluas',
    'confluasse',
    'confluassent',
    'confluasses',
    'confluassiez',
    'conflue',
    'confluence',
    'confluences',
    'confluent',
    'confluents',
    'confluer',
    'confluera',
    'confluerai',
    'confluerais',
    'confluerait',
    'conflueras',
    'confluerez',
    'conflueriez',
    'confluerions',
    'confluerons',
    'conflueront',
    'conflues',
    'confluez',
    'confluiez',
    'confluions',
    'confluons',
    'confluâmes',
    'confluât',
    'confluâtes',
    'confluèrent',
    'conflué',
    'confluée',
    'confluées',
    'conflués',
    'confond',
    'confondaient',
    'confondais',
    'confondait',
    'confondant',
    'confondante',
    'confondantes',
    'confondants',
    'confonde',
    'confondent',
    'confondes',
    'confondez',
    'confondiez',
    'confondions',
    'confondirent',
    'confondis',
    'confondisse',
    'confondisses',
    'confondit',
    'confondons',
    'confondra',
    'confondrai',
    'confondrais',
    'confondrait',
    'confondras',
    'confondre',
    'confondrez',
    'confondriez',
    'confondrions',
    'confondrons',
    'confondront',
    'confonds',
    'confondu',
    'confondue',
    'confondues',
    'confondus',
    'confondîmes',
    'confondît',
    'confondîtes',
    'conforma',
    'conformai',
    'conformaient',
    'conformais',
    'conformait',
    'conformant',
    'conformas',
    'conformasse',
    'conformasses',
    'conformateur',
    'conformation',
    'conforme',
    'conforment',
    'conformer',
    'conformera',
    'conformerai',
    'conformerais',
    'conformerait',
    'conformeras',
    'conformerez',
    'conformeriez',
    'conformerons',
    'conformeront',
    'conformes',
    'conformez',
    'conformiez',
    'conformions',
    'conformisme',
    'conformismes',
    'conformiste',
    'conformistes',
    'conformité',
    'conformités',
    'conformons',
    'conformâmes',
    'conformât',
    'conformâtes',
    'conformèrent',
    'conformé',
    'conformée',
    'conformées',
    'conformément',
    'conformés',
    'confort',
    'conforta',
    'confortable',
    'confortables',
    'confortai',
    'confortaient',
    'confortais',
    'confortait',
    'confortant',
    'confortas',
    'confortasse',
    'confortasses',
    'conforte',
    'confortent',
    'conforter',
    'confortera',
    'conforterai',
    'conforterais',
    'conforterait',
    'conforteras',
    'conforterez',
    'conforteriez',
    'conforterons',
    'conforteront',
    'confortes',
    'confortez',
    'confortiez',
    'confortions',
    'confortons',
    'conforts',
    'confortâmes',
    'confortât',
    'confortâtes',
    'confortèrent',
    'conforté',
    'confortée',
    'confortées',
    'confortés',
    'confraternel',
    'confronta',
    'confrontai',
    'confrontais',
    'confrontait',
    'confrontant',
    'confrontas',
    'confrontasse',
    'confronte',
    'confrontent',
    'confronter',
    'confrontera',
    'confronterai',
    'confronteras',
    'confronterez',
    'confrontes',
    'confrontez',
    'confrontiez',
    'confrontions',
    'confrontons',
    'confrontâmes',
    'confrontât',
    'confrontâtes',
    'confronté',
    'confrontée',
    'confrontées',
    'confrontés',
    'confrère',
    'confrères',
    'confrérie',
    'confréries',
    'confus',
    'confuse',
    'confuses',
    'confusion',
    'confusionnel',
    'confusions',
    'confusément',
    'confère',
    'confèrent',
    'confères',
    'confédère',
    'confédèrent',
    'confédères',
    'confédéra',
    'confédérai',
    'confédérais',
    'confédérait',
    'confédéral',
    'confédérale',
    'confédérales',
    'confédérant',
    'confédéras',
    'confédérasse',
    'confédéraux',
    'confédérer',
    'confédérera',
    'confédérerai',
    'confédéreras',
    'confédérerez',
    'confédérez',
    'confédériez',
    'confédérions',
    'confédérons',
    'confédérâmes',
    'confédérât',
    'confédérâtes',
    'confédéré',
    'confédérée',
    'confédérées',
    'confédérés',
    'conféra',
    'conférai',
    'conféraient',
    'conférais',
    'conférait',
    'conférant',
    'conféras',
    'conférasse',
    'conférassent',
    'conférasses',
    'conférassiez',
    'conférence',
    'conférences',
    'conférencier',
    'conférer',
    'conférera',
    'conférerai',
    'conférerais',
    'conférerait',
    'conféreras',
    'conférerez',
    'conféreriez',
    'conférerions',
    'conférerons',
    'conféreront',
    'conférez',
    'confériez',
    'conférions',
    'conférons',
    'conférâmes',
    'conférât',
    'conférâtes',
    'conférèrent',
    'conféré',
    'conférée',
    'conférées',
    'conférés',
    'confîmes',
    'confît',
    'confîtes',
    'conga',
    'congas',
    'congaye',
    'congayes',
    'congaï',
    'congaïs',
    'congela',
    'congelable',
    'congelables',
    'congelai',
    'congelaient',
    'congelais',
    'congelait',
    'congelant',
    'congelas',
    'congelasse',
    'congelassent',
    'congelasses',
    'congelassiez',
    'congeler',
    'congelez',
    'congeliez',
    'congelions',
    'congelons',
    'congelâmes',
    'congelât',
    'congelâtes',
    'congelèrent',
    'congelé',
    'congelée',
    'congelées',
    'congelés',
    'congestif',
    'congestifs',
    'congestion',
    'congestionna',
    'congestionne',
    'congestionné',
    'congestions',
    'congestive',
    'congestives',
    'conglomère',
    'conglomèrent',
    'conglomères',
    'congloméra',
    'conglomérai',
    'conglomérais',
    'conglomérait',
    'conglomérant',
    'congloméras',
    'conglomérat',
    'conglomérats',
    'conglomérer',
    'conglomérera',
    'conglomérez',
    'conglomériez',
    'conglomérons',
    'conglomérât',
    'congloméré',
    'conglomérée',
    'conglomérées',
    'conglomérés',
    'conglutina',
    'conglutinai',
    'conglutinais',
    'conglutinait',
    'conglutinant',
    'conglutinas',
    'conglutine',
    'conglutinent',
    'conglutiner',
    'conglutinera',
    'conglutines',
    'conglutinez',
    'conglutiniez',
    'conglutinons',
    'conglutinât',
    'conglutiné',
    'conglutinée',
    'conglutinées',
    'conglutinés',
    'congolais',
    'congolaise',
    'congolaises',
    'congratula',
    'congratulai',
    'congratulais',
    'congratulait',
    'congratulant',
    'congratulas',
    'congratule',
    'congratulent',
    'congratuler',
    'congratulera',
    'congratules',
    'congratulez',
    'congratuliez',
    'congratulons',
    'congratulât',
    'congratulé',
    'congratulée',
    'congratulées',
    'congratulés',
    'congre',
    'congres',
    'congressiste',
    'congru',
    'congrue',
    'congruence',
    'congruences',
    'congruent',
    'congruente',
    'congruentes',
    'congruents',
    'congrues',
    'congrus',
    'congrès',
    'congréa',
    'congréai',
    'congréaient',
    'congréais',
    'congréait',
    'congréant',
    'congréas',
    'congréasse',
    'congréassent',
    'congréasses',
    'congréassiez',
    'congrée',
    'congréent',
    'congréer',
    'congréera',
    'congréerai',
    'congréerais',
    'congréerait',
    'congréeras',
    'congréerez',
    'congréeriez',
    'congréerions',
    'congréerons',
    'congréeront',
    'congrées',
    'congréez',
    'congrégation',
    'congréiez',
    'congréions',
    'congréons',
    'congréâmes',
    'congréât',
    'congréâtes',
    'congréèrent',
    'congréé',
    'congréée',
    'congréées',
    'congréés',
    'congèle',
    'congèlent',
    'congèlera',
    'congèlerai',
    'congèlerais',
    'congèlerait',
    'congèleras',
    'congèlerez',
    'congèleriez',
    'congèlerions',
    'congèlerons',
    'congèleront',
    'congèles',
    'congère',
    'congères',
    'congé',
    'congédia',
    'congédiable',
    'congédiables',
    'congédiai',
    'congédiaient',
    'congédiais',
    'congédiait',
    'congédiant',
    'congédias',
    'congédiasse',
    'congédiasses',
    'congédie',
    'congédiement',
    'congédient',
    'congédier',
    'congédiera',
    'congédierai',
    'congédierais',
    'congédierait',
    'congédieras',
    'congédierez',
    'congédieriez',
    'congédierons',
    'congédieront',
    'congédies',
    'congédiez',
    'congédiiez',
    'congédiions',
    'congédions',
    'congédiâmes',
    'congédiât',
    'congédiâtes',
    'congédièrent',
    'congédié',
    'congédiée',
    'congédiées',
    'congédiés',
    'congélateur',
    'congélateurs',
    'congélation',
    'congélations',
    'congénital',
    'congénitale',
    'congénitales',
    'congénitaux',
    'congénère',
    'congénères',
    'congés',
    'conicine',
    'conicines',
    'conicité',
    'conicités',
    'conidie',
    'conidies',
    'conifère',
    'conifères',
    'conique',
    'coniques',
    'conirostre',
    'conirostres',
    'conjectura',
    'conjecturai',
    'conjecturais',
    'conjecturait',
    'conjectural',
    'conjecturale',
    'conjecturant',
    'conjecturas',
    'conjecturaux',
    'conjecture',
    'conjecturent',
    'conjecturer',
    'conjecturera',
    'conjectures',
    'conjecturez',
    'conjecturiez',
    'conjecturons',
    'conjecturât',
    'conjecturé',
    'conjecturée',
    'conjecturées',
    'conjecturés',
    'conjoignais',
    'conjoignait',
    'conjoignant',
    'conjoigne',
    'conjoignent',
    'conjoignes',
    'conjoignez',
    'conjoigniez',
    'conjoignions',
    'conjoignis',
    'conjoignisse',
    'conjoignit',
    'conjoignons',
    'conjoignîmes',
    'conjoignît',
    'conjoignîtes',
    'conjoindra',
    'conjoindrai',
    'conjoindrais',
    'conjoindrait',
    'conjoindras',
    'conjoindre',
    'conjoindrez',
    'conjoindriez',
    'conjoindrons',
    'conjoindront',
    'conjoins',
    'conjoint',
    'conjointe',
    'conjointes',
    'conjoints',
    'conjoncteur',
    'conjoncteurs',
    'conjonctif',
    'conjonctifs',
    'conjonction',
    'conjonctions',
    'conjonctival',
    'conjonctive',
    'conjonctives',
    'conjoncture',
    'conjoncturel',
    'conjonctures',
    'conjugaison',
    'conjugaisons',
    'conjugal',
    'conjugale',
    'conjugales',
    'conjugaux',
    'conjugua',
    'conjuguai',
    'conjuguaient',
    'conjuguais',
    'conjuguait',
    'conjuguant',
    'conjuguas',
    'conjuguasse',
    'conjuguasses',
    'conjugue',
    'conjuguent',
    'conjuguer',
    'conjuguera',
    'conjuguerai',
    'conjuguerais',
    'conjuguerait',
    'conjugueras',
    'conjuguerez',
    'conjugueriez',
    'conjuguerons',
    'conjugueront',
    'conjugues',
    'conjuguez',
    'conjuguiez',
    'conjuguions',
    'conjuguons',
    'conjuguâmes',
    'conjuguât',
    'conjuguâtes',
    'conjuguèrent',
    'conjugué',
    'conjuguée',
    'conjuguées',
    'conjugués',
    'conjungo',
    'conjura',
    'conjurai',
    'conjuraient',
    'conjurais',
    'conjurait',
    'conjurant',
    'conjuras',
    'conjurasse',
    'conjurassent',
    'conjurasses',
    'conjurassiez',
    'conjurateur',
    'conjurateurs',
    'conjuration',
    'conjurations',
    'conjuratrice',
    'conjure',
    'conjurent',
    'conjurer',
    'conjurera',
    'conjurerai',
    'conjurerais',
    'conjurerait',
    'conjureras',
    'conjurerez',
    'conjureriez',
    'conjurerions',
    'conjurerons',
    'conjureront',
    'conjures',
    'conjurez',
    'conjuriez',
    'conjurions',
    'conjurons',
    'conjurâmes',
    'conjurât',
    'conjurâtes',
    'conjurèrent',
    'conjuré',
    'conjurée',
    'conjurées',
    'conjurés',
    'connais',
    'connaissable',
    'connaissais',
    'connaissait',
    'connaissance',
    'connaissant',
    'connaisse',
    'connaissent',
    'connaisses',
    'connaisseur',
    'connaisseurs',
    'connaisseuse',
    'connaissez',
    'connaissiez',
    'connaissions',
    'connaissons',
    'connard',
    'connarde',
    'connardes',
    'connards',
    'connasse',
    'connasses',
    'connaît',
    'connaîtra',
    'connaîtrai',
    'connaîtrais',
    'connaîtrait',
    'connaîtras',
    'connaître',
    'connaîtrez',
    'connaîtriez',
    'connaîtrions',
    'connaîtrons',
    'connaîtront',
    'connecta',
    'connectai',
    'connectaient',
    'connectais',
    'connectait',
    'connectant',
    'connectas',
    'connectasse',
    'connectasses',
    'connecte',
    'connectent',
    'connecter',
    'connectera',
    'connecterai',
    'connecterais',
    'connecterait',
    'connecteras',
    'connecterez',
    'connecteriez',
    'connecterons',
    'connecteront',
    'connectes',
    'connecteur',
    'connecteurs',
    'connectez',
    'connectiez',
    'connectif',
    'connectifs',
    'connections',
    'connective',
    'connectives',
    'connectons',
    'connectâmes',
    'connectât',
    'connectâtes',
    'connectèrent',
    'connecté',
    'connectée',
    'connectées',
    'connectés',
    'connerie',
    'conneries',
    'connexe',
    'connexes',
    'connexion',
    'connexions',
    'connexité',
    'connexités',
    'connivence',
    'connivences',
    'connivent',
    'connivente',
    'conniventes',
    'connivents',
    'connota',
    'connotai',
    'connotaient',
    'connotais',
    'connotait',
    'connotant',
    'connotas',
    'connotasse',
    'connotassent',
    'connotasses',
    'connotassiez',
    'connotation',
    'connotations',
    'connote',
    'connotent',
    'connoter',
    'connotera',
    'connoterai',
    'connoterais',
    'connoterait',
    'connoteras',
    'connoterez',
    'connoteriez',
    'connoterions',
    'connoterons',
    'connoteront',
    'connotes',
    'connotez',
    'connotiez',
    'connotions',
    'connotons',
    'connotâmes',
    'connotât',
    'connotâtes',
    'connotèrent',
    'connoté',
    'connotée',
    'connotées',
    'connotés',
    'connu',
    'connue',
    'connues',
    'connurent',
    'connus',
    'connusse',
    'connussent',
    'connusses',
    'connussiez',
    'connussions',
    'connut',
    'connétable',
    'connétables',
    'connûmes',
    'connût',
    'connûtes',
    'conobra',
    'conobrai',
    'conobraient',
    'conobrais',
    'conobrait',
    'conobrant',
    'conobras',
    'conobrasse',
    'conobrassent',
    'conobrasses',
    'conobrassiez',
    'conobre',
    'conobrent',
    'conobrer',
    'conobrera',
    'conobrerai',
    'conobrerais',
    'conobrerait',
    'conobreras',
    'conobrerez',
    'conobreriez',
    'conobrerions',
    'conobrerons',
    'conobreront',
    'conobres',
    'conobrez',
    'conobriez',
    'conobrions',
    'conobrons',
    'conobrâmes',
    'conobrât',
    'conobrâtes',
    'conobrèrent',
    'conobré',
    'conobrée',
    'conobrées',
    'conobrés',
    'conopée',
    'conopées',
    'conoïde',
    'conoïdes',
    'conpressa',
    'conpressai',
    'conpressais',
    'conpressait',
    'conpressant',
    'conpressante',
    'conpressants',
    'conpressas',
    'conpressasse',
    'conpresse',
    'conpressent',
    'conpresser',
    'conpressera',
    'conpresserai',
    'conpresseras',
    'conpresserez',
    'conpresses',
    'conpressez',
    'conpressiez',
    'conpressions',
    'conpressons',
    'conpressâmes',
    'conpressât',
    'conpressâtes',
    'conpressé',
    'conpressée',
    'conpressées',
    'conpressés',
    'conque',
    'conquerra',
    'conquerrai',
    'conquerrais',
    'conquerrait',
    'conquerras',
    'conquerrez',
    'conquerriez',
    'conquerrions',
    'conquerrons',
    'conquerront',
    'conques',
    'conquiers',
    'conquiert',
    'conquirent',
    'conquis',
    'conquise',
    'conquises',
    'conquisse',
    'conquissent',
    'conquisses',
    'conquissiez',
    'conquissions',
    'conquistador',
    'conquit',
    'conquière',
    'conquièrent',
    'conquières',
    'conquéraient',
    'conquérais',
    'conquérait',
    'conquérant',
    'conquérante',
    'conquérantes',
    'conquérants',
    'conquérez',
    'conquériez',
    'conquérions',
    'conquérir',
    'conquérons',
    'conquéru',
    'conquérue',
    'conquérues',
    'conquérus',
    'conquêt',
    'conquête',
    'conquêtes',
    'conquêts',
    'conquîmes',
    'conquît',
    'conquîtes',
    'cons',
    'consacra',
    'consacrai',
    'consacraient',
    'consacrais',
    'consacrait',
    'consacrant',
    'consacras',
    'consacrasse',
    'consacrasses',
    'consacre',
    'consacrent',
    'consacrer',
    'consacrera',
    'consacrerai',
    'consacrerais',
    'consacrerait',
    'consacreras',
    'consacrerez',
    'consacreriez',
    'consacrerons',
    'consacreront',
    'consacres',
    'consacrez',
    'consacriez',
    'consacrions',
    'consacrons',
    'consacrâmes',
    'consacrât',
    'consacrâtes',
    'consacrèrent',
    'consacré',
    'consacrée',
    'consacrées',
    'consacrés',
    'consanguin',
    'consanguine',
    'consanguines',
    'consanguins',
    'consciemment',
    'conscience',
    'consciences',
    'conscient',
    'consciente',
    'conscientes',
    'conscients',
    'conscription',
    'conscrit',
    'conscrits',
    'conseil',
    'conseilla',
    'conseillai',
    'conseillais',
    'conseillait',
    'conseillant',
    'conseillas',
    'conseillasse',
    'conseille',
    'conseillent',
    'conseiller',
    'conseillera',
    'conseillerai',
    'conseilleras',
    'conseillerez',
    'conseillers',
    'conseilles',
    'conseilleur',
    'conseilleurs',
    'conseilleuse',
    'conseillez',
    'conseilliez',
    'conseillions',
    'conseillons',
    'conseillâmes',
    'conseillât',
    'conseillâtes',
    'conseillère',
    'conseillères',
    'conseillé',
    'conseillée',
    'conseillées',
    'conseillés',
    'conseils',
    'consens',
    'consensus',
    'consent',
    'consentaient',
    'consentais',
    'consentait',
    'consentant',
    'consentante',
    'consentantes',
    'consentants',
    'consente',
    'consentement',
    'consentent',
    'consentes',
    'consentez',
    'consenti',
    'consentie',
    'consenties',
    'consentiez',
    'consentions',
    'consentir',
    'consentira',
    'consentirai',
    'consentirais',
    'consentirait',
    'consentiras',
    'consentirent',
    'consentirez',
    'consentiriez',
    'consentirons',
    'consentiront',
    'consentis',
    'consentisse',
    'consentisses',
    'consentit',
    'consentons',
    'consentîmes',
    'consentît',
    'consentîtes',
    'conserva',
    'conservai',
    'conservaient',
    'conservais',
    'conservait',
    'conservant',
    'conservas',
    'conservasse',
    'conservasses',
    'conservateur',
    'conservation',
    'conserve',
    'conservent',
    'conserver',
    'conservera',
    'conserverai',
    'conserverais',
    'conserverait',
    'conserveras',
    'conserverez',
    'conserverie',
    'conserveries',
    'conserveriez',
    'conserverons',
    'conserveront',
    'conserves',
    'conservez',
    'conserviez',
    'conservions',
    'conservons',
    'conservâmes',
    'conservât',
    'conservâtes',
    'conservèrent',
    'conservé',
    'conservée',
    'conservées',
    'conservés',
    'considère',
    'considèrent',
    'considères',
    'considéra',
    'considérable',
    'considérai',
    'considérais',
    'considérait',
    'considérant',
    'considérante',
    'considérants',
    'considéras',
    'considérasse',
    'considérer',
    'considérera',
    'considérerai',
    'considéreras',
    'considérerez',
    'considérez',
    'considériez',
    'considérions',
    'considérons',
    'considérâmes',
    'considérât',
    'considérâtes',
    'considéré',
    'considérée',
    'considérées',
    'considérés',
    'consigna',
    'consignai',
    'consignaient',
    'consignais',
    'consignait',
    'consignant',
    'consignas',
    'consignasse',
    'consignasses',
    'consignation',
    'consigne',
    'consignent',
    'consigner',
    'consignera',
    'consignerai',
    'consignerais',
    'consignerait',
    'consigneras',
    'consignerez',
    'consigneriez',
    'consignerons',
    'consigneront',
    'consignes',
    'consignez',
    'consigniez',
    'consignions',
    'consignons',
    'consignâmes',
    'consignât',
    'consignâtes',
    'consignèrent',
    'consigné',
    'consignée',
    'consignées',
    'consignés',
    'consista',
    'consistai',
    'consistaient',
    'consistais',
    'consistait',
    'consistance',
    'consistances',
    'consistant',
    'consistante',
    'consistantes',
    'consistants',
    'consistas',
    'consistasse',
    'consistasses',
    'consiste',
    'consistent',
    'consister',
    'consistera',
    'consisterai',
    'consisterais',
    'consisterait',
    'consisteras',
    'consisterez',
    'consisteriez',
    'consisterons',
    'consisteront',
    'consistes',
    'consistez',
    'consistiez',
    'consistions',
    'consistoire',
    'consistoires',
    'consistons',
    'consistorial',
    'consistâmes',
    'consistât',
    'consistâtes',
    'consistèrent',
    'consisté',
    'consoeur',
    'consoeurs',
    'consola',
    'consolable',
    'consolables',
    'consolai',
    'consolaient',
    'consolais',
    'consolait',
    'consolant',
    'consolante',
    'consolantes',
    'consolants',
    'consolas',
    'consolasse',
    'consolassent',
    'consolasses',
    'consolassiez',
    'consolateur',
    'consolateurs',
    'consolation',
    'consolations',
    'consolatrice',
    'console',
    'consolent',
    'consoler',
    'consolera',
    'consolerai',
    'consolerais',
    'consolerait',
    'consoleras',
    'consolerez',
    'consoleriez',
    'consolerions',
    'consolerons',
    'consoleront',
    'consoles',
    'consolez',
    'consolida',
    'consolidai',
    'consolidais',
    'consolidait',
    'consolidant',
    'consolidas',
    'consolidasse',
    'consolide',
    'consolident',
    'consolider',
    'consolidera',
    'consoliderai',
    'consolideras',
    'consoliderez',
    'consolides',
    'consolidez',
    'consolidiez',
    'consolidions',
    'consolidons',
    'consolidâmes',
    'consolidât',
    'consolidâtes',
    'consolidé',
    'consolidée',
    'consolidées',
    'consolidés',
    'consoliez',
    'consolions',
    'consolons',
    'consolâmes',
    'consolât',
    'consolâtes',
    'consolèrent',
    'consolé',
    'consolée',
    'consolées',
    'consolés',
    'consomma',
    'consommable',
    'consommables',
    'consommai',
    'consommaient',
    'consommais',
    'consommait',
    'consommant',
    'consommas',
    'consommasse',
    'consommasses',
    'consommateur',
    'consommation',
    'consomme',
    'consomment',
    'consommer',
    'consommera',
    'consommerai',
    'consommerais',
    'consommerait',
    'consommeras',
    'consommerez',
    'consommeriez',
    'consommerons',
    'consommeront',
    'consommes',
    'consommez',
    'consommiez',
    'consommions',
    'consommons',
    'consommâmes',
    'consommât',
    'consommâtes',
    'consommèrent',
    'consommé',
    'consommée',
    'consommées',
    'consommés',
    'consomptible',
    'consomptif',
    'consomptifs',
    'consomption',
    'consomptions',
    'consomptive',
    'consomptives',
    'consona',
    'consonai',
    'consonaient',
    'consonais',
    'consonait',
    'consonance',
    'consonances',
    'consonant',
    'consonas',
    'consonasse',
    'consonassent',
    'consonasses',
    'consonassiez',
    'consone',
    'consonent',
    'consoner',
    'consonera',
    'consonerai',
    'consonerais',
    'consonerait',
    'consoneras',
    'consonerez',
    'consoneriez',
    'consonerions',
    'consonerons',
    'consoneront',
    'consones',
    'consonez',
    'consoniez',
    'consonions',
    'consonne',
    'consonnes',
    'consonons',
    'consonâmes',
    'consonât',
    'consonâtes',
    'consonèrent',
    'consoné',
    'consort',
    'consortium',
    'consortiums',
    'consorts',
    'conspira',
    'conspirai',
    'conspiraient',
    'conspirais',
    'conspirait',
    'conspirant',
    'conspiras',
    'conspirasse',
    'conspirasses',
    'conspirateur',
    'conspiration',
    'conspire',
    'conspirent',
    'conspirer',
    'conspirera',
    'conspirerai',
    'conspirerais',
    'conspirerait',
    'conspireras',
    'conspirerez',
    'conspireriez',
    'conspirerons',
    'conspireront',
    'conspires',
    'conspirez',
    'conspiriez',
    'conspirions',
    'conspirons',
    'conspirâmes',
    'conspirât',
    'conspirâtes',
    'conspirèrent',
    'conspiré',
    'conspirée',
    'conspirées',
    'conspirés',
    'conspua',
    'conspuai',
    'conspuaient',
    'conspuais',
    'conspuait',
    'conspuant',
    'conspuas',
    'conspuasse',
    'conspuassent',
    'conspuasses',
    'conspuassiez',
    'conspue',
    'conspuent',
    'conspuer',
    'conspuera',
    'conspuerai',
    'conspuerais',
    'conspuerait',
    'conspueras',
    'conspuerez',
    'conspueriez',
    'conspuerions',
    'conspuerons',
    'conspueront',
    'conspues',
    'conspuez',
    'conspuiez',
    'conspuions',
    'conspuons',
    'conspuâmes',
    'conspuât',
    'conspuâtes',
    'conspuèrent',
    'conspué',
    'conspuée',
    'conspuées',
    'conspués',
    'constable',
    'constables',
    'constamment',
    'constance',
    'constances',
    'constant',
    'constantan',
    'constantans',
    'constante',
    'constantes',
    'constants',
    'constat',
    'constata',
    'constatai',
    'constataient',
    'constatais',
    'constatait',
    'constatant',
    'constatas',
    'constatasse',
    'constatasses',
    'constatation',
    'constate',
    'constatent',
    'constater',
    'constatera',
    'constaterai',
    'constaterais',
    'constaterait',
    'constateras',
    'constaterez',
    'constateriez',
    'constaterons',
    'constateront',
    'constates',
    'constatez',
    'constatiez',
    'constations',
    'constatons',
    'constats',
    'constatâmes',
    'constatât',
    'constatâtes',
    'constatèrent',
    'constaté',
    'constatée',
    'constatées',
    'constatés',
    'constella',
    'constellai',
    'constellais',
    'constellait',
    'constellant',
    'constellas',
    'constellasse',
    'constelle',
    'constellent',
    'consteller',
    'constellera',
    'constellerai',
    'constelleras',
    'constellerez',
    'constelles',
    'constellez',
    'constelliez',
    'constellions',
    'constellons',
    'constellâmes',
    'constellât',
    'constellâtes',
    'constellé',
    'constellée',
    'constellées',
    'constellés',
    'consterna',
    'consternai',
    'consternais',
    'consternait',
    'consternant',
    'consternante',
    'consternants',
    'consternas',
    'consternasse',
    'consterne',
    'consternent',
    'consterner',
    'consternera',
    'consternerai',
    'consterneras',
    'consternerez',
    'consternes',
    'consternez',
    'consterniez',
    'consternions',
    'consternons',
    'consternâmes',
    'consternât',
    'consternâtes',
    'consterné',
    'consternée',
    'consternées',
    'consternés',
    'constipa',
    'constipai',
    'constipaient',
    'constipais',
    'constipait',
    'constipant',
    'constipas',
    'constipasse',
    'constipasses',
    'constipation',
    'constipe',
    'constipent',
    'constiper',
    'constipera',
    'constiperai',
    'constiperais',
    'constiperait',
    'constiperas',
    'constiperez',
    'constiperiez',
    'constiperons',
    'constiperont',
    'constipes',
    'constipez',
    'constipiez',
    'constipions',
    'constipons',
    'constipâmes',
    'constipât',
    'constipâtes',
    'constipèrent',
    'constipé',
    'constipée',
    'constipées',
    'constipés',
    'constitua',
    'constituai',
    'constituais',
    'constituait',
    'constituant',
    'constituante',
    'constituants',
    'constituas',
    'constituasse',
    'constitue',
    'constituent',
    'constituer',
    'constituera',
    'constituerai',
    'constitueras',
    'constituerez',
    'constitues',
    'constituez',
    'constituiez',
    'constituions',
    'constituons',
    'constitutif',
    'constitutifs',
    'constitution',
    'constitutive',
    'constituâmes',
    'constituât',
    'constituâtes',
    'constitué',
    'constituée',
    'constituées',
    'constitués',
    'constricteur',
    'constriction',
    'constructeur',
    'constructif',
    'constructifs',
    'construction',
    'constructive',
    'construira',
    'construirai',
    'construirais',
    'construirait',
    'construiras',
    'construire',
    'construirez',
    'construiriez',
    'construirons',
    'construiront',
    'construis',
    'construisais',
    'construisait',
    'construisant',
    'construise',
    'construisent',
    'construises',
    'construisez',
    'construisiez',
    'construisis',
    'construisit',
    'construisons',
    'construisît',
    'construit',
    'construite',
    'construites',
    'construits',
    'consul',
    'consulaire',
    'consulaires',
    'consulat',
    'consulats',
    'consuls',
    'consulta',
    'consultable',
    'consultables',
    'consultai',
    'consultaient',
    'consultais',
    'consultait',
    'consultant',
    'consultante',
    'consultantes',
    'consultants',
    'consultas',
    'consultasse',
    'consultasses',
    'consultatif',
    'consultatifs',
    'consultation',
    'consultative',
    'consulte',
    'consultent',
    'consulter',
    'consultera',
    'consulterai',
    'consulterais',
    'consulterait',
    'consulteras',
    'consulterez',
    'consulteriez',
    'consulterons',
    'consulteront',
    'consultes',
    'consultez',
    'consultiez',
    'consultions',
    'consultons',
    'consultâmes',
    'consultât',
    'consultâtes',
    'consultèrent',
    'consulté',
    'consultée',
    'consultées',
    'consultés',
    'consuma',
    'consumai',
    'consumaient',
    'consumais',
    'consumait',
    'consumant',
    'consumas',
    'consumasse',
    'consumassent',
    'consumasses',
    'consumassiez',
    'consume',
    'consument',
    'consumer',
    'consumera',
    'consumerai',
    'consumerais',
    'consumerait',
    'consumeras',
    'consumerez',
    'consumeriez',
    'consumerions',
    'consumerons',
    'consumeront',
    'consumes',
    'consumez',
    'consumiez',
    'consumions',
    'consumons',
    'consumâmes',
    'consumât',
    'consumâtes',
    'consumèrent',
    'consumé',
    'consumée',
    'consumées',
    'consumérisme',
    'consumériste',
    'consumés',
    'consécration',
    'consécutif',
    'consécutifs',
    'consécution',
    'consécutions',
    'consécutive',
    'consécutives',
    'conséquence',
    'conséquences',
    'conséquent',
    'conséquente',
    'conséquentes',
    'conséquents',
    'conta',
    'contact',
    'contacta',
    'contactai',
    'contactaient',
    'contactais',
    'contactait',
    'contactant',
    'contactas',
    'contactasse',
    'contactasses',
    'contacte',
    'contactent',
    'contacter',
    'contactera',
    'contacterai',
    'contacterais',
    'contacterait',
    'contacteras',
    'contacterez',
    'contacteriez',
    'contacterons',
    'contacteront',
    'contactes',
    'contacteur',
    'contacteurs',
    'contactez',
    'contactiez',
    'contactions',
    'contactons',
    'contactrice',
    'contactrices',
    'contacts',
    'contactâmes',
    'contactât',
    'contactâtes',
    'contactèrent',
    'contacté',
    'contactée',
    'contactées',
    'contactés',
    'contage',
    'contages',
    'contagieuse',
    'contagieuses',
    'contagieux',
    'contagion',
    'contagionna',
    'contagionnai',
    'contagionnas',
    'contagionne',
    'contagionner',
    'contagionnes',
    'contagionnez',
    'contagionnât',
    'contagionné',
    'contagionnée',
    'contagionnés',
    'contagions',
    'contagiosité',
    'contai',
    'contaient',
    'container',
    'containerisa',
    'containerise',
    'containerisé',
    'containers',
    'contais',
    'contait',
    'contamina',
    'contaminai',
    'contaminais',
    'contaminait',
    'contaminant',
    'contaminas',
    'contaminasse',
    'contamine',
    'contaminent',
    'contaminer',
    'contaminera',
    'contaminerai',
    'contamineras',
    'contaminerez',
    'contamines',
    'contaminez',
    'contaminiez',
    'contaminions',
    'contaminons',
    'contaminâmes',
    'contaminât',
    'contaminâtes',
    'contaminé',
    'contaminée',
    'contaminées',
    'contaminés',
    'contant',
    'contas',
    'contasse',
    'contassent',
    'contasses',
    'contassiez',
    'contassions',
    'conte',
    'contempla',
    'contemplai',
    'contemplais',
    'contemplait',
    'contemplant',
    'contemplas',
    'contemplasse',
    'contemplatif',
    'contemple',
    'contemplent',
    'contempler',
    'contemplera',
    'contemplerai',
    'contempleras',
    'contemplerez',
    'contemples',
    'contemplez',
    'contempliez',
    'contemplions',
    'contemplons',
    'contemplâmes',
    'contemplât',
    'contemplâtes',
    'contemplé',
    'contemplée',
    'contemplées',
    'contemplés',
    'contemporain',
    'contempteur',
    'contempteurs',
    'contemptrice',
    'contenaient',
    'contenais',
    'contenait',
    'contenance',
    'contenances',
    'contenant',
    'contenante',
    'contenantes',
    'contenants',
    'conteneur',
    'conteneurisa',
    'conteneurise',
    'conteneurisé',
    'conteneurs',
    'contenez',
    'conteniez',
    'contenions',
    'contenir',
    'contenons',
    'content',
    'contenta',
    'contentai',
    'contentaient',
    'contentais',
    'contentait',
    'contentant',
    'contentas',
    'contentasse',
    'contentasses',
    'contente',
    'contentement',
    'contentent',
    'contenter',
    'contentera',
    'contenterai',
    'contenterais',
    'contenterait',
    'contenteras',
    'contenterez',
    'contenteriez',
    'contenterons',
    'contenteront',
    'contentes',
    'contentez',
    'contentieuse',
    'contentieux',
    'contentiez',
    'contentif',
    'contentifs',
    'contention',
    'contentions',
    'contentive',
    'contentives',
    'contentons',
    'contents',
    'contentâmes',
    'contentât',
    'contentâtes',
    'contentèrent',
    'contenté',
    'contentée',
    'contentées',
    'contentés',
    'contenu',
    'contenue',
    'contenues',
    'contenus',
    'conter',
    'contera',
    'conterai',
    'conteraient',
    'conterais',
    'conterait',
    'conteras',
    'conterez',
    'conteriez',
    'conterions',
    'conterons',
    'conteront',
    'contes',
    'contesta',
    'contestable',
    'contestables',
    'contestai',
    'contestaient',
    'contestais',
    'contestait',
    'contestant',
    'contestas',
    'contestasse',
    'contestasses',
    'contestation',
    'conteste',
    'contestent',
    'contester',
    'contestera',
    'contesterai',
    'contesterais',
    'contesterait',
    'contesteras',
    'contesterez',
    'contesteriez',
    'contesterons',
    'contesteront',
    'contestes',
    'contestez',
    'contestiez',
    'contestions',
    'contestons',
    'contestâmes',
    'contestât',
    'contestâtes',
    'contestèrent',
    'contesté',
    'contestée',
    'contestées',
    'contestés',
    'conteur',
    'conteurs',
    'conteuse',
    'conteuses',
    'contexte',
    'contextes',
    'contextuel',
    'contextuelle',
    'contextuels',
    'contexture',
    'contextures',
    'contez',
    'contiendra',
    'contiendrai',
    'contiendrais',
    'contiendrait',
    'contiendras',
    'contiendrez',
    'contiendriez',
    'contiendrons',
    'contiendront',
    'contienne',
    'contiennent',
    'contiennes',
    'contiens',
    'contient',
    'contiez',
    'contigu',
    'contigus',
    'contiguë',
    'contiguës',
    'contiguïté',
    'contiguïtés',
    'continence',
    'continences',
    'continent',
    'continental',
    'continentale',
    'continentaux',
    'continents',
    'contingence',
    'contingences',
    'contingent',
    'contingenta',
    'contingentai',
    'contingentas',
    'contingente',
    'contingenter',
    'contingentes',
    'contingentez',
    'contingents',
    'contingentât',
    'contingenté',
    'contingentée',
    'contingentés',
    'continrent',
    'contins',
    'continsse',
    'continssent',
    'continsses',
    'continssiez',
    'continssions',
    'contint',
    'continu',
    'continua',
    'continuai',
    'continuaient',
    'continuais',
    'continuait',
    'continuant',
    'continuas',
    'continuasse',
    'continuasses',
    'continuateur',
    'continuation',
    'continue',
    'continuel',
    'continuelle',
    'continuelles',
    'continuels',
    'continuent',
    'continuer',
    'continuera',
    'continuerai',
    'continuerais',
    'continuerait',
    'continueras',
    'continuerez',
    'continueriez',
    'continuerons',
    'continueront',
    'continues',
    'continuez',
    'continuiez',
    'continuions',
    'continuité',
    'continuités',
    'continuo',
    'continuons',
    'continuos',
    'continus',
    'continuum',
    'continuums',
    'continuâmes',
    'continuât',
    'continuâtes',
    'continuèrent',
    'continué',
    'continuée',
    'continuées',
    'continués',
    'continûment',
    'contions',
    'contondant',
    'contondante',
    'contondantes',
    'contondants',
    'contons',
    'contorsion',
    'contorsionna',
    'contorsionne',
    'contorsionné',
    'contorsions',
    'contour',
    'contourna',
    'contournai',
    'contournais',
    'contournait',
    'contournant',
    'contournas',
    'contournasse',
    'contourne',
    'contournent',
    'contourner',
    'contournera',
    'contournerai',
    'contourneras',
    'contournerez',
    'contournes',
    'contournez',
    'contourniez',
    'contournions',
    'contournons',
    'contournâmes',
    'contournât',
    'contournâtes',
    'contourné',
    'contournée',
    'contournées',
    'contournés',
    'contours',
    'contra',
    'contraceptif',
    'contracta',
    'contractai',
    'contractais',
    'contractait',
    'contractant',
    'contractante',
    'contractants',
    'contractas',
    'contractasse',
    'contracte',
    'contractent',
    'contracter',
    'contractera',
    'contracterai',
    'contracteras',
    'contracterez',
    'contractes',
    'contractez',
    'contractiez',
    'contraction',
    'contractions',
    'contractons',
    'contractuel',
    'contractuels',
    'contractura',
    'contracturai',
    'contracturas',
    'contracture',
    'contracturer',
    'contractures',
    'contracturez',
    'contracturât',
    'contracturé',
    'contracturée',
    'contracturés',
    'contractâmes',
    'contractât',
    'contractâtes',
    'contracté',
    'contractée',
    'contractées',
    'contractés',
    'contrai',
    'contraient',
    'contraignais',
    'contraignait',
    'contraignant',
    'contraigne',
    'contraignent',
    'contraignes',
    'contraignez',
    'contraigniez',
    'contraignis',
    'contraignit',
    'contraignons',
    'contraignît',
    'contraindra',
    'contraindrai',
    'contraindras',
    'contraindre',
    'contraindrez',
    'contrains',
    'contraint',
    'contrainte',
    'contraintes',
    'contraints',
    'contraire',
    'contraires',
    'contrais',
    'contrait',
    'contralto',
    'contraltos',
    'contrant',
    'contraposa',
    'contraposai',
    'contraposais',
    'contraposait',
    'contraposant',
    'contraposas',
    'contrapose',
    'contraposent',
    'contraposer',
    'contraposera',
    'contraposes',
    'contraposez',
    'contraposiez',
    'contraposons',
    'contraposât',
    'contraposé',
    'contraposée',
    'contraposées',
    'contraposés',
    'contraria',
    'contrariai',
    'contrariais',
    'contrariait',
    'contrariant',
    'contrariante',
    'contrariants',
    'contrarias',
    'contrariasse',
    'contrarie',
    'contrarient',
    'contrarier',
    'contrariera',
    'contrarierai',
    'contrarieras',
    'contrarierez',
    'contraries',
    'contrariez',
    'contrariiez',
    'contrariions',
    'contrarions',
    'contrariâmes',
    'contrariât',
    'contrariâtes',
    'contrarié',
    'contrariée',
    'contrariées',
    'contrariés',
    'contrariété',
    'contrariétés',
    'contras',
    'contrasse',
    'contrassent',
    'contrasses',
    'contrassiez',
    'contrassions',
    'contrasta',
    'contrastai',
    'contrastais',
    'contrastait',
    'contrastant',
    'contrastas',
    'contrastasse',
    'contraste',
    'contrastent',
    'contraster',
    'contrastera',
    'contrasterai',
    'contrasteras',
    'contrasterez',
    'contrastes',
    'contrastez',
    'contrastiez',
    'contrastions',
    'contrastons',
    'contrastâmes',
    'contrastât',
    'contrastâtes',
    'contrasté',
    'contrastée',
    'contrastées',
    'contrastés',
    'contrat',
    'contrats',
    'contre',
    'contrebande',
    'contrebandes',
    'contrebas',
    'contrebasse',
    'contrebasses',
    'contrebasson',
    'contrebat',
    'contrebats',
    'contrebatte',
    'contrebattes',
    'contrebattez',
    'contrebattis',
    'contrebattit',
    'contrebattra',
    'contrebattre',
    'contrebattu',
    'contrebattue',
    'contrebattus',
    'contrebattît',
    'contrebouta',
    'contreboutai',
    'contreboutas',
    'contreboute',
    'contrebouter',
    'contreboutes',
    'contreboutez',
    'contreboutât',
    'contrebouté',
    'contreboutée',
    'contreboutés',
    'contrebuta',
    'contrebutai',
    'contrebutais',
    'contrebutait',
    'contrebutant',
    'contrebutas',
    'contrebute',
    'contrebutent',
    'contrebuter',
    'contrebutera',
    'contrebutes',
    'contrebutez',
    'contrebutiez',
    'contrebutons',
    'contrebutât',
    'contrebuté',
    'contrebutée',
    'contrebutées',
    'contrebutés',
    'contrecarra',
    'contrecarrai',
    'contrecarras',
    'contrecarre',
    'contrecarrer',
    'contrecarres',
    'contrecarrez',
    'contrecarrât',
    'contrecarré',
    'contrecarrée',
    'contrecarrés',
    'contrechamp',
    'contrechamps',
    'contrecoeur',
    'contrecoeurs',
    'contrecoup',
    'contrecoups',
    'contrecoeur',
    'contredanse',
    'contredanses',
    'contredira',
    'contredirai',
    'contredirais',
    'contredirait',
    'contrediras',
    'contredire',
    'contredirent',
    'contredirez',
    'contrediriez',
    'contredirons',
    'contrediront',
    'contredis',
    'contredisais',
    'contredisait',
    'contredisant',
    'contredise',
    'contredisent',
    'contredises',
    'contredisez',
    'contredisiez',
    'contredisons',
    'contredisse',
    'contredisses',
    'contredit',
    'contredite',
    'contredites',
    'contredits',
    'contredîmes',
    'contredît',
    'contredîtes',
    'contrefaire',
    'contrefais',
    'contrefait',
    'contrefaite',
    'contrefaites',
    'contrefaits',
    'contrefasse',
    'contrefasses',
    'contrefaçon',
    'contrefaçons',
    'contrefera',
    'contreferai',
    'contreferais',
    'contreferait',
    'contreferas',
    'contreferez',
    'contreferiez',
    'contreferons',
    'contreferont',
    'contreficha',
    'contrefichai',
    'contrefichas',
    'contrefiche',
    'contreficher',
    'contrefiches',
    'contrefichez',
    'contrefichât',
    'contrefiché',
    'contrefichée',
    'contrefichés',
    'contrefirent',
    'contrefis',
    'contrefisse',
    'contrefisses',
    'contrefit',
    'contrefont',
    'contrefort',
    'contreforts',
    'contrefous',
    'contrefout',
    'contrefoute',
    'contrefoutes',
    'contrefoutez',
    'contrefoutra',
    'contrefoutre',
    'contrefoutu',
    'contrefoutue',
    'contrefoutus',
    'contrefîmes',
    'contrefît',
    'contrefîtes',
    'contremanda',
    'contremandai',
    'contremandas',
    'contremande',
    'contremander',
    'contremandes',
    'contremandez',
    'contremandât',
    'contremandé',
    'contremandée',
    'contremandés',
    'contremarche',
    'contremarqua',
    'contremarque',
    'contremarqué',
    'contremaître',
    'contrent',
    'contrepartie',
    'contrepoids',
    'contrepoint',
    'contrepoints',
    'contrepoison',
    'contrer',
    'contrera',
    'contrerai',
    'contreraient',
    'contrerais',
    'contrerait',
    'contreras',
    'contrerez',
    'contreriez',
    'contrerions',
    'contrerons',
    'contreront',
    'contres',
    'contrescarpe',
    'contreseing',
    'contreseings',
    'contresens',
    'contresigna',
    'contresignai',
    'contresignas',
    'contresigne',
    'contresigner',
    'contresignes',
    'contresignez',
    'contresignât',
    'contresigné',
    'contresignée',
    'contresignés',
    'contretemps',
    'contretype',
    'contretyper',
    'contretypes',
    'contrevenais',
    'contrevenait',
    'contrevenant',
    'contrevenez',
    'contreveniez',
    'contrevenir',
    'contrevenons',
    'contrevent',
    'contreventer',
    'contrevents',
    'contrevenu',
    'contrevenue',
    'contrevenues',
    'contrevenus',
    'contrevienne',
    'contreviens',
    'contrevient',
    'contrevins',
    'contrevinsse',
    'contrevint',
    'contrevérité',
    'contrevînmes',
    'contrevînt',
    'contrevîntes',
    'contrez',
    'contribua',
    'contribuable',
    'contribuai',
    'contribuais',
    'contribuait',
    'contribuant',
    'contribuas',
    'contribuasse',
    'contribue',
    'contribuent',
    'contribuer',
    'contribuera',
    'contribuerai',
    'contribueras',
    'contribuerez',
    'contribues',
    'contribuez',
    'contribuiez',
    'contribuions',
    'contribuons',
    'contributeur',
    'contributif',
    'contributifs',
    'contribution',
    'contributive',
    'contribuâmes',
    'contribuât',
    'contribuâtes',
    'contribué',
    'contriez',
    'contrions',
    'contrista',
    'contristai',
    'contristais',
    'contristait',
    'contristant',
    'contristas',
    'contristasse',
    'contriste',
    'contristent',
    'contrister',
    'contristera',
    'contristerai',
    'contristeras',
    'contristerez',
    'contristes',
    'contristez',
    'contristiez',
    'contristions',
    'contristons',
    'contristâmes',
    'contristât',
    'contristâtes',
    'contristé',
    'contristée',
    'contristées',
    'contristés',
    'contrit',
    'contrite',
    'contrites',
    'contrition',
    'contritions',
    'contrits',
    'controns',
    'contrordre',
    'contrordres',
    'controuva',
    'controuvai',
    'controuvais',
    'controuvait',
    'controuvant',
    'controuvas',
    'controuvasse',
    'controuve',
    'controuvent',
    'controuver',
    'controuvera',
    'controuverai',
    'controuveras',
    'controuverez',
    'controuves',
    'controuvez',
    'controuviez',
    'controuvions',
    'controuvons',
    'controuvâmes',
    'controuvât',
    'controuvâtes',
    'controuvé',
    'controuvée',
    'controuvées',
    'controuvés',
    'controversa',
    'controversai',
    'controversas',
    'controverse',
    'controverser',
    'controverses',
    'controversez',
    'controversât',
    'controversé',
    'controversée',
    'controversés',
    'contrâmes',
    'contrât',
    'contrâtes',
    'contrèrent',
    'contré',
    'contrée',
    'contrées',
    'contrés',
    'contrôla',
    'contrôlable',
    'contrôlables',
    'contrôlai',
    'contrôlaient',
    'contrôlais',
    'contrôlait',
    'contrôlant',
    'contrôlas',
    'contrôlasse',
    'contrôlasses',
    'contrôle',
    'contrôlent',
    'contrôler',
    'contrôlera',
    'contrôlerai',
    'contrôlerais',
    'contrôlerait',
    'contrôleras',
    'contrôlerez',
    'contrôleriez',
    'contrôlerons',
    'contrôleront',
    'contrôles',
    'contrôleur',
    'contrôleurs',
    'contrôleuse',
    'contrôleuses',
    'contrôlez',
    'contrôliez',
    'contrôlions',
    'contrôlons',
    'contrôlâmes',
    'contrôlât',
    'contrôlâtes',
    'contrôlèrent',
    'contrôlé',
    'contrôlée',
    'contrôlées',
    'contrôlés',
    'contumace',
    'contumaces',
    'contumax',
    'contusion',
    'contusionna',
    'contusionnai',
    'contusionnas',
    'contusionne',
    'contusionner',
    'contusionnes',
    'contusionnez',
    'contusionnât',
    'contusionné',
    'contusionnée',
    'contusionnés',
    'contusions',
    'contâmes',
    'contât',
    'contâtes',
    'contèrent',
    'conté',
    'contée',
    'contées',
    'contés',
    'contînmes',
    'contînt',
    'contîntes',
    'conurbation',
    'conurbations',
    'convainc',
    'convaincant',
    'convaincante',
    'convaincants',
    'convaincra',
    'convaincrai',
    'convaincrais',
    'convaincrait',
    'convaincras',
    'convaincre',
    'convaincrez',
    'convaincriez',
    'convaincrons',
    'convaincront',
    'convaincs',
    'convaincu',
    'convaincue',
    'convaincues',
    'convaincus',
    'convainquais',
    'convainquait',
    'convainquant',
    'convainque',
    'convainquent',
    'convainques',
    'convainquez',
    'convainquiez',
    'convainquis',
    'convainquit',
    'convainquons',
    'convainquît',
    'convalescent',
    'convenable',
    'convenables',
    'convenaient',
    'convenais',
    'convenait',
    'convenance',
    'convenances',
    'convenant',
    'convenante',
    'convenantes',
    'convenants',
    'convenez',
    'conveniez',
    'convenions',
    'convenir',
    'convenons',
    'convention',
    'conventionna',
    'conventionne',
    'conventionné',
    'conventions',
    'conventuel',
    'conventuelle',
    'conventuels',
    'convenu',
    'convenue',
    'convenues',
    'convenus',
    'converge',
    'convergea',
    'convergeai',
    'convergeais',
    'convergeait',
    'convergeant',
    'convergeante',
    'convergeants',
    'convergeas',
    'convergeasse',
    'convergence',
    'convergences',
    'convergent',
    'convergente',
    'convergentes',
    'convergents',
    'convergeons',
    'converger',
    'convergera',
    'convergerai',
    'convergerais',
    'convergerait',
    'convergeras',
    'convergerez',
    'convergeriez',
    'convergerons',
    'convergeront',
    'converges',
    'convergez',
    'convergeâmes',
    'convergeât',
    'convergeâtes',
    'convergiez',
    'convergions',
    'convergèrent',
    'convergé',
    'convers',
    'conversa',
    'conversai',
    'conversaient',
    'conversais',
    'conversait',
    'conversant',
    'conversas',
    'conversasse',
    'conversasses',
    'conversation',
    'converse',
    'conversent',
    'converser',
    'conversera',
    'converserai',
    'converserais',
    'converserait',
    'converseras',
    'converserez',
    'converseriez',
    'converserons',
    'converseront',
    'converses',
    'conversez',
    'conversiez',
    'conversion',
    'conversions',
    'conversons',
    'conversâmes',
    'conversât',
    'conversâtes',
    'conversèrent',
    'conversé',
    'converti',
    'convertible',
    'convertibles',
    'convertie',
    'converties',
    'convertir',
    'convertira',
    'convertirai',
    'convertirais',
    'convertirait',
    'convertiras',
    'convertirent',
    'convertirez',
    'convertiriez',
    'convertirons',
    'convertiront',
    'convertis',
    'convertisse',
    'convertisses',
    'convertissez',
    'convertit',
    'convertîmes',
    'convertît',
    'convertîtes',
    'convexe',
    'convexes',
    'convexité',
    'convexités',
    'convia',
    'conviai',
    'conviaient',
    'conviais',
    'conviait',
    'conviant',
    'convias',
    'conviasse',
    'conviassent',
    'conviasses',
    'conviassiez',
    'conviassions',
    'conviction',
    'convictions',
    'convie',
    'conviendra',
    'conviendrai',
    'conviendrais',
    'conviendrait',
    'conviendras',
    'conviendrez',
    'conviendriez',
    'conviendrons',
    'conviendront',
    'convienne',
    'conviennent',
    'conviennes',
    'conviens',
    'convient',
    'convier',
    'conviera',
    'convierai',
    'convieraient',
    'convierais',
    'convierait',
    'convieras',
    'convierez',
    'convieriez',
    'convierions',
    'convierons',
    'convieront',
    'convies',
    'conviez',
    'conviiez',
    'conviions',
    'convinrent',
    'convins',
    'convinsse',
    'convinssent',
    'convinsses',
    'convinssiez',
    'convinssions',
    'convint',
    'convions',
    'convive',
    'convives',
    'convivial',
    'conviviale',
    'conviviales',
    'convivialité',
    'conviviaux',
    'conviâmes',
    'conviât',
    'conviâtes',
    'convièrent',
    'convié',
    'conviée',
    'conviées',
    'conviés',
    'convocation',
    'convocations',
    'convoi',
    'convoie',
    'convoient',
    'convoiera',
    'convoierai',
    'convoierais',
    'convoierait',
    'convoieras',
    'convoierez',
    'convoieriez',
    'convoierions',
    'convoierons',
    'convoieront',
    'convoies',
    'convois',
    'convoita',
    'convoitai',
    'convoitaient',
    'convoitais',
    'convoitait',
    'convoitant',
    'convoitas',
    'convoitasse',
    'convoitasses',
    'convoite',
    'convoitent',
    'convoiter',
    'convoitera',
    'convoiterai',
    'convoiterais',
    'convoiterait',
    'convoiteras',
    'convoiterez',
    'convoiteriez',
    'convoiterons',
    'convoiteront',
    'convoites',
    'convoitez',
    'convoitiez',
    'convoitions',
    'convoitise',
    'convoitises',
    'convoitons',
    'convoitâmes',
    'convoitât',
    'convoitâtes',
    'convoitèrent',
    'convoité',
    'convoitée',
    'convoitées',
    'convoités',
    'convola',
    'convolai',
    'convolaient',
    'convolais',
    'convolait',
    'convolant',
    'convolas',
    'convolasse',
    'convolassent',
    'convolasses',
    'convolassiez',
    'convole',
    'convolent',
    'convoler',
    'convolera',
    'convolerai',
    'convolerais',
    'convolerait',
    'convoleras',
    'convolerez',
    'convoleriez',
    'convolerions',
    'convolerons',
    'convoleront',
    'convoles',
    'convolez',
    'convoliez',
    'convolions',
    'convolons',
    'convolution',
    'convolutions',
    'convolâmes',
    'convolât',
    'convolâtes',
    'convolèrent',
    'convolé',
    'convoqua',
    'convoquai',
    'convoquaient',
    'convoquais',
    'convoquait',
    'convoquant',
    'convoquas',
    'convoquasse',
    'convoquasses',
    'convoque',
    'convoquent',
    'convoquer',
    'convoquera',
    'convoquerai',
    'convoquerais',
    'convoquerait',
    'convoqueras',
    'convoquerez',
    'convoqueriez',
    'convoquerons',
    'convoqueront',
    'convoques',
    'convoquez',
    'convoquiez',
    'convoquions',
    'convoquons',
    'convoquâmes',
    'convoquât',
    'convoquâtes',
    'convoquèrent',
    'convoqué',
    'convoquée',
    'convoquées',
    'convoqués',
    'convoya',
    'convoyai',
    'convoyaient',
    'convoyais',
    'convoyait',
    'convoyant',
    'convoyas',
    'convoyasse',
    'convoyassent',
    'convoyasses',
    'convoyassiez',
    'convoyer',
    'convoyeur',
    'convoyeurs',
    'convoyeuse',
    'convoyeuses',
    'convoyez',
    'convoyiez',
    'convoyions',
    'convoyons',
    'convoyâmes',
    'convoyât',
    'convoyâtes',
    'convoyèrent',
    'convoyé',
    'convoyée',
    'convoyées',
    'convoyés',
    'convulsa',
    'convulsai',
    'convulsaient',
    'convulsais',
    'convulsait',
    'convulsant',
    'convulsas',
    'convulsasse',
    'convulsasses',
    'convulse',
    'convulsent',
    'convulser',
    'convulsera',
    'convulserai',
    'convulserais',
    'convulserait',
    'convulseras',
    'convulserez',
    'convulseriez',
    'convulserons',
    'convulseront',
    'convulses',
    'convulsez',
    'convulsiez',
    'convulsif',
    'convulsifs',
    'convulsion',
    'convulsionna',
    'convulsionne',
    'convulsionné',
    'convulsions',
    'convulsive',
    'convulsives',
    'convulsons',
    'convulsâmes',
    'convulsât',
    'convulsâtes',
    'convulsèrent',
    'convulsé',
    'convulsée',
    'convulsées',
    'convulsés',
    'convînmes',
    'convînt',
    'convîntes',
    'conçois',
    'conçoit',
    'conçoive',
    'conçoivent',
    'conçoives',
    'conçu',
    'conçue',
    'conçues',
    'conçurent',
    'conçus',
    'conçusse',
    'conçussent',
    'conçusses',
    'conçussiez',
    'conçussions',
    'conçut',
    'conçûmes',
    'conçût',
    'conçûtes',
    'cool',
    'coolie',
    'coolies',
    'coopta',
    'cooptai',
    'cooptaient',
    'cooptais',
    'cooptait',
    'cooptant',
    'cooptas',
    'cooptasse',
    'cooptassent',
    'cooptasses',
    'cooptassiez',
    'cooptassions',
    'cooptation',
    'cooptations',
    'coopte',
    'cooptent',
    'coopter',
    'cooptera',
    'coopterai',
    'coopteraient',
    'coopterais',
    'coopterait',
    'coopteras',
    'coopterez',
    'coopteriez',
    'coopterions',
    'coopterons',
    'coopteront',
    'cooptes',
    'cooptez',
    'cooptiez',
    'cooptions',
    'cooptons',
    'cooptâmes',
    'cooptât',
    'cooptâtes',
    'cooptèrent',
    'coopté',
    'cooptée',
    'cooptées',
    'cooptés',
    'coopère',
    'coopèrent',
    'coopères',
    'coopéra',
    'coopérai',
    'coopéraient',
    'coopérais',
    'coopérait',
    'coopérant',
    'coopérante',
    'coopérantes',
    'coopérants',
    'coopéras',
    'coopérasse',
    'coopérassent',
    'coopérasses',
    'coopérassiez',
    'coopérateur',
    'coopérateurs',
    'coopératif',
    'coopératifs',
    'coopération',
    'coopérations',
    'coopératisme',
    'coopérative',
    'coopératives',
    'coopératrice',
    'coopérer',
    'coopérera',
    'coopérerai',
    'coopérerais',
    'coopérerait',
    'coopéreras',
    'coopérerez',
    'coopéreriez',
    'coopérerions',
    'coopérerons',
    'coopéreront',
    'coopérez',
    'coopériez',
    'coopérions',
    'coopérons',
    'coopérâmes',
    'coopérât',
    'coopérâtes',
    'coopérèrent',
    'coopéré',
    'coordinateur',
    'coordination',
    'coordonna',
    'coordonnai',
    'coordonnais',
    'coordonnait',
    'coordonnant',
    'coordonnas',
    'coordonnasse',
    'coordonne',
    'coordonnent',
    'coordonner',
    'coordonnera',
    'coordonnerai',
    'coordonneras',
    'coordonnerez',
    'coordonnes',
    'coordonnez',
    'coordonniez',
    'coordonnions',
    'coordonnons',
    'coordonnâmes',
    'coordonnât',
    'coordonnâtes',
    'coordonné',
    'coordonnée',
    'coordonnées',
    'coordonnés',
    'copain',
    'copains',
    'copal',
    'copals',
    'copartage',
    'copartageant',
    'copartager',
    'copartages',
    'copaïer',
    'copaïers',
    'copeau',
    'copeaux',
    'copermuta',
    'copermutai',
    'copermutais',
    'copermutait',
    'copermutant',
    'copermutas',
    'copermutasse',
    'copermute',
    'copermutent',
    'copermuter',
    'copermutera',
    'copermuterai',
    'copermuteras',
    'copermuterez',
    'copermutes',
    'copermutez',
    'copermutiez',
    'copermutions',
    'copermutons',
    'copermutâmes',
    'copermutât',
    'copermutâtes',
    'copermuté',
    'copermutée',
    'copermutées',
    'copermutés',
    'copernicien',
    'coperniciens',
    'copia',
    'copiage',
    'copiages',
    'copiai',
    'copiaient',
    'copiais',
    'copiait',
    'copiant',
    'copias',
    'copiasse',
    'copiassent',
    'copiasses',
    'copiassiez',
    'copiassions',
    'copie',
    'copient',
    'copier',
    'copiera',
    'copierai',
    'copieraient',
    'copierais',
    'copierait',
    'copieras',
    'copierez',
    'copieriez',
    'copierions',
    'copierons',
    'copieront',
    'copies',
    'copieur',
    'copieurs',
    'copieuse',
    'copieusement',
    'copieuses',
    'copieux',
    'copiez',
    'copiiez',
    'copiions',
    'copilote',
    'copilotes',
    'copina',
    'copinage',
    'copinages',
    'copinai',
    'copinaient',
    'copinais',
    'copinait',
    'copinant',
    'copinas',
    'copinasse',
    'copinassent',
    'copinasses',
    'copinassiez',
    'copinassions',
    'copine',
    'copinent',
    'copiner',
    'copinera',
    'copinerai',
    'copineraient',
    'copinerais',
    'copinerait',
    'copineras',
    'copinerez',
    'copinerie',
    'copineries',
    'copineriez',
    'copinerions',
    'copinerons',
    'copineront',
    'copines',
    'copinez',
    'copiniez',
    'copinions',
    'copinons',
    'copinâmes',
    'copinât',
    'copinâtes',
    'copinèrent',
    'copiné',
    'copions',
    'copiste',
    'copistes',
    'copiâmes',
    'copiât',
    'copiâtes',
    'copièrent',
    'copié',
    'copiée',
    'copiées',
    'copiés',
    'coplanaire',
    'coplanaires',
    'copossesseur',
    'copossède',
    'copossèdent',
    'copossèdes',
    'coposséder',
    'copossédé',
    'copossédée',
    'copossédées',
    'copossédés',
    'copposéda',
    'copposédai',
    'copposédais',
    'copposédait',
    'copposédant',
    'copposédas',
    'copposédasse',
    'copposédera',
    'copposéderai',
    'copposéderas',
    'copposéderez',
    'copposédez',
    'copposédiez',
    'copposédions',
    'copposédons',
    'copposédâmes',
    'copposédât',
    'copposédâtes',
    'copra',
    'coprah',
    'coprahs',
    'copras',
    'coproduction',
    'coprolithe',
    'coprolithes',
    'copropriété',
    'copropriétés',
    'coprésidence',
    'coprésident',
    'coprésidente',
    'coprésidents',
    'copte',
    'coptes',
    'copula',
    'copulai',
    'copulaient',
    'copulais',
    'copulait',
    'copulant',
    'copulas',
    'copulasse',
    'copulassent',
    'copulasses',
    'copulassiez',
    'copulassions',
    'copulatif',
    'copulatifs',
    'copulation',
    'copulations',
    'copulative',
    'copulatives',
    'copule',
    'copulent',
    'copuler',
    'copulera',
    'copulerai',
    'copuleraient',
    'copulerais',
    'copulerait',
    'copuleras',
    'copulerez',
    'copuleriez',
    'copulerions',
    'copulerons',
    'copuleront',
    'copules',
    'copulez',
    'copuliez',
    'copulions',
    'copulons',
    'copulâmes',
    'copulât',
    'copulâtes',
    'copulèrent',
    'copulé',
    'copyright',
    'coqs',
    'coqua',
    'coquai',
    'coquaient',
    'coquais',
    'coquait',
    'coquant',
    'coquard',
    'coquards',
    'coquart',
    'coquarts',
    'coquas',
    'coquasse',
    'coquassent',
    'coquasses',
    'coquassiez',
    'coquassions',
    'coque',
    'coquelet',
    'coquelets',
    'coqueleux',
    'coquelicot',
    'coquelicots',
    'coqueluche',
    'coqueluches',
    'coquelucheux',
    'coquent',
    'coquer',
    'coquera',
    'coquerai',
    'coqueraient',
    'coquerais',
    'coquerait',
    'coqueras',
    'coquerez',
    'coquerico',
    'coquericos',
    'coqueriez',
    'coquerions',
    'coquerons',
    'coqueront',
    'coques',
    'coquet',
    'coqueta',
    'coquetai',
    'coquetaient',
    'coquetais',
    'coquetait',
    'coquetant',
    'coquetas',
    'coquetasse',
    'coquetassent',
    'coquetasses',
    'coquetassiez',
    'coqueter',
    'coquetez',
    'coquetier',
    'coquetiers',
    'coquetiez',
    'coquetions',
    'coquetons',
    'coquets',
    'coquette',
    'coquettement',
    'coquettent',
    'coquettera',
    'coquetterai',
    'coquetterais',
    'coquetterait',
    'coquetteras',
    'coquetterez',
    'coquetterie',
    'coquetteries',
    'coquetteriez',
    'coquetterons',
    'coquetteront',
    'coquettes',
    'coquetâmes',
    'coquetât',
    'coquetâtes',
    'coquetèrent',
    'coqueté',
    'coquez',
    'coquiez',
    'coquilla',
    'coquillage',
    'coquillages',
    'coquillai',
    'coquillaient',
    'coquillais',
    'coquillait',
    'coquillant',
    'coquillart',
    'coquillarts',
    'coquillas',
    'coquillasse',
    'coquillasses',
    'coquille',
    'coquillent',
    'coquiller',
    'coquillera',
    'coquillerai',
    'coquillerais',
    'coquillerait',
    'coquilleras',
    'coquillerez',
    'coquilleriez',
    'coquillerons',
    'coquilleront',
    'coquilles',
    'coquillette',
    'coquillettes',
    'coquillez',
    'coquillier',
    'coquilliers',
    'coquilliez',
    'coquillions',
    'coquillière',
    'coquillières',
    'coquillons',
    'coquillâmes',
    'coquillât',
    'coquillâtes',
    'coquillèrent',
    'coquillé',
    'coquin',
    'coquine',
    'coquinerie',
    'coquineries',
    'coquines',
    'coquins',
    'coquions',
    'coquons',
    'coquâmes',
    'coquât',
    'coquâtes',
    'coquèrent',
    'coqué',
    'coquée',
    'coquées',
    'coqués',
    'corail',
    'corallien',
    'corallienne',
    'coralliennes',
    'coralliens',
    'coran',
    'coranique',
    'coraniques',
    'corans',
    'coraux',
    'corbeau',
    'corbeaux',
    'corbeille',
    'corbeilles',
    'corbillard',
    'corbillards',
    'corbillat',
    'corbillats',
    'corbin',
    'corbins',
    'corda',
    'cordage',
    'cordages',
    'cordai',
    'cordaient',
    'cordais',
    'cordait',
    'cordant',
    'cordas',
    'cordasse',
    'cordassent',
    'cordasses',
    'cordassiez',
    'cordassions',
    'corde',
    'cordeau',
    'cordeaux',
    'cordela',
    'cordelai',
    'cordelaient',
    'cordelais',
    'cordelait',
    'cordelant',
    'cordelas',
    'cordelasse',
    'cordelassent',
    'cordelasses',
    'cordelassiez',
    'cordeler',
    'cordelette',
    'cordelettes',
    'cordelez',
    'cordelier',
    'cordeliers',
    'cordeliez',
    'cordelions',
    'cordelière',
    'cordelières',
    'cordelle',
    'cordellent',
    'cordellera',
    'cordellerai',
    'cordellerais',
    'cordellerait',
    'cordelleras',
    'cordellerez',
    'cordelleriez',
    'cordellerons',
    'cordelleront',
    'cordelles',
    'cordelons',
    'cordelâmes',
    'cordelât',
    'cordelâtes',
    'cordelèrent',
    'cordelé',
    'cordelée',
    'cordelées',
    'cordelés',
    'cordent',
    'corder',
    'cordera',
    'corderai',
    'corderaient',
    'corderais',
    'corderait',
    'corderas',
    'corderez',
    'corderiez',
    'corderions',
    'corderons',
    'corderont',
    'cordes',
    'cordez',
    'cordial',
    'cordiale',
    'cordialement',
    'cordiales',
    'cordialité',
    'cordialités',
    'cordiaux',
    'cordier',
    'cordiers',
    'cordiez',
    'cordillère',
    'cordillères',
    'cordions',
    'cordon',
    'cordonna',
    'cordonnai',
    'cordonnaient',
    'cordonnais',
    'cordonnait',
    'cordonnant',
    'cordonnas',
    'cordonnasse',
    'cordonnasses',
    'cordonne',
    'cordonnent',
    'cordonner',
    'cordonnera',
    'cordonnerai',
    'cordonnerais',
    'cordonnerait',
    'cordonneras',
    'cordonnerez',
    'cordonnerie',
    'cordonneries',
    'cordonneriez',
    'cordonnerons',
    'cordonneront',
    'cordonnes',
    'cordonnet',
    'cordonnets',
    'cordonnez',
    'cordonnier',
    'cordonniers',
    'cordonniez',
    'cordonnions',
    'cordonnons',
    'cordonnâmes',
    'cordonnât',
    'cordonnâtes',
    'cordonnèrent',
    'cordonné',
    'cordonnée',
    'cordonnées',
    'cordonnés',
    'cordons',
    'cordâmes',
    'cordât',
    'cordâtes',
    'cordèrent',
    'cordé',
    'cordée',
    'cordées',
    'cordés',
    'coriace',
    'coriaces',
    'coriandre',
    'coriandres',
    'coricide',
    'coricides',
    'corindon',
    'corindons',
    'corinthien',
    'corinthienne',
    'corinthiens',
    'cormier',
    'cormiers',
    'cormoran',
    'cormorans',
    'corna',
    'cornac',
    'cornacs',
    'cornai',
    'cornaient',
    'cornais',
    'cornait',
    'cornaline',
    'cornalines',
    'cornant',
    'cornard',
    'cornards',
    'cornas',
    'cornasse',
    'cornassent',
    'cornasses',
    'cornassiez',
    'cornassions',
    'corne',
    'corneille',
    'corneilles',
    'cornemuse',
    'cornemuses',
    'cornemuseur',
    'cornemuseurs',
    'cornent',
    'corner',
    'cornera',
    'cornerai',
    'corneraient',
    'cornerais',
    'cornerait',
    'corneras',
    'cornerez',
    'corneriez',
    'cornerions',
    'cornerons',
    'corneront',
    'corners',
    'cornes',
    'cornet',
    'cornets',
    'cornette',
    'cornettes',
    'cornettiste',
    'cornettistes',
    'cornez',
    'corniaud',
    'corniauds',
    'corniche',
    'corniches',
    'cornichon',
    'cornichons',
    'cornier',
    'corniers',
    'corniez',
    'cornions',
    'corniste',
    'cornistes',
    'cornière',
    'cornières',
    'cornons',
    'cornu',
    'cornue',
    'cornues',
    'cornus',
    'cornâmes',
    'cornât',
    'cornâtes',
    'cornèrent',
    'corné',
    'cornée',
    'cornéen',
    'cornéenne',
    'cornéennes',
    'cornéens',
    'cornées',
    'cornélien',
    'cornélienne',
    'cornéliennes',
    'cornéliens',
    'cornés',
    'corollaire',
    'corollaires',
    'corolle',
    'corolles',
    'coron',
    'coronaire',
    'coronaires',
    'coronarien',
    'coronarienne',
    'coronariens',
    'coronarite',
    'coronarites',
    'coroner',
    'coroners',
    'coronille',
    'coronilles',
    'corons',
    'corozo',
    'corozos',
    'corporal',
    'corporatif',
    'corporatifs',
    'corporation',
    'corporations',
    'corporatisme',
    'corporatiste',
    'corporative',
    'corporatives',
    'corporaux',
    'corporel',
    'corporelle',
    'corporelles',
    'corporels',
    'corps',
    'corpulence',
    'corpulences',
    'corpulent',
    'corpulente',
    'corpulentes',
    'corpulents',
    'corpus',
    'corpuscule',
    'corpuscules',
    'corral',
    'corrals',
    'correct',
    'correcte',
    'correctement',
    'correctes',
    'correcteur',
    'correcteurs',
    'correctif',
    'correctifs',
    'correction',
    'corrections',
    'corrective',
    'correctives',
    'correctrice',
    'correctrices',
    'corrects',
    'correspond',
    'corresponde',
    'correspondes',
    'correspondez',
    'correspondis',
    'correspondit',
    'correspondra',
    'correspondre',
    'corresponds',
    'correspondu',
    'correspondue',
    'correspondus',
    'correspondît',
    'corrida',
    'corridas',
    'corridor',
    'corridors',
    'corrige',
    'corrigea',
    'corrigeai',
    'corrigeaient',
    'corrigeais',
    'corrigeait',
    'corrigeant',
    'corrigeas',
    'corrigeasse',
    'corrigeasses',
    'corrigent',
    'corrigeons',
    'corriger',
    'corrigera',
    'corrigerai',
    'corrigerais',
    'corrigerait',
    'corrigeras',
    'corrigerez',
    'corrigeriez',
    'corrigerions',
    'corrigerons',
    'corrigeront',
    'corriges',
    'corrigez',
    'corrigeâmes',
    'corrigeât',
    'corrigeâtes',
    'corrigible',
    'corrigibles',
    'corrigiez',
    'corrigions',
    'corrigèrent',
    'corrigé',
    'corrigée',
    'corrigées',
    'corrigés',
    'corrobora',
    'corroborai',
    'corroborais',
    'corroborait',
    'corroborant',
    'corroboras',
    'corroborasse',
    'corrobore',
    'corroborent',
    'corroborer',
    'corroborera',
    'corroborerai',
    'corroboreras',
    'corroborerez',
    'corrobores',
    'corroborez',
    'corroboriez',
    'corroborions',
    'corroborons',
    'corroborâmes',
    'corroborât',
    'corroborâtes',
    'corroboré',
    'corroborée',
    'corroborées',
    'corroborés',
    'corroda',
    'corrodai',
    'corrodaient',
    'corrodais',
    'corrodait',
    'corrodant',
    'corrodas',
    'corrodasse',
    'corrodassent',
    'corrodasses',
    'corrodassiez',
    'corrode',
    'corrodent',
    'corroder',
    'corrodera',
    'corroderai',
    'corroderais',
    'corroderait',
    'corroderas',
    'corroderez',
    'corroderiez',
    'corroderions',
    'corroderons',
    'corroderont',
    'corrodes',
    'corrodez',
    'corrodiez',
    'corrodions',
    'corrodons',
    'corrodâmes',
    'corrodât',
    'corrodâtes',
    'corrodèrent',
    'corrodé',
    'corrodée',
    'corrodées',
    'corrodés',
    'corroie',
    'corroient',
    'corroiera',
    'corroierai',
    'corroierais',
    'corroierait',
    'corroieras',
    'corroierez',
    'corroieriez',
    'corroierions',
    'corroierons',
    'corroieront',
    'corroies',
    'corrompaient',
    'corrompais',
    'corrompait',
    'corrompant',
    'corrompe',
    'corrompent',
    'corrompes',
    'corrompez',
    'corrompiez',
    'corrompions',
    'corrompirent',
    'corrompis',
    'corrompisse',
    'corrompisses',
    'corrompit',
    'corrompons',
    'corrompra',
    'corromprai',
    'corromprais',
    'corromprait',
    'corrompras',
    'corrompre',
    'corromprez',
    'corrompriez',
    'corromprions',
    'corromprons',
    'corrompront',
    'corromps',
    'corrompt',
    'corrompu',
    'corrompue',
    'corrompues',
    'corrompus',
    'corrompîmes',
    'corrompît',
    'corrompîtes',
    'corrosif',
    'corrosifs',
    'corrosion',
    'corrosions',
    'corrosive',
    'corrosives',
    'corroya',
    'corroyage',
    'corroyages',
    'corroyai',
    'corroyaient',
    'corroyais',
    'corroyait',
    'corroyant',
    'corroyas',
    'corroyasse',
    'corroyassent',
    'corroyasses',
    'corroyassiez',
    'corroyer',
    'corroyeur',
    'corroyeurs',
    'corroyez',
    'corroyiez',
    'corroyions',
    'corroyons',
    'corroyâmes',
    'corroyât',
    'corroyâtes',
    'corroyèrent',
    'corroyé',
    'corroyée',
    'corroyées',
    'corroyés',
    'corrupteur',
    'corrupteurs',
    'corruptible',
    'corruptibles',
    'corruption',
    'corruptions',
    'corruptrice',
    'corruptrices',
    'corrèle',
    'corrèlent',
    'corrèles',
    'corréla',
    'corrélai',
    'corrélaient',
    'corrélais',
    'corrélait',
    'corrélant',
    'corrélas',
    'corrélasse',
    'corrélassent',
    'corrélasses',
    'corrélassiez',
    'corrélatif',
    'corrélatifs',
    'corrélation',
    'corrélations',
    'corrélative',
    'corrélatives',
    'corréler',
    'corrélera',
    'corrélerai',
    'corrélerais',
    'corrélerait',
    'corréleras',
    'corrélerez',
    'corréleriez',
    'corrélerions',
    'corrélerons',
    'corréleront',
    'corrélez',
    'corréliez',
    'corrélions',
    'corrélons',
    'corrélâmes',
    'corrélât',
    'corrélâtes',
    'corrélèrent',
    'corrélé',
    'corrélée',
    'corrélées',
    'corrélés',
    'cors',
    'corsa',
    'corsage',
    'corsages',
    'corsai',
    'corsaient',
    'corsaire',
    'corsaires',
    'corsais',
    'corsait',
    'corsant',
    'corsas',
    'corsasse',
    'corsassent',
    'corsasses',
    'corsassiez',
    'corsassions',
    'corse',
    'corselet',
    'corselets',
    'corsent',
    'corser',
    'corsera',
    'corserai',
    'corseraient',
    'corserais',
    'corserait',
    'corseras',
    'corserez',
    'corseriez',
    'corserions',
    'corserons',
    'corseront',
    'corses',
    'corset',
    'corseta',
    'corsetai',
    'corsetaient',
    'corsetais',
    'corsetait',
    'corsetant',
    'corsetas',
    'corsetasse',
    'corsetassent',
    'corsetasses',
    'corsetassiez',
    'corseter',
    'corsetez',
    'corsetier',
    'corsetiers',
    'corsetiez',
    'corsetions',
    'corsetière',
    'corsetières',
    'corsetons',
    'corsets',
    'corsetâmes',
    'corsetât',
    'corsetâtes',
    'corsetèrent',
    'corseté',
    'corsetée',
    'corsetées',
    'corsetés',
    'corsez',
    'corsiez',
    'corsions',
    'corsons',
    'corsâmes',
    'corsât',
    'corsâtes',
    'corsèrent',
    'corsète',
    'corsètent',
    'corsètera',
    'corsèterai',
    'corsèterais',
    'corsèterait',
    'corsèteras',
    'corsèterez',
    'corsèteriez',
    'corsèterions',
    'corsèterons',
    'corsèteront',
    'corsètes',
    'corsé',
    'corsée',
    'corsées',
    'corsés',
    'cortex',
    'cortical',
    'corticale',
    'corticales',
    'corticaux',
    'cortisone',
    'cortège',
    'cortèges',
    'corvette',
    'corvettes',
    'corvéable',
    'corvéables',
    'corvée',
    'corvées',
    'coryphée',
    'coryphées',
    'coryza',
    'coryzas',
    'coréen',
    'coréenne',
    'coréennes',
    'coréens',
    'cosaque',
    'cosaques',
    'cosignataire',
    'cosinus',
    'cosmique',
    'cosmiques',
    'cosmodrome',
    'cosmodromes',
    'cosmogonie',
    'cosmogonies',
    'cosmogonique',
    'cosmographie',
    'cosmologie',
    'cosmologies',
    'cosmonaute',
    'cosmonautes',
    'cosmopolite',
    'cosmopolites',
    'cosmos',
    'cosmétiqua',
    'cosmétiquai',
    'cosmétiquais',
    'cosmétiquait',
    'cosmétiquant',
    'cosmétiquas',
    'cosmétique',
    'cosmétiquent',
    'cosmétiquer',
    'cosmétiquera',
    'cosmétiques',
    'cosmétiquez',
    'cosmétiquiez',
    'cosmétiquons',
    'cosmétiquât',
    'cosmétiqué',
    'cosmétiquée',
    'cosmétiquées',
    'cosmétiqués',
    'cosmétologie',
    'cosmétologue',
    'cossa',
    'cossai',
    'cossaient',
    'cossais',
    'cossait',
    'cossant',
    'cossard',
    'cossarde',
    'cossardes',
    'cossards',
    'cossas',
    'cossasse',
    'cossassent',
    'cossasses',
    'cossassiez',
    'cossassions',
    'cosse',
    'cossent',
    'cosser',
    'cossera',
    'cosserai',
    'cosseraient',
    'cosserais',
    'cosserait',
    'cosseras',
    'cosserez',
    'cosseriez',
    'cosserions',
    'cosserons',
    'cosseront',
    'cosses',
    'cossez',
    'cossiez',
    'cossions',
    'cossons',
    'cossu',
    'cossue',
    'cossues',
    'cossus',
    'cossâmes',
    'cossât',
    'cossâtes',
    'cossèrent',
    'cossé',
    'costal',
    'costale',
    'costales',
    'costard',
    'costards',
    'costaud',
    'costaude',
    'costaudes',
    'costauds',
    'costaux',
    'costuma',
    'costumai',
    'costumaient',
    'costumais',
    'costumait',
    'costumant',
    'costumas',
    'costumasse',
    'costumassent',
    'costumasses',
    'costumassiez',
    'costume',
    'costument',
    'costumer',
    'costumera',
    'costumerai',
    'costumerais',
    'costumerait',
    'costumeras',
    'costumerez',
    'costumeriez',
    'costumerions',
    'costumerons',
    'costumeront',
    'costumes',
    'costumez',
    'costumier',
    'costumiers',
    'costumiez',
    'costumions',
    'costumière',
    'costumières',
    'costumons',
    'costumâmes',
    'costumât',
    'costumâtes',
    'costumèrent',
    'costumé',
    'costumée',
    'costumées',
    'costumés',
    'cosy',
    'cosys',
    'cota',
    'cotable',
    'cotables',
    'cotai',
    'cotaient',
    'cotais',
    'cotait',
    'cotant',
    'cotas',
    'cotasse',
    'cotassent',
    'cotasses',
    'cotassiez',
    'cotassions',
    'cotation',
    'cotations',
    'cote',
    'coteau',
    'coteaux',
    'cotent',
    'coter',
    'cotera',
    'coterai',
    'coteraient',
    'coterais',
    'coterait',
    'coteras',
    'coterez',
    'coterie',
    'coteries',
    'coteriez',
    'coterions',
    'coterons',
    'coteront',
    'cotes',
    'cotez',
    'cothurne',
    'cothurnes',
    'coti',
    'cotie',
    'coties',
    'cotiez',
    'cotillon',
    'cotillons',
    'cotions',
    'cotir',
    'cotira',
    'cotirai',
    'cotiraient',
    'cotirais',
    'cotirait',
    'cotiras',
    'cotirent',
    'cotirez',
    'cotiriez',
    'cotirions',
    'cotirons',
    'cotiront',
    'cotis',
    'cotisa',
    'cotisai',
    'cotisaient',
    'cotisais',
    'cotisait',
    'cotisant',
    'cotisante',
    'cotisantes',
    'cotisants',
    'cotisas',
    'cotisasse',
    'cotisassent',
    'cotisasses',
    'cotisassiez',
    'cotisassions',
    'cotisation',
    'cotisations',
    'cotise',
    'cotisent',
    'cotiser',
    'cotisera',
    'cotiserai',
    'cotiseraient',
    'cotiserais',
    'cotiserait',
    'cotiseras',
    'cotiserez',
    'cotiseriez',
    'cotiserions',
    'cotiserons',
    'cotiseront',
    'cotises',
    'cotisez',
    'cotisiez',
    'cotisions',
    'cotisons',
    'cotissaient',
    'cotissais',
    'cotissait',
    'cotissant',
    'cotisse',
    'cotissent',
    'cotisses',
    'cotissez',
    'cotissiez',
    'cotissions',
    'cotissons',
    'cotisâmes',
    'cotisât',
    'cotisâtes',
    'cotisèrent',
    'cotisé',
    'cotisée',
    'cotisées',
    'cotisés',
    'cotit',
    'coton',
    'cotonna',
    'cotonnade',
    'cotonnades',
    'cotonnai',
    'cotonnaient',
    'cotonnais',
    'cotonnait',
    'cotonnant',
    'cotonnas',
    'cotonnasse',
    'cotonnassent',
    'cotonnasses',
    'cotonnassiez',
    'cotonne',
    'cotonnent',
    'cotonner',
    'cotonnera',
    'cotonnerai',
    'cotonnerais',
    'cotonnerait',
    'cotonneras',
    'cotonnerez',
    'cotonneriez',
    'cotonnerions',
    'cotonnerons',
    'cotonneront',
    'cotonnes',
    'cotonneuse',
    'cotonneuses',
    'cotonneux',
    'cotonnez',
    'cotonnier',
    'cotonniers',
    'cotonniez',
    'cotonnions',
    'cotonnière',
    'cotonnières',
    'cotonnons',
    'cotonnâmes',
    'cotonnât',
    'cotonnâtes',
    'cotonnèrent',
    'cotonné',
    'cotonnée',
    'cotonnées',
    'cotonnés',
    'cotons',
    'cottage',
    'cottages',
    'cotte',
    'cottes',
    'cotylédon',
    'cotylédons',
    'cotâmes',
    'cotât',
    'cotâtes',
    'cotèrent',
    'coté',
    'cotée',
    'cotées',
    'cotés',
    'cotîmes',
    'cotît',
    'cotîtes',
    'couac',
    'couacs',
    'couard',
    'couarde',
    'couardes',
    'couardise',
    'couardises',
    'couards',
    'coucha',
    'couchage',
    'couchages',
    'couchai',
    'couchaient',
    'couchailla',
    'couchaillai',
    'couchaillais',
    'couchaillas',
    'couchaille',
    'couchaillent',
    'couchailler',
    'couchaillera',
    'couchailles',
    'couchaillât',
    'couchaillé',
    'couchais',
    'couchait',
    'couchant',
    'couchante',
    'couchantes',
    'couchants',
    'couchas',
    'couchasse',
    'couchassent',
    'couchasses',
    'couchassiez',
    'couchassions',
    'couche',
    'couchent',
    'coucher',
    'couchera',
    'coucherai',
    'coucheraient',
    'coucherais',
    'coucherait',
    'coucheras',
    'coucherez',
    'coucheriez',
    'coucherions',
    'coucherons',
    'coucheront',
    'couchers',
    'couches',
    'couchette',
    'couchettes',
    'coucheur',
    'coucheurs',
    'coucheuse',
    'coucheuses',
    'couchez',
    'couchiez',
    'couchions',
    'couchons',
    'couchâmes',
    'couchât',
    'couchâtes',
    'couchèrent',
    'couché',
    'couchée',
    'couchées',
    'couchés',
    'coucou',
    'coucous',
    'coud',
    'couda',
    'coudai',
    'coudaient',
    'coudais',
    'coudait',
    'coudant',
    'coudas',
    'coudasse',
    'coudassent',
    'coudasses',
    'coudassiez',
    'coudassions',
    'coude',
    'coudent',
    'couder',
    'coudera',
    'couderai',
    'couderaient',
    'couderais',
    'couderait',
    'couderas',
    'couderez',
    'couderiez',
    'couderions',
    'couderons',
    'couderont',
    'coudes',
    'coudez',
    'coudiez',
    'coudions',
    'coudoie',
    'coudoiement',
    'coudoiements',
    'coudoient',
    'coudoiera',
    'coudoierai',
    'coudoierais',
    'coudoierait',
    'coudoieras',
    'coudoierez',
    'coudoieriez',
    'coudoierions',
    'coudoierons',
    'coudoieront',
    'coudoies',
    'coudons',
    'coudoya',
    'coudoyai',
    'coudoyaient',
    'coudoyais',
    'coudoyait',
    'coudoyant',
    'coudoyas',
    'coudoyasse',
    'coudoyassent',
    'coudoyasses',
    'coudoyassiez',
    'coudoyer',
    'coudoyez',
    'coudoyiez',
    'coudoyions',
    'coudoyons',
    'coudoyâmes',
    'coudoyât',
    'coudoyâtes',
    'coudoyèrent',
    'coudoyé',
    'coudoyée',
    'coudoyées',
    'coudoyés',
    'coudra',
    'coudrai',
    'coudraie',
    'coudraient',
    'coudraies',
    'coudrais',
    'coudrait',
    'coudras',
    'coudre',
    'coudrez',
    'coudrier',
    'coudriers',
    'coudriez',
    'coudrions',
    'coudrons',
    'coudront',
    'couds',
    'coudâmes',
    'coudât',
    'coudâtes',
    'coudèrent',
    'coudé',
    'coudée',
    'coudées',
    'coudés',
    'couenne',
    'couennes',
    'couette',
    'couettes',
    'couffin',
    'couffins',
    'coufique',
    'coufiques',
    'cougouar',
    'cougouars',
    'couguar',
    'couguars',
    'couic',
    'couille',
    'couilles',
    'couillon',
    'couillonna',
    'couillonnai',
    'couillonnais',
    'couillonnait',
    'couillonnant',
    'couillonnas',
    'couillonne',
    'couillonnent',
    'couillonner',
    'couillonnera',
    'couillonnes',
    'couillonnez',
    'couillonniez',
    'couillonnons',
    'couillonnât',
    'couillonné',
    'couillonnée',
    'couillonnées',
    'couillonnés',
    'couillons',
    'couina',
    'couinai',
    'couinaient',
    'couinais',
    'couinait',
    'couinant',
    'couinas',
    'couinasse',
    'couinassent',
    'couinasses',
    'couinassiez',
    'couinassions',
    'couine',
    'couinement',
    'couinements',
    'couinent',
    'couiner',
    'couinera',
    'couinerai',
    'couineraient',
    'couinerais',
    'couinerait',
    'couineras',
    'couinerez',
    'couineriez',
    'couinerions',
    'couinerons',
    'couineront',
    'couines',
    'couinez',
    'couiniez',
    'couinions',
    'couinons',
    'couinâmes',
    'couinât',
    'couinâtes',
    'couinèrent',
    'couiné',
    'coula',
    'coulage',
    'coulages',
    'coulai',
    'coulaient',
    'coulais',
    'coulait',
    'coulant',
    'coulante',
    'coulantes',
    'coulants',
    'coulas',
    'coulasse',
    'coulassent',
    'coulasses',
    'coulassiez',
    'coulassions',
    'coule',
    'coulent',
    'couler',
    'coulera',
    'coulerai',
    'couleraient',
    'coulerais',
    'coulerait',
    'couleras',
    'coulerez',
    'couleriez',
    'coulerions',
    'coulerons',
    'couleront',
    'coules',
    'couleur',
    'couleurs',
    'couleuvre',
    'couleuvres',
    'coulez',
    'couliez',
    'coulions',
    'coulis',
    'coulissa',
    'coulissai',
    'coulissaient',
    'coulissais',
    'coulissait',
    'coulissant',
    'coulissante',
    'coulissantes',
    'coulissants',
    'coulissas',
    'coulissasse',
    'coulissasses',
    'coulisse',
    'coulissement',
    'coulissent',
    'coulisser',
    'coulissera',
    'coulisserai',
    'coulisserais',
    'coulisserait',
    'coulisseras',
    'coulisserez',
    'coulisseriez',
    'coulisserons',
    'coulisseront',
    'coulisses',
    'coulissez',
    'coulissier',
    'coulissiers',
    'coulissiez',
    'coulissions',
    'coulissons',
    'coulissâmes',
    'coulissât',
    'coulissâtes',
    'coulissèrent',
    'coulissé',
    'coulissée',
    'coulissées',
    'coulissés',
    'couloir',
    'couloirs',
    'coulomb',
    'coulombs',
    'coulommiers',
    'coulons',
    'coulure',
    'coulures',
    'coulâmes',
    'coulât',
    'coulâtes',
    'coulèrent',
    'coulé',
    'coulée',
    'coulées',
    'coulés',
    'country',
    'coup',
    'coupa',
    'coupable',
    'coupables',
    'coupage',
    'coupages',
    'coupai',
    'coupaient',
    'coupailla',
    'coupaillai',
    'coupaillais',
    'coupaillait',
    'coupaillant',
    'coupaillas',
    'coupaillasse',
    'coupaille',
    'coupaillent',
    'coupailler',
    'coupaillera',
    'coupaillerai',
    'coupailleras',
    'coupaillerez',
    'coupailles',
    'coupaillez',
    'coupailliez',
    'coupaillions',
    'coupaillons',
    'coupaillâmes',
    'coupaillât',
    'coupaillâtes',
    'coupaillé',
    'coupaillée',
    'coupaillées',
    'coupaillés',
    'coupais',
    'coupait',
    'coupant',
    'coupante',
    'coupantes',
    'coupants',
    'coupas',
    'coupasse',
    'coupassent',
    'coupasses',
    'coupassiez',
    'coupassions',
    'coupe',
    'coupella',
    'coupellai',
    'coupellaient',
    'coupellais',
    'coupellait',
    'coupellant',
    'coupellas',
    'coupellasse',
    'coupellasses',
    'coupelle',
    'coupellent',
    'coupeller',
    'coupellera',
    'coupellerai',
    'coupellerais',
    'coupellerait',
    'coupelleras',
    'coupellerez',
    'coupelleriez',
    'coupellerons',
    'coupelleront',
    'coupelles',
    'coupellez',
    'coupelliez',
    'coupellions',
    'coupellons',
    'coupellâmes',
    'coupellât',
    'coupellâtes',
    'coupellèrent',
    'coupellé',
    'coupellée',
    'coupellées',
    'coupellés',
    'coupent',
    'couper',
    'coupera',
    'couperai',
    'couperaient',
    'couperais',
    'couperait',
    'couperas',
    'couperet',
    'couperets',
    'couperez',
    'couperiez',
    'couperions',
    'couperons',
    'couperont',
    'couperose',
    'couperoses',
    'couperosé',
    'couperosée',
    'couperosées',
    'couperosés',
    'coupes',
    'coupez',
    'coupiez',
    'coupions',
    'coupla',
    'couplage',
    'couplages',
    'couplai',
    'couplaient',
    'couplais',
    'couplait',
    'couplant',
    'couplas',
    'couplasse',
    'couplassent',
    'couplasses',
    'couplassiez',
    'couplassions',
    'couple',
    'couplent',
    'coupler',
    'couplera',
    'couplerai',
    'coupleraient',
    'couplerais',
    'couplerait',
    'coupleras',
    'couplerez',
    'coupleriez',
    'couplerions',
    'couplerons',
    'coupleront',
    'couples',
    'couplet',
    'couplets',
    'coupleur',
    'coupleurs',
    'couplez',
    'coupliez',
    'couplions',
    'couplons',
    'couplâmes',
    'couplât',
    'couplâtes',
    'couplèrent',
    'couplé',
    'couplée',
    'couplées',
    'couplés',
    'coupole',
    'coupoles',
    'coupon',
    'coupons',
    'coups',
    'coupure',
    'coupures',
    'coupâmes',
    'coupât',
    'coupâtes',
    'coupèrent',
    'coupé',
    'coupée',
    'coupées',
    'coupés',
    'cour',
    'courage',
    'courages',
    'courageuse',
    'courageuses',
    'courageux',
    'couraient',
    'courailla',
    'couraillai',
    'couraillais',
    'couraillait',
    'couraillant',
    'couraillas',
    'couraillasse',
    'couraille',
    'couraillent',
    'courailler',
    'couraillera',
    'couraillerai',
    'courailleras',
    'couraillerez',
    'courailles',
    'couraillez',
    'courailliez',
    'couraillions',
    'couraillons',
    'couraillâmes',
    'couraillât',
    'couraillâtes',
    'couraillé',
    'courais',
    'courait',
    'couramment',
    'courant',
    'courante',
    'courantes',
    'courants',
    'courba',
    'courbai',
    'courbaient',
    'courbais',
    'courbait',
    'courbant',
    'courbas',
    'courbasse',
    'courbassent',
    'courbasses',
    'courbassiez',
    'courbassions',
    'courbatu',
    'courbatue',
    'courbatues',
    'courbatura',
    'courbaturai',
    'courbaturais',
    'courbaturait',
    'courbaturant',
    'courbaturas',
    'courbature',
    'courbaturent',
    'courbaturer',
    'courbaturera',
    'courbatures',
    'courbaturez',
    'courbaturiez',
    'courbaturons',
    'courbaturât',
    'courbaturé',
    'courbaturée',
    'courbaturées',
    'courbaturés',
    'courbatus',
    'courbe',
    'courbement',
    'courbements',
    'courbent',
    'courber',
    'courbera',
    'courberai',
    'courberaient',
    'courberais',
    'courberait',
    'courberas',
    'courberez',
    'courberiez',
    'courberions',
    'courberons',
    'courberont',
    'courbes',
    'courbette',
    'courbettes',
    'courbez',
    'courbiez',
    'courbions',
    'courbons',
    'courbure',
    'courbures',
    'courbâmes',
    'courbât',
    'courbâtes',
    'courbèrent',
    'courbé',
    'courbée',
    'courbées',
    'courbés',
    'courcailler',
    'courcaillet',
    'courcaillets',
    'coure',
    'courent',
    'coures',
    'courette',
    'courettes',
    'coureur',
    'coureurs',
    'coureuse',
    'coureuses',
    'courez',
    'courge',
    'courges',
    'courgette',
    'courgettes',
    'couriez',
    'courions',
    'courir',
    'courlieu',
    'courlieus',
    'courlis',
    'couronna',
    'couronnai',
    'couronnaient',
    'couronnais',
    'couronnait',
    'couronnant',
    'couronnas',
    'couronnasse',
    'couronnasses',
    'couronne',
    'couronnement',
    'couronnent',
    'couronner',
    'couronnera',
    'couronnerai',
    'couronnerais',
    'couronnerait',
    'couronneras',
    'couronnerez',
    'couronneriez',
    'couronnerons',
    'couronneront',
    'couronnes',
    'couronnez',
    'couronniez',
    'couronnions',
    'couronnons',
    'couronnâmes',
    'couronnât',
    'couronnâtes',
    'couronnèrent',
    'couronné',
    'couronnée',
    'couronnées',
    'couronnés',
    'courons',
    'courra',
    'courrai',
    'courraient',
    'courrais',
    'courrait',
    'courras',
    'courre',
    'courrez',
    'courrier',
    'courriers',
    'courriez',
    'courrions',
    'courroie',
    'courroies',
    'courrons',
    'courront',
    'courrouce',
    'courroucent',
    'courroucer',
    'courroucera',
    'courroucerai',
    'courrouceras',
    'courroucerez',
    'courrouces',
    'courroucez',
    'courrouciez',
    'courroucions',
    'courroucé',
    'courroucée',
    'courroucées',
    'courroucés',
    'courroux',
    'courrouça',
    'courrouçai',
    'courrouçais',
    'courrouçait',
    'courrouçant',
    'courrouças',
    'courrouçasse',
    'courrouçons',
    'courrouçâmes',
    'courrouçât',
    'courrouçâtes',
    'cours',
    'coursa',
    'coursai',
    'coursaient',
    'coursais',
    'coursait',
    'coursant',
    'coursas',
    'coursasse',
    'coursassent',
    'coursasses',
    'coursassiez',
    'coursassions',
    'course',
    'coursent',
    'courser',
    'coursera',
    'courserai',
    'courseraient',
    'courserais',
    'courserait',
    'courseras',
    'courserez',
    'courseriez',
    'courserions',
    'courserons',
    'courseront',
    'courses',
    'coursez',
    'coursier',
    'coursiers',
    'coursiez',
    'coursions',
    'coursive',
    'coursives',
    'coursière',
    'coursières',
    'courson',
    'coursons',
    'coursâmes',
    'coursât',
    'coursâtes',
    'coursèrent',
    'coursé',
    'coursée',
    'coursées',
    'coursés',
    'court',
    'courtage',
    'courtages',
    'courtaud',
    'courtauda',
    'courtaudai',
    'courtaudais',
    'courtaudait',
    'courtaudant',
    'courtaudas',
    'courtaudasse',
    'courtaude',
    'courtaudent',
    'courtauder',
    'courtaudera',
    'courtauderai',
    'courtauderas',
    'courtauderez',
    'courtaudes',
    'courtaudez',
    'courtaudiez',
    'courtaudions',
    'courtaudons',
    'courtauds',
    'courtaudâmes',
    'courtaudât',
    'courtaudâtes',
    'courtaudé',
    'courtaudée',
    'courtaudées',
    'courtaudés',
    'courte',
    'courtepointe',
    'courtes',
    'courtier',
    'courtiers',
    'courtilière',
    'courtilières',
    'courtine',
    'courtines',
    'courtisa',
    'courtisai',
    'courtisaient',
    'courtisais',
    'courtisait',
    'courtisan',
    'courtisane',
    'courtisanes',
    'courtisans',
    'courtisant',
    'courtisas',
    'courtisasse',
    'courtisasses',
    'courtise',
    'courtisent',
    'courtiser',
    'courtisera',
    'courtiserai',
    'courtiserais',
    'courtiserait',
    'courtiseras',
    'courtiserez',
    'courtiseriez',
    'courtiserons',
    'courtiseront',
    'courtises',
    'courtisez',
    'courtisiez',
    'courtisions',
    'courtisons',
    'courtisâmes',
    'courtisât',
    'courtisâtes',
    'courtisèrent',
    'courtisé',
    'courtisée',
    'courtisées',
    'courtisés',
    'courtière',
    'courtières',
    'courtois',
    'courtoise',
    'courtoises',
    'courtoisie',
    'courtoisies',
    'courts',
    'couru',
    'courue',
    'courues',
    'coururent',
    'courus',
    'courusse',
    'courussent',
    'courusses',
    'courussiez',
    'courussions',
    'courut',
    'courûmes',
    'courût',
    'courûtes',
    'cous',
    'cousaient',
    'cousais',
    'cousait',
    'cousant',
    'couscous',
    'couse',
    'cousent',
    'couses',
    'couseur',
    'couseurs',
    'couseuse',
    'couseuses',
    'cousez',
    'cousiez',
    'cousin',
    'cousina',
    'cousinai',
    'cousinaient',
    'cousinais',
    'cousinait',
    'cousinant',
    'cousinas',
    'cousinasse',
    'cousinassent',
    'cousinasses',
    'cousinassiez',
    'cousine',
    'cousinent',
    'cousiner',
    'cousinera',
    'cousinerai',
    'cousinerais',
    'cousinerait',
    'cousineras',
    'cousinerez',
    'cousineriez',
    'cousinerions',
    'cousinerons',
    'cousineront',
    'cousines',
    'cousinez',
    'cousiniez',
    'cousinions',
    'cousinons',
    'cousins',
    'cousinâmes',
    'cousinât',
    'cousinâtes',
    'cousinèrent',
    'cousiné',
    'cousinée',
    'cousinées',
    'cousinés',
    'cousions',
    'cousirent',
    'cousis',
    'cousisse',
    'cousissent',
    'cousisses',
    'cousissiez',
    'cousissions',
    'cousit',
    'cousons',
    'coussin',
    'coussinet',
    'coussinets',
    'coussins',
    'cousu',
    'cousue',
    'cousues',
    'cousus',
    'cousîmes',
    'cousît',
    'cousîtes',
    'couteau',
    'couteaux',
    'coutelas',
    'coutelier',
    'couteliers',
    'coutelière',
    'coutelières',
    'coutellerie',
    'coutelleries',
    'coutil',
    'coutils',
    'coutre',
    'coutres',
    'coutume',
    'coutumes',
    'coutumier',
    'coutumiers',
    'coutumière',
    'coutumières',
    'coutura',
    'couturai',
    'couturaient',
    'couturais',
    'couturait',
    'couturant',
    'couturas',
    'couturasse',
    'couturassent',
    'couturasses',
    'couturassiez',
    'couture',
    'couturent',
    'couturer',
    'couturera',
    'couturerai',
    'couturerais',
    'couturerait',
    'coutureras',
    'couturerez',
    'coutureriez',
    'couturerions',
    'couturerons',
    'coutureront',
    'coutures',
    'couturez',
    'couturier',
    'couturiers',
    'couturiez',
    'couturions',
    'couturière',
    'couturières',
    'couturons',
    'couturâmes',
    'couturât',
    'couturâtes',
    'couturèrent',
    'couturé',
    'couturée',
    'couturées',
    'couturés',
    'couva',
    'couvai',
    'couvaient',
    'couvain',
    'couvains',
    'couvais',
    'couvaison',
    'couvaisons',
    'couvait',
    'couvant',
    'couvas',
    'couvasse',
    'couvassent',
    'couvasses',
    'couvassiez',
    'couvassions',
    'couve',
    'couvent',
    'couvents',
    'couver',
    'couvera',
    'couverai',
    'couveraient',
    'couverais',
    'couverait',
    'couveras',
    'couvercle',
    'couvercles',
    'couverez',
    'couveriez',
    'couverions',
    'couverons',
    'couveront',
    'couvert',
    'couverte',
    'couvertes',
    'couverts',
    'couverture',
    'couvertures',
    'couves',
    'couveuse',
    'couveuses',
    'couvez',
    'couviez',
    'couvions',
    'couvons',
    'couvraient',
    'couvrais',
    'couvrait',
    'couvrant',
    'couvrante',
    'couvrantes',
    'couvrants',
    'couvre',
    'couvrent',
    'couvres',
    'couvreur',
    'couvreurs',
    'couvreuse',
    'couvreuses',
    'couvrez',
    'couvriez',
    'couvrions',
    'couvrir',
    'couvrira',
    'couvrirai',
    'couvriraient',
    'couvrirais',
    'couvrirait',
    'couvriras',
    'couvrirent',
    'couvrirez',
    'couvririez',
    'couvririons',
    'couvrirons',
    'couvriront',
    'couvris',
    'couvrisse',
    'couvrissent',
    'couvrisses',
    'couvrissiez',
    'couvrissions',
    'couvrit',
    'couvrons',
    'couvru',
    'couvrue',
    'couvrues',
    'couvrus',
    'couvrîmes',
    'couvrît',
    'couvrîtes',
    'couvâmes',
    'couvât',
    'couvâtes',
    'couvèrent',
    'couvé',
    'couvée',
    'couvées',
    'couvés',
    'covariance',
    'covariances',
    'covendeur',
    'covendeurs',
    'covendeuse',
    'covendeuses',
    'coxal',
    'coxale',
    'coxales',
    'coxalgie',
    'coxalgies',
    'coxalgique',
    'coxalgiques',
    'coxarthrose',
    'coxarthroses',
    'coxaux',
    'coyau',
    'coyaus',
    'coyote',
    'coyotes',
    'cozanet',
    'coéditeur',
    'coéditeurs',
    'coédition',
    'coéditions',
    'coéditrice',
    'coéditrices',
    'coéquipier',
    'coéquipiers',
    'coéquipière',
    'coéquipières',
    'coïncida',
    'coïncidai',
    'coïncidaient',
    'coïncidais',
    'coïncidait',
    'coïncidant',
    'coïncidas',
    'coïncidasse',
    'coïncidasses',
    'coïncide',
    'coïncidence',
    'coïncidences',
    'coïncident',
    'coïncidente',
    'coïncidentes',
    'coïncidents',
    'coïncider',
    'coïncidera',
    'coïnciderai',
    'coïnciderais',
    'coïnciderait',
    'coïncideras',
    'coïnciderez',
    'coïncideriez',
    'coïnciderons',
    'coïncideront',
    'coïncides',
    'coïncidez',
    'coïncidiez',
    'coïncidions',
    'coïncidons',
    'coïncidâmes',
    'coïncidât',
    'coïncidâtes',
    'coïncidèrent',
    'coïncidé',
    'coïnculpé',
    'coïnculpée',
    'coïnculpées',
    'coïnculpés',
    'coït',
    'coïta',
    'coïtai',
    'coïtaient',
    'coïtais',
    'coïtait',
    'coïtant',
    'coïtas',
    'coïtasse',
    'coïtassent',
    'coïtasses',
    'coïtassiez',
    'coïtassions',
    'coïte',
    'coïtent',
    'coïter',
    'coïtera',
    'coïterai',
    'coïteraient',
    'coïterais',
    'coïterait',
    'coïteras',
    'coïterez',
    'coïteriez',
    'coïterions',
    'coïterons',
    'coïteront',
    'coïtes',
    'coïtez',
    'coïtiez',
    'coïtions',
    'coïtons',
    'coïts',
    'coïtâmes',
    'coïtât',
    'coïtâtes',
    'coïtèrent',
    'coïté',
    'coût',
    'coûta',
    'coûtai',
    'coûtaient',
    'coûtais',
    'coûtait',
    'coûtant',
    'coûtante',
    'coûtantes',
    'coûtants',
    'coûtas',
    'coûtasse',
    'coûtassent',
    'coûtasses',
    'coûtassiez',
    'coûtassions',
    'coûte',
    'coûtent',
    'coûter',
    'coûtera',
    'coûterai',
    'coûteraient',
    'coûterais',
    'coûterait',
    'coûteras',
    'coûterez',
    'coûteriez',
    'coûterions',
    'coûterons',
    'coûteront',
    'coûtes',
    'coûteuse',
    'coûteusement',
    'coûteuses',
    'coûteux',
    'coûtez',
    'coûtiez',
    'coûtions',
    'coûtons',
    'coûts',
    'coûtâmes',
    'coûtât',
    'coûtâtes',
    'coûtèrent',
    'coûté',
    'coûtée',
    'coûtées',
    'coûtés',
    'crabe',
    'crabes',
    'crabier',
    'crabiers',
    'crabot',
    'crabotage',
    'crabotages',
    'craboter',
    'crabots',
    'crac',
    'cracha',
    'crachai',
    'crachaient',
    'crachais',
    'crachait',
    'crachant',
    'crachas',
    'crachasse',
    'crachassent',
    'crachasses',
    'crachassiez',
    'crachassions',
    'crachat',
    'crachats',
    'crache',
    'crachement',
    'crachements',
    'crachent',
    'cracher',
    'crachera',
    'cracherai',
    'cracheraient',
    'cracherais',
    'cracherait',
    'cracheras',
    'cracherez',
    'cracheriez',
    'cracherions',
    'cracherons',
    'cracheront',
    'craches',
    'cracheur',
    'cracheurs',
    'cracheuse',
    'cracheuses',
    'crachez',
    'crachiez',
    'crachin',
    'crachina',
    'crachinait',
    'crachine',
    'crachiner',
    'crachinera',
    'crachinerait',
    'crachins',
    'crachinât',
    'crachiné',
    'crachions',
    'crachoir',
    'crachoirs',
    'crachons',
    'crachota',
    'crachotai',
    'crachotaient',
    'crachotais',
    'crachotait',
    'crachotant',
    'crachotas',
    'crachotasse',
    'crachotasses',
    'crachote',
    'crachotement',
    'crachotent',
    'crachoter',
    'crachotera',
    'crachoterai',
    'crachoterais',
    'crachoterait',
    'crachoteras',
    'crachoterez',
    'crachoteriez',
    'crachoterons',
    'crachoteront',
    'crachotes',
    'crachotez',
    'crachotiez',
    'crachotions',
    'crachotons',
    'crachotâmes',
    'crachotât',
    'crachotâtes',
    'crachotèrent',
    'crachoté',
    'crachouilla',
    'crachouillai',
    'crachouillas',
    'crachouille',
    'crachouiller',
    'crachouilles',
    'crachouillez',
    'crachouillât',
    'crachouillé',
    'crachâmes',
    'crachât',
    'crachâtes',
    'crachèrent',
    'craché',
    'crachée',
    'crachées',
    'crachés',
    'crack',
    'cracker',
    'crackers',
    'cracking',
    'cracks',
    'cracra',
    'crado',
    'craie',
    'craies',
    'craignaient',
    'craignais',
    'craignait',
    'craignant',
    'craigne',
    'craignent',
    'craignes',
    'craignez',
    'craigniez',
    'craignions',
    'craignirent',
    'craignis',
    'craignisse',
    'craignissent',
    'craignisses',
    'craignissiez',
    'craignit',
    'craignons',
    'craignîmes',
    'craignît',
    'craignîtes',
    'crailla',
    'craillai',
    'craillaient',
    'craillais',
    'craillait',
    'craillant',
    'craillas',
    'craillasse',
    'craillassent',
    'craillasses',
    'craillassiez',
    'craille',
    'craillent',
    'crailler',
    'craillera',
    'craillerai',
    'craillerais',
    'craillerait',
    'crailleras',
    'craillerez',
    'crailleriez',
    'craillerions',
    'craillerons',
    'crailleront',
    'crailles',
    'craillez',
    'crailliez',
    'craillions',
    'craillons',
    'craillâmes',
    'craillât',
    'craillâtes',
    'craillèrent',
    'craillé',
    'craindra',
    'craindrai',
    'craindraient',
    'craindrais',
    'craindrait',
    'craindras',
    'craindre',
    'craindrez',
    'craindriez',
    'craindrions',
    'craindrons',
    'craindront',
    'crains',
    'craint',
    'crainte',
    'craintes',
    'craintif',
    'craintifs',
    'craintive',
    'craintives',
    'craints',
   