\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{rugcourse}

% screen (default): hyperref active
% if tight, then reduced margins, otherwise book size
% book: book size plus 5mm gutter, hyperref draft
% a4/letter: centered on printer page, hyperref draft

\newif\if@screen \@screentrue
\newif\if@tight \@tightfalse
\newif\if@afour \@afourfalse
\newif\if@letter \@letterfalse
\newif\if@book \@bookfalse
\DeclareOption{tight}{\@screentrue \@tighttrue}
\DeclareOption{screen}{\@screentrue \@tightfalse}
\DeclareOption{a4}{\@screenfalse \@afourtrue}
\DeclareOption{letter}{\@screenfalse \@lettertrue}
\DeclareOption{book}{\@screenfalse \@booktrue}

\ProcessOptions\relax

\RequirePackage[dutch,english]{babel}

\LoadClass[twoside]{report}

\RequirePackage{dcolumn}
\newcolumntype{d}[1]{D{.}{.}{#1}}

\RequirePackage{graphicx}
\RequirePackage{color}
%\RequirePackage{framed}
\RequirePackage{amsmath}
\RequirePackage{bm}

\RequirePackage{verbatim}

\RequirePackage{url}
\global\let\path\url

%%% fonts %%%%%%%%%%%%%%

\RequirePackage[utf8]{inputenc}
\RequirePackage{csquotes} % recommended by babel

\RequirePackage[TS1,T1]{fontenc}
\RequirePackage[sb]{libertineRoman}
\RequirePackage[libertine]{newtxmath}
\RequirePackage[sf,scaled=.94]{quattrocento}
\RequirePackage[scaled=.93]{inconsolata} % inconsolata (zi4) for monospace

\newcommand\titlefont{\rmfamily\bfseries}
\newcommand\sectionfont{\sffamily\bfseries}

\RequirePackage[protrusion=true,expansion=false]{microtype}
\UseMicrotypeSet[protrusion]{basictext}

%%% color %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\definecolor{spotcolor}{rgb}{0,0.1,0.4}
\definecolor{shade}{rgb}{0.2,0.5,0.7}

%%% layout and typography %%%%%%%%%%%%%%

% vertical page layout
\textheight 575pt
\headsep 18pt
\headheight 12pt
\footskip 40pt

% horizontal page layout
\textwidth 370bp

\if@tight
  \pdfpagewidth=14.0cm
  \pdfpageheight=23.5cm
\else \if@screen
  \pdfpagewidth=16.5cm
  \pdfpageheight=24cm
\else \if@book
  \pdfpagewidth=17cm
  \pdfpageheight=24cm
\else \if@afour
  \pdfpagewidth=595bp
  \pdfpageheight=842bp
\else
  \pdfpagewidth=612bp
  \pdfpageheight=792bp
\fi \fi \fi \fi
\paperwidth=\pdfpagewidth
\paperheight=\pdfpageheight

\parindent=1em
% parindent is now frozen and will not adapt to font size

% make \parindent available in e.g. a minipage environment
\newdimen\saveparindent
\saveparindent=\parindent

% raggedbottom:
\def\@textbottom{\vskip \z@ \@plus.1fil}
\let\@texttop\relax

\AtBeginDocument{%
  % vertical centering of page content
  \topmargin=\pdfpageheight
  % subtract stuff
  \advance\topmargin-\headheight
  \advance\topmargin-\headsep
  \advance\topmargin-\textheight
  \advance\topmargin-\footskip
  % divide remainder by 2
  \divide\topmargin by 2
  % subtract 1in offset
  \advance\topmargin -1in
  % horizontal
  \oddsidemargin=\paperwidth
  \advance\oddsidemargin-\textwidth
  \divide\oddsidemargin by 2
  \advance \oddsidemargin -1in
  \evensidemargin=\oddsidemargin
  \if@book
    \advance\oddsidemargin2.5mm
    \advance\evensidemargin-2.5mm
  \fi
}

%%% page headers- and footers %%%%%%%%%%%%%%%%%%%%%

\AtBeginDocument{\global\let\@datesave\@date}
% left header: title; right header: section
\def\booktitle#1{\gdef\@booktitle{#1}}
\def\bookauthor#1{\gdef\@bookauthor{#1}}
\def\ps@headings{%
    \def\@oddfoot{%
      \sffamily
      {\footnotesize \MakeUppercase{\@datesave}}\hfill\thepage}
    \def\@evenfoot{%
      \sffamily
      \thepage\hfill{\footnotesize\MakeUppercase{\@booktitle}}}
    \def\@evenhead{%
      \rlap{\rule[-4pt]{\textwidth}{0.3bp}}%
      \hfill\sffamily
      \footnotesize\leftmark}%
    \def\@oddhead{%
      \rlap{\rule[-4pt]{\textwidth}{0.3bp}}%
      \sffamily
      \footnotesize {\itshape\rightmark }\hfill\null}%
    \let\@mkboth\markboth
  \def\chaptermark##1{\markboth {\MakeUppercase{\thechapter\quad ##1}}%
      {\MakeUppercase{\thechapter\quad ##1}}}%
  \def\sectionmark##1{%
    \markright {\thesection\quad ##1}}}
\pagestyle{headings}

\def\ps@plain{%
    \def\@oddfoot{%
      \sffamily
      {\footnotesize \MakeUppercase{\@datesave}}\hfill\thepage}
    \def\@evenfoot{%
      \sffamily
      \thepage\hfill\footnotesize\MakeUppercase{\@booktitle}}
    \let\@oddhead\@empty\let\@evenhead\@empty}

%%% title %%%%%%%%%%%%%%

\renewcommand\maketitle{%
  \begin{titlepage}%
    \begin{center}
      \vspace*{100bp}
        \titlefont
        {\fontsize{30bp}{30bp}\selectfont \@title \par}%
      \vspace{50bp}
        {\fontsize{24bp}{24bp}\mdseries\itshape \@author \par}
    \end{center}
    \vfill\null
  \end{titlepage}%
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}

%%% other tweaks to report style %%%%%%%%%%%%%%%%%

\setcounter{secnumdepth}{2}
\setcounter{tocdepth}{1}
\let\tocsave\tableofcontents
\def\tableofcontents{{%
  \parskip=0pt
  \tocsave
  % restore leftmark
  \markboth{\uppercase{\contentsname}}{\uppercase{\contentsname}}
}}
% a bit less headroom for chapter entries in tableofcontents
\renewcommand*\l@chapter[2]{%
  %\ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 0.4em \@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  %\fi
}

\newdimen\chapfontsize
\chapfontsize=30pt

% decorative chapter number
\def\numbox#1{
   \textcolor{shade}{
     \rule[-.12\chapfontsize]{1.0\chapfontsize}{1.0\chapfontsize}}%
   \hspace{-1.0\chapfontsize}%
     \makebox[1.0\chapfontsize]%
      {\color{white}\fontfamily{fvs}\bfseries\selectfont #1}}

% dummy for chapter* vertically matching \numbox
\def\numphantom{\rule[-.12\chapfontsize]{0pt}{1.0\chapfontsize}}

\def\@makechapterhead#1{%
  {\parindent \z@
   \titlefont \fontsize{\chapfontsize}{\chapfontsize}\selectfont
    \numbox{\thechapter}\hfill #1\par
  }
  \vskip 40\p@
}
\def\@makeschapterhead#1{%
  {\parindent \z@
   \titlefont \fontsize{\chapfontsize}{\chapfontsize}\selectfont
   \numphantom \hfill #1\par
  }
  \vskip 40\p@
}

% sectioning

% formatting of section number
\def\@seccntformat#1{\csname the#1\endcsname \hskip6pt}
% sectioning commands
\def\section{\@startsection{section}{1}{\z@}%
  {-10pt}{6pt}%
  {\sectionfont \large \raggedright}}
\def\subsection{\@startsection{subsection}{2}{\z@}%
  {-7pt}{1sp}%
  {\sectionfont \raggedright}}
% run-in subsubsection headers
\def\@runin#1{{\normalsize\sffamily\bfseries #1.}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}%
  {6pt}{-0.5em}{\@runin}}

% footnotes

\renewcommand\@makefntext[1]{%
  \leavevmode\rlap{\arabic{footnote}.}\hspace{\saveparindent}#1}

% lists

% less white in and around lists
\leftmargini1em
\leftmarginii1em
\leftmarginiii1em
\leftmarginiv1em
\labelsep0pt
\labelwidth\leftmargini
\def\@mkklab#1{#1\hfil\null}
\def\@listi{\leftmargin\leftmargini
  \parsep 0\p@
  \topsep 3\p@
  \itemsep3\p@
}
\let\@listI\@listi

% left-align label within its space.
% this can only be done by redefining enumerate/itemize
\def\enumerate{%
  \ifnum \@enumdepth >\thr@@\@toodeep\else
    \advance\@enumdepth\@ne
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
      \expandafter
      \list
        \csname label\@enumctr\endcsname
        {\usecounter\@enumctr\def\makelabel##1{##1\hss}}%
  \fi}
\let\endenumerate =\endlist
\def\itemize{%
  \ifnum \@itemdepth >\thr@@\@toodeep\else
    \advance\@itemdepth\@ne
    \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
    \expandafter
    \list
      \csname\@itemitem\endcsname
      {\def\makelabel##1{##1\hss}}%
  \fi}
\let\enditemize =\endlist

% replace some item labels
\def\labelitemii{\textopenbullet}
\def\labelitemiii{--}
\def\labelitemiv{\textperiodcentered}

\renewcommand*\descriptionlabel[1]{%
 \normalfont\bfseries #1\hspace*{.7em}}

%%% float tweaks %%%%%%%%%%%%%%%%%%%%%

\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\sffamily\small\itshape #1. #2}%
  \ifdim \wd\@tempboxa >\hsize
    {\sffamily\small\itshape #1. #2\par}%
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

\setcounter{topnumber}{2}
\setcounter{bottomnumber}{2}
\setcounter{totalnumber}{3}
\setcounter{dbltopnumber}{2}
\renewcommand{\topfraction}{.9}
\renewcommand{\textfraction}{.1}
\renewcommand{\bottomfraction}{.75}
\renewcommand{\floatpagefraction}{.9}
\renewcommand{\dblfloatpagefraction}{.9}
\renewcommand{\dbltopfraction}{.9}

%%% verbatims %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% We like a smaller verbatim, but not in running text.
% \every@verbatim does not apply to the inline verb environment.

\def\sm@ller{%
  \@tempdima=\f@size pt
  \advance\@tempdima-0.1\@tempdima
  \fontsize{\@tempdima}{\f@baselineskip}\selectfont}
\addto@hook\every@verbatim{\sm@ller}%

% less whitespace around verbatims
\def\less@white{\topsep=3pt}
\addto@hook\every@verbatim{\less@white}

% indented verbatim matching surrounding text
\newdimen\savedindent
\def\saveindent{\savedindent=\parindent}
\addto@hook\every@verbatim{\saveindent}

\def\coloredverb{\color{spotcolor}}
\addto@hook\every@verbatim{\coloredverb}

\def\verbatim@processline{%
  \leavevmode
  \null\hskip\savedindent
  \the\verbatim@line\par}

%\newenvironment{sverbatim}%
%  {\bgroup\small\verbatim}%
%  {\endverbatim\egroup}

%\global\let\verbatim@startsave\verbatim@startline
%\newenvironment{iverbatim}%
%  {\def\verbatim@startline{%
%      \verbatim@startsave
%      \leavevmode\llap{\sffamily #1\hspace{12pt}\null}%
%      \global\let\verbatim@startline\verbatim@startsave}%
%   \verbatim}%
%  {\endverbatim}

%%% biblatex %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5

\usepackage[style=authoryear,natbib=true,backend=biber]{biblatex}

\defbibheading{bibliography}{%
  \chapter*{\bibname}%
  \markboth{\bibname}{\bibname}
  \addcontentsline{toc}{chapter}{\bibname}}

\DeclareCiteCommand{\citetitle}
  {\boolfalse{citetracker}%
   \boolfalse{pagetracker}%
   \usebibmacro{prenote}}
  {\ifciteindex
     {\indexfield{indextitle}}
     {}%
   \printtext[bibhyperref]{\printfield[citetitle]{labeltitle}}}
  {\multicitedelim}
  {\usebibmacro{postnote}}

%%% hyperref %%%%%%%%%%%%%%%%%%%%%%%%%

\RequirePackage{hyperref}
\if@screen
  \hypersetup{%
    raiselinks=false,%
    colorlinks=true,%
    citecolor=black,%
    linkcolor=spotcolor,%
    filecolor=black,% local files
    urlcolor=black,%
    bookmarksnumbered=true,%
    bookmarksopen=true,%
    bookmarksopenlevel=1}
\else
  \hypersetup{draft=true}
\fi

%%% utility macros %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\extrawhite{\vspace{6pt}}

\newcommand\cmd[1]{\texttt{\textbackslash #1}}
\newcommand\benv[1]{\texttt{\cmd{begin}\{#1\}}}
\newcommand\eenv[1]{\texttt{\cmd{end}\{#1\}}}

\global\let\menupath\textit
\global\let\package\texttt

%% discretionary linebreak
\newcommand{\dbr}{\discretionary{}{}{}}

%% shorter command for backslash
\newcommand{\bsl}{\textbackslash}
\newcommand{\command}[1]{\texttt{\bsl #1}}

%% formatting some tabulars %%%%%%%%%%%%%%%
\newcommand\topline{\rule{\linewidth}{.3pt}\par\vspace{6pt}}
\newcommand\midline{\par\vspace{-6pt}\rule{\linewidth}{.3pt}\par\vspace{6pt}}
\newcommand\botline{\par\vspace{-6pt}\rule{\linewidth}{.3pt}}

% add some vertical space and suppress indentation after e.g. examples
\newcommand\nextblock{\par\vspace{3pt}\noindent}

\input logos

%%% typesetting examples %%%%%%%%%%%%%%%%%%%

% some horizontal measurements for examples
\newdimen\exacolwidth
\exacolwidth=.5\textwidth
\advance\exacolwidth-1pc

%\newenvironment{myleftbar}{%
%  \def\FrameCommand{\null\hspace{-12pt}%
%  % determine length of hspace experimentally;
%  % compensate for a space which seems to be inserted somewhere
%  \textcolor[gray]{0.8}{\vrule width 4pt} \hspace{4pt}}%
%  \MakeFramed {}}%
% {\endMakeFramed}

% prepare for typesetting example source at the left
\newcommand\exa{%
  %%\begin{myleftbar}
  \par
  \vspace{4pt}
  %\vspace{2pt}
  %\noindent\textcolor[gray]{0.8}{\rule{\linewidth}{.3pt}}
  %\vspace{-6pt}
  \par
  \bgroup\raggedright
  \begin{minipage}{\exacolwidth}
  \raggedright\small}

% prepare for including typeset example
\newcommand\exb{%
  \end{minipage}%
  \kern 2pc\begin{minipage}{\exacolwidth}
  \raggedright}

% finish example
\newcommand\exc{%
  \end{minipage}%
  \par
  \egroup
  \vspace{4pt}
  %\noindent\textcolor[gray]{0.8}{\rule{\linewidth}{.3pt}}
  %\vspace{-8pt}
  %%\end{myleftbar}
  \par
}

% uniform scaling of screenshots
\newcommand{\scalegrap}[2][.5]{\scalebox{#1}{\includegraphics{#2}}}

%%% framed typeset examples
\newdimen\figwd

\newcommand\includedetail[2][1]{%
  \figwd=#1\linewidth
  \advance\figwd-2\fboxrule
  \advance\figwd-2\fboxsep
  \vspace{6pt}\noindent\fbox{\includegraphics[width=\figwd]{#2}}\vspace{6pt}
}

\endinput
