require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UFS_UFS_DIR_H_)) {
    eval 'sub _UFS_UFS_DIR_H_ () {1;}' unless defined(&_UFS_UFS_DIR_H_);
    eval 'sub doff_t () { &int32_t;}' unless defined(&doff_t);
    eval 'sub UFS_MAXDIRSIZE () {(0x7fffffff);}' unless defined(&UFS_MAXDIRSIZE);
    undef(&UFS_DIRBLKSIZ) if defined(&UFS_DIRBLKSIZ);
    eval 'sub UFS_DIRBLKSIZ () { &DEV_BSIZE;}' unless defined(&UFS_DIRBLKSIZ);
    eval 'sub FFS_MAXNAMLEN () {255;}' unless defined(&FFS_MAXNAMLEN);
    eval 'sub APPLEUFS_DIRBLKSIZ () {1024;}' unless defined(&APPLEUFS_DIRBLKSIZ);
    eval 'sub d_ino () { &d_fileno;}' unless defined(&d_ino);
    eval 'sub DT_UNKNOWN () {0;}' unless defined(&DT_UNKNOWN);
    eval 'sub DT_FIFO () {1;}' unless defined(&DT_FIFO);
    eval 'sub DT_CHR () {2;}' unless defined(&DT_CHR);
    eval 'sub DT_DIR () {4;}' unless defined(&DT_DIR);
    eval 'sub DT_BLK () {6;}' unless defined(&DT_BLK);
    eval 'sub DT_REG () {8;}' unless defined(&DT_REG);
    eval 'sub DT_LNK () {10;}' unless defined(&DT_LNK);
    eval 'sub DT_SOCK () {12;}' unless defined(&DT_SOCK);
    eval 'sub DT_WHT () {14;}' unless defined(&DT_WHT);
    eval 'sub IFTODT {
        my($mode) = @_;
	    eval q(((($mode) & 0170000) >> 12));
    }' unless defined(&IFTODT);
    eval 'sub DTTOIF {
        my($dirtype) = @_;
	    eval q((($dirtype) << 12));
    }' unless defined(&DTTOIF);
    eval 'sub DIR_ROUNDUP () {4;}' unless defined(&DIR_ROUNDUP);
    eval 'sub UFS_NAMEROUNDUP {
        my($namlen) = @_;
	    eval q(((($namlen) +  &DIR_ROUNDUP) & ~( &DIR_ROUNDUP - 1)));
    }' unless defined(&UFS_NAMEROUNDUP);
    eval 'sub UFS_NAMEPAD {
        my($namlen) = @_;
	    eval q(( &DIR_ROUNDUP - (($namlen) & ( &DIR_ROUNDUP - 1))));
    }' unless defined(&UFS_NAMEPAD);
    eval 'sub UFS_DIRECTSIZ {
        my($namlen) = @_;
	    eval q((($sizeof{\'struct direct\'} - ( &FFS_MAXNAMLEN+1)) +  &UFS_NAMEROUNDUP($namlen)));
    }' unless defined(&UFS_DIRECTSIZ);
    if(((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef))) {
	eval 'sub UFS_DIRSIZ {
	    my($oldfmt, $dp, $needswap) = @_;
    	    eval q(((($oldfmt)  && !($needswap)) ?  &UFS_DIRECTSIZ(($dp)-> &d_type) :  &UFS_DIRECTSIZ(($dp)-> &d_namlen)));
	}' unless defined(&UFS_DIRSIZ);
    } else {
	eval 'sub UFS_DIRSIZ {
	    my($oldfmt, $dp, $needswap) = @_;
    	    eval q(((($oldfmt)  && ($needswap)) ?  &UFS_DIRECTSIZ(($dp)-> &d_type) :  &UFS_DIRECTSIZ(($dp)-> &d_namlen)));
	}' unless defined(&UFS_DIRSIZ);
    }
    eval 'sub UFS_OLDDIRFMT () {1;}' unless defined(&UFS_OLDDIRFMT);
    eval 'sub UFS_NEWDIRFMT () {0;}' unless defined(&UFS_NEWDIRFMT);
}
1;
