/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.encode;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.broad.igv.util.encode.EncodeFileRecord;

public class EncodeTableModel
extends AbstractTableModel {
    private String[] columnHeadings;
    private List<EncodeFileRecord> records;
    private final TableRowSorter<EncodeTableModel> sorter;

    public EncodeTableModel(String[] headings, List<EncodeFileRecord> records) {
        this.records = records;
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add("");
        for (String h : headings) {
            String heading = h.trim();
            if (heading.length() <= 0 || "path".equals(heading)) continue;
            tmp.add(heading);
        }
        this.columnHeadings = tmp.toArray(new String[tmp.size()]);
        this.sorter = new TableRowSorter<EncodeTableModel>(this);
        this.sorter.setStringConverter(new TableStringConverter(){

            @Override
            public String toString(TableModel model, int row, int column) {
                Object value = model.getValueAt(row, column);
                return value == null ? "" : value.toString();
            }
        });
    }

    public TableRowSorter<EncodeTableModel> getSorter() {
        return this.sorter;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Boolean.class : String.class;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnHeadings[column];
    }

    @Override
    public int getRowCount() {
        return this.records.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnHeadings.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.records.size() || columnIndex >= this.columnHeadings.length) {
            return null;
        }
        EncodeFileRecord record = this.records.get(rowIndex);
        if (columnIndex == 0) {
            return record.isSelected();
        }
        String att = this.columnHeadings[columnIndex];
        return record.getAttributeValue(att);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            this.records.get(row).setSelected((Boolean)value);
        }
        this.fireTableCellUpdated(row, col);
    }

    public List<EncodeFileRecord> getRecords() {
        return this.records;
    }
}

