/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import htsjdk.samtools.util.Locatable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.util.Interval;
import org.broad.igv.util.IntervalTree;

public class FeatureCache<T extends Locatable> {
    int DEFAULT_BATCH_SIZE = 100;
    int batchSize;
    Map<String, IntervalTree<List<T>>> featureMap;

    public FeatureCache(List<T> features) {
        this.init(features, this.DEFAULT_BATCH_SIZE);
    }

    public FeatureCache(List<T> features, int batchSize) {
        this.init(features, batchSize);
    }

    public List<T> getFeatures(String chr, int start, int end) {
        ArrayList<Locatable> features = new ArrayList<Locatable>();
        IntervalTree<List<T>> tree = this.featureMap.get(chr);
        if (tree != null) {
            List<Interval<List<T>>> intervals = tree.findOverlapping(start, end);
            for (Interval<List<T>> interval : intervals) {
                List<T> intervalFeatures = interval.getValue();
                for (Locatable f : intervalFeatures) {
                    if (f.getEnd() < start || f.getStart() > end) continue;
                    features.add(f);
                }
            }
        }
        return features;
    }

    private void init(List<T> features, int batchSize) {
        String lastChr = null;
        ArrayList<Locatable> currentFeatureList = new ArrayList<Locatable>();
        int currentMin = Integer.MAX_VALUE;
        int currentMax = 0;
        this.featureMap = new HashMap<String, IntervalTree<List<T>>>();
        features.sort(this.getPositionComparator());
        for (Locatable f : features) {
            IntervalTree<List<ArrayList<Object>>> tree;
            String chr = f.getContig();
            int start = f.getStart();
            int end = f.getEnd();
            if (lastChr == null) {
                currentMin = start;
                currentMax = end;
                currentFeatureList.add(f);
                tree = new IntervalTree();
                this.featureMap.put(chr, tree);
                lastChr = chr;
                continue;
            }
            if (!chr.equals(lastChr)) {
                tree = this.featureMap.get(lastChr);
                tree.insert(new Interval(currentMin, currentMax, currentFeatureList));
                tree = new IntervalTree();
                this.featureMap.put(chr, tree);
                lastChr = chr;
                currentFeatureList = new ArrayList();
                currentFeatureList.add(f);
                currentMin = start;
                currentMax = end;
                continue;
            }
            if (currentFeatureList.size() > batchSize) {
                tree = this.featureMap.get(lastChr);
                tree.insert(new Interval(currentMin, currentMax, currentFeatureList));
                currentFeatureList = new ArrayList();
                currentFeatureList.add(f);
                currentMin = start;
                currentMax = end;
                continue;
            }
            currentMin = Math.min(currentMin, start);
            currentMax = Math.max(currentMax, end);
            currentFeatureList.add(f);
        }
        IntervalTree tree = this.featureMap.get(lastChr);
        tree.insert(new Interval(currentMin, currentMax, currentFeatureList));
    }

    private Comparator<T> getPositionComparator() {
        Comparator comp = new Comparator<T>(){
            private Comparator<String> nameComparator = ChromosomeNameComparator.get();

            @Override
            public int compare(T o1, T o2) {
                int nameComp = this.nameComparator.compare(o1.getContig(), o2.getContig());
                if (nameComp == 0) {
                    return o1.getStart() - o2.getStart();
                }
                return nameComp;
            }
        };
        return comp;
    }
}

