/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.util.Timer;
import java.util.TimerTask;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;

public class IndefiniteProgressMonitor
extends ProgressMonitor {
    int cycleTime;
    Timer timer;
    private static final int DEFAULT_CYCLE_TIME = 60;

    public IndefiniteProgressMonitor() {
        this(60);
    }

    private IndefiniteProgressMonitor(int cycleTime) {
        this.cycleTime = cycleTime;
        this.timer = new Timer();
        this.setReady(true);
    }

    public void start() {
        this.timer.schedule((TimerTask)new CycleTask(), 0L, 1000L);
    }

    public void stop() {
        this.timer.cancel();
        UIUtilities.invokeOnEventThread(() -> this.fireProgressChange(100));
    }

    class CycleTask
    extends TimerTask {
        boolean stop = false;
        int progress = 0;
        int progressIncrement = 0;
        int direction = 1;
        long lastTime = System.currentTimeMillis();

        CycleTask() {
        }

        @Override
        public void run() {
            UIUtilities.invokeOnEventThread(() -> IndefiniteProgressMonitor.this.fireProgressChange(this.progressIncrement));
            long t = System.currentTimeMillis();
            this.progressIncrement = (int)((long)this.direction * (t - this.lastTime) / (long)(10 * IndefiniteProgressMonitor.this.cycleTime));
            this.progress += this.progressIncrement;
            if (this.progress >= 90) {
                this.progress = 99;
                this.direction = -1;
            } else if (this.progress < 0) {
                this.progress = 1;
                this.direction = 1;
            }
            this.lastTime = t;
        }
    }
}

