/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broad.igv.track.AttributeManager;

public class AttributeSelectionDialog
extends JDialog {
    private JButton cancelButton;
    private JComboBox comboBox;
    private JLabel comboBoxLabel;
    private JButton okButton;
    private boolean isCanceled = true;
    private String[] selArray;

    public AttributeSelectionDialog(Frame parent, String action) {
        super(parent, true);
        this.setDefaultCloseOperation(2);
        this.initComponents(action);
        this.setLocationRelativeTo(parent);
    }

    public void setSelectedItem(Object selection) {
        this.comboBox.setSelectedItem(selection);
    }

    public void setSelectedIndex(int index) {
        this.comboBox.setSelectedIndex(index);
    }

    public String getSelected() {
        int selIndex = this.comboBox.getSelectedIndex();
        return this.isCanceled || selIndex == 0 ? null : this.selArray[selIndex];
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    private void initComponents(String action) {
        List<String> attributeKeys = AttributeManager.getInstance().getVisibleAttributes();
        ArrayList<String> selections = new ArrayList<String>();
        selections.add("None");
        selections.addAll(attributeKeys);
        this.selArray = selections.toArray(new String[0]);
        this.setDefaultCloseOperation(2);
        this.setTitle(action);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel attributeSelectionPanel = new JPanel();
        this.getContentPane().add(attributeSelectionPanel);
        attributeSelectionPanel.setLayout(new FlowLayout());
        this.comboBoxLabel = new JLabel(action + " Tracks By:");
        attributeSelectionPanel.add(this.comboBoxLabel);
        this.comboBox = new JComboBox();
        this.comboBox.setModel(new DefaultComboBoxModel<String>(this.selArray));
        this.comboBox.setEditable(false);
        attributeSelectionPanel.add(this.comboBox);
        JPanel buttonPanel = new JPanel();
        this.getContentPane().add(buttonPanel);
        this.okButton = new JButton();
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeSelectionDialog.this.okButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeSelectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.cancelButton);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.isCanceled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.isCanceled = false;
        this.setVisible(false);
        this.dispose();
    }
}

