/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.json.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.json.internal.dom.SdkJsonNode;

@SdkInternalApi
public final class SdkArrayNode
implements SdkJsonNode {
    private final List<SdkJsonNode> items;

    private SdkArrayNode(Builder builder) {
        this.items = Collections.unmodifiableList(new ArrayList(builder.items));
    }

    @Override
    public List<SdkJsonNode> items() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SdkArrayNode that = (SdkArrayNode)o;
        return Objects.equals(this.items, that.items);
    }

    public int hashCode() {
        return Objects.hashCode(this.items);
    }

    public String toString() {
        return this.items.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private final List<SdkJsonNode> items = new ArrayList<SdkJsonNode>();

        private Builder() {
        }

        Builder addItem(SdkJsonNode item) {
            this.items.add(item);
            return this;
        }

        SdkArrayNode build() {
            return new SdkArrayNode(this);
        }
    }
}

