/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.pool.ChannelPool;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.URI;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class ProxyTunnelInitHandler
extends ChannelDuplexHandler {
    public static final Logger log = Logger.loggerFor(ProxyTunnelInitHandler.class);
    private final ChannelPool sourcePool;
    private final URI remoteHost;
    private final Promise<Channel> initPromise;
    private final Supplier<HttpClientCodec> httpCodecSupplier;

    public ProxyTunnelInitHandler(ChannelPool sourcePool, URI remoteHost, Promise<Channel> initPromise) {
        this(sourcePool, remoteHost, initPromise, HttpClientCodec::new);
    }

    @SdkTestInternalApi
    public ProxyTunnelInitHandler(ChannelPool sourcePool, URI remoteHost, Promise<Channel> initPromise, Supplier<HttpClientCodec> httpCodecSupplier) {
        this.sourcePool = sourcePool;
        this.remoteHost = remoteHost;
        this.initPromise = initPromise;
        this.httpCodecSupplier = httpCodecSupplier;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addBefore(ctx.name(), null, (ChannelHandler)this.httpCodecSupplier.get());
        HttpRequest connectRequest = this.connectRequest();
        ctx.channel().writeAndFlush((Object)connectRequest).addListener(f -> {
            if (!f.isSuccess()) {
                this.handleConnectRequestFailure(ctx, f.cause());
            }
        });
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (ctx.pipeline().get(HttpClientCodec.class) != null) {
            ctx.pipeline().remove(HttpClientCodec.class);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        HttpResponse response;
        if (msg instanceof HttpResponse && (response = (HttpResponse)msg).status().code() == 200) {
            ctx.pipeline().remove((ChannelHandler)this);
            this.initPromise.setSuccess((Object)ctx.channel());
            return;
        }
        ctx.pipeline().remove((ChannelHandler)this);
        ctx.close();
        this.sourcePool.release(ctx.channel());
        this.initPromise.setFailure((Throwable)new IOException("Could not connect to proxy"));
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (!this.initPromise.isDone()) {
            this.handleConnectRequestFailure(ctx, null);
        } else {
            log.debug(() -> "The proxy channel (" + ctx.channel().id() + ") is inactive");
            this.closeAndRelease(ctx);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.initPromise.isDone()) {
            this.handleConnectRequestFailure(ctx, cause);
        } else {
            log.debug(() -> "An exception occurred on the proxy tunnel channel (" + ctx.channel().id() + "). The channel has been closed to prevent any ongoing issues.", cause);
            this.closeAndRelease(ctx);
        }
    }

    private void handleConnectRequestFailure(ChannelHandlerContext ctx, Throwable cause) {
        this.closeAndRelease(ctx);
        String errorMsg = "Unable to send CONNECT request to proxy";
        IOException ioException = cause == null ? new IOException(errorMsg) : new IOException(errorMsg, cause);
        this.initPromise.setFailure((Throwable)ioException);
    }

    private void closeAndRelease(ChannelHandlerContext ctx) {
        ctx.close();
        this.sourcePool.release(ctx.channel());
    }

    private HttpRequest connectRequest() {
        String uri = this.getUri();
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, uri, Unpooled.EMPTY_BUFFER, false);
        request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)uri);
        return request;
    }

    private String getUri() {
        return this.remoteHost.getHost() + ":" + this.remoteHost.getPort();
    }
}

