/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.internal.WebIdentityCredentialsUtils;
import software.amazon.awssdk.auth.credentials.internal.WebIdentityTokenCredentialProperties;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public class WebIdentityTokenFileCredentialsProvider
implements AwsCredentialsProvider {
    private final AwsCredentialsProvider credentialsProvider;
    private final RuntimeException loadException;

    private WebIdentityTokenFileCredentialsProvider(BuilderImpl builder) {
        AwsCredentialsProvider credentialsProvider = null;
        RuntimeException loadException = null;
        try {
            Path webIdentityTokenFile = builder.webIdentityTokenFile != null ? builder.webIdentityTokenFile : Paths.get(StringUtils.trim((String)SdkSystemSetting.AWS_WEB_IDENTITY_TOKEN_FILE.getStringValueOrThrow()), new String[0]);
            String roleArn = builder.roleArn != null ? builder.roleArn : StringUtils.trim((String)SdkSystemSetting.AWS_ROLE_ARN.getStringValueOrThrow());
            Optional<String> roleSessionName = builder.roleSessionName != null ? Optional.of(builder.roleSessionName) : SdkSystemSetting.AWS_ROLE_SESSION_NAME.getStringValue();
            WebIdentityTokenCredentialProperties credentialProperties = WebIdentityTokenCredentialProperties.builder().roleArn(roleArn).roleSessionName(roleSessionName.orElse(null)).webIdentityTokenFile(webIdentityTokenFile).build();
            credentialsProvider = WebIdentityCredentialsUtils.factory().create(credentialProperties);
        }
        catch (RuntimeException e) {
            loadException = e;
        }
        this.loadException = loadException;
        this.credentialsProvider = credentialsProvider;
    }

    public static WebIdentityTokenFileCredentialsProvider create() {
        return WebIdentityTokenFileCredentialsProvider.builder().build();
    }

    @Override
    public AwsCredentials resolveCredentials() {
        if (this.loadException != null) {
            throw this.loadException;
        }
        return this.credentialsProvider.resolveCredentials();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public String toString() {
        return ToString.create((String)"WebIdentityTokenCredentialsProvider");
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String roleSessionName;
        private Path webIdentityTokenFile;

        BuilderImpl() {
        }

        @Override
        public Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public void setRoleArn(String roleArn) {
            this.roleArn(roleArn);
        }

        @Override
        public Builder roleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
            return this;
        }

        public void setRoleSessionName(String roleSessionName) {
            this.roleSessionName(roleSessionName);
        }

        @Override
        public Builder webIdentityTokenFile(Path webIdentityTokenFile) {
            this.webIdentityTokenFile = webIdentityTokenFile;
            return this;
        }

        public void setWebIdentityTokenFile(Path webIdentityTokenFile) {
            this.webIdentityTokenFile(webIdentityTokenFile);
        }

        @Override
        public WebIdentityTokenFileCredentialsProvider build() {
            return new WebIdentityTokenFileCredentialsProvider(this);
        }
    }

    public static interface Builder {
        public Builder roleArn(String var1);

        public Builder roleSessionName(String var1);

        public Builder webIdentityTokenFile(Path var1);

        public WebIdentityTokenFileCredentialsProvider build();
    }
}

