/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.SortingCollection;
import java.io.InputStream;
import java.io.OutputStream;

public class IntervalCodec
implements SortingCollection.Codec<Interval> {
    private final SAMSequenceDictionary dict;
    private final BinaryCodec binaryCodec = new BinaryCodec();

    public IntervalCodec(SAMSequenceDictionary dict) {
        this.dict = dict;
    }

    public IntervalCodec clone() {
        return new IntervalCodec(this.dict);
    }

    @Override
    public void setOutputStream(OutputStream os) {
        this.binaryCodec.setOutputStream(os);
    }

    public void setOutputStream(OutputStream os, String filename) {
        this.binaryCodec.setOutputStream(os);
        this.binaryCodec.setOutputFileName(filename);
    }

    @Override
    public void setInputStream(InputStream is) {
        this.binaryCodec.setInputStream(is);
    }

    public void setInputStream(InputStream is, String filename) {
        this.binaryCodec.setInputStream(is);
        this.binaryCodec.setInputFileName(filename);
    }

    @Override
    public void encode(Interval interval) {
        String name = interval.getName();
        this.binaryCodec.writeInt(this.dict.getSequenceIndex(interval.getContig()));
        this.binaryCodec.writeInt(interval.getStart());
        this.binaryCodec.writeInt(interval.getEnd());
        this.binaryCodec.writeBoolean(interval.isNegativeStrand());
        this.binaryCodec.writeBoolean(name != null);
        if (name != null) {
            this.binaryCodec.writeString(name, false, true);
        }
    }

    @Override
    public Interval decode() {
        int sequenceIndex;
        try {
            sequenceIndex = this.binaryCodec.readInt();
        }
        catch (RuntimeEOFException e) {
            return null;
        }
        return new Interval(this.dict.getSequence(sequenceIndex).getSequenceName(), this.binaryCodec.readInt(), this.binaryCodec.readInt(), this.binaryCodec.readBoolean(), this.binaryCodec.readBoolean() ? this.binaryCodec.readNullTerminatedString() : null);
    }
}

