/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.LineReader;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;

public class BufferedLineReader
extends LineNumberReader
implements LineReader {
    public BufferedLineReader(InputStream is) {
        this(is, Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public BufferedLineReader(InputStream is, int bufferSize) {
        super(new InputStreamReader(is, Charset.forName("UTF-8")), bufferSize);
    }

    public static BufferedLineReader fromString(String s) {
        return new BufferedLineReader(new ByteArrayInputStream(s.getBytes()));
    }

    @Override
    public String readLine() {
        try {
            return super.readLine();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int peek() {
        try {
            this.mark(2);
            int ret = this.read();
            this.reset();
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

