/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.DefaultBitInputStream;
import htsjdk.samtools.cram.structure.CompressorCache;
import htsjdk.samtools.cram.structure.SliceBlocks;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.utils.ValidationUtils;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SliceBlocksReadStreams {
    private final BitInputStream coreBlockInputStream;
    private final Map<Integer, ByteArrayInputStream> externalInputStreams = new HashMap<Integer, ByteArrayInputStream>();

    public SliceBlocksReadStreams(SliceBlocks sliceBlocks, CompressorCache compressorCache) {
        ValidationUtils.nonNull(sliceBlocks.getCoreBlock(), "sliceBlocks must have been initialized");
        ValidationUtils.validateArg(sliceBlocks.getNumberOfExternalBlocks() > 0, "sliceBlocks must have been initialized");
        if (sliceBlocks.getCoreBlock() == null || sliceBlocks.getNumberOfExternalBlocks() == 0) {
            throw new CRAMException("slice blocks must be initialized before being used with a reader");
        }
        this.coreBlockInputStream = new DefaultBitInputStream(new ByteArrayInputStream(sliceBlocks.getCoreBlock().getUncompressedContent(compressorCache)));
        List<Integer> externalContentIDs = sliceBlocks.getExternalContentIDs();
        for (Integer contentID : externalContentIDs) {
            Block block = sliceBlocks.getExternalBlock(contentID);
            this.externalInputStreams.put(contentID, new ByteArrayInputStream(block.getUncompressedContent(compressorCache)));
        }
    }

    public BitInputStream getCoreBlockInputStream() {
        return this.coreBlockInputStream;
    }

    public ByteArrayInputStream getExternalInputStream(Integer contentID) {
        return this.externalInputStreams.get(contentID);
    }
}

