/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.FileInputResource;
import htsjdk.samtools.InputResource;
import htsjdk.samtools.InputStreamInputResource;
import htsjdk.samtools.PathInputResource;
import htsjdk.samtools.SRAInputResource;
import htsjdk.samtools.SeekableStreamInputResource;
import htsjdk.samtools.UrlInputResource;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.sra.SRAAccession;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Function;

public class SamInputResource {
    private final InputResource source;
    private InputResource index;

    SamInputResource(InputResource data) {
        this(data, null);
    }

    SamInputResource(InputResource source, InputResource index) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        this.source = source;
        this.index = index;
    }

    InputResource data() {
        return this.source;
    }

    InputResource indexMaybe() {
        return this.index;
    }

    public String toString() {
        return String.format("data=%s;index=%s", this.source, this.index);
    }

    public static SamInputResource of(File file) {
        return new SamInputResource(new FileInputResource(file));
    }

    public static SamInputResource of(Path path) {
        if (path.getFileSystem() == FileSystems.getDefault() && !Files.isRegularFile(path, new LinkOption[0])) {
            return SamInputResource.of(path.toFile());
        }
        return new SamInputResource(new PathInputResource(path));
    }

    public static SamInputResource of(Path path, Function<SeekableByteChannel, SeekableByteChannel> wrapper) {
        return new SamInputResource(new PathInputResource(path, wrapper));
    }

    public static SamInputResource of(InputStream inputStream) {
        return new SamInputResource(new InputStreamInputResource(inputStream));
    }

    public static SamInputResource of(URL url) {
        return new SamInputResource(new UrlInputResource(url));
    }

    public static SamInputResource of(SeekableStream seekableStream) {
        return new SamInputResource(new SeekableStreamInputResource(seekableStream));
    }

    public static SamInputResource of(SRAAccession acc) {
        return new SamInputResource(new SRAInputResource(acc));
    }

    public static SamInputResource of(String string) {
        try {
            URL url = new URL(string);
            return SamInputResource.of(url);
        }
        catch (MalformedURLException malformedURLException) {
            return SamInputResource.of(new File(string));
        }
    }

    public SamInputResource index(File file) {
        this.index = new FileInputResource(file);
        return this;
    }

    public SamInputResource index(Path path) {
        this.index = new PathInputResource(path);
        return this;
    }

    public SamInputResource index(Path path, Function<SeekableByteChannel, SeekableByteChannel> wrapper) {
        this.index = new PathInputResource(path, wrapper);
        return this;
    }

    public SamInputResource index(InputStream inputStream) {
        this.index = new InputStreamInputResource(inputStream);
        return this;
    }

    public SamInputResource index(URL url) {
        this.index = new UrlInputResource(url);
        return this;
    }

    public SamInputResource index(SeekableStream seekableStream) {
        this.index = new SeekableStreamInputResource(seekableStream);
        return this;
    }
}

