/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIteratorFilter;
import htsjdk.samtools.SAMRecord;

public class BAMStartingAtIteratorFilter
implements BAMIteratorFilter {
    private final int mReferenceIndex;
    private final int mRegionStart;

    public BAMStartingAtIteratorFilter(int referenceIndex, int start) {
        this.mReferenceIndex = referenceIndex;
        this.mRegionStart = start;
    }

    @Override
    public BAMIteratorFilter.FilteringIteratorState compareToFilter(SAMRecord record) {
        int referenceIndex = record.getReferenceIndex();
        if (referenceIndex < 0 || referenceIndex > this.mReferenceIndex) {
            return BAMIteratorFilter.FilteringIteratorState.STOP_ITERATION;
        }
        if (referenceIndex < this.mReferenceIndex) {
            return BAMIteratorFilter.FilteringIteratorState.CONTINUE_ITERATION;
        }
        int alignmentStart = record.getAlignmentStart();
        if (alignmentStart > this.mRegionStart) {
            return BAMIteratorFilter.FilteringIteratorState.STOP_ITERATION;
        }
        if (alignmentStart == this.mRegionStart) {
            return BAMIteratorFilter.FilteringIteratorState.MATCHES_FILTER;
        }
        return BAMIteratorFilter.FilteringIteratorState.CONTINUE_ITERATION;
    }
}

