/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.readers;

import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.io.FastBufferedReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.campagnelab.goby.exception.GobyRuntimeException;
import org.campagnelab.goby.readers.FastXEntry;

public class FastXReader
implements Iterator<FastXEntry>,
Iterable<FastXEntry>,
Closeable {
    private static final char FASTA_RECORD_START = '>';
    private char fastXRecordStart = (char)62;
    private BufferedReader reader;
    private FastXEntry nextEntry;
    private final FastXEntry mutableEntry;
    private final String fileType;
    private boolean useCasavaQualityFilter;

    public FastXReader(String file) throws IOException {
        this(file.endsWith(".gz") ? new GZIPInputStream((InputStream)new FastBufferedInputStream((InputStream)new FileInputStream(file))) : new FileInputStream(file));
    }

    public FastXReader(InputStream is) throws IOException {
        String nextLine;
        this.reader = new BufferedReader((Reader)new FastBufferedReader((Reader)new InputStreamReader((InputStream)new FastBufferedInputStream(is))));
        this.nextEntry = null;
        this.mutableEntry = new FastXEntry();
        if (!this.reader.markSupported()) {
            this.reader.close();
            this.reader = null;
            throw new IOException("FastaReader requires markSupported() on its input stream");
        }
        this.reader.mark(32768);
        while ((nextLine = this.reader.readLine()) != null) {
            if (nextLine.length() == 0 || nextLine.charAt(0) == ';' || nextLine.charAt(0) == '#') continue;
            this.fastXRecordStart = nextLine.charAt(0);
            break;
        }
        this.reader.reset();
        this.fileType = this.fastXRecordStart == '>' ? "fa" : (this.fastXRecordStart == '@' ? "fq" : "UNKNOWN");
    }

    public String getFileType() {
        return this.fileType;
    }

    @Override
    public boolean hasNext() {
        if (this.nextEntry != null) {
            return true;
        }
        try {
            this.readNextEntry();
            return this.nextEntry != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public FastXEntry next() {
        if (this.nextEntry == null) {
            try {
                this.readNextEntry();
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
            }
            catch (IOException e) {
                throw new GobyRuntimeException(e);
            }
        }
        FastXEntry toReturn = this.nextEntry;
        this.nextEntry = null;
        return toReturn;
    }

    private void readNextEntry() throws IOException {
        this.nextEntry = this.mutableEntry;
        this.nextEntry.reset();
        while (true) {
            char firstChar;
            this.reader.mark(32768);
            String nextLine = this.reader.readLine();
            if (nextLine == null) {
                if (this.nextEntry.getEntry().length() == 0) {
                    this.nextEntry = null;
                } else {
                    this.nextEntry.setEntryComplete(true);
                }
                return;
            }
            if (nextLine.length() == 0 || ((firstChar = nextLine.charAt(0)) == ';' || firstChar == '#') && this.nextEntry.getEntry().length() == 0) continue;
            if (!this.nextEntry.addLine(nextLine)) {
                this.reader.reset();
                return;
            }
            if (!this.nextEntry.isEntryComplete()) continue;
            if (!this.useCasavaQualityFilter) break;
            if (!this.nextEntry.isCasavaFilteredOutEntry()) {
                return;
            }
            this.nextEntry.reset();
        }
    }

    public boolean isUseCasavaQualityFilter() {
        return this.useCasavaQualityFilter;
    }

    public void setUseCasavaQualityFilter(boolean useCasavaQualityFilter) {
        this.useCasavaQualityFilter = useCasavaQualityFilter;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<FastXEntry> iterator() {
        return this;
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Reader)this.reader);
    }
}

