/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.io.InputBitStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.campagnelab.goby.counts.CountsReader;

public class CountIndexBuilder {
    IntArrayList positions = new IntArrayList();
    IntArrayList offsets = new IntArrayList();
    IntArrayList counts = new IntArrayList();
    private int numIndexEntries;
    private int transitionsPerIndex = 10000;

    public CountIndexBuilder(int transitionsPerIndex) {
        this.transitionsPerIndex = transitionsPerIndex;
    }

    public CountIndexBuilder() {
    }

    public void buildIndex(byte[] countBytes, DataOutput indexPart) throws IOException {
        this.positions.clear();
        this.offsets.clear();
        this.counts.clear();
        this.numIndexEntries = 0;
        ByteArrayInputStream stream = new ByteArrayInputStream(countBytes);
        InputBitStream inputBitStream = new InputBitStream((InputStream)stream);
        CountsReader reader = new CountsReader(inputBitStream);
        int transitionNum = 0;
        long bitsWritten = 0L;
        int maxPosition = 0;
        assert (this.positions.isEmpty()) : "we start a new sequence and must not have positions from other sequences.";
        assert (this.offsets.isEmpty()) : "we start a new sequence and must not have offsets from other sequences.";
        assert (this.counts.isEmpty()) : "we start a new sequence and must not have counts from other sequences.";
        while (reader.hasNextTransition()) {
            reader.nextTransition();
            int position = reader.getPosition();
            int count = reader.getCount();
            if (++transitionNum % this.transitionsPerIndex == 0) {
                this.offsets.add((int)bitsWritten);
                this.positions.add(position);
                this.counts.add(count);
                ++this.numIndexEntries;
                maxPosition = Math.max(position, maxPosition);
            }
            bitsWritten = inputBitStream.readBits();
        }
        this.offsets.add((int)bitsWritten);
        this.positions.add(maxPosition);
        this.counts.add(0);
        ++this.numIndexEntries;
        indexPart.writeInt(this.numIndexEntries);
        BinIO.storeInts((int[])this.positions.toIntArray(), (DataOutput)indexPart);
        BinIO.storeInts((int[])this.offsets.toIntArray(), (DataOutput)indexPart);
        BinIO.storeInts((int[])this.counts.toIntArray(), (DataOutput)indexPart);
    }
}

