/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.processors;

import java.io.Serializable;

public class ObservedIndel
implements Comparable<ObservedIndel>,
Serializable {
    final int startPosition;
    final int endPosition;
    final String from;
    final String to;
    private int length;
    public int readIndex;
    private byte[] qualityScores;
    private boolean hasQualityScores;
    private boolean matchesForwardStrand;
    final int BEFORE = -1;
    final int EQUAL = 0;
    final int AFTER = 1;

    public ObservedIndel(int startPosition, String from, String to, int readIndex, boolean matchesForwardStrand) {
        this(startPosition, from, to, readIndex);
        this.matchesForwardStrand = matchesForwardStrand;
    }

    public ObservedIndel(int startPosition, String from, String to, int readIndex) {
        this(startPosition, from, to);
        this.readIndex = readIndex;
    }

    public ObservedIndel(int startPosition, int endPosition, String from, String to) {
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.from = from;
        this.to = to;
        this.length = Math.max(from.length(), to.length());
    }

    public ObservedIndel(int startPosition, String from, String to) {
        this(startPosition, startPosition + Math.max(from.length(), to.length()) + 1, from, to);
    }

    public boolean hasQualityScores() {
        return this.hasQualityScores;
    }

    public byte[] getQualityScores() {
        return this.qualityScores;
    }

    public void setQualityScores(byte[] qualityScores) {
        this.hasQualityScores = true;
        this.qualityScores = qualityScores;
    }

    public void setMatchesForwardStrand(boolean matchesForwardStrand) {
        this.matchesForwardStrand = matchesForwardStrand;
    }

    public int positionSpan() {
        return this.endPosition - this.startPosition;
    }

    public int getLength() {
        return this.length;
    }

    public ObservedIndel(int startPosition, int endPosition, String from, String to, int readIndex) {
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.from = from;
        this.to = to;
        this.readIndex = readIndex;
    }

    public int getStart() {
        return this.startPosition;
    }

    public int getEnd() {
        return this.endPosition;
    }

    public String from() {
        return this.from;
    }

    public String to() {
        return this.to;
    }

    public final boolean isReferenceInsertion() {
        return this.to.contains("-");
    }

    public final boolean isReadInsertion() {
        return this.from.contains("-");
    }

    public int hashCode() {
        return this.startPosition ^ this.endPosition ^ this.from.hashCode() ^ this.to.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ObservedIndel)) {
            return false;
        }
        ObservedIndel other = (ObservedIndel)o;
        return other.startPosition == this.startPosition && other.endPosition == this.endPosition && other.from().equals(this.from) && other.to.equals(this.to);
    }

    public String toString() {
        return String.format("%s/%s %d-%d", this.from, this.to, this.startPosition, this.endPosition);
    }

    @Override
    public int compareTo(ObservedIndel other) {
        if (this == other) {
            return 0;
        }
        if (this.startPosition < other.startPosition) {
            return -1;
        }
        if (this.startPosition > other.startPosition) {
            return 1;
        }
        if (this.endPosition < other.endPosition) {
            return -1;
        }
        if (this.endPosition > other.endPosition) {
            return 1;
        }
        int a = this.from.compareTo(other.from);
        if (a != 0) {
            return a;
        }
        a = this.to.compareTo(other.to);
        return a;
    }

    public boolean getMatchesForwardStrand() {
        return this.matchesForwardStrand;
    }

    public int gapLength() {
        int i;
        int gapLength = 0;
        for (i = 0; i < this.from.length(); ++i) {
            if (this.from.charAt(i) != '-') continue;
            ++gapLength;
        }
        for (i = 0; i < this.to.length(); ++i) {
            if (this.to.charAt(i) != '-') continue;
            ++gapLength;
        }
        return gapLength;
    }
}

