/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.AlignmentPositionComparator;
import org.campagnelab.goby.alignments.AlignmentReader;
import org.campagnelab.goby.alignments.AlignmentWriterImpl;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.IterateAlignments;
import org.campagnelab.goby.alignments.Merge;

public class SortIterateAlignments
extends IterateAlignments {
    private static final Log LOG = LogFactory.getLog(SortIterateAlignments.class);
    ObjectArrayList<Alignments.AlignmentEntry> entries = new ObjectArrayList();
    String outputFilename;
    String basename;
    private static final Comparator<Alignments.AlignmentEntry> POSITION_ENTRY_COMPARATOR = new AlignmentPositionComparator();
    AlignmentReader alignmentReader = null;

    public String getBasename() {
        return this.basename;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    @Override
    public void prepareDataStructuresForReference(AlignmentReader alignmentReader, int referenceIndex) {
        if (this.alignmentReader == null) {
            this.alignmentReader = alignmentReader;
        }
    }

    @Override
    public void processAlignmentEntry(AlignmentReader alignmentReader, Alignments.AlignmentEntry alignmentEntry) {
        this.entries.add((Object)alignmentEntry);
    }

    public void sort() {
        Collections.sort(this.entries, POSITION_ENTRY_COMPARATOR);
    }

    public void writeTmh() throws IOException {
        Merge.prepareMergedTooManyHits(this.outputFilename, this.alignmentReader.getNumberOfQueries(), 0, this.basename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(AlignmentWriterImpl writer) throws IOException {
        try {
            writer.setTargetIdentifiers(this.alignmentReader.getTargetIdentifiers());
            writer.setQueryIdentifiers(this.alignmentReader.getQueryIdentifiers());
            int[] targetLengths = this.alignmentReader.getTargetLength();
            if (targetLengths != null) {
                writer.setTargetLengths(targetLengths);
            }
            writer.setLargestSplitQueryIndex(this.alignmentReader.getLargestSplitQueryIndex());
            writer.setSmallestSplitQueryIndex(this.alignmentReader.getSmallestSplitQueryIndex());
            writer.setSorted(true);
            writer.setAlignerName(this.alignmentReader.getAlignerName());
            writer.setAlignerVersion(this.alignmentReader.getAlignerVersion());
            writer.setStatistics(this.alignmentReader.getStatistics());
            writer.putStatistic("basename", FilenameUtils.getName((String)this.basename));
            writer.putStatistic("basename.full", this.basename);
            for (Alignments.AlignmentEntry entry : this.entries) {
                writer.appendEntry(entry);
            }
        }
        finally {
            writer.close();
        }
    }
}

