/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import edu.cornell.med.icb.identifier.IndexedIdentifier;
import edu.cornell.med.icb.util.VersionUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.lang.MutableString;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.AlignmentCollectionHandler;
import org.campagnelab.goby.alignments.AlignmentWriter;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.perms.NoOpPermutation;
import org.campagnelab.goby.alignments.perms.QueryIndexPermutation;
import org.campagnelab.goby.alignments.perms.QueryIndexPermutationInterface;
import org.campagnelab.goby.compression.MessageChunksWriter;
import org.campagnelab.goby.util.dynoptions.DynamicOptionClient;
import org.campagnelab.goby.util.dynoptions.RegisterThis;

public class AlignmentWriterImpl
implements AlignmentWriter {
    private static final Log LOG = LogFactory.getLog(AlignmentWriterImpl.class);
    private final Alignments.AlignmentCollection.Builder collectionBuilder;
    private final MessageChunksWriter entriesChunkWriter;
    private IndexedIdentifier queryIdentifiers;
    private IndexedIdentifier targetIdentifiers;
    private boolean headerWritten;
    private final GZIPOutputStream headerOutput;
    private boolean entriesHaveQueryLength;
    private boolean entriesHaveQueryIndexOccurrences = true;
    private boolean allReadQualityScores = true;
    @RegisterThis
    public static DynamicOptionClient doc = new DynamicOptionClient(AlignmentWriterImpl.class, "permutate-query-indices:boolean, when true permutates query indices to small values (improves compression, but looses the ability to track alignments back to reads):false");
    private ObjectArrayList<Alignments.ReadOriginInfo.Builder> readOriginInfoBuilderList;
    private boolean entriesHaveAmbiguity = true;
    private String alignerName;
    private String alignerVersion;
    private String gobyVersion;
    private final IntSet uniqueQueryLengths = new IntOpenHashSet();
    private int[] targetLengths;
    private String[] queryIdentifiersArray;
    private String[] targetIdentifiersArray;
    private int maxTargetIndex = -1;
    private int minQueryIndex = Integer.MAX_VALUE;
    private int maxQueryIndex = Integer.MIN_VALUE;
    private int actualNumberOfQueries = Integer.MIN_VALUE;
    private final Properties stats;
    private boolean statsWritten;
    private final FileWriter statsWriter;
    private final String basename;
    private int numberOfAlignedReads;
    private int constantQueryLength;
    private boolean isConstantQueryLength;
    private Alignments.AlignmentEntry.Builder newEntry;
    private final FileOutputStream alignmentEntries;
    private boolean sortedState;
    private int previousChunkOffset = -1;
    private int firstTargetIndexInChunk;
    private boolean firstEntryInChunk = true;
    private int firstPositionInChunk;
    private final LongArrayList indexOffsets = new LongArrayList();
    private final LongArrayList indexAbsolutePositions = new LongArrayList();
    private boolean indexWritten;
    private long[] targetPositionOffsets;
    private QueryIndexPermutationInterface permutator;
    private boolean queryIndicesWerePermuted;

    public static DynamicOptionClient doc() {
        return doc;
    }

    public AlignmentWriterImpl(String outputBasename) throws IOException {
        this.alignmentEntries = new FileOutputStream(outputBasename + ".entries");
        this.headerOutput = new GZIPOutputStream(new FileOutputStream(outputBasename + ".header"));
        this.statsWriter = new FileWriter(outputBasename + ".stats");
        this.basename = outputBasename;
        this.collectionBuilder = Alignments.AlignmentCollection.newBuilder();
        this.entriesChunkWriter = new MessageChunksWriter(this.alignmentEntries);
        this.entriesChunkWriter.setParser(new AlignmentCollectionHandler());
        this.newEntry = Alignments.AlignmentEntry.newBuilder();
        this.queryIdentifiers = new IndexedIdentifier();
        this.targetIdentifiers = new IndexedIdentifier();
        this.stats = new Properties();
        this.statsWritten = true;
        this.setPermutation(doc.getBoolean("permutate-query-indices"));
    }

    @Override
    public void setPermutation(boolean state) {
        if (state) {
            this.permutator = new QueryIndexPermutation(this.basename);
            this.queryIndicesWerePermuted = true;
        } else {
            this.permutator = new NoOpPermutation();
            this.queryIndicesWerePermuted = false;
        }
    }

    @Override
    public void setSorted(boolean sortedState) {
        this.sortedState = sortedState;
        if (sortedState) {
            if (this.targetPositionOffsets == null) {
                String s = "Indexing sorted alignments requires knowning target lengths before entries are appended. setTargetLength must be called before setSorted(true).";
                LOG.error((Object)"Indexing sorted alignments requires knowning target lengths before entries are appended. setTargetLength must be called before setSorted(true).");
                throw new UnsupportedOperationException("Indexing sorted alignments requires knowning target lengths before entries are appended. setTargetLength must be called before setSorted(true).");
            }
        } else {
            this.setPermutation(false);
        }
    }

    @Deprecated
    public final void setQueryIndex(int queryIndex) {
        this.newEntry.setQueryIndex(queryIndex);
    }

    @Deprecated
    public final void setTargetIndex(int targetIndex) {
        this.newEntry.setTargetIndex(targetIndex);
    }

    @Deprecated
    public final void setTargetPosition(int position) {
        this.newEntry.setPosition(position);
    }

    @Deprecated
    public final void setAlignmentScore(float score) {
        this.newEntry.setScore(score);
    }

    public void setNumAlignmentEntriesPerChunk(int numEntriesPerChunk) {
        this.entriesChunkWriter.setNumEntriesPerChunk(numEntriesPerChunk);
    }

    @Deprecated
    public final void setAlignmentEntry(int queryIndex, int targetIndex, int position, float score, boolean matchesReverseStrand, int queryLength) {
        this.newEntry.setQueryIndex(queryIndex);
        this.newEntry.setTargetIndex(targetIndex);
        this.newEntry.setScore(score);
        this.newEntry.setPosition(position);
        this.newEntry.setMatchingReverseStrand(matchesReverseStrand);
        this.newEntry.setMultiplicity(1);
        this.newEntry.setQueryLength(queryLength);
    }

    @Deprecated
    public Alignments.AlignmentEntry.Builder getAlignmentEntry() {
        return this.newEntry;
    }

    @Deprecated
    public synchronized void appendEntry() throws IOException {
        this.uniqueQueryLengths.add(this.newEntry.getQueryLength());
        this.maxTargetIndex = Math.max(this.newEntry.getTargetIndex(), this.maxTargetIndex);
        this.permutator.makeSmallIndices(this.newEntry);
        if (this.newEntry.hasMultiplicity() && this.newEntry.getMultiplicity() == 1) {
            this.newEntry.clearMultiplicity();
        }
        Alignments.AlignmentEntry builtEntry = this.newEntry.build();
        this.collectionBuilder.addAlignmentEntries(builtEntry);
        this.writeIndexEntry(builtEntry);
        this.newEntry = Alignments.AlignmentEntry.newBuilder();
    }

    private void writeIndexEntry(Alignments.AlignmentEntryOrBuilder builtEntry) throws IOException {
        this.entriesHaveQueryIndexOccurrences &= builtEntry.hasQueryIndexOccurrences();
        this.entriesHaveAmbiguity &= builtEntry.hasAmbiguity();
        this.allReadQualityScores &= builtEntry.hasReadQualityScores();
        this.entriesHaveQueryLength |= builtEntry.hasQueryLength();
        if (this.firstEntryInChunk) {
            this.firstTargetIndexInChunk = builtEntry.getTargetIndex();
            this.firstPositionInChunk = builtEntry.getPosition();
            this.firstEntryInChunk = false;
        }
        long currentChunkOffset = this.entriesChunkWriter.writeAsNeeded(this.collectionBuilder, builtEntry.hasMultiplicity() ? builtEntry.getMultiplicity() : 1);
        if (this.sortedState && this.entriesChunkWriter.getAppendedInChunk() == 0) {
            this.pushIndex(currentChunkOffset, this.firstTargetIndexInChunk, this.firstPositionInChunk);
            this.firstEntryInChunk = true;
        } else {
            this.firstEntryInChunk = false;
        }
    }

    private void pushIndex(long startOfChunkOffset, int firstTargetIndexInChunk, int firstPositionInChunk) {
        long newOffset = Math.max(startOfChunkOffset, 0L);
        int size = this.indexAbsolutePositions.size();
        long codedPosition = this.recodePosition(firstTargetIndexInChunk, firstPositionInChunk);
        if (size == 0 || codedPosition != this.indexAbsolutePositions.get(size - 1)) {
            this.indexOffsets.add(newOffset);
            this.indexAbsolutePositions.add(codedPosition);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("INDEX Pushing targetIndex= %d position= %d offset-in-file= %d absolutePosition= %d", firstTargetIndexInChunk, firstPositionInChunk, newOffset, codedPosition));
            }
        }
    }

    protected long recodePosition(int firstTargetIndexInChunk, int firstPositionInChunk) {
        assert (firstTargetIndexInChunk < this.targetPositionOffsets.length) : "Target length array must have enough elements to store each possible target index.";
        return this.targetPositionOffsets[firstTargetIndexInChunk] + (long)firstPositionInChunk;
    }

    @Override
    public synchronized void appendEntry(Alignments.AlignmentEntry entry) throws IOException {
        if (entry.hasQueryLength()) {
            this.uniqueQueryLengths.add(entry.getQueryLength());
        }
        if (entry.hasMultiplicity() && entry.getMultiplicity() == 1) {
            this.newEntry = Alignments.AlignmentEntry.newBuilder(entry);
            this.newEntry.clearMultiplicity();
            entry = this.newEntry.build();
        }
        this.maxTargetIndex = Math.max(entry.getTargetIndex(), this.maxTargetIndex);
        entry = this.permutator.makeSmallIndices(entry);
        this.collectionBuilder.addAlignmentEntries(entry);
        this.writeIndexEntry(entry);
        ++this.numberOfAlignedReads;
    }

    public boolean entriesHaveQueryIndexOccurrences() {
        return this.entriesHaveQueryIndexOccurrences;
    }

    public boolean isAllReadQualityScores() {
        return this.allReadQualityScores;
    }

    @Override
    public void close() throws IOException {
        this.writeHeader();
        this.writeStats();
        this.permutator.close();
        IOUtils.closeQuietly((OutputStream)this.headerOutput);
        this.entriesChunkWriter.close(this.collectionBuilder);
        if (this.sortedState && this.targetPositionOffsets != null) {
            this.writeIndex();
        }
        IOUtils.closeQuietly((OutputStream)this.alignmentEntries);
        IOUtils.closeQuietly((Writer)this.statsWriter);
    }

    private void writeIndex() throws IOException {
        if (!this.indexWritten) {
            this.pushIndex(this.entriesChunkWriter.getCurrentChunkStartOffset(), this.firstTargetIndexInChunk, this.firstPositionInChunk);
            DeflaterOutputStream indexOutput = null;
            try {
                indexOutput = new GZIPOutputStream(new FileOutputStream(this.basename + ".index"));
                Alignments.AlignmentIndex.Builder indexBuilder = Alignments.AlignmentIndex.newBuilder();
                assert (this.indexOffsets.size() == this.indexAbsolutePositions.size()) : "index sizes must be consistent.";
                indexBuilder.addAllOffsets((Iterable<? extends Long>)this.indexOffsets);
                indexBuilder.addAllAbsolutePositions((Iterable<? extends Long>)this.indexAbsolutePositions);
                indexBuilder.build().writeTo(indexOutput);
            }
            finally {
                if (indexOutput != null) {
                    indexOutput.close();
                }
                this.indexWritten = true;
            }
        }
    }

    private synchronized void writeHeader() throws IOException {
        if (!this.headerWritten) {
            Alignments.AlignmentHeader.Builder headerBuilder = Alignments.AlignmentHeader.newBuilder();
            String version = VersionUtils.getImplementationVersion(AlignmentWriterImpl.class);
            headerBuilder.setVersion(version);
            headerBuilder.setLargestSplitQueryIndex(this.permutator.getBiggestSmallIndex());
            headerBuilder.setSmallestSplitQueryIndex(this.permutator.getSmallestIndex());
            headerBuilder.setNumberOfTargets(this.maxTargetIndex + 1);
            headerBuilder.setNumberOfQueries(this.getNumQueries());
            headerBuilder.setSorted(this.sortedState);
            headerBuilder.setQueryIndicesWerePermuted(this.queryIndicesWerePermuted);
            headerBuilder.setQueryIndexOccurrences(this.entriesHaveQueryIndexOccurrences);
            headerBuilder.setAllReadQualityScores(this.allReadQualityScores);
            headerBuilder.setIndexed(this.sortedState);
            headerBuilder.setQueryNameMapping(this.getMapping(this.queryIdentifiers, this.queryIdentifiersArray));
            headerBuilder.setTargetNameMapping(this.getMapping(this.targetIdentifiers, this.targetIdentifiersArray));
            headerBuilder.setNumberOfAlignedReads(this.numberOfAlignedReads);
            if (this.alignerName != null) {
                headerBuilder.setAlignerName(this.alignerName);
            }
            if (this.alignerVersion != null) {
                headerBuilder.setAlignerVersion(this.alignerVersion);
            }
            if (this.uniqueQueryLengths.size() == 1) {
                this.constantQueryLength = this.uniqueQueryLengths.iterator().nextInt();
                headerBuilder.setConstantQueryLength(this.constantQueryLength);
                this.isConstantQueryLength = true;
            } else {
                this.constantQueryLength = 0;
                this.isConstantQueryLength = false;
            }
            if (this.readOriginInfoBuilderList != null) {
                for (Alignments.ReadOriginInfo.Builder builder : this.readOriginInfoBuilderList) {
                    headerBuilder.addReadOrigin(builder);
                }
            }
            headerBuilder.setQueryLengthsStoredInEntries(true);
            headerBuilder.setAmbiguityStoredInEntries(this.entriesHaveAmbiguity);
            if (this.targetLengths != null) {
                headerBuilder.addAllTargetLength((Iterable<? extends Integer>)IntArrayList.wrap((int[])this.targetLengths));
            }
            headerBuilder.setVersion(VersionUtils.getImplementationVersion(AlignmentWriterImpl.class));
            headerBuilder.build().writeTo(this.headerOutput);
            this.headerWritten = true;
        }
    }

    private synchronized void writeStats() throws IOException {
        if (!this.statsWritten) {
            this.stats.put("basename", FilenameUtils.getName((String)this.basename));
            this.stats.put("min.query.index", Integer.toString(this.permutator.getSmallestIndex()));
            this.stats.put("max.query.index", Integer.toString(this.permutator.getBiggestSmallIndex()));
            this.stats.put("number.of.queries", Integer.toString(this.getNumQueries()));
            this.stats.put("basename.full", this.basename);
            this.stats.put("number.alignment.entries", Integer.toString(this.numberOfAlignedReads));
            this.stats.store(this.statsWriter, "Statistics for merged alignment. ");
            this.statsWritten = true;
        }
    }

    @Override
    public void setQueryIdentifiersArray(String[] queryIdentifiersArray) {
        this.queryIdentifiersArray = queryIdentifiersArray;
        this.maxQueryIndex = queryIdentifiersArray.length - 1;
    }

    @Override
    public void setTargetIdentifiersArray(String[] targetIdentifiersArray) {
        this.targetIdentifiersArray = targetIdentifiersArray;
        this.maxTargetIndex = targetIdentifiersArray.length - 1;
    }

    private Alignments.IdentifierMapping getMapping(IndexedIdentifier identifiers, String[] targetIdentifiersArray) {
        Alignments.IdentifierMapping.Builder result = Alignments.IdentifierMapping.newBuilder();
        ObjectArrayList mappings = new ObjectArrayList();
        if (targetIdentifiersArray == null) {
            for (MutableString id : identifiers.keySet()) {
                if (id == null) continue;
                mappings.add((Object)Alignments.IdentifierInfo.newBuilder().setName(id.toString()).setIndex(identifiers.get((Object)id)).build());
            }
        } else {
            for (int index = 0; index < targetIdentifiersArray.length; ++index) {
                if (targetIdentifiersArray[index] == null) continue;
                mappings.add((Object)Alignments.IdentifierInfo.newBuilder().setName(targetIdentifiersArray[index]).setIndex(index).build());
            }
        }
        result.addAllMappings((Iterable<? extends Alignments.IdentifierInfo>)mappings);
        return result.build();
    }

    @Override
    public void printStats(PrintStream out) {
        this.entriesChunkWriter.printStats(out);
        out.println("Min query index: " + this.permutator.getSmallestIndex());
        out.println("Max query index: " + this.permutator.getBiggestSmallIndex());
        out.println("Number of queries: " + this.getNumQueries());
        out.println("Number of targets: " + (this.maxTargetIndex + 1));
    }

    @Override
    public void setQueryIdentifiers(IndexedIdentifier queryIdentifiers) {
        this.queryIdentifiers = queryIdentifiers;
        IntIterator intIterator = queryIdentifiers.values().iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            this.permutator.permutate(index, 2);
        }
    }

    @Override
    public void setTargetIdentifiers(IndexedIdentifier targetIdentifiers) {
        this.targetIdentifiers = targetIdentifiers;
        IntIterator intIterator = targetIdentifiers.values().iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            this.maxTargetIndex = Math.max(this.maxTargetIndex, index);
        }
    }

    @Override
    public void setTargetLengths(int[] targetLengths) {
        assert (targetLengths != null) : "Target lengths cannot be null.";
        assert (targetLengths.length > this.maxTargetIndex) : "The number of elements of targetLength is too small to accommodate targetIndex=" + this.maxTargetIndex;
        this.targetPositionOffsets = new long[targetLengths.length];
        if (targetLengths.length > 0) {
            this.targetPositionOffsets[0] = 0L;
            for (int targetIndex = 1; targetIndex < targetLengths.length; ++targetIndex) {
                this.targetPositionOffsets[targetIndex] = (long)targetLengths[targetIndex - 1] + this.targetPositionOffsets[targetIndex - 1];
            }
        }
        this.targetLengths = targetLengths;
    }

    @Override
    public void setNumQueries(int numQueries) {
        this.actualNumberOfQueries = numQueries;
        this.maxQueryIndex = numQueries - 1;
    }

    public int getNumQueries() {
        if (this.actualNumberOfQueries != Integer.MIN_VALUE) {
            return this.actualNumberOfQueries;
        }
        return this.permutator.getBiggestSmallIndex() - this.permutator.getSmallestIndex() + 1;
    }

    @Override
    public void setNumTargets(int numTargets) {
        this.maxTargetIndex = numTargets - 1;
    }

    @Override
    public void putStatistic(String description, String value) {
        this.statsWritten = false;
        this.stats.put(description, value);
    }

    @Override
    public void putStatistic(String description, double value) {
        this.putStatistic(description, String.format("%3.3g", value));
    }

    @Override
    public void putStatistic(String description, int value) {
        this.putStatistic(description, String.format("%d", value));
    }

    @Override
    public void setStatistics(Properties statistics) {
        for (Map.Entry<Object, Object> statistic : statistics.entrySet()) {
            this.putStatistic(statistic.getKey().toString(), statistic.getValue().toString());
        }
    }

    @Override
    public void setSmallestSplitQueryIndex(int smallestQueryIndex) {
        this.permutator.setSmallestIndex(smallestQueryIndex);
    }

    @Override
    public void setLargestSplitQueryIndex(int largestQueryIndex) {
        this.permutator.setBiggestSmallIndex(largestQueryIndex);
    }

    public String getAlignerVersion() {
        return this.alignerVersion;
    }

    @Override
    public void setAlignerVersion(String alignerVersion) {
        this.alignerVersion = alignerVersion;
    }

    public String getAlignerName() {
        return this.alignerName;
    }

    @Override
    public void setAlignerName(String alignerName) {
        this.alignerName = alignerName;
    }

    @Override
    public void setReadOriginInfo(ObjectArrayList<Alignments.ReadOriginInfo.Builder> readOriginInfoBuilderList) {
        this.readOriginInfoBuilderList = readOriginInfoBuilderList;
    }

    @Override
    public void addReadOriginInfo(ObjectArrayList<Alignments.ReadOriginInfo.Builder> readOriginInfoBuilderList) {
        this.readOriginInfoBuilderList.addAll(readOriginInfoBuilderList);
    }
}

