/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.campagnelab.goby.alignments.Alignments;

public class AlignmentTooManyHitsWriter
implements Closeable {
    private boolean tooManyHitsWritten;
    private final OutputStream tooManyHitsOutput;
    private final Alignments.AlignmentTooManyHits.Builder tooManyHits;
    private Alignments.AmbiguousLocation.Builder newAmbiguousLocation;
    private ObjectArrayList<Alignments.AmbiguousLocation> localCachedCollection = new ObjectArrayList();

    public AlignmentTooManyHitsWriter(String outputBasename, int alignerThreshold) throws IOException {
        this.tooManyHitsOutput = new GZIPOutputStream(new FileOutputStream(outputBasename + ".tmh"));
        this.newAmbiguousLocation = Alignments.AmbiguousLocation.newBuilder();
        this.tooManyHits = Alignments.AlignmentTooManyHits.newBuilder();
        this.tooManyHits.setAlignerThreshold(alignerThreshold);
    }

    public void setAlignerThreshold(int alignerThreshold) {
        this.tooManyHits.setAlignerThreshold(alignerThreshold);
    }

    @Override
    public void close() throws IOException {
        if (!this.localCachedCollection.isEmpty()) {
            this.tooManyHits.addAllHits((Iterable<? extends Alignments.AmbiguousLocation>)this.localCachedCollection);
            this.localCachedCollection.clear();
        }
        this.write();
    }

    public void write() throws IOException {
        if (!this.tooManyHitsWritten) {
            this.tooManyHits.build().writeTo(this.tooManyHitsOutput);
            this.tooManyHitsOutput.close();
            this.tooManyHitsWritten = true;
            this.tooManyHits.clear();
        }
    }

    public Alignments.AmbiguousLocation.Builder getNewAmbiguousLocation() {
        return this.newAmbiguousLocation;
    }

    public void append(int queryIndex, int howManyHits, int lengthOfMatch) {
        this.newAmbiguousLocation.setQueryIndex(queryIndex);
        this.newAmbiguousLocation.setAtLeastNumberOfHits(howManyHits);
        this.newAmbiguousLocation.setLengthOfMatch(lengthOfMatch);
        this.append();
    }

    public void append() {
        assert (this.tooManyHits.hasAlignerThreshold()) : "append> writer missing aligner threshold";
        assert (this.newAmbiguousLocation.hasAtLeastNumberOfHits()) : "append> new record missing atLeastNumberOfHits";
        if (this.newAmbiguousLocation.getAtLeastNumberOfHits() > this.tooManyHits.getAlignerThreshold()) {
            Alignments.AmbiguousLocation builder = this.newAmbiguousLocation.build();
            this.localCachedCollection.add((Object)builder);
        }
        this.newAmbiguousLocation = Alignments.AmbiguousLocation.newBuilder();
    }
}

