/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.algorithmic.dsv;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.lang.MutableString;
import java.util.Collections;
import java.util.Comparator;
import org.campagnelab.goby.algorithmic.indels.EquivalentIndelRegion;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.util.BaseToStringHelper;

public class SampleCountInfo {
    public static final int BASE_A_INDEX = 0;
    public static final int BASE_T_INDEX = 1;
    public static final int BASE_C_INDEX = 2;
    public static final int BASE_G_INDEX = 3;
    public static final int BASE_OTHER_INDEX = 4;
    public static final int BASE_MAX_INDEX = 5;
    public char referenceBase;
    public IntSet distinctReadIndices = new IntArraySet();
    public int sampleIndex;
    public int varCount;
    public int refCount;
    public int failedCount;
    private int[][] counts = new int[2][5];
    public boolean[] filtered = new boolean[5];
    private ObjectArrayList<EquivalentIndelRegion> indels;
    private static final Comparator<? super EquivalentIndelRegion> INDEL_COMPARATOR = new Comparator<EquivalentIndelRegion>(){

        @Override
        public int compare(EquivalentIndelRegion eir1, EquivalentIndelRegion eir2) {
            return eir1.to.compareTo(eir2.to);
        }
    };
    private int sumOfCounts;
    private BaseToStringHelper baseConversion = new BaseToStringHelper();
    static final String A_BASE = "A";
    static final String T_BASE = "T";
    static final String C_BASE = "C";
    static final String G_BASE = "G";
    static final String N_BASE = "N";
    static final String[] STRING = new String[]{"A", "T", "C", "G", "N"};
    private static final int POSITIVE_STRAND = 1;
    private static final int NEGATIVE_STRAND = 0;

    public SampleCountInfo() {
        this.counts[0] = new int[5];
        this.counts[1] = new int[5];
    }

    public void addIndel(EquivalentIndelRegion indel) {
        if (!indel.isFiltered()) {
            if (this.indels == null) {
                this.indels = new ObjectArrayList();
            }
            int previousStartPosition = -1;
            for (EquivalentIndelRegion prevIndel : this.indels) {
                if (prevIndel.equals(indel)) {
                    prevIndel.reverseReadIndices.addAll((IntCollection)indel.reverseReadIndices);
                    prevIndel.forwardReadIndices.addAll((IntCollection)indel.forwardReadIndices);
                    prevIndel.forwardQualityScores.addAll(indel.forwardQualityScores);
                    prevIndel.reverseQualityScores.addAll(indel.reverseQualityScores);
                    for (Alignments.AlignmentEntry supportingEntry : indel.supportingEntries) {
                        if (supportingEntry.getMatchingReverseStrand()) {
                            prevIndel.incrementReverseFrequency();
                            continue;
                        }
                        prevIndel.incrementForwardFrequency();
                    }
                }
                previousStartPosition = prevIndel.startPosition;
            }
            if (previousStartPosition != -1) assert (indel.startPosition == previousStartPosition) : "You can only add indels with the same start position in any given SampleCountInfo ";
            this.indels.add((Object)indel);
        }
    }

    public final int getGenotypeMaxIndex() {
        return 5 + (this.hasIndels() ? this.indels.size() : 0);
    }

    public static void alignIndels(SampleCountInfo[] samples) {
        ObjectArraySet dummyIndels = new ObjectArraySet();
        boolean hasSomeIndels = false;
        for (SampleCountInfo sample : samples) {
            if (!sample.hasIndels()) continue;
            hasSomeIndels = true;
            for (EquivalentIndelRegion indel : sample.indels) {
                if (dummyIndels.contains((Object)indel)) continue;
                dummyIndels.add((Object)indel.copy());
            }
        }
        if (!hasSomeIndels) {
            return;
        }
        for (SampleCountInfo sample : samples) {
            for (EquivalentIndelRegion indel : dummyIndels) {
                if (sample.hasMatching(indel)) continue;
                EquivalentIndelRegion copy = indel.copy();
                copy.sampleIndex = sample.sampleIndex;
                copy.markFiltered();
                if (sample.indels == null) {
                    sample.indels = new ObjectArrayList();
                }
                sample.indels.add((Object)copy);
            }
            sample.sortGenotypes();
        }
    }

    private void sortGenotypes() {
        Collections.sort(this.indels, INDEL_COMPARATOR);
    }

    private boolean hasMatching(EquivalentIndelRegion indel) {
        if (!this.hasIndels()) {
            return false;
        }
        for (EquivalentIndelRegion eir : this.indels) {
            if (eir.startPosition != indel.startPosition || eir.endPosition != indel.endPosition || eir.referenceIndex != indel.referenceIndex || !eir.to.equals(indel.to)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIndels() {
        return this.indels != null && !this.indels.isEmpty();
    }

    private boolean allMarkedRemoved() {
        boolean allRemoved = true;
        for (EquivalentIndelRegion eir : this.indels) {
            allRemoved &= eir.isFiltered();
        }
        return allRemoved;
    }

    public final char base(int baseIndex) {
        switch (baseIndex) {
            case 0: {
                return 'A';
            }
            case 2: {
                return 'C';
            }
            case 1: {
                return 'T';
            }
            case 3: {
                return 'G';
            }
        }
        return 'N';
    }

    public final int baseIndex(char to) {
        switch (to) {
            case 'A': {
                return 0;
            }
            case 'C': {
                return 2;
            }
            case 'T': {
                return 1;
            }
            case 'G': {
                return 3;
            }
        }
        return 4;
    }

    public ObjectArrayList<EquivalentIndelRegion> getEquivalentIndelRegions() {
        return this.indels;
    }

    public EquivalentIndelRegion getIndelGenotype(int genotypeIndex) {
        assert (genotypeIndex >= 5) : "genotype index must not refer to a base when fetching an indel.";
        assert (this.hasIndels()) : "SampleCountInfo must have indels to fetch an indel";
        int indelIndex = genotypeIndex - 5;
        return (EquivalentIndelRegion)this.indels.get(indelIndex);
    }

    public final void getGenotype(int genotypeIndex, MutableString destination) {
        destination.setLength(0);
        if (genotypeIndex < 5) {
            destination.append(this.base(genotypeIndex));
            return;
        }
        if (this.hasIndels()) {
            int indelIndex = genotypeIndex - 5;
            destination.append(((EquivalentIndelRegion)this.indels.get((int)indelIndex)).to);
            return;
        }
        throw new IllegalArgumentException("The genotype index argument was out of range: " + genotypeIndex);
    }

    public final String getGenotypeString(int genotypeIndex) {
        if (genotypeIndex < 5) {
            return STRING[genotypeIndex];
        }
        if (this.hasIndels()) {
            int indelIndex = genotypeIndex - 5;
            return ((EquivalentIndelRegion)this.indels.get(indelIndex)).toInContext();
        }
        throw new IllegalArgumentException("The genotype index argument was out of range: " + genotypeIndex);
    }

    public boolean isReferenceGenotype(int genotypeIndex) {
        if (genotypeIndex < 5) {
            return this.base(genotypeIndex) == this.referenceBase;
        }
        if (this.hasIndels()) {
            int indelIndex = genotypeIndex - 5;
            EquivalentIndelRegion equivalentIndelRegion = (EquivalentIndelRegion)this.indels.get(indelIndex);
            return equivalentIndelRegion.to.equals(equivalentIndelRegion.from);
        }
        throw new IllegalArgumentException("The genotype index argument was out of range: " + genotypeIndex);
    }

    public boolean isIndel(int genotypeIndex) {
        if (genotypeIndex < 5) {
            return false;
        }
        return this.hasIndels() ? genotypeIndex - 5 < this.indels.size() : false;
    }

    public String getReferenceGenotype() {
        if (this.hasIndels()) {
            return ((EquivalentIndelRegion)this.indels.get(0)).fromInContext();
        }
        return this.baseConversion.convert(this.referenceBase);
    }

    public void clearIndels() {
        if (this.indels != null) {
            this.indels.clear();
        }
    }

    public final String baseString(int genotypeIndex) {
        if (genotypeIndex < 5) {
            return STRING[genotypeIndex];
        }
        if (this.hasIndels()) {
            int indelIndex = genotypeIndex - 5;
            return ((EquivalentIndelRegion)this.indels.get(indelIndex)).toString();
        }
        throw new IllegalArgumentException("The genotype index argument was out of range: " + genotypeIndex);
    }

    public void removeIndel(EquivalentIndelRegion indel) {
        for (EquivalentIndelRegion eir : this.indels) {
            if (eir.isFiltered() || !indel.equals(eir)) continue;
            eir.markFiltered();
        }
    }

    public String toString() {
        return String.format("sample: %d counts %s %s %s %s %s FB=%d indels={ %s }%n", this.sampleIndex, this.toString(0), this.toString(1), this.toString(2), this.toString(3), this.toString(4), this.failedCount, this.indels);
    }

    private String toString(int baseIndex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.base(baseIndex));
        buffer.append("=");
        buffer.append(this.getGenotypeCount(baseIndex));
        return buffer.toString();
    }

    public void suggestRemovingGenotype(int baseIndex, boolean matchesForwardStrand) {
        if (this.getGenotypeCount(baseIndex, matchesForwardStrand) - 1 >= 0) {
            if (this.isReferenceGenotype(baseIndex)) {
                --this.refCount;
            } else {
                --this.varCount;
            }
            this.decrementGenotypeCount(baseIndex, matchesForwardStrand);
        }
    }

    public final int getGenotypeCount(int genotypeIndex) {
        if (genotypeIndex < 5) {
            return Math.max(0, this.counts[1][genotypeIndex]) + Math.max(0, this.counts[0][genotypeIndex]);
        }
        if (this.hasIndels()) {
            int indelIndex = genotypeIndex - 5;
            return ((EquivalentIndelRegion)this.indels.get(indelIndex)).getFrequency();
        }
        throw new IllegalArgumentException("The genotype index argument was out of range: " + genotypeIndex);
    }

    public final int getGenotypeCount(int genotypeIndex, boolean matchesForwardStrand) {
        if (genotypeIndex < 5) {
            return Math.max(0, this.counts[this.recodeStrand(matchesForwardStrand)][genotypeIndex]);
        }
        if (this.hasIndels()) {
            int indelIndex = genotypeIndex - 5;
            if (matchesForwardStrand) {
                return ((EquivalentIndelRegion)this.indels.get(indelIndex)).getForwardFrequency();
            }
            return ((EquivalentIndelRegion)this.indels.get(indelIndex)).getReverseFrequency();
        }
        throw new IllegalArgumentException("The genotype index argument was out of range: " + genotypeIndex);
    }

    private int recodeStrand(boolean matchesForwardStrand) {
        return matchesForwardStrand ? 1 : 0;
    }

    public void setGenotypeCount(int genotypeIndex, int count, boolean matchesForwardStrand) {
        if (genotypeIndex < 5) {
            this.counts[this.recodeStrand((boolean)matchesForwardStrand)][genotypeIndex] = count;
            return;
        }
        if (this.hasIndels()) {
            int indelIndex = genotypeIndex - 5;
            EquivalentIndelRegion equivalentIndelRegion = (EquivalentIndelRegion)this.indels.get(indelIndex);
            if (matchesForwardStrand) {
                equivalentIndelRegion.setForwardFrequency(count);
            } else {
                equivalentIndelRegion.setReverseFrequency(count);
            }
            equivalentIndelRegion.removeFiltered();
            return;
        }
        throw new IllegalArgumentException("The genotype index argument was out of range: " + genotypeIndex);
    }

    public void setGenotypeCount(int genotypeIndex, int count) {
        this.setGenotypeCount(genotypeIndex, count, true);
    }

    private int decrementGenotypeCount(int baseIndex, boolean matchesForwardStrand) {
        int[] nArray = this.counts[this.recodeStrand(matchesForwardStrand)];
        int n = baseIndex;
        int n2 = nArray[n] - 1;
        nArray[n] = n2;
        return n2;
    }

    public int incrementGenotypeCount(int baseIndex, boolean matchesForwardStrand) {
        int[] nArray = this.counts[this.recodeStrand(matchesForwardStrand)];
        int n = baseIndex;
        int n2 = nArray[n] + 1;
        nArray[n] = n2;
        return n2;
    }

    public int getSumCounts() {
        int sum = 0;
        for (int i = 0; i < this.getGenotypeMaxIndex(); ++i) {
            sum += this.getGenotypeCount(i);
        }
        return sum;
    }

    public boolean isFiltered(int genotypeIndex) {
        if (genotypeIndex < 5) {
            return this.filtered[genotypeIndex];
        }
        if (this.hasIndels()) {
            int indelIndex = genotypeIndex - 5;
            EquivalentIndelRegion equivalentIndelRegion = (EquivalentIndelRegion)this.indels.get(indelIndex);
            return equivalentIndelRegion.isFiltered();
        }
        return false;
    }

    public float frequency(int genotypeIndex) {
        int sum = 0;
        for (int index = 0; index < this.getGenotypeMaxIndex(); ++index) {
            sum += this.getGenotypeCount(index);
        }
        if (sum == 0) {
            return 0.0f;
        }
        float count = this.getGenotypeCount(genotypeIndex);
        return count / (float)sum;
    }

    public void clearGenotypeCount(int baseIndex) {
        this.counts[0][baseIndex] = 0;
        this.counts[1][baseIndex] = 0;
    }

    public int getCountsSize() {
        return this.counts.length;
    }

    public boolean anyCountNegative() {
        for (int i = 0; i < this.getCountsSize(); ++i) {
            if (this.getGenotypeCount(i) >= 0) continue;
            return true;
        }
        return false;
    }

    public int getSumOfCounts() {
        int sum = 0;
        for (int count : this.counts[0]) {
            sum += count;
        }
        for (int count : this.counts[1]) {
            sum += count;
        }
        return sum;
    }

    public int coverage() {
        int coverage = 0;
        for (int genotypeIndex = 0; genotypeIndex < this.getGenotypeMaxIndex(); ++genotypeIndex) {
            coverage += this.getGenotypeCount(genotypeIndex);
        }
        return coverage;
    }
}

