/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.algorithmic.dsv;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collections;
import java.util.Random;
import org.campagnelab.goby.algorithmic.indels.EquivalentIndelRegion;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.PositionBaseInfo;

public class DiscoverVariantPositionData
extends ObjectArrayList<PositionBaseInfo> {
    private static final long serialVersionUID = 9212001398502402859L;
    private char referenceBase;
    private ObjectArraySet<EquivalentIndelRegion> candidateIndels;
    private int position = -1;
    private ObjectArraySet<EquivalentIndelRegion> failedIndels;
    private static final ObjectArraySet<EquivalentIndelRegion> EMPTY_SET = new ObjectArraySet();
    private int numObservations;
    public int SUB_SAMPLE_SIZE = Integer.MAX_VALUE;
    public ObjectArraySet[] filtered;
    Random random = new Random();

    public int getZeroBasedPosition() {
        return this.position;
    }

    public DiscoverVariantPositionData() {
        this.filtered = new ObjectArraySet[5];
        for (int baseIndex = 0; baseIndex < 5; ++baseIndex) {
            this.filtered[baseIndex] = new ObjectArraySet();
        }
    }

    public void clear() {
        super.clear();
        if (this.candidateIndels != null) {
            this.candidateIndels.clear();
        }
        if (this.failedIndels != null) {
            this.failedIndels.clear();
        }
        if (this.filtered != null) {
            for (ObjectArraySet set : this.filtered) {
                set.clear();
            }
        }
        this.numObservations = 0;
    }

    public String toString() {
        return String.format("pos=%d #bases: %d #indels: %d", this.position, this.size(), this.hasCandidateIndels() ? this.getIndels().size() : 0);
    }

    public DiscoverVariantPositionData(int position, char referenceBase) {
        this();
        this.position = position;
        this.referenceBase = referenceBase;
    }

    public void observeCandidateIndel(EquivalentIndelRegion candidateIndel, Alignments.AlignmentEntry alignmentEntry) {
        if (this.candidateIndels == null) {
            this.candidateIndels = new ObjectArraySet();
        }
        candidateIndel.supportingEntries.add(alignmentEntry);
        if (!this.candidateIndels.contains((Object)candidateIndel)) {
            this.candidateIndels.add((Object)candidateIndel);
        } else {
            for (EquivalentIndelRegion eir : this.candidateIndels) {
                if (!eir.equals(candidateIndel)) continue;
                eir.mergeInto(candidateIndel, alignmentEntry);
            }
        }
    }

    public ObjectArraySet<EquivalentIndelRegion> getIndels() {
        return this.candidateIndels;
    }

    public void failIndel(EquivalentIndelRegion indel) {
        if (this.candidateIndels != null) {
            this.candidateIndels.remove((Object)indel);
        }
        if (this.failedIndels == null) {
            this.failedIndels = new ObjectArraySet();
        }
        this.failedIndels.add((Object)indel);
    }

    public boolean hasCandidateIndels() {
        return this.candidateIndels != null && !this.candidateIndels.isEmpty();
    }

    public char getReferenceBase() {
        return this.referenceBase;
    }

    public ObjectArraySet<EquivalentIndelRegion> getFailedIndels() {
        if (this.failedIndels == null) {
            return EMPTY_SET;
        }
        return this.failedIndels;
    }

    public String completeToString() {
        return super.toString();
    }

    public void printAll() {
        System.out.println(this.completeToString());
    }

    public void subSample(int numberToKeep) {
        int size = this.size();
        if (numberToKeep >= size) {
            return;
        }
        Collections.shuffle(this);
        for (int i = size - 1; i >= numberToKeep; --i) {
            this.remove(i);
        }
    }

    public boolean add(PositionBaseInfo positionBaseInfo) {
        assert (this.SUB_SAMPLE_SIZE != 0) : "SUB_SAMPLE_SIZE cannot be zero";
        ++this.numObservations;
        float samplingRate = 1.0f;
        if (this.numObservations > this.SUB_SAMPLE_SIZE) {
            samplingRate = 1.0f / (1.0f + (float)this.numObservations / (float)this.SUB_SAMPLE_SIZE);
            if (this.random.nextFloat() < samplingRate) {
                return super.add((Object)positionBaseInfo);
            }
        }
        return super.add((Object)positionBaseInfo);
    }

    public int numObservations() {
        return this.numObservations;
    }

    public void setReferenceBase(char referenceBase) {
        this.referenceBase = referenceBase;
    }
}

