/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.util;

import edu.cornell.med.icb.stat.LinearRegression;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.time.StopWatch;

public class ProcessEstimator {
    private final StopWatch stopWatch;
    private final AtomicInteger totalUnits;
    private final AtomicInteger unitsCompleted;
    private final LinearRegression regressor;
    private double correlationCoefficient;

    public ProcessEstimator(int totalUnitsVal) {
        assert (totalUnitsVal > 0);
        this.totalUnits = new AtomicInteger(totalUnitsVal);
        this.stopWatch = new StopWatch();
        this.stopWatch.start();
        this.unitsCompleted = new AtomicInteger(0);
        this.regressor = new LinearRegression();
    }

    public long unitCompleted() {
        int numUnits = this.unitsCompleted.incrementAndGet();
        long currentTime = this.stopWatch.getTime();
        this.regressor.addDataPoint(this.stopWatch.getTime(), this.totalUnits.intValue() - numUnits);
        if (numUnits < 2) {
            return Long.MAX_VALUE;
        }
        this.regressor.regress();
        this.correlationCoefficient = this.regressor.getCorrelationCoefficient();
        long completeAt = (long)this.regressor.getXIntercept();
        return completeAt - currentTime;
    }

    public double getCorrelationCoefficient() {
        return this.correlationCoefficient;
    }

    public int getTotalUnits() {
        return this.totalUnits.intValue();
    }

    public void startTimer() {
        this.stopWatch.start();
    }

    public void suspendTimer() {
        this.stopWatch.suspend();
    }

    public void resumeTimer() {
        this.stopWatch.resume();
    }

    public long getTimeSpent() {
        return this.stopWatch.getTime();
    }

    public int getUnitsCompleted() {
        return this.unitsCompleted.intValue();
    }
}

