/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.ip;

import edu.cornell.med.icb.ip.IpAddress;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class IpUtils {
    private IpUtils() {
    }

    public static IpAddress validateIpAddress(String toValidate) throws UnknownHostException {
        if (StringUtils.isBlank((String)toValidate)) {
            return new IpAddress(null, "");
        }
        String trimmedIpAddress = toValidate.trim();
        String comment = "";
        if (trimmedIpAddress.charAt(0) == '#') {
            return new IpAddress(null, trimmedIpAddress.substring(1).trim());
        }
        String[] ipAndCommentParts = StringUtils.split((String)trimmedIpAddress, (String)"#", (int)2);
        String ipNoComment = ipAndCommentParts[0].trim();
        if (ipAndCommentParts.length == 2) {
            comment = ipAndCommentParts[1].trim();
        }
        InetAddress ipAddress = InetAddress.getByName(ipNoComment);
        return new IpAddress(ipAddress, comment);
    }

    public static List<IpAddress> readIpList(InputStream input, boolean keepCommentOnlyLines, boolean ignoreParsingErrors) throws IOException {
        String line;
        LinkedList<IpAddress> results = new LinkedList<IpAddress>();
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        while ((line = br.readLine()) != null) {
            try {
                IpAddress ipAddress = IpUtils.validateIpAddress(line);
                if (ipAddress.getIpAddress() == null && !keepCommentOnlyLines) continue;
                results.add(IpUtils.validateIpAddress(line));
            }
            catch (UnknownHostException e) {
                if (ignoreParsingErrors) continue;
                throw e;
            }
        }
        return results;
    }

    public static boolean ipListContains(List<IpAddress> list, String address) throws UnknownHostException {
        if (list == null || address == null) {
            return false;
        }
        return IpUtils.ipListContains(list, IpUtils.validateIpAddress(address).getIpAddress());
    }

    public static boolean ipListContains(List<IpAddress> list, IpAddress address) {
        if (list == null || address == null) {
            return false;
        }
        return IpUtils.ipListContains(list, address.getIpAddress());
    }

    public static boolean ipListContains(List<IpAddress> list, InetAddress address) {
        if (list == null || address == null) {
            return false;
        }
        for (IpAddress listAddr : list) {
            if (!address.equals(listAddr.getIpAddress())) continue;
            return true;
        }
        return false;
    }
}

