/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.client.builder;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.config.AwsAdvancedClientOption;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.endpoint.DefaultServiceEndpointBuilder;
import software.amazon.awssdk.awscore.interceptor.HelpfulUnknownHostExceptionInterceptor;
import software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import software.amazon.awssdk.core.client.builder.SdkDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkProtectedApi
public abstract class AwsDefaultClientBuilder<BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT>
extends SdkDefaultClientBuilder<BuilderT, ClientT>
implements AwsClientBuilder<BuilderT, ClientT> {
    private static final String DEFAULT_ENDPOINT_PROTOCOL = "https";

    protected AwsDefaultClientBuilder() {
    }

    @SdkTestInternalApi
    AwsDefaultClientBuilder(SdkHttpClient.Builder defaultHttpClientBuilder, SdkAsyncHttpClient.Builder defaultAsyncHttpClientFactory) {
        super(defaultHttpClientBuilder, defaultAsyncHttpClientFactory);
    }

    protected abstract String serviceEndpointPrefix();

    protected abstract String signingName();

    protected abstract String serviceName();

    protected final AttributeMap childHttpConfig() {
        return this.serviceHttpConfig();
    }

    protected AttributeMap serviceHttpConfig() {
        return AttributeMap.empty();
    }

    protected final SdkClientConfiguration mergeChildDefaults(SdkClientConfiguration configuration) {
        SdkClientConfiguration config = this.mergeServiceDefaults(configuration);
        return config.merge(c -> c.option(AwsAdvancedClientOption.ENABLE_DEFAULT_REGION_DETECTION, (Object)true).option((ClientOption)SdkAdvancedClientOption.DISABLE_HOST_PREFIX_INJECTION, (Object)false).option(AwsClientOption.SERVICE_SIGNING_NAME, (Object)this.signingName()).option((ClientOption)SdkClientOption.SERVICE_NAME, (Object)this.serviceName()).option(AwsClientOption.ENDPOINT_PREFIX, (Object)this.serviceEndpointPrefix()));
    }

    protected SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration configuration) {
        return configuration;
    }

    protected final SdkClientConfiguration finalizeChildConfiguration(SdkClientConfiguration configuration) {
        configuration = this.finalizeServiceConfiguration(configuration);
        configuration = configuration.toBuilder().option(AwsClientOption.AWS_REGION, (Object)this.resolveRegion(configuration)).build();
        return configuration.toBuilder().option(AwsClientOption.CREDENTIALS_PROVIDER, (Object)this.resolveCredentials(configuration)).option((ClientOption)SdkClientOption.ENDPOINT, (Object)this.resolveEndpoint(configuration)).option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, this.addAwsInterceptors(configuration)).option(AwsClientOption.SIGNING_REGION, (Object)this.resolveSigningRegion(configuration)).option((ClientOption)SdkClientOption.RETRY_POLICY, (Object)this.resolveAwsRetryPolicy(configuration)).build();
    }

    protected SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration configuration) {
        return configuration;
    }

    private Region resolveSigningRegion(SdkClientConfiguration config) {
        return ServiceMetadata.of((String)this.serviceEndpointPrefix()).signingRegion((Region)config.option(AwsClientOption.AWS_REGION));
    }

    private URI resolveEndpoint(SdkClientConfiguration config) {
        return Optional.ofNullable(config.option((ClientOption)SdkClientOption.ENDPOINT)).orElseGet(() -> this.endpointFromConfig(config));
    }

    private URI endpointFromConfig(SdkClientConfiguration config) {
        return new DefaultServiceEndpointBuilder(this.serviceEndpointPrefix(), DEFAULT_ENDPOINT_PROTOCOL).withRegion((Region)config.option(AwsClientOption.AWS_REGION)).withProfileFile((ProfileFile)config.option((ClientOption)SdkClientOption.PROFILE_FILE)).withProfileName((String)config.option((ClientOption)SdkClientOption.PROFILE_NAME)).getServiceEndpoint();
    }

    private Region resolveRegion(SdkClientConfiguration config) {
        return config.option(AwsClientOption.AWS_REGION) != null ? (Region)config.option(AwsClientOption.AWS_REGION) : this.regionFromDefaultProvider(config);
    }

    private Region regionFromDefaultProvider(SdkClientConfiguration config) {
        Boolean defaultRegionDetectionEnabled = (Boolean)config.option(AwsAdvancedClientOption.ENABLE_DEFAULT_REGION_DETECTION);
        if (defaultRegionDetectionEnabled != null && !defaultRegionDetectionEnabled.booleanValue()) {
            throw new IllegalStateException("No region was configured, and use-region-provider-chain was disabled.");
        }
        ProfileFile profileFile = (ProfileFile)config.option((ClientOption)SdkClientOption.PROFILE_FILE);
        String profileName = (String)config.option((ClientOption)SdkClientOption.PROFILE_NAME);
        return DefaultAwsRegionProviderChain.builder().profileFile(() -> profileFile).profileName(profileName).build().getRegion();
    }

    private AwsCredentialsProvider resolveCredentials(SdkClientConfiguration config) {
        return config.option(AwsClientOption.CREDENTIALS_PROVIDER) != null ? (AwsCredentialsProvider)config.option(AwsClientOption.CREDENTIALS_PROVIDER) : DefaultCredentialsProvider.builder().profileFile((ProfileFile)config.option((ClientOption)SdkClientOption.PROFILE_FILE)).profileName((String)config.option((ClientOption)SdkClientOption.PROFILE_NAME)).build();
    }

    private RetryPolicy resolveAwsRetryPolicy(SdkClientConfiguration config) {
        RetryPolicy policy = (RetryPolicy)config.option((ClientOption)SdkClientOption.RETRY_POLICY);
        if (policy != null) {
            if (policy.additionalRetryConditionsAllowed()) {
                return AwsRetryPolicy.addRetryConditions(policy);
            }
            return policy;
        }
        RetryMode retryMode = RetryMode.resolver().profileFile(() -> (ProfileFile)config.option((ClientOption)SdkClientOption.PROFILE_FILE)).profileName((String)config.option((ClientOption)SdkClientOption.PROFILE_NAME)).resolve();
        return AwsRetryPolicy.forRetryMode(retryMode);
    }

    @Override
    public final BuilderT region(Region region) {
        this.clientConfiguration.option(AwsClientOption.AWS_REGION, (Object)region);
        return (BuilderT)((AwsClientBuilder)this.thisBuilder());
    }

    public final void setRegion(Region region) {
        this.region(region);
    }

    @Override
    public final BuilderT credentialsProvider(AwsCredentialsProvider credentialsProvider) {
        this.clientConfiguration.option(AwsClientOption.CREDENTIALS_PROVIDER, (Object)credentialsProvider);
        return (BuilderT)((AwsClientBuilder)this.thisBuilder());
    }

    public final void setCredentialsProvider(AwsCredentialsProvider credentialsProvider) {
        this.credentialsProvider(credentialsProvider);
    }

    private List<ExecutionInterceptor> addAwsInterceptors(SdkClientConfiguration config) {
        List interceptors = this.awsInterceptors();
        interceptors = CollectionUtils.mergeLists(interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        return interceptors;
    }

    private List<ExecutionInterceptor> awsInterceptors() {
        return Collections.singletonList(new HelpfulUnknownHostExceptionInterceptor());
    }
}

