/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.netty.http;

import com.typesafe.netty.CancelledSubscriber;
import com.typesafe.netty.HandlerPublisher;
import com.typesafe.netty.HandlerSubscriber;
import com.typesafe.netty.http.DelegateStreamedHttpRequest;
import com.typesafe.netty.http.EmptyHttpRequest;
import com.typesafe.netty.http.HttpStreamsHandler;
import com.typesafe.netty.http.WebSocketHttpResponse;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class HttpStreamsServerHandler
extends HttpStreamsHandler<HttpRequest, HttpResponse> {
    private HttpRequest lastRequest = null;
    private HttpStreamsHandler.Outgoing webSocketResponse = null;
    private int inFlight = 0;
    private boolean continueExpected = true;
    private boolean sendContinue = false;
    private boolean close = false;
    private final List<ChannelHandler> dependentHandlers;

    public HttpStreamsServerHandler() {
        this(Collections.emptyList());
    }

    public HttpStreamsServerHandler(List<ChannelHandler> dependentHandlers) {
        super(HttpRequest.class, HttpResponse.class);
        this.dependentHandlers = dependentHandlers;
    }

    @Override
    protected boolean hasBody(HttpRequest request) {
        return HttpUtil.getContentLength((HttpMessage)request, (int)0) != 0 || HttpUtil.isTransferEncodingChunked((HttpMessage)request);
    }

    @Override
    protected HttpRequest createEmptyMessage(HttpRequest request) {
        return new EmptyHttpRequest(request);
    }

    @Override
    protected HttpRequest createStreamedMessage(HttpRequest httpRequest, Publisher<HttpContent> stream) {
        return new DelegateStreamedHttpRequest(httpRequest, stream);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.continueExpected = false;
        this.sendContinue = false;
        if (msg instanceof HttpRequest) {
            HttpRequest request;
            this.lastRequest = request = (HttpRequest)msg;
            if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
                this.continueExpected = true;
            }
        }
        super.channelRead(ctx, msg);
    }

    @Override
    protected void receivedInMessage(ChannelHandlerContext ctx) {
        ++this.inFlight;
    }

    @Override
    protected void sentOutMessage(ChannelHandlerContext ctx) {
        --this.inFlight;
        if (this.inFlight == 1 && this.continueExpected && this.sendContinue) {
            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(this.lastRequest.protocolVersion(), HttpResponseStatus.CONTINUE));
            this.sendContinue = false;
            this.continueExpected = false;
        }
        if (this.close) {
            ctx.close();
        }
    }

    @Override
    protected void unbufferedWrite(ChannelHandlerContext ctx, HttpStreamsHandler.Outgoing out) {
        if (out.message instanceof WebSocketHttpResponse) {
            if (this.lastRequest instanceof FullHttpRequest || !this.hasBody(this.lastRequest)) {
                this.handleWebSocketResponse(ctx, out);
            } else {
                this.webSocketResponse = out;
            }
        } else {
            String connection = ((HttpResponse)out.message).headers().get((CharSequence)HttpHeaderNames.CONNECTION);
            if (this.lastRequest.protocolVersion().isKeepAliveDefault()) {
                if ("close".equalsIgnoreCase(connection)) {
                    this.close = true;
                }
            } else if (!"keep-alive".equalsIgnoreCase(connection)) {
                this.close = true;
            }
            if (this.inFlight == 1 && this.continueExpected) {
                HttpUtil.setKeepAlive(out.message, (boolean)false);
                this.close = true;
                this.continueExpected = false;
            }
            if (!HttpUtil.isContentLengthSet(out.message) && !HttpUtil.isTransferEncodingChunked(out.message) && this.canHaveBody((HttpResponse)out.message)) {
                HttpUtil.setKeepAlive(out.message, (boolean)false);
                this.close = true;
            }
            super.unbufferedWrite(ctx, out);
        }
    }

    private boolean canHaveBody(HttpResponse message) {
        HttpResponseStatus status = message.status();
        return status != HttpResponseStatus.CONTINUE && status != HttpResponseStatus.SWITCHING_PROTOCOLS && status != HttpResponseStatus.PROCESSING && status != HttpResponseStatus.NO_CONTENT && status != HttpResponseStatus.NOT_MODIFIED;
    }

    @Override
    protected void consumedInMessage(ChannelHandlerContext ctx) {
        if (this.webSocketResponse != null) {
            this.handleWebSocketResponse(ctx, this.webSocketResponse);
            this.webSocketResponse = null;
        }
    }

    private void handleWebSocketResponse(ChannelHandlerContext ctx, HttpStreamsHandler.Outgoing out) {
        WebSocketHttpResponse response = (WebSocketHttpResponse)out.message;
        WebSocketServerHandshaker handshaker = response.handshakerFactory().newHandshaker(this.lastRequest);
        if (handshaker == null) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UPGRADE_REQUIRED);
            res.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)WebSocketVersion.V13.toHttpHeaderValue());
            HttpUtil.setContentLength((HttpMessage)res, (long)0L);
            super.unbufferedWrite(ctx, new HttpStreamsHandler.Outgoing((HttpStreamsHandler)this, (HttpMessage)res, out.promise));
            response.subscribe((Subscriber)new CancelledSubscriber());
        } else {
            ChannelPipeline pipeline = ctx.pipeline();
            HandlerPublisher publisher = new HandlerPublisher(ctx.executor(), WebSocketFrame.class);
            HandlerSubscriber subscriber = new HandlerSubscriber(ctx.executor());
            pipeline.addAfter((EventExecutorGroup)ctx.executor(), ctx.name(), "websocket-subscriber", (ChannelHandler)subscriber);
            pipeline.addAfter((EventExecutorGroup)ctx.executor(), ctx.name(), "websocket-publisher", (ChannelHandler)publisher);
            ctx.pipeline().remove(ctx.name());
            handshaker.handshake(ctx.channel(), (FullHttpRequest)new EmptyHttpRequest(this.lastRequest));
            response.subscribe((Subscriber)subscriber);
            publisher.subscribe((Subscriber)response);
        }
    }

    @Override
    protected void bodyRequested(ChannelHandlerContext ctx) {
        if (this.continueExpected) {
            if (this.inFlight == 1) {
                ctx.writeAndFlush((Object)new DefaultFullHttpResponse(this.lastRequest.protocolVersion(), HttpResponseStatus.CONTINUE));
                this.continueExpected = false;
            } else {
                this.sendContinue = true;
            }
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        for (ChannelHandler dependent : this.dependentHandlers) {
            try {
                ctx.pipeline().remove(dependent);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }
}

