/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache.internal.conn;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.http.conn.ConnectionRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.apache.internal.conn.Wrapped;

@SdkInternalApi
final class ClientConnectionRequestFactory {
    private static final Logger log = LoggerFactory.getLogger(ClientConnectionRequestFactory.class);
    private static final Class<?>[] INTERFACES = new Class[]{ConnectionRequest.class, Wrapped.class};

    private ClientConnectionRequestFactory() {
    }

    static ConnectionRequest wrap(ConnectionRequest orig) {
        if (orig instanceof Wrapped) {
            throw new IllegalArgumentException();
        }
        return (ConnectionRequest)Proxy.newProxyInstance(ClientConnectionRequestFactory.class.getClassLoader(), INTERFACES, (InvocationHandler)new Handler(orig));
    }

    private static class Handler
    implements InvocationHandler {
        private final ConnectionRequest orig;

        Handler(ConnectionRequest orig) {
            this.orig = orig;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.orig, args);
            }
            catch (InvocationTargetException e) {
                log.debug("", (Throwable)e);
                throw e.getCause();
            }
        }
    }
}

