/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.utils.builder.SdkBuilder;

final class ObjectListCopier {
    ObjectListCopier() {
    }

    static List<S3Object> copy(Collection<S3Object> objectListParam) {
        if (objectListParam == null || objectListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        ArrayList<S3Object> objectListParamCopy = new ArrayList<S3Object>(objectListParam);
        return Collections.unmodifiableList(objectListParamCopy);
    }

    static List<S3Object> copyFromBuilder(Collection<? extends S3Object.Builder> objectListParam) {
        if (objectListParam == null || objectListParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return ObjectListCopier.copy(objectListParam.stream().map(SdkBuilder::build).collect(Collectors.toList()));
    }
}

