/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.readers.sam;

import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.lang.MutableString;
import java.util.ArrayList;
import java.util.List;
import org.campagnelab.goby.readers.sam.GobyQuickSeqvar;
import org.campagnelab.goby.readers.sam.GobySamSegment;
import org.campagnelab.goby.util.LogIsConfigured;
import org.campagnelab.goby.util.pool.QueueResettableObjectPool;
import org.campagnelab.goby.util.pool.Resettable;
import org.campagnelab.goby.util.pool.ResettableObjectPoolInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GobySamRecord
implements Resettable {
    private static final Logger LOG = LoggerFactory.getLogger(GobySamRecord.class);
    private final ResettableObjectPoolInterface<GobySamSegment> gobySamSegmentPool;
    private final ResettableObjectPoolInterface<GobyQuickSeqvar> gobyQuickSeqvarPool;
    List<GobyQuickSeqvar> allSequenceVariations;
    List<GobySamSegment> segments;
    String query;
    ByteList readQuals;
    int readNum;
    MutableString readName;
    int targetIndex;
    boolean reverseStrand;
    boolean hasMate;
    int pairFlags;
    int mateTargetIndex;
    int mateStartPosition;
    int numInserts;
    int numDeletes;
    int queryAlignedLength;
    int targetAlignedLength;
    private final boolean debug = LogIsConfigured.isConfigured();

    public GobySamRecord() {
        this.gobySamSegmentPool = new QueueResettableObjectPool<GobySamSegment>(){

            @Override
            public GobySamSegment makeObject() {
                return new GobySamSegment(GobySamRecord.this.gobyQuickSeqvarPool);
            }
        };
        this.gobyQuickSeqvarPool = new QueueResettableObjectPool<GobyQuickSeqvar>(){

            @Override
            public GobyQuickSeqvar makeObject() {
                return new GobyQuickSeqvar();
            }
        };
        this.allSequenceVariations = new ArrayList<GobyQuickSeqvar>();
        this.segments = new ArrayList<GobySamSegment>();
        this.readName = new MutableString();
        this.reset();
    }

    @Override
    public void reset() {
        for (GobySamSegment segment : this.segments) {
            this.gobySamSegmentPool.returnObject(segment);
        }
        this.segments.clear();
        this.allSequenceVariations.clear();
        this.readNum = 0;
        this.targetIndex = 0;
        this.reverseStrand = false;
        this.hasMate = false;
        this.pairFlags = 0;
        this.mateTargetIndex = 0;
        this.mateStartPosition = 0;
        this.numInserts = 0;
        this.numDeletes = 0;
        this.queryAlignedLength = 0;
        this.targetAlignedLength = 0;
        this.readName.length(0);
    }

    public int getQueryLength() {
        return this.query.length();
    }

    public int getNumSegments() {
        return this.segments.size();
    }

    public List<GobySamSegment> getSegments() {
        return this.segments;
    }

    public GobySamSegment getSegment(int index) {
        return this.segments.get(index);
    }

    public GobySamSegment addSegment() {
        GobySamSegment segment = this.gobySamSegmentPool.borrowObject();
        this.segments.add(segment);
        return segment;
    }

    public int getReadNum() {
        return this.readNum;
    }

    public MutableString getReadName() {
        return this.readName;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public boolean isReverseStrand() {
        return this.reverseStrand;
    }

    public boolean isHasMate() {
        return this.hasMate;
    }

    public int getPairFlags() {
        return this.pairFlags;
    }

    public int getMateTargetIndex() {
        return this.mateTargetIndex;
    }

    public int getMateStartPosition() {
        return this.mateStartPosition;
    }

    public int getNumInserts() {
        return this.numInserts;
    }

    public int getNumDeletes() {
        return this.numDeletes;
    }

    public int getTargetAlignedLength() {
        return this.targetAlignedLength;
    }

    public int getQueryAlignedLength() {
        return this.queryAlignedLength;
    }

    public int getSequenceVariationsCount() {
        return this.allSequenceVariations.size();
    }

    public GobyQuickSeqvar getSequenceVariations(int i) {
        return this.allSequenceVariations.get(i);
    }

    public List<GobyQuickSeqvar> getSequenceVariations() {
        return this.allSequenceVariations;
    }

    public String getQuery() {
        return this.query;
    }

    public byte[] getReadQualitiesAsBytes() {
        return this.readQuals.toByteArray();
    }

    public void observeVariations() {
        for (GobySamSegment segment : this.segments) {
            segment.observeVariations();
            if (this.debug && LOG.isDebugEnabled()) {
                segment.debugOutput();
            }
            this.allSequenceVariations.addAll(segment.sequenceVariations);
            this.targetAlignedLength += segment.targetAlignedLength;
            this.queryAlignedLength += segment.queryAlignedLength;
        }
    }
}

