/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.modes.core;

import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import org.campagnelab.goby.GobyVersion;
import org.campagnelab.goby.alignments.AlignmentReaderImpl;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.ReferenceLocation;

public class UpgradeModeCore {
    private String[] basenames;
    private boolean silent;
    private boolean check;

    public void setBasenames(String[] basenames) {
        this.basenames = basenames;
    }

    public void execute() throws IOException {
        for (String basename : this.basenames) {
            this.upgrade(basename);
            if (!this.check) continue;
            this.check(basename);
        }
    }

    public void upgrade(String basename) {
        try {
            AlignmentReaderImpl reader = new AlignmentReaderImpl(basename, false);
            reader.readHeader();
            String version = reader.getGobyVersion();
            if (!this.silent) {
                System.out.printf("processing %s with version %s %n", basename, version);
            }
            if (GobyVersion.isOlder(version, "goby_1.9.6") && reader.isIndexed()) {
                System.err.println("This alignment requires upgrading, please download goby 2 and use its concatenate to upgrade.");
                System.exit(1);
            }
            if (GobyVersion.isOlder(version, "goby_1.9.8.2") && reader.isIndexed()) {
                System.err.println("This alignment requires upgrading, please download goby 2 and use its concatenate tool to upgrade.");
                System.exit(1);
            }
        }
        catch (IOException e) {
            System.err.println("Could not read alignment " + basename);
            e.printStackTrace();
        }
    }

    public void check(String basename) {
        try {
            AlignmentReaderImpl reader = new AlignmentReaderImpl(basename, false);
            reader.readHeader();
            String version = reader.getGobyVersion();
            if (!this.silent) {
                System.out.printf("processing %s with version %s %n", basename, version);
            }
            if (GobyVersion.isMoreRecent(version, "1.9.6") && reader.isIndexed()) {
                ObjectList<ReferenceLocation> locations = reader.getLocations(1000);
                System.out.println("Checking..");
                ProgressLogger progress = new ProgressLogger();
                progress.expectedUpdates = locations.size();
                progress.start();
                for (ReferenceLocation location : locations) {
                    Alignments.AlignmentEntry entry = reader.skipTo(location.targetIndex, location.position);
                    if (entry == null) {
                        System.err.printf("Entry must be found at position (t=%d,p=%d) %n", location.targetIndex, location.position);
                        System.exit(1);
                    }
                    if (entry.getTargetIndex() < location.targetIndex) {
                        System.err.printf("Entry must be found on reference >%d for position (t=%d,p=%d) %n", location.targetIndex, location.targetIndex, location.position);
                        System.exit(1);
                    }
                    if (entry.getPosition() < location.position) {
                        System.err.printf("Entry must be found at position >=%d for position (t=%d,p=%d) %n", location.position, entry.getTargetIndex(), entry.getPosition());
                        System.exit(1);
                    }
                    progress.lightUpdate();
                }
                progress.stop();
                System.out.printf("Checked %d skipTo calls", locations.size());
            }
        }
        catch (IOException e) {
            System.err.println("Could not read alignment " + basename);
            e.printStackTrace();
        }
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }
}

