/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.filters;

import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.lang.MutableString;
import java.io.FileNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.filters.AbstractAlignmentEntryFilter;
import org.campagnelab.goby.alignments.filters.GeneTranscriptRelationships;

public final class TranscriptsAlignmentFilter
extends AbstractAlignmentEntryFilter {
    private static final Log LOG = LogFactory.getLog(TranscriptsAlignmentFilter.class);
    private final GeneTranscriptRelationships gtr;
    private final IndexedIdentifier transcriptsIndexedIdentifiers;
    private final Int2ObjectMap<IntSet> readIndexToGeneIdSetMap;
    private final int k;
    private int[] alignmentReferenceIndexToTranscriptIndex;
    private int numInspected;

    public TranscriptsAlignmentFilter(String geneTranscriptFile, int kVal) throws FileNotFoundException {
        LOG.debug((Object)"** TRANSCRIPT MODE **");
        this.gtr = new GeneTranscriptRelationships();
        this.transcriptsIndexedIdentifiers = this.gtr.load(geneTranscriptFile);
        this.readIndexToGeneIdSetMap = new Int2ObjectOpenHashMap();
        this.k = kVal;
        this.numInspected = 0;
    }

    @Override
    public void setTargetIdentifiers(IndexedIdentifier targets) {
        ObjectSet targetIds = targets.keySet();
        this.alignmentReferenceIndexToTranscriptIndex = new int[targetIds.size()];
        for (MutableString id : targetIds) {
            assert (this.transcriptsIndexedIdentifiers.containsKey((Object)id)) : "transcript id must be defined as a target sequence.";
            int transcriptIndex = this.transcriptsIndexedIdentifiers.getInt((Object)id);
            int referenceIndex = targets.getInt((Object)id);
            this.alignmentReferenceIndexToTranscriptIndex[referenceIndex] = transcriptIndex;
        }
    }

    @Override
    public void postProcessing() {
    }

    @Override
    public void inspectEntry(Alignments.AlignmentEntry entry) {
        ++this.numInspected;
        int queryIndex = entry.getQueryIndex();
        IntSet geneIdSet = (IntSet)this.readIndexToGeneIdSetMap.get(queryIndex);
        if (geneIdSet != null && geneIdSet.size() > this.k) {
            return;
        }
        int transcriptIndex = this.alignmentReferenceIndexToTranscriptIndex[entry.getTargetIndex()];
        int geneIndex = this.gtr.transcript2Gene(transcriptIndex);
        if (geneIdSet == null) {
            geneIdSet = new IntArraySet();
            this.readIndexToGeneIdSetMap.put(queryIndex, (Object)geneIdSet);
        }
        if (geneIdSet.size() <= this.k) {
            geneIdSet.add(geneIndex);
            boolean bl = false;
        }
    }

    @Override
    public boolean shouldRetainEntry(Alignments.AlignmentEntry entry) {
        return ((IntSet)this.readIndexToGeneIdSetMap.get(entry.getQueryIndex())).size() <= this.k;
    }
}

