/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

final class RETokenWordBoundary
extends REToken {
    static final int BEGIN = 1;
    static final int END = 2;
    private boolean negated;
    private int where;

    final boolean match(CharIndexed input, REMatch mymatch) {
        char ch;
        boolean after = false;
        boolean before = false;
        if (((mymatch.eflags & 0x40) != 64 || mymatch.offset + mymatch.index > mymatch.anchor) && (ch = input.charAt(mymatch.index - 1)) != (char)-1) {
            boolean bl = false;
            if (Character.isLetterOrDigit(ch) || ch == '_') {
                bl = before = true;
            }
        }
        if ((ch = input.charAt(mymatch.index)) != (char)-1) {
            boolean bl = false;
            if (Character.isLetterOrDigit(ch) || ch == '_') {
                bl = true;
            }
            after = bl;
        }
        boolean doNext = false;
        if ((this.where & 1) == 1) {
            boolean bl = false;
            if (after && !before) {
                bl = doNext = true;
            }
        }
        if ((this.where & 2) == 2) {
            boolean bl = false;
            if (before && !after) {
                bl = true;
            }
            doNext ^= bl;
        }
        if (this.negated) {
            doNext ^= true;
        }
        boolean bl = false;
        if (doNext) {
            bl = this.next(input, mymatch);
        }
        return bl;
    }

    final void dump(StringBuffer os) {
        if (this.where == 3) {
            os.append(this.negated ? "\\B" : "\\b");
        } else if (this.where == 1) {
            os.append("\\<");
        } else {
            os.append("\\>");
        }
    }

    RETokenWordBoundary(int subIndex, int where, boolean negated) {
        super(subIndex);
        this.where = where;
        this.negated = negated;
    }
}

