##############################################################################
#  The BYTE UNIX Benchmarks - Release 1
#          Module: report.sh   SID: 1.4 5/15/91 19:30:26
#          
##############################################################################
# Bug reports, patches, comments, suggestions should be sent to:
#
#	Ben Smith or Tom Yager at BYTE Magazine
#	ben@bytepb.byte.com   tyager@byptepb.byte.com
#
##############################################################################
# generate an report from test log
# 
#############################################################################
#  Modification Log:
#        created 4/1/91 - Ben Smith
#
##############################################################################
BINDIR=${BINDIR-pgms}
TARGET=${TARGET-results/log}
HAVEPRINTF=false ; export HAVEPRINTF
if expr "`type printf`" : '^printf is shell builtint$' >/dev/null 2>&1 ; then
	HAVEPRINTF=true
elif expr "`type printf`" : '.* is .*/printf$' >/dev/null 2>&1 ; then
	HAVEPRINTF=true
fi
if $HAVEPRINT ; then
	# use ``$echo'' if any of the other variables...
	echo=print
	nl='\n'
	n=''
	c='\c'
elif $HAVEPRINTF ; then
	# use ``$echo'' if any of the other variables...
	echo=printf
	nl='\n'
	n=''
	c='\c'
else
	echo=echo
	(echo "hi there\c" ; echo " ") >echotmp
	# Configure checks to make sure grep returns a status...
	if grep c echotmp >/dev/null 2>&1 ; then
		nl=''
		n='-n'
		c=''
	else
		nl='\n'
		n=''
		c='\c'
	fi
	rm -f echotmp
fi
# RESULTS TARGET
#
if [ $# -lt 1 ]
then
	$echo $n "Source File for target machine results: $c"
	read TARGET
else
	TARGET=$1
fi
# check for existance
if [ ! -r ${TARGET} ]
then
	echo "Cannot open $TARGET for reading"
	exit 1
fi
awk -f ${BINDIR}/report.awk $TARGET


