/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import org.broad.igv.feature.Locus;
import org.broad.igv.ui.panel.ReferenceFrame;

public class LoadedDataInterval<T> {
    public Locus range;
    private T scores;
    int zoom = -1;

    public LoadedDataInterval(String chr, int start, int end, T scores) {
        this.range = new Locus(chr, start, end);
        this.scores = scores;
    }

    public LoadedDataInterval(String chr, int start, int end, int zoom, T scores) {
        this.range = new Locus(chr, start, end);
        this.zoom = zoom;
        this.scores = scores;
    }

    public boolean contains(String chr, int start, int end) {
        return this.range.contains(chr, start, end);
    }

    public boolean contains(String chr, int start, int end, int zoom) {
        return (this.zoom == -1 || this.zoom == zoom) && this.range.contains(chr, start, end);
    }

    public boolean contains(ReferenceFrame frame) {
        String chr = frame.getChrName();
        int start = (int)frame.getOrigin();
        int end = (int)frame.getEnd();
        int zoom = frame.getZoom();
        return this.contains(chr, start, end, zoom);
    }

    public T getFeatures() {
        return this.scores;
    }
}

