/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.ByteArrayLenCodec;
import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.DataSeriesType;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.SliceBlocksReadStreams;
import htsjdk.samtools.cram.structure.SliceBlocksWriteStreams;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteArrayLenEncoding
extends CRAMEncoding<byte[]> {
    private final CRAMEncoding<Integer> lenEncoding;
    private final CRAMEncoding<byte[]> byteEncoding;

    public ByteArrayLenEncoding(CRAMEncoding<Integer> lenEncoding, CRAMEncoding<byte[]> byteEncoding) {
        super(EncodingID.BYTE_ARRAY_LEN);
        this.lenEncoding = lenEncoding;
        this.byteEncoding = byteEncoding;
    }

    public static ByteArrayLenEncoding fromSerializedEncodingParams(byte[] serializedParams) {
        ByteBuffer buffer = ByteBuffer.wrap(serializedParams);
        EncodingID lenEncodingID = EncodingID.values()[buffer.get()];
        int lenLength = ITF8.readUnsignedITF8(buffer);
        byte[] lenBytes = new byte[lenLength];
        buffer.get(lenBytes);
        CRAMEncoding<Integer> lenEncoding = EncodingFactory.createCRAMEncoding(DataSeriesType.INT, lenEncodingID, lenBytes);
        EncodingID byteID = EncodingID.values()[buffer.get()];
        int byteLength = ITF8.readUnsignedITF8(buffer);
        byte[] byteBytes = new byte[byteLength];
        buffer.get(byteBytes);
        CRAMEncoding<byte[]> byteEncoding = EncodingFactory.createCRAMEncoding(DataSeriesType.BYTE_ARRAY, byteID, byteBytes);
        return new ByteArrayLenEncoding(lenEncoding, byteEncoding);
    }

    @Override
    public byte[] toSerializedEncodingParams() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write((byte)this.lenEncoding.id().getId());
            byte[] lenBytes = this.lenEncoding.toSerializedEncodingParams();
            ITF8.writeUnsignedITF8(lenBytes.length, byteArrayOutputStream);
            byteArrayOutputStream.write(lenBytes);
            byteArrayOutputStream.write((byte)this.byteEncoding.id().getId());
            byte[] byteBytes = this.byteEncoding.toSerializedEncodingParams();
            ITF8.writeUnsignedITF8(byteBytes.length, byteArrayOutputStream);
            byteArrayOutputStream.write(byteBytes);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public CRAMCodec<byte[]> buildCodec(SliceBlocksReadStreams sliceBlocksReadStreams, SliceBlocksWriteStreams sliceBlocksWriteStreams) {
        return new ByteArrayLenCodec(this.lenEncoding.buildCodec(sliceBlocksReadStreams, sliceBlocksWriteStreams), this.byteEncoding.buildCodec(sliceBlocksReadStreams, sliceBlocksWriteStreams));
    }

    public String toString() {
        return String.format("LenEncoding: %s ByteEncoding: %s", this.lenEncoding.toString(), this.byteEncoding.toString());
    }
}

