require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MIPS_CPUREGS_H_)) {
    eval 'sub _MIPS_CPUREGS_H_ () {1;}' unless defined(&_MIPS_CPUREGS_H_);
    require 'sys/cdefs.ph';
    if(defined(&_KERNEL_OPT)) {
	require './mips/opt_cputype.ph';
    }
    if(defined(&_LP64)) {
	eval 'sub MIPS_XUSEG_START () {(0 << 62);}' unless defined(&MIPS_XUSEG_START);
	eval 'sub MIPS_XUSEG_P {
	    my($x) = @_;
    	    eval q(((( &uint64_t)($x) >> 62) == 0));
	}' unless defined(&MIPS_XUSEG_P);
	eval 'sub MIPS_USEG_P {
	    my($x) = @_;
    	    eval q((( &uintptr_t)($x) < 0x80000000));
	}' unless defined(&MIPS_USEG_P);
	eval 'sub MIPS_XSSEG_START () {(1 << 62);}' unless defined(&MIPS_XSSEG_START);
	eval 'sub MIPS_XSSEG_P {
	    my($x) = @_;
    	    eval q(((( &uint64_t)($x) >> 62) == 1));
	}' unless defined(&MIPS_XSSEG_P);
    }
    unless(defined(&_LOCORE)) {
	eval 'sub MIPS_KSEG0_START () {(-0x7fffffff-1);}' unless defined(&MIPS_KSEG0_START);
	eval 'sub MIPS_KSEG1_START () {-0x60000000;}' unless defined(&MIPS_KSEG1_START);
	eval 'sub MIPS_KSEG2_START () {-0x40000000;}' unless defined(&MIPS_KSEG2_START);
	eval 'sub MIPS_MAX_MEM_ADDR () {-0x42000000;}' unless defined(&MIPS_MAX_MEM_ADDR);
	eval 'sub MIPS_RESERVED_ADDR () {-0x40380000;}' unless defined(&MIPS_RESERVED_ADDR);
    }
    eval 'sub MIPS_PHYS_MASK () {0x1fffffff;}' unless defined(&MIPS_PHYS_MASK);
    eval 'sub MIPS_KSEG0_TO_PHYS {
        my($x) = @_;
	    eval q((( &uintptr_t)($x) &  &MIPS_PHYS_MASK));
    }' unless defined(&MIPS_KSEG0_TO_PHYS);
    eval 'sub MIPS_PHYS_TO_KSEG0 {
        my($x) = @_;
	    eval q((( &intptr_t)(($x) +  &MIPS_KSEG0_START)));
    }' unless defined(&MIPS_PHYS_TO_KSEG0);
    eval 'sub MIPS_KSEG1_TO_PHYS {
        my($x) = @_;
	    eval q((( &uintptr_t)($x) &  &MIPS_PHYS_MASK));
    }' unless defined(&MIPS_KSEG1_TO_PHYS);
    eval 'sub MIPS_PHYS_TO_KSEG1 {
        my($x) = @_;
	    eval q((( &intptr_t)($x) | ( &intptr_t) &MIPS_KSEG1_START));
    }' unless defined(&MIPS_PHYS_TO_KSEG1);
    eval 'sub MIPS_KSEG0_P {
        my($x) = @_;
	    eval q(((( &intptr_t)($x) & ~ &MIPS_PHYS_MASK) ==  &MIPS_KSEG0_START));
    }' unless defined(&MIPS_KSEG0_P);
    eval 'sub MIPS_KSEG1_P {
        my($x) = @_;
	    eval q(((( &intptr_t)($x) & ~ &MIPS_PHYS_MASK) ==  &MIPS_KSEG1_START));
    }' unless defined(&MIPS_KSEG1_P);
    eval 'sub MIPS_KSEG2_P {
        my($x) = @_;
	    eval q((( &uintptr_t) &MIPS_KSEG2_START <= ( &uintptr_t)($x)));
    }' unless defined(&MIPS_KSEG2_P);
    eval 'sub MIPS3_VA_TO_CINDEX {
        my($x) = @_;
	    eval q(((( &intptr_t)($x) & 0xffffff) |  &MIPS_KSEG0_START));
    }' unless defined(&MIPS3_VA_TO_CINDEX);
    unless(defined(&_LOCORE)) {
	eval 'sub MIPS_XSEG_MASK () {(4.61168601842739e+18);}' unless defined(&MIPS_XSEG_MASK);
	eval 'sub MIPS_XKSEG_START () {(0x3 << 62);}' unless defined(&MIPS_XKSEG_START);
	eval 'sub MIPS_XKSEG_P {
	    my($x) = @_;
    	    eval q(((( &uint64_t)($x) >> 62) == 3));
	}' unless defined(&MIPS_XKSEG_P);
	eval 'sub MIPS_XKPHYS_START () {(0x2 << 62);}' unless defined(&MIPS_XKPHYS_START);
	eval 'sub MIPS_PHYS_TO_XKPHYS_UNCACHED {
	    my($x) = @_;
    	    eval q(( &MIPS_XKPHYS_START | (( &uint64_t)( &CCA_UNCACHED) << 59) | ($x)));
	}' unless defined(&MIPS_PHYS_TO_XKPHYS_UNCACHED);
	eval 'sub MIPS_PHYS_TO_XKPHYS_ACC {
	    my($x) = @_;
    	    eval q(( &MIPS_XKPHYS_START | (( &uint64_t)( ($mips_options->{mips3_cca_devmem})) << 59) | ($x)));
	}' unless defined(&MIPS_PHYS_TO_XKPHYS_ACC);
	eval 'sub MIPS_PHYS_TO_XKPHYS_CACHED {
	    my($x) = @_;
    	    eval q(( ($mips_options->{mips3_xkphys_cached}) | ($x)));
	}' unless defined(&MIPS_PHYS_TO_XKPHYS_CACHED);
	eval 'sub MIPS_PHYS_TO_XKPHYS {
	    my($cca,$x) = @_;
    	    eval q(( &MIPS_XKPHYS_START | (( &uint64_t)($cca) << 59) | ($x)));
	}' unless defined(&MIPS_PHYS_TO_XKPHYS);
	eval 'sub MIPS_XKPHYS_TO_PHYS {
	    my($x) = @_;
    	    eval q((( &uint64_t)($x) & 5.76460752303423e+17));
	}' unless defined(&MIPS_XKPHYS_TO_PHYS);
	eval 'sub MIPS_XKPHYS_TO_CCA {
	    my($x) = @_;
    	    eval q(((( &uint64_t)($x) >> 59) & 7));
	}' unless defined(&MIPS_XKPHYS_TO_CCA);
	eval 'sub MIPS_XKPHYS_P {
	    my($x) = @_;
    	    eval q(((( &uint64_t)($x) >> 62) == 2));
	}' unless defined(&MIPS_XKPHYS_P);
    }
    eval 'sub CCA_UNCACHED () {2;}' unless defined(&CCA_UNCACHED);
    eval 'sub CCA_CACHEABLE () {3;}' unless defined(&CCA_CACHEABLE);
    eval 'sub CCA_SB_CACHEABLE_COHERENT () {5;}' unless defined(&CCA_SB_CACHEABLE_COHERENT);
    eval 'sub CCA_ACCEL () {7;}' unless defined(&CCA_ACCEL);
    if(((defined(&MIPS32R2) ? &MIPS32R2 : undef) + (defined(&MIPS64R2) ? &MIPS64R2 : undef)) > 0) {
	if(((defined(&MIPS1) ? &MIPS1 : undef) + (defined(&MIPS3) ? &MIPS3 : undef) + (defined(&MIPS32) ? &MIPS32 : undef) + (defined(&MIPS64) ? &MIPS64 : undef)) == 0) {
	    eval 'sub COP0_SYNC () { &sll $0,$0,3;}' unless defined(&COP0_SYNC);
	    eval 'sub JR_HB_RA () {. &set  &push; . &set  &mips32r2;  ($jr->{hb})  &ra;  &nop; . &set  &pop;}' unless defined(&JR_HB_RA);
	} else {
	    eval 'sub COP0_SYNC () { &sll $0,$0,1;  &sll $0,$0,1;  &sll $0,$0,3;}' unless defined(&COP0_SYNC);
	    eval 'sub JR_HB_RA () { &sll $0,$0,1;  &sll $0,$0,1;  &jr  &ra;  &sll $0,$0,3;}' unless defined(&JR_HB_RA);
	}
    }
 elsif(((defined(&MIPS32) ? &MIPS32 : undef) + (defined(&MIPS64) ? &MIPS64 : undef)) > 0) {
	eval 'sub COP0_SYNC () { &sll $0,$0,1;  &sll $0,$0,1;  &sll $0,$0,1;}' unless defined(&COP0_SYNC);
	eval 'sub JR_HB_RA () { &sll $0,$0,1;  &sll $0,$0,1;  &jr  &ra;  &sll $0,$0,1;}' unless defined(&JR_HB_RA);
    }
 elsif((defined(&MIPS3) ? &MIPS3 : undef) > 0) {
	eval 'sub COP0_SYNC () { &nop;  &nop;  &nop;}' unless defined(&COP0_SYNC);
	eval 'sub JR_HB_RA () { &nop;  &nop;  &jr  &ra;  &nop;}' unless defined(&JR_HB_RA);
    } else {
	eval 'sub COP0_SYNC () { &nop;}' unless defined(&COP0_SYNC);
	eval 'sub JR_HB_RA () { &jr  &ra;  &nop;}' unless defined(&JR_HB_RA);
    }
    eval 'sub COP0_HAZARD_FPUENABLE () { &nop;  &nop;  &nop;  &nop;;}' unless defined(&COP0_HAZARD_FPUENABLE);
    eval 'sub MIPS_CR_BR_DELAY () {0x80000000;}' unless defined(&MIPS_CR_BR_DELAY);
    eval 'sub MIPS_CR_COP_ERR () {0x30000000;}' unless defined(&MIPS_CR_COP_ERR);
    eval 'sub MIPS_CR_COP_ERR_CU1 () {1;}' unless defined(&MIPS_CR_COP_ERR_CU1);
    eval 'sub MIPS_CR_COP_ERR_CU2 () {2;}' unless defined(&MIPS_CR_COP_ERR_CU2);
    eval 'sub MIPS_CR_COP_ERR_CU3 () {3;}' unless defined(&MIPS_CR_COP_ERR_CU3);
    eval 'sub MIPS1_CR_EXC_CODE () {0x3c;}' unless defined(&MIPS1_CR_EXC_CODE);
    eval 'sub MIPS3_CR_EXC_CODE () {0x7c;}' unless defined(&MIPS3_CR_EXC_CODE);
    eval 'sub MIPS_CR_IP () {0xff00;}' unless defined(&MIPS_CR_IP);
    eval 'sub MIPS_CR_EXC_CODE_SHIFT () {2;}' unless defined(&MIPS_CR_EXC_CODE_SHIFT);
    eval 'sub MIPS_SR_COP_USABILITY () {0xf0000000;}' unless defined(&MIPS_SR_COP_USABILITY);
    eval 'sub MIPS_SR_COP_0_BIT () {0x10000000;}' unless defined(&MIPS_SR_COP_0_BIT);
    eval 'sub MIPS_SR_COP_1_BIT () {0x20000000;}' unless defined(&MIPS_SR_COP_1_BIT);
    eval 'sub MIPS_SR_COP_2_BIT () {0x40000000;}' unless defined(&MIPS_SR_COP_2_BIT);
    eval 'sub MIPS_SR_MX () {0x1000000;}' unless defined(&MIPS_SR_MX);
    eval 'sub MIPS_SR_PX () {0x800000;}' unless defined(&MIPS_SR_PX);
    eval 'sub MIPS_SR_BEV () {0x400000;}' unless defined(&MIPS_SR_BEV);
    eval 'sub MIPS_SR_TS () {0x200000;}' unless defined(&MIPS_SR_TS);
    eval 'sub MIPS_SR_INT_IE () {0x1;}' unless defined(&MIPS_SR_INT_IE);
    eval 'sub MIPS1_PARITY_ERR () {0x100000;}' unless defined(&MIPS1_PARITY_ERR);
    eval 'sub MIPS1_CACHE_MISS () {0x80000;}' unless defined(&MIPS1_CACHE_MISS);
    eval 'sub MIPS1_PARITY_ZERO () {0x40000;}' unless defined(&MIPS1_PARITY_ZERO);
    eval 'sub MIPS1_SWAP_CACHES () {0x20000;}' unless defined(&MIPS1_SWAP_CACHES);
    eval 'sub MIPS1_ISOL_CACHES () {0x10000;}' unless defined(&MIPS1_ISOL_CACHES);
    eval 'sub MIPS1_SR_KU_OLD () {0x20;}' unless defined(&MIPS1_SR_KU_OLD);
    eval 'sub MIPS1_SR_INT_ENA_OLD () {0x10;}' unless defined(&MIPS1_SR_INT_ENA_OLD);
    eval 'sub MIPS1_SR_KU_PREV () {0x8;}' unless defined(&MIPS1_SR_KU_PREV);
    eval 'sub MIPS1_SR_INT_ENA_PREV () {0x4;}' unless defined(&MIPS1_SR_INT_ENA_PREV);
    eval 'sub MIPS1_SR_KU_CUR () {0x2;}' unless defined(&MIPS1_SR_KU_CUR);
    eval 'sub MIPS_SR_PARITY_ERR () { &MIPS1_PARITY_ERR;}' unless defined(&MIPS_SR_PARITY_ERR);
    eval 'sub MIPS_SR_CACHE_MISS () { &MIPS1_CACHE_MISS;}' unless defined(&MIPS_SR_CACHE_MISS);
    eval 'sub MIPS_SR_PARITY_ZERO () { &MIPS1_PARITY_ZERO;}' unless defined(&MIPS_SR_PARITY_ZERO);
    eval 'sub MIPS_SR_SWAP_CACHES () { &MIPS1_SWAP_CACHES;}' unless defined(&MIPS_SR_SWAP_CACHES);
    eval 'sub MIPS_SR_ISOL_CACHES () { &MIPS1_ISOL_CACHES;}' unless defined(&MIPS_SR_ISOL_CACHES);
    eval 'sub MIPS_SR_KU_OLD () { &MIPS1_SR_KU_OLD;}' unless defined(&MIPS_SR_KU_OLD);
    eval 'sub MIPS_SR_INT_ENA_OLD () { &MIPS1_SR_INT_ENA_OLD;}' unless defined(&MIPS_SR_INT_ENA_OLD);
    eval 'sub MIPS_SR_KU_PREV () { &MIPS1_SR_KU_PREV;}' unless defined(&MIPS_SR_KU_PREV);
    eval 'sub MIPS_SR_KU_CUR () { &MIPS1_SR_KU_CUR;}' unless defined(&MIPS_SR_KU_CUR);
    eval 'sub MIPS_SR_INT_ENA_PREV () { &MIPS1_SR_INT_ENA_PREV;}' unless defined(&MIPS_SR_INT_ENA_PREV);
    eval 'sub MIPS3_SR_XX () {0x80000000;}' unless defined(&MIPS3_SR_XX);
    eval 'sub MIPS3_SR_RP () {0x8000000;}' unless defined(&MIPS3_SR_RP);
    eval 'sub MIPS3_SR_FR () {0x4000000;}' unless defined(&MIPS3_SR_FR);
    eval 'sub MIPS3_SR_RE () {0x2000000;}' unless defined(&MIPS3_SR_RE);
    eval 'sub MIPS3_SR_DIAG_DL () {0x1000000;}' unless defined(&MIPS3_SR_DIAG_DL);
    eval 'sub MIPS3_SR_DIAG_IL () {0x800000;}' unless defined(&MIPS3_SR_DIAG_IL);
    eval 'sub MIPS3_SR_PX () {0x800000;}' unless defined(&MIPS3_SR_PX);
    eval 'sub MIPS3_SR_SR () {0x100000;}' unless defined(&MIPS3_SR_SR);
    eval 'sub MIPS3_SR_NMI () {0x80000;}' unless defined(&MIPS3_SR_NMI);
    eval 'sub MIPS3_SR_DIAG_CH () {0x40000;}' unless defined(&MIPS3_SR_DIAG_CH);
    eval 'sub MIPS3_SR_DIAG_CE () {0x20000;}' unless defined(&MIPS3_SR_DIAG_CE);
    eval 'sub MIPS3_SR_DIAG_PE () {0x10000;}' unless defined(&MIPS3_SR_DIAG_PE);
    eval 'sub MIPS3_SR_KX () {0x80;}' unless defined(&MIPS3_SR_KX);
    eval 'sub MIPS3_SR_SX () {0x40;}' unless defined(&MIPS3_SR_SX);
    eval 'sub MIPS3_SR_UX () {0x20;}' unless defined(&MIPS3_SR_UX);
    eval 'sub MIPS3_SR_KSU_MASK () {0x18;}' unless defined(&MIPS3_SR_KSU_MASK);
    eval 'sub MIPS3_SR_KSU_USER () {0x10;}' unless defined(&MIPS3_SR_KSU_USER);
    eval 'sub MIPS3_SR_KSU_SUPER () {0x8;}' unless defined(&MIPS3_SR_KSU_SUPER);
    eval 'sub MIPS3_SR_KSU_KERNEL () {0x;}' unless defined(&MIPS3_SR_KSU_KERNEL);
    eval 'sub MIPS3_SR_ERL () {0x4;}' unless defined(&MIPS3_SR_ERL);
    eval 'sub MIPS3_SR_EXL () {0x2;}' unless defined(&MIPS3_SR_EXL);
    eval 'sub MIPS_SR_SOFT_RESET () { &MIPS3_SR_SOFT_RESET;}' unless defined(&MIPS_SR_SOFT_RESET);
    eval 'sub MIPS_SR_DIAG_CH () { &MIPS3_SR_DIAG_CH;}' unless defined(&MIPS_SR_DIAG_CH);
    eval 'sub MIPS_SR_DIAG_CE () { &MIPS3_SR_DIAG_CE;}' unless defined(&MIPS_SR_DIAG_CE);
    eval 'sub MIPS_SR_DIAG_PE () { &MIPS3_SR_DIAG_PE;}' unless defined(&MIPS_SR_DIAG_PE);
    eval 'sub MIPS_SR_KX () { &MIPS3_SR_KX;}' unless defined(&MIPS_SR_KX);
    eval 'sub MIPS_SR_SX () { &MIPS3_SR_SX;}' unless defined(&MIPS_SR_SX);
    eval 'sub MIPS_SR_UX () { &MIPS3_SR_UX;}' unless defined(&MIPS_SR_UX);
    eval 'sub MIPS_SR_KSU_MASK () { &MIPS3_SR_KSU_MASK;}' unless defined(&MIPS_SR_KSU_MASK);
    eval 'sub MIPS_SR_KSU_USER () { &MIPS3_SR_KSU_USER;}' unless defined(&MIPS_SR_KSU_USER);
    eval 'sub MIPS_SR_KSU_SUPER () { &MIPS3_SR_KSU_SUPER;}' unless defined(&MIPS_SR_KSU_SUPER);
    eval 'sub MIPS_SR_KSU_KERNEL () { &MIPS3_SR_KSU_KERNEL;}' unless defined(&MIPS_SR_KSU_KERNEL);
    eval 'sub MIPS_SR_ERL () { &MIPS3_SR_ERL;}' unless defined(&MIPS_SR_ERL);
    eval 'sub MIPS_SR_EXL () { &MIPS3_SR_EXL;}' unless defined(&MIPS_SR_EXL);
    eval 'sub MIPS_INT_MASK () {0xff00;}' unless defined(&MIPS_INT_MASK);
    eval 'sub MIPS_INT_MASK_5 () {0x8000;}' unless defined(&MIPS_INT_MASK_5);
    eval 'sub MIPS_INT_MASK_4 () {0x4000;}' unless defined(&MIPS_INT_MASK_4);
    eval 'sub MIPS_INT_MASK_3 () {0x2000;}' unless defined(&MIPS_INT_MASK_3);
    eval 'sub MIPS_INT_MASK_2 () {0x1000;}' unless defined(&MIPS_INT_MASK_2);
    eval 'sub MIPS_INT_MASK_1 () {0x800;}' unless defined(&MIPS_INT_MASK_1);
    eval 'sub MIPS_INT_MASK_0 () {0x400;}' unless defined(&MIPS_INT_MASK_0);
    eval 'sub MIPS_HARD_INT_MASK () {0xfc00;}' unless defined(&MIPS_HARD_INT_MASK);
    eval 'sub MIPS_SOFT_INT_MASK_1 () {0x200;}' unless defined(&MIPS_SOFT_INT_MASK_1);
    eval 'sub MIPS_SOFT_INT_MASK_0 () {0x100;}' unless defined(&MIPS_SOFT_INT_MASK_0);
    eval 'sub MIPS_SOFT_INT_MASK () {0x300;}' unless defined(&MIPS_SOFT_INT_MASK);
    eval 'sub MIPS_INT_MASK_SHIFT () {8;}' unless defined(&MIPS_INT_MASK_SHIFT);
    if(defined(&MIPS3_ENABLE_CLOCK_INTR)) {
	eval 'sub MIPS3_INT_MASK () { &MIPS_INT_MASK;}' unless defined(&MIPS3_INT_MASK);
	eval 'sub MIPS3_HARD_INT_MASK () { &MIPS_HARD_INT_MASK;}' unless defined(&MIPS3_HARD_INT_MASK);
    } else {
	eval 'sub MIPS3_INT_MASK () {( &MIPS_INT_MASK & ~ &MIPS_INT_MASK_5);}' unless defined(&MIPS3_INT_MASK);
	eval 'sub MIPS3_HARD_INT_MASK () {( &MIPS_HARD_INT_MASK & ~ &MIPS_INT_MASK_5);}' unless defined(&MIPS3_HARD_INT_MASK);
    }
    eval 'sub MIPS1_CNTXT_PTE_BASE () {0xffe00000;}' unless defined(&MIPS1_CNTXT_PTE_BASE);
    eval 'sub MIPS1_CNTXT_BAD_VPN () {0x1ffffc;}' unless defined(&MIPS1_CNTXT_BAD_VPN);
    eval 'sub MIPS3_CNTXT_PTE_BASE () {0xff800000;}' unless defined(&MIPS3_CNTXT_PTE_BASE);
    eval 'sub MIPS3_CNTXT_BAD_VPN2 () {0x7ffff0;}' unless defined(&MIPS3_CNTXT_BAD_VPN2);
    eval 'sub MIPS3_CONFIG_K0_MASK () {0x7;}' unless defined(&MIPS3_CONFIG_K0_MASK);
    eval 'sub MIPS3_CONFIG_CU () {0x8;}' unless defined(&MIPS3_CONFIG_CU);
    eval 'sub MIPS3_CONFIG_DB () {0x10;}' unless defined(&MIPS3_CONFIG_DB);
    eval 'sub MIPS3_CONFIG_IB () {0x20;}' unless defined(&MIPS3_CONFIG_IB);
    eval 'sub MIPS3_CONFIG_CACHE_L1_LSIZE {
        my($config, $bit) = @_;
	    eval q(((($config) & ($bit)) ? 32: 16));
    }' unless defined(&MIPS3_CONFIG_CACHE_L1_LSIZE);
    eval 'sub MIPS3_CONFIG_DC_MASK () {0x1c0;}' unless defined(&MIPS3_CONFIG_DC_MASK);
    eval 'sub MIPS3_CONFIG_DC_SHIFT () {6;}' unless defined(&MIPS3_CONFIG_DC_SHIFT);
    eval 'sub MIPS3_CONFIG_IC_MASK () {0xe00;}' unless defined(&MIPS3_CONFIG_IC_MASK);
    eval 'sub MIPS3_CONFIG_IC_SHIFT () {9;}' unless defined(&MIPS3_CONFIG_IC_SHIFT);
    eval 'sub MIPS3_CONFIG_C_DEFBASE () {0x1000;}' unless defined(&MIPS3_CONFIG_C_DEFBASE);
    eval 'sub MIPS3_CONFIG_CS () {0x1000;}' unless defined(&MIPS3_CONFIG_CS);
    eval 'sub MIPS3_CONFIG_C_4100BASE () {0x400;}' unless defined(&MIPS3_CONFIG_C_4100BASE);
    eval 'sub MIPS3_CONFIG_CACHE_SIZE {
        my($config, $mask, $base, $shift) = @_;
	    eval q((($base) << ((($config) & ($mask)) >> ($shift))));
    }' unless defined(&MIPS3_CONFIG_CACHE_SIZE);
    eval 'sub MIPS3_CONFIG_SE () {0x1000;}' unless defined(&MIPS3_CONFIG_SE);
    eval 'sub MIPS3_CONFIG_EB () {0x2000;}' unless defined(&MIPS3_CONFIG_EB);
    eval 'sub MIPS3_CONFIG_EM () {0x4000;}' unless defined(&MIPS3_CONFIG_EM);
    eval 'sub MIPS3_CONFIG_BE () {0x8000;}' unless defined(&MIPS3_CONFIG_BE);
    eval 'sub MIPS3_CONFIG_SM () {0x10000;}' unless defined(&MIPS3_CONFIG_SM);
    eval 'sub MIPS3_CONFIG_SC () {0x20000;}' unless defined(&MIPS3_CONFIG_SC);
    eval 'sub MIPS3_CONFIG_EW_MASK () {0xc0000;}' unless defined(&MIPS3_CONFIG_EW_MASK);
    eval 'sub MIPS3_CONFIG_EW_SHIFT () {18;}' unless defined(&MIPS3_CONFIG_EW_SHIFT);
    eval 'sub MIPS3_CONFIG_SW () {0x100000;}' unless defined(&MIPS3_CONFIG_SW);
    eval 'sub MIPS3_CONFIG_SS () {0x200000;}' unless defined(&MIPS3_CONFIG_SS);
    eval 'sub MIPS3_CONFIG_SB_MASK () {0xc00000;}' unless defined(&MIPS3_CONFIG_SB_MASK);
    eval 'sub MIPS3_CONFIG_SB_SHIFT () {22;}' unless defined(&MIPS3_CONFIG_SB_SHIFT);
    eval 'sub MIPS3_CONFIG_CACHE_L2_LSIZE {
        my($config) = @_;
	    eval q((0x10 << ((($config) &  &MIPS3_CONFIG_SB_MASK) >>  &MIPS3_CONFIG_SB_SHIFT)));
    }' unless defined(&MIPS3_CONFIG_CACHE_L2_LSIZE);
    eval 'sub MIPS3_CONFIG_EP_MASK () {0xf000000;}' unless defined(&MIPS3_CONFIG_EP_MASK);
    eval 'sub MIPS3_CONFIG_EP_SHIFT () {24;}' unless defined(&MIPS3_CONFIG_EP_SHIFT);
    eval 'sub MIPS3_CONFIG_EC_MASK () {0x70000000;}' unless defined(&MIPS3_CONFIG_EC_MASK);
    eval 'sub MIPS3_CONFIG_EC_SHIFT () {28;}' unless defined(&MIPS3_CONFIG_EC_SHIFT);
    eval 'sub MIPS3_CONFIG_CM () {0x80000000;}' unless defined(&MIPS3_CONFIG_CM);
    eval 'sub MIPS4_CONFIG_K0_MASK () { &MIPS3_CONFIG_K0_MASK;}' unless defined(&MIPS4_CONFIG_K0_MASK);
    eval 'sub MIPS4_CONFIG_DN_MASK () {0x18;}' unless defined(&MIPS4_CONFIG_DN_MASK);
    eval 'sub MIPS4_CONFIG_CT () {0x20;}' unless defined(&MIPS4_CONFIG_CT);
    eval 'sub MIPS4_CONFIG_PE () {0x40;}' unless defined(&MIPS4_CONFIG_PE);
    eval 'sub MIPS4_CONFIG_PM_MASK () {0x180;}' unless defined(&MIPS4_CONFIG_PM_MASK);
    eval 'sub MIPS4_CONFIG_EC_MASK () {0x1e00;}' unless defined(&MIPS4_CONFIG_EC_MASK);
    eval 'sub MIPS4_CONFIG_SB () {0x2000;}' unless defined(&MIPS4_CONFIG_SB);
    eval 'sub MIPS4_CONFIG_SK () {0x4000;}' unless defined(&MIPS4_CONFIG_SK);
    eval 'sub MIPS4_CONFIG_BE () {0x8000;}' unless defined(&MIPS4_CONFIG_BE);
    eval 'sub MIPS4_CONFIG_SS_MASK () {0x70000;}' unless defined(&MIPS4_CONFIG_SS_MASK);
    eval 'sub MIPS4_CONFIG_SC_MASK () {0x380000;}' unless defined(&MIPS4_CONFIG_SC_MASK);
    eval 'sub MIPS4_CONFIG_RESERVED () {0x3c00000;}' unless defined(&MIPS4_CONFIG_RESERVED);
    eval 'sub MIPS4_CONFIG_DC_MASK () {0x1c000000;}' unless defined(&MIPS4_CONFIG_DC_MASK);
    eval 'sub MIPS4_CONFIG_IC_MASK () {0xe0000000;}' unless defined(&MIPS4_CONFIG_IC_MASK);
    eval 'sub MIPS4_CONFIG_DC_SHIFT () {26;}' unless defined(&MIPS4_CONFIG_DC_SHIFT);
    eval 'sub MIPS4_CONFIG_IC_SHIFT () {29;}' unless defined(&MIPS4_CONFIG_IC_SHIFT);
    eval 'sub MIPS4_CONFIG_CACHE_SIZE {
        my($config, $mask, $base, $shift) = @_;
	    eval q((($base) << ((($config) & ($mask)) >> ($shift))));
    }' unless defined(&MIPS4_CONFIG_CACHE_SIZE);
    eval 'sub MIPS4_CONFIG_CACHE_L2_LSIZE {
        my($config) = @_;
	    eval q(((($config) &  &MIPS4_CONFIG_SB) ? 128: 64));
    }' unless defined(&MIPS4_CONFIG_CACHE_L2_LSIZE);
    eval 'sub MIPS_RESET_EXC_VEC () { &MIPS_PHYS_TO_KSEG1(0x1fc00000);}' unless defined(&MIPS_RESET_EXC_VEC);
    eval 'sub MIPS_UTLB_MISS_EXC_VEC () { &MIPS_PHYS_TO_KSEG0(0);}' unless defined(&MIPS_UTLB_MISS_EXC_VEC);
    eval 'sub MIPS1_GEN_EXC_VEC () { &MIPS_PHYS_TO_KSEG0(0x80);}' unless defined(&MIPS1_GEN_EXC_VEC);
    eval 'sub MIPS3_XTLB_MISS_EXC_VEC () { &MIPS_PHYS_TO_KSEG0(0x80);}' unless defined(&MIPS3_XTLB_MISS_EXC_VEC);
    eval 'sub MIPS3_CACHE_ERR_EXC_VEC () { &MIPS_PHYS_TO_KSEG0(0x100);}' unless defined(&MIPS3_CACHE_ERR_EXC_VEC);
    eval 'sub MIPS3_GEN_EXC_VEC () { &MIPS_PHYS_TO_KSEG0(0x180);}' unless defined(&MIPS3_GEN_EXC_VEC);
    eval 'sub MIPS3_INTR_EXC_VEC () { &MIPS_PHYS_TO_KSEG0(0x200);}' unless defined(&MIPS3_INTR_EXC_VEC);
    if(defined(&_LOCORE)) {
	eval 'sub _ {
	    my($n) = @_;
    	    eval q( &__CONCAT($,$n));
	}' unless defined(&_);
    } else {
	eval 'sub _ {
	    my($n) = @_;
    	    eval q($n);
	}' unless defined(&_);
    }
    eval 'sub MIPS_COP_0_TLB_INDEX () { &_(0);}' unless defined(&MIPS_COP_0_TLB_INDEX);
    eval 'sub MIPS_COP_0_TLB_RANDOM () { &_(1);}' unless defined(&MIPS_COP_0_TLB_RANDOM);
    eval 'sub MIPS_COP_0_TLB_CONTEXT () { &_(4);}' unless defined(&MIPS_COP_0_TLB_CONTEXT);
    eval 'sub MIPS_COP_0_BAD_VADDR () { &_(8);}' unless defined(&MIPS_COP_0_BAD_VADDR);
    eval 'sub MIPS_COP_0_TLB_HI () { &_(10);}' unless defined(&MIPS_COP_0_TLB_HI);
    eval 'sub MIPS_COP_0_STATUS () { &_(12);}' unless defined(&MIPS_COP_0_STATUS);
    eval 'sub MIPS_COP_0_CAUSE () { &_(13);}' unless defined(&MIPS_COP_0_CAUSE);
    eval 'sub MIPS_COP_0_EXC_PC () { &_(14);}' unless defined(&MIPS_COP_0_EXC_PC);
    eval 'sub MIPS_COP_0_PRID () { &_(15);}' unless defined(&MIPS_COP_0_PRID);
    eval 'sub MIPS_COP_0_TLB_LOW () { &_(2);}' unless defined(&MIPS_COP_0_TLB_LOW);
    eval 'sub MIPS_COP_0_TLB_LO0 () { &_(2);}' unless defined(&MIPS_COP_0_TLB_LO0);
    eval 'sub MIPS_COP_0_TLB_LO1 () { &_(3);}' unless defined(&MIPS_COP_0_TLB_LO1);
    eval 'sub MIPS_COP_0_TLB_PG_MASK () { &_(5);}' unless defined(&MIPS_COP_0_TLB_PG_MASK);
    eval 'sub MIPS_COP_0_TLB_WIRED () { &_(6);}' unless defined(&MIPS_COP_0_TLB_WIRED);
    eval 'sub MIPS_COP_0_COUNT () { &_(9);}' unless defined(&MIPS_COP_0_COUNT);
    eval 'sub MIPS_COP_0_COMPARE () { &_(11);}' unless defined(&MIPS_COP_0_COMPARE);
    eval 'sub MIPS_COP_0_CONFIG () { &_(16);}' unless defined(&MIPS_COP_0_CONFIG);
    eval 'sub MIPS_COP_0_LLADDR () { &_(17);}' unless defined(&MIPS_COP_0_LLADDR);
    eval 'sub MIPS_COP_0_WATCH_LO () { &_(18);}' unless defined(&MIPS_COP_0_WATCH_LO);
    eval 'sub MIPS_COP_0_WATCH_LO1 () { &_(18), 1;}' unless defined(&MIPS_COP_0_WATCH_LO1);
    eval 'sub MIPS_COP_0_WATCH_HI () { &_(19);}' unless defined(&MIPS_COP_0_WATCH_HI);
    eval 'sub MIPS_COP_0_WATCH_HI1 () { &_(19), 1;}' unless defined(&MIPS_COP_0_WATCH_HI1);
    eval 'sub MIPS_COP_0_TLB_XCONTEXT () { &_(20);}' unless defined(&MIPS_COP_0_TLB_XCONTEXT);
    eval 'sub MIPS_COP_0_ECC () { &_(26);}' unless defined(&MIPS_COP_0_ECC);
    eval 'sub MIPS_COP_0_CACHE_ERR () { &_(27);}' unless defined(&MIPS_COP_0_CACHE_ERR);
    eval 'sub MIPS_COP_0_CACHE_ERR_I () { &_(27);}' unless defined(&MIPS_COP_0_CACHE_ERR_I);
    eval 'sub MIPS_COP_0_CACHE_ERR_D () { &_(27), 1;}' unless defined(&MIPS_COP_0_CACHE_ERR_D);
    eval 'sub MIPS_COP_0_TAG_LO () { &_(28);}' unless defined(&MIPS_COP_0_TAG_LO);
    eval 'sub MIPS_COP_0_TAG_HI () { &_(29);}' unless defined(&MIPS_COP_0_TAG_HI);
    eval 'sub MIPS_COP_0_TAG_HI_DATA () { &_(29), 2;}' unless defined(&MIPS_COP_0_TAG_HI_DATA);
    eval 'sub MIPS_COP_0_ERROR_PC () { &_(30);}' unless defined(&MIPS_COP_0_ERROR_PC);
    eval 'sub MIPS_COP_0_CTXCONFIG () { &_(4), 1;}' unless defined(&MIPS_COP_0_CTXCONFIG);
    eval 'sub MIPS_COP_0_USERLOCAL () { &_(4), 2;}' unless defined(&MIPS_COP_0_USERLOCAL);
    eval 'sub MIPS_COP_0_XCTXCONFIG () { &_(4), 3;}' unless defined(&MIPS_COP_0_XCTXCONFIG);
    eval 'sub MIPS_COP_0_PGGRAIN () { &_(5), 1;}' unless defined(&MIPS_COP_0_PGGRAIN);
    eval 'sub MIPS_COP_0_SEGCTL0 () { &_(5), 2;}' unless defined(&MIPS_COP_0_SEGCTL0);
    eval 'sub MIPS_COP_0_SEGCTL1 () { &_(5), 3;}' unless defined(&MIPS_COP_0_SEGCTL1);
    eval 'sub MIPS_COP_0_SEGCTL2 () { &_(5), 4;}' unless defined(&MIPS_COP_0_SEGCTL2);
    eval 'sub MIPS_COP_0_PWBASE () { &_(5), 5;}' unless defined(&MIPS_COP_0_PWBASE);
    eval 'sub MIPS_COP_0_PWFIELD () { &_(5), 6;}' unless defined(&MIPS_COP_0_PWFIELD);
    eval 'sub MIPS_COP_0_PWSIZE () { &_(5), 7;}' unless defined(&MIPS_COP_0_PWSIZE);
    eval 'sub MIPS_COP_0_PWCTL () { &_(6), 6;}' unless defined(&MIPS_COP_0_PWCTL);
    eval 'sub MIPS_COP_0_EIRR () { &_(6), 6;}' unless defined(&MIPS_COP_0_EIRR);
    eval 'sub MIPS_COP_0_EIMR () { &_(6), 7;}' unless defined(&MIPS_COP_0_EIMR);
    eval 'sub MIPS_COP_0_HWRENA () { &_(7);}' unless defined(&MIPS_COP_0_HWRENA);
    eval 'sub MIPS_COP_0_BADINSTR () { &_(8), 1;}' unless defined(&MIPS_COP_0_BADINSTR);
    eval 'sub MIPS_COP_0_BADINSTRP () { &_(8), 2;}' unless defined(&MIPS_COP_0_BADINSTRP);
    eval 'sub MIPS_COP_0_CVMCNT () { &_(9), 6;}' unless defined(&MIPS_COP_0_CVMCNT);
    eval 'sub MIPS_COP_0_CVMCTL () { &_(9), 7;}' unless defined(&MIPS_COP_0_CVMCTL);
    eval 'sub MIPS_COP_0_CVMMEMCTL () { &_(11), 7;}' unless defined(&MIPS_COP_0_CVMMEMCTL);
    eval 'sub MIPS_COP_0_INTCTL () { &_(12), 1;}' unless defined(&MIPS_COP_0_INTCTL);
    eval 'sub MIPS_COP_0_SRSCTL () { &_(12), 2;}' unless defined(&MIPS_COP_0_SRSCTL);
    eval 'sub MIPS_COP_0_SRSMAP () { &_(12), 3;}' unless defined(&MIPS_COP_0_SRSMAP);
    eval 'sub MIPS_COP_0_NESTEDEXC () { &_(13), 5;}' unless defined(&MIPS_COP_0_NESTEDEXC);
    eval 'sub MIPS_COP_0_NESTED_EPC () { &_(14), 2;}' unless defined(&MIPS_COP_0_NESTED_EPC);
    eval 'sub MIPS_COP_0_EBASE () { &_(15), 1;}' unless defined(&MIPS_COP_0_EBASE);
    eval 'sub MIPS_COP_0_CDMMBASE () { &_(15), 2;}' unless defined(&MIPS_COP_0_CDMMBASE);
    eval 'sub MIPS_COP_0_CMGCRBASE () { &_(15), 3;}' unless defined(&MIPS_COP_0_CMGCRBASE);
    eval 'sub MIPS_COP_0_CONFIG1 () { &_(16), 1;}' unless defined(&MIPS_COP_0_CONFIG1);
    eval 'sub MIPS_COP_0_CONFIG2 () { &_(16), 2;}' unless defined(&MIPS_COP_0_CONFIG2);
    eval 'sub MIPS_COP_0_CONFIG3 () { &_(16), 3;}' unless defined(&MIPS_COP_0_CONFIG3);
    eval 'sub MIPS_COP_0_CONFIG4 () { &_(16), 4;}' unless defined(&MIPS_COP_0_CONFIG4);
    eval 'sub MIPS_COP_0_CONFIG5 () { &_(16), 5;}' unless defined(&MIPS_COP_0_CONFIG5);
    eval 'sub MIPS_COP_0_CONFIG6 () { &_(16), 6;}' unless defined(&MIPS_COP_0_CONFIG6);
    eval 'sub MIPS_COP_0_CVMMEMCTL2 () { &_(16), 6;}' unless defined(&MIPS_COP_0_CVMMEMCTL2);
    eval 'sub MIPS_COP_0_CONFIG7 () { &_(16), 7;}' unless defined(&MIPS_COP_0_CONFIG7);
    eval 'sub MIPS_COP_0_CVMVMCONFIG () { &_(16), 7;}' unless defined(&MIPS_COP_0_CVMVMCONFIG);
    eval 'sub MIPS_COP_0_OSSCRATCH () { &_(22);}' unless defined(&MIPS_COP_0_OSSCRATCH);
    eval 'sub MIPS_COP_0_DIAG () { &_(22);}' unless defined(&MIPS_COP_0_DIAG);
    eval 'sub MIPS_COP_0_MCD () { &_(22);}' unless defined(&MIPS_COP_0_MCD);
    eval 'sub MIPS_COP_0_DEBUG () { &_(23);}' unless defined(&MIPS_COP_0_DEBUG);
    eval 'sub MIPS_COP_0_DEPC () { &_(24);}' unless defined(&MIPS_COP_0_DEPC);
    eval 'sub MIPS_COP_0_PERFCNT0_CTL () { &_(25);}' unless defined(&MIPS_COP_0_PERFCNT0_CTL);
    eval 'sub MIPS_COP_0_PERFCNT0_CNT () { &_(25), 1;}' unless defined(&MIPS_COP_0_PERFCNT0_CNT);
    eval 'sub MIPS_COP_0_PERFCNT1_CTL () { &_(25), 2;}' unless defined(&MIPS_COP_0_PERFCNT1_CTL);
    eval 'sub MIPS_COP_0_PERFCNT1_CNT () { &_(25), 3;}' unless defined(&MIPS_COP_0_PERFCNT1_CNT);
    eval 'sub MIPS_COP_0_PERFCNT2_CTL () { &_(25), 4;}' unless defined(&MIPS_COP_0_PERFCNT2_CTL);
    eval 'sub MIPS_COP_0_PERFCNT2_CNT () { &_(25), 5;}' unless defined(&MIPS_COP_0_PERFCNT2_CNT);
    eval 'sub MIPS_COP_0_PERFCNT3_CTL () { &_(25), 6;}' unless defined(&MIPS_COP_0_PERFCNT3_CTL);
    eval 'sub MIPS_COP_0_PERFCNT3_CNT () { &_(25), 7;}' unless defined(&MIPS_COP_0_PERFCNT3_CNT);
    eval 'sub MIPS_COP_0_DATA_LO () { &_(28), 1;}' unless defined(&MIPS_COP_0_DATA_LO);
    eval 'sub MIPS_COP_0_DATA_HI () { &_(29), 3;}' unless defined(&MIPS_COP_0_DATA_HI);
    eval 'sub MIPS_COP_0_DATA_HI_DATA () { &_(29);}' unless defined(&MIPS_COP_0_DATA_HI_DATA);
    eval 'sub MIPS_COP_0_DESAVE () { &_(31);}' unless defined(&MIPS_COP_0_DESAVE);
    eval 'sub MIPS_DIAG_RAS_DISABLE () {0x1;}' unless defined(&MIPS_DIAG_RAS_DISABLE);
    eval 'sub MIPS_DIAG_BTB_CLEAR () {0x2;}' unless defined(&MIPS_DIAG_BTB_CLEAR);
    eval 'sub MIPS_DIAG_ITLB_CLEAR () {0x4;}' unless defined(&MIPS_DIAG_ITLB_CLEAR);
    eval 'sub MIPS_BREAK_INSTR () {0xd;}' unless defined(&MIPS_BREAK_INSTR);
    eval 'sub MIPS_BREAK_VAL_MASK () {0x3ff0000;}' unless defined(&MIPS_BREAK_VAL_MASK);
    eval 'sub MIPS_BREAK_VAL_SHIFT () {16;}' unless defined(&MIPS_BREAK_VAL_SHIFT);
    eval 'sub MIPS_BREAK_INTOVERFLOW () {6;}' unless defined(&MIPS_BREAK_INTOVERFLOW);
    eval 'sub MIPS_BREAK_INTDIVZERO () {7;}' unless defined(&MIPS_BREAK_INTDIVZERO);
    eval 'sub MIPS_BREAK_KDB_VAL () {512;}' unless defined(&MIPS_BREAK_KDB_VAL);
    eval 'sub MIPS_BREAK_SSTEP_VAL () {513;}' unless defined(&MIPS_BREAK_SSTEP_VAL);
    eval 'sub MIPS_BREAK_BRKPT_VAL () {514;}' unless defined(&MIPS_BREAK_BRKPT_VAL);
    eval 'sub MIPS_BREAK_SOVER_VAL () {515;}' unless defined(&MIPS_BREAK_SOVER_VAL);
    eval 'sub MIPS_BREAK_KDB () {( &MIPS_BREAK_INSTR | ( &MIPS_BREAK_KDB_VAL <<  &MIPS_BREAK_VAL_SHIFT));}' unless defined(&MIPS_BREAK_KDB);
    eval 'sub MIPS_BREAK_SSTEP () {( &MIPS_BREAK_INSTR | ( &MIPS_BREAK_SSTEP_VAL <<  &MIPS_BREAK_VAL_SHIFT));}' unless defined(&MIPS_BREAK_SSTEP);
    eval 'sub MIPS_BREAK_BRKPT () {( &MIPS_BREAK_INSTR | ( &MIPS_BREAK_BRKPT_VAL <<  &MIPS_BREAK_VAL_SHIFT));}' unless defined(&MIPS_BREAK_BRKPT);
    eval 'sub MIPS_BREAK_SOVER () {( &MIPS_BREAK_INSTR | ( &MIPS_BREAK_SOVER_VAL <<  &MIPS_BREAK_VAL_SHIFT));}' unless defined(&MIPS_BREAK_SOVER);
    eval 'sub MIPS_MIN_CACHE_SIZE () {(16* 1024);}' unless defined(&MIPS_MIN_CACHE_SIZE);
    eval 'sub MIPS_MAX_CACHE_SIZE () {(256* 1024);}' unless defined(&MIPS_MAX_CACHE_SIZE);
    eval 'sub MIPS3_MAX_PCACHE_SIZE () {(32* 1024);}' unless defined(&MIPS3_MAX_PCACHE_SIZE);
    eval 'sub MIPS_FIR () {$0;}' unless defined(&MIPS_FIR);
    eval 'sub MIPS_FCSR () {$31;}' unless defined(&MIPS_FCSR);
    eval 'sub MIPS_FCSR_RM () { &__BITS(1,0);}' unless defined(&MIPS_FCSR_RM);
    eval 'sub MIPS_FCSR_RM_RN () {0;}' unless defined(&MIPS_FCSR_RM_RN);
    eval 'sub MIPS_FCSR_RM_RZ () {1;}' unless defined(&MIPS_FCSR_RM_RZ);
    eval 'sub MIPS_FCSR_RM_RP () {2;}' unless defined(&MIPS_FCSR_RM_RP);
    eval 'sub MIPS_FCSR_RM_RM () {3;}' unless defined(&MIPS_FCSR_RM_RM);
    eval 'sub MIPS_FCSR_FLAGS () { &__BITS(6,2);}' unless defined(&MIPS_FCSR_FLAGS);
    eval 'sub MIPS_FCSR_FLAGS_I () { &__BIT(2);}' unless defined(&MIPS_FCSR_FLAGS_I);
    eval 'sub MIPS_FCSR_FLAGS_U () { &__BIT(3);}' unless defined(&MIPS_FCSR_FLAGS_U);
    eval 'sub MIPS_FCSR_FLAGS_O () { &__BIT(4);}' unless defined(&MIPS_FCSR_FLAGS_O);
    eval 'sub MIPS_FCSR_FLAGS_Z () { &__BIT(5);}' unless defined(&MIPS_FCSR_FLAGS_Z);
    eval 'sub MIPS_FCSR_FLAGS_V () { &__BIT(6);}' unless defined(&MIPS_FCSR_FLAGS_V);
    eval 'sub MIPS_FCSR_ENABLES () { &__BITS(11,7);}' unless defined(&MIPS_FCSR_ENABLES);
    eval 'sub MIPS_FCSR_ENABLES_I () { &__BIT(7);}' unless defined(&MIPS_FCSR_ENABLES_I);
    eval 'sub MIPS_FCSR_ENABLES_U () { &__BIT(8);}' unless defined(&MIPS_FCSR_ENABLES_U);
    eval 'sub MIPS_FCSR_ENABLES_O () { &__BIT(9);}' unless defined(&MIPS_FCSR_ENABLES_O);
    eval 'sub MIPS_FCSR_ENABLES_Z () { &__BIT(10);}' unless defined(&MIPS_FCSR_ENABLES_Z);
    eval 'sub MIPS_FCSR_ENABLES_V () { &__BIT(11);}' unless defined(&MIPS_FCSR_ENABLES_V);
    eval 'sub MIPS_FCSR_CAUSE () { &__BITS(17,12);}' unless defined(&MIPS_FCSR_CAUSE);
    eval 'sub MIPS_FCSR_CAUSE_I () { &__BIT(12);}' unless defined(&MIPS_FCSR_CAUSE_I);
    eval 'sub MIPS_FCSR_CAUSE_U () { &__BIT(13);}' unless defined(&MIPS_FCSR_CAUSE_U);
    eval 'sub MIPS_FCSR_CAUSE_O () { &__BIT(14);}' unless defined(&MIPS_FCSR_CAUSE_O);
    eval 'sub MIPS_FCSR_CAUSE_Z () { &__BIT(15);}' unless defined(&MIPS_FCSR_CAUSE_Z);
    eval 'sub MIPS_FCSR_CAUSE_V () { &__BIT(16);}' unless defined(&MIPS_FCSR_CAUSE_V);
    eval 'sub MIPS_FCSR_CAUSE_E () { &__BIT(17);}' unless defined(&MIPS_FCSR_CAUSE_E);
    eval 'sub MIPS_FCSR_NAN_2008 () { &__BIT(18);}' unless defined(&MIPS_FCSR_NAN_2008);
    eval 'sub MIPS_FCSR_ABS_2008 () { &__BIT(19);}' unless defined(&MIPS_FCSR_ABS_2008);
    eval 'sub MIPS_FCSR_FCC0 () { &__BIT(23);}' unless defined(&MIPS_FCSR_FCC0);
    eval 'sub MIPS_FCSR_FCC () {( &MIPS_FPU_COND_BIT |  &__BITS(31,25));}' unless defined(&MIPS_FCSR_FCC);
    eval 'sub MIPS_FCSR_FS () { &__BIT(24);}' unless defined(&MIPS_FCSR_FS);
    eval 'sub MIPS_OPCODE_SHIFT () {26;}' unless defined(&MIPS_OPCODE_SHIFT);
    eval 'sub MIPS_OPCODE_C1 () {0x11;}' unless defined(&MIPS_OPCODE_C1);
    eval 'sub MIPS1_TLB_PFN () {0xfffff000;}' unless defined(&MIPS1_TLB_PFN);
    eval 'sub MIPS1_TLB_NON_CACHEABLE_BIT () {0x800;}' unless defined(&MIPS1_TLB_NON_CACHEABLE_BIT);
    eval 'sub MIPS1_TLB_DIRTY_BIT () {0x400;}' unless defined(&MIPS1_TLB_DIRTY_BIT);
    eval 'sub MIPS1_TLB_VALID_BIT () {0x200;}' unless defined(&MIPS1_TLB_VALID_BIT);
    eval 'sub MIPS1_TLB_GLOBAL_BIT () {0x100;}' unless defined(&MIPS1_TLB_GLOBAL_BIT);
    eval 'sub MIPS3_TLB_PFN () {0x3fffffc0;}' unless defined(&MIPS3_TLB_PFN);
    eval 'sub MIPS3_TLB_ATTR_MASK () {0x38;}' unless defined(&MIPS3_TLB_ATTR_MASK);
    eval 'sub MIPS3_TLB_ATTR_SHIFT () {3;}' unless defined(&MIPS3_TLB_ATTR_SHIFT);
    eval 'sub MIPS3_TLB_DIRTY_BIT () {0x4;}' unless defined(&MIPS3_TLB_DIRTY_BIT);
    eval 'sub MIPS3_TLB_VALID_BIT () {0x2;}' unless defined(&MIPS3_TLB_VALID_BIT);
    eval 'sub MIPS3_TLB_GLOBAL_BIT () {0x1;}' unless defined(&MIPS3_TLB_GLOBAL_BIT);
    eval 'sub MIPS1_TLB_PHYS_PAGE_SHIFT () {12;}' unless defined(&MIPS1_TLB_PHYS_PAGE_SHIFT);
    eval 'sub MIPS3_TLB_PHYS_PAGE_SHIFT () {6;}' unless defined(&MIPS3_TLB_PHYS_PAGE_SHIFT);
    eval 'sub MIPS1_TLB_PF_NUM () { &MIPS1_TLB_PFN;}' unless defined(&MIPS1_TLB_PF_NUM);
    eval 'sub MIPS3_TLB_PF_NUM () { &MIPS3_TLB_PFN;}' unless defined(&MIPS3_TLB_PF_NUM);
    eval 'sub MIPS1_TLB_MOD_BIT () { &MIPS1_TLB_DIRTY_BIT;}' unless defined(&MIPS1_TLB_MOD_BIT);
    eval 'sub MIPS3_TLB_MOD_BIT () { &MIPS3_TLB_DIRTY_BIT;}' unless defined(&MIPS3_TLB_MOD_BIT);
    eval 'sub MIPS3_TLB_ATTR_WT () {0;}' unless defined(&MIPS3_TLB_ATTR_WT);
    eval 'sub MIPS3_TLB_ATTR_WT_WRITEALLOCATE () {1;}' unless defined(&MIPS3_TLB_ATTR_WT_WRITEALLOCATE);
    eval 'sub MIPS3_TLB_ATTR_UNCACHED () {2;}' unless defined(&MIPS3_TLB_ATTR_UNCACHED);
    eval 'sub MIPS3_TLB_ATTR_WB_NONCOHERENT () {3;}' unless defined(&MIPS3_TLB_ATTR_WB_NONCOHERENT);
    eval 'sub MIPS3_TLB_ATTR_WB_EXCLUSIVE () {4;}' unless defined(&MIPS3_TLB_ATTR_WB_EXCLUSIVE);
    eval 'sub MIPS3_TLB_ATTR_WB_SHARABLE () {5;}' unless defined(&MIPS3_TLB_ATTR_WB_SHARABLE);
    eval 'sub MIPS3_TLB_ATTR_WB_UPDATE () {6;}' unless defined(&MIPS3_TLB_ATTR_WB_UPDATE);
    eval 'sub MIPS4_TLB_ATTR_UNCACHED_ACCELERATED () {7;}' unless defined(&MIPS4_TLB_ATTR_UNCACHED_ACCELERATED);
    eval 'sub MIPS1_TLB_VPN () {0xfffff000;}' unless defined(&MIPS1_TLB_VPN);
    eval 'sub MIPS1_TLB_PID () {0xfc0;}' unless defined(&MIPS1_TLB_PID);
    eval 'sub MIPS1_TLB_PID_SHIFT () {6;}' unless defined(&MIPS1_TLB_PID_SHIFT);
    eval 'sub MIPS3_TLB_VPN2 () {0xffffe000;}' unless defined(&MIPS3_TLB_VPN2);
    eval 'sub MIPS3_TLB_EHINV () {0x400;}' unless defined(&MIPS3_TLB_EHINV);
    eval 'sub MIPS3_TLB_ASID () {0xff;}' unless defined(&MIPS3_TLB_ASID);
    eval 'sub MIPS1_TLB_VIRT_PAGE_NUM () { &MIPS1_TLB_VPN;}' unless defined(&MIPS1_TLB_VIRT_PAGE_NUM);
    eval 'sub MIPS3_TLB_VIRT_PAGE_NUM () { &MIPS3_TLB_VPN2;}' unless defined(&MIPS3_TLB_VIRT_PAGE_NUM);
    eval 'sub MIPS3_TLB_PID () { &MIPS3_TLB_ASID;}' unless defined(&MIPS3_TLB_PID);
    eval 'sub MIPS_TLB_VIRT_PAGE_SHIFT () {12;}' unless defined(&MIPS_TLB_VIRT_PAGE_SHIFT);
    eval 'sub MIPS1_TLB_INDEX_SHIFT () {8;}' unless defined(&MIPS1_TLB_INDEX_SHIFT);
    eval 'sub MIPS1_TLB_FIRST_RAND_ENTRY () {8;}' unless defined(&MIPS1_TLB_FIRST_RAND_ENTRY);
    eval 'sub MIPS3_TLB_WIRED_UPAGES () {1;}' unless defined(&MIPS3_TLB_WIRED_UPAGES);
    eval 'sub MIPS1_TLB_NUM_PIDS () {64;}' unless defined(&MIPS1_TLB_NUM_PIDS);
    eval 'sub MIPS3_TLB_NUM_ASIDS () {256;}' unless defined(&MIPS3_TLB_NUM_ASIDS);
    if(((defined(&MIPS3) ? &MIPS3 : undef) + (defined(&MIPS4) ? &MIPS4 : undef) + (defined(&MIPS32) ? &MIPS32 : undef) + (defined(&MIPS32R2) ? &MIPS32R2 : undef) + (defined(&MIPS64) ? &MIPS64 : undef) + (defined(&MIPS64R2) ? &MIPS64R2 : undef)) == 0 && (defined(&MIPS1) ? &MIPS1 : undef) != 0) {
	eval 'sub MIPS_TLB_PID_SHIFT () { &MIPS1_TLB_PID_SHIFT;}' unless defined(&MIPS_TLB_PID_SHIFT);
	eval 'sub MIPS_TLB_PID () { &MIPS1_TLB_PID;}' unless defined(&MIPS_TLB_PID);
	eval 'sub MIPS_TLB_NUM_PIDS () { &MIPS1_TLB_NUM_PIDS;}' unless defined(&MIPS_TLB_NUM_PIDS);
    }
    if(((defined(&MIPS3) ? &MIPS3 : undef) + (defined(&MIPS4) ? &MIPS4 : undef) + (defined(&MIPS32) ? &MIPS32 : undef) + (defined(&MIPS32R2) ? &MIPS32R2 : undef) + (defined(&MIPS64) ? &MIPS64 : undef) + (defined(&MIPS64R2) ? &MIPS64R2 : undef)) != 0 && (defined(&MIPS1) ? &MIPS1 : undef) == 0) {
	eval 'sub MIPS_TLB_PID_SHIFT () {0;}' unless defined(&MIPS_TLB_PID_SHIFT);
	eval 'sub MIPS_TLB_PID () { &MIPS3_TLB_PID;}' unless defined(&MIPS_TLB_PID);
	eval 'sub MIPS_TLB_NUM_PIDS () { &MIPS3_TLB_NUM_ASIDS;}' unless defined(&MIPS_TLB_NUM_PIDS);
    }
    if(!defined(&MIPS_TLB_PID_SHIFT)) {
	eval 'sub MIPS_TLB_PID_SHIFT () {(( &MIPS_HAS_R4K_MMU) ? 0:  &MIPS1_TLB_PID_SHIFT);}' unless defined(&MIPS_TLB_PID_SHIFT);
	eval 'sub MIPS_TLB_PID () {(( &MIPS_HAS_R4K_MMU) ?  &MIPS3_TLB_PID :  &MIPS1_TLB_PID);}' unless defined(&MIPS_TLB_PID);
	eval 'sub MIPS_TLB_NUM_PIDS () {(( &MIPS_HAS_R4K_MMU) ?  &MIPS3_TLB_NUM_ASIDS :  &MIPS1_TLB_NUM_PIDS);}' unless defined(&MIPS_TLB_NUM_PIDS);
    }
    eval 'sub MIPS_WATCHLO_VADDR32 () { &__BITS(31,3);}' unless defined(&MIPS_WATCHLO_VADDR32);
    eval 'sub MIPS_WATCHLO_VADDR64 () { &__BITS(63,3);}' unless defined(&MIPS_WATCHLO_VADDR64);
    eval 'sub MIPS_WATCHLO_INSN () { &__BIT(2);}' unless defined(&MIPS_WATCHLO_INSN);
    eval 'sub MIPS_WATCHLO_DATA_READ () { &__BIT(1);}' unless defined(&MIPS_WATCHLO_DATA_READ);
    eval 'sub MIPS_WATCHLO_DATA_WRITE () { &__BIT(0);}' unless defined(&MIPS_WATCHLO_DATA_WRITE);
    eval 'sub MIPS_WATCHHI_M () { &__BIT(31);}' unless defined(&MIPS_WATCHHI_M);
    eval 'sub MIPS_WATCHHI_G () { &__BIT(30);}' unless defined(&MIPS_WATCHHI_G);
    eval 'sub MIPS_WATCHHI_EAS () { &__BITS(25,24);}' unless defined(&MIPS_WATCHHI_EAS);
    eval 'sub MIPS_WATCHHI_ASID () { &__BITS(23,16);}' unless defined(&MIPS_WATCHHI_ASID);
    eval 'sub MIPS_WATCHHI_MASK () { &__BITS(11,3);}' unless defined(&MIPS_WATCHHI_MASK);
    eval 'sub MIPS_WATCHHI_INSN () { &MIPS_WATCHLO_INSN;}' unless defined(&MIPS_WATCHHI_INSN);
    eval 'sub MIPS_WATCHHI_DATA_READ () { &MIPS_WATCHLO_DATA_READ;}' unless defined(&MIPS_WATCHHI_DATA_READ);
    eval 'sub MIPS_WATCHHI_DATA_WRITE () { &MIPS_WATCHLO_DATA_WRITE;}' unless defined(&MIPS_WATCHHI_DATA_WRITE);
    eval 'sub MIPS_HWR_CPUNUM () { &_(0);}' unless defined(&MIPS_HWR_CPUNUM);
    eval 'sub MIPS_HWR_SYNCI_STEP () { &_(1);}' unless defined(&MIPS_HWR_SYNCI_STEP);
    eval 'sub MIPS_HWR_CC () { &_(2);}' unless defined(&MIPS_HWR_CC);
    eval 'sub MIPS_HWR_CCRES () { &_(3);}' unless defined(&MIPS_HWR_CCRES);
    eval 'sub MIPS_HWR_ULR () { &_(29);}' unless defined(&MIPS_HWR_ULR);
    eval 'sub MIPS_HWR_IMPL30 () { &_(30);}' unless defined(&MIPS_HWR_IMPL30);
    eval 'sub MIPS_HWR_IMPL31 () { &_(31);}' unless defined(&MIPS_HWR_IMPL31);
    eval 'sub MIPS_HWRENA_IMPL31 () { &__BIT( &MIPS_HWR_IMPL31);}' unless defined(&MIPS_HWRENA_IMPL31);
    eval 'sub MIPS_HWRENA_IMPL30 () { &__BIT( &MIPS_HWR_IMPL30);}' unless defined(&MIPS_HWRENA_IMPL30);
    eval 'sub MIPS_HWRENA_ULR () { &__BIT( &MIPS_HWR_ULR);}' unless defined(&MIPS_HWRENA_ULR);
    eval 'sub MIPS_HWRENA_CCRES () { &__BIT( &MIPS_HWR_CCRES);}' unless defined(&MIPS_HWRENA_CCRES);
    eval 'sub MIPS_HWRENA_CC () { &__BIT( &MIPS_HWR_CC);}' unless defined(&MIPS_HWRENA_CC);
    eval 'sub MIPS_HWRENA_SYNCI_STEP () { &__BIT( &MIPS_HWR_SYNCI_STEP);}' unless defined(&MIPS_HWRENA_SYNCI_STEP);
    eval 'sub MIPS_HWRENA_CPUNUM () { &__BIT( &MIPS_HWR_CPUNUM);}' unless defined(&MIPS_HWRENA_CPUNUM);
    eval 'sub MIPS_EBASE_EXC_BASE_SHIFT () {12;}' unless defined(&MIPS_EBASE_EXC_BASE_SHIFT);
    eval 'sub MIPS_EBASE_EXC_BASE () { &__BITS(29,  &MIPS_EBASE_EXC_BASE_SHIFT);}' unless defined(&MIPS_EBASE_EXC_BASE);
    eval 'sub MIPS_EBASE_CPUNUM () { &__BITS(9, 0);}' unless defined(&MIPS_EBASE_CPUNUM);
    eval 'sub MIPS_EBASE_CPUNUM_WIDTH () {10;}' unless defined(&MIPS_EBASE_CPUNUM_WIDTH);
    eval 'sub PREF_LOAD () {0;}' unless defined(&PREF_LOAD);
    eval 'sub PREF_LOAD_STREAMED () {4;}' unless defined(&PREF_LOAD_STREAMED);
    eval 'sub PREF_LOAD_RETAINED () {6;}' unless defined(&PREF_LOAD_RETAINED);
    eval 'sub PREF_STORE () {1;}' unless defined(&PREF_STORE);
    eval 'sub PREF_STORE_STREAMED () {5;}' unless defined(&PREF_STORE_STREAMED);
    eval 'sub PREF_STORE_RETAINED () {7;}' unless defined(&PREF_STORE_RETAINED);
    eval 'sub PREF_WB_INV () {25;}' unless defined(&PREF_WB_INV);
    eval 'sub PREF_NUDGE () { &PREF_WB_INV;}' unless defined(&PREF_NUDGE);
    eval 'sub PREF_PREPAREFORSTORE () {30;}' unless defined(&PREF_PREPAREFORSTORE);
    eval 'sub MIPS_R2000 () {0x1;}' unless defined(&MIPS_R2000);
    eval 'sub MIPS_R3000 () {0x2;}' unless defined(&MIPS_R3000);
    eval 'sub MIPS_R6000 () {0x3;}' unless defined(&MIPS_R6000);
    eval 'sub MIPS_R4000 () {0x4;}' unless defined(&MIPS_R4000);
    eval 'sub MIPS_R3LSI () {0x5;}' unless defined(&MIPS_R3LSI);
    eval 'sub MIPS_R6000A () {0x6;}' unless defined(&MIPS_R6000A);
    eval 'sub MIPS_R3IDT () {0x7;}' unless defined(&MIPS_R3IDT);
    eval 'sub MIPS_R10000 () {0x9;}' unless defined(&MIPS_R10000);
    eval 'sub MIPS_R4200 () {0xa;}' unless defined(&MIPS_R4200);
    eval 'sub MIPS_R4300 () {0xb;}' unless defined(&MIPS_R4300);
    eval 'sub MIPS_R4100 () {0xc;}' unless defined(&MIPS_R4100);
    eval 'sub MIPS_R12000 () {0xe;}' unless defined(&MIPS_R12000);
    eval 'sub MIPS_R14000 () {0xf;}' unless defined(&MIPS_R14000);
    eval 'sub MIPS_R8000 () {0x10;}' unless defined(&MIPS_R8000);
    eval 'sub MIPS_RC32300 () {0x18;}' unless defined(&MIPS_RC32300);
    eval 'sub MIPS_R4600 () {0x20;}' unless defined(&MIPS_R4600);
    eval 'sub MIPS_R4700 () {0x21;}' unless defined(&MIPS_R4700);
    eval 'sub MIPS_R3SONY () {0x21;}' unless defined(&MIPS_R3SONY);
    eval 'sub MIPS_R4650 () {0x22;}' unless defined(&MIPS_R4650);
    eval 'sub MIPS_TX3900 () {0x22;}' unless defined(&MIPS_TX3900);
    eval 'sub MIPS_R5000 () {0x23;}' unless defined(&MIPS_R5000);
    eval 'sub MIPS_R3NKK () {0x23;}' unless defined(&MIPS_R3NKK);
    eval 'sub MIPS_RC32364 () {0x26;}' unless defined(&MIPS_RC32364);
    eval 'sub MIPS_RM7000 () {0x27;}' unless defined(&MIPS_RM7000);
    eval 'sub MIPS_RM5200 () {0x28;}' unless defined(&MIPS_RM5200);
    eval 'sub MIPS_TX4900 () {0x2d;}' unless defined(&MIPS_TX4900);
    eval 'sub MIPS_R5900 () {0x2e;}' unless defined(&MIPS_R5900);
    eval 'sub MIPS_RC64470 () {0x30;}' unless defined(&MIPS_RC64470);
    eval 'sub MIPS_TX7900 () {0x38;}' unless defined(&MIPS_TX7900);
    eval 'sub MIPS_R5400 () {0x54;}' unless defined(&MIPS_R5400);
    eval 'sub MIPS_R5500 () {0x55;}' unless defined(&MIPS_R5500);
    eval 'sub MIPS_LOONGSON2 () {0x63;}' unless defined(&MIPS_LOONGSON2);
    eval 'sub MIPS_REV_R2000A () {0x16;}' unless defined(&MIPS_REV_R2000A);
    eval 'sub MIPS_REV_R3000 () {0x20;}' unless defined(&MIPS_REV_R3000);
    eval 'sub MIPS_REV_R3000A () {0x30;}' unless defined(&MIPS_REV_R3000A);
    eval 'sub MIPS_REV_TX3912 () {0x10;}' unless defined(&MIPS_REV_TX3912);
    eval 'sub MIPS_REV_TX3922 () {0x30;}' unless defined(&MIPS_REV_TX3922);
    eval 'sub MIPS_REV_TX3927 () {0x40;}' unless defined(&MIPS_REV_TX3927);
    eval 'sub MIPS_REV_R4000_A () {0x;}' unless defined(&MIPS_REV_R4000_A);
    eval 'sub MIPS_REV_R4000_B () {0x22;}' unless defined(&MIPS_REV_R4000_B);
    eval 'sub MIPS_REV_R4000_C () {0x30;}' unless defined(&MIPS_REV_R4000_C);
    eval 'sub MIPS_REV_R4400_A () {0x40;}' unless defined(&MIPS_REV_R4400_A);
    eval 'sub MIPS_REV_R4400_B () {0x50;}' unless defined(&MIPS_REV_R4400_B);
    eval 'sub MIPS_REV_R4400_C () {0x60;}' unless defined(&MIPS_REV_R4400_C);
    eval 'sub MIPS_REV_TX4927 () {0x22;}' unless defined(&MIPS_REV_TX4927);
    eval 'sub MIPS_REV_LOONGSON2E () {0x2;}' unless defined(&MIPS_REV_LOONGSON2E);
    eval 'sub MIPS_REV_LOONGSON2F () {0x3;}' unless defined(&MIPS_REV_LOONGSON2F);
    eval 'sub MIPS_4Kc () {0x80;}' unless defined(&MIPS_4Kc);
    eval 'sub MIPS_5Kc () {0x81;}' unless defined(&MIPS_5Kc);
    eval 'sub MIPS_20Kc () {0x82;}' unless defined(&MIPS_20Kc);
    eval 'sub MIPS_4Kmp () {0x83;}' unless defined(&MIPS_4Kmp);
    eval 'sub MIPS_4KEc () {0x84;}' unless defined(&MIPS_4KEc);
    eval 'sub MIPS_4KEmp () {0x85;}' unless defined(&MIPS_4KEmp);
    eval 'sub MIPS_4KSc () {0x86;}' unless defined(&MIPS_4KSc);
    eval 'sub MIPS_M4K () {0x87;}' unless defined(&MIPS_M4K);
    eval 'sub MIPS_25Kf () {0x88;}' unless defined(&MIPS_25Kf);
    eval 'sub MIPS_5KE () {0x89;}' unless defined(&MIPS_5KE);
    eval 'sub MIPS_4KEc_R2 () {0x90;}' unless defined(&MIPS_4KEc_R2);
    eval 'sub MIPS_4KEmp_R2 () {0x91;}' unless defined(&MIPS_4KEmp_R2);
    eval 'sub MIPS_4KSd () {0x92;}' unless defined(&MIPS_4KSd);
    eval 'sub MIPS_24K () {0x93;}' unless defined(&MIPS_24K);
    eval 'sub MIPS_34K () {0x95;}' unless defined(&MIPS_34K);
    eval 'sub MIPS_24KE () {0x96;}' unless defined(&MIPS_24KE);
    eval 'sub MIPS_74K () {0x97;}' unless defined(&MIPS_74K);
    eval 'sub MIPS_1004K () {0x99;}' unless defined(&MIPS_1004K);
    eval 'sub MIPS_1074K () {0x9a;}' unless defined(&MIPS_1074K);
    eval 'sub MIPS_interAptiv () {0xa1;}' unless defined(&MIPS_interAptiv);
    eval 'sub MIPS_BCM3302 () {0x90;}' unless defined(&MIPS_BCM3302);
    eval 'sub MIPS_AU_REV1 () {0x1;}' unless defined(&MIPS_AU_REV1);
    eval 'sub MIPS_AU_REV2 () {0x2;}' unless defined(&MIPS_AU_REV2);
    eval 'sub MIPS_AU1000 () {0x;}' unless defined(&MIPS_AU1000);
    eval 'sub MIPS_AU1500 () {0x1;}' unless defined(&MIPS_AU1500);
    eval 'sub MIPS_AU1100 () {0x2;}' unless defined(&MIPS_AU1100);
    eval 'sub MIPS_AU1550 () {0x3;}' unless defined(&MIPS_AU1550);
    eval 'sub MIPS_SB1 () {0x1;}' unless defined(&MIPS_SB1);
    eval 'sub MIPS_SB1_11 () {0x11;}' unless defined(&MIPS_SB1_11);
    eval 'sub MIPS_SR7100 () {0x4;}' unless defined(&MIPS_SR7100);
    eval 'sub MIPS_XLR_B2 () {0x4;}' unless defined(&MIPS_XLR_B2);
    eval 'sub MIPS_XLR_C4 () {0x91;}' unless defined(&MIPS_XLR_C4);
    eval 'sub MIPS_XLR308B () {0x6;}' unless defined(&MIPS_XLR308B);
    eval 'sub MIPS_XLR508B () {0x7;}' unless defined(&MIPS_XLR508B);
    eval 'sub MIPS_XLR516B () {0x8;}' unless defined(&MIPS_XLR516B);
    eval 'sub MIPS_XLR532B () {0x9;}' unless defined(&MIPS_XLR532B);
    eval 'sub MIPS_XLR716B () {0xa;}' unless defined(&MIPS_XLR716B);
    eval 'sub MIPS_XLR732B () {0xb;}' unless defined(&MIPS_XLR732B);
    eval 'sub MIPS_XLR732C () {0x;}' unless defined(&MIPS_XLR732C);
    eval 'sub MIPS_XLR716C () {0x2;}' unless defined(&MIPS_XLR716C);
    eval 'sub MIPS_XLR532C () {0x8;}' unless defined(&MIPS_XLR532C);
    eval 'sub MIPS_XLR516C () {0xa;}' unless defined(&MIPS_XLR516C);
    eval 'sub MIPS_XLR508C () {0xb;}' unless defined(&MIPS_XLR508C);
    eval 'sub MIPS_XLR308C () {0xf;}' unless defined(&MIPS_XLR308C);
    eval 'sub MIPS_XLS616 () {0x40;}' unless defined(&MIPS_XLS616);
    eval 'sub MIPS_XLS416 () {0x44;}' unless defined(&MIPS_XLS416);
    eval 'sub MIPS_XLS608 () {0x4a;}' unless defined(&MIPS_XLS608);
    eval 'sub MIPS_XLS408 () {0x4e;}' unless defined(&MIPS_XLS408);
    eval 'sub MIPS_XLS404 () {0x4f;}' unless defined(&MIPS_XLS404);
    eval 'sub MIPS_XLS408LITE () {0x88;}' unless defined(&MIPS_XLS408LITE);
    eval 'sub MIPS_XLS404LITE () {0x8c;}' unless defined(&MIPS_XLS404LITE);
    eval 'sub MIPS_XLS208 () {0x8e;}' unless defined(&MIPS_XLS208);
    eval 'sub MIPS_XLS204 () {0x8f;}' unless defined(&MIPS_XLS204);
    eval 'sub MIPS_XLS108 () {0xce;}' unless defined(&MIPS_XLS108);
    eval 'sub MIPS_XLS104 () {0xcf;}' unless defined(&MIPS_XLS104);
    eval 'sub MIPS_CN38XX () {0x;}' unless defined(&MIPS_CN38XX);
    eval 'sub MIPS_CN31XX () {0x1;}' unless defined(&MIPS_CN31XX);
    eval 'sub MIPS_CN30XX () {0x2;}' unless defined(&MIPS_CN30XX);
    eval 'sub MIPS_CN58XX () {0x3;}' unless defined(&MIPS_CN58XX);
    eval 'sub MIPS_CN56XX () {0x4;}' unless defined(&MIPS_CN56XX);
    eval 'sub MIPS_CN50XX () {0x6;}' unless defined(&MIPS_CN50XX);
    eval 'sub MIPS_CN52XX () {0x7;}' unless defined(&MIPS_CN52XX);
    eval 'sub MIPS_CN63XX () {0x90;}' unless defined(&MIPS_CN63XX);
    eval 'sub MIPS_CN68XX () {0x91;}' unless defined(&MIPS_CN68XX);
    eval 'sub MIPS_CN66XX () {0x92;}' unless defined(&MIPS_CN66XX);
    eval 'sub MIPS_CN61XX () {0x93;}' unless defined(&MIPS_CN61XX);
    eval 'sub MIPS_CNF71XX () {0x94;}' unless defined(&MIPS_CNF71XX);
    eval 'sub MIPS_CN78XX () {0x95;}' unless defined(&MIPS_CN78XX);
    eval 'sub MIPS_CN70XX () {0x96;}' unless defined(&MIPS_CN70XX);
    eval 'sub MIPS_CN73XX () {0x97;}' unless defined(&MIPS_CN73XX);
    eval 'sub MIPS_CNF75XX () {0x98;}' unless defined(&MIPS_CNF75XX);
    eval 'sub MIPS_eMIPS () {0x4;}' unless defined(&MIPS_eMIPS);
    eval 'sub MIPS_XBURST () {0x2;}' unless defined(&MIPS_XBURST);
    eval 'sub MIPS_SOFT () {0x;}' unless defined(&MIPS_SOFT);
    eval 'sub MIPS_R2360 () {0x1;}' unless defined(&MIPS_R2360);
    eval 'sub MIPS_R2010 () {0x2;}' unless defined(&MIPS_R2010);
    eval 'sub MIPS_R3010 () {0x3;}' unless defined(&MIPS_R3010);
    eval 'sub MIPS_R6010 () {0x4;}' unless defined(&MIPS_R6010);
    eval 'sub MIPS_R4010 () {0x5;}' unless defined(&MIPS_R4010);
    eval 'sub MIPS_R31LSI () {0x6;}' unless defined(&MIPS_R31LSI);
    eval 'sub MIPS_R3TOSH () {0x22;}' unless defined(&MIPS_R3TOSH);
    if(defined(&ENABLE_MIPS_TX3900)) {
	require 'mips/r3900regs.ph';
    }
    if(defined(&MIPS64_SB1)) {
	require 'mips/sb1regs.ph';
    }
    if(defined(&MIPS64_XLP) || defined(&MIPS64_XLR) || defined(&MIPS64_XLS)) {
	require 'mips/rmi/rmixlreg.ph';
    }
    if(defined(&MIPS3_LOONGSON2)) {
	eval 'sub LOONGSON_AWR_BASE_ADDRESS () {0x3ff00000;}' unless defined(&LOONGSON_AWR_BASE_ADDRESS);
	eval 'sub LOONGSON_AWR_BASE {
	    my($master, $window) = @_;
    	    eval q(( &LOONGSON_AWR_BASE_ADDRESS + ($window) * 0x8 + ($master) * 0x60 + 0x));
	}' unless defined(&LOONGSON_AWR_BASE);
	eval 'sub LOONGSON_AWR_SIZE {
	    my($master, $window) = @_;
    	    eval q(( &LOONGSON_AWR_BASE_ADDRESS + ($window) * 0x8 + ($master) * 0x60 + 0x20));
	}' unless defined(&LOONGSON_AWR_SIZE);
	eval 'sub LOONGSON_AWR_MMAP {
	    my($master, $window) = @_;
    	    eval q(( &LOONGSON_AWR_BASE_ADDRESS + ($window) * 0x8 + ($master) * 0x60 + 0x40));
	}' unless defined(&LOONGSON_AWR_MMAP);
	eval 'sub COP_0_DIAG_ITLB_CLEAR () {0x4;}' unless defined(&COP_0_DIAG_ITLB_CLEAR);
	eval 'sub COP_0_DIAG_BTB_CLEAR () {0x2;}' unless defined(&COP_0_DIAG_BTB_CLEAR);
	eval 'sub COP_0_DIAG_RAS_DISABLE () {0x1;}' unless defined(&COP_0_DIAG_RAS_DISABLE);
    }
}
1;
