/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public abstract class NavigationComponentHelper {
    private int _rolloverRow = -1;
    private Point _mousePosition = null;

    protected abstract Rectangle getRowBounds(int var1);

    protected abstract int rowAtPoint(Point var1);

    protected abstract int[] getSelectedRows();

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void paint(Graphics g, JComponent c) {
        int[] rows;
        if (this._rolloverRow != -1) {
            this.paintRolloverRow(g, c, this._rolloverRow);
        }
        if ((rows = this.getSelectedRows()) != null) {
            for (int row : rows) {
                this.paintSelectedRow(g, c, row);
            }
        }
    }

    protected void paintSelectedRow(Graphics g, JComponent c, int row) {
        Color selectedColor = this.getSelectionColor(c);
        Rectangle bounds = this.getRowBounds(row);
        if (bounds != null) {
            --bounds.width;
            --bounds.height;
            this.paintRow(g, row, bounds, selectedColor, 30, 70, 50, 128);
        }
    }

    protected Color getSelectionColor(JComponent c) {
        Color selectedColor = UIManager.getColor("NavigationComponent.selectionBackground");
        if (selectedColor == null) {
            selectedColor = UIManager.getColor("Tree.selectionBackground");
        }
        if (!c.hasFocus() && Color.WHITE.equals(selectedColor = ColorUtils.toGrayscale(selectedColor).brighter())) {
            selectedColor = new Color(202, 202, 202);
        }
        return selectedColor;
    }

    protected void paintRolloverRow(Graphics g, JComponent c, int row) {
        Color selectedColor = UIManager.getColor("Tree.selectionBackground");
        Rectangle bounds = this.getRowBounds(row);
        if (bounds != null) {
            --bounds.width;
            --bounds.height;
            this.paintRow(g, row, bounds, selectedColor, 10, 40, 20, 100);
        }
    }

    private void paintRow(Graphics g, int row, Rectangle bounds, Color color, int a1, int a2, int a3, int a4) {
        Object o = JideSwingUtilities.setupShapeAntialiasing(g);
        ((Graphics2D)g).setPaint(new LinearGradientPaint(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height, new float[]{0.5f, 0.95f, 1.0f}, new Color[]{new Color(color.getRed(), color.getGreen(), color.getBlue(), a1), new Color(color.getRed(), color.getGreen(), color.getBlue(), a2), new Color(color.getRed(), color.getGreen(), color.getBlue(), a3)}, MultipleGradientPaint.CycleMethod.NO_CYCLE));
        int cornerSize = 5;
        g.fillRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, cornerSize, cornerSize);
        g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), a4));
        g.drawRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, cornerSize, cornerSize);
        JideSwingUtilities.restoreShapeAntialiasing(g, o);
    }

    public void setup(final JComponent c) {
        MouseInputAdapter inputAdapter = new MouseInputAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (c != null) {
                    Rectangle bounds;
                    NavigationComponentHelper.this._mousePosition = null;
                    int old = NavigationComponentHelper.this._rolloverRow;
                    NavigationComponentHelper.this._rolloverRow = -1;
                    if (old != -1 && (bounds = NavigationComponentHelper.this.getRowBounds(old)) != null) {
                        c.repaint(bounds);
                    }
                }
                NavigationComponentHelper.this.mouseExited(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                NavigationComponentHelper.this.mouseEntered(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                NavigationComponentHelper.this.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                NavigationComponentHelper.this.mouseReleased(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                NavigationComponentHelper.this.mouseClicked(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (c != null) {
                    int row = NavigationComponentHelper.this.rowAtPoint(e.getPoint());
                    if (row != -1) {
                        Rectangle bounds = NavigationComponentHelper.this.getRowBounds(row);
                        if (c instanceof JTree) {
                            int maxIconSize;
                            int n = maxIconSize = bounds != null ? bounds.height : ((JTree)c).getRowHeight();
                            if (NavigationComponentHelper.this._mousePosition != null) {
                                c.repaint(new Rectangle(((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.x - maxIconSize, ((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.y - maxIconSize, 2 * maxIconSize, 2 * maxIconSize));
                            }
                            NavigationComponentHelper.this._mousePosition = e.getPoint();
                            if (NavigationComponentHelper.this._mousePosition != null) {
                                c.repaint(new Rectangle(((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.x - maxIconSize, ((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.y - maxIconSize, 2 * maxIconSize, 2 * maxIconSize));
                            }
                        }
                        if (NavigationComponentHelper.this._rolloverRow != row) {
                            Rectangle oldBounds;
                            int old = NavigationComponentHelper.this._rolloverRow;
                            NavigationComponentHelper.this._rolloverRow = row;
                            if (old != -1 && (oldBounds = NavigationComponentHelper.this.getRowBounds(old)) != null) {
                                c.repaint(oldBounds);
                            }
                            if (bounds != null) {
                                c.repaint(bounds);
                            }
                        }
                    } else {
                        Rectangle bounds;
                        int old = NavigationComponentHelper.this._rolloverRow;
                        NavigationComponentHelper.this._rolloverRow = -1;
                        if (old != -1 && (bounds = NavigationComponentHelper.this.getRowBounds(old)) != null) {
                            c.repaint(bounds);
                        }
                    }
                }
                NavigationComponentHelper.this.mouseMoved(e);
            }
        };
        c.addMouseMotionListener(inputAdapter);
        c.addMouseListener(inputAdapter);
        c.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                NavigationComponentHelper.this.repaintSelections(c);
                NavigationComponentHelper.this.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                NavigationComponentHelper.this.repaintSelections(c);
                NavigationComponentHelper.this.focusLost(e);
            }
        });
    }

    public void repaintSelections(JComponent c) {
        Rectangle bounds;
        int[] rows = this.getSelectedRows();
        if (rows != null) {
            for (int row : rows) {
                Rectangle bounds2 = this.getRowBounds(row);
                if (bounds2 == null) continue;
                bounds2.x = 0;
                bounds2.width = c.getWidth();
                c.repaint(bounds2);
            }
        }
        if (this._rolloverRow != -1 && (bounds = this.getRowBounds(this._rolloverRow)) != null) {
            c.repaint(bounds);
        }
    }

    public int getRolloverRow() {
        return this._rolloverRow;
    }

    public void setRolloverRow(int rolloverRow) {
        this._rolloverRow = rolloverRow;
    }

    public Point getMousePosition() {
        return this._mousePosition;
    }
}

