/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CRAMBAIIndexer;
import htsjdk.samtools.CRAMContainerStreamWriter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.structure.CRAMEncodingStrategy;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.Log;
import java.io.OutputStream;

public class CRAMFileWriter
extends SAMFileWriterImpl {
    private final CRAMContainerStreamWriter cramContainerStream;
    private final SAMFileHeader samFileHeader;
    private final String fileName;
    private static final Log log = Log.getInstance(CRAMFileWriter.class);

    public CRAMFileWriter(OutputStream outputStream, CRAMReferenceSource referenceSource, SAMFileHeader samFileHeader, String fileName) {
        this(outputStream, null, referenceSource, samFileHeader, fileName);
    }

    public CRAMFileWriter(OutputStream outputStream, OutputStream indexOS, CRAMReferenceSource referenceSource, SAMFileHeader samFileHeader, String fileName) {
        this(outputStream, indexOS, true, referenceSource, samFileHeader, fileName);
    }

    public CRAMFileWriter(OutputStream outputStream, OutputStream indexOS, boolean presorted, CRAMReferenceSource referenceSource, SAMFileHeader samFileHeader, String fileName) {
        this(new CRAMEncodingStrategy(), outputStream, indexOS, presorted, referenceSource, samFileHeader, fileName);
    }

    public CRAMFileWriter(CRAMEncodingStrategy encodingStrategy, OutputStream outputStream, OutputStream indexOS, boolean presorted, CRAMReferenceSource referenceSource, SAMFileHeader samFileHeader, String fileName) {
        if (outputStream == null) {
            throw new IllegalArgumentException("CRAMWriter output stream can not be null.");
        }
        if (referenceSource == null) {
            throw new IllegalArgumentException("A reference is required for CRAM writers");
        }
        if (samFileHeader == null) {
            throw new IllegalArgumentException("A valid SAMFileHeader is required for CRAM writers");
        }
        this.samFileHeader = samFileHeader;
        this.fileName = fileName;
        this.setSortOrder(samFileHeader.getSortOrder(), presorted);
        this.cramContainerStream = new CRAMContainerStreamWriter(encodingStrategy, referenceSource, samFileHeader, outputStream, indexOS == null ? null : new CRAMBAIIndexer(indexOS, samFileHeader), fileName);
        this.setHeader(samFileHeader);
    }

    @Override
    protected void writeAlignment(SAMRecord alignment) {
        this.cramContainerStream.writeAlignment(alignment);
    }

    @Override
    protected void writeHeader(String textHeader) {
        this.writeHeader(new SAMTextHeaderCodec().decode(BufferedLineReader.fromString(textHeader), this.fileName != null ? this.fileName : null));
    }

    @Override
    protected void writeHeader(SAMFileHeader header) {
        if (!header.equals(this.samFileHeader)) {
            throw new IllegalArgumentException("Attempt to write a differetn file header than was previously provided");
        }
        this.cramContainerStream.writeHeader();
    }

    @Override
    protected void finish() {
        this.cramContainerStream.finish(true);
    }

    @Override
    protected String getFilename() {
        return this.fileName;
    }
}

