/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributors: Jason Day <jasonday@worldnet.att.net>
 *               Reinhold Kainhofer (reinhold@kainhofer.com)
 *
 */

#ifndef __LIBMAL_H__
#define __LIBMAL_H__

#define LIBMAL_VERSION 0
#define LIBMAL_MAJOR   43
#define LIBMAL_MINOR   ""


#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>

#include <AGUtil.h>
#include <AGClientProcessor.h>
#include <AGProtocol.h>
#include <AGBufferReader.h>
#include <AGPalmProtocol.h>
#include <AGUserConfig.h>
#include <AGServerConfig.h>
#include <AGSyncCommon.h>
#include <AGCommandProcessor.h>
#include <AGDesktopInfoPalm.h>
#include <AGTimeoutMessageBox.h>
#include <AGMobileLinkSettings.h>
#include <AGMD5.h>

#include <pi-source.h>
#include <pi-socket.h>
#include <pi-file.h>
#include <pi-dlp.h>
#include <pi-version.h>

#define DEFAULT_CARD_NUM 0

#define VERSION_STRING "malsync version 2.2.0"


typedef struct {
    AGDeviceInfo *deviceInfo;
    AGUserConfig *userConfig;
    AGServerConfig *currentServerConfig;
    AGClientProcessor *clientProcessor;
    AGPlatformCalls *platform;
    AGRecord *record;
    AGDBConfig *currentDb;
    AGCommandProcessor *commandProcessor;
    AGBool quit;

    /* For .sub files -- JLD */
    char *subBuf;
    long subBufferSize;
    AGBool sentCommand;

    /* Pilot-specific */
    AGBool currentDBIsResourceType;
    int pilot_rHandle;
    int pilot_RecIndex;
    recordid_t id;

    /* pilot-link >= 0.12 */
    pi_buffer_t *pi_buf;

    /* pilot-link 0.11 */
    uint8  *pilot_buffer;
    int pilot_buffer_size;

    /* Secure Network Library Stuff */
    AGBool          hasseclib;

    /* libmal stuff */
    int sd;
    int threeone;
    int lowres;
    char *device;
    char *httpProxy;
    int   httpProxyPort;
    char *socksProxy;
    int   socksProxyPort;
    char *proxyUsername;
    char *proxyPassword;

    /* callbacks */
    AGPerformTaskFunc taskFunc;
    AGPerformItemFunc itemFunc;

} PalmSyncInfo;

extern int lm_errno;
#define LM_EXIT_CANCEL        1
#define LM_USER_CONFIG        2
#define LM_SYNC_INFO          3
#define LM_READ_SYS_INFO      4
#define LM_READ_STORAGE_INFO  5
#define LM_READ_RECORD        6
#define LM_CLIENT             7
#define LM_CREATE_DB          8

/* ----------------------------------------------------------------------------*/
/* Malsync security lib functions */

typedef sword (*netInitFunc)(AGNetCtx *ctx);
typedef sword (*netCloseFunc)(AGNetCtx *ctx);
typedef int32 (*netCtxSizeFunc)(void);
typedef void  (*netPreSyncHook) (AGNetCtx *ctx,
                                 AGServerConfig *sc,
                                 AGLocationConfig *lc,
                                 AGSyncProcessor *sp,
                                 AGBool connectSecure);
typedef void  (*netPostSyncHook) (AGNetCtx *ctx,
                                  AGServerConfig *sc,
                                  AGLocationConfig *lc,
                                  AGSyncProcessor *sp,
                                  AGBool connectSecure);


/* ----------------------------------------------------------------------------*/
/* Function Prototypes */


PalmSyncInfo *syncInfoNew (void);
void syncInfoFree (PalmSyncInfo * pInfo);
void Connect (PalmSyncInfo *pi);
void Disconnect (PalmSyncInfo *pi);
int loadSecLib (void);
int malsync (PalmSyncInfo *pInfo);

#ifdef __cplusplus
}
#endif
#endif /* __LIBMAL_H__ */
