dnl # $Id: libcomprex.m4.in,v 1.4 2002/10/20 07:47:09 chipx86 Exp $

dnl # Configure paths for comprex

dnl AM_PATH_COMPREX([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for COMPREX, and define COMPREX_CFLAGS and COMPREX_LIBS
dnl
AC_DEFUN(AM_PATH_COMPREX,
[dnl
dnl Get the cflags and libraries from the comprex-config script
dnl
AC_ARG_WITH(comprex-prefix,[  --with-comprex-prefix=PFX  Prefix where comprex is installed (optional)],
		comprex_config_prefix="$withval", comprex_config_prefix="")
AC_ARG_WITH(comprex-exec-prefix,[  --with-comprex-exec-prefix=PFX  Exec prefix where comprex is installed (optional)],
		comprex_config_exec_prefix="$withval", comprex_config_exec_prefix="")
AC_ARG_ENABLE(comprextest, [  --disable-comprextest  Do not try to compile and run a test comprex program],
		, enable_comprextest=yes)

	if test x$comprex_config_exec_prefix != x ; then
		comprex_config_args="$comprex_config_args --exec-prefix=$comprex_config_exec_prefix"
		if test x${COMPREX_CONFIG+set} != xset ; then
			COMPREX_CONFIG=$comprex_config_exec_prefix/bin/comprex-config
		fi
	fi
	if test x$comprex_config_prefix != x ; then
		comprex_config_args="$comprex_config_args --prefix=$comprex_config_prefix"
		if test x${COMPREX_CONFIG+set} != xset ; then
			COMPREX_CONFIG=$comprex_config_prefix/bin/comprex-config
		fi
	fi

	AC_PATH_PROG(COMPREX_CONFIG, comprex-config, no)

	min_comprex_version=ifelse([$1], , 0.3.3, $1)
	AC_MSG_CHECKING([for libcomprex - version >= $min_comprex_version])
	no_comprex=""
	if test "$COMPREX_CONFIG" = "no" ; then
		no_comprex=yes
	else
		COMPREX_CFLAGS=`$COMPREX_CONFIG $comprex_config_args --cflags`
		COMPREX_LIBS=`$COMPREX_CONFIG $comprex_config_args --libs`
		comprex_config_major_version=`$COMPREX_CONFIG $comprex_config_args --version | \
			sed 's/[[^0-9]]*\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
		comprex_config_minor_version=`$COMPREX_CONFIG $comprex_config_args --version | \
			sed 's/[[^0-9]]*\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
		comprex_config_micro_version=`$COMPREX_CONFIG $comprex_config_args --version | \
			sed 's/[[^0-9]]*\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
		if test "x$enable_comprextest" = "xyes" ; then
			ac_save_CFLAGS="$CFLAGS"
			ac_save_LIBS="$LIBS"
			CFLAGS="$CFLAGS $COMPREX_CFLAGS"
			LIBS="$COMPREX_LIBS $LIBS"
dnl
dnl Now check if the installed comprex is sufficiently new.
dnl (Also sanity checks the results of comprex-config to some extent.)
dnl
			rm -f conf.comprextest
			AC_TRY_RUN([
#include <libcomprex/comprex.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char *my_strdup(char *str)
{
	char *new_str;

	if (str)
	{
		new_str = (char *)malloc((strlen(str) + 1) * sizeof(char));
		strcpy(new_str, str);
	}
	else
		new_str = NULL;

	return new_str;
}

int main()
{
	int major, minor, micro;
	char *tmp_version;

	system("touch conf.comprextest");

	/* HP/UX 9 (%@#!) writes to sscanf strings */
	tmp_version = my_strdup("$min_comprex_version");
	if (sscanf(tmp_version, "%d.%d.%d", &major, &minor,&micro) != 3) {
		printf("%s, bad version string\n", "$min_comprex_version");
		exit(1);
	}

	if (($comprex_config_major_version  > major) ||
	   (($comprex_config_major_version == major) && ($comprex_config_minor_version  > minor)) ||
	   (($comprex_config_major_version == major) && ($comprex_config_minor_version == minor) &&
	    ($comprex_config_micro_version >= micro)))
	{
		return 0;
	}
	else
	{
		printf("\n*** 'comprex-config --version' returned %d.%d.%d, but comprex (%d.%d.%d)\n",
		       $comprex_config_major_version, $comprex_config_minor_version, $comprex_config_micro_version,
		       major, minor, micro);
		printf("*** was found! If comprex-config was correct, then it is best\n");
		printf("*** to remove the old version of comprex. You may also be able to fix the error\n");
		printf("*** by modifying your LD_LIBRARY_PATH environment variable, or by editing\n");
		printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
		printf("*** required on your system.\n");
		printf("*** If comprex-config was wrong, set the environment variable COMPREX_CONFIG\n");
		printf("*** to point to the correct copy of comprex-config, and remove the file config.cache\n");
		printf("*** before re-running configure.\n");
		return 1;
	}
}
],, no_comprex=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
			CFLAGS="$ac_save_CFLAGS"
			LIBS="$ac_save_LIBS"
		fi
	fi
	if test "x$no_comprex" = x ; then
		AC_MSG_RESULT(yes)
		ifelse([$2], , :, [$2])
	else
		AC_MSG_RESULT(no)
		if test "$COMPREX_CONFIG" = "no" ; then
			echo "*** The comprex-config script installed by comprex could not be found"
			echo "*** If comprex was installed in PREFIX, make sure PREFIX/bin is in"
			echo "*** your path, or set the COMPREX_CONFIG environment variable to the "
			echo "*** full path to comprex-config."
		else
			if test -f conf.comprextest ; then
				:
			else
				echo "*** Could not run comprex test program, checking why..."
				CFLAGS="$CFLAGS $COMPREX_CFLAGS"
				LIBS="$LIBS $COMPREX_LIBS"
				AC_TRY_LINK([
#include <libcomprex/comprex.h>
#include <stdio.h>
],[
				return (($comprex_config_major_version) || ($comprex_config_minor_version) || ($comprex_config_micro_version));
],[
				echo "*** The test program compiled, but did not run. This usually means"
				echo "*** that the run-time linker is not finding comprex or finding the wrong"
				echo "*** version of comprex. If it is not finding comprex, you'll need to set your"
				echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
				echo "*** to the installed location. Also, make sure you have run ldconfig, if that"
				echo "*** is required on your system."
				echo "***"
				echo "*** If you have an old version installed, it is best to remove it, although"
				echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH."
				])
				CFLAGS="$ac_save_CFLAGS"
				LIBS="$ac_save_LIBS"
			fi
		fi
		COMPREX_CFLAGS=""
		COMPREX_LIBS=""
		ifelse([$3], , :, [$3])
	fi
	AC_SUBST(COMPREX_CFLAGS)
	AC_SUBST(COMPREX_LIBS)
	rm -f conf.comprextest
])
