/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.ConstantMemoryDownsamplingIterator;
import htsjdk.samtools.HighAccuracyDownsamplingIterator;
import htsjdk.samtools.SAMRecord;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class ChainedDownsamplingIterator
extends HighAccuracyDownsamplingIterator {
    public static final int MIN_ACCURATE_INPUT_READS = 50000;

    ChainedDownsamplingIterator(Iterator<SAMRecord> iterator, double proportion, int seed) {
        super(new ConstantMemoryDownsamplingIterator(iterator, ChainedDownsamplingIterator.adjustProportion(proportion), seed), proportion, seed);
        long discarded = ((ConstantMemoryDownsamplingIterator)this.getUnderlyingIterator()).getDiscardedCount();
        this.recordDiscardRecords(discarded);
    }

    private static double adjustProportion(double p) {
        double ciAdjustment99_9 = 3.3 * Math.sqrt(p / 50000.0);
        return Math.min(1.0, p + ciAdjustment99_9);
    }

    @Override
    protected void readFromUnderlyingIterator(List<SAMRecord> recs, Set<String> names, int templatesToRead) {
        ((ConstantMemoryDownsamplingIterator)this.getUnderlyingIterator()).resetStatistics();
        super.readFromUnderlyingIterator(recs, names, templatesToRead);
    }

    @Override
    protected int calculateTemplatesToKeep(int templatesRead, double overallProportion) {
        ConstantMemoryDownsamplingIterator iter = (ConstantMemoryDownsamplingIterator)this.getUnderlyingIterator();
        double priorProportion = iter.getAcceptedFraction();
        double p = Math.max(0.0, Math.min(1.0, overallProportion / priorProportion));
        int retval = super.calculateTemplatesToKeep(templatesRead, p);
        this.recordDiscardRecords(iter.getDiscardedCount());
        return retval;
    }
}

