/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.samtools.cram.compression.rans.ArithmeticDecoder;
import htsjdk.samtools.cram.compression.rans.D04;
import htsjdk.samtools.cram.compression.rans.D14;
import htsjdk.samtools.cram.compression.rans.E04;
import htsjdk.samtools.cram.compression.rans.E14;
import htsjdk.samtools.cram.compression.rans.Frequencies;
import htsjdk.samtools.cram.compression.rans.RANSDecodingSymbol;
import htsjdk.samtools.cram.compression.rans.RANSEncodingSymbol;
import htsjdk.utils.ValidationUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class RANS {
    private static final int ORDER_BYTE_LENGTH = 1;
    private static final int COMPRESSED_BYTE_LENGTH = 4;
    private static final int RAW_BYTE_LENGTH = 4;
    private static final int PREFIX_BYTE_LENGTH = 9;
    private static final int MINIMUM__ORDER_1_SIZE = 4;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    public static final int NUMBER_OF_SYMBOLS = 256;
    private ArithmeticDecoder[] D;
    private RANSDecodingSymbol[][] decodingSymbols;
    private RANSEncodingSymbol[][] encodingSymbols;

    private void initializeRANSCoder() {
        int j;
        int i;
        if (this.D == null) {
            this.D = new ArithmeticDecoder[256];
            for (i = 0; i < 256; ++i) {
                this.D[i] = new ArithmeticDecoder();
            }
        } else {
            for (i = 0; i < 256; ++i) {
                this.D[i].reset();
            }
        }
        if (this.decodingSymbols == null) {
            this.decodingSymbols = new RANSDecodingSymbol[256][256];
            for (i = 0; i < this.decodingSymbols.length; ++i) {
                for (j = 0; j < this.decodingSymbols[i].length; ++j) {
                    this.decodingSymbols[i][j] = new RANSDecodingSymbol();
                }
            }
        } else {
            for (i = 0; i < this.decodingSymbols.length; ++i) {
                for (j = 0; j < this.decodingSymbols[i].length; ++j) {
                    this.decodingSymbols[i][j].set(0, 0);
                }
            }
        }
        if (this.encodingSymbols == null) {
            this.encodingSymbols = new RANSEncodingSymbol[256][256];
            for (i = 0; i < this.encodingSymbols.length; ++i) {
                for (j = 0; j < this.encodingSymbols[i].length; ++j) {
                    this.encodingSymbols[i][j] = new RANSEncodingSymbol();
                }
            }
        } else {
            for (i = 0; i < this.encodingSymbols.length; ++i) {
                for (j = 0; j < this.encodingSymbols[i].length; ++j) {
                    this.encodingSymbols[i][j].reset();
                }
            }
        }
    }

    public ByteBuffer uncompress(ByteBuffer inBuffer) {
        if (inBuffer.remaining() == 0) {
            return EMPTY_BUFFER;
        }
        this.initializeRANSCoder();
        ORDER order = ORDER.fromInt(inBuffer.get());
        inBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int inSize = inBuffer.getInt();
        if (inSize != inBuffer.remaining() - 4) {
            throw new RuntimeException("Incorrect input length.");
        }
        int outSize = inBuffer.getInt();
        ByteBuffer outBuffer = ByteBuffer.allocate(outSize);
        switch (order) {
            case ZERO: {
                return this.uncompressOrder0Way4(inBuffer, outBuffer);
            }
            case ONE: {
                return this.uncompressOrder1Way4(inBuffer, outBuffer);
            }
        }
        throw new RuntimeException("Unknown rANS order: " + (Object)((Object)order));
    }

    public ByteBuffer compress(ByteBuffer inBuffer, ORDER order) {
        if (inBuffer.remaining() == 0) {
            return EMPTY_BUFFER;
        }
        this.initializeRANSCoder();
        if (inBuffer.remaining() < 4) {
            return this.compressOrder0Way4(inBuffer);
        }
        switch (order) {
            case ZERO: {
                return this.compressOrder0Way4(inBuffer);
            }
            case ONE: {
                return this.compressOrder1Way4(inBuffer);
            }
        }
        throw new RuntimeException("Unknown rANS order: " + (Object)((Object)order));
    }

    private ByteBuffer compressOrder0Way4(ByteBuffer inBuffer) {
        int inSize = inBuffer.remaining();
        ByteBuffer outBuffer = RANS.allocateOutputBuffer(inSize);
        outBuffer.position(9);
        int[] F = Frequencies.calcFrequenciesOrder0(inBuffer);
        Frequencies.buildSymsOrder0(F, this.encodingSymbols[0]);
        ByteBuffer cp = outBuffer.slice();
        int frequencyTableSize = Frequencies.writeFrequenciesOrder0(cp, F);
        inBuffer.rewind();
        int compressedBlobSize = E04.compress(inBuffer, this.encodingSymbols[0], cp);
        RANS.writeCompressionPrefix(ORDER.ZERO, outBuffer, inSize, frequencyTableSize, compressedBlobSize);
        return outBuffer;
    }

    private ByteBuffer compressOrder1Way4(ByteBuffer inBuffer) {
        int inSize = inBuffer.remaining();
        ByteBuffer outBuffer = RANS.allocateOutputBuffer(inSize);
        outBuffer.position(9);
        int[][] F = Frequencies.calcFrequenciesOrder1(inBuffer);
        Frequencies.buildSymsOrder1(F, this.encodingSymbols);
        ByteBuffer cp = outBuffer.slice();
        int frequencyTableSize = Frequencies.writeFrequenciesOrder1(cp, F);
        inBuffer.rewind();
        int compressedBlobSize = E14.compress(inBuffer, this.encodingSymbols, cp);
        RANS.writeCompressionPrefix(ORDER.ONE, outBuffer, inSize, frequencyTableSize, compressedBlobSize);
        return outBuffer;
    }

    private ByteBuffer uncompressOrder0Way4(ByteBuffer inBuffer, ByteBuffer outBuffer) {
        Frequencies.readStatsOrder0(inBuffer, this.D[0], this.decodingSymbols[0]);
        D04.uncompress(inBuffer, this.D[0], this.decodingSymbols[0], outBuffer);
        return outBuffer;
    }

    private ByteBuffer uncompressOrder1Way4(ByteBuffer in, ByteBuffer outBuffer) {
        Frequencies.readStatsOrder1(in, this.D, this.decodingSymbols);
        D14.uncompress(in, outBuffer, this.D, this.decodingSymbols);
        return outBuffer;
    }

    private static ByteBuffer allocateOutputBuffer(int inSize) {
        int compressedSize = (int)(1.05 * (double)inSize + 198147.0 + 9.0);
        ByteBuffer outputBuffer = ByteBuffer.allocate(compressedSize);
        if (outputBuffer.remaining() < compressedSize) {
            throw new RuntimeException("Failed to allocate sufficient buffer size for RANS coder.");
        }
        outputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return outputBuffer;
    }

    private static void writeCompressionPrefix(ORDER order, ByteBuffer outBuffer, int inSize, int frequencyTableSize, int compressedBlobSize) {
        ValidationUtils.validateArg(order == ORDER.ONE || order == ORDER.ZERO, "unrecognized RANS order");
        outBuffer.limit(9 + frequencyTableSize + compressedBlobSize);
        outBuffer.put(0, (byte)(order != ORDER.ZERO ? 1 : 0));
        outBuffer.order(ByteOrder.LITTLE_ENDIAN);
        outBuffer.putInt(1, frequencyTableSize + compressedBlobSize);
        outBuffer.putInt(5, inSize);
        outBuffer.rewind();
    }

    public static enum ORDER {
        ZERO,
        ONE;


        public static ORDER fromInt(int orderValue) {
            try {
                return ORDER.values()[orderValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unknown rANS order: " + orderValue);
            }
        }
    }
}

